/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.visuals.ParameterTreeNode;
import com.sas.wadmin.visuals.ParametersSelectorTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ParametersSelectorPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ParametersSelectorPanel.class);
    private cTreeListSelector m_TreeListSelector;
    private int m_minSelectionCount;
    private boolean m_bReturnExistingObjects;
    private List m_lSelectedObjects;
    private boolean m_bDoDataExchanged;
    private ParametersSelectorTreeModel m_mdlTree;
    private Job m_mdJob;
    private ParameterComparator m_cmpParameterComparator;

    public ParametersSelectorPanel(Job mdJob) {
        this.m_mdJob = mdJob;
        this.setHelpProduct("wdb");
        this.setHelpTopic("import_parameters_win");
        this.initialize();
    }

    protected void initialize() {
        this.m_TreeListSelector = new cTreeListSelector();
        this.m_cmpParameterComparator = new ParameterComparator();
        this.m_mdlTree = new ParametersSelectorTreeModel(this.m_mdJob);
        this.m_mdlTree.addListenersToTree((JTree)this.m_TreeListSelector.getSourceComponent());
        this.m_TreeListSelector.setModel(this.m_mdlTree);
        this.m_TreeListSelector.setCopyModeEnabled(true);
        this.m_TreeListSelector.setCopyModeDuplicatesAllowed(false);
        this.m_TreeListSelector.setTransferAllControlsVisible(false);
        this.m_TreeListSelector.setDragAndDropEnabled(false);
        this.m_TreeListSelector.setParentNodesMoveable(false);
        this.m_TreeListSelector.setFilter(new DefaultFilter(this.m_cmpParameterComparator));
        this.m_TreeListSelector.setSourceCellRenderer((TreeCellRenderer)new WsDefaultTreeCellRenderer());
        this.m_TreeListSelector.setTargetCellRenderer(new cListCellRenderer());
        this.m_TreeListSelector.getTargetModel().addListDataListener(new cTargetListListener());
        this.setSourceAndTargetLabels();
        this.setMaxSelectionCount(Integer.MAX_VALUE);
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_TreeListSelector), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setSourceAndTargetLabels() {
        this.setTreeLabel(bundle.getString("ParametersSelectorPanel.AvailableParameters.txt"), bundle.getString("ParametersSelectorPanel.AvailableParameters.mnem").charAt(0));
        this.setListLabel(bundle.getString("ParametersSelectorPanel.SelectedParameters.txt"), bundle.getString("ParametersSelectorPanel.SelectedParameters.mnem").charAt(0));
    }

    public void setListLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_TreeListSelector.getTargetLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setTreeLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_TreeListSelector.getSourceLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        this.m_TreeListSelector.setTargetMaximumCount(maxSelectionCount);
        this.m_TreeListSelector.setTargetControlsVisible(maxSelectionCount != 1);
    }

    public int getMaxSelectionCount() {
        return this.m_TreeListSelector.getTargetMaximumCount();
    }

    public void setMinSelectionCount(int minSelectionCount) {
        if (minSelectionCount > this.getMaxSelectionCount()) {
            throw new IllegalArgumentException("Minimum selection count is greater than maximum selection count.");
        }
        this.m_minSelectionCount = minSelectionCount;
    }

    public int getMinSelectionCount() {
        return this.m_minSelectionCount;
    }

    public Filter getFilter() {
        return this.m_TreeListSelector.getFilter();
    }

    public void setSelectedObjects(List lSelectedObjects) {
        this.m_lSelectedObjects = lSelectedObjects;
    }

    public List getSelectedObjects() {
        return this.m_lSelectedObjects;
    }

    public void setTreeModelComparator(Comparator cmp) {
        this.m_mdlTree.setComparator(cmp);
    }

    public Comparator getTreeModelComparator() {
        return this.m_mdlTree.getComparator();
    }

    public Comparator getParameterComparator() {
        return this.m_cmpParameterComparator;
    }

    public void setEditable(boolean bEditable) {
        this.m_TreeListSelector.setEnabled(bEditable);
    }

    public boolean validateData() {
        ListModel mdlTarget = this.m_TreeListSelector.getTargetModel();
        if (mdlTarget.getSize() < this.m_minSelectionCount) {
            String sMessage = bundle.formatString("ObjectsSelectorPanel.NotEnoughError.fmt.txt", (Object)"Parameters");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return false;
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlTree.expandRootNode();
        if (this.m_lSelectedObjects == null) {
            return;
        }
        this.setListeningForChanges(false);
        try {
            JTree tree = (JTree)this.m_TreeListSelector.getSourceComponent();
            tree.clearSelection();
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_lSelectedObjects != null && !this.m_bReturnExistingObjects) {
            for (int iObject = 0; iObject < this.m_lSelectedObjects.size(); ++iObject) {
                Root oObject = (Root)this.m_lSelectedObjects.get(iObject);
                oObject.delete();
            }
            this.m_lSelectedObjects.clear();
        } else {
            this.m_lSelectedObjects = new ArrayList();
        }
        ListModel mdlTarget = this.m_TreeListSelector.getTargetModel();
        for (int iSelected = 0; iSelected < mdlTarget.getSize(); ++iSelected) {
            TreePath pathSelected = (TreePath)mdlTarget.getElementAt(iSelected);
            ParameterTreeNode nodeSelected = (ParameterTreeNode)((Object)pathSelected.getLastPathComponent());
            PromptDefinitionInterface oSelected = nodeSelected.getDataObject();
            this.m_lSelectedObjects.add(oSelected);
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            if (!this.m_bDoDataExchanged) {
                this.m_bDoDataExchanged = true;
                this.moveDataToView();
                this.populateStore();
            }
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    protected class cTargetListListener
    implements ListDataListener {
        protected cTargetListListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (ParametersSelectorPanel.this.isListeningForChanges()) {
                ParametersSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (ParametersSelectorPanel.this.isListeningForChanges()) {
                ParametersSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (ParametersSelectorPanel.this.isListeningForChanges()) {
                ParametersSelectorPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cTreeListSelector
    extends TreeListSelector {
        private Filter m_filter;

        protected cTreeListSelector() {
        }

        public void setFilter(Filter filter) {
            this.m_filter = filter;
        }

        public Filter getFilter() {
            return this.m_filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            if (this.m_filter != null) {
                                this.m_filter.filter(lItems, toAdapter.getAllItems());
                            }
                            List lTargets = toAdapter.getAllItems();
                            if (lItems.size() + lTargets.size() > ParametersSelectorPanel.this.m_TreeListSelector.getTargetMaximumCount()) {
                                String sTypes = bundle.getString("ParametersSelectorPanel.TypeName.txt");
                                String sMessage = bundle.formatString("ParametersSelectorPanel.TooManyTypesWouldBeSelected.fmt.txt", (Object)sTypes);
                                MessageUtil.displayMessage((String)sMessage, (int)0);
                                lItems.clear();
                            }
                            if (lItems.size() > 0) {
                                if (!this.copyModeEnabled) {
                                    fromAdapter.removeItems(lItems);
                                }
                                toAdapter.addItems(lItems);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            if (!this.copyModeEnabled) {
                                toAdapter.addItems(lItems);
                            }
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }
    }

    public static class ParameterComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            PromptDefinitionInterface t1 = (PromptDefinitionInterface)o1;
            PromptDefinitionInterface t2 = (PromptDefinitionInterface)o2;
            return t1.getPromptName().compareToIgnoreCase(t2.getPromptName());
        }
    }

    public static class DefaultFilter
    implements Filter {
        private Comparator m_aComparator;
        private boolean m_bShowMessages;

        public DefaultFilter(Comparator cmp) {
            this.m_aComparator = cmp;
            this.m_bShowMessages = true;
        }

        @Override
        public void setShowingMessages(boolean bShowMessages) {
            this.m_bShowMessages = bShowMessages;
        }

        public boolean isShowingMessages() {
            return this.m_bShowMessages;
        }

        @Override
        public void filter(List lSources, List lTargets) {
            this.filterType(lSources, lTargets, this.m_aComparator);
            this.filterDuplicates(lSources, lTargets, this.m_aComparator);
        }

        protected void filterType(List lSources, List lTargets, Comparator comparator) {
            for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                TreePath pathSource = (TreePath)lSources.get(iSource);
                WsTreeNode nodeSource = (WsTreeNode)pathSource.getLastPathComponent();
                if (nodeSource instanceof ParameterTreeNode) continue;
                this.displayTypesErrorMessage();
                lSources.clear();
                break;
            }
        }

        protected void displayTypesErrorMessage() {
            if (this.m_bShowMessages) {
                String sType = bundle.getString("ParametersSelectorPanel.TypeName.txt");
                String sMessage = bundle.formatString("ParametersSelectorPanel.OnlyTypesMayBeSelectedError.fmt.txt", (Object)sType);
                MessageUtil.displayMessage((String)sMessage, (int)0);
            }
        }

        protected void filterDuplicates(List lSources, List lTargets, Comparator comparator) {
            ArrayList<String> lDuplicates = new ArrayList<String>();
            for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                TreePath pathSource = (TreePath)lSources.get(iSource);
                WsTreeNode nodeSource = (WsTreeNode)pathSource.getLastPathComponent();
                PromptDefinitionInterface oSource = ((ParameterTreeNode)nodeSource).getDataObject();
                boolean bAddSourceToTarget = true;
                for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                    TreePath pathTarget = (TreePath)lTargets.get(iTarget);
                    ParameterTreeNode nodeTarget = (ParameterTreeNode)((Object)pathTarget.getLastPathComponent());
                    PromptDefinitionInterface oTarget = nodeTarget.getDataObject();
                    if (!oSource.equals(oTarget)) continue;
                    lDuplicates.add(nodeSource.toString());
                    lSources.remove(iSource--);
                    bAddSourceToTarget = false;
                    break;
                }
                if (!bAddSourceToTarget) continue;
                lTargets.add(pathSource);
            }
            if (lDuplicates.size() > 0 && this.m_bShowMessages) {
                MessageUtil.displayListMessage((String)bundle.getString("ParametersSelectorPanel.DuplicatesError.txt"), lDuplicates, (int)0);
            }
        }
    }

    public static interface Filter {
        public void filter(List var1, List var2);

        public void setShowingMessages(boolean var1);
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof TreePath) {
                TreePath pathValue = (TreePath)value;
                WsTreeNode nodeValue = (WsTreeNode)pathValue.getLastPathComponent();
                this.setIcon(nodeValue.getIcon(false));
                this.setText(nodeValue.toString());
            }
            return this;
        }
    }
}

