/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ParametersInterface;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ParametersModel
implements ParametersInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(ParametersModel.class);
    private Root m_metadata;
    private PromptGroupInterface m_promptGroup;

    public ParametersModel() {
        this(null);
    }

    public ParametersModel(Root oMetadata) {
        this.setMetadata(oMetadata);
    }

    public boolean isParameterizedObject() throws MdException, RemoteException {
        return this.m_promptGroup != null && !this.m_promptGroup.getPromptDefinitions(true).isEmpty();
    }

    public boolean isGeneratedTransform() throws MdException, RemoteException {
        boolean generatedTransform = false;
        if (this.m_metadata instanceof TransformationStep) {
            TransformInterface tInterface = MacroPluginUtilities.getTransformInterfaceFromStep((TransformationStep)this.m_metadata);
            generatedTransform = tInterface instanceof MacroPlugin;
        }
        return generatedTransform;
    }

    public StringBuffer getParameterMacroCode() throws MdException, RemoteException {
        return this.getParameterMacroCode(null);
    }

    public StringBuffer getParameterMacroCode(ICodeSegment codeSegment) throws MdException, RemoteException {
        StringBuffer code = null;
        if (this.isParameterizedObject()) {
            SASCodeGeneration sascode = new SASCodeGeneration();
            String comment = sascode.makeComment(bundle.formatString("ParametersModel.ParameterMacroCode.ParameterDefaults.txt", (Object)this.m_metadata.getName()));
            BaseModel model = new BaseModel();
            OMRAdapter omr = new OMRAdapter((IModel)model, Workspace.getMdFactory(), "ParametersModel");
            try {
                IObject owner = (IObject)omr.acquireObjectUsingTemplate(this.getMetadata());
                BasePromptModel promptModel = new BasePromptModel((IModel)model, owner, this.m_promptGroup);
                code = new StringBuffer(comment);
                code.append(promptModel.getOptionsString(codeSegment, null, true, true, false, false));
            }
            catch (ServiceException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (ServerConnectionException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (BadServerDefinitionException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (CodegenException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (BadLibraryDefinitionException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            catch (ServerException e) {
                e.printStackTrace();
                throw new MdException((Throwable)e);
            }
            finally {
                omr.dispose();
                model.dispose();
            }
        }
        return code;
    }

    public List getParameterDefinitions() {
        ArrayList newList = new ArrayList();
        if (this.m_promptGroup != null) {
            newList.addAll(this.m_promptGroup.getPromptDefinitions(true));
        }
        return newList;
    }

    public Root getMetadata() {
        return this.m_metadata;
    }

    public void setMetadata(Root object) {
        if (this.m_metadata != object) {
            this.m_metadata = object;
            if (this.m_metadata != null) {
                Root parmObject = this.m_metadata;
                try {
                    Prototype proto;
                    if (this.m_metadata instanceof TransformationStep && !((TransformationStep)this.m_metadata).getTransformations().isEmpty() && ((TransformationStep)this.m_metadata).getTransformations().get(0) instanceof Job) {
                        parmObject = (Root)((TransformationStep)this.m_metadata).getTransformations().get(0);
                    } else if (this.isGeneratedTransform() && (proto = MacroPluginUtilities.getPrototypeForStep((TransformationStep)this.m_metadata)) != null) {
                        parmObject = proto;
                    }
                    this.m_promptGroup = PromptsPersistUtil.getPromptGroupFromOMRObject((Root)parmObject, (SessionContextInterface)Workspace.getWorkspace().getSessionContext());
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }
}

