/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.Pageable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsFlatButton;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneLayout;

public class PageScrollPane
extends JScrollPane {
    private static WAdminResource bundle = WAdminResource.getBundle(PageScrollPane.class);
    private Pageable m_Pageable;
    private WsFlatButton m_btnFirstPage;
    private WsFlatButton m_btnPreviousPage;
    private WsFlatButton m_btnNextPage;
    private WsFlatButton m_btnLastPage;
    private FirstPageAction m_firstPageAction;
    private PreviousPageAction m_previousPageAction;
    private NextPageAction m_nextPageAction;
    private LastPageAction m_lastPageAction;

    public PageScrollPane(Component view) {
        super(view);
        this.m_Pageable = (Pageable)((Object)view);
        this.initialize();
    }

    private void initialize() {
        this.m_firstPageAction = new FirstPageAction();
        this.m_nextPageAction = new NextPageAction();
        this.m_previousPageAction = new PreviousPageAction();
        this.m_lastPageAction = new LastPageAction();
        this.m_firstPageAction.setEnabled(false);
        this.m_previousPageAction.setEnabled(false);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(33, 10), "FirstPage");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(33, 8), "PageUp");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(34, 8), "PageDown");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(34, 10), "LastPage");
        this.getActionMap().put("FirstPage", (Action)((Object)this.m_previousPageAction));
        this.getActionMap().put("PageUp", (Action)((Object)this.m_previousPageAction));
        this.getActionMap().put("PageDown", (Action)((Object)this.m_nextPageAction));
        this.getActionMap().put("LastPage", (Action)((Object)this.m_nextPageAction));
        this.m_btnFirstPage = (WsFlatButton)WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_firstPageAction);
        this.m_btnPreviousPage = (WsFlatButton)WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_previousPageAction);
        this.m_btnNextPage = (WsFlatButton)WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_nextPageAction);
        this.m_btnLastPage = (WsFlatButton)WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_lastPageAction);
        this.m_btnFirstPage.setVisible(false);
        this.m_btnPreviousPage.setVisible(false);
        this.m_btnNextPage.setVisible(false);
        this.m_btnLastPage.setVisible(false);
        Box lowerRightCornerComp = new Box(3);
        lowerRightCornerComp.add((Component)this.m_btnFirstPage);
        lowerRightCornerComp.add((Component)this.m_btnPreviousPage);
        lowerRightCornerComp.add((Component)this.m_btnNextPage);
        lowerRightCornerComp.add((Component)this.m_btnLastPage);
        this.setCorner("LOWER_RIGHT_CORNER", lowerRightCornerComp);
        this.setLayout(new CustomScrollPaneLayout());
        this.m_Pageable.addPageChangeListener(new cPageChangeListener());
    }

    private void updateActions() {
        this.m_firstPageAction.setEnabled(!this.m_Pageable.isAtFirstPage());
        this.m_previousPageAction.setEnabled(!this.m_Pageable.isAtFirstPage());
        this.m_nextPageAction.setEnabled(!this.m_Pageable.isAtLastPage());
        this.m_lastPageAction.setEnabled(!this.m_Pageable.isAtLastPage());
    }

    private void updateButtonVisibility() {
        if (!this.m_Pageable.isAtFirstPage() || !this.m_Pageable.isAtLastPage()) {
            this.setVerticalScrollBarPolicy(22);
            this.m_btnFirstPage.setVisible(true);
            this.m_btnPreviousPage.setVisible(true);
            this.m_btnNextPage.setVisible(true);
            this.m_btnLastPage.setVisible(true);
        }
    }

    public void firstPage() {
        this.m_firstPageAction.actionPerformed(null);
    }

    public void previousPage() {
        this.m_previousPageAction.actionPerformed(null);
    }

    public void nextPage() {
        this.m_nextPageAction.actionPerformed(null);
    }

    public void lastPage() {
        this.m_lastPageAction.actionPerformed(null);
    }

    protected class cPageChangeListener
    implements PropertyChangeListener {
        protected cPageChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!e.getPropertyName().equals("PageNumber")) {
                return;
            }
            if (PageScrollPane.this.m_Pageable.getCurrentPageNumber() > 0) {
                PageScrollPane.this.updateActions();
                PageScrollPane.this.updateButtonVisibility();
                PageScrollPane.this.getVerticalScrollBar().setValue(0);
            }
        }
    }

    protected class LastPageAction
    extends WsAbstractAction {
        public LastPageAction() {
            super(bundle, "PageScrollPane.LastPage", 18);
        }

        public void actionPerformed(ActionEvent ae) {
            JInternalFrame frame = Workspace.getWorkspace().getDesktopWindowHandle().getSelectedFrame();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            PageScrollPane.this.m_Pageable.lastPage();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class NextPageAction
    extends WsAbstractAction {
        public NextPageAction() {
            super(bundle, "PageScrollPane.PageDown", 18);
        }

        public void actionPerformed(ActionEvent ae) {
            JInternalFrame frame = Workspace.getWorkspace().getDesktopWindowHandle().getSelectedFrame();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            PageScrollPane.this.m_Pageable.nextPage();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class PreviousPageAction
    extends WsAbstractAction {
        public PreviousPageAction() {
            super(bundle, "PageScrollPane.PageUp", 18);
        }

        public void actionPerformed(ActionEvent ae) {
            JInternalFrame frame = Workspace.getWorkspace().getDesktopWindowHandle().getSelectedFrame();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            PageScrollPane.this.m_Pageable.previousPage();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class FirstPageAction
    extends WsAbstractAction {
        public FirstPageAction() {
            super(bundle, "PageScrollPane.FirstPage", 18);
        }

        public void actionPerformed(ActionEvent ae) {
            JInternalFrame frame = Workspace.getWorkspace().getDesktopWindowHandle().getSelectedFrame();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            PageScrollPane.this.m_Pageable.firstPage();
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class CustomScrollPaneLayout
    extends ScrollPaneLayout {
        protected CustomScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            this.adjustForButtonsPanel();
        }

        private void adjustForButtonsPanel() {
            if (!PageScrollPane.this.m_btnPreviousPage.isVisible() || !PageScrollPane.this.m_btnNextPage.isVisible()) {
                return;
            }
            int heightAdjust = ((PageScrollPane)PageScrollPane.this).m_btnPreviousPage.getPreferredSize().height;
            int n = this.hsb.isVisible() ? 3 : 4;
            Rectangle vsbRect = this.vsb.getBounds();
            vsbRect.height -= (heightAdjust *= n);
            this.vsb.setBounds(vsbRect);
            Rectangle lowerRightRect = this.lowerRight.getBounds();
            lowerRightRect.y = vsbRect.y + vsbRect.height;
            lowerRightRect.height = lowerRightRect.height + heightAdjust + 2;
            this.lowerRight.setBounds(lowerRightRect);
        }
    }
}

