/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.visuals.ObjectsSelectorTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsDefaultTreeCellRenderer;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ObjectsSelectorPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ObjectsSelectorPanel.class);
    public static final int CUSTOM_TREE = 1;
    public static final int MINING_TREE = 2;
    public static final int ALL_TREES = 255;
    public static final int ALL_COLUMNS = 0;
    public static final int NUMERIC_COLUMNS = 1;
    public static final int CHARACTER_COLUMNS = 2;
    private WATextArea m_txtDescription;
    private JSeparator m_separator;
    private cTreeListSelector m_TreeListSelector;
    private JCheckBox m_ckbSortColumns;
    private String[] m_saSelectionTypes;
    private String m_sDescription;
    private MdObjectStore m_storeReturnedObjects;
    private int m_minSelectionCount;
    private boolean m_bReturnExistingObjects;
    private List m_lSelectedObjects;
    private String m_sDisplayPluralType;
    private boolean m_bExpandRepositoryNodes;
    private boolean m_bDoDataExchanged;
    private boolean m_bDeleteOldSelectedObjects = true;
    private MdObjectStore m_storeLocal;
    private ObjectsSelectorTreeModel m_mdlTree;

    public ObjectsSelectorPanel() {
        this("Column");
    }

    public ObjectsSelectorPanel(String sSelectionType) {
        this(sSelectionType, null);
    }

    public ObjectsSelectorPanel(String[] saSelectionTypes) {
        this(saSelectionTypes, null);
    }

    public ObjectsSelectorPanel(String sSelectionType, String sDescription) {
        this(new String[]{sSelectionType}, sDescription);
    }

    public ObjectsSelectorPanel(String[] saSelectionTypes, String sDescription) {
        this.m_saSelectionTypes = saSelectionTypes;
        this.m_sDescription = sDescription;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.m_storeLocal = Workspace.getWorkspace().getMdObjectFactory().createObjectStore(null, "ObjectsSelectorPanel");
            if (this.m_sDescription != null) {
                this.m_txtDescription = new WATextArea();
                this.m_txtDescription.setText(this.m_sDescription);
                this.m_txtDescription.setColumns(30);
                this.m_txtDescription.setBehavior(1);
                this.m_txtDescription.setAutosize(true);
                this.m_separator = new JSeparator(0);
            }
            if (this.isSelectionType("Column")) {
                this.m_ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ObjectsSelectorPanel.Checkbox.SortColumns");
                this.m_ckbSortColumns.addActionListener(new cSortColumnsListener());
            }
            this.m_TreeListSelector = new cTreeListSelector();
            this.m_mdlTree = new ObjectsSelectorTreeModel(this.m_storeLocal);
            this.m_mdlTree.addListenersToTree((JTree)this.m_TreeListSelector.getSourceComponent());
            this.m_TreeListSelector.setModel((TreeModel)((Object)this.m_mdlTree));
            this.m_TreeListSelector.setCopyModeEnabled(true);
            this.m_TreeListSelector.setCopyModeDuplicatesAllowed(false);
            this.m_TreeListSelector.setTransferAllControlsVisible(false);
            this.m_TreeListSelector.setDragAndDropEnabled(false);
            this.m_TreeListSelector.setParentNodesMoveable(false);
            if (this.m_saSelectionTypes != null) {
                Comparator[] aComparators = new Comparator[this.m_saSelectionTypes.length];
                for (int iType = 0; iType < this.m_saSelectionTypes.length; ++iType) {
                    aComparators[iType] = this.m_saSelectionTypes[iType].equals("Column") ? new ColumnComparator() : new RootComparator();
                }
                this.m_TreeListSelector.setFilter(new DefaultFilter(this.m_saSelectionTypes, aComparators));
            }
            this.m_TreeListSelector.setSourceCellRenderer((TreeCellRenderer)new WsDefaultTreeCellRenderer());
            this.m_TreeListSelector.setTargetCellRenderer(new cListCellRenderer());
            this.m_TreeListSelector.getTargetModel().addListDataListener(new cTargetListListener());
            this.setSourceAndTargetLabels();
            this.setMaxSelectionCount(Integer.MAX_VALUE);
            this.setReturnExistingObjects(true);
            this.setTypesToShow(new String[]{"PhysicalTable", "Column"});
            this.setPreferredSize(new Dimension(450, 300));
            this.setLayout(new GridBagLayout());
            if (this.m_sDescription != null) {
                this.add((Component)this.m_txtDescription, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.m_separator, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 0), 0, 0));
            }
            this.add((Component)((Object)this.m_TreeListSelector), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (this.isSelectionType("Column")) {
                this.add(this.m_ckbSortColumns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void setSourceAndTargetLabels() {
        if (this.isSelectionType("Column")) {
            this.setTreeLabel(bundle.getString("ObjectsSelectorPanel.AvailableColumns.txt"), bundle.getString("ObjectsSelectorPanel.AvailableColumns.mnem").charAt(0));
            this.setListLabel(bundle.getString("ObjectsSelectorPanel.SelectedColumns.txt"), bundle.getString("ObjectsSelectorPanel.SelectedColumns.mnem").charAt(0));
        } else if (this.isSelectionType("PhysicalTable")) {
            this.setTreeLabel(bundle.getString("ObjectsSelectorPanel.AvailableTables.txt"), bundle.getString("ObjectsSelectorPanel.AvailableTables.mnem").charAt(0));
            this.setListLabel(bundle.getString("ObjectsSelectorPanel.SelectedTables.txt"), bundle.getString("ObjectsSelectorPanel.SelectedTables.mnem").charAt(0));
        } else if (this.isSelectionType("MiningResult")) {
            this.setTreeLabel(bundle.getString("ObjectsSelectorPanel.AvailableTables.txt"), bundle.getString("ObjectsSelectorPanel.AvailableTables.mnem").charAt(0));
            this.setListLabel(bundle.getString("ObjectsSelectorPanel.SelectedTables.txt"), bundle.getString("ObjectsSelectorPanel.SelectedTables.mnem").charAt(0));
        } else if (this.isSelectionType("ExternalTable")) {
            this.setTreeLabel(bundle.getString("ObjectsSelectorPanel.AvailableTables.txt"), bundle.getString("ObjectsSelectorPanel.AvailableTables.mnem").charAt(0));
            this.setListLabel(bundle.getString("ObjectsSelectorPanel.SelectedTables.txt"), bundle.getString("ObjectsSelectorPanel.SelectedTables.mnem").charAt(0));
        } else {
            this.setTreeLabel(bundle.getString("ObjectsSelectorPanel.AvailableColumns.txt"), bundle.getString("ObjectsSelectorPanel.AvailableColumns.mnem").charAt(0));
            this.setListLabel(bundle.getString("ObjectsSelectorPanel.SelectedColumns.txt"), bundle.getString("ObjectsSelectorPanel.SelectedColumns.mnem").charAt(0));
        }
    }

    private boolean isSelectionType(String sType) {
        if (this.m_saSelectionTypes == null) {
            return false;
        }
        return this.m_saSelectionTypes.length == 1 && this.m_saSelectionTypes[0].equals(sType);
    }

    public void setRepositoriesToShow(List lRepositories) {
        this.m_mdlTree.setRepositories(lRepositories);
    }

    public List getRepositoriesToShow() {
        return this.m_mdlTree.getRepositories();
    }

    public void addInventoryNodes(String[] title, String[] saType) {
        this.m_mdlTree.addInventoryNodes(title, saType);
    }

    public void addInventoryNode(String title, String saType) {
        this.addInventoryNodes(new String[]{title}, new String[]{saType});
    }

    public void setExpandRepositoryNodes(boolean bExpandRepositoryNodes) {
        this.m_bExpandRepositoryNodes = bExpandRepositoryNodes;
    }

    public boolean isExpandRepositoryNodes() {
        return this.m_bExpandRepositoryNodes;
    }

    public void setDeleteOldSelectedObjects(boolean bDeleteOldSelectedObjects) {
        this.m_bDeleteOldSelectedObjects = bDeleteOldSelectedObjects;
    }

    public boolean isDeletedOldSelectedObjects() {
        return this.m_bDeleteOldSelectedObjects;
    }

    public void setListLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_TreeListSelector.getTargetLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setTreeLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_TreeListSelector.getSourceLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setTargetControlsVisible(boolean bVisible) {
        this.m_TreeListSelector.setTargetControlsVisible(bVisible);
    }

    public boolean isTargetControlsVisible() {
        return this.m_TreeListSelector.isTargetControlsVisible();
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        this.m_TreeListSelector.setTargetMaximumCount(maxSelectionCount);
        this.m_TreeListSelector.setTargetControlsVisible(maxSelectionCount != 1);
    }

    public int getMaxSelectionCount() {
        return this.m_TreeListSelector.getTargetMaximumCount();
    }

    public void setMinSelectionCount(int minSelectionCount) {
        if (minSelectionCount > this.getMaxSelectionCount()) {
            throw new IllegalArgumentException("Minimum selection count is greater than maximum selection count.");
        }
        this.m_minSelectionCount = minSelectionCount;
    }

    public int getMinSelectionCount() {
        return this.m_minSelectionCount;
    }

    public void setFilter(Filter filter) {
        this.m_TreeListSelector.setFilter(filter);
        if (filter instanceof DefaultFilter) {
            ((DefaultFilter)filter).setPluralDisplayType(this.m_sDisplayPluralType);
        }
    }

    public Filter getFilter() {
        return this.m_TreeListSelector.getFilter();
    }

    public void setTreesToShow(int eTree) {
        this.m_mdlTree.setTreesToShow(eTree);
    }

    public int getTreesToShow() {
        return this.m_mdlTree.getTreesToShow();
    }

    public void setTypesToShow(String[] saTypes) {
        this.m_mdlTree.setTypesToShow(saTypes);
        this.setExpandTypesForBackwardsCompatibility(saTypes);
    }

    private void setExpandTypesForBackwardsCompatibility(String[] saTypes) {
        if (saTypes == null) {
            this.m_mdlTree.setTypesToExpand(new String[0]);
            return;
        }
        boolean bColumn = false;
        boolean bRelationalTable = false;
        for (int iType = 0; iType < saTypes.length; ++iType) {
            if (saTypes[iType].equals("Column")) {
                bColumn = true;
                continue;
            }
            if (!saTypes[iType].equals("RelationalTable")) continue;
            bRelationalTable = true;
        }
        ArrayList<String> lExpandTypes = new ArrayList<String>();
        for (int iType = 0; iType < saTypes.length; ++iType) {
            if (bColumn && (saTypes[iType].equals("PhysicalTable") || saTypes[iType].equals("ExternalTable") || saTypes[iType].equals("RelationalTable"))) {
                lExpandTypes.add(saTypes[iType]);
            }
            if (!bRelationalTable || !saTypes[iType].equals("MiningResult")) continue;
            lExpandTypes.add(saTypes[iType]);
        }
        String[] saExpandTypes = new String[lExpandTypes.size()];
        lExpandTypes.toArray(saExpandTypes);
        this.m_mdlTree.setTypesToExpand(saExpandTypes);
    }

    public String[] getTypesToShow() {
        return this.m_mdlTree.getTypesToShow();
    }

    public void setTypesToExpand(String[] saTypes) {
        this.m_mdlTree.setTypesToExpand(saTypes);
    }

    public String[] getTypesToExpand() {
        return this.m_mdlTree.getTypesToExpand();
    }

    public void setColumnTypeToShow(int eType) {
        this.m_mdlTree.setColumnTypeToShow(eType);
    }

    public int getColumnTypeToShow() {
        return this.m_mdlTree.getColumnTypeToShow();
    }

    public void setReturnExistingObjects(boolean bExisting) {
        this.m_bReturnExistingObjects = bExisting;
    }

    public boolean isReturnExistingObjects() {
        return this.m_bReturnExistingObjects;
    }

    public void setReturnedObjectsStore(MdObjectStore store) {
        this.m_storeReturnedObjects = store;
    }

    public MdObjectStore getReturnedObjectsStore() {
        return this.m_storeReturnedObjects;
    }

    public void setSelectedObjects(List lSelectedObjects) {
        this.m_lSelectedObjects = lSelectedObjects;
    }

    public List getSelectedObjects() {
        return this.m_lSelectedObjects;
    }

    public void setTreeModelComparator(Comparator cmp) {
        this.m_mdlTree.setComparator(cmp);
    }

    public Comparator getTreeModelComparator() {
        return this.m_mdlTree.getComparator();
    }

    public void setErrorMessagePluralType(String sPluralType) {
        this.m_sDisplayPluralType = sPluralType;
        Filter filter = this.getFilter();
        if (filter instanceof DefaultFilter) {
            ((DefaultFilter)filter).setPluralDisplayType(sPluralType);
        }
    }

    public String getErrorMessagePluralType() {
        return this.m_sDisplayPluralType;
    }

    public void setEditable(boolean bEditable) {
        this.m_TreeListSelector.setEnabled(bEditable);
    }

    public boolean validateData() {
        ListModel mdlTarget = this.m_TreeListSelector.getTargetModel();
        if (mdlTarget.getSize() < this.m_minSelectionCount) {
            String sType = this.m_sDisplayPluralType;
            if (sType == null && this.m_saSelectionTypes != null) {
                sType = this.m_saSelectionTypes[0];
            }
            String sMessage = bundle.formatString("ObjectsSelectorPanel.NotEnoughError.fmt.txt", (Object)sType);
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return false;
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToView() throws MdException, RemoteException {
        JTree tree = (JTree)this.m_TreeListSelector.getSourceComponent();
        WsTreeNode node = (WsTreeNode)this.m_mdlTree.getRoot();
        TreePath path = new TreePath(node);
        tree.collapsePath(path);
        tree.expandPath(path);
        if (this.m_bExpandRepositoryNodes) {
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                tree.expandPath(path.pathByAddingChild(node.getChildAt(iChild)));
            }
            if (node.getChildCount() > 0 && (node = (WsTreeNode)node.getChildAt(0)).getChildCount() > 0) {
                node = (WsTreeNode)node.getChildAt(0);
            }
            tree.setSelectionPath(new TreePath(node.getPath()));
        }
        if (this.m_lSelectedObjects == null) {
            return;
        }
        this.setListeningForChanges(false);
        try {
            DefaultListModel mdlList = (DefaultListModel)this.m_TreeListSelector.getTargetModel();
            tree.clearSelection();
            for (int iObject = 0; iObject < this.m_lSelectedObjects.size(); ++iObject) {
                Root oCopy = this.copyObject((Root)this.m_lSelectedObjects.get(iObject), this.m_storeLocal, true);
                node = this.m_mdlTree.find(oCopy);
                if (node != null) {
                    path = new TreePath(node.getPath());
                    tree.addSelectionPath(path);
                    tree.scrollPathToVisible(path);
                    mdlList.addElement(path);
                    continue;
                }
                mdlList.addElement(new TreePath(this.m_mdlTree.getNodeFactory().createObjectNode(oCopy, (WsTreeNode)this.m_mdlTree.getRoot())));
            }
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_lSelectedObjects != null && !this.m_bReturnExistingObjects) {
            if (this.m_bDeleteOldSelectedObjects) {
                for (int iObject = 0; iObject < this.m_lSelectedObjects.size(); ++iObject) {
                    Root oObject = (Root)this.m_lSelectedObjects.get(iObject);
                    oObject.delete();
                }
            }
            this.m_lSelectedObjects.clear();
        } else {
            this.m_lSelectedObjects = new ArrayList();
        }
        ListModel mdlTarget = this.m_TreeListSelector.getTargetModel();
        for (int iSelected = 0; iSelected < mdlTarget.getSize(); ++iSelected) {
            TreePath pathSelected = (TreePath)mdlTarget.getElementAt(iSelected);
            WsDataTreeNode nodeSelected = (WsDataTreeNode)pathSelected.getLastPathComponent();
            Root oSelected = (Root)nodeSelected.getMetadata();
            this.m_lSelectedObjects.add(this.copyObject(oSelected, this.m_storeReturnedObjects, this.m_bReturnExistingObjects));
        }
    }

    protected Root copyObject(Root oObject, MdObjectStore store, boolean bExisting) throws MdException, RemoteException {
        Workspace workspace = Workspace.getWorkspace();
        MdFactory factory = workspace.getMdObjectFactory();
        String sName = oObject.getName();
        String sType = oObject.getCMetadataType();
        String sFQID = bExisting ? oObject.getFQID() : workspace.getDefaultRepository().getFQID().substring(9, 17);
        int fState = bExisting ? 2 : 1;
        Root oReturn = (Root)factory.createComplexMetadataObject(store, sName, sType, sFQID);
        MdStoreUtil.copyObjectAttributes((CMetadata)oObject, (CMetadata)oReturn, (int)fState);
        if (sType.equals("Column") && bExisting) {
            DataTable oTable = ((Column)oObject).getTable();
            DataTable oReturnTable = (DataTable)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oTable);
            MdStoreUtil.copyObjectAttributes((CMetadata)oTable, (CMetadata)oReturnTable, (int)fState);
            ((Column)oReturn).setTable(oReturnTable);
        }
        return oReturn;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            if (!this.m_bDoDataExchanged) {
                this.m_bDoDataExchanged = true;
                this.moveDataToView();
                this.populateStore();
            }
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    public void saveSettingsAndCleanUp() {
        try {
            this.m_storeLocal.dispose();
            Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected class cSortColumnsListener
    implements ActionListener {
        protected cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectsSelectorPanel.this.m_mdlTree.setSortColumns(ObjectsSelectorPanel.this.m_ckbSortColumns.isSelected());
        }
    }

    protected class cTargetListListener
    implements ListDataListener {
        protected cTargetListListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cTreeListSelector
    extends TreeListSelector {
        private Filter m_filter;

        protected cTreeListSelector() {
        }

        public void setFilter(Filter filter) {
            this.m_filter = filter;
        }

        public Filter getFilter() {
            return this.m_filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            if (this.m_filter != null) {
                                this.m_filter.filter(lItems, toAdapter.getAllItems());
                            }
                            List lTargets = toAdapter.getAllItems();
                            if (lItems.size() + lTargets.size() > ObjectsSelectorPanel.this.m_TreeListSelector.getTargetMaximumCount()) {
                                String sTypes = ObjectsSelectorPanel.this.m_sDisplayPluralType;
                                if (sTypes == null && ObjectsSelectorPanel.this.m_saSelectionTypes != null) {
                                    sTypes = ObjectsSelectorPanel.this.m_saSelectionTypes[0];
                                }
                                String sMessage = bundle.formatString("ObjectsSelectorPanel.TooManyTypesWouldBeSelected.fmt.txt", (Object)sTypes);
                                MessageUtil.displayMessage((String)sMessage, (int)0);
                                lItems.clear();
                            }
                            if (lItems.size() > 0) {
                                if (!this.copyModeEnabled) {
                                    fromAdapter.removeItems(lItems);
                                }
                                toAdapter.addItems(lItems);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            if (!this.copyModeEnabled) {
                                toAdapter.addItems(lItems);
                            }
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }
    }

    public static class PhysicalTableComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                PhysicalTable t1 = (PhysicalTable)o1;
                PhysicalTable t2 = (PhysicalTable)o2;
                return t1.getSASTableName().compareToIgnoreCase(t2.getSASTableName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return Integer.MIN_VALUE;
            }
        }
    }

    public static class ColumnComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                Column c1 = (Column)o1;
                Column c2 = (Column)o2;
                return c1.getSASColumnName().compareToIgnoreCase(c2.getSASColumnName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return Integer.MIN_VALUE;
            }
        }
    }

    public static class RootComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                Root r1 = (Root)o1;
                Root r2 = (Root)o2;
                return r1.getName().compareToIgnoreCase(r2.getName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return Integer.MIN_VALUE;
            }
        }
    }

    public static class DefaultFilter
    implements Filter {
        private String m_sPluralDisplayType;
        private String[] m_saSelectionTypes;
        private Comparator[] m_aComparators;
        private boolean m_bShowMessages;

        public DefaultFilter(String sSelectionType, Comparator cmp) {
            this(new String[]{sSelectionType}, new Comparator[]{cmp});
        }

        public DefaultFilter(String[] saSelectionTypes, Comparator[] aComparators) {
            this.m_saSelectionTypes = saSelectionTypes;
            this.m_aComparators = aComparators;
            this.m_bShowMessages = true;
        }

        @Override
        public void setShowingMessages(boolean bShowMessages) {
            this.m_bShowMessages = bShowMessages;
        }

        public boolean isShowingMessages() {
            return this.m_bShowMessages;
        }

        public void setPluralDisplayType(String sPluralType) {
            this.m_sPluralDisplayType = sPluralType;
        }

        @Override
        public void filter(List lSources, List lTargets) {
            ArrayList lComparators = new ArrayList(lSources.size());
            this.filterType(lSources, lTargets, lComparators);
            this.filterDuplicates(lSources, lTargets, lComparators);
        }

        protected void filterType(List lSources, List lTargets, List lComparators) {
            try {
                for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                    int iType;
                    TreePath pathSource = (TreePath)lSources.get(iSource);
                    WsTreeNode nodeSource = (WsTreeNode)pathSource.getLastPathComponent();
                    if (!(nodeSource instanceof WsDataTreeNode)) {
                        this.displayTypesErrorMessage();
                        lSources.clear();
                        break;
                    }
                    CMetadata oSource = ((WsDataTreeNode)nodeSource).getMetadata();
                    String sType = oSource.getCMetadataType();
                    for (iType = 0; iType < this.m_saSelectionTypes.length && !sType.equals(this.m_saSelectionTypes[iType]); ++iType) {
                    }
                    if (iType >= this.m_saSelectionTypes.length) {
                        this.displayTypesErrorMessage();
                        lSources.clear();
                        break;
                    }
                    lComparators.add(this.m_aComparators[iType]);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        protected void displayTypesErrorMessage() {
            if (this.m_bShowMessages) {
                String sType = this.m_sPluralDisplayType;
                if (sType == null && this.m_saSelectionTypes != null) {
                    sType = this.m_saSelectionTypes[0];
                }
                String sMessage = bundle.formatString("ObjectsSelectorPanel.OnlyTypesMayBeSelectedError.fmt.txt", (Object)sType);
                MessageUtil.displayMessage((String)sMessage, (int)0);
            }
        }

        protected void filterDuplicates(List lSources, List lTargets, List lComparators) {
            try {
                ArrayList<String> lDuplicates = new ArrayList<String>();
                for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                    TreePath pathSource = (TreePath)lSources.get(iSource);
                    WsTreeNode nodeSource = (WsTreeNode)pathSource.getLastPathComponent();
                    CMetadata oSource = ((WsDataTreeNode)nodeSource).getMetadata();
                    boolean bAddSourceToTarget = true;
                    for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                        TreePath pathTarget = (TreePath)lTargets.get(iTarget);
                        WsDataTreeNode nodeTarget = (WsDataTreeNode)pathTarget.getLastPathComponent();
                        CMetadata oTarget = nodeTarget.getMetadata();
                        Comparator cmp = (Comparator)lComparators.get(iSource);
                        if (!oSource.getCMetadataType().equals(oTarget.getCMetadataType()) || cmp.compare(oSource, oTarget) != 0) continue;
                        lDuplicates.add(nodeSource.toString());
                        lComparators.remove(iSource);
                        lSources.remove(iSource--);
                        bAddSourceToTarget = false;
                        break;
                    }
                    if (!bAddSourceToTarget) continue;
                    lTargets.add(pathSource);
                }
                if (lDuplicates.size() > 0 && this.m_bShowMessages) {
                    MessageUtil.displayListMessage((String)bundle.getString("ObjectsSelectorPanel.DuplicatesError.txt"), lDuplicates, (int)0);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public static interface Filter {
        public void filter(List var1, List var2);

        public void setShowingMessages(boolean var1);
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof TreePath) {
                TreePath pathValue = (TreePath)value;
                WsTreeNode nodeValue = (WsTreeNode)pathValue.getLastPathComponent();
                this.setIcon(nodeValue.getIcon(false));
                this.setText(nodeValue.toString());
            }
            return this;
        }
    }
}

