/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.NotesListModelUsingMetadata;
import com.sas.wadmin.visuals.common.NotePreviewPane;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsList;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NotesPaneUsingMetadata
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(NotesPaneUsingMetadata.class);
    private Root m_oMetadata;
    private TextStore m_currentNote;
    private JPopupMenu m_mnuNotesListPopup;
    private JLabel m_lblNotesList;
    private WsList m_lstNotesList;
    private JScrollPane m_scrNotesList;
    private NotesListModelUsingMetadata m_mdlNotesList;
    private NotePreviewPane m_txtNote;
    private JButton m_btnDelete;
    private JButton m_btnNew;
    private JButton m_btnAttach;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actAttach;
    private boolean m_bNotesListChanged = false;
    private boolean m_bNoteChanged = false;

    public NotesPaneUsingMetadata(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.createActions();
        this.createNotesPopupMenu();
        this.m_mdlNotesList = new NotesListModelUsingMetadata(this.m_oMetadata);
        this.m_lstNotesList = new WsList((ListModel)this.m_mdlNotesList);
        this.m_lstNotesList.setToolTipText(bundle.getString("NotesPane.NotesList.tip"));
        this.m_lstNotesList.setComponentPopupMenu(this.m_mnuNotesListPopup);
        this.m_lstNotesList.getSelectionModel().addListSelectionListener(new NotesListSelectionListener());
        this.m_lstNotesList.setSelectionMode(0);
        this.m_lstNotesList.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_lstNotesList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_lblNotesList = new JLabel(bundle.getString("NotesPane.Label.Assigned.txt"));
        this.m_lblNotesList.setDisplayedMnemonic(bundle.getString("NotesPane.Label.Assigned.mnem").charAt(0));
        this.m_lblNotesList.setLabelFor((Component)this.m_lstNotesList);
        this.m_txtNote = new NotePreviewPane();
        this.m_txtNote.setEnabled(false);
        JLabel lblNotesText = this.m_txtNote.getTextLabel();
        lblNotesText.setText(bundle.getString("NotesPane.Label.NoteText.txt"));
        lblNotesText.setDisplayedMnemonic(bundle.getString("NotesPane.Label.NoteText.mnem").charAt(0));
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnAttach = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttach);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_lstNotesList, (Component)this.m_txtNote);
        CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.m_txtNote, (Component)this.m_btnNew);
        this.m_txtNote.setDocumentListener(new NotesDocumentListener());
    }

    private void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAttach = this.createAttachAction();
    }

    private WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    private WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    private WsAbstractAction createAttachAction() {
        return new cAttachAction();
    }

    private void createNotesPopupMenu() {
        this.m_mnuNotesListPopup = new JPopupMenu();
        this.m_mnuNotesListPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNew));
        this.m_mnuNotesListPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        int[] aRows = this.m_lstNotesList.getSelectedIndices();
        boolean bSelected = aRows != null && aRows.length > 0;
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actAttach.setEnabled(bEditable);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_lstNotesList.setEditable(bEditable);
        if (this.m_lstNotesList.getModel().getSize() > 0) {
            if (this.m_lstNotesList.getSelectedIndex() > -1) {
                Document obj = (Document)this.m_lstNotesList.getSelectedValues()[0];
                if (Workspace.getWorkspace().isObjectEditable((CMetadata)obj)) {
                    this.m_txtNote.setEditable(bEditable);
                } else {
                    this.m_txtNote.setEditable(false);
                }
            }
            this.m_txtNote.setEditable(bEditable);
        } else {
            this.m_txtNote.setEditable(bEditable);
        }
        this.updateActions();
    }

    public Component getDefaultFocusComponent() {
        return this.m_lstNotesList;
    }

    public boolean validateData() {
        if (this.m_bNotesListChanged) {
            ArrayList noteNameConflicts = new ArrayList();
            if (noteNameConflicts.isEmpty()) {
                return true;
            }
            if (noteNameConflicts.size() == 1) {
                int changeDuplicateName = MessageUtil.displayMessage((String)bundle.formatString("NotesPane.Error.OneDuplicateName.fmt.txt", noteNameConflicts.get(0)), (String)bundle.getString("NotesPane.DuplicateNameWarning.txt"), (int)2, (int)0);
                return changeDuplicateName != 0;
            }
            Collections.sort(noteNameConflicts);
            int changeDuplicateName = MessageUtil.displayListMessage((String)bundle.getString("NotesPane.Error.ManyDuplicateNames.txt"), noteNameConflicts, (String)bundle.getString("NotesPane.DuplicateNameWarning.txt"), (int)2, (int)0);
            return changeDuplicateName != 0;
        }
        return true;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("NotesPane.notesString.txt")));
        this.m_scrNotesList = new JScrollPane((Component)this.m_lstNotesList);
        this.m_scrNotesList.setToolTipText(bundle.getString("NotesPane.NotesList.tip"));
        this.m_txtNote.getTextPane().setToolTipText(bundle.getString("NotesPane.NoteText.tip"));
        JPanel m_pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        m_pnlButtons.add(this.m_btnNew);
        m_pnlButtons.add(this.m_btnDelete);
        m_pnlButtons.add(this.m_btnAttach);
        this.add(this.m_lblNotesList, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrNotesList, new GridBagConstraints(0, 1, 1, 1, 0.4, 1.0, 18, 1, new Insets(5, 0, 0, 10), 0, 0));
        this.add(this.m_txtNote, new GridBagConstraints(1, 0, 2, 2, 0.6, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(m_pnlButtons, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void addNotesFocusListener(FocusListener f) {
        this.m_lstNotesList.addFocusListener(f);
        this.m_txtNote.getTextPane().addFocusListener(f);
    }

    public WsAbstractAction getDeleteAction() {
        return this.m_actDelete;
    }

    private void doDelete() {
        int iRow;
        if (this.m_lstNotesList.isEditing()) {
            this.m_lstNotesList.cancelCellEditing();
        }
        if ((iRow = this.getSelectedRow()) != -1) {
            this.removeNote(iRow);
            this.m_bNotesListChanged = true;
            this.setDataChanged(true);
        }
    }

    private void removeNote(int iIndex) {
        int iCount = 0;
        int iTotalCount = 0;
        boolean bFound = false;
        try {
            AssociationList allDocs = this.m_oMetadata.getDocuments();
            for (int i = 0; i < allDocs.size(); ++i) {
                Document doc = (Document)allDocs.get(i);
                if (doc.getPublicType().equalsIgnoreCase("Note")) {
                    if (iIndex == iCount) {
                        bFound = true;
                        break;
                    }
                    ++iCount;
                }
                ++iTotalCount;
            }
            if (bFound) {
                this.m_oMetadata.getDocuments().remove(iTotalCount);
                this.m_mdlNotesList.remove(iIndex);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        this.m_mdlNotesList.doDataExchange(bSaveToModel);
        if (bSaveToModel && this.hasDataChanged()) {
            this.saveNoteText();
        }
        return true;
    }

    private void setNoteText() {
        try {
            if (this.m_currentNote != null && !this.m_txtNote.getContents().equals(this.m_currentNote.getStoredText())) {
                this.m_txtNote.setContents(this.m_currentNote.getStoredText());
            }
            this.m_bNoteChanged = false;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    private void saveNoteText() {
        try {
            if (this.m_currentNote != null && this.m_bNoteChanged) {
                this.m_currentNote.setStoredText(this.m_txtNote.getContents());
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    private void doNew() {
        SimpleObject obj = AppDialogFactory.getInstance().showNewNoteDialog((JFrame)Workspace.getWorkspace(), null);
        if (obj == null) {
            return;
        }
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            Document oDoc = (Document)factory.createComplexMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore(), obj.getName(), obj.getMetadataType(), obj.getID());
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oDoc, null, null, null, 8);
            this.m_oMetadata.getDocuments().add((Object)oDoc);
            this.m_mdlNotesList.addElement(oDoc);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        this.m_bNotesListChanged = true;
        this.setDataChanged(true);
        this.m_lstNotesList.setSelectedIndex(this.m_mdlNotesList.getSize() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAttach() throws RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AttachNotes");
        ArrayList<String> salErrorValues = new ArrayList<String>();
        try {
            ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 5);
            String sImportDialogTitle = bundle.getString("NotesPane.Attach.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("shared");
            dlg.setHelpTopic("sel_note");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject[] aNotes = pnl.getSelectedObjects();
                for (int iNote = 0; iNote < aNotes.length; ++iNote) {
                    SimpleObject note = aNotes[iNote];
                    Document mdoNote = (Document)ObjectConverter.getInstance().convertToJOMAObject(store, note);
                    if (!this.isDuplicate(mdoNote)) {
                        this.m_oMetadata.getDocuments().add((Object)mdoNote);
                        this.m_mdlNotesList.addElement(mdoNote);
                        continue;
                    }
                    salErrorValues.add(mdoNote.getName());
                }
                if (aNotes.length == 0) {
                    return;
                }
                if (salErrorValues.size() > 0) {
                    MessageUtil.displayListMessage((String)bundle.getString("NotesTab.DuplicateObject.txt"), salErrorValues, (int)1);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        finally {
            store.dispose();
        }
    }

    private boolean isDuplicate(Document oDoc) {
        try {
            if (this.m_oMetadata.getDocuments().indexOf((Object)oDoc) > -1) {
                return true;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return true;
        }
        return false;
    }

    private int getSelectedRow() {
        int[] aRows = this.m_lstNotesList.getSelectedIndices();
        int iRow = aRows != null && aRows.length > 0 ? aRows[0] : -1;
        return iRow;
    }

    private class cAttachAction
    extends WsAbstractAction {
        public cAttachAction() {
            super(bundle, "NotesPane.Attach");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NotesPaneUsingMetadata.this.doAttach();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "NotesPane.Delete", 544);
        }

        public void actionPerformed(ActionEvent e) {
            NotesPaneUsingMetadata.this.doDelete();
        }
    }

    private class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "NotesPane.New", 544);
        }

        public void actionPerformed(ActionEvent e) {
            NotesPaneUsingMetadata.this.doNew();
        }
    }

    private class NotesDocumentListener
    implements DocumentListener {
        private NotesDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NotesPaneUsingMetadata.this.m_bNoteChanged = true;
            NotesPaneUsingMetadata.this.setDataChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NotesPaneUsingMetadata.this.m_bNoteChanged = true;
            NotesPaneUsingMetadata.this.setDataChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NotesPaneUsingMetadata.this.m_bNoteChanged = true;
            NotesPaneUsingMetadata.this.setDataChanged(true);
        }
    }

    private class NotesListSelectionListener
    implements ListSelectionListener {
        private NotesListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean bEnabled;
            NotesPaneUsingMetadata.this.m_lstNotesList.cancelCellEditing();
            boolean bTextEditable = false;
            boolean bDeleteEnabled = true;
            int iRow = NotesPaneUsingMetadata.this.getSelectedRow();
            if (iRow != -1) {
                TextStore newSelNote = (TextStore)NotesPaneUsingMetadata.this.m_mdlNotesList.getNoteTextStoreAtIndex(iRow);
                if (NotesPaneUsingMetadata.this.m_currentNote != newSelNote) {
                    NotesPaneUsingMetadata.this.saveNoteText();
                    NotesPaneUsingMetadata.this.m_currentNote = newSelNote;
                    NotesPaneUsingMetadata.this.setNoteText();
                }
                bTextEditable = Workspace.getWorkspace().isObjectEditable((CMetadata)NotesPaneUsingMetadata.this.m_currentNote);
                bDeleteEnabled = true;
                bEnabled = bTextEditable;
            } else {
                NotesPaneUsingMetadata.this.saveNoteText();
                NotesPaneUsingMetadata.this.m_currentNote = null;
                NotesPaneUsingMetadata.this.m_txtNote.setContents("");
                bEnabled = false;
                bDeleteEnabled = false;
            }
            NotesPaneUsingMetadata.this.m_txtNote.setEnabled(bEnabled && NotesPaneUsingMetadata.this.isEditable() && bTextEditable);
            NotesPaneUsingMetadata.this.m_actDelete.setEnabled(bDeleteEnabled && NotesPaneUsingMetadata.this.isEditable());
        }
    }
}

