/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.visuals.WAdminTree_Warehouse;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class NewProjectWizard
extends WAWizardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewProjectWizard.class);
    protected CMetadata m_selectedProjectRepository = null;
    protected Group m_topGroup = null;
    protected Vector m_objectArray = new Vector();
    protected MdObjectStore m_store;

    public NewProjectWizard(Frame frame, String title) {
        super(frame, title, true);
        WizardFinishTab tmpObj = null;
        this.addWizardData("FINISHINFO", "");
        ImageIcon image = bundle.getImageIcon("SourceDesigner.FirstTab.image");
        this.addTab(bundle.getString("NewProjectWizard.Checkout.Title"), "NewProjectWizardtab1", (WAPropertyTab)new cCheckoutTab(bundle.getString("NewProjectWizard.Checkout.Desc.txt"), "NewProjectWizardtab1"), "warehouse_w1.gif", image, false);
        tmpObj = new WizardFinishTab(bundle.getString("NewProjectWizard.finishtabtitle.txt"));
        tmpObj.setHelpProduct("shared");
        tmpObj.setHelpTopic("wiz_finish_win");
        this.addTab(bundle.getString("FinishTab.Title.txt"), "NewProjectWizardtab2", (WAPropertyTab)tmpObj, "warehouse_w1.gif", image, true);
    }

    protected class cCheckoutTab
    extends WsDescriptionWizardTab {
        protected String m_initialTab;
        protected WAdminTree_Warehouse m_selTree;

        public cCheckoutTab(String name, String initialTab) {
            super(name);
            this.m_initialTab = initialTab;
            this._initialize();
            this.setHelpProduct("wdb");
            this.setHelpTopic("cmwiz_select");
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                this.m_selTree.initialize();
                this.m_selTree.setListenForChanges(false);
                this.m_selTree.setPopupMenusEnabled(false);
                this.m_selTree.setEditable(false);
                this.m_selTree.setDefaultActionEnabled(false);
                NewProjectWizard.this.m_topGroup = null;
                NewProjectWizard.this.m_objectArray.clear();
            } else {
                String str1 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Message");
                String str2 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Title");
                String str3 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Cancel");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new cThreadedCheckoutRunnable());
                Workspace.getDefaultLogger().debug((Object)"Finished waiting on checkout");
            }
            return true;
        }

        public void doThreadedCheckout() {
            Workspace.getDefaultLogger().debug((Object)"Starting checkout");
            try {
                TreePath[] paths = this.m_selTree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    CMetadata object = node.getMetadata();
                    NewProjectWizard.this.m_store = (MdObjectStore)NewProjectWizard.this.getWizardData("OBJECTSTORE");
                    CMetadata detailObject = Workspace.getMdFactory().createComplexMetadataObject(NewProjectWizard.this.m_store, null, object);
                    NewProjectWizard.this.m_objectArray.add(detailObject);
                }
                CMetadata projectRepository = Workspace.getWorkspace().getProjectRepository();
                ProjectUtil.checkOutMetadata((List)NewProjectWizard.this.m_objectArray, (CMetadata)projectRepository);
                if (NewProjectWizard.this.m_store != null) {
                    NewProjectWizard.this.m_store.dispose();
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingout");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            Workspace.getDefaultLogger().debug((Object)"Finished checkout");
        }

        public void _initialize() {
            this.setLayout(new GridBagLayout());
            this.m_selTree = new WAdminTree_Warehouse();
            this.m_selTree.getSelectionModel().setSelectionMode(4);
            JScrollPane treeScrollPane = new JScrollPane((Component)((Object)this.m_selTree), 22, 30);
            treeScrollPane.setBorder(BorderFactory.createBevelBorder(1));
            treeScrollPane.setToolTipText(bundle.getString("NewProjectWizard.CheckoutTab.Label.Tooltip.txt"));
            treeScrollPane.setPreferredSize(new Dimension(200, 150));
            this.add(treeScrollPane, new GridBagConstraints(0, 0, 3, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            boolean isout = false;
            try {
                TreePath[] paths = this.m_selTree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    CMetadata object = node.getMetadata();
                    if (object == null) {
                        MessageUtil.displayMessage((String)bundle.getString("NewProjectWizard.InvalidSelection.txt"), (int)2);
                        return false;
                    }
                    if (object.getCMetadataType().compareToIgnoreCase("Environment") == 0) {
                        MessageUtil.displayMessage((String)bundle.getString("NewProjectWizard.InvalidSelection.txt"), (int)2);
                        return false;
                    }
                    if (object.getCMetadataType().compareToIgnoreCase("Cube") == 0) {
                        MessageUtil.displayMessage((String)bundle.formatString("NewProjectWizard.NoCubeCheckout.Text.fmt", (Object)object.getName()), (int)2);
                        return false;
                    }
                    isout = object.isCheckedOut();
                    if (!isout) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("NewProjectWizard.ObjectIsCheckedOut.Text.fmt", (Object)object.getName()), (int)2);
                    break;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return !isout;
        }

        public String createFinishString() {
            String temp = "";
            try {
                TreePath[] paths = this.m_selTree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    temp = temp + node.getMetadata().getName() + "\n";
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return temp;
        }

        protected class cThreadedCheckoutRunnable
        implements Runnable {
            @Override
            public void run() {
                cCheckoutTab.this.doThreadedCheckout();
            }
        }
    }
}

