/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.Tree;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.SourceDesigner;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class NewGlobalsWizard
implements NewObjectInterface,
MultipleNodeInterface {
    protected WAWizardDialog m_wizardDialog;
    protected WATransitionWizardModel m_wizardModel;
    protected String m_name = bundle.getString("NewGlobalsWizard.pluginname.txt");
    protected ImageIcon m_icon = bundle.getImageIcon("Common.ClosedTree.image");
    protected String m_tooltip = bundle.getString("NewGlobalsWizard.ToolTip.txt");
    protected String m_category = "";
    private static WAdminResource bundle = WAdminResource.getBundle(NewGlobalsWizard.class);
    protected static final int LIBRARY = 1;
    protected static final int SOURCEDESIGNER = 3;
    protected int m_iType = 1;

    public String getDescription() {
        return bundle.getString("NewGlobalsWizard.description.txt");
    }

    public void initPlugin() {
    }

    public void dispose() {
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean initializeWizard(WAWizardDialog wizardDialog, WATransitionWizardModel wizardModel) {
        this.m_wizardDialog = wizardDialog;
        this.m_wizardModel = wizardModel;
        return true;
    }

    public boolean checkGlobalSelection(String nodeName) {
        Collator collator = Collator.getInstance();
        boolean fReturn = false;
        if (collator.compare(nodeName, bundle.getString("NewGlobalsWizard.Name.Library.txt")) == 0) {
            this.m_iType = 1;
            fReturn = true;
        } else if (collator.compare(nodeName, bundle.getString("NewGlobalsWizard.Name.SourceDesigner.txt")) == 0) {
            this.m_iType = 3;
            fReturn = true;
        }
        return fReturn;
    }

    public void launchGlobalWizard() {
        try {
            Workspace work = Workspace.getWorkspace();
            Object wizard = null;
            if (this.m_iType == 1) {
                wizard = new LibraryWizard((JFrame)work, work.getDefaultRepository().getFQID());
            } else if (this.m_iType == 3) {
                wizard = new SourceDesigner((Frame)work, bundle.getString("SourceDesigner.Title"));
            }
            wizard.show();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void launchGlobalWizard(Object tree) {
        try {
            if (tree instanceof Tree) {
                Tree groupTree = (Tree)tree;
                Workspace work = Workspace.getWorkspace();
                Object wizard = null;
                if (this.m_iType == 1) {
                    wizard = new LibraryWizard((JFrame)work, work.getDefaultRepository().getFQID());
                } else if (this.m_iType == 3) {
                    wizard = new SourceDesigner((Frame)work, bundle.getString("SourceDesigner.Title"), groupTree);
                }
                wizard.show();
            } else {
                this.launchGlobalWizard();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public String getInitialTabName() {
        return "";
    }

    public String[] getLastTabNames() {
        String[] value = new String[]{""};
        return value;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    @Override
    public String getToolTip() {
        return this.m_tooltip;
    }

    @Override
    public String getCategory() {
        return this.m_category;
    }

    public ArrayList getNames() {
        ArrayList<String> names = new ArrayList<String>(8);
        names.add(bundle.getString("NewGlobalsWizard.Name.Library.txt"));
        names.add(bundle.getString("NewGlobalsWizard.Name.SourceDesigner.txt"));
        return names;
    }

    public ArrayList getToolTips() {
        ArrayList<String> names = new ArrayList<String>(8);
        names.add(bundle.getString("NewGlobalsWizard.ToolTip.Library.txt"));
        names.add(bundle.getString("NewGlobalsWizard.ToolTip.SourceDesigner.txt"));
        return names;
    }

    public ArrayList getIcons() {
        ArrayList<ImageIcon> names = new ArrayList<ImageIcon>(8);
        names.add(bundle.getImageIcon("NewGlobalsWizard.Library.image"));
        names.add(bundle.getImageIcon("NewGlobalsWizard.SourceDesigner.image"));
        return names;
    }

    public ArrayList getDescriptions() {
        ArrayList<String> names = new ArrayList<String>(8);
        names.add(bundle.getString("NewGlobalsWizard.description.Library.txt"));
        names.add(bundle.getString("NewGlobalsWizard.description.SourceDesigner.txt"));
        return names;
    }
}

