/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.Folder;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.rmi.RemoteException;

public class NewFolderDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewFolderDialog.class);
    private SimpleObject m_parentFolder;
    private cMainPanel m_pnlMain;
    private SimpleObject m_folder;
    private Tree m_newFolder = null;
    private MdObjectStore m_store = null;

    public NewFolderDialog(Frame frm) {
        this(frm, null);
    }

    public NewFolderDialog(Frame frm, SimpleObject parentFolder) {
        super(frm, true);
        this.m_parentFolder = parentFolder;
        this.setTitle(bundle.getString("NewFolderDialog.Title.txt"));
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("folder_wizard");
    }

    protected void initialize() {
        super.initialize();
        this.m_pnlMain = new cMainPanel();
        this.setMainPanel(this.m_pnlMain);
        this.setResizable(true);
    }

    public SimpleObject getNewFolder() {
        return this.m_folder;
    }

    protected void writeMetadata(boolean bCleanUp) {
        super.writeMetadata(false);
        try {
            this.m_folder = new SimpleObjectImpl(this.m_newFolder.getName(), this.m_newFolder.getFQID(), this.m_newFolder.getCMetadataType(), this.m_newFolder.getPublicType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (bCleanUp) {
            this.dispose();
        }
    }

    private class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected WAGeneralPanel m_generalPanel;

        public cMainPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_generalPanel = new WAGeneralPanel(null, null, false, false, false, true);
            this.m_generalPanel.setAllowRootFolderSelection(true);
            this.m_generalPanel.enableNameValidation(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_generalPanel, "Center");
        }

        public void moveDataToView() {
            try {
                NewFolderDialog.this.m_store = Workspace.getMdFactory().createObjectStore(null, "NewFolderDialog");
                this.m_generalPanel.moveDataToView();
                String newName = WsMetadataNameUtil.getUniqueNameForType((String)"Tree", (String)bundle.getString("NewFolderDialog.DefaultFolderName.txt"));
                this.m_generalPanel.setNameField(newName);
                Tree mdoFolder = NewFolderDialog.this.m_parentFolder == null ? WsMetadataUtil.getDefaultFolder((MdObjectStore)NewFolderDialog.this.m_store) : (Tree)ObjectConverter.getInstance().convertToJOMAObject(NewFolderDialog.this.m_store, NewFolderDialog.this.m_parentFolder);
                this.m_generalPanel.setOwningTree(mdoFolder);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
        }

        public void moveDataToStore() {
            try {
                NewFolderDialog.this.m_newFolder = this.makeFolder(NewFolderDialog.this.m_store);
                NewFolderDialog.this.setMetadataObject((CMetadata)NewFolderDialog.this.m_newFolder);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public boolean validateData() {
            boolean bIsUniqueName;
            boolean state = this.m_generalPanel.validateData();
            if (!state) {
                return state;
            }
            Tree tree = null;
            SoftwareComponent sc = this.m_generalPanel.getOwningSoftwareComponent();
            if (sc == null && (tree = this.m_generalPanel.getOwningTree()) == null) {
                MessageUtil.displayMessage((String)bundle.getString("NewFolderDialog.MissingFolder.txt"), (int)0);
                return false;
            }
            if (tree != null && !(bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (Tree)tree, (String)"Folder"))) {
                MessageUtil.displayMessage((String)bundle.getString("NewFolderDialog.DuplicateName.Message.txt"), (String)bundle.getString("NewFolderDialog.DuplicateName.Title.txt"), (int)0, (int)-1);
                return false;
            }
            if (sc != null && !(bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (SoftwareComponent)sc, (String)"Folder"))) {
                MessageUtil.displayMessage((String)bundle.getString("NewFolderDialog.DuplicateName.Message.txt"), (String)bundle.getString("NewFolderDialog.DuplicateName.Title.txt"), (int)0, (int)-1);
                return false;
            }
            return true;
        }

        public void saveSettingsAndCleanUp() {
            try {
                if (NewFolderDialog.this.m_store != null && !NewFolderDialog.this.m_store.isDisposed()) {
                    NewFolderDialog.this.m_store.dispose();
                }
                NewFolderDialog.this.m_store = null;
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        private Tree makeFolder(MdObjectStore store) throws RemoteException, MdException {
            SoftwareComponent sc;
            Tree owningTree;
            Tree tree = null;
            String reposID = null;
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                reposID = repos.getFQID().substring(9, 17);
            } else {
                owningTree = this.m_generalPanel.getOwningTree();
                if (owningTree != null) {
                    reposID = owningTree.getRepositoryID();
                } else {
                    sc = this.m_generalPanel.getOwningSoftwareComponent();
                    reposID = sc.getRepositoryID();
                }
            }
            tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, "", "Tree", reposID, null);
            tree.setTreeType("BIP Folder");
            tree.setPublicType("Folder");
            tree.setUsageVersion(Folder.CURRENT_VERSION.encode());
            tree.setName(this.m_generalPanel.getNameComponent().getText());
            tree.setDesc(this.m_generalPanel.getDescriptionComponent().getText());
            owningTree = this.m_generalPanel.getOwningTree();
            if (owningTree != null) {
                tree.setParentTree(owningTree);
                WsMetadataUtil.setDefaultFolder((String)owningTree.getFQID());
            } else {
                sc = this.m_generalPanel.getOwningSoftwareComponent();
                if (sc != null) {
                    tree.getSoftwareComponents().add((Object)sc);
                }
            }
            return tree;
        }
    }
}

