/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class NewDocumentWizardTab
extends WsDescriptionWizardTab
implements MdStoreListener {
    private static WAdminResource bundle = WAdminResource.getBundle(NewDocumentWizardTab.class);
    protected Tree m_groupTree = null;
    protected JButton m_additionalBtn;
    protected JButton m_newButton;
    protected WAGeneralPanel m_generalPanel;
    protected Document m_doc;
    protected WATextField m_doctext;
    protected String m_fullPath = null;
    private static final String PUBLICTYPE_DOCUMENT = "Document";

    public NewDocumentWizardTab() {
        super(bundle.getString("NewDocumentWizardTab.Description.txt"));
        this._initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("new_doc_wiz");
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            store.addMdStoreListener((MdStoreListener)this);
            if (this.m_doc == null) {
                CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                String defaultName = WsMetadataNameUtil.getUniqueNameForType((String)PUBLICTYPE_DOCUMENT, (String)bundle.getString("NewDocumentWizardTab.DefaultDocumentName.txt"));
                this.m_doc = (Document)Workspace.getMdFactory().createComplexMetadataObject(store, "", PUBLICTYPE_DOCUMENT, repos.getFQID().substring(9, 17));
                this.m_doc.setName(defaultName);
                myParent.addWizardData("DEFAULTTREEROLE", (Object)"Documents");
                myParent.addWizardData("MYNEWOBJECTTYPE", (Object)bundle.getString("NewDocumentWizardTab.NewObjectType.Name.txt"));
            }
            this.m_generalPanel.setMetadataObject((Root)this.m_doc);
            this.m_generalPanel.doDataExchange(false);
            this.m_doc.setPublicType(PUBLICTYPE_DOCUMENT);
            this.m_doc.setUsageVersion(OMRDocument.CURRENT_VERSION.encode());
        } else {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            CMetadata repository = (CMetadata)myParent.getWizardData("REPOSITORY");
            myParent.fixupID((CMetadata)this.m_doc, repository.getFQID());
            Vector m_validObjects = (Vector)myParent.getWizardData("ATTACHOBJECTS");
            if (m_validObjects != null) {
                for (int i = 0; i < m_validObjects.size(); ++i) {
                    CMetadata metaObject = (CMetadata)m_validObjects.get(i);
                    String metatype = metaObject.getCMetadataType();
                    CMetadata m_attachObject = Workspace.getMdFactory().createComplexMetadataObject(store, "", metatype, metaObject.getFQID());
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(m_attachObject, null, null, "", 8);
                    this.m_doc.getObjects().add((Object)m_attachObject);
                }
            }
            String newDocText = this.m_fullPath.trim();
            this.m_doc.setURI(newDocText);
            if (myParent.getWizardData("GROUP") == null) {
                myParent.addWizardData("GROUP", null);
            } else {
                this.m_doc.getTrees().add(myParent.getWizardData("GROUP"));
            }
            myParent.setMasterObject((CMetadata)this.m_doc);
            myParent.addWizardData("DOC", (Object)this.m_doc);
        }
        return true;
    }

    public void _initialize() {
        this.setLayout(new GridBagLayout());
        this.m_generalPanel = new WAGeneralPanel(bundle.getString("WAGeneralPropertyTab.Title.txt"), false, false, false);
        this.m_generalPanel.setPreferredSize(new Dimension(200, 100));
        this.add((Component)this.m_generalPanel, new GridBagConstraints(0, 0, 4, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel m_doclabel = new JLabel(bundle.getString("NewDocumentWizardTab.Label.Path.txt"));
        m_doclabel.setDisplayedMnemonic(bundle.getString("NewDocumentWizardTab.Label.Path.mnem").charAt(0));
        this.add(m_doclabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_doctext = new WATextField();
        this.m_doctext.setBehavior(0);
        this.m_doctext.setToolTipText(bundle.getString("NewDocumentWizardTab.Label.Path.Tooltip.txt"));
        this.m_doctext.setFocusAccelerator(bundle.getString("NewDocumentWizardTab.Label.Path.mnem").charAt(0));
        this.m_doctext.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)this.m_doctext, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 42, 0, 0), 0, 0));
        this.m_newButton = new JButton(bundle.getString("NewDocumentWizardTab.NewButton.txt"));
        this.m_newButton.setMnemonic(bundle.getString("NewDocumentWizardTab.NewButton.mnem").charAt(0));
        this.m_newButton.setToolTipText(bundle.getString("NewDocumentWizardTab.NewButton.Tooltip.txt"));
        this.m_newButton.addActionListener(new ActionListener(){
            String m_selectedDir = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                String uDir;
                String wholeName;
                FileDialog m_fileSelect = null;
                m_fileSelect = new FileDialog((Frame)Workspace.getWorkspace());
                if (this.m_selectedDir != null) {
                    m_fileSelect.setDirectory(this.m_selectedDir);
                } else {
                    m_fileSelect.setDirectory(Workspace.getWorkspace().getDefaultPath());
                }
                m_fileSelect.setMode(0);
                m_fileSelect.show();
                String uFile = m_fileSelect.getFile();
                this.m_selectedDir = m_fileSelect.getDirectory();
                if (uFile != null && (wholeName = (uDir = m_fileSelect.getDirectory()) + uFile) != null) {
                    NewDocumentWizardTab.this.m_doctext.setText(wholeName);
                }
            }
        });
        this.add(this.m_newButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.m_additionalBtn = new JButton(bundle.getString("NewDocumentWizardTab.AdditionalProp.txt"));
        this.m_additionalBtn.setMnemonic(bundle.getString("NewDocumentWizardTab.AdditionalProp.mnem").charAt(0));
        this.m_additionalBtn.setToolTipText(bundle.getString("NewDocumentWizardTab.AdditionalProp.Tooltip.txt"));
        this.m_additionalBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(NewDocumentWizardTab.this.m_doc.getObjectStore());
                    WAPropertyDialog buttonDialog = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("NewDocumentWizardTab.AdditionalProp.Dialog.Title.txt"), true);
                    NewDocumentWizardTab.this.m_generalPanel.doDataExchange(true);
                    Document tempNewNote = (Document)Workspace.getMdFactory().createComplexMetadataObject(store, NewDocumentWizardTab.this.m_doc.getObjectStore(), (CMetadata)NewDocumentWizardTab.this.m_doc);
                    buttonDialog.setMetadataObject((CMetadata)tempNewNote);
                    buttonDialog.addTab(bundle.getString("Common.General.txt"), (WAPropertyTab)new WAGeneralPropertyTab((CMetadata)tempNewNote));
                    buttonDialog.addTab(bundle.getString("NewDocumentWizardTab.ExtAttrTab.Title.txt"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)tempNewNote));
                    buttonDialog.addTab(bundle.getString("WsGenericGeneralPropertyTab.Title.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)tempNewNote));
                    buttonDialog.show();
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        });
        this.add(this.m_additionalBtn, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        boolean state = this.m_generalPanel.validateData();
        if (!state) {
            return state;
        }
        String m_docPath = this.m_doctext.getText().trim();
        if (m_docPath == null || m_docPath.trim().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("NewDocumentWizardTab.errornodoc.txt"), bundle.getString("NewDocumentWizardTab.Title.errornodoc.txt"), 0);
            return false;
        }
        try {
            this.m_generalPanel.doDataExchange(true);
            this.m_fullPath = m_docPath;
            this.m_doctext.setText(" ");
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent.addWizardData("THEDOCPATH", (Object)this);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public void setDocPath() {
        this.m_doctext.setText(this.m_fullPath);
    }

    public String createFinishString() {
        StringBuffer sbFinish = new StringBuffer(300);
        try {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            CMetadata repos = (CMetadata)myParent.getWizardData("REPOSITORY");
            sbFinish.append(bundle.getString("NewDocumentWizardTab.FinishString.Intro.txt"));
            sbFinish.append("\n\n");
            sbFinish.append(bundle.formatString("NewDocumentWizardTab.FinishString.Repository.txt", (Object)repos.getName()));
            sbFinish.append("\n");
            Tree groupTree = (Tree)myParent.getWizardData("GROUP");
            if (groupTree != null) {
                sbFinish.append(bundle.formatString("NewDocumentWizardTab.FinishString.Group.txt", (Object)groupTree.getName()));
            } else {
                sbFinish.append(bundle.formatString("NewDocumentWizardTab.FinishString.Group.txt", (Object)"Ungrouped"));
            }
            sbFinish.append("\n");
            sbFinish.append(bundle.formatString("NewDocumentWizardTab.FinishString.Name.fmt.txt", (Object)this.m_doc.getName()));
            sbFinish.append("\n");
            sbFinish.append(bundle.formatString("NewDocumentWizardTab.FinishString.Desc.fmt.txt", (Object)this.m_doc.getDesc()));
            sbFinish.append("\n\n");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return sbFinish.toString();
    }

    public void MdObjectsModified(MdEvent e, List items) {
        try {
            this.m_generalPanel.doDataExchange(false);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void MdObjectsRemoved(MdEvent e, List items) {
    }

    public void MdObjectsAdded(MdEvent e, List items) {
    }
}

