/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MiningTreeUtilities {
    private static final String ClassIdentifier = "com.sas.analytics.eminer.EnterpriseMiner";

    private MiningTreeUtilities() {
    }

    public static Tree getRoot(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getWorkspace().getMdObjectFactory().createObjectStore(null, "MiningTreeUtilities.getRoot");
        try {
            Tree tree = MiningTreeUtilities.getRoot(sRepositoryFQID, store);
            return tree;
        }
        finally {
            store.dispose();
        }
    }

    public static Tree getRoot(String sRepositoryFQID, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        sbOptions.append("<XMLSelect Search=\"@ClassIdentifier='");
        sbOptions.append(ClassIdentifier);
        sbOptions.append("'\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<SoftwareComponent><SoftwareTrees/></SoftwareComponent>");
        sbOptions.append("<Tree TreeType=\"\"></Tree>");
        sbOptions.append("</Templates>");
        int fOptions = 396;
        List lSoftComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "SoftwareComponent", fOptions, sbOptions.toString());
        if (lSoftComponents.isEmpty()) {
            return null;
        }
        SoftwareComponent oSoft = (SoftwareComponent)lSoftComponents.get(0);
        AssociationList lTrees = oSoft.getSoftwareTrees();
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree oTree = (Tree)lTrees.get(iTree);
            if (!oTree.getTreeType().equals("EnterpriseMinerModels")) continue;
            return oTree;
        }
        return null;
    }

    public static List getPath(Root oData) throws MdException, RemoteException {
        return MiningTreeUtilities.getPath(oData, (MdObjectStore)oData.getObjectStore());
    }

    public static List getPath(Root oData, MdObjectStore store) throws MdException, RemoteException {
        String sRepositoryFQID = "A0000001." + oData.getRepositoryID();
        Tree oRoot = MiningTreeUtilities.getRoot(sRepositoryFQID, store);
        if (oRoot == null) {
            return new ArrayList(0);
        }
        return MiningTreeUtilities.getPath(oData, oRoot, store);
    }

    public static List getPath(Root oData, Tree oRoot) throws MdException, RemoteException {
        return MiningTreeUtilities.getPath(oData, oRoot, (MdObjectStore)oData.getObjectStore());
    }

    public static List getPath(Root oData, Tree oRoot, MdObjectStore store) throws MdException, RemoteException {
        Object lTrees;
        StringBuffer sbTemplate = new StringBuffer(80);
        sbTemplate.append("<Templates>");
        sbTemplate.append("<Tree Name=\"\"><ParentTree/></Tree>");
        sbTemplate.append("</Templates>");
        ArrayList<String> lAttrs = new ArrayList<String>(1);
        boolean bTree = oData.getCMetadataType().equals("Tree");
        if (bTree) {
            lAttrs.add("ParentTree");
        } else {
            lAttrs.add("Trees");
        }
        int fFlags = 260;
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oData, null, lAttrs, sbTemplate.toString(), fFlags);
        if (bTree) {
            lTrees = new ArrayList(1);
            lTrees.add(oData);
        } else {
            lTrees = oData.getTrees();
        }
        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
            Tree oTree = (Tree)lTrees.get(iTree);
            List lPath = MiningTreeUtilities.getPathToRoot(oTree);
            Tree oPathRoot = (Tree)lPath.get(0);
            if (!oPathRoot.getFQID().equals(oRoot.getFQID())) continue;
            return lPath;
        }
        return new ArrayList();
    }

    private static List getPathToRoot(Tree oTree) throws MdException, RemoteException {
        ArrayList<Tree> lTreePath = new ArrayList<Tree>(2);
        while (oTree != null) {
            lTreePath.add(0, oTree);
            oTree = oTree.getParentTree();
        }
        return lTreePath;
    }
}

