/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.visuals.MiningModelInfoPanel;
import com.sas.wadmin.visuals.ObjectsSelectorTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MiningResultsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultsPropertyTab.class);
    private static final boolean g_bGotoServer = true;
    protected MdObjectStore m_oStore;
    protected TransformationStep m_mdTS;
    protected MiningResult m_mdMR;
    protected MiningResult m_mdFirstMR;
    protected ObjectsSelectorTreeModel m_mdlMRSelector;
    protected WsTree m_treeMRSelector;
    protected MiningModelInfoPanel m_pnlMRInfo;
    protected AssociationList m_alTargetColumnObjects;

    public MiningResultsPropertyTab(TransformationStep mdTS) {
        this.m_mdTS = mdTS;
        try {
            this.m_oStore = Workspace.getMdFactory().createObjectStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("mining_results_query_tab");
    }

    protected void initialize() {
        this.m_mdlMRSelector = new ObjectsSelectorTreeModel(this.m_oStore);
        String[] aTypes = new String[]{"MiningResult"};
        this.m_mdlMRSelector.setTypesToShow(aTypes);
        String[] titles = new String[]{bundle.getString("MiningResultsPropertyTab.AllMiningResults.Title.txt")};
        this.m_mdlMRSelector.setTreesToShow(2);
        this.m_mdlMRSelector.addInventoryNodes(titles, aTypes);
        this.m_treeMRSelector = new WsTree((DefaultTreeModel)((Object)this.m_mdlMRSelector));
        this.m_treeMRSelector.setEditable(false);
        this.m_treeMRSelector.setDefaultActionEnabled(false);
        this.m_treeMRSelector.getSelectionModel().setSelectionMode(1);
        this.m_treeMRSelector.getSelectionModel().addTreeSelectionListener(new cTreeSelectionListener());
        this.m_mdlMRSelector.addListenersToTree((JTree)this.m_treeMRSelector);
        JScrollPane scrObjectSelector = new JScrollPane((Component)this.m_treeMRSelector);
        scrObjectSelector.setPreferredSize(new Dimension(200, 200));
        JLabel lblSelect = WsUIUtilities.createLabelForComponent((JComponent)this.m_treeMRSelector, (WAdminResource)bundle, (String)"MiningResultsPropertyTab.treeMRSelector");
        this.m_pnlMRInfo = new MiningModelInfoPanel(true);
        this.setLayout(new GridBagLayout());
        this.add(lblSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrObjectSelector, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_pnlMRInfo), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_alTargetColumnObjects = null;
        List lSourceSpecs = this.getSourceSpecList();
        if (lSourceSpecs != null) {
            for (int i = 0; i < lSourceSpecs.size(); ++i) {
                CMetadata mdSourceSpec = (CMetadata)lSourceSpecs.get(i);
                if (!(mdSourceSpec instanceof MiningResult)) continue;
                this.m_mdFirstMR = this.m_mdMR = (MiningResult)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, mdSourceSpec);
                WsDataTreeNode tnNodeToSelect = this.m_mdlMRSelector.find((Root)this.m_mdMR, true);
                if (tnNodeToSelect != null) {
                    Object[] aPath = this.m_mdlMRSelector.getPathToRoot((TreeNode)tnNodeToSelect);
                    TreePath tpPath = new TreePath(aPath);
                    this.m_treeMRSelector.setSelectionPath(tpPath);
                }
                this.m_pnlMRInfo.setMiningResult(this.m_mdMR);
                break;
            }
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.hasDataChanged()) {
            List lSourceSpecs = this.getSourceSpecList();
            for (int i = lSourceSpecs.size() - 1; i >= 0; --i) {
                if (!(lSourceSpecs.get(i) instanceof MiningResult)) continue;
                lSourceSpecs.remove(i);
            }
            if (this.m_mdMR != null) {
                MiningResult newMiningResult = (MiningResult)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_mdTS.getObjectStore(), (CMetadata)this.m_mdMR);
                MdStoreUtil.copyObjectAttributes((CMetadata)this.m_mdMR, (CMetadata)newMiningResult, (int)2);
                if (!this.m_mdMR.equals(this.m_mdFirstMR)) {
                    AssociationList alCMs = this.m_mdTS.getTransformations();
                    int nCMs = alCMs.size();
                    for (int iCM = 0; iCM < nCMs; ++iCM) {
                        ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                        AssociationList lTargetTables = oCM.getClassifierTargets();
                        int nTargetTables = lTargetTables.size();
                        for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                            DataTable oTargetTable = (DataTable)lTargetTables.get(iTargetTable);
                            AssociationList alTargetColumnObjects = oTargetTable.getColumns();
                            ArrayList alOldTargetColumnObjects = new ArrayList(alTargetColumnObjects);
                            int nTargetColumnObjects = alOldTargetColumnObjects.size();
                            alTargetColumnObjects.removeAllElements();
                            for (int iTargetColumnObject = 0; iTargetColumnObject < nTargetColumnObjects; ++iTargetColumnObject) {
                                Column oTargetColumnObject = (Column)alOldTargetColumnObjects.get(iTargetColumnObject);
                                this.m_oStore.removeObjectFromStore((CMetadata)oTargetColumnObject, "<Column/>");
                            }
                        }
                        AssociationList alFMs = oCM.getFeatureMaps();
                        if (!alFMs.isEmpty()) continue;
                        DataTable oSource = null;
                        DataTable oRequiredInputTable = null;
                        AssociationList alSources = oCM.getClassifierSources();
                        int nSources = alSources.size();
                        for (int iSource = 0; iSource < nSources; ++iSource) {
                            oSource = (DataTable)alSources.get(iSource);
                        }
                        newMiningResult.getObjectStore().setIsGotToServerForMetadata(true);
                        AssociationList alRequiredInputTables = newMiningResult.getTransformationSources();
                        newMiningResult.getObjectStore().setIsGotToServerForMetadata(false);
                        if (!alRequiredInputTables.isEmpty()) {
                            oRequiredInputTable = (DataTable)alRequiredInputTables.get(0);
                            oRequiredInputTable.getColumns();
                        }
                        if (oSource == null || oRequiredInputTable == null) continue;
                        MappingUtil.quickMap(oSource, oRequiredInputTable, oCM);
                    }
                }
                lSourceSpecs.add(newMiningResult);
            }
            this.setDataChanged(false);
        }
    }

    public boolean validateData() {
        if (this.isListeningForChanges()) {
            boolean Valid = true;
            try {
                Valid = this.validateModelChange();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (Valid) {
                this.updateInfoPanel();
                this.setDataChanged(true);
            }
        }
        return true;
    }

    public boolean validateModelChange() throws MdException, RemoteException {
        MiningResult mdMR;
        CMetadata mdSelectedObject;
        WsTreeNode tnSelectedMR = this.m_treeMRSelector.getSelectedNode();
        if (tnSelectedMR != null && (mdSelectedObject = tnSelectedMR.getMetadata()) != null && mdSelectedObject instanceof MiningResult && !(mdMR = (MiningResult)mdSelectedObject).equals(this.m_mdFirstMR)) {
            int eAnswer;
            AssociationList alCMs = this.m_mdTS.getTransformations();
            this.m_alTargetColumnObjects = null;
            int nCMs = alCMs.size();
            for (int iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                AssociationList lTargetTables = oCM.getClassifierTargets();
                int nTargetTables = lTargetTables.size();
                for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                    DataTable oTargetTable = (DataTable)lTargetTables.get(iTargetTable);
                    this.m_alTargetColumnObjects = oTargetTable.getColumns();
                }
            }
            if (!this.m_alTargetColumnObjects.isEmpty() && (eAnswer = MessageUtil.displayMessage((String)bundle.getString("MiningResultsPropertyTab.ChangedMiningResultsModelMessage.txt"), (String)bundle.getString("MiningResultsPropertyTab.ChangedMiningResultsModelTitle.txt"), (int)2, (int)0)) != 0) {
                if (this.m_mdFirstMR != null) {
                    WsDataTreeNode tnNodeToSelect = this.m_mdlMRSelector.find((Root)this.m_mdFirstMR, true);
                    Object[] aPath = this.m_mdlMRSelector.getPathToRoot((TreeNode)tnNodeToSelect);
                    TreePath tpPath = new TreePath(aPath);
                    this.m_treeMRSelector.setSelectionPath(tpPath);
                } else {
                    this.m_treeMRSelector.clearSelection();
                }
                return false;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_treeMRSelector.setEnabled(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        try {
            this.m_oStore.dispose();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected List getSourceSpecList() throws MdException, RemoteException {
        AssociationList lTransformations = this.m_mdTS.getTransformations();
        if (!lTransformations.isEmpty()) {
            ClassifierMap map = (ClassifierMap)lTransformations.get(0);
            return map.getSourceSpecifications();
        }
        return null;
    }

    protected void updateInfoPanel() {
        try {
            CMetadata mdSelectedObject;
            WsTreeNode tnSelectedMR = this.m_treeMRSelector.getSelectedNode();
            if (tnSelectedMR != null && (mdSelectedObject = tnSelectedMR.getMetadata()) != null && mdSelectedObject instanceof MiningResult) {
                this.m_mdMR = (MiningResult)mdSelectedObject;
                this.m_pnlMRInfo.setMiningResult(this.m_mdMR);
                return;
            }
            this.m_mdMR = null;
            this.m_pnlMRInfo.setMiningResult(null);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected class cTreeSelectionListener
    implements TreeSelectionListener {
        protected cTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            if (MiningResultsPropertyTab.this.isListeningForChanges()) {
                MiningResultsPropertyTab.this.updateInfoPanel();
                MiningResultsPropertyTab.this.setDataChanged(true);
            }
        }
    }
}

