/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.model.MiningResultsTargetColumnsTableModel;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.MappingsPropertyTab;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.undo.UndoManager;

public class MiningResultsMappingsPropertyTab
extends MappingsPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningResultsMappingsPropertyTab.class);
    private static final boolean g_bGotoServer = true;
    protected boolean m_bHasFM = false;

    public MiningResultsMappingsPropertyTab(TransformationStep oTS) {
        super(oTS, "MiningResults", false, false, false, false, false);
        this.setHelpTopic("mapping_tab_mresults");
        this.setHelpProduct("shared");
    }

    @Override
    protected void createTargetTable() {
        this.m_mdlTarget = new MiningResultsTargetColumnsTableModel();
        this.m_mdlTarget.setTransformationStep(this.m_oTS);
        this.m_mdlTarget.addTableModelListener(this.m_lsnrTargetTableModel);
        this.m_tblTarget = new WsTable((WsAbstractTableModel)this.m_mdlTarget);
        this.m_tblTarget.setName("Required Inputs");
        this.removeTargetTableColumns();
        this.m_tblTarget.setMultipleSelectionDragEnabled(true);
        this.m_tblTarget.setUndoManager((UndoManager)this.m_TargetTableUndoManager);
        this.m_tblTarget.setTablePopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.setViewportPopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        ((WsDefaultTableRowModel)this.m_tblTarget.getRowModel()).addRowModelListener(this.m_lsnrTargetTableRowModel);
        this.m_tblTarget.getActionMap().put(this.m_actSelectAllColumns, (Action)this.m_actSelectAllColumns);
        this.m_tblTarget.getActionMap().put(this.m_actDeleteColumns, (Action)this.m_actDeleteColumns);
        this.m_tblTarget.getInputMap().put(KeyStroke.getKeyStroke(65, 2), this.m_actSelectAllColumns);
        this.m_tblTarget.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDeleteColumns);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(7);
        int iColumnName = this.m_tblTarget.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_tblTarget.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        int iExpression = this.m_tblTarget.convertColumnIndexToView(1);
        if (iExpression > 0) {
            WsDialogTableCellEditor edtExpression = new WsDialogTableCellEditor();
            edtExpression.setDialog((WsDialogTableCellEditorInterface)new MappingsPropertyTab.cExpressionDialog());
            edtExpression.setStopEditingOnDialogClose(true);
            TableColumn colExpression = this.m_tblTarget.getColumnModel().getColumn(iExpression);
            colExpression.setCellEditor((TableCellEditor)edtExpression);
        }
        this.m_tblTarget.restoreSettings("MiningResultsMappingsPropertyTab." + this.m_sSettingsKey + ".TargetTable");
        this.m_scrTarget = new JScrollPane((Component)this.m_tblTarget);
        this.m_scrTarget.setMinimumSize(new Dimension(50, 150));
        this.m_scrTarget.setPreferredSize(new Dimension(200, 200));
        this.m_lblTarget = new JLabel(bundle.getString("MiningResultsMappingsPropertyTab.TargetTables.txt"));
        this.m_lblTarget.setDisplayedMnemonic(bundle.getString("MiningResultsMappingsPropertyTab.TargetTables.mnem").charAt(0));
        this.m_lblTarget.setLabelFor((Component)this.m_tblTarget);
        Dimension dimLabel = this.m_lblTarget.getPreferredSize();
        this.m_lblTarget.setMinimumSize(new Dimension(50, dimLabel.height));
        this.m_lblTarget.setPreferredSize(new Dimension(200, dimLabel.height));
    }

    @Override
    protected void updateTableLabel(JLabel lblTable, List lDataTables, String sKey) {
        String sLabel;
        if (lDataTables.size() == 0) {
            sLabel = "";
        } else {
            DataTable oDataTable = (DataTable)lDataTables.get(0);
            String sDataTable = TransformationTargetColumnsTableModel.getDataTableDisplayName(oDataTable);
            sLabel = bundle.formatString("MiningResultsMappingsPropertyTab." + sKey + "Table.fmt", (Object)sDataTable);
        }
        lblTable.setText(sLabel);
    }

    @Override
    public boolean validateData() {
        if (!this.m_tblTarget.stopCellEditing()) {
            return false;
        }
        boolean bRequiredInputsMapped = true;
        int iExpressionCol = this.m_tblTarget.convertColumnIndexToView(1);
        String sDerived = TransformationTargetColumnsTableModel.getViewMappingTypeString(2);
        String sUnmapped = TransformationTargetColumnsTableModel.getViewMappingTypeString(0);
        int nRows = this.m_mdlTarget.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            String sExpression;
            String sMappingType = (String)this.m_mdlTarget.getValueAt(iRow, 6);
            if (sMappingType.equals(sUnmapped)) {
                bRequiredInputsMapped = false;
            }
            if ((sExpression = (String)this.m_mdlTarget.getValueAt(iRow, 1)).trim().length() == 0) {
                if (!sMappingType.equals(sDerived)) continue;
                MessageUtil.displayMessage((String)bundle.getString("MiningResultsMappingPropertyTab.DerivedRequiresExpressionError.txt"), (int)0);
                iRow = this.m_tblTarget.convertRowIndexToView(iRow);
                this.m_tblTarget.selectCell(iRow, iExpressionCol);
                this.m_tblTarget.editCellAt(iRow, iExpressionCol);
                return false;
            }
            if (sExpression.trim().length() == 0 || this.autoMapColumnsFromExpression(iRow, sExpression, true)) continue;
            iRow = this.m_tblTarget.convertRowIndexToView(iRow);
            this.m_tblTarget.selectCell(iRow, iExpressionCol);
            return false;
        }
        if (!bRequiredInputsMapped) {
            MessageUtil.displayMessage((String)bundle.getString("MiningResultsMappingPropertyTab.AllRequiredInputsMustBeMapped.txt"), (int)2);
        }
        if (this.m_bOrderChanged && !this.m_tblTarget.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("MiningResultsMappingPropertyTab.SaveOrderMessage.txt"), (String)bundle.getString("MiningResultsMappingPropertyTab.SaveOrderTitle.txt"), (int)2, (int)1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_tblTarget.getRowModel();
        this.m_mdlTarget.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    @Override
    protected String validateMapping(int iSource, int iTarget) {
        String sTargetType;
        String sSourceType = (String)this.m_mdlSource.getValueAt(iSource, 4);
        if (!sSourceType.equals(sTargetType = (String)this.m_mdlTarget.getValueAt(iTarget, 7))) {
            return "DifferentTypes";
        }
        Integer iSourceLength = (Integer)this.m_mdlSource.getValueAt(iSource, 5);
        Integer iTargetLength = (Integer)this.m_mdlTarget.getValueAt(iTarget, 8);
        if (iSourceLength > iTargetLength) {
            return "ShorterTarget";
        }
        return null;
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.m_bHasFM = false;
        this.m_tblTarget.cancelCellEditing();
        this.setListeningForChanges(false);
        this.m_pnlMappings.removeAllMappings();
        this.m_mdlSource.moveDataToModel();
        this.m_mdlTarget.moveDataToModel();
        List lSourceTables = this.m_mdlSource.getDataTables();
        if (!this.m_bMultipleSources) {
            this.updateTableLabel(this.m_lblSource, lSourceTables, "Source");
        }
        this.m_bUsesQuotes = false;
        this.m_bCaseSensitive = false;
        int nSourceTables = lSourceTables.size();
        for (int iSourceTable = 0; iSourceTable < nSourceTables; ++iSourceTable) {
            DataTable oSourceTable = (DataTable)lSourceTables.get(iSourceTable);
            if (!DBMSNamesPropertyHandler.needQuotes((DataTable)oSourceTable)) continue;
            this.m_bUsesQuotes = true;
            this.m_bCaseSensitive = true;
            break;
        }
        List lTargetTables = this.m_mdlTarget.getDataTables();
        if (!this.m_bMultipleTargets) {
            this.updateTableLabel(this.m_lblTarget, lTargetTables, "Target");
        }
        this.m_bEditableTargetTables = true;
        int nTargetTables = lTargetTables.size();
        for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
            DataTable oTargetTable = (DataTable)lTargetTables.get(iTargetTable);
            if (!oTargetTable.getCMetadataType().equals("PhysicalTable") && !oTargetTable.getCMetadataType().equals("RelationalTable")) continue;
            this.m_bEditableTargetTables = false;
            break;
        }
        this.m_mdlTarget.getColumn(3).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(0).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(2).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(7).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(8).setEditable(this.m_bEditableTargetTables);
        int nTargetColumns = this.m_mdlTarget.getRowCount();
        for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
            FeatureMap oFM = (FeatureMap)this.m_mdlTarget.getValueAt(iTargetColumn, 12);
            if (oFM == null) continue;
            this.m_bHasFM = true;
            AssociationList alSourceColumns = oFM.getFeatureSources();
            int nSourceColumns = alSourceColumns.size();
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                Column oSourceColumn = (Column)alSourceColumns.get(iSourceColumn);
                int[] aRows = this.m_mdlSource.findRows(8, oSourceColumn);
                if (aRows.length < 1) continue;
                WsMapping map = new WsMapping(aRows[0], iTargetColumn, (Object)oFM);
                this.m_pnlMappings.addMapping(map);
            }
        }
        if (nTargetColumns > 0) {
            this.m_tblTarget.selectCell(0, 0);
        }
        if (this.m_tblSource.getRowCount() > 0) {
            this.m_tblSource.selectCell(0, 0);
            this.m_tblSource.requestFocus();
        }
        if (!this.m_bHasFM) {
            this.setListeningForChanges(true);
            this.quickMap();
        }
        this.m_tblTarget.clearSortMemory();
        this.setListeningForChanges(true);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        FeatureMap oFM;
        int iCM;
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_mdlTarget.moveDataToStore();
        String sUnmapped = TransformationTargetColumnsTableModel.getViewMappingTypeString(0);
        String sOneToOne = TransformationTargetColumnsTableModel.getViewMappingTypeString(1);
        String sManyToOne = TransformationTargetColumnsTableModel.getViewMappingTypeString(3);
        String sOneToOneRole = "ONETOONE";
        String sDerivedRole = "DERIVED";
        String sManyToOneRole = "MANYTOONE";
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        MdObjectStore store = (MdObjectStore)this.m_oTS.getObjectStore();
        ArrayList<Object> lTargetTables = new ArrayList<Object>();
        ArrayList<ClassifierMap> lClassifierMaps = new ArrayList<ClassifierMap>();
        AssociationList alCMs = this.m_oTS.getTransformations(false);
        int nCMs = alCMs.size();
        AssociationList[] aFMLists = new AssociationList[nCMs];
        List[] aOldFMLists = new List[nCMs];
        for (iCM = 0; iCM < nCMs; ++iCM) {
            ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
            aFMLists[iCM] = oCM.getFeatureMaps(false);
            aOldFMLists[iCM] = new ArrayList(aFMLists[iCM]);
            aFMLists[iCM].removeAllElements();
            AssociationList alSourceSpecifications = oCM.getSourceSpecifications();
            int nMiningResults = alSourceSpecifications.size();
            for (int iMiningResult = 0; iMiningResult < nMiningResults; ++iMiningResult) {
                MiningResult oMiningResult;
                AssociationList alRequiredInputTables;
                Root oRoot = (Root)alSourceSpecifications.get(iMiningResult);
                if (!(oRoot instanceof MiningResult) || (alRequiredInputTables = (oMiningResult = (MiningResult)oRoot).getTransformationSources()).isEmpty()) continue;
                lTargetTables.add(alRequiredInputTables.get(0));
                lClassifierMaps.add(oCM);
            }
        }
        int nRows = this.m_mdlTarget.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            String sMappingType = (String)this.m_mdlTarget.getValueAt(iRow, 6);
            if (!sMappingType.equals(sUnmapped)) {
                Column oTarget = (Column)this.m_mdlTarget.getValueAt(iRow, 11);
                oFM = (FeatureMap)this.m_mdlTarget.getValueAt(iRow, 12);
                if (oFM == null) {
                    oFM = (FeatureMap)factory.createComplexMetadataObject(store, sMappingType, "FeatureMap", this.m_oTS.getRepositoryID());
                    oFM.getFeatureTargets(false).add((Object)oTarget);
                    this.m_mdlTarget.setValueAt(oFM, iRow, 12);
                }
                if (!oFM.getName().equals(sMappingType)) {
                    oFM.setName(sMappingType);
                }
                String sRole = sMappingType.equals(sOneToOne) ? sOneToOneRole : (sMappingType.equals(sManyToOne) ? sManyToOneRole : sDerivedRole);
                if (!oFM.getTransformRole().equals(sRole)) {
                    oFM.setTransformRole(sRole);
                }
                AssociationList alSourceColumns = oFM.getFeatureSources(false);
                alSourceColumns.removeAllElements();
                List lMappings = this.m_pnlMappings.findMappingsForRow(iRow, false);
                int nMappings = lMappings.size();
                for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
                    WsMapping mapping = (WsMapping)lMappings.get(iMapping);
                    Column oSource = (Column)this.m_mdlSource.getValueAt(mapping.getSource(), 8);
                    alSourceColumns.add((Object)oSource);
                }
                String sExpression = (String)this.m_mdlTarget.getValueAt(iRow, 1);
                TextStore oExpression = (TextStore)oFM.getSourceCode();
                if (sExpression.length() > 0) {
                    String sParsedExpression = ExpressionParser.tokenizeString((String)sExpression, (List)alSourceColumns, (AbstractTransformation)oFM, (boolean)this.m_bUsesQuotes, (boolean)this.m_bCaseSensitive);
                    if (oExpression == null) {
                        oExpression = (TextStore)factory.createComplexMetadataObject(store, "FeatureMapExpression", "TextStore", this.m_oTS.getRepositoryID());
                        oExpression.setTextRole("FeatureMapExpression");
                        oExpression.setStoredText(sParsedExpression);
                        oFM.setSourceCode((Text)oExpression);
                    } else if (!oExpression.getStoredText().equals(sParsedExpression)) {
                        oExpression.setStoredText(sParsedExpression);
                    }
                } else if (oExpression != null) {
                    store.removeObjectFromStore((CMetadata)oExpression, null);
                    store.removeObjectsFromStore((List)oFM.getSubstitutionVariables());
                }
                int iTargetTable = lTargetTables.indexOf(oTarget.getTable());
                ClassifierMap oCM = (ClassifierMap)lClassifierMaps.get(iTargetTable);
                iCM = lClassifierMaps.indexOf(oCM);
                aFMLists[iCM].add((Object)oFM);
                if (!aOldFMLists[iCM].contains(oFM)) continue;
                aOldFMLists[iCM].remove(oFM);
                continue;
            }
            this.m_mdlTarget.setValueAt(null, iRow, 12);
        }
        for (iCM = 0; iCM < nCMs; ++iCM) {
            int nFMs = aOldFMLists[iCM].size();
            for (int iFM = 0; iFM < nFMs; ++iFM) {
                oFM = (FeatureMap)aOldFMLists[iCM].get(iFM);
                if (oFM.getIsUserDefined() == 0) {
                    store.removeObjectFromStore((CMetadata)oFM, "<FeatureMap><SourceCode/><SubstitutionVariables/></FeatureMap>");
                    continue;
                }
                aFMLists[iCM].add((Object)oFM);
            }
        }
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlMappings.setDraggingFromSourceTableEnabled(bEditable);
        this.m_pnlMappings.setDraggingFromTargetTableEnabled(bEditable);
        this.m_tblTarget.setEditable(false);
        this.updateActions();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_tblSource.saveSettings("MiningResultsMappingsPropertyTab." + this.m_sSettingsKey + ".SourceTable");
        this.m_tblTarget.saveSettings("MiningResultsMappingsPropertyTab." + this.m_sSettingsKey + ".TargetTable");
    }

    @Override
    protected void updateActions() {
        if (this.m_bIgnoreActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable();
        boolean bFirst = false;
        boolean bLast = false;
        boolean bNoMappings = true;
        int[] aSelectedSourceRows = this.m_tblSource.getSelectedRowsFromSelectedCells();
        int[] aSelectedTargetRows = this.m_tblTarget.getSelectedRowsFromSelectedCells();
        int nSelectedSourceRows = aSelectedSourceRows.length;
        int nSelectedTargetRows = aSelectedTargetRows.length;
        int nTargetRows = this.m_tblTarget.getRowCount();
        int nSourceRows = this.m_tblSource.getRowCount();
        for (int iSelectedTargetRow = 0; iSelectedTargetRow < nSelectedTargetRows; ++iSelectedTargetRow) {
            int iTarget = aSelectedTargetRows[iSelectedTargetRow];
            if (iTarget == 0) {
                bFirst = true;
            }
            if (iTarget == nTargetRows - 1) {
                bLast = true;
            }
            if (bFirst && bLast) break;
        }
        if (nSelectedTargetRows == 1) {
            this.m_tblSource.convertRowIndexesToModel(aSelectedSourceRows);
            this.m_tblTarget.convertRowIndexesToModel(aSelectedTargetRows);
            WsMapping map = new WsMapping(0, aSelectedTargetRows[0]);
            for (int iSelectedSourceRow = 0; iSelectedSourceRow < nSelectedSourceRows; ++iSelectedSourceRow) {
                map.setSource(aSelectedSourceRows[iSelectedSourceRow]);
                if (!this.m_pnlMappings.mappingExists(map)) continue;
                bNoMappings = false;
                break;
            }
        }
        int nMappings = this.m_pnlMappings.getMappingsCount();
        int nSelectedMappings = this.m_pnlMappings.getSelectedMappings().size();
        boolean bNewMapping = this.m_bMultipleSourceColumnsEnabled ? nSelectedSourceRows >= 1 : nSelectedSourceRows == 1;
        this.m_actNewColumn.setEnabled(false);
        this.m_actNewMapping.setEnabled(bEditable && !this.m_bExpanded && bNewMapping && nSelectedTargetRows == 1 && bNoMappings);
        this.m_actDeleteMappings.setEnabled(bEditable && !this.m_bExpanded && nSelectedMappings > 0);
        this.m_actDeleteColumns.setEnabled(false);
        this.m_actCommonDelete.setEnabled(this.m_actDeleteMappings.isEnabled() || this.m_actDeleteColumns.isEnabled());
        this.m_actSelectAll.setEnabled(bEditable && !this.m_bExpanded && nMappings >= 1);
        this.m_actSelectAllColumns.setEnabled(bEditable && !this.m_bExpanded && nTargetRows >= 1);
        this.m_actQuickMap.setEnabled(bEditable && !this.m_bExpanded && nSourceRows > 0);
        this.m_actExpression.setEnabled(false);
        this.m_actImport.setEnabled(false);
        this.m_actQuickPropagate.setEnabled(false);
    }

    protected class cExtendedObjectsSelector
    extends ObjectsSelectorPanel {
        private List m_lTargetTables;
        private WAComboBox m_cmbTargetTables;
        private JLabel m_lblTargetTables;

        public cExtendedObjectsSelector(List lTargetTables) {
            super(Workspace.getWorkspace().getUserContext(), 4);
            this.m_lTargetTables = lTargetTables;
            this.m_cmbTargetTables = new WAComboBox();
            this.m_cmbTargetTables.addItem((Object)bundle.getString("MiningResultsMappingsPropertyTab.cExtendedObjectsSelector.All.txt"));
            int nTargetTables = this.m_lTargetTables.size();
            for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)this.m_lTargetTables.get(iTargetTable);
                String sTargetTable = MiningResultsTargetColumnsTableModel.getDataTableDisplayName(oTargetTable);
                this.m_cmbTargetTables.addItem((Object)sTargetTable);
            }
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbTargetTables, (WAdminResource)bundle, (String)"MiningResultsMappingsPropertyTab.cExtendedObjectsSelector.TargetTables");
            this.add(this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)this.m_cmbTargetTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        }

        public List getSelectedTables() {
            if (this.m_cmbTargetTables.getSelectedIndex() == 0) {
                return this.m_lTargetTables;
            }
            ArrayList lTargetTables = new ArrayList(1);
            lTargetTables.add(this.m_lTargetTables.get(this.m_cmbTargetTables.getSelectedIndex() - 1));
            return lTargetTables;
        }
    }

    protected class cTargetTableModelListener
    implements TableModelListener {
        protected cTargetTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (MiningResultsMappingsPropertyTab.this.isListeningForChanges()) {
                MiningResultsMappingsPropertyTab.this.setDataChanged(true);
            }
            if (e.getType() == 0) {
                int iRow = e.getFirstRow();
                int iCol = e.getColumn();
                block1 : switch (iCol) {
                    case 3: {
                        try {
                            String sTable = (String)MiningResultsMappingsPropertyTab.this.m_mdlTarget.getValueAt(iRow, iCol);
                            List lTables = MiningResultsMappingsPropertyTab.this.m_mdlTarget.getDataTables();
                            int nTables = lTables.size();
                            for (int iTable = 0; iTable < nTables; ++iTable) {
                                DataTable tbl = (DataTable)lTables.get(iTable);
                                TransformationTargetColumnsTableModel cfr_ignored_0 = MiningResultsMappingsPropertyTab.this.m_mdlTarget;
                                if (!TransformationTargetColumnsTableModel.getDataTableDisplayName(tbl).equals(sTable)) continue;
                                TransformationTargetColumnsTableModel cfr_ignored_1 = MiningResultsMappingsPropertyTab.this.m_mdlTarget;
                                MiningResultsMappingsPropertyTab.this.m_mdlTarget.setValueAt(tbl.getDesc(), iRow, 4);
                                break block1;
                            }
                            break;
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                            break;
                        }
                    }
                    case 1: {
                        MiningResultsMappingsPropertyTab.this.updateMappingType(iRow);
                        TransformationTargetColumnsTableModel cfr_ignored_2 = MiningResultsMappingsPropertyTab.this.m_mdlTarget;
                        String sExpression = (String)MiningResultsMappingsPropertyTab.this.m_mdlTarget.getValueAt(iRow, 1);
                        MiningResultsMappingsPropertyTab.this.autoMapColumnsFromExpression(iRow, sExpression, false);
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (MiningResultsMappingsPropertyTab.this.updateMappingType(iRow)) break;
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                MiningResultsMappingsPropertyTab.this.m_TargetTableUndoManager.undo();
                            }
                        };
                        SwingUtilities.invokeLater(run);
                    }
                }
            }
        }
    }
}

