/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.model.TransformationSourceColumnsTableModel;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.QuickPropagateSelectorPanel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsLimitedPlainDocument;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsObjectListModelEvent;
import com.sas.workspace.WsObjectListModelListener;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableMappingsPanel;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class MappingsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(MappingsPropertyTab.class);
    private static final boolean g_bGotoServer = true;
    protected WAUndoManager m_TargetTableUndoManager = new WAUndoManager();
    protected static final int MIN_TABLE_WIDTH = 50;
    protected static final int MIN_TABLE_HEIGHT = 150;
    protected static final int PREF_TABLE_WIDTH = 200;
    protected static final int PREF_TABLE_HEIGHT = 200;
    protected static final int MIN_MAPPINGS_WIDTH = 20;
    protected static final int MIN_MAPPINGS_HEIGHT = 150;
    protected static final int PREF_MAPPINGS_WIDTH = 50;
    protected static final int PREF_MAPPINGS_HEIGHT = 200;
    private static final int BORDER_WIDTH = 4;
    private static final int DIVIDER_WIDTH = 3;
    private static final int MIN_WIDTH = 120;
    private static final int MEDIUM_WIDTH = 420;
    private static final int PREF_WIDTH = 450;
    public static final int UNKNOWN_TRANSFORMATION = 0;
    public static final int JOIN_TRANSFORMATION = 1;
    public static final int SPLITTER_TRANSFORMATION = 2;
    public static final int EXTRACT_TRANSFORMATION = 3;
    public static final int SORT_TRANSFORMATION = 4;
    public static final int LOADER_TRANSFORMATION = 5;
    public static final int USERWRITTEN_TRANSFORMATION = 6;
    protected TransformationStep m_oTS;
    protected DataTable m_oSourceTable;
    protected DataTable m_oTargetTable;
    private List m_lSrcTables;
    private List m_lTgtTables;
    protected AssociationList m_lFeatureMaps;
    protected String m_sRole;
    protected List m_lTargetColumns;
    protected PhysicalTable m_newTargetTable;
    protected List m_lQuickPropagateSources;
    protected String m_sSettingsKey;
    private String m_sDividerLocationsKey;
    protected boolean m_bExpressionsEnabled;
    protected boolean m_bGroupByEnabled;
    protected boolean m_bMultipleSources;
    protected boolean m_bMultipleTargets;
    protected boolean m_bEditableTargetTables;
    protected boolean m_bMultipleSourceColumnsEnabled;
    protected boolean m_bFeatureMapListProvided;
    private boolean m_bFlushNonWorkTables;
    private boolean m_bEditNonWorkTables;
    protected TransformationSourceColumnsTableModel m_mdlSource;
    protected TransformationTargetColumnsTableModel m_mdlTarget;
    protected List m_lSourceColumns;
    protected boolean m_bUsesQuotes;
    protected boolean m_bCaseSensitive;
    protected WsTable m_tblSource;
    protected WsTable m_tblTarget;
    protected JScrollPane m_scrSource;
    protected JScrollPane m_scrTarget;
    protected JLabel m_lblSource;
    protected JLabel m_lblTarget;
    private JPanel m_pnlSource;
    private JPanel m_pnlTarget;
    protected WsTableMappingsPanel m_pnlMappings;
    private JLabel m_lblMappings;
    private JPanel m_pnlCenter;
    protected JButton m_btnExpand;
    protected JButton m_btnCollapse;
    private JSplitPane m_splInner;
    private JSplitPane m_splOuter;
    private JToolBar m_barButtons;
    protected ListSelectionListener m_lsnrTableSelection;
    protected TableModelListener m_lsnrTargetTableModel;
    protected WsTableRowModelListener m_lsnrTargetTableRowModel;
    protected WsObjectListModelListener m_lsnrMappingsModel;
    protected WsObjectSelectionListener m_lsnrMappingsSelection;
    protected WsPopupMenuRequestListener m_lsnrSourceTablePopup;
    protected WsPopupMenuRequestListener m_lsnrTargetTablePopup;
    protected WsPopupMenuRequestListener m_lsnrMappingsPanelPopup;
    protected WsAbstractAction m_actNewMapping;
    protected WsAbstractAction m_actNewColumn;
    protected WsAbstractAction m_actCommonDelete;
    protected WsAbstractAction m_actDeleteColumns;
    protected WsAbstractAction m_actDeleteMappings;
    protected WsAbstractAction m_actExpand;
    protected WsAbstractAction m_actCollapse;
    protected WsAbstractAction m_actSelectAll;
    protected WsAbstractAction m_actSelectAllColumns;
    protected WsAbstractAction m_actExpression;
    protected WsAbstractAction m_actQuickMap;
    protected WsAbstractAction m_actImport;
    protected WsAbstractAction m_actQuickPropagate;
    protected ArrayList m_alSavedFeatures;
    protected boolean m_bExpanded;
    protected boolean m_bIgnoreActionUpdates;
    protected boolean m_bOrderChanged;
    protected String m_sLookupLabelOverride;
    private boolean m_bFlushRequired;
    private boolean m_bSplitLocationSet;

    public MappingsPropertyTab() {
    }

    public MappingsPropertyTab(TransformationStep oTS) {
        this(oTS, 0);
    }

    public MappingsPropertyTab(TransformationStep oTS, int eTransformation) {
        switch (eTransformation) {
            case 1: {
                this.construct(oTS, "Join", true, false, true, false);
                break;
            }
            case 2: {
                this.construct(oTS, "Splitter", false, true, false, false);
                break;
            }
            case 3: {
                this.construct(oTS, "Extract", false, false, true, false);
                break;
            }
            case 4: {
                this.construct(oTS, "Sort", false, false, false, false);
                break;
            }
            case 5: {
                this.construct(oTS, "Loader", false, false, true, false);
                break;
            }
            case 6: {
                this.construct(oTS, "UserWritten", false, false, true, false);
                break;
            }
            default: {
                this.construct(oTS, "Unknown", false, false, false, false);
            }
        }
    }

    public MappingsPropertyTab(TransformationStep oTS, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled) {
        this.construct(oTS, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled);
    }

    public MappingsPropertyTab(TransformationStep oTS, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.construct(oTS, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bMultipleSourceColumnsEnabled);
    }

    public MappingsPropertyTab(TransformationStep oTS, List lSourceTables, List lTargetTables, AssociationList lFeatureMaps, String sRole, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.construct(oTS, lSourceTables, lTargetTables, lFeatureMaps, sRole, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bMultipleSourceColumnsEnabled);
    }

    public MappingsPropertyTab(TransformationStep oTS, DataTable oSourceTable, DataTable oTargetTable, AssociationList lFeatureMaps, String sRole, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.construct(oTS, oSourceTable, oTargetTable, lFeatureMaps, sRole, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bMultipleSourceColumnsEnabled);
    }

    protected void construct(TransformationStep oTS, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled) {
        this.construct(oTS, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bExpressionsEnabled);
    }

    protected void construct(TransformationStep oTS, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.m_oTS = oTS;
        this.m_sSettingsKey = sSettingsKey;
        this.m_bMultipleSources = bMultipleSources;
        this.m_bMultipleTargets = bMultipleTargets;
        this.m_bExpressionsEnabled = bExpressionsEnabled;
        this.m_bGroupByEnabled = bGroupByEnabled;
        this.m_bMultipleSourceColumnsEnabled = bMultipleSourceColumnsEnabled;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("mapping_tab");
        this.setHelpProduct("shared");
    }

    protected void construct(TransformationStep oTS, DataTable oSourceTable, DataTable oTargetTable, AssociationList lFeatureMaps, String sRole, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.m_oSourceTable = oSourceTable;
        this.m_oTargetTable = oTargetTable;
        ArrayList<DataTable> lSourceTables = new ArrayList<DataTable>(1);
        if (oSourceTable != null) {
            lSourceTables.add(oSourceTable);
        }
        ArrayList<DataTable> lTargetTables = new ArrayList<DataTable>(1);
        if (oTargetTable != null) {
            lTargetTables.add(oTargetTable);
        }
        this.construct(oTS, lSourceTables, lTargetTables, lFeatureMaps, sRole, sSettingsKey, bMultipleSources, bMultipleTargets, bExpressionsEnabled, bGroupByEnabled, bMultipleSourceColumnsEnabled);
    }

    protected void construct(TransformationStep oTS, List lSourceTables, List lTargetTables, AssociationList lFeatureMaps, String sRole, String sSettingsKey, boolean bMultipleSources, boolean bMultipleTargets, boolean bExpressionsEnabled, boolean bGroupByEnabled, boolean bMultipleSourceColumnsEnabled) {
        this.m_oTS = oTS;
        this.m_lSrcTables = lSourceTables;
        this.m_lTgtTables = lTargetTables;
        this.m_lFeatureMaps = lFeatureMaps;
        this.m_sRole = sRole;
        this.m_sSettingsKey = sSettingsKey;
        this.m_bMultipleSources = bMultipleSources;
        this.m_bMultipleTargets = bMultipleTargets;
        this.m_bExpressionsEnabled = bExpressionsEnabled;
        this.m_bGroupByEnabled = bGroupByEnabled;
        this.m_bMultipleSourceColumnsEnabled = bMultipleSourceColumnsEnabled;
        this.m_bFeatureMapListProvided = true;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("mapping_tab");
        this.setHelpProduct("shared");
    }

    protected void initialize() {
        this.createActions();
        this.createListeners();
        this.createExpandCollapseComponents();
        this.createSourceTable();
        this.createTargetTable();
        this.createMappingsPanel();
        this.createLayoutPanels();
        this.setDividerLocationsKey("MappingsPropertyTab");
    }

    protected void createExpandCollapseComponents() {
        this.m_btnExpand = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpand);
        this.m_btnCollapse = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapse);
        this.m_btnExpand.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnCollapse.setMargin(new Insets(0, 0, 0, 0));
    }

    protected TransformationSourceColumnsTableModel createSourceTableModel() {
        return new TransformationSourceColumnsTableModel();
    }

    protected TransformationTargetColumnsTableModel createTargetTableModel() {
        return new TransformationTargetColumnsTableModel();
    }

    protected void createSourceTable() {
        this.m_mdlSource = this.createSourceTableModel();
        if (this.m_bFeatureMapListProvided) {
            this.m_mdlSource.setTables(this.m_lSrcTables);
        } else {
            this.m_mdlSource.setTransformationStep(this.m_oTS);
            try {
                if (this.m_oTS.getTransformRole().equals("LOOKUP") || this.m_oTS.getTransformRole().equals("Contents")) {
                    this.m_mdlSource.setOnlyLoadFirstTable(true);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        this.m_tblSource = new WsTable((WsAbstractTableModel)this.m_mdlSource);
        this.m_tblSource.setName("Source");
        this.removeSourceTableColumns();
        this.m_tblSource.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        this.m_tblSource.setEditable(false);
        this.m_tblSource.setMultipleSelectionDragEnabled(this.m_bMultipleSourceColumnsEnabled);
        this.m_tblSource.setTablePopupMenuRequestListener(this.m_lsnrSourceTablePopup);
        this.m_tblSource.setViewportPopupMenuRequestListener(this.m_lsnrSourceTablePopup);
        this.m_tblSource.getActionMap().put(this.m_actSelectAll, (Action)this.m_actSelectAll);
        this.m_tblSource.getActionMap().put(this.m_actDeleteMappings, (Action)this.m_actDeleteMappings);
        this.m_tblSource.getInputMap().put(KeyStroke.getKeyStroke(65, 2), this.m_actSelectAll);
        this.m_tblSource.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDeleteMappings);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(4);
        int iColumnName = this.m_tblSource.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_tblSource.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        this.m_tblSource.restoreSettings("MappingsPropertyTab." + this.m_sSettingsKey + ".SourceTable");
        this.m_scrSource = new JScrollPane((Component)this.m_tblSource);
        this.m_scrSource.setMinimumSize(new Dimension(50, 150));
        this.m_scrSource.setPreferredSize(new Dimension(200, 200));
        this.m_lblSource = new JLabel(bundle.getString("MappingsPropertyTab.SourceTables.txt"));
        this.m_lblSource.setDisplayedMnemonic(bundle.getString("MappingsPropertyTab.SourceTables.mnem").charAt(0));
        this.m_lblSource.setLabelFor((Component)this.m_tblSource);
    }

    protected void removeSourceTableColumns() {
        if (this.m_bMultipleSources) {
            this.m_tblSource.hideColumn(3);
        } else {
            this.removeColumn(this.m_tblSource, 2);
            this.removeColumn(this.m_tblSource, 3);
        }
    }

    protected void createTargetTable() {
        this.m_mdlTarget = this.createTargetTableModel();
        this.m_mdlTarget.addTableModelListener(this.m_lsnrTargetTableModel);
        this.m_mdlTarget.setTransformationStep(this.m_oTS);
        if (this.m_bFeatureMapListProvided) {
            this.m_mdlTarget.setTables(this.m_lTgtTables);
            this.m_mdlTarget.setSourceTables(this.m_lSrcTables);
            this.m_mdlTarget.setFeatureMapsList((List)this.m_lFeatureMaps);
        }
        this.m_tblTarget = new WsTable((WsAbstractTableModel)this.m_mdlTarget);
        this.m_tblTarget.setName("Target");
        this.removeTargetTableColumns();
        this.m_tblTarget.setMultipleSelectionDragEnabled(true);
        this.m_tblTarget.setUndoManager((UndoManager)this.m_TargetTableUndoManager);
        this.m_tblTarget.setTablePopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.setViewportPopupMenuRequestListener(this.m_lsnrTargetTablePopup);
        this.m_tblTarget.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        ((WsDefaultTableRowModel)this.m_tblTarget.getRowModel()).addRowModelListener(this.m_lsnrTargetTableRowModel);
        this.m_tblTarget.getActionMap().put(this.m_actSelectAllColumns, (Action)this.m_actSelectAllColumns);
        this.m_tblTarget.getActionMap().put(this.m_actDeleteColumns, (Action)this.m_actDeleteColumns);
        this.m_tblTarget.getInputMap().put(KeyStroke.getKeyStroke(65, 2), this.m_actSelectAllColumns);
        this.m_tblTarget.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDeleteColumns);
        ColumnsTableNameCellRenderer rdrColumnName = new ColumnsTableNameCellRenderer();
        rdrColumnName.setTypeColumnIndex(7);
        int iColumnName = this.m_tblTarget.convertColumnIndexToView(0);
        TableColumn colColumnName = this.m_tblTarget.getColumnModel().getColumn(iColumnName);
        colColumnName.setCellRenderer((TableCellRenderer)((Object)rdrColumnName));
        int iExpression = this.m_tblTarget.convertColumnIndexToView(1);
        if (iExpression > 0) {
            TableColumn colExpression = this.m_tblTarget.getColumnModel().getColumn(iExpression);
            colExpression.setCellEditor(this.createExpressionEditor());
        }
        this.m_tblTarget.restoreSettings("MappingsPropertyTab." + this.m_sSettingsKey + ".TargetTable");
        this.m_scrTarget = new JScrollPane((Component)this.m_tblTarget);
        this.m_scrTarget.setMinimumSize(new Dimension(50, 150));
        this.m_scrTarget.setPreferredSize(new Dimension(200, 200));
        this.m_lblTarget = new JLabel(bundle.getString("MappingsPropertyTab.TargetTables.txt"));
        this.m_lblTarget.setDisplayedMnemonic(bundle.getString("MappingsPropertyTab.TargetTables.mnem").charAt(0));
        this.m_lblTarget.setLabelFor((Component)this.m_tblTarget);
    }

    protected void removeTargetTableColumns() {
        if (this.m_bMultipleTargets) {
            this.m_tblTarget.hideColumn(4);
        } else {
            this.removeColumn(this.m_tblTarget, 3);
            this.removeColumn(this.m_tblTarget, 4);
        }
        if (!this.m_bExpressionsEnabled) {
            this.removeColumn(this.m_tblTarget, 1);
        }
        if (!this.m_bGroupByEnabled) {
            this.removeColumn(this.m_tblTarget, 5);
        }
    }

    protected void createMappingsPanel() {
        this.m_pnlMappings = new WsTableMappingsPanel(this.m_tblSource, this.m_tblTarget);
        this.initializeMappingsPanel();
    }

    protected void initializeMappingsPanel() {
        this.m_pnlMappings.setPreferredSize(new Dimension(50, 200));
        this.m_pnlMappings.setMinimumSize(new Dimension(20, 150));
        this.m_pnlMappings.getMappingsModel().addObjectListModelListener(this.m_lsnrMappingsModel);
        this.m_pnlMappings.getSelectionModel().addObjectSelectionListener(this.m_lsnrMappingsSelection);
        this.m_pnlMappings.setPopupMenuRequestListener(this.m_lsnrMappingsPanelPopup);
        this.m_pnlMappings.setAutoSelectEnabled(true);
        this.m_lblMappings = new JLabel();
    }

    protected void removeColumn(WsTable tbl, int iModelColumn) {
        int iViewColumn = tbl.convertColumnIndexToView(iModelColumn);
        if (iViewColumn != -1) {
            tbl.removeColumn(tbl.getColumnModel().getColumn(iViewColumn));
        }
    }

    protected void createLayoutPanels() {
        this.m_barButtons = WsUIUtilities.createToolBar();
        this.m_barButtons.setBorder(null);
        this.m_barButtons.add(this.m_btnExpand);
        int height = Math.max(this.m_btnExpand.getPreferredSize().height, this.m_lblSource.getPreferredSize().height);
        this.m_lblSource.setMinimumSize(new Dimension(50, height));
        this.m_lblSource.setPreferredSize(new Dimension(200, height));
        this.m_lblMappings.setMinimumSize(new Dimension(20, height));
        this.m_lblMappings.setPreferredSize(new Dimension(50, height));
        this.m_lblTarget.setMinimumSize(new Dimension(50, height));
        this.m_lblTarget.setPreferredSize(new Dimension(200, height));
        this.m_pnlSource = new JPanel(new GridBagLayout());
        this.m_pnlSource.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_pnlSource.add((Component)this.m_lblSource, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        this.m_pnlSource.add((Component)this.m_scrSource, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlTarget = new JPanel(new GridBagLayout());
        this.m_pnlTarget.setBorder(BorderFactory.createLoweredBevelBorder());
        this.layoutTargetPanel();
        this.m_pnlCenter = new JPanel(new GridBagLayout());
        this.m_pnlCenter.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_pnlCenter.add((Component)this.m_lblMappings, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        this.m_pnlCenter.add((Component)this.m_pnlMappings, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splInner = new JSplitPane(1, this.m_pnlSource, this.m_pnlCenter);
        this.m_splInner.setContinuousLayout(true);
        this.m_splInner.setResizeWeight(0.0);
        this.m_splInner.setBorder(null);
        this.m_splInner.setDividerSize(3);
        ((BasicSplitPaneUI)this.m_splInner.getUI()).getDivider().setBorder(null);
        this.m_splOuter = new JSplitPane(1, this.m_splInner, this.m_pnlTarget);
        this.m_splOuter.setContinuousLayout(true);
        this.m_splOuter.setResizeWeight(0.0);
        this.m_splOuter.setBorder(null);
        this.m_splOuter.setDividerSize(3);
        ((BasicSplitPaneUI)this.m_splOuter.getUI()).getDivider().setBorder(null);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.layoutComponentsNormal();
    }

    protected void layoutTargetPanel() {
        this.m_barButtons.add(this.m_btnExpand);
        this.m_pnlTarget.add((Component)this.m_barButtons, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlTarget.add((Component)this.m_lblTarget, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        this.m_pnlTarget.add((Component)this.m_scrTarget, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void removeComponents() {
        if (this.m_bExpanded) {
            this.m_btnCollapse.getModel().setRollover(false);
        } else {
            this.m_btnExpand.getModel().setRollover(false);
        }
        this.m_barButtons.removeAll();
        this.removeAll();
    }

    protected void layoutComponentsNormal() {
        this.layoutTargetPanel();
        this.add(this.m_splOuter, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void layoutComponentsExpanded() {
        this.m_barButtons.add(this.m_btnCollapse);
        this.add(this.m_barButtons, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblTarget, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.add(this.m_scrTarget, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    public void doLayout() {
        if (!this.m_bSplitLocationSet) {
            int cxMappings;
            int cxTable;
            int cxDeficit;
            Insets insTab = this.getInsets();
            int cxAvailable = this.getWidth() - insTab.left - insTab.right - 12 - 6;
            if (cxAvailable < 120) {
                cxDeficit = (120 - cxAvailable) / 3;
                cxTable = 50 - cxDeficit;
                cxMappings = 20 - cxDeficit;
            } else if (cxAvailable < 420) {
                cxDeficit = (420 - cxAvailable) / 2;
                cxTable = 200 - cxDeficit;
                cxMappings = 20;
            } else if (cxAvailable < 450) {
                cxDeficit = 450 - cxAvailable;
                cxTable = 200;
                cxMappings = 50 - cxDeficit;
            } else {
                int cxExtra = (cxAvailable - 450) / 2;
                cxTable = 200 + cxExtra;
                cxMappings = 50;
            }
            int xInner = cxTable + 4;
            int xOuter = xInner + 3 + cxMappings + 4;
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splInner.setDividerLocation(appDefaults.getPropertyInt(this.getDividerLocationsKey() + ".InnerLocation.x", xInner));
            this.m_splOuter.setDividerLocation(appDefaults.getPropertyInt(this.getDividerLocationsKey() + ".OuterLocation.x", xOuter));
            this.m_bSplitLocationSet = true;
        }
        super.doLayout();
    }

    protected void updateTableLabel(JLabel lblTable, List lDataTables, String sKey) {
        String sDataTable = lDataTables == null || lDataTables.isEmpty() ? "" : TransformationTargetColumnsTableModel.getDataTableDisplayName((DataTable)lDataTables.get(0));
        if (sKey.equals(this.m_sLookupLabelOverride)) {
            sKey = "Lookup";
        }
        String sLabel = bundle.formatString("MappingsPropertyTab." + sKey + "Table.fmt", (Object)sDataTable);
        lblTable.setText(sLabel);
    }

    public void setEditNonWorkTables(boolean bEdit) {
        this.m_bEditNonWorkTables = bEdit;
    }

    public boolean isEditNonWorkTables() {
        return this.m_bEditNonWorkTables;
    }

    public void setFlushNonWorkTables(boolean bFlush) {
        this.m_bFlushNonWorkTables = bFlush;
    }

    public boolean isFlushNonWorkTables() {
        return this.m_bFlushNonWorkTables;
    }

    protected List getSourceTables() {
        return this.m_lSrcTables;
    }

    protected List getTargetTables() {
        return this.m_lTgtTables;
    }

    public void setDividerLocationsKey(String sKey) {
        this.m_sDividerLocationsKey = sKey;
    }

    public String getDividerLocationsKey() {
        return this.m_sDividerLocationsKey;
    }

    public boolean validateData() {
        if (!this.isEditable()) {
            return true;
        }
        if (!this.m_tblTarget.stopCellEditing()) {
            return false;
        }
        String sDerived = TransformationTargetColumnsTableModel.getViewMappingTypeString(2);
        for (int iRow = 0; iRow < this.m_tblTarget.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblTarget.convertRowIndexToModel(iRow);
            String sExpression = (String)this.m_mdlTarget.getValueAt(iModelRow, 1);
            if (sExpression.trim().length() == 0) {
                String sMappingType = (String)this.m_mdlTarget.getValueAt(iModelRow, 6);
                if (sMappingType.equals(sDerived)) {
                    MessageUtil.displayMessage((String)bundle.getString("MappingsPropertyTab.DerivedRequiresExpressionError.txt"), (int)0);
                    int iExpressionColumn = this.m_tblTarget.convertColumnIndexToView(1);
                    if (iExpressionColumn == -1) {
                        this.m_tblTarget.showColumn(1);
                        iExpressionColumn = this.m_tblTarget.convertColumnIndexToView(1);
                    }
                    this.m_tblTarget.selectCell(iRow, iExpressionColumn);
                    this.m_tblTarget.editCellAt(iRow, iExpressionColumn);
                    return false;
                }
            } else if (sExpression.trim().length() != 0 && !this.autoMapColumnsFromExpression(iModelRow, sExpression, true)) {
                int iExpressionColumn = this.m_tblTarget.convertColumnIndexToView(1);
                if (iExpressionColumn == -1) {
                    this.m_tblTarget.showColumn(1);
                    iExpressionColumn = this.m_tblTarget.convertColumnIndexToView(1);
                }
                this.m_tblTarget.selectCell(iRow, iExpressionColumn);
                return false;
            }
            String sType = WsColumnMetadataUtil.convertColumnTypeToData((String)((String)this.m_mdlTarget.getValueAt(iModelRow, 7)));
            String sInformat = (String)this.m_mdlTarget.getValueAt(iModelRow, 9);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("TableColumnsPanel2.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                int iInformatColumn = this.m_tblTarget.convertColumnIndexToView(9);
                if (iInformatColumn == -1) {
                    this.m_tblTarget.showColumn(9);
                    iInformatColumn = this.m_tblTarget.convertColumnIndexToView(9);
                }
                this.m_tblTarget.selectCell(iRow, iInformatColumn);
                this.m_tblTarget.editCellAt(iRow, iInformatColumn);
                return false;
            }
            String sFormat = (String)this.m_mdlTarget.getValueAt(iModelRow, 10);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("TableColumnsPanel2.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            int iFormatColumn = this.m_tblTarget.convertColumnIndexToView(10);
            if (iFormatColumn == -1) {
                this.m_tblTarget.showColumn(10);
                iFormatColumn = this.m_tblTarget.convertColumnIndexToView(10);
            }
            this.m_tblTarget.selectCell(iRow, iFormatColumn);
            this.m_tblTarget.editCellAt(iRow, iFormatColumn);
            return false;
        }
        if (this.m_bOrderChanged && !this.m_tblTarget.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("MappingsPropertyTab.SaveOrderMessage.txt"), (String)bundle.getString("MappingsPropertyTab.SaveOrderTitle.txt"), (int)2, (int)1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_tblTarget.getRowModel();
        this.m_mdlTarget.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oTS.getFQID().indexOf(36) == -1) {
            String sTemplate = "<Templates>";
            sTemplate = sTemplate + "<ClassifierMap><ClassifierSources/><ClassifierTargets/><SourceSpecifications/><FeatureMaps/></ClassifierMap>";
            sTemplate = sTemplate + "<Select><ClassifierSources/><ClassifierTargets/><FeatureMaps/><GroupByForSelect/></Select>";
            sTemplate = sTemplate + "<DataTable><Columns/></DataTable>";
            sTemplate = sTemplate + "<WorkTable><Columns/></WorkTable>";
            sTemplate = sTemplate + "<PhysicalTable><Columns/></PhysicalTable>";
            sTemplate = sTemplate + "<FeatureMap><FeatureSources/><FeatureTargets/><SourceCode/></FeatureMap>";
            sTemplate = sTemplate + "<GroupByClause><Columns/></GroupByClause>";
            sTemplate = sTemplate + "<MiningResult><Extensions/><TransformationSources/><TransformationTargets/><SourceCode/></MiningResult>";
            sTemplate = sTemplate + "</Templates>";
            Vector<String> vComplexAttrs = new Vector<String>();
            vComplexAttrs.add("Transformations");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oTS, null, vComplexAttrs, sTemplate, 12);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        int iTargetTable;
        int nTargetTables;
        this.m_tblTarget.cancelCellEditing();
        this.setListeningForChanges(false);
        this.m_pnlMappings.removeAllMappings();
        this.m_mdlSource.moveDataToModel();
        this.m_mdlTarget.moveDataToModel();
        List lSourceTables = this.m_mdlSource.getDataTables();
        if (!this.m_bMultipleSources) {
            this.updateTableLabel(this.m_lblSource, lSourceTables, "Source");
        }
        this.m_bUsesQuotes = false;
        this.m_bCaseSensitive = false;
        int nSourceTables = lSourceTables.size();
        for (int iSourceTable = 0; iSourceTable < nSourceTables; ++iSourceTable) {
            DataTable oSourceTable = (DataTable)lSourceTables.get(iSourceTable);
            if (!DBMSNamesPropertyHandler.needQuotes((DataTable)oSourceTable)) continue;
            this.m_bUsesQuotes = true;
            this.m_bCaseSensitive = true;
            break;
        }
        List lTargetTables = this.m_mdlTarget.getDataTables();
        if (!this.m_bMultipleTargets) {
            this.updateTableLabel(this.m_lblTarget, lTargetTables, "Target");
        }
        if ((nTargetTables = lTargetTables.size()) == 0) {
            this.m_bEditableTargetTables = false;
        } else if (this.m_bEditNonWorkTables) {
            this.m_bEditableTargetTables = true;
            for (iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)lTargetTables.get(iTargetTable);
                if (Workspace.getWorkspace().isObjectEditable((CMetadata)oTargetTable)) continue;
                this.m_bEditableTargetTables = false;
                break;
            }
        } else {
            this.m_bEditableTargetTables = true;
            for (iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)lTargetTables.get(iTargetTable);
                String targetMetaType = oTargetTable.getCMetadataType();
                if (!targetMetaType.equals("PhysicalTable") && !targetMetaType.equals("ExternalTable")) continue;
                this.m_bEditableTargetTables = false;
                break;
            }
        }
        this.m_mdlTarget.getColumn(3).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(0).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(2).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(7).setEditable(this.m_bEditableTargetTables);
        this.m_mdlTarget.getColumn(8).setEditable(this.m_bEditableTargetTables);
        this.createMappings();
        int nTargetColumns = this.m_mdlTarget.getRowCount();
        if (nTargetColumns > 0) {
            this.m_tblTarget.selectCell(0, 0);
        }
        if (this.m_tblSource.getRowCount() > 0) {
            this.m_tblSource.selectCell(0, 0);
        }
        this.m_tblTarget.clearSortMemory();
        this.updateActions();
        this.setListeningForChanges(true);
    }

    protected void createMappings() throws MdException, RemoteException {
        int nTargetColumns = this.m_mdlTarget.getRowCount();
        for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
            FeatureMap oFM = this.getFeatureMapForColumn(iTargetColumn);
            if (oFM == null) continue;
            AssociationList alSourceColumns = oFM.getFeatureSources();
            int nSourceColumns = alSourceColumns.size();
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                Column oSourceColumn = (Column)alSourceColumns.get(iSourceColumn);
                int[] aRows = this.m_mdlSource.findRows(8, oSourceColumn);
                if (aRows.length < 1) continue;
                WsMapping map = new WsMapping(aRows[0], iTargetColumn, (Object)oFM);
                this.m_pnlMappings.addMapping(map);
            }
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        if (this.m_bEditableTargetTables) {
            this.m_mdlTarget.moveDataToStore();
            this.m_bFlushRequired = this.m_bFlushNonWorkTables;
        }
        this.updateFeatureMaps();
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    protected void updateFeatureMaps() throws MdException, RemoteException {
        int iCM;
        List[] aOldFMLists;
        AssociationList[] aFMLists;
        int nCMs;
        String sUnmapped = TransformationTargetColumnsTableModel.getViewMappingTypeString(0);
        MdObjectStore store = (MdObjectStore)this.m_oTS.getObjectStore();
        ArrayList<Object> lTargetTables = new ArrayList<Object>();
        ArrayList<ClassifierMap> lClassifierMaps = new ArrayList<ClassifierMap>();
        if (this.m_bFeatureMapListProvided) {
            nCMs = 1;
            aFMLists = new AssociationList[1];
            aOldFMLists = new List[1];
            aFMLists[0] = this.m_lFeatureMaps;
            aOldFMLists[0] = new ArrayList(aFMLists[0]);
            aFMLists[0].removeAllElements();
        } else {
            AssociationList alCMs = this.m_oTS.getTransformations(false);
            nCMs = alCMs.size();
            aFMLists = new AssociationList[nCMs];
            aOldFMLists = new List[nCMs];
            for (iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                aFMLists[iCM] = oCM.getFeatureMaps(false);
                aOldFMLists[iCM] = new ArrayList(aFMLists[iCM]);
                aFMLists[iCM].removeAllElements();
                AssociationList alTargets = oCM.getClassifierTargets(false);
                int nTargets = alTargets.size();
                for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
                    lTargetTables.add(alTargets.get(iTarget));
                    lClassifierMaps.add(oCM);
                }
            }
        }
        int nRows = this.m_mdlTarget.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            String sMappingType = (String)this.m_mdlTarget.getValueAt(iRow, 6);
            if (!sMappingType.equals(sUnmapped)) {
                Column oTarget = (Column)this.m_mdlTarget.getValueAt(iRow, 11);
                FeatureMap oFM = this.updateFeatureMapForMapping(iRow, oTarget, sMappingType, store);
                if (this.m_bFeatureMapListProvided) {
                    aFMLists[0].add((Object)oFM);
                    if (!aOldFMLists[0].contains(oFM)) continue;
                    aOldFMLists[0].remove(oFM);
                    continue;
                }
                int iTargetTable = lTargetTables.indexOf(oTarget.getTable());
                ClassifierMap oCM = (ClassifierMap)lClassifierMaps.get(iTargetTable);
                iCM = lClassifierMaps.indexOf(oCM);
                aFMLists[iCM].add((Object)oFM);
                if (!aOldFMLists[iCM].contains(oFM)) continue;
                aOldFMLists[iCM].remove(oFM);
                continue;
            }
            this.m_mdlTarget.setValueAt(null, iRow, 12);
        }
        for (iCM = 0; iCM < nCMs; ++iCM) {
            int nFMs = aOldFMLists[iCM].size();
            for (int iFM = 0; iFM < nFMs; ++iFM) {
                FeatureMap oFM = (FeatureMap)aOldFMLists[iCM].get(iFM);
                if (oFM.getIsUserDefined() != 0 || oFM.getTransformRole().equals("lookup")) {
                    aFMLists[iCM].add((Object)oFM);
                    continue;
                }
                store.removeObjectFromStore((CMetadata)oFM, "<FeatureMap><SourceCode/><SubstitutionVariables/></FeatureMap>");
            }
        }
    }

    protected FeatureMap getFeatureMapForColumn(int index) {
        return (FeatureMap)this.m_mdlTarget.getValueAt(index, 12);
    }

    protected FeatureMap updateFeatureMapForMapping(int iRow, Column oTarget, String sMappingType, MdObjectStore store) throws MdException, RemoteException {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        String sOneToOne = TransformationTargetColumnsTableModel.getViewMappingTypeString(1);
        String sManyToOne = TransformationTargetColumnsTableModel.getViewMappingTypeString(3);
        String sOneToOneRole = "ONETOONE";
        String sDerivedRole = "DERIVED";
        String sManyToOneRole = "MANYTOONE";
        FeatureMap oFM = (FeatureMap)this.m_mdlTarget.getValueAt(iRow, 12);
        if (oFM == null) {
            oFM = (FeatureMap)factory.createComplexMetadataObject(store, sMappingType, "FeatureMap", this.m_oTS.getRepositoryID());
            oFM.getFeatureTargets(false).add((Object)oTarget);
            this.m_mdlTarget.setValueAt(oFM, iRow, 12);
        }
        if (!oFM.getName().equals(sMappingType)) {
            oFM.setName(sMappingType);
        }
        if (this.m_sRole == null) {
            String sRole = sMappingType.equals(sOneToOne) ? sOneToOneRole : (sMappingType.equals(sManyToOne) ? sManyToOneRole : sDerivedRole);
            if (!oFM.getTransformRole().equals(sRole)) {
                oFM.setTransformRole(sRole);
            }
        } else if (!oFM.getTransformRole().equals(this.m_sRole)) {
            oFM.setTransformRole(this.m_sRole);
        }
        AssociationList alSourceColumns = oFM.getFeatureSources(false);
        alSourceColumns.removeAllElements();
        List lMappings = this.m_pnlMappings.findMappingsForRow(iRow, false);
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            Column oSource = (Column)this.m_mdlSource.getValueAt(mapping.getSource(), 8);
            alSourceColumns.add((Object)oSource);
        }
        String sExpression = (String)this.m_mdlTarget.getValueAt(iRow, 1);
        TextStore oExpression = (TextStore)oFM.getSourceCode();
        if (sExpression.length() > 0) {
            String sParsedExpression = ExpressionParser.tokenizeString((String)sExpression, (List)alSourceColumns, (AbstractTransformation)oFM, (boolean)this.m_bUsesQuotes, (boolean)this.m_bCaseSensitive);
            if (oExpression == null) {
                oExpression = (TextStore)factory.createComplexMetadataObject(store, "FeatureMapExpression", "TextStore", this.m_oTS.getRepositoryID());
                oExpression.setTextRole("FeatureMapExpression");
                oExpression.setStoredText(sParsedExpression);
                oFM.setSourceCode((Text)oExpression);
            } else if (!oExpression.getStoredText().equals(sParsedExpression)) {
                oExpression.setStoredText(sParsedExpression);
            }
        } else if (oExpression != null) {
            store.removeObjectFromStore((CMetadata)oExpression, null);
            store.removeObjectsFromStore((List)oFM.getSubstitutionVariables());
        }
        return oFM;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNewMapping.setActive(bActive);
        this.m_actNewColumn.setActive(bActive);
        this.m_actCommonDelete.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actExpression.setActive(bActive);
        this.m_actQuickMap.setActive(bActive);
        this.m_actImport.setActive(bActive);
        this.m_actQuickPropagate.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlMappings.setDraggingFromSourceTableEnabled(bEditable);
        this.m_pnlMappings.setDraggingFromTargetTableEnabled(bEditable);
        this.m_tblTarget.setEditable(bEditable);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblSource.saveSettings("MappingsPropertyTab." + this.m_sSettingsKey + ".SourceTable");
        this.m_tblTarget.saveSettings("MappingsPropertyTab." + this.m_sSettingsKey + ".TargetTable");
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt(this.getDividerLocationsKey() + ".InnerLocation.x", this.m_splInner.getDividerLocation());
        appDefaults.setPropertyInt(this.getDividerLocationsKey() + ".OuterLocation.x", this.m_splOuter.getDividerLocation());
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        this.m_tblTarget.setUndoManager((UndoManager)mgrUndo);
    }

    public void onParentOK() {
        if (this.m_bFlushRequired) {
            this.flushNonWorkTables();
        }
    }

    public void onParentApply() {
        if (this.m_bFlushRequired) {
            this.flushNonWorkTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNonWorkTables() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "MappingsPropertyStore:flushNonWorkTables");
            try {
                List lTables = this.m_mdlTarget.getDataTables();
                for (int iTable = 0; iTable < lTables.size(); ++iTable) {
                    DataTable oTable = (DataTable)lTables.get(iTable);
                    String sType = oTable.getCMetadataType();
                    if (!sType.equals("PhysicalTable") && !sType.equals("ExternalTable")) continue;
                    DataTable oNewTable = (DataTable)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oTable);
                    AssociationList lColumns = oTable.getColumns();
                    AssociationList lNewColumns = oNewTable.getColumns(false);
                    lNewColumns.clear();
                    for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                        Column oColumn = (Column)lColumns.get(iColumn);
                        Column oNewColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)oColumn);
                        oNewColumn.setName(oColumn.getName(), oColumn.getNameState());
                        oNewColumn.setColumnName(oColumn.getColumnName(), oColumn.getColumnNameState());
                        oNewColumn.setSASColumnName(oColumn.getSASColumnName(), oColumn.getSASColumnNameState());
                        oNewColumn.setDesc(oColumn.getDesc(), oColumn.getDescState());
                        oNewColumn.setSASColumnType(oColumn.getSASColumnType(), oColumn.getSASColumnTypeState());
                        oNewColumn.setSASColumnLength(oColumn.getSASColumnLength(), oColumn.getSASColumnLengthState());
                        oNewColumn.setSASFormat(oColumn.getSASFormat(), oColumn.getSASFormatState());
                        oNewColumn.setSASInformat(oColumn.getSASInformat(), oColumn.getSASInformatState());
                        oNewColumn.setIsNullable(oColumn.getIsNullable(), oColumn.getIsNullableState());
                        lNewColumns.add(oNewColumn);
                    }
                }
                store.updatedMetadataAll();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
                this.m_bFlushRequired = false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setLookupLabelOverride(String sLookupLabelOverride) {
        this.m_sLookupLabelOverride = sLookupLabelOverride;
    }

    public void setQuickPropagateSources(List lSourceTables) {
        this.m_lQuickPropagateSources = lSourceTables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean updateMappingType(int iTarget) {
        String sMessageKey = null;
        int eMappingType = 2;
        String sExpression = ((String)this.m_mdlTarget.getValueAt(iTarget, 1)).trim();
        if (sExpression.length() == 0) {
            List lMappings = this.m_pnlMappings.findMappingsForRow(iTarget, false);
            int nMappings = lMappings.size();
            if (nMappings > 1) {
                if (this.m_bMultipleSourceColumnsEnabled && !this.m_bExpressionsEnabled) {
                    int iSource;
                    eMappingType = 3;
                    for (int iMapping = 0; iMapping < nMappings && (sMessageKey = this.validateMapping(iSource = ((WsMapping)lMappings.get(iMapping)).getSource(), iTarget)) == null; ++iMapping) {
                    }
                } else {
                    sMessageKey = "MultipleMappings";
                }
            } else if (nMappings == 1) {
                int iSource = ((WsMapping)lMappings.get(0)).getSource();
                sMessageKey = this.validateMapping(iSource, iTarget);
                if (sMessageKey == null) {
                    eMappingType = 1;
                }
            } else {
                eMappingType = 0;
            }
        }
        String sOldMappingType = (String)this.m_mdlTarget.getValueAt(iTarget, 6);
        String sMappingType = TransformationTargetColumnsTableModel.getViewMappingTypeString(eMappingType);
        String sDerivedType = TransformationTargetColumnsTableModel.getViewMappingTypeString(2);
        if (sMessageKey != null && !sOldMappingType.equals(sDerivedType)) {
            if (this.m_bExpressionsEnabled) {
                int eAnswer = MessageUtil.displayMessage((String)bundle.getString("MappingsPropertyTab." + sMessageKey + "Warning.txt"), (int)2, (int)1);
                if (eAnswer == 0) {
                    sExpression = this.showExpressionBuilderDialog(iTarget, "");
                    if (sExpression == null) return false;
                    this.m_mdlTarget.setValueAt(sExpression, iTarget, 1);
                    this.m_tblTarget.selectCell(this.m_tblTarget.convertRowIndexToView(iTarget), this.m_tblTarget.convertColumnIndexToView(1));
                } else if (eAnswer != 1) {
                    return false;
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("MappingsPropertyTab." + sMessageKey + "Error.txt"), (int)0);
                return false;
            }
        }
        this.m_mdlTarget.setValueAt(sMappingType, iTarget, 6);
        return true;
    }

    protected String validateMapping(int iSource, int iTarget) {
        String sTargetType;
        String sSourceType = (String)this.m_mdlSource.getValueAt(iSource, 4);
        if (!sSourceType.equals(sTargetType = (String)this.m_mdlTarget.getValueAt(iTarget, 7))) {
            return "DifferentTypes";
        }
        Integer iSourceLength = (Integer)this.m_mdlSource.getValueAt(iSource, 5);
        Integer iTargetLength = (Integer)this.m_mdlTarget.getValueAt(iTarget, 8);
        if (iSourceLength > iTargetLength) {
            return "ShorterTarget";
        }
        return null;
    }

    protected void quickMap() {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        String sUnmapped = TransformationTargetColumnsTableModel.getViewMappingTypeString(0);
        boolean bMultipleMappings = this.m_bMultipleSourceColumnsEnabled && !this.m_bExpressionsEnabled;
        ArrayList<WsQuickMapColumn> lTargets = new ArrayList<WsQuickMapColumn>();
        int nTargets = this.m_tblTarget.getRowCount();
        for (int iTarget = 0; iTarget < nTargets; ++iTarget) {
            int iRow = this.m_tblTarget.convertRowIndexToModel(iTarget);
            String sMappingType = (String)this.m_mdlTarget.getValueAt(iRow, 6);
            if (!sMappingType.equals(sUnmapped) && !bMultipleMappings) continue;
            String sName = (String)this.m_mdlTarget.getValueAt(iRow, 0);
            String sType = (String)this.m_mdlTarget.getValueAt(iRow, 7);
            Integer nLength = (Integer)this.m_mdlTarget.getValueAt(iRow, 8);
            Integer iModelRow = new Integer(iRow);
            WsQuickMapColumn col = new WsQuickMapColumn(sName, sType, nLength, iModelRow);
            lTargets.add(col);
        }
        ArrayList<WsQuickMapColumn> lSources = new ArrayList<WsQuickMapColumn>();
        int nSources = this.m_tblSource.getRowCount();
        for (int iSource = 0; iSource < nSources; ++iSource) {
            int iRow = this.m_tblSource.convertRowIndexToModel(iSource);
            String sName = (String)this.m_mdlSource.getValueAt(iRow, 0);
            String sType = (String)this.m_mdlSource.getValueAt(iRow, 4);
            Integer nLength = (Integer)this.m_mdlSource.getValueAt(iRow, 5);
            Integer iModelRow = new Integer(iRow);
            WsQuickMapColumn col = new WsQuickMapColumn(sName, sType, nLength, iModelRow);
            lSources.add(col);
        }
        List lMappings = MappingsPropertyTab.quickMap(lSources, lTargets, bMultipleMappings);
        this.m_pnlMappings.setAutoSelectEnabled(false);
        int nMappings = lMappings.size();
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            WsQuickMapColumn colSource = (WsQuickMapColumn)lSources.get(mapping.getSource());
            WsQuickMapColumn colTarget = (WsQuickMapColumn)lTargets.get(mapping.getTarget());
            mapping.setSource(((Integer)colSource.getUserValue()).intValue());
            mapping.setTarget(((Integer)colTarget.getUserValue()).intValue());
            this.addMappingToMappingPanel(mapping);
            Object oData = mapping.getDataObject();
            if (!(oData instanceof String) || !this.m_bExpressionsEnabled) continue;
            this.m_mdlTarget.setValueAt(oData, (Integer)colTarget.getUserValue(), 1);
        }
        this.m_pnlMappings.setAutoSelectEnabled(true);
        this.m_pnlMappings.autoSelectFromMappings();
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void addMappingToMappingPanel(WsMapping mapping) {
        if (!this.m_pnlMappings.mappingExists(mapping)) {
            this.m_pnlMappings.addMapping(mapping);
        }
    }

    protected static List quickMap(List lSourceColumns, List lTargetColumns, boolean bAllowMultipleMappings) {
        ArrayList<WsMapping> lMappings = new ArrayList<WsMapping>();
        int nTargetColumns = lTargetColumns.size();
        int nSourceColumns = lSourceColumns.size();
        block0: for (int iTargetColumn = 0; iTargetColumn < nTargetColumns; ++iTargetColumn) {
            WsQuickMapColumn colTarget = (WsQuickMapColumn)lTargetColumns.get(iTargetColumn);
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                WsQuickMapColumn colSource = (WsQuickMapColumn)lSourceColumns.get(iSourceColumn);
                if (!colSource.getColumnName().equalsIgnoreCase(colTarget.getColumnName()) || !colSource.getColumnType().equalsIgnoreCase(colTarget.getColumnType()) || colSource.getColumnLength() > colTarget.getColumnLength()) continue;
                lMappings.add(new WsMapping(iSourceColumn, iTargetColumn));
                if (!bAllowMultipleMappings) continue block0;
            }
        }
        return lMappings;
    }

    protected boolean autoMapColumnsFromExpression(int iTargetColumn, String sExpression, boolean bAllowCancel) {
        try {
            String sMappingType = (String)this.m_mdlTarget.getValueAt(iTargetColumn, 6);
            String sDerivedType = TransformationTargetColumnsTableModel.getViewMappingTypeString(2);
            if (!sMappingType.equals(sDerivedType)) {
                return true;
            }
            List lColumns = this.m_mdlSource.getDataColumns();
            ArrayList lUsedColumns = new ArrayList();
            ExpressionParser.tokenizeString((String)sExpression, (List)lColumns, lUsedColumns, (boolean)this.m_bUsesQuotes, (boolean)this.m_bCaseSensitive);
            ArrayList<WsMapping> lUnusedMappings = new ArrayList<WsMapping>();
            List lMappings = this.m_pnlMappings.findMappingsForRow(iTargetColumn, false);
            int nMappings = lMappings.size();
            for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
                WsMapping mapping = (WsMapping)lMappings.get(iMapping);
                Column oColumn = (Column)lColumns.get(mapping.getSource());
                int iUsedColumn = lUsedColumns.indexOf(oColumn);
                if (iUsedColumn != -1) {
                    lUsedColumns.remove(iUsedColumn);
                    continue;
                }
                lUnusedMappings.add(mapping);
            }
            if (lUsedColumns.size() > 0 || lUnusedMappings.size() > 0) {
                int eOptions;
                String sColumn = (String)this.m_mdlTarget.getValueAt(iTargetColumn, 0);
                String sMessage = bundle.formatString("MappingsPropertyTab.MappingsDoNotMatchExpressionWarning.fmt", (Object)sColumn);
                int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)2, (int)(eOptions = bAllowCancel ? 1 : 0));
                if (eAnswer == 1) {
                    return true;
                }
                if (eAnswer != 0) {
                    return false;
                }
                lMappings.clear();
                int nUsedColumns = lUsedColumns.size();
                for (int iUsedColumn = 0; iUsedColumn < nUsedColumns; ++iUsedColumn) {
                    Column oColumn = (Column)lUsedColumns.get(iUsedColumn);
                    WsMapping mapping = new WsMapping(lColumns.indexOf(oColumn), iTargetColumn);
                    lMappings.add(mapping);
                }
                this.m_pnlMappings.removeMappings(lUnusedMappings);
                this.m_pnlMappings.addMappings(lMappings);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    protected String showExpressionBuilderDialog(int iRow, String sExpression) {
        List lMappings = this.m_pnlMappings.findMappingsForRow(iRow, false);
        int nMappings = lMappings.size();
        ArrayList<Object> alColumns = new ArrayList<Object>(nMappings);
        for (int iMapping = 0; iMapping < nMappings; ++iMapping) {
            WsMapping mapping = (WsMapping)lMappings.get(iMapping);
            alColumns.add(this.m_mdlSource.getValueAt(mapping.getSource(), 8));
        }
        ExpressionBuilderTab tabExpressionBuilder = new ExpressionBuilderTab(alColumns, (ArrayList)this.m_mdlSource.getDataTables(), this.m_bMultipleSources);
        tabExpressionBuilder.setExpression(sExpression);
        tabExpressionBuilder.setUseQuotes(this.m_bUsesQuotes);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("MappingsPropertyTab.ExpressionBuilder.Title.txt"), true, (WAPanel)tabExpressionBuilder);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return tabExpressionBuilder.getExpression();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showImportColumnsDialog() {
        if (!this.m_tblTarget.stopCellEditing()) {
            return;
        }
        try {
            MdObjectStore storeDialog = Workspace.getMdFactory().createObjectStore();
            try {
                storeDialog.setGoToServerForMetadata(true);
                List lSelectedTables = null;
                ObjectsSelectorPanel pnl = this.m_bMultipleTargets ? new cExtendedObjectsSelector(this.m_mdlTarget.getDataTables()) : new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
                String sImportDialogTitle = bundle.getString("MappingsPropertyTab.ImportColumnsDialogTitle.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.setHelpProduct("shared");
                dlg.setHelpTopic("import_column_win");
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    lSelectedTables = this.m_bMultipleTargets ? ((cExtendedObjectsSelector)pnl).getSelectedTables() : this.m_mdlTarget.getDataTables();
                    SimpleObject[] aColumns = pnl.getSelectedObjects();
                    Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(storeDialog, aColumns);
                    List<Root> lColumns = Arrays.asList(aMDColumns);
                    int nColumns = lColumns.size();
                    int nSelectedTables = lSelectedTables.size();
                    ArrayList<List> lRowsValues = new ArrayList<List>(nColumns);
                    ArrayList<String> lDuplicateColumns = new ArrayList<String>();
                    for (int iSelectedTable = 0; iSelectedTable < nSelectedTables; ++iSelectedTable) {
                        DataTable oSelectedTable = (DataTable)lSelectedTables.get(iSelectedTable);
                        String sSelectedTable = TransformationTargetColumnsTableModel.getDataTableDisplayName(oSelectedTable);
                        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                            Column oNewColumn = WsColumnMetadataUtil.createMetadataColumnCopy((Column)((Column)lColumns.get(iColumn)), (MdObjectStore)storeDialog, (String)oSelectedTable.getRepositoryID());
                            String sColumn = oNewColumn.getName();
                            if (this.m_mdlTarget.validateColumnNameUniqueness(sSelectedTable, sColumn, -1)) {
                                lRowsValues.add(this.m_mdlTarget.getRowValuesForColumn(oNewColumn, oSelectedTable));
                                continue;
                            }
                            if (this.m_bMultipleTargets) {
                                lDuplicateColumns.add(sSelectedTable + "." + oNewColumn.getName());
                                continue;
                            }
                            lDuplicateColumns.add(oNewColumn.getName());
                        }
                    }
                    if (!lRowsValues.isEmpty()) {
                        int firstInsertIndex = this.m_tblTarget.getLastSelectedRow() + 1;
                        this.m_tblTarget.undoableInsertRowsAfterLastSelectedRow(lRowsValues);
                        for (int i = 0; i < lRowsValues.size(); ++i) {
                            this.updateColumnInModelAt(firstInsertIndex + i);
                        }
                    }
                    if (lDuplicateColumns.size() > 0) {
                        String sMessage = bundle.getString("MappingsPropertyTab.DuplicateColumnsRemovedWarning.txt");
                        MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
                    }
                }
            }
            finally {
                storeDialog.dispose();
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void updateColumnInModelAt(int index) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showQuickPropagateDialog() {
        if (!this.m_tblTarget.stopCellEditing()) {
            return;
        }
        try {
            MdObjectStore storeChild = Workspace.getMdFactory().createObjectStore();
            try {
                List lSourceColumns;
                List lSourceTables;
                storeChild.setIsGotToServerForMetadata(true);
                List lSelectedTables = null;
                if (this.m_lQuickPropagateSources != null) {
                    lSourceTables = this.m_lQuickPropagateSources;
                    lSourceColumns = new ArrayList();
                    for (int i = 0; i < lSourceTables.size(); ++i) {
                        lSourceColumns.addAll(((DataTable)lSourceTables.get(i)).getColumns());
                    }
                } else {
                    lSourceTables = this.m_mdlSource.getDataTables();
                    lSourceColumns = this.m_mdlSource.getDataColumns();
                }
                int nSourceColumns = lSourceColumns.size();
                List lTargetTables = this.m_mdlTarget.getDataTables();
                int nTargetTables = lTargetTables.size();
                ArrayList<String> lTargetColumns = new ArrayList<String>();
                for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                    String sTargetTable = TransformationTargetColumnsTableModel.getDataTableDisplayName((DataTable)lTargetTables.get(iTargetTable));
                    for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                        Column oSourceColumn = (Column)lSourceColumns.get(iSourceColumn);
                        if (!this.m_mdlTarget.validateColumnUniqueness(sTargetTable, oSourceColumn, -1)) continue;
                        lTargetColumns.add(oSourceColumn.getSASColumnName());
                    }
                }
                QuickPropagateSelectorPanel pnl = this.createQuickPropagatePanel(lSourceTables, lTargetColumns);
                pnl.setStore(storeChild);
                pnl.setRepository(Workspace.getWorkspace().getDefaultRepository());
                String sQuickPropagateDialogTitle = bundle.getString("MappingsPropertyTab.QuickPropagateDialogTitle.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sQuickPropagateDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpTopic("quick_propagate_win");
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    lSelectedTables = this.m_bMultipleTargets ? pnl.getSelectedTables() : this.m_mdlTarget.getDataTables();
                    int iSelectedRow = this.m_tblTarget.getLastSelectedRow();
                    Vector lColumns = pnl.getColumns();
                    int nColumns = lColumns.size();
                    int nSelectedTables = lSelectedTables.size();
                    ArrayList<List> lRowsValues = new ArrayList<List>(nColumns);
                    ArrayList<String> lDuplicateColumns = new ArrayList<String>();
                    for (int iSelectedTable = 0; iSelectedTable < nSelectedTables; ++iSelectedTable) {
                        DataTable oSelectedTable = (DataTable)lSelectedTables.get(iSelectedTable);
                        String sSelectedTable = TransformationTargetColumnsTableModel.getDataTableDisplayName(oSelectedTable);
                        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                            Column oColumn = (Column)lColumns.get(iColumn);
                            String sColumn = oColumn.getName();
                            if (this.m_mdlTarget.validateColumnNameUniqueness(sSelectedTable, sColumn, -1)) {
                                lRowsValues.add(this.m_mdlTarget.getRowValuesForColumn(oColumn, oSelectedTable));
                                continue;
                            }
                            if (this.m_bMultipleTargets) {
                                lDuplicateColumns.add(sSelectedTable + "." + oColumn.getName());
                                continue;
                            }
                            lDuplicateColumns.add(oColumn.getName());
                        }
                    }
                    if (!lRowsValues.isEmpty()) {
                        int firstInsertIndex = this.m_tblTarget.getLastSelectedRow() + 1;
                        this.m_tblTarget.undoableInsertRowsAfterLastSelectedRow(lRowsValues);
                        for (int i = 0; i < lRowsValues.size(); ++i) {
                            this.updateColumnInModelAt(firstInsertIndex + i);
                        }
                    }
                    if (MappingUtil.isAutoMapEnabled(this.m_oTS)) {
                        this.quickMap();
                    }
                    this.m_tblTarget.changeCurrentCell(++iSelectedRow, 0);
                    if (lDuplicateColumns.size() > 0) {
                        String sMessage = bundle.getString("MappingsPropertyTab.DuplicateColumnsRemovedWarning.txt");
                        MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                storeChild.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected QuickPropagateSelectorPanel createQuickPropagatePanel(List lSourceTables, List lTargetColumns) {
        QuickPropagateSelectorPanel pnl = new QuickPropagateSelectorPanel(this.m_bMultipleSources, this.m_bMultipleTargets, lSourceTables, lTargetColumns, this.m_mdlTarget.getDataTables());
        pnl.setPreferredSize(new Dimension(450, 400));
        return pnl;
    }

    protected void insertForQuickPropagate(Column oColumn, String tableName, int iInsertAfterRow) {
        List lValues = this.m_mdlTarget.createRowValuesFromColumn(oColumn, tableName);
        this.m_tblTarget.undoableInsertRow(iInsertAfterRow, lValues);
    }

    protected void createActions() {
        this.m_actNewColumn = this.createNewColumnAction();
        this.m_actNewMapping = this.createNewMappingAction();
        this.m_actCommonDelete = this.createCommonDeleteAction();
        this.m_actDeleteMappings = this.createDeleteMappingsAction();
        this.m_actDeleteColumns = this.createDeleteColumnsAction();
        this.m_actExpand = this.createExpandAction();
        this.m_actCollapse = this.createCollapseAction();
        this.m_actSelectAll = this.createSelectAllAction();
        this.m_actSelectAllColumns = this.createSelectAllColumnsAction();
        this.m_actExpression = this.createExpressionAction();
        this.m_actQuickMap = this.createQuickMapAction();
        this.m_actImport = this.createImportAction();
        this.m_actQuickPropagate = this.createQuickPropagateAction();
    }

    protected void updateActions() {
        if (this.m_bIgnoreActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable();
        boolean bFirst = false;
        boolean bLast = false;
        boolean bNoMappings = true;
        int[] aSelectedSourceRows = this.m_tblSource.getSelectedRowsFromSelectedCells();
        int[] aSelectedTargetRows = this.m_tblTarget.getSelectedRowsFromSelectedCells();
        int nSelectedSourceRows = aSelectedSourceRows.length;
        int nSelectedTargetRows = aSelectedTargetRows.length;
        int nTargetRows = this.m_tblTarget.getRowCount();
        int nSourceRows = this.m_tblSource.getRowCount();
        for (int iSelectedTargetRow = 0; iSelectedTargetRow < nSelectedTargetRows; ++iSelectedTargetRow) {
            int iTarget = aSelectedTargetRows[iSelectedTargetRow];
            if (iTarget == 0) {
                bFirst = true;
            }
            if (iTarget == nTargetRows - 1) {
                bLast = true;
            }
            if (bFirst && bLast) break;
        }
        if (nSelectedTargetRows == 1) {
            this.m_tblSource.convertRowIndexesToModel(aSelectedSourceRows);
            this.m_tblTarget.convertRowIndexesToModel(aSelectedTargetRows);
            WsMapping map = new WsMapping(0, aSelectedTargetRows[0]);
            for (int iSelectedSourceRow = 0; iSelectedSourceRow < nSelectedSourceRows; ++iSelectedSourceRow) {
                map.setSource(aSelectedSourceRows[iSelectedSourceRow]);
                if (!this.m_pnlMappings.mappingExists(map)) continue;
                bNoMappings = false;
                break;
            }
        }
        int nMappings = this.m_pnlMappings.getMappingsCount();
        int nSelectedMappings = this.m_pnlMappings.getSelectedMappings().size();
        boolean bNewMapping = this.m_bMultipleSourceColumnsEnabled ? nSelectedSourceRows >= 1 : nSelectedSourceRows == 1;
        boolean bDeleteColumns = this.m_bEditableTargetTables && nSelectedTargetRows > 0;
        this.m_actNewColumn.setEnabled(bEditable && this.m_bEditableTargetTables);
        this.m_actNewMapping.setEnabled(bEditable && !this.m_bExpanded && bNewMapping && nSelectedTargetRows == 1 && bNoMappings);
        this.m_actDeleteMappings.setEnabled(bEditable && !this.m_bExpanded && nSelectedMappings > 0);
        this.m_actDeleteColumns.setEnabled(bEditable && bDeleteColumns);
        this.m_actCommonDelete.setEnabled(this.m_actDeleteMappings.isEnabled() || this.m_actDeleteColumns.isEnabled());
        this.m_actSelectAll.setEnabled(bEditable && !this.m_bExpanded && nMappings >= 1);
        this.m_actSelectAllColumns.setEnabled(bEditable && !this.m_bExpanded && nTargetRows >= 1);
        this.m_actQuickMap.setEnabled(bEditable && !this.m_bExpanded && nSourceRows > 0);
        this.m_actExpression.setEnabled(bEditable && this.m_bExpressionsEnabled && nSelectedTargetRows == 1);
        this.m_actImport.setEnabled(bEditable && this.m_bEditableTargetTables);
        this.m_actQuickPropagate.setEnabled(bEditable && this.m_bEditableTargetTables && nSourceRows > 0);
    }

    protected WsAbstractAction createNewMappingAction() {
        return new cNewMappingAction();
    }

    protected WsAbstractAction createNewColumnAction() {
        return new cNewColumnAction();
    }

    protected WsAbstractAction createCommonDeleteAction() {
        return new cCommonDeleteAction();
    }

    protected WsAbstractAction createDeleteMappingsAction() {
        return new cDeleteMappingsAction();
    }

    protected WsAbstractAction createDeleteColumnsAction() {
        return new cDeleteColumnsAction();
    }

    protected WsAbstractAction createExpandAction() {
        return new cExpandAction();
    }

    protected WsAbstractAction createCollapseAction() {
        return new cCollapseAction();
    }

    protected WsAbstractAction createSelectAllAction() {
        return new cSelectAllAction();
    }

    protected WsAbstractAction createSelectAllColumnsAction() {
        return new cSelectAllColumnsAction();
    }

    protected WsAbstractAction createExpressionAction() {
        return new cExpressionAction();
    }

    protected WsAbstractAction createQuickMapAction() {
        return new cQuickMapAction();
    }

    protected WsAbstractAction createImportAction() {
        return new cImportAction();
    }

    protected WsAbstractAction createQuickPropagateAction() {
        return new cQuickPropagateAction();
    }

    protected void onNewMapping(int[] aSourceRows, int[] aTargetRows) {
        int iTargetModelRow = this.m_tblTarget.convertRowIndexToModel(aTargetRows[0]);
        int nSourceRows = aSourceRows.length;
        for (int iSourceRow = 0; iSourceRow < nSourceRows; ++iSourceRow) {
            int iSourceModelRow = this.m_tblSource.convertRowIndexToModel(aSourceRows[iSourceRow]);
            if (this.m_pnlMappings.mappingExists(iSourceModelRow, iTargetModelRow)) continue;
            this.m_pnlMappings.addMapping(iSourceModelRow, iTargetModelRow);
            this.m_pnlMappings.selectMapping(iSourceModelRow, iTargetModelRow);
        }
    }

    protected void onExpressionEdited(int iRow, String sExpression) {
        this.updateMappingType(iRow);
        this.autoMapColumnsFromExpression(iRow, sExpression, false);
    }

    protected void onDeleteMappings(List lMappings) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        this.m_bIgnoreActionUpdates = true;
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_pnlMappings.removeMappings(lMappings);
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromMappings();
            this.m_bIgnoreActionUpdates = false;
            this.updateActions();
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void onNewColumn() {
        this.m_tblTarget.undoableInsertNewRowAfterLastSelectedRow();
    }

    protected void onDeleteColumns(int[] aColumnIndexes) {
        ArrayList lAllMappings = new ArrayList();
        for (int i = 0; i < aColumnIndexes.length; ++i) {
            lAllMappings.addAll(this.m_pnlMappings.findMappingsForRow(aColumnIndexes[i], false));
        }
        this.m_pnlMappings.removeMappings(lAllMappings);
        this.m_tblTarget.undoableDeleteSelectedRows();
    }

    protected void createListeners() {
        this.m_lsnrTableSelection = this.createTableSelectionListener();
        this.m_lsnrTargetTableModel = this.createTargetTableModelListener();
        this.m_lsnrTargetTableRowModel = this.createTargetTableRowModelListener();
        this.m_lsnrMappingsModel = this.createMappingsModelListener();
        this.m_lsnrMappingsSelection = this.createMappingsSelectionListener();
        this.m_lsnrSourceTablePopup = this.createSourceTablePopupMenuRequestListener();
        this.m_lsnrTargetTablePopup = this.createTargetTablePopupMenuRequestListener();
        this.m_lsnrMappingsPanelPopup = this.createMappingsPanelPopupMenuRequestListener();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected TableModelListener createTargetTableModelListener() {
        return new cTargetTableModelListener();
    }

    protected WsTableRowModelListener createTargetTableRowModelListener() {
        return new cTargetTableRowModelListener();
    }

    protected WsObjectListModelListener createMappingsModelListener() {
        return new cMappingsModelListener();
    }

    protected WsObjectSelectionListener createMappingsSelectionListener() {
        return new cMappingsSelectionListener();
    }

    protected WsPopupMenuRequestListener createSourceTablePopupMenuRequestListener() {
        return new cSourceTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTargetTablePopupMenuRequestListener() {
        return new cTargetTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createMappingsPanelPopupMenuRequestListener() {
        return new cMappingsPanelPopupMenuRequestListener();
    }

    protected JPopupMenu createTargetTablePopupMenu() {
        JPopupMenu mnuPop = new JPopupMenu();
        mnuPop.add(new JMenuItem((Action)this.m_actNewColumn));
        mnuPop.add(new JMenuItem((Action)this.m_actNewMapping));
        mnuPop.add(new JMenuItem((Action)this.m_actDeleteColumns));
        mnuPop.addSeparator();
        mnuPop.add(new JMenuItem((Action)this.m_actSelectAllColumns));
        mnuPop.addSeparator();
        mnuPop.add(new JMenuItem((Action)this.m_actImport));
        mnuPop.add(new JMenuItem((Action)this.m_actQuickPropagate));
        mnuPop.add(new JMenuItem((Action)this.m_actQuickMap));
        mnuPop.add(new JMenuItem((Action)this.m_actExpression));
        return mnuPop;
    }

    protected TableCellEditor createExpressionEditor() {
        return new cExpressionEditor();
    }

    protected class cExpressionEditor
    extends WsDialogTableCellEditor {
        public cExpressionEditor() {
            this.setDialog(new cExpressionDialog());
            this.setStopEditingOnDialogClose(true);
            Document doc = this.m_txt.getDocument();
            doc.putProperty("filterNewlines", Boolean.FALSE);
            if (doc instanceof WsLimitedPlainDocument) {
                ((WsLimitedPlainDocument)doc).setSingleLine(false);
            }
        }
    }

    protected class cExtendedObjectsSelector
    extends ObjectsSelectorPanel {
        private List m_lTargetTables;
        private WAComboBox m_cmbTargetTables;
        private JLabel m_lblTargetTables;

        public cExtendedObjectsSelector(List lTargetTables) {
            super(Workspace.getWorkspace().getUserContext(), 4);
            this.m_lTargetTables = lTargetTables;
            this.m_cmbTargetTables = new WAComboBox();
            this.m_cmbTargetTables.addItem((Object)bundle.getString("MappingsPropertyTab.cExtendedObjectsSelector.All.txt"));
            int nTargetTables = this.m_lTargetTables.size();
            for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)this.m_lTargetTables.get(iTargetTable);
                String sTargetTable = TransformationTargetColumnsTableModel.getDataTableDisplayName(oTargetTable);
                this.m_cmbTargetTables.addItem((Object)sTargetTable);
            }
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbTargetTables, (WAdminResource)bundle, (String)"MappingsPropertyTab.cExtendedObjectsSelector.TargetTables");
            this.add(this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)this.m_cmbTargetTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        }

        public List getSelectedTables() {
            if (this.m_cmbTargetTables.getSelectedIndex() == 0) {
                return this.m_lTargetTables;
            }
            ArrayList lTargetTables = new ArrayList(1);
            lTargetTables.add(this.m_lTargetTables.get(this.m_cmbTargetTables.getSelectedIndex() - 1));
            return lTargetTables;
        }
    }

    protected class cMappingsPanelPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cMappingsPanelPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actNewMapping));
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actDeleteMappings));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actSelectAll));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actQuickPropagate));
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actQuickMap));
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actExpression));
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTargetTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cTargetTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = MappingsPropertyTab.this.createTargetTablePopupMenu();
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cSourceTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cSourceTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPop = new JPopupMenu();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actNewMapping));
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actDeleteMappings));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actSelectAll));
            mnuPop.addSeparator();
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actQuickPropagate));
            mnuPop.add(new JMenuItem((Action)MappingsPropertyTab.this.m_actQuickMap));
            mnuPop.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cMappingsSelectionListener
    implements WsObjectSelectionListener {
        protected cMappingsSelectionListener() {
        }

        public void objectChangedSelection(WsObjectSelectionEvent e) {
            MappingsPropertyTab.this.updateActions();
        }
    }

    protected class cMappingsModelListener
    implements WsObjectListModelListener {
        protected cMappingsModelListener() {
        }

        public void objectAdded(WsObjectListModelEvent e) {
            if (MappingsPropertyTab.this.m_pnlMappings.isDragging()) {
                return;
            }
            if (!MappingsPropertyTab.this.isListeningForChanges()) {
                return;
            }
            WsMapping map = (WsMapping)e.getObject();
            int iTarget = map.getTarget();
            if (MappingsPropertyTab.this.updateMappingType(iTarget)) {
                MappingsPropertyTab.this.setDataChanged(true);
                MappingsPropertyTab.this.m_pnlMappings.selectMapping(map);
            } else {
                final WsMapping mapFinal = map;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        MappingsPropertyTab.this.m_pnlMappings.removeMapping(mapFinal);
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        }

        public void objectRemoved(WsObjectListModelEvent e) {
            if (MappingsPropertyTab.this.m_pnlMappings.isDragging()) {
                return;
            }
            if (MappingsPropertyTab.this.isListeningForChanges()) {
                MappingsPropertyTab.this.setDataChanged(true);
            }
            WsMapping map = (WsMapping)e.getObject();
            MappingsPropertyTab.this.updateMappingType(map.getTarget());
        }
    }

    protected class cTargetTableRowModelListener
    implements WsTableRowModelListener {
        protected cTargetTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            if (!MappingsPropertyTab.this.isEditable()) {
                return;
            }
            if (MappingsPropertyTab.this.m_bEditableTargetTables) {
                MappingsPropertyTab.this.setDataChanged(true);
                MappingsPropertyTab.this.m_bOrderChanged = true;
            }
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            if (!MappingsPropertyTab.this.isEditable()) {
                return;
            }
            if (MappingsPropertyTab.this.m_bEditableTargetTables) {
                MappingsPropertyTab.this.setDataChanged(true);
                MappingsPropertyTab.this.m_bOrderChanged = true;
            }
        }
    }

    protected class cTargetTableModelListener
    implements TableModelListener {
        protected cTargetTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (MappingsPropertyTab.this.isListeningForChanges()) {
                MappingsPropertyTab.this.setDataChanged(true);
            }
            if (e.getType() == 0) {
                int iRow = e.getFirstRow();
                int iCol = e.getColumn();
                block1 : switch (iCol) {
                    case 3: {
                        try {
                            String sTable = (String)MappingsPropertyTab.this.m_mdlTarget.getValueAt(iRow, iCol);
                            List lTables = MappingsPropertyTab.this.m_mdlTarget.getDataTables();
                            int nTables = lTables.size();
                            for (int iTable = 0; iTable < nTables; ++iTable) {
                                DataTable tbl = (DataTable)lTables.get(iTable);
                                TransformationTargetColumnsTableModel cfr_ignored_0 = MappingsPropertyTab.this.m_mdlTarget;
                                if (!TransformationTargetColumnsTableModel.getDataTableDisplayName(tbl).equals(sTable)) continue;
                                TransformationTargetColumnsTableModel cfr_ignored_1 = MappingsPropertyTab.this.m_mdlTarget;
                                MappingsPropertyTab.this.m_mdlTarget.setValueAt(tbl.getDesc(), iRow, 4);
                                break block1;
                            }
                            break;
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                            break;
                        }
                    }
                    case 1: {
                        TransformationTargetColumnsTableModel cfr_ignored_2 = MappingsPropertyTab.this.m_mdlTarget;
                        String sExpression = (String)MappingsPropertyTab.this.m_mdlTarget.getValueAt(iRow, 1);
                        MappingsPropertyTab.this.onExpressionEdited(iRow, sExpression);
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (MappingsPropertyTab.this.updateMappingType(iRow)) break;
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                MappingsPropertyTab.this.m_TargetTableUndoManager.undo();
                            }
                        };
                        SwingUtilities.invokeLater(run);
                    }
                }
            }
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MappingsPropertyTab.this.updateActions();
        }
    }

    protected class cQuickPropagateAction
    extends WsAbstractAction {
        public cQuickPropagateAction() {
            super(bundle, "MappingsPropertyTab.QuickPropagate", true);
            this.setMenuSupportId("quickpropagate");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.showQuickPropagateDialog();
        }
    }

    protected class cImportAction
    extends WsAbstractAction {
        public cImportAction() {
            super(bundle, "MappingsPropertyTab.Import", true);
            this.setMenuSupportId("importcolumns");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.showImportColumnsDialog();
        }
    }

    protected class cQuickMapAction
    extends WsAbstractAction {
        public cQuickMapAction() {
            super(bundle, "MappingsPropertyTab.QuickMap", true);
            this.setMenuSupportId("quickmap");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.m_bIgnoreActionUpdates = true;
            MappingsPropertyTab.this.quickMap();
            MappingsPropertyTab.this.m_bIgnoreActionUpdates = false;
            MappingsPropertyTab.this.updateActions();
        }
    }

    protected class cExpressionAction
    extends WsAbstractAction {
        public cExpressionAction() {
            super(bundle, "MappingsPropertyTab.Expression", true);
            this.setMenuSupportId("expression");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = MappingsPropertyTab.this.m_tblTarget.getSelectedRowsFromSelectedCells();
            int iRow = MappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(aSelectedRows[0]);
            TransformationTargetColumnsTableModel cfr_ignored_0 = MappingsPropertyTab.this.m_mdlTarget;
            String sExpression = (String)MappingsPropertyTab.this.m_mdlTarget.getValueAt(iRow, 1);
            sExpression = MappingsPropertyTab.this.showExpressionBuilderDialog(iRow, sExpression);
            if (sExpression != null) {
                TransformationTargetColumnsTableModel cfr_ignored_1 = MappingsPropertyTab.this.m_mdlTarget;
                MappingsPropertyTab.this.m_mdlTarget.setValueAt(sExpression, iRow, 1);
                TransformationTargetColumnsTableModel cfr_ignored_2 = MappingsPropertyTab.this.m_mdlTarget;
                MappingsPropertyTab.this.m_tblTarget.selectCell(MappingsPropertyTab.this.m_tblTarget.convertRowIndexToView(iRow), MappingsPropertyTab.this.m_tblTarget.convertColumnIndexToView(1));
            }
        }
    }

    protected class cSelectAllColumnsAction
    extends WsAbstractAction {
        public cSelectAllColumnsAction() {
            super(bundle, "MappingsPropertyTab.SelectAllColumns");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                MappingsPropertyTab.this.m_bIgnoreActionUpdates = true;
                MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(false);
                MappingsPropertyTab.this.m_tblTarget.selectAll();
            }
            finally {
                MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(true);
                MappingsPropertyTab.this.m_pnlMappings.autoSelectFromTable(false);
                MappingsPropertyTab.this.m_bIgnoreActionUpdates = false;
                MappingsPropertyTab.this.updateActions();
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected class cSelectAllAction
    extends WsAbstractAction {
        public cSelectAllAction() {
            super(bundle, "MappingsPropertyTab.SelectAll");
            this.setMenuSupportId("selectall");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                MappingsPropertyTab.this.m_bIgnoreActionUpdates = true;
                MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(false);
                MappingsPropertyTab.this.m_pnlMappings.selectAllMappings();
            }
            finally {
                MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(true);
                MappingsPropertyTab.this.m_pnlMappings.autoSelectFromMappings();
                MappingsPropertyTab.this.m_bIgnoreActionUpdates = false;
                MappingsPropertyTab.this.updateActions();
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected class cCollapseAction
    extends WsAbstractAction {
        public cCollapseAction() {
            super(bundle, "MappingsPropertyTab.Collapse", true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.removeComponents();
            MappingsPropertyTab.this.m_bExpanded = false;
            MappingsPropertyTab.this.updateActions();
            MappingsPropertyTab.this.layoutComponentsNormal();
            MappingsPropertyTab.this.revalidate();
            MappingsPropertyTab.this.repaint();
        }
    }

    protected class cExpandAction
    extends WsAbstractAction {
        public cExpandAction() {
            super(bundle, "MappingsPropertyTab.Expand", true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.m_tblSource.clearSelection();
            MappingsPropertyTab.this.m_pnlMappings.deselectAllMappings();
            MappingsPropertyTab.this.removeComponents();
            MappingsPropertyTab.this.m_bExpanded = true;
            MappingsPropertyTab.this.updateActions();
            MappingsPropertyTab.this.layoutComponentsExpanded();
            MappingsPropertyTab.this.revalidate();
            MappingsPropertyTab.this.repaint();
        }
    }

    protected class cDeleteColumnsAction
    extends WsAbstractAction {
        public cDeleteColumnsAction() {
            super(bundle, "MappingsPropertyTab.DeleteColumns", true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            MappingsPropertyTab.this.m_bIgnoreActionUpdates = true;
            MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(false);
            try {
                int[] aRows = MappingsPropertyTab.this.m_tblTarget.getSelectedRowsFromSelectedCells();
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    aRows[iRow] = MappingsPropertyTab.this.m_tblTarget.convertRowIndexToModel(aRows[iRow]);
                }
                MappingsPropertyTab.this.onDeleteColumns(aRows);
            }
            finally {
                MappingsPropertyTab.this.m_pnlMappings.setAutoSelectEnabled(true);
                MappingsPropertyTab.this.m_pnlMappings.autoSelectFromTable(false);
                MappingsPropertyTab.this.m_bIgnoreActionUpdates = false;
                MappingsPropertyTab.this.updateActions();
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected class cDeleteMappingsAction
    extends WsAbstractAction {
        public cDeleteMappingsAction() {
            super(bundle, "MappingsPropertyTab.DeleteMappings", true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.onDeleteMappings(MappingsPropertyTab.this.m_pnlMappings.getSelectedMappings());
        }
    }

    protected class cCommonDeleteAction
    extends WsAbstractAction {
        public cCommonDeleteAction() {
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            if (MappingsPropertyTab.this.m_actDeleteMappings.isEnabled()) {
                MappingsPropertyTab.this.m_actDeleteMappings.actionPerformed(e);
            } else {
                MappingsPropertyTab.this.m_actDeleteColumns.actionPerformed(e);
            }
        }
    }

    protected class cNewColumnAction
    extends WsAbstractAction {
        public cNewColumnAction() {
            super(bundle, "MappingsPropertyTab.NewColumn", true);
            this.setMenuSupportId("newcolumn");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsPropertyTab.this.onNewColumn();
        }
    }

    protected class cNewMappingAction
    extends WsAbstractAction {
        public cNewMappingAction() {
            super(bundle, "MappingsPropertyTab.NewMapping", true);
            this.setMenuSupportId("newmapping");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSourceRows = MappingsPropertyTab.this.m_tblSource.getSelectedRowsFromSelectedCells();
            int[] aTargetRows = MappingsPropertyTab.this.m_tblTarget.getSelectedRowsFromSelectedCells();
            MappingsPropertyTab.this.onNewMapping(aSourceRows, aTargetRows);
        }
    }

    protected static class WsQuickMapColumn {
        protected String m_sColumnName;
        protected String m_sColumnType;
        protected int m_nColumnLength;
        protected Object m_oUserValue;

        public WsQuickMapColumn() {
            this("", "", -1);
        }

        public WsQuickMapColumn(String sColumnName, String sColumnType, int nColumnLength) {
            this(sColumnName, sColumnType, nColumnLength, null);
        }

        public WsQuickMapColumn(String sColumnName, String sColumnType, int nColumnLength, Object oUserValue) {
            this.m_sColumnName = sColumnName;
            this.m_sColumnType = sColumnType;
            this.m_nColumnLength = nColumnLength;
            this.m_oUserValue = oUserValue;
        }

        public void setColumnName(String sColumnName) {
            this.m_sColumnName = sColumnName;
        }

        public String getColumnName() {
            return this.m_sColumnName;
        }

        public void setColumnType(String sColumnType) {
            this.m_sColumnType = sColumnType;
        }

        public String getColumnType() {
            return this.m_sColumnType;
        }

        public void setColumnLength(int nColumnLength) {
            this.m_nColumnLength = nColumnLength;
        }

        public int getColumnLength() {
            return this.m_nColumnLength;
        }

        public void setUserValue(Object oUserValue) {
            this.m_oUserValue = oUserValue;
        }

        public Object getUserValue() {
            return this.m_oUserValue;
        }
    }

    protected class cExpressionDialog
    implements WsDialogTableCellEditorInterface {
        protected cExpressionDialog() {
        }

        public String showDialog(JTable tbl, int iRow, int iCol, String sValue) {
            iRow = ((WsTable)tbl).convertRowIndexToModel(iRow);
            return MappingsPropertyTab.this.showExpressionBuilderDialog(iRow, sValue);
        }
    }
}

