/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.CodeEditor;
import com.sas.entities.GUID;
import com.sas.etl.models.job.IGeneratedTransformDefinition;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.prompts.visuals.PromptDesignTimePanel;
import com.sas.wadmin.visuals.MacroGeneralPanel;
import com.sas.wadmin.visuals.MacroOptionsTemplatesPanel;
import com.sas.wadmin.visuals.MacroOptionsTransformPropertiesPanel;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class MacroPluginWizard
extends WAWizardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(MacroPluginWizard.class);
    boolean m_fExisting = false;
    boolean m_cancelPressed = false;
    private static final String PROTOTYPE_KEY = "PROTOTYPE";
    private SimpleObject m_folder = null;

    public MacroPluginWizard(Frame frame) {
        this(frame, null, null);
    }

    protected boolean onCancel() {
        this.m_cancelPressed = true;
        return super.onCancel();
    }

    public boolean getCancelStatus() {
        return this.m_cancelPressed;
    }

    public MacroPluginWizard(Frame frame, Prototype prototype, SimpleObject folder) {
        this(frame, prototype, folder, null);
    }

    public MacroPluginWizard(Frame frame, Prototype prototype, SimpleObject folder, String sCategory) {
        super(frame, bundle.getString("MacroPluginWizard.title.txt"), true);
        this.m_folder = folder;
        if (prototype != null) {
            this.addWizardData(PROTOTYPE_KEY, prototype);
            this.m_fExisting = true;
        }
        if (sCategory != null && sCategory.length() > 0) {
            this.addWizardData("PROCESSTREEFOLDER", sCategory);
        }
        this.addWizardData("FINISHINFO", "");
        MdObjectStore store = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        Tree defaultFolder = null;
        try {
            if (this.m_folder != null) {
                defaultFolder = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, this.m_folder);
            }
            if (defaultFolder == null) {
                defaultFolder = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (RemoteException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
        ImageIcon image = bundle.getImageIcon("SourceDesigner.FirstTab.image");
        cGeneralTab macroGeneralTab = new cGeneralTab();
        WAGeneralPanel generalPanel = macroGeneralTab.getGeneralPanel();
        String sName = WsMetadataNameUtil.getUniqueNameForType((String)"Prototype", (String)bundle.getString("NewTransformation.DefaultName.txt"));
        generalPanel.setNameField(sName);
        generalPanel.setOwningTree(defaultFolder);
        this.addWizardData("GENERALPANEL", generalPanel);
        MacroGeneralPanel macroGeneralPanel = macroGeneralTab.getMacroGeneralPanel();
        this.addWizardData("MACROGENERALPANEL", (Object)macroGeneralPanel);
        this.setResizable(true);
        this.addTab(bundle.getString("MacroPluginWizard.General.Title"), "MacroPluginWizardtab1", (WAPropertyTab)macroGeneralTab, "warehouse_w1.gif", image, false);
        cEditorTab editorTab = new cEditorTab();
        this.addTab(bundle.getString("MacroPluginWizard.Editor.Title"), "MacroPluginWizardtab2", (WAPropertyTab)editorTab, "warehouse_w1.gif", image, false);
        this.addTabToCleanupOnCancel((WAPropertyTab)editorTab);
        this.addTab(bundle.getString("MacroPluginWizard.Options.Title"), "MacroPluginWizardtab3", (WAPropertyTab)new cOptionsTab(), "warehouse_w1.gif", image, false);
        this.addTab(bundle.getString("MacroOptionsTransformPropertiesTab.title"), "MacroPluginWizardtab4", (WAPropertyTab)new cTransformOptionsTab(), "warehouse_w1.gif", image, false);
        image = bundle.getImageIcon("SourceDesigner.FinishTab.image");
        this.addTab(bundle.getString("FinishTab.Title.txt"), "MacroPluginWizardtab5", (WAPropertyTab)new cFinishTab(), "warehouse_w1.gif", image, true);
    }

    protected class cFinishTab
    extends WizardFinishTab {
        WAWizardDialog m_parent;

        public cFinishTab() {
            super(bundle.getString("SourceDesigner.finishtabtitle.txt"));
            this.m_parent = null;
            this.m_parent = MacroPluginWizard.this;
        }

        public boolean validateData() {
            if (!super.validateData()) {
                return false;
            }
            WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
            Prototype prototype = (Prototype)dlgWizard.getWizardData("MASTEROBJECT");
            try {
                Tree folder = (Tree)prototype.getTrees().get(0);
                boolean bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)prototype.getName(), (Tree)folder, (String)"GeneratedTransform");
                if (!bIsUniqueName) {
                    MessageUtil.displayMessage((String)bundle.formatString("NewTransformation.Error.DuplicateName.txt", (Object)prototype.getName(), (Object)folder.getName()), (int)0);
                    return false;
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                return false;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return true;
        }
    }

    protected class cTransformOptionsTab
    extends WsDescriptionWizardTab {
        private WAWizardDialog m_parent;
        MacroOptionsTransformPropertiesPanel m_pnlTransformProperties;
        Prototype m_prototype;

        public cTransformOptionsTab() {
            super(bundle.getString("cTransformOptionsTab.Top.txt"));
            this.m_parent = null;
            this.m_prototype = null;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen_transform_props");
            this.initialize();
        }

        public void initialize() {
            this.m_parent = MacroPluginWizard.this;
            this.m_pnlTransformProperties = new MacroOptionsTransformPropertiesPanel(this.m_parent);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.m_pnlTransformProperties));
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (bSaveToModel) {
                this.moveDataToStore();
            } else {
                WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
                this.m_prototype = (Prototype)dlgWizard.getWizardData("MASTEROBJECT");
                this.populateStore();
                this.moveDataToView();
            }
            return true;
        }

        public void populateStore() throws MdException, RemoteException {
            this.m_pnlTransformProperties.setMetadataObject((Prototype)this.m_parent.getWizardData(MacroPluginWizard.PROTOTYPE_KEY));
            this.m_pnlTransformProperties.populateStore();
        }

        public void moveDataToView() throws MdException, RemoteException {
        }

        public void moveDataToStore() throws MdException, RemoteException {
            this.m_pnlTransformProperties.moveDataToStore();
            this.m_prototype = (Prototype)this.m_parent.getWizardData(MacroPluginWizard.PROTOTYPE_KEY);
            TextStore textStore = (TextStore)this.m_parent.getWizardData("MPTEXTSTORE");
            StringBuffer storedText = (StringBuffer)this.m_parent.getWizardData("MPSTOREDTEXT");
            Property transformationTemplate = (Property)this.m_parent.getWizardData("MPTTPROPERTY");
            transformationTemplate.setStoredConfiguration((Text)textStore);
            String prototypeName = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.m_prototype.getName());
            String prototypeDesc = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(this.m_prototype.getDesc());
            storedText.append(" Name=\"");
            storedText.append(prototypeName);
            storedText.append("\" Desc=\"" + prototypeDesc + "\" IsActive=\"1\" TransformRole=\"" + "TransformationStep2" + "\" >");
            storedText.append(MacroPluginUtilities.populateAssociationProperties(this.m_prototype, this.m_pnlTransformProperties.getTemplatesPanel()));
            storedText.append("<PropertySets><PropertySet Name=\"OPTIONS\" SetRole=\"OPTIONS\">");
            storedText.append("<Properties>");
            storedText.append("<Property Name=\"syslast\" PropertyName=\"SYSLAST\" SQLType=\"1\" DefaultValue=\"YES\">");
            storedText.append("</Property>");
            storedText.append("</Properties></PropertySet>");
            storedText.append("</PropertySets>");
            storedText.append("<Transformations><ClassifierMap Name=\"" + prototypeName + "\" TransformRole=\"norole\" IsActive=\"1\">");
            MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("MPOPTIONSSTORE");
            store.flushUpdatesToParentStore();
            String strGUID = GUID.newGUID();
            PromptGroupInterface rootPromptGroup = (PromptGroupInterface)this.m_parent.getWizardData("MPOPTIONS");
            if (!this.m_pnlTransformProperties.getTemplatesPanel().getGenerateDeleteCode()) {
                rootPromptGroup.addPromptDefinition((PromptDefinitionInterface)MacroOptionsTemplatesPanel.createDontDeleteOutputsPrompt());
            }
            PromptUtils.savePromptGroupToMetadataObject((UserContextInterface)Workspace.getWorkspace().getUserContext(), (String)this.m_prototype.getRepositoryID(), (PromptGroupInterface)rootPromptGroup, (Root)this.m_prototype);
            storedText.append("<ClassifierTargets>");
            int minOutputs = this.m_pnlTransformProperties.getMinOutputs();
            List outputNames = this.m_pnlTransformProperties.getListOfMacroNames(false);
            for (int g = 0; g < minOutputs; ++g) {
                String name = null;
                name = outputNames != null && outputNames.size() >= g + 1 ? (String)outputNames.get(g) : "_OUTPUT" + Integer.toString(g);
                storedText.append("<WorkTable Name=\"" + prototypeName + "\" Desc=\"" + name + "\"/>");
            }
            storedText.append("</ClassifierTargets>");
            storedText.append("<UsingPrototype><Prototype Name=\"ClassifierPrototype\" MetadataType=\"ClassifierMap\">");
            storedText.append("<Properties><Property Name=\"ClassifierMap Template\" isRequired=\"1\" PropertyName=\"GetXML\" PropertyRole=\"GetXML\">");
            storedText.append("<StoredConfiguration>");
            storedText.append(this.m_parent.getWizardData("MPSOURCECODE") + "</StoredConfiguration></Property></Properties></Prototype></UsingPrototype>");
            storedText.append("</ClassifierMap></Transformations>");
            storedText.append("<Properties>");
            storedText.append("<Property Name=\"").append("Class").append("\" PropertyName=\"").append("Class").append("\" DefaultValue=\"" + strGUID + "\" PropertyRole=\"").append("ESMACRO").append("\" SQLType=\"12\"/>");
            storedText.append("<Property Name=\"VERSION\" PropertyName=\"TRANSFORMVERSION\" PropertyRole=\"VERSION\" DefaultValue=\"1\" SQLType=\"4\"/>");
            storedText.append("</Properties></TransformationStep>");
            Workspace.getDefaultLogger().debug((Object)("****TRANSFORM****: " + storedText.toString()));
            textStore.setStoredText(storedText.toString());
            MdObjectStore parentstore = (MdObjectStore)this.m_prototype.getObjectStore();
            MacroPluginUtilities.createGUIDProperty(this.m_prototype, strGUID);
            String value = parentstore.createXMLforStore();
            Workspace.getDefaultLogger().debug((Object)("***STORE***" + value));
            Workspace.getDefaultLogger().debug((Object)Workspace.getMdFactory().getOMIUtil().formatXML(value));
            String totalValue = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><AddMetadata><Metadata>" + value + "</Metadata><Reposid>_ReposID_</Reposid><ns>SAS</ns><flags>268435456</flags><options/></AddMetadata>";
            this.m_parent.addWizardData("MPOUTPUTXML", (Object)totalValue);
            store.dispose();
        }

        protected void updateStoreIDS(MdObjectStore store) throws RemoteException {
            ArrayList changes = new ArrayList();
            Map map = store.getDetailObjectMap();
            Set keys = map.keySet();
            Iterator cIter = keys.iterator();
            while (cIter.hasNext()) {
                changes.add(cIter.next());
            }
            for (int i = 0; i < changes.size(); ++i) {
                String realKey = "$" + (i + 1);
                store.changeHashKey((String)changes.get(i), realKey);
            }
        }

        public String createFinishString() {
            return this.m_pnlTransformProperties.createFinishString();
        }

        public boolean validateData() {
            return this.m_pnlTransformProperties.validateData();
        }

        public void onNext() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onNext();
            this.m_parent.setCursor(null);
        }

        public void onBack() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onBack();
            this.m_parent.setCursor(null);
        }
    }

    protected class cOptionsTab
    extends WsDescriptionWizardTab {
        private WAWizardDialog m_parent;
        MdObjectStore m_store;
        boolean fFirstTime;
        private PromptDesignTimePanel m_panel;

        public cOptionsTab() {
            super(bundle.getString("cOptionsTab.Top.txt"));
            this.m_parent = null;
            this.m_store = null;
            this.fFirstTime = true;
            this.m_panel = null;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen_sascode_options");
            this._initialize();
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                if (this.fFirstTime) {
                    MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
                    this.m_store = Workspace.getMdFactory().createObjectStore((MdStore)store);
                    this.m_parent.addWizardData("MPOPTIONSSTORE", (Object)this.m_store);
                    this.fFirstTime = false;
                }
            } else {
                this.m_parent.addWizardData("MPOPTIONS", (Object)this.m_panel.getPromptGroup());
            }
            return true;
        }

        public boolean validateData() {
            return true;
        }

        public void onNext() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onNext();
            this.m_parent.setCursor(null);
        }

        public void onBack() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onBack();
            this.m_parent.setCursor(null);
        }

        void _initialize() {
            this.m_parent = MacroPluginWizard.this;
            this.setLayout(new GridBagLayout());
            this.m_panel = new PromptDesignTimePanel(null, false, null, true, true);
            this.add((Component)((Object)this.m_panel), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String createFinishString() {
            String temp = "";
            List prompts = this.m_panel.getPromptGroup().getPromptDefinitions(true);
            if (prompts == null) {
                return temp;
            }
            for (int i = 0; i < prompts.size(); ++i) {
                PromptDefinitionInterface prompt = (PromptDefinitionInterface)prompts.get(i);
                temp = temp + bundle.formatString("MacroPluginWizard.OPTIONS.FINISH.txt", (Object)prompt.getPromptLabel(Locale.getDefault()), (Object)PromptUtility.getTypeLabelForPromptObject((Object)prompt)) + "\n";
            }
            temp = temp + "\n";
            return temp;
        }
    }

    protected class cEditorTab
    extends WsDescriptionWizardTab {
        private WAWizardDialog m_parent;
        private CodeEditor m_editor;
        Prototype m_prototype;

        public cEditorTab() {
            super(bundle.getString("cEditorTab.Top.txt"));
            this.m_parent = null;
            this.m_prototype = null;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen_sascode");
            this._initialize();
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (bSaveToModel) {
                String strText = this.m_editor.getText();
                String strNormalized = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strText);
                Workspace.getDefaultLogger().debug((Object)("Normalized: " + strNormalized));
                String sourceCode = "<TextStore Name=\"SourceCode\" TextRole=\"SASCODE\" StoredText=\"" + strNormalized + "\"/>";
                this.m_parent.addWizardData("MPSOURCECODE", (Object)sourceCode);
                this.m_parent.addWizardData("SOURCE", (Object)strText);
            } else {
                MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
                WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
                WAGeneralPanel panel = (WAGeneralPanel)dlgWizard.getWizardData("GENERALPANEL");
                MacroGeneralPanel macroGeneralPanel = (MacroGeneralPanel)((Object)dlgWizard.getWizardData("MACROGENERALPANEL"));
                Tree mdoFolder = panel.getOwningTree();
                dlgWizard.addWizardData("GROUP", (Object)mdoFolder);
                Prototype masterObject = (Prototype)dlgWizard.getWizardData("MASTEROBJECT");
                if (masterObject == null) {
                    String sContainerID = null;
                    sContainerID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9, 17) : mdoFolder.getFQID().substring(0, 8);
                    masterObject = this.createObjects(store, sContainerID, mdoFolder, dlgWizard, panel);
                    MacroPluginUtilities.updatePrototypeVersion(masterObject, true);
                } else {
                    if (!Workspace.getWorkspace().isChangeManagementOn()) {
                        String sPrototypeRepositoryID;
                        String sTreeRepositoryID = mdoFolder.getFQID().substring(0, 8);
                        if (!sTreeRepositoryID.equalsIgnoreCase(sPrototypeRepositoryID = masterObject.getFQID().substring(0, 8))) {
                            store.clearObjectsFromStore();
                            this.createObjects(store, sTreeRepositoryID, mdoFolder, dlgWizard, panel);
                        } else {
                            String strExistingOwningTree;
                            String strNewOwningTree = panel.getOwningTree().getFQID();
                            if (strNewOwningTree != (strExistingOwningTree = ((Tree)masterObject.getTrees().get(0)).getFQID())) {
                                masterObject.getTrees().removeAllElements();
                                masterObject.getTrees().add((Object)mdoFolder);
                            }
                        }
                    } else {
                        String strExistingOwningTree;
                        String strNewOwningTree = mdoFolder.getFQID();
                        if (strNewOwningTree != (strExistingOwningTree = ((Tree)masterObject.getTrees().get(0)).getFQID())) {
                            masterObject.getTrees().removeAllElements();
                            masterObject.getTrees().add((Object)mdoFolder);
                        }
                    }
                    masterObject.setName(panel.getNameComponent().getText());
                    masterObject.setDesc(panel.getDescriptionComponent().getText());
                }
                GeneratedTransformationUtilities.setProcessTreePath((Root)masterObject, (String)macroGeneralPanel.getProcessLibraryFolderName());
                super.moveDataToView();
            }
            return true;
        }

        private Prototype createObjects(MdObjectStore store, String sContainerID, Tree mdoFolder, WAWizardDialog dlgWizard, WAGeneralPanel panel) throws RemoteException, MdException {
            Prototype prototype = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, panel.getNameComponent().getText(), "Prototype", sContainerID);
            prototype.setMetadataType("TransformationStep2");
            prototype.setPublicType("GeneratedTransform");
            prototype.setUsageVersion(IGeneratedTransformDefinition.CURRENT_VERSION.encode());
            prototype.getTrees().add((Object)mdoFolder);
            prototype.setDesc(panel.getDescriptionComponent().getText());
            Property property = (Property)Workspace.getMdFactory().createComplexMetadataObject(store, "TransformationTemplate", "Property", sContainerID);
            property.setSQLType(1);
            property.setIsRequired(1);
            property.setIsVisible(1);
            property.setIsExpert(0);
            property.setPropertyName("GetXML");
            property.setPropertyRole("GetXML");
            prototype.getProperties().add((Object)property);
            TextStore textStore = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, "TransformationTemplate", "TextStore", sContainerID);
            textStore.setTextRole("TEMPLATE");
            property.getStoredConfigurations().add((Object)textStore);
            StringBuffer storedText = new StringBuffer("<TransformationStep ");
            dlgWizard.addWizardData(MacroPluginWizard.PROTOTYPE_KEY, (Object)prototype);
            dlgWizard.addWizardData("MASTEROBJECT", (Object)prototype);
            dlgWizard.addWizardData("MPTTPROPERTY", (Object)property);
            dlgWizard.addWizardData("MPTEXTSTORE", (Object)textStore);
            dlgWizard.addWizardData("MPSTOREDTEXT", (Object)storedText);
            return prototype;
        }

        public boolean validateData() {
            return true;
        }

        public void onNext() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onNext();
            this.m_parent.setCursor(null);
        }

        public void onBack() {
            this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
            super.onBack();
            this.m_parent.setCursor(null);
        }

        void _initialize() {
            this.m_parent = MacroPluginWizard.this;
            Workspace frmMain = Workspace.getWorkspace();
            this.m_editor = new CodeEditor(frmMain.getCodeEditorDefaults());
            this.m_editor.setPreferredSize(new Dimension(200, 100));
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_editor);
        }

        public String createFinishString() {
            String temp = "\n" + bundle.formatString("MacroPluginWizard.SOURCECODE.FINISH.txt", (Object)this.m_editor.getText()) + "\n\n";
            return temp;
        }

        public void saveSettingsAndCleanUp() {
            if (this.m_editor != null) {
                this.m_editor.cleanup();
            }
            this.m_editor = null;
        }
    }

    protected class cGeneralTab
    extends WsDescriptionWizardTab {
        private WAWizardDialog m_parent;
        private MacroGeneralPanel m_macroGeneralPanel;

        public cGeneralTab() {
            super(bundle.getString("cGeneralTab.Top.txt"));
            this.m_parent = null;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen");
            this._initialize();
        }

        void _initialize() {
            this.m_parent = MacroPluginWizard.this;
            this.m_macroGeneralPanel = new MacroGeneralPanel();
            this.setLayout(new GridBagLayout());
            this.add((Component)((Object)this.m_macroGeneralPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public WAGeneralPanel getGeneralPanel() {
            return this.m_macroGeneralPanel.getGeneralPanel();
        }

        public MacroGeneralPanel getMacroGeneralPanel() {
            return this.m_macroGeneralPanel;
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                this.m_macroGeneralPanel.populateStore();
                this.m_macroGeneralPanel.moveDataToView();
                WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
                String strDefaultCategoryName = (String)dlgWizard.getWizardData("PROCESSTREEFOLDER");
                if (strDefaultCategoryName == null) {
                    strDefaultCategoryName = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("TransformationsTreeDefaultCategory", "UNAVAILABLE");
                }
                if (strDefaultCategoryName != null && strDefaultCategoryName.length() > 0 && !strDefaultCategoryName.equalsIgnoreCase("UNAVAILABLE")) {
                    this.m_macroGeneralPanel.setProcessLibraryFolderName(strDefaultCategoryName);
                }
            } else {
                this.m_macroGeneralPanel.moveDataToStore();
            }
            return true;
        }

        public boolean validateData() {
            return this.m_macroGeneralPanel.validateData();
        }

        public String createFinishString() {
            StringBuffer temp = new StringBuffer();
            try {
                String folder;
                Tree groupTree;
                temp.append(bundle.getString("MacroPluginWizard.CREATINGSTART.FINISH.txt")).append("\n\n").append(bundle.formatString("MacroPluginWizard.CREATING.FINISH.txt", (Object)this.m_macroGeneralPanel.getNameText())).append("\n");
                String description = this.m_macroGeneralPanel.getDescription();
                if (description.length() > 0) {
                    temp.append(bundle.formatString("MacroPluginWizard.CREATINGDESC.FINISH.txt", (Object)this.m_macroGeneralPanel.getDescription())).append("\n");
                }
                if ((groupTree = (Tree)this.m_parent.getWizardData("GROUP")) != null) {
                    temp.append(bundle.formatString("MacroPluginWizard.CREATINGFOLDER.FINISH.txt", (Object)groupTree.getName())).append("\n");
                }
                if ((folder = this.m_macroGeneralPanel.getProcessLibraryFolderName()) != null && folder.length() > 0) {
                    temp.append(bundle.formatString("MacroPluginWizard.CREATINGLOC.FINISH.txt", (Object)folder)).append("\n");
                    Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("TransformationsTreeDefaultCategory", folder);
                } else {
                    Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("TransformationsTreeDefaultCategory", "UNAVAILABLE");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return temp.toString();
        }
    }
}

