/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.entities.GUID;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDMetadataParsing;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformArchiveInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformOrderMattersInterface;
import com.sas.wadmin.visuals.MacroOptionsTemplatesPanel;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginPropertiesView;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsBaseView;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JInternalFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MacroPluginUtilities {
    private static WAdminResource bundle = WAdminResource.getBundle(MacroPluginUtilities.class);
    public static final String DEFAULT = "DEFAULT";
    public static final String DISPLAY = "DISPLAY";
    public static final int TURNONDISPLAY = 0;
    public static final int TURNOFFDISPLAY = 1;
    public static final String INPUT = "INPUT";
    public static final String OUTPUT = "OUTPUT";
    public static final String VERSION_PROPERTY_NAME = "VERSION";
    public static final String CLASS = "Class";
    public static final String ESMACRO = "ESMACRO";
    public static final String GENERATED_TRANSFORM_TRANSFORMATIONSTEP_ROLE = "TransformationStep2";

    private MacroPluginUtilities() {
    }

    public static StringBuffer populateWorkTableNames(Prototype prototype, MacroOptionsTemplatesPanel panel) {
        StringBuffer storedText = new StringBuffer();
        try {
            for (int i = 0; i < panel.getMinOutputs(); ++i) {
                storedText.append("<WorkTable Name=\"" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(prototype.getName()) + "\" />");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return storedText;
    }

    public static CMetadata getNextAvailableObjectToConnectTo(MdObjectStore newStore, TransformationStep replacingStep, String strType) throws MdException, RemoteException {
        if (replacingStep.getUsingPrototypes().isEmpty()) {
            return null;
        }
        AssociationList properties = ((Prototype)replacingStep.getUsingPrototypes().get(0)).getPrototypeProperties();
        if (strType.equalsIgnoreCase(INPUT)) {
            AssociationProperty defaultAssoc = null;
            for (int i = 0; i < properties.size(); ++i) {
                AssociationProperty property = (AssociationProperty)properties.get(i);
                if (!property.getMetadataType().equalsIgnoreCase(INPUT)) continue;
                if (MacroPluginUtilities.isGeneratedTransform((Root)replacingStep)) {
                    if (MacroPluginUtilities.isTemplateDefault(property)) {
                        return null;
                    }
                    if (property.getUsingPrototypes(false).size() != 0) continue;
                    return property;
                }
                if (!MacroPluginUtilities.isOrderTypeTransform(replacingStep)) continue;
                if (MacroPluginUtilities.isTemplateDefault(property)) {
                    defaultAssoc = property;
                    continue;
                }
                if (property.getUsingPrototypes(false).size() != 0) continue;
                return property;
            }
            if (MacroPluginUtilities.isOrderTypeTransform(replacingStep) && defaultAssoc != null) {
                return defaultAssoc;
            }
            return null;
        }
        ClassifierMap map = (ClassifierMap)replacingStep.getTransformations().get(0);
        for (int p = 0; p < map.getClassifierTargets(false).size(); ++p) {
            WorkTable table = (WorkTable)map.getClassifierTargets(false).get(p);
            if (table.getSourceClassifierMaps(false).size() != 0) continue;
            return table;
        }
        return null;
    }

    public static AssociationProperty getNextAvailableOutputObjectToConnectTo(MdObjectStore newStore, TransformationStep replacingStep) throws MdException, RemoteException {
        if (replacingStep.getUsingPrototypes().isEmpty()) {
            return null;
        }
        AssociationList properties = ((Prototype)replacingStep.getUsingPrototypes().get(0)).getPrototypeProperties();
        for (int i = 0; i < properties.size(); ++i) {
            AssociationProperty property = (AssociationProperty)properties.get(i);
            if (!property.getMetadataType().equalsIgnoreCase(OUTPUT)) continue;
            if (MacroPluginUtilities.isTemplateDefault(property)) {
                return null;
            }
            if (property.getUsingPrototypes(false).size() != 0) continue;
            return property;
        }
        return null;
    }

    public static StringBuffer populateAssociationProperties(Prototype prototype, MacroOptionsTemplatesPanel panel) {
        int outputLoopLength;
        int i;
        int inputLoopLength;
        StringBuffer storedText = new StringBuffer();
        boolean fStartOfString = false;
        int minInputs = panel.getMinInputs();
        int maxInputs = panel.getMaxInputs();
        int minOutputs = panel.getMinOutputs();
        int maxOutputs = panel.getMaxOutputs();
        List inputNames = panel.getListOfMacroNames(true);
        List inputPrompts = panel.getListOfMacroPrompts(true);
        List outputNames = panel.getListOfMacroNames(false);
        List outputPrompts = panel.getListOfMacroPrompts(false);
        if (minInputs > 0 || maxInputs > 0 || minOutputs > 0 || maxOutputs > 0 || maxInputs == -1 || maxOutputs == -1) {
            fStartOfString = true;
            storedText.append("<UsingPrototype>");
            storedText.append("<Prototype Name=\"PFDTEMPLATE\">");
            storedText.append("<PrototypeProperties>");
        }
        if (minInputs == -1 || minInputs == 0 && maxInputs == -1) {
            inputLoopLength = inputPrompts == null ? 0 : inputPrompts.size();
            for (i = 0; i < inputLoopLength; ++i) {
                storedText.append(MacroPluginUtilities.getNextInputProperty(inputPrompts, inputNames, 0, minInputs, maxInputs, false));
            }
            storedText.append(MacroPluginUtilities.getNextInputProperty(inputPrompts, inputNames, 0, minInputs, maxInputs, true));
        } else if (minInputs > 0 || maxInputs > 0) {
            inputLoopLength = inputPrompts == null ? minInputs : (minInputs < inputPrompts.size() ? inputPrompts.size() : minInputs);
            for (i = 0; i < inputLoopLength; ++i) {
                storedText.append(MacroPluginUtilities.getNextInputProperty(inputPrompts, inputNames, i, minInputs, maxInputs, false));
            }
            if (inputPrompts == null && (maxInputs > 0 || maxInputs == -1) || inputPrompts != null && (maxInputs > inputPrompts.size() || maxInputs == -1)) {
                storedText.append(MacroPluginUtilities.getNextInputProperty(inputPrompts, inputNames, inputLoopLength, minInputs, maxInputs, true));
            }
        }
        if (minOutputs == -1 || minOutputs == 0 && maxOutputs == -1) {
            outputLoopLength = outputPrompts == null ? 0 : outputPrompts.size();
            for (i = 0; i < outputLoopLength; ++i) {
                storedText.append(MacroPluginUtilities.getNextOutputProperty(outputPrompts, outputNames, 0, minOutputs, maxOutputs, false));
            }
            storedText.append(MacroPluginUtilities.getNextOutputProperty(outputPrompts, outputNames, 0, minOutputs, maxOutputs, true));
        } else if (minOutputs > 0 || maxOutputs > 0) {
            outputLoopLength = outputPrompts == null ? minOutputs : (minOutputs < outputPrompts.size() ? outputPrompts.size() : minOutputs);
            for (i = 0; i < outputLoopLength; ++i) {
                storedText.append(MacroPluginUtilities.getNextOutputProperty(outputPrompts, outputNames, i, minOutputs, maxOutputs, false));
            }
            if (outputPrompts == null && (maxOutputs > 0 || maxOutputs == -1) || outputPrompts != null && (maxOutputs > outputPrompts.size() || maxOutputs == -1)) {
                storedText.append(MacroPluginUtilities.getNextOutputProperty(outputPrompts, outputNames, outputLoopLength, minOutputs, maxOutputs, true));
            }
        }
        if (fStartOfString) {
            storedText.append("</PrototypeProperties></Prototype></UsingPrototype>");
        }
        return storedText;
    }

    public static StringBuffer getNextInputProperty(List inputPrompts, List inputNames, int iNextVar, int iMinInputs, int iMaxInputs, boolean fIsDefault) {
        StringBuffer storedText = new StringBuffer();
        try {
            storedText.append("<AssociationProperty Name=\"");
            if (fIsDefault) {
                storedText.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(bundle.getString("MacroOptionsDefineTemplatesPanel.DefaultTemplate.txt")) + "\"");
                storedText.append(" PartnerName= \"").append(DEFAULT).append("\"");
            } else {
                String macroName;
                String strPrompt;
                if (inputPrompts != null && inputPrompts.size() > iNextVar) {
                    strPrompt = (String)inputPrompts.get(iNextVar);
                    macroName = (String)inputNames.get(iNextVar);
                } else {
                    strPrompt = bundle.getString("MacroOptionsDefineTemplatesPanel.DefaultTemplate.txt");
                    macroName = "_INPUT" + Integer.toString(iNextVar);
                }
                storedText.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strPrompt) + "\"");
                storedText.append(" PartnerName= \"" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(macroName) + ":\"");
            }
            storedText.append(" MetadataType=\"INPUT\" AssociationName=\"ClassifierSources\" ");
            storedText.append(" Minimum=\"");
            storedText.append(Integer.toString(iMinInputs == -1 ? 0 : iMinInputs));
            storedText.append("\" Maximum=\"");
            storedText.append(Integer.toString(iMaxInputs == -1 ? 0 : iMaxInputs));
            storedText.append("\" ");
            if (iMinInputs > -1 && iNextVar < iMinInputs && !fIsDefault) {
                storedText.append(" IsRequired=\"1\"");
            }
            storedText.append(" IsVisible=\"1\"/>");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return storedText;
    }

    public static StringBuffer getNextOutputProperty(List outputPrompts, List outputNames, int iNextVar, int iMinOutputs, int iMaxOutputs, boolean fIsDefault) {
        StringBuffer storedText = new StringBuffer();
        try {
            storedText.append("<AssociationProperty Name=\"");
            if (fIsDefault) {
                storedText.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(bundle.getString("MacroOptionsDefineTemplatesPanel.DefaultTemplate.txt")) + "\"");
                storedText.append(" PartnerName= \"").append(DEFAULT).append("\"");
            } else {
                String macroName;
                String strPrompt;
                if (outputPrompts != null && outputPrompts.size() > iNextVar) {
                    strPrompt = (String)outputPrompts.get(iNextVar);
                    macroName = (String)outputNames.get(iNextVar);
                } else {
                    strPrompt = bundle.getString("MacroOptionsDefineTemplatesPanel.DefaultTemplate.txt");
                    macroName = "_OUTPUT" + Integer.toString(iNextVar);
                }
                storedText.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strPrompt) + "\"");
                storedText.append(" PartnerName= \"" + Workspace.getMdFactory().getOMIUtil().cleanStringForXML(macroName) + ":\"");
            }
            storedText.append(" MetadataType=\"OUTPUT\" AssociationName=\"ClassifierSources\" ");
            storedText.append(" Minimum=\"");
            storedText.append(Integer.toString(iMinOutputs == -1 ? 0 : iMinOutputs));
            storedText.append("\" Maximum=\"");
            storedText.append(Integer.toString(iMaxOutputs == -1 ? 0 : iMaxOutputs));
            storedText.append("\" ");
            if (iMinOutputs > -1 && iNextVar < iMinOutputs && !fIsDefault) {
                storedText.append(" IsRequired=\"1\"");
            }
            storedText.append(" IsVisible=\"1\"/>");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return storedText;
    }

    public static boolean isVersionEqual(TransformationStep step, CMetadata prototype, MdObjectStore store) throws MdException, RemoteException {
        boolean fIsEqual = true;
        MdObjectStore newStore = Workspace.getMdFactory().createObjectStore();
        Prototype proto = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, prototype);
        StringBuffer sbTemplate = new StringBuffer();
        sbTemplate.append("<TEMPLATES><Prototype Id=\"\"><TimeStamps/></Prototype></TEMPLATES>");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)proto, null, null, sbTemplate.toString(), 12);
        fIsEqual = MacroPluginUtilities.isVersionEqual(step, proto);
        newStore.dispose();
        return fIsEqual;
    }

    public static boolean isVersionEqual(TransformationStep transformStep, Prototype prototype) throws MdException, RemoteException {
        Property timeStamp = null;
        int prototypeVersion = -1;
        for (int i = 0; i < prototype.getProperties().size(); ++i) {
            timeStamp = (Property)prototype.getProperties().get(i);
            if (!timeStamp.getPropertyRole().equalsIgnoreCase(VERSION_PROPERTY_NAME)) continue;
            prototypeVersion = Integer.valueOf(timeStamp.getDefaultValue());
            break;
        }
        if (prototypeVersion != -1) {
            int transformVersion = -1;
            for (int i = 0; i < transformStep.getProperties().size(); ++i) {
                timeStamp = (Property)transformStep.getProperties().get(i);
                if (!timeStamp.getPropertyRole().equalsIgnoreCase(VERSION_PROPERTY_NAME)) continue;
                transformVersion = Integer.valueOf(timeStamp.getDefaultValue());
                return transformVersion == prototypeVersion;
            }
        }
        return false;
    }

    public static AssociationProperty createOrUpdateMetadataAssociationPropertyCopy(AssociationProperty oPrototypeProperty, MdObjectStore store, String sReposId, AssociationProperty oPreviousProperty) {
        try {
            if (oPreviousProperty == null) {
                oPreviousProperty = (AssociationProperty)Workspace.getMdFactory().createComplexMetadataObject(store, oPrototypeProperty.getName(), "AssociationProperty", sReposId);
            }
            oPreviousProperty.setName(oPrototypeProperty.getName());
            oPreviousProperty.setDesc(oPrototypeProperty.getDesc());
            oPreviousProperty.setAssociationName(oPrototypeProperty.getAssociationName());
            oPreviousProperty.setIsExpert(oPrototypeProperty.getIsExpert());
            oPreviousProperty.setIsLinked(oPrototypeProperty.getIsLinked());
            oPreviousProperty.setIsRequired(oPrototypeProperty.getIsRequired());
            oPreviousProperty.setIsUpdateable(oPrototypeProperty.getIsUpdateable());
            oPreviousProperty.setIsVisible(oPrototypeProperty.getIsVisible());
            oPreviousProperty.setMaximum(oPrototypeProperty.getMaximum());
            oPreviousProperty.setMetadataType(oPrototypeProperty.getMetadataType());
            oPreviousProperty.setMinimum(oPrototypeProperty.getMinimum());
            oPreviousProperty.setPartnerName(oPrototypeProperty.getPartnerName());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return oPreviousProperty;
    }

    public static Prototype makeNewStepPrototype(TransformationStep step, MdObjectStore store, String sReposId) throws MdException, RemoteException {
        Prototype prototype = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, "PFDTEMPLATE", "Prototype", sReposId);
        prototype.getUsedByPrototypes().add((Object)step);
        return prototype;
    }

    public static List getAssociationProperties(MdObjectStore childStore, boolean fInput, Prototype protoFromRepository) throws MdException, RemoteException {
        if (protoFromRepository == null) {
            return null;
        }
        AssociationList properties = protoFromRepository.getProperties();
        if (properties.size() == 0) {
            return null;
        }
        Property property = (Property)properties.elementAt(0);
        TextStore storedText = (TextStore)property.getStoredConfiguration();
        String strGetXML = storedText.getStoredText();
        if (strGetXML == null || strGetXML.length() == 0) {
            return null;
        }
        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strGetXML);
        Node firstNode = doc.getFirstChild();
        String reposFQID = protoFromRepository.getRepositoryID();
        TransformationStep stepFromPrototype = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(childStore, null, "Name", "TransformationStep", protoFromRepository.getRepositoryID());
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        stepFromPrototype = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)stepFromPrototype, firstNode.getAttributes(), firstNode.getChildNodes(), reposFQID, inputs, outputs);
        Prototype stepPrototypeFromPrototype = (Prototype)stepFromPrototype.getUsingPrototype();
        int iNumAssociationProperties = 0;
        if (stepPrototypeFromPrototype != null) {
            iNumAssociationProperties = stepPrototypeFromPrototype.getPrototypeProperties().size();
        }
        ArrayList<AssociationProperty> returningList = new ArrayList<AssociationProperty>();
        if (stepPrototypeFromPrototype != null) {
            for (int i = 0; i < iNumAssociationProperties; ++i) {
                AssociationProperty newTemplate = (AssociationProperty)stepPrototypeFromPrototype.getPrototypeProperties().get(i);
                if (fInput && newTemplate.getMetadataType().indexOf(INPUT) > -1) {
                    returningList.add(newTemplate);
                    continue;
                }
                if (fInput || newTemplate.getMetadataType().indexOf(OUTPUT) <= -1) continue;
                returningList.add(newTemplate);
            }
        }
        return returningList;
    }

    public static void getAllAssociationProperties(MdObjectStore childStore, Prototype protoFromRepository, List inputList, List outputList) throws MdException, RemoteException {
        AssociationList properties = protoFromRepository.getProperties();
        if (properties.size() == 0) {
            return;
        }
        Property property = (Property)properties.elementAt(0);
        TextStore storedText = (TextStore)property.getStoredConfiguration();
        String strGetXML = storedText.getStoredText();
        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strGetXML);
        Node firstNode = doc.getFirstChild();
        String reposFQID = protoFromRepository.getRepositoryID();
        TransformationStep stepFromPrototype = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(childStore, null, "Name", "TransformationStep", protoFromRepository.getRepositoryID());
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        stepFromPrototype = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)stepFromPrototype, firstNode.getAttributes(), firstNode.getChildNodes(), reposFQID, inputs, outputs);
        Prototype stepPrototypeFromPrototype = (Prototype)stepFromPrototype.getUsingPrototype();
        int iNumAssociationProperties = 0;
        if (stepPrototypeFromPrototype != null) {
            iNumAssociationProperties = stepPrototypeFromPrototype.getPrototypeProperties().size();
        }
        if (stepPrototypeFromPrototype != null) {
            for (int i = 0; i < iNumAssociationProperties; ++i) {
                AssociationProperty newTemplate = (AssociationProperty)stepPrototypeFromPrototype.getPrototypeProperties().get(i);
                if (newTemplate.getMetadataType().indexOf(INPUT) > -1) {
                    inputList.add(newTemplate);
                    continue;
                }
                if (newTemplate.getMetadataType().indexOf(OUTPUT) <= -1) continue;
                outputList.add(newTemplate);
            }
        }
    }

    public static MacroPlugin getPluginFromStep(TransformationStep step) throws MdException, RemoteException {
        TransformInterface transform;
        String classname = null;
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals(CLASS)) continue;
            classname = prop.getDefaultValue();
            break;
        }
        if ((transform = TransformManager.getInstance().getTransform(classname)) != null && transform instanceof MacroPlugin) {
            return (MacroPlugin)transform;
        }
        return null;
    }

    public static TransformInterface getTransformInterfaceFromStep(TransformationStep step) throws MdException, RemoteException {
        TransformInterface transform;
        String classname = null;
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals(CLASS)) continue;
            classname = prop.getDefaultValue();
            break;
        }
        if ((transform = TransformManager.getInstance().getTransform(classname)) != null) {
            return transform;
        }
        return null;
    }

    public static void updateTemplates(TransformationStep step) throws MdException, RemoteException {
        MacroPlugin plugin = MacroPluginUtilities.getPluginFromStep(step);
        ArrayList newTemplates = new ArrayList();
        MdObjectStore newStore = Workspace.getMdFactory().createObjectStore();
        Prototype protoFromRepository = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, plugin.getPrototype());
        Vector vAssocs = new Vector();
        StringBuffer sbTemplate = new StringBuffer();
        sbTemplate.append("<TEMPLATES><Prototype Id=\"\"><Properties/><PropertySets/><Extensions/></Prototype><Property Id=\"\"><StoredConfiguration/></Property><StoredConfiguration Id=\"\"><StoredText/></StoredConfiguration></TEMPLATES>");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)protoFromRepository, null, vAssocs, sbTemplate.toString(), 12);
        AssociationList properties = protoFromRepository.getProperties();
        Property property = (Property)properties.elementAt(0);
        TextStore storedText = (TextStore)property.getStoredConfiguration();
        String strGetXML = storedText.getStoredText();
        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strGetXML);
        Node firstNode = doc.getFirstChild();
        String reposFQID = protoFromRepository.getRepositoryID();
        TransformationStep stepFromPrototype = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, "Name", "TransformationStep", protoFromRepository.getRepositoryID());
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        stepFromPrototype = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)stepFromPrototype, firstNode.getAttributes(), firstNode.getChildNodes(), reposFQID, inputs, outputs);
        Prototype stepPrototypeFromPrototype = (Prototype)stepFromPrototype.getUsingPrototype();
        ArrayList deletes = new ArrayList();
        Prototype stepPrototypeFromStep = (Prototype)step.getUsingPrototype();
        if (stepPrototypeFromStep != null) {
            for (int i = 0; i < stepPrototypeFromStep.getPrototypeProperties().size(); ++i) {
            }
        }
        int iNumNewAssociationProperties = 0;
        if (stepPrototypeFromPrototype != null) {
            iNumNewAssociationProperties = stepPrototypeFromPrototype.getPrototypeProperties().size();
        }
        if (stepPrototypeFromStep == null && iNumNewAssociationProperties > 0) {
            stepPrototypeFromStep = MacroPluginUtilities.makeNewStepPrototype(step, (MdObjectStore)step.getObjectStore(), step.getRepositoryID());
        }
        if (stepPrototypeFromPrototype != null) {
            ArrayList<AssociationProperty> inputProtoProps = new ArrayList<AssociationProperty>();
            ArrayList<AssociationProperty> outputProtoProps = new ArrayList<AssociationProperty>();
            for (int i = 0; i < stepPrototypeFromPrototype.getPrototypeProperties().size(); ++i) {
                AssociationProperty prop = (AssociationProperty)stepPrototypeFromPrototype.getPrototypeProperties().get(i);
                if (prop.getMetadataType().equals(INPUT)) {
                    inputProtoProps.add(prop);
                    continue;
                }
                outputProtoProps.add(prop);
            }
            ArrayList<AssociationProperty> inputStepProps = new ArrayList<AssociationProperty>();
            ArrayList<AssociationProperty> outputStepProps = new ArrayList<AssociationProperty>();
            for (int i = 0; i < stepPrototypeFromStep.getPrototypeProperties().size(); ++i) {
                AssociationProperty prop = (AssociationProperty)stepPrototypeFromStep.getPrototypeProperties().get(i);
                if (prop.getMetadataType().equals(INPUT)) {
                    inputStepProps.add(prop);
                    continue;
                }
                outputStepProps.add(prop);
            }
            MacroPluginUtilities.updateAssociationList(step, inputProtoProps, inputStepProps, newTemplates);
            MacroPluginUtilities.updateAssociationList(step, outputProtoProps, outputStepProps, newTemplates);
        }
        if (deletes.size() > 0) {
            ((MdObjectStore)step.getObjectStore()).removeObjectsFromStore(deletes);
        }
        for (int i = 0; i < newTemplates.size(); ++i) {
            AssociationProperty newProperty = (AssociationProperty)newTemplates.get(i);
            newProperty.setOwningPrototype(stepPrototypeFromStep);
        }
        if (newStore != null) {
            newStore.dispose();
        }
    }

    private static void updateAssociationList(TransformationStep step, List protoList, List stepList, List newTemplates) throws RemoteException {
        for (int i = 0; i < protoList.size(); ++i) {
            AssociationProperty templateToCopy = (AssociationProperty)protoList.get(i);
            AssociationProperty previousTemplate = null;
            if (stepList.size() > i) {
                previousTemplate = (AssociationProperty)stepList.get(i);
            }
            AssociationProperty newTemplate = MacroPluginUtilities.createOrUpdateMetadataAssociationPropertyCopy(templateToCopy, (MdObjectStore)step.getObjectStore(), step.getRepositoryID(), previousTemplate);
            newTemplates.add(newTemplate);
        }
    }

    public static String getMacroNameFromProperty(AssociationProperty property) {
        try {
            int iEnd = property.getPartnerName().indexOf(":");
            if (iEnd > -1) {
                return property.getPartnerName().substring(0, iEnd);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public static boolean isTemplateDisplayed(AssociationProperty property) {
        try {
            String name = property.getPartnerName();
            if (name.indexOf(DISPLAY) > -1) {
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public static boolean isTemplateDefault(AssociationProperty propertyFromIncomingList) throws RemoteException {
        String partnerName = MacroPluginUtilities.getPartnerNameFromAssociationProperty(propertyFromIncomingList);
        return partnerName.equals(DEFAULT);
    }

    public static String getPartnerNameFromAssociationProperty(AssociationProperty propertyFromIncomingList) throws RemoteException {
        String partnerName = propertyFromIncomingList.getPartnerName();
        if (partnerName.indexOf(":") > -1) {
            partnerName = partnerName.substring(0, partnerName.indexOf(":"));
        }
        return partnerName;
    }

    public static boolean isOrderTypeTransform(TransformationStep step) throws MdException, RemoteException {
        TransformInterface transform;
        if (step == null) {
            return false;
        }
        String classname = null;
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals(CLASS)) continue;
            classname = prop.getDefaultValue();
            break;
        }
        return (transform = TransformManager.getInstance().getTransform(classname)) instanceof TransformOrderMattersInterface;
    }

    public static boolean isGeneratedTransform(Root metaObject) {
        boolean generatedTransform = false;
        try {
            if (metaObject instanceof TransformationStep && ((TransformationStep)metaObject).getTransformRole().indexOf(GENERATED_TRANSFORM_TRANSFORMATIONSTEP_ROLE) > -1) {
                generatedTransform = true;
            } else if (metaObject instanceof Prototype && ((Prototype)metaObject).getMetadataType().equalsIgnoreCase(GENERATED_TRANSFORM_TRANSFORMATIONSTEP_ROLE)) {
                generatedTransform = true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return generatedTransform;
    }

    public static void setWorkTableMacroVariable(AssociationProperty property, WorkTable workTable) {
        String macroName = MacroPluginUtilities.getMacroNameFromProperty(property);
        if (macroName == null) {
            return;
        }
        if (macroName.equals(DEFAULT)) {
            return;
        }
        try {
            String newDesc = workTable.getDesc().concat(macroName);
            workTable.setDesc(newDesc);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static String getWorkTableMacroVariable(WorkTable workTable) {
        try {
            String desc = workTable.getDesc();
            if (desc.length() > 0) {
                return desc.substring(desc.indexOf(":"));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public static Node getNodeForTag(Document docConfig, String tag) {
        if (docConfig == null) {
            return null;
        }
        if (docConfig.getElementsByTagName(tag) == null) {
            return null;
        }
        if (docConfig.getElementsByTagName(tag).getLength() > 0) {
            return docConfig.getElementsByTagName(tag).item(0);
        }
        return null;
    }

    public static String getValueForNode(Node node) {
        Node info = node.getChildNodes().item(0);
        if (info != null) {
            return info.getNodeValue();
        }
        return "";
    }

    public static AssociationList getDefinedPropertiesFromObject(Root object) throws MdException, RemoteException {
        PropertySet pSet = MacroPluginUtilities.getPropertySetFromObject(object);
        if (pSet == null) {
            return null;
        }
        return pSet.getProperties();
    }

    public static TextStore getGetXMLTextStore(Prototype mdoTransform) throws MdException, RemoteException {
        TextStore textStore = null;
        if (mdoTransform != null) {
            AssociationList lProperties = mdoTransform.getProperties();
            for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
                TextStore storedText;
                String sGetXML;
                Property property = (Property)lProperties.get(iProperty);
                if (!property.getPropertyName().equalsIgnoreCase("GetXML") || (sGetXML = (storedText = (TextStore)property.getStoredConfiguration()).getStoredText()).indexOf("PropertyName=\"Class\"") <= -1) continue;
                textStore = storedText;
                break;
            }
        }
        return textStore;
    }

    public static String getGetXML(Prototype mdoTransform) throws MdException, RemoteException {
        TextStore storedText;
        String text = null;
        if (mdoTransform != null && (storedText = MacroPluginUtilities.getGetXMLTextStore(mdoTransform)) != null) {
            text = storedText.getStoredText();
        }
        return text;
    }

    public static void setGetXML(Prototype mdoTransform, String xml) throws MdException, RemoteException {
        TextStore storedText;
        if (mdoTransform != null && (storedText = MacroPluginUtilities.getGetXMLTextStore(mdoTransform)) != null) {
            storedText.setStoredText(xml);
        }
    }

    public static void createGUIDProperty(Prototype proto, String guid) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)proto.getObjectStore();
        MdFactory factory = store.getFactory();
        Property guidProp = (Property)factory.createComplexMetadataObject(store, null, CLASS, "Property", proto.getRepositoryID());
        guidProp.setDefaultValue(guid);
        guidProp.setSQLType(12);
        guidProp.setPropertyRole(ESMACRO);
        guidProp.setPropertyName(CLASS);
        proto.getProperties().addElement((Object)guidProp);
    }

    public static Property getGUIDProperty(Prototype proto) throws MdException, RemoteException {
        if (proto == null) {
            return null;
        }
        AssociationList lstProps = proto.getProperties();
        int size = lstProps.size();
        for (int i = 0; i < size; ++i) {
            Property p = (Property)lstProps.get(i);
            if (!p.getPropertyName().equals(CLASS)) continue;
            return p;
        }
        return null;
    }

    public static String setNewGuid(Prototype proto) throws MdException, RemoteException {
        return MacroPluginUtilities.setNewGuid(proto, GUID.newGUID());
    }

    public static String setNewGuid(Prototype proto, String sNewGUID) throws MdException, RemoteException {
        Property prop = MacroPluginUtilities.getGUIDProperty(proto);
        if (prop != null) {
            prop.setDefaultValue(sNewGUID);
        } else {
            MacroPluginUtilities.createGUIDProperty(proto, sNewGUID);
        }
        String sGetXML = MacroPluginUtilities.getGetXML(proto);
        if (sGetXML != null) {
            Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
            Matcher matcher = pattern.matcher(sGetXML);
            String sNewStoredText = matcher.replaceAll(sNewGUID);
            MacroPluginUtilities.setGetXML(proto, sNewStoredText);
        }
        return sNewGUID;
    }

    public static String getGuid(Prototype proto) throws MdException, RemoteException {
        Property prop = MacroPluginUtilities.getGUIDProperty(proto);
        if (prop != null) {
            return prop.getDefaultValue();
        }
        String sGetXML = MacroPluginUtilities.getGetXML(proto);
        if (sGetXML == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
        Matcher matcher = pattern.matcher(sGetXML);
        String strGUID = null;
        if (matcher.find()) {
            strGUID = matcher.group();
        }
        return strGUID;
    }

    public static String getTransformationStepClassName(TransformationStep step) throws RemoteException, MdException {
        String className = null;
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals(CLASS)) continue;
            className = prop.getDefaultValue();
            break;
        }
        return className;
    }

    public static Prototype getPrototypeForStep(TransformationStep step) throws MdException, RemoteException {
        TransformInterface tInterface = WAPFDTransformNodeModel.getInterfaceClass(step);
        if (tInterface != null && tInterface instanceof MacroPlugin) {
            MacroPlugin plugin = (MacroPlugin)tInterface;
            return plugin.getPrototype((MdObjectStore)step.getObjectStore());
        }
        return null;
    }

    public static PropertySet getPropertySetFromObject(Root object) throws MdException, RemoteException {
        PropertyHandler pHandler = new PropertyHandler(object, "MACROOPTIONS");
        return pHandler.getPropertySet();
    }

    public static boolean isPrototypeUsedInJobs(Prototype proto) {
        try {
            JInternalFrame[] frames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                PFDPanel pfdpanel;
                CMetadata oJob;
                WsBaseView view;
                JInternalFrame frame = frames[i];
                if (!(frame instanceof WAInternalFrame) || !((view = ((WAInternalFrame)frame).getView()) instanceof WAPFDEditorOMAView) || !((oJob = (pfdpanel = ((WAPFDEditorOMAView)view).getPFDPanel()).getActiveJob()) instanceof Job) || ((Job)oJob).getJobActivities().size() <= 0) continue;
                TransformationActivity act = (TransformationActivity)((Job)oJob).getJobActivities().get(0);
                AssociationList steps = act.getSteps();
                for (int k = 0; k < steps.size(); ++k) {
                    TransformationStep step = (TransformationStep)steps.get(k);
                    Prototype p = MacroPluginUtilities.getPrototypeForStep(step);
                    if (proto == null || p == null || !proto.getFQID().equals(p.getFQID())) continue;
                    return true;
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    public static boolean isEditingGeneratedTransform() {
        JInternalFrame[] frames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            WsBaseView view;
            CMetadata object;
            JInternalFrame frame = frames[i];
            if (!(frame instanceof WAPropertyFrame) || !((object = ((WAPropertyFrame)frame).getMetadataObject()) instanceof Prototype) || !((view = ((WAInternalFrame)frame).getView()) instanceof MacroPluginPropertiesView) || !MacroPluginUtilities.isGeneratedTransform((Root)((Prototype)object))) continue;
            return true;
        }
        return false;
    }

    public static Root getMetadataPropertyValue(Property property) throws MdException, RemoteException {
        Transformation trans;
        Root rObject = null;
        if (!property.getSpecTargetTransformations().isEmpty() && !(trans = (Transformation)property.getSpecTargetTransformations().get(0)).getSourceSpecifications().isEmpty()) {
            return (Root)trans.getSourceSpecifications().get(0);
        }
        return rObject;
    }

    public static void setDefaultObject(Property prop, Object newValue) throws MdException, RemoteException {
        Transformation trans = null;
        trans = !prop.getSpecTargetTransformations().isEmpty() ? (Transformation)prop.getSpecTargetTransformations().get(0) : MacroPluginUtilities.createTransform(prop);
        trans.getSourceSpecifications().removeAllElements();
        if (newValue != null && newValue instanceof Root) {
            trans.getSourceSpecifications().add(newValue);
        }
    }

    public static void createLinkToAssociationProperty(TransformationStep existingStep, AssociationProperty assocProp, CMetadata replacingObject) throws MdException, RemoteException {
        if (MacroPluginUtilities.isGeneratedTransform((Root)existingStep)) {
            DataTable table = null;
            if (assocProp == null) {
                return;
            }
            if (replacingObject instanceof TransformationStep) {
                TransformationStep step = (TransformationStep)replacingObject;
                if (step.getTransformations().size() == 0) {
                    if (assocProp.getUsingPrototype() == null) {
                        assocProp.setUsingPrototype((Root)replacingObject);
                    }
                } else {
                    ClassifierMap genCM = (ClassifierMap)existingStep.getTransformations().get(0);
                    block0: for (int i = 0; i < step.getTransformations().size(); ++i) {
                        DataTable lastTable;
                        int j;
                        ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(i);
                        if (assocProp.getMetadataType().equalsIgnoreCase(INPUT)) {
                            for (j = 0; j < cMap.getClassifierTargets().size(); ++j) {
                                lastTable = (DataTable)cMap.getClassifierTargets().get(j);
                                if (!lastTable.getSourceClassifierMaps().isEmpty() && genCM != lastTable.getSourceClassifierMaps().get(0)) continue;
                                table = lastTable;
                                continue block0;
                            }
                            continue;
                        }
                        for (j = 0; j < cMap.getClassifierSources().size(); ++j) {
                            lastTable = (DataTable)cMap.getClassifierSources().get(j);
                            if (lastTable.getTargetClassifierMaps().size() <= 0 || !genCM.getFQID().equalsIgnoreCase(((CMetadata)lastTable.getTargetClassifierMaps().get(0)).getFQID())) continue;
                            table = lastTable;
                            continue block0;
                        }
                    }
                }
            } else if (replacingObject instanceof DataTable) {
                table = (DataTable)replacingObject;
            } else if (replacingObject instanceof ExternalTable) {
                table = (ExternalTable)replacingObject;
            }
            if (table != null && assocProp != null && assocProp.getUsingPrototype() == null && MacroPluginUtilities.isGeneratedTransform((Root)existingStep) && !MacroPluginUtilities.isTemplateDefault(assocProp) || table != null && assocProp != null && assocProp.getUsingPrototype() == null && !MacroPluginUtilities.isGeneratedTransform((Root)existingStep)) {
                assocProp.setUsingPrototype((Root)table);
            }
        } else if (MacroPluginUtilities.isOrderTypeTransform(existingStep)) {
            DataTable table = null;
            if (assocProp == null) {
                return;
            }
            if (replacingObject instanceof TransformationStep) {
                TransformationStep step = (TransformationStep)replacingObject;
                if (step.getTransformations().size() == 0) {
                    if (MacroPluginUtilities.isTemplateDefault(assocProp)) {
                        Group group = (Group)assocProp.getUsingPrototype();
                        group.getMembers().add((Object)replacingObject);
                    } else {
                        assocProp.setUsingPrototype((Root)replacingObject);
                    }
                } else {
                    ClassifierMap genCM = (ClassifierMap)existingStep.getTransformations().get(0);
                    block3: for (int i = 0; i < step.getTransformations().size(); ++i) {
                        DataTable lastTable;
                        int j;
                        ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(i);
                        if (assocProp.getMetadataType().equalsIgnoreCase(INPUT)) {
                            for (j = 0; j < cMap.getClassifierTargets().size(); ++j) {
                                lastTable = (DataTable)cMap.getClassifierTargets().get(j);
                                if (!lastTable.getSourceClassifierMaps().isEmpty() && genCM != lastTable.getSourceClassifierMaps().get(0)) continue;
                                table = lastTable;
                                continue block3;
                            }
                            continue;
                        }
                        for (j = 0; j < cMap.getClassifierSources().size(); ++j) {
                            lastTable = (DataTable)cMap.getClassifierSources().get(j);
                            if (lastTable.getTargetClassifierMaps().size() <= 0 || !genCM.getFQID().equalsIgnoreCase(((CMetadata)lastTable.getTargetClassifierMaps().get(0)).getFQID())) continue;
                            table = lastTable;
                            continue block3;
                        }
                    }
                }
            } else if (replacingObject instanceof DataTable) {
                table = (DataTable)replacingObject;
            } else if (replacingObject instanceof ExternalTable) {
                table = (ExternalTable)replacingObject;
            }
            if (table != null && assocProp != null) {
                if (MacroPluginUtilities.isTemplateDefault(assocProp)) {
                    Group group = (Group)assocProp.getUsingPrototype();
                    group.getMembers().add((Object)table);
                } else {
                    assocProp.setUsingPrototype((Root)table);
                }
            }
        }
    }

    public static void createAllDefaultLinksToAssociationProperties(TransformationStep existingStep) throws MdException, RemoteException {
        if (MacroPluginUtilities.isGeneratedTransform((Root)existingStep)) {
            int i;
            ClassifierMap genCM = (ClassifierMap)existingStep.getTransformations().get(0);
            ArrayList<AssociationProperty> listOfOutputs = new ArrayList<AssociationProperty>();
            if (existingStep.getUsingPrototypes().size() == 0) {
                return;
            }
            for (i = 0; i < ((Prototype)existingStep.getUsingPrototype()).getPrototypeProperties().size(); ++i) {
                AssociationProperty property = (AssociationProperty)((Prototype)existingStep.getUsingPrototype()).getPrototypeProperties().get(i);
                if (!property.getMetadataType().equalsIgnoreCase(OUTPUT)) continue;
                listOfOutputs.add(property);
            }
            for (i = 0; i < genCM.getClassifierTargets().size(); ++i) {
                WorkTable table = (WorkTable)genCM.getClassifierTargets().get(i);
                AssociationProperty property = (AssociationProperty)listOfOutputs.get(i);
                if (MacroPluginUtilities.isTemplateDefault(property)) continue;
                property.getUsingPrototypes().add((Object)table);
            }
        }
    }

    public static AssociationProperty removeLinkToAssociationProperty(TransformationStep step, CMetadata toObject) throws MdException, RemoteException {
        AssociationProperty assoc = null;
        if (MacroPluginUtilities.isGeneratedTransform((Root)step) || MacroPluginUtilities.isOrderTypeTransform(step)) {
            int i;
            DataTable tableRemoved = null;
            if (toObject instanceof TransformationStep) {
                block0: for (int i2 = 0; i2 < ((TransformationStep)toObject).getTransformations().size(); ++i2) {
                    ClassifierMap cMap = (ClassifierMap)((TransformationStep)toObject).getTransformations().get(i2);
                    for (int j = 0; j < cMap.getClassifierTargets().size(); ++j) {
                        AssociationProperty tempAssoc = MacroPluginUtilities.removeLinkToAssociationProperty(step, (CMetadata)((DataTable)cMap.getClassifierTargets().get(j)));
                        if (tempAssoc == null) continue;
                        assoc = tempAssoc;
                        tableRemoved = (DataTable)cMap.getClassifierTargets().get(j);
                        continue block0;
                    }
                }
            } else {
                if (step.getUsingPrototypes().isEmpty()) {
                    return null;
                }
                Prototype template = (Prototype)step.getUsingPrototype();
                AssociationList props = template.getPrototypeProperties();
                block2: for (i = 0; i < props.size(); ++i) {
                    AssociationProperty assocProp = (AssociationProperty)props.get(i);
                    if (assocProp.getUsingPrototype() == toObject) {
                        assocProp.getUsingPrototypes().clear();
                        assoc = assocProp;
                        if (!(toObject instanceof DataTable)) continue;
                        tableRemoved = (DataTable)toObject;
                        continue;
                    }
                    if (assocProp.getUsingPrototype() == null || !assocProp.getUsingPrototype().getCMetadataType().equals("Group")) continue;
                    Group group = (Group)assocProp.getUsingPrototype();
                    AssociationList members = group.getMembers();
                    for (int p = 0; p < members.size(); ++p) {
                        Root cMeta = (Root)members.get(p);
                        if (!cMeta.getFQID().equals(toObject.getFQID())) continue;
                        members.remove(p);
                        continue block2;
                    }
                }
            }
            PropertySet pSet = MacroPluginUtilities.getPropertySetFromObject((Root)step);
            if (tableRemoved != null && pSet != null) {
                AssociationList columnsRemoved = tableRemoved.getColumns();
                for (i = 0; i < pSet.getProperties().size(); ++i) {
                    Property property = (Property)pSet.getProperties().get(i);
                    if (property.getPropertyRole().indexOf("COLUMNS") <= -1 || property.getSpecTargetTransformations().isEmpty()) continue;
                    Transformation transformation = (Transformation)property.getSpecTargetTransformations().elementAt(0);
                    AssociationList byColumnsList = transformation.getSourceSpecifications();
                    byColumnsList.removeAll((Collection)columnsRemoved);
                    if (!byColumnsList.isEmpty()) continue;
                    ArrayList<Object> deleteObjects = new ArrayList<Object>();
                    deleteObjects.add(transformation);
                    deleteObjects.add(property);
                    ((MdObjectStore)step.getObjectStore()).removeObjectsFromStore(deleteObjects);
                }
            }
        }
        return assoc;
    }

    public static void deleteProperty(Property property, MdObjectStore store) throws MdException, RemoteException {
        ArrayList<Object> deleteObjects = new ArrayList<Object>();
        if (!property.getSpecTargetTransformations().isEmpty()) {
            for (int i = 0; i < property.getSpecTargetTransformations().size(); ++i) {
                deleteObjects.add(property.getSpecTargetTransformations().get(i));
            }
        }
        deleteObjects.add(property);
        store.removeObjectsFromStore(deleteObjects);
    }

    public static Transformation createTransform(Property property) throws MdException, RemoteException {
        Transformation transform = (Transformation)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)property.getObjectStore(), null, property.getName(), "Transformation", property.getRepositoryID(), null);
        property.getSpecTargetTransformations().add((Object)transform);
        return transform;
    }

    public static void updatePrototypeVersion(Prototype metadata) throws MdException, RemoteException {
        MacroPluginUtilities.updatePrototypeVersion(metadata, false);
    }

    public static void updatePrototypeVersion(Prototype metadata, boolean createNewProperty) throws MdException, RemoteException {
        Property timeStamp = MacroPluginUtilities.getPrototypeVersionProperty(metadata);
        metadata.setName(metadata.getName());
        if (timeStamp == null && createNewProperty) {
            timeStamp = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)metadata.getObjectStore(), null, VERSION_PROPERTY_NAME, "Property", metadata.getRepositoryID(), null);
            timeStamp.setDesc("Last update version for prototype");
            timeStamp.setDefaultValue("0");
            timeStamp.setSQLType(4);
            timeStamp.setIsRequired(1);
            timeStamp.setIsVisible(1);
            timeStamp.setIsExpert(0);
            timeStamp.setPropertyName(VERSION_PROPERTY_NAME);
            timeStamp.setPropertyRole(VERSION_PROPERTY_NAME);
            metadata.getProperties().add((Object)timeStamp);
        }
        if (timeStamp != null) {
            String defaultValue = timeStamp.getDefaultValue();
            int version = Integer.valueOf(defaultValue);
            timeStamp.setDefaultValue(Integer.toString(++version));
        }
    }

    public static Property getPrototypeVersionProperty(Prototype metadata) throws MdException, RemoteException {
        Property prop = null;
        for (int i = 0; i < metadata.getProperties().size(); ++i) {
            Property timeStamp = (Property)metadata.getProperties().get(i);
            if (timeStamp.getDefaultValueState() != 2 || !timeStamp.getPropertyRole().equalsIgnoreCase(VERSION_PROPERTY_NAME)) continue;
            prop = timeStamp;
            break;
        }
        return prop;
    }

    public static void updateJobTransformationSteps(List generatedTransformChanged) throws MdException, RemoteException {
        if (generatedTransformChanged.size() > 0) {
            for (int i = 0; i < generatedTransformChanged.size(); ++i) {
                TransformationStep tStep = (TransformationStep)generatedTransformChanged.get(i);
                TransformInterface transformInterface = null;
                String classname = null;
                AssociationList properties = tStep.getProperties();
                for (int j = 0; j < properties.size(); ++j) {
                    Property prop = (Property)properties.get(j);
                    if (!prop.getPropertyName().equals(CLASS)) continue;
                    classname = prop.getDefaultValue();
                    break;
                }
                transformInterface = TransformManager.getInstance().getTransform(classname);
                MacroPluginUtilities.updateTemplates(tStep);
                int iNewVersion = ((MacroPlugin)transformInterface).getPrototypeVersion(tStep);
                ((MacroPlugin)transformInterface).updateTransformVersion(tStep, iNewVersion);
            }
        }
    }

    public static List getOldTransformationStepVersions(Job job) throws MdException, RemoteException {
        ArrayList<TransformationStep> m_generatedTransformVersionMismatches = new ArrayList<TransformationStep>();
        AssociationList tActivities = job.getJobActivities();
        for (int i = 0; i < tActivities.size(); ++i) {
            TransformationActivity tActivity = (TransformationActivity)tActivities.get(i);
            AssociationList steps = tActivity.getSteps();
            for (int j = 0; j < steps.size(); ++j) {
                int iTransformVersion;
                MacroPlugin macroPlugin;
                int iPrototypeVersion;
                TransformationStep step = (TransformationStep)steps.get(j);
                MacroPlugin transformPlugin = MacroPluginUtilities.getPluginFromStep(step);
                if (!(transformPlugin instanceof MacroPlugin) || !MacroPluginUtilities.isGeneratedTransform((Root)step) || (iPrototypeVersion = (macroPlugin = transformPlugin).getPrototypeVersion(step)) <= (iTransformVersion = macroPlugin.getTransformVersion(step))) continue;
                m_generatedTransformVersionMismatches.add(step);
            }
        }
        return m_generatedTransformVersionMismatches;
    }

    public static List getArchivedTransforms(Job job) throws MdException, RemoteException {
        ArrayList<TransformationStep> m_archivedList = new ArrayList<TransformationStep>();
        AssociationList tActivities = job.getJobActivities();
        for (int i = 0; i < tActivities.size(); ++i) {
            TransformationActivity tActivity = (TransformationActivity)tActivities.get(i);
            AssociationList steps = tActivity.getSteps();
            for (int j = 0; j < steps.size(); ++j) {
                TransformationStep step = (TransformationStep)steps.get(j);
                TransformInterface transformPlugin = MacroPluginUtilities.getTransformInterfaceFromStep(step);
                if (transformPlugin == null || !(transformPlugin instanceof TransformArchiveInterface)) continue;
                m_archivedList.add(step);
            }
        }
        return m_archivedList;
    }

    public static TransformInterface getReplacingTransformInterface(TransformationStep step) throws MdException, RemoteException {
        String className;
        TransformInterface replaceInterface = null;
        TransformInterface transformPlugin = MacroPluginUtilities.getTransformInterfaceFromStep(step);
        if (transformPlugin != null && transformPlugin instanceof TransformArchiveInterface && (className = ((TransformArchiveInterface)((Object)transformPlugin)).getReplacingTransformClass()).length() > 0) {
            try {
                Class<?> replaceClass = Class.forName(className);
                try {
                    Object replaceObject = replaceClass.newInstance();
                    if (replaceObject instanceof TransformInterface) {
                        replaceInterface = (TransformInterface)replaceObject;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return replaceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJobUpToDate(CMetadata job) {
        boolean upToDate = true;
        try {
            MdObjectStore jobStore = Workspace.getMdFactory().createObjectStore(null, "MacroPluginUtilities: isJobUpToDate");
            Job tempJob = (Job)Workspace.getMdFactory().createComplexMetadataObject(jobStore, job);
            try {
                upToDate = MacroPluginUtilities.getOldTransformationStepVersions(tempJob).isEmpty();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            finally {
                jobStore.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return upToDate;
    }

    public static boolean promptToUpdateTransformsInJob(CMetadata job) {
        return MacroPluginUtilities.promptToUpdateTransformsInJob(job, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean promptToUpdateTransformsInJob(CMetadata job, boolean promptForUpdate) {
        boolean updated = false;
        try {
            MdObjectStore jobStore = Workspace.getMdFactory().createObjectStore(null, "MacroPluginUtilities: promptToUpdateTransformsInJob");
            Job tempJob = (Job)Workspace.getMdFactory().createComplexMetadataObject(jobStore, job);
            try {
                List stepsChanged = MacroPluginUtilities.getOldTransformationStepVersions(tempJob);
                boolean editable = Workspace.getWorkspace().isObjectEditable(job);
                if (!stepsChanged.isEmpty()) {
                    String message = null;
                    int options = -1;
                    if (editable) {
                        options = 0;
                        message = bundle.getString("MacroPluginUtilities.PluginMismatch.msg.txt");
                    } else {
                        options = -1;
                        message = bundle.getString("MacroPluginUtilities.PluginMismatch2.msg.txt");
                        updated = true;
                    }
                    if ((!promptForUpdate || 0 == MessageUtil.displayListMessage((String)message, (List)stepsChanged, (String)bundle.getString("MacroPluginUtilities.PluginMismatch.title.txt"), (int)2, (int)options)) && editable) {
                        MacroPluginUtilities.updateJobTransformationSteps(stepsChanged);
                        jobStore.updatedMetadataAll();
                        updated = true;
                    }
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            finally {
                jobStore.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return updated;
    }

    public static Column findColumn(String defaultRepositoryId, String[] strColumnPath, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        if (strColumnPath == null) {
            return null;
        }
        if (strColumnPath.length <= 0) {
            return null;
        }
        String strLibraryName = strColumnPath[0];
        if (strLibraryName == null) {
            return null;
        }
        String strSchemaName = null;
        if (strColumnPath.length - 2 < 0) {
            return null;
        }
        if (strColumnPath.length - 1 < 0) {
            return null;
        }
        String strTableName = strColumnPath[strColumnPath.length - 2];
        String strColumnName = strColumnPath[strColumnPath.length - 1];
        if (strColumnPath.length == 4) {
            strSchemaName = strColumnPath[1];
        }
        sbOptions.append("<XMLSelect search=\"");
        MacroPluginUtilities.generateXMLColumnSelect(store.getFactory(), strLibraryName, strSchemaName, strTableName, strColumnName, sbOptions);
        sbOptions.append("\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<Column SASColumnName=\"\"></Column>");
        sbOptions.append("</Templates>");
        int fOptions = 8596;
        boolean fserver = store.isGoToServerForMetadata();
        store.setGoToServerForMetadata(true);
        List lColumns = store.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, defaultRepositoryId, "Column", fOptions, sbOptions.toString());
        store.setGoToServerForMetadata(fserver);
        if (!lColumns.isEmpty()) {
            return (Column)lColumns.get(0);
        }
        return null;
    }

    public static SASLibrary findLibrary(String defaultRepositoryId, String strLibraryName, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        sbOptions.append("<XMLSelect search=\"");
        MacroPluginUtilities.generateXMLLibrarySelect(store.getFactory(), strLibraryName, sbOptions);
        sbOptions.append("\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<SASLibrary Libref=\"\"></SASLibrary>");
        sbOptions.append("</Templates>");
        int fOptions = 8580;
        boolean fserver = store.isGoToServerForMetadata();
        store.setGoToServerForMetadata(true);
        List lLibraries = store.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, defaultRepositoryId, "SASLibrary", fOptions, sbOptions.toString());
        store.setGoToServerForMetadata(fserver);
        if (!lLibraries.isEmpty()) {
            return (SASLibrary)lLibraries.get(0);
        }
        return null;
    }

    public static PhysicalTable findTable(String defaultRepositoryId, String[] strTablePath, MdObjectStore store) throws MdException, RemoteException {
        StringBuffer sbOptions = new StringBuffer(100);
        String strLibraryName = strTablePath[0];
        String strSchemaName = null;
        String strTableName = strTablePath[strTablePath.length - 1];
        if (strTablePath.length == 3) {
            strSchemaName = strTablePath[1];
        }
        sbOptions.append("<XMLSelect search=\"");
        MacroPluginUtilities.generateXMLTableSelect(store.getFactory(), strLibraryName, strSchemaName, strTableName, sbOptions, true);
        sbOptions.append("\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<PhysicalTable SASTableName=\"\"></PhysicalTable>");
        sbOptions.append("</Templates>");
        int fOptions = 8596;
        boolean fserver = store.isGoToServerForMetadata();
        store.setGoToServerForMetadata(true);
        List lTables = store.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, defaultRepositoryId, "PhysicalTable", fOptions, sbOptions.toString());
        store.setGoToServerForMetadata(fserver);
        if (!lTables.isEmpty()) {
            return (PhysicalTable)lTables.get(0);
        }
        return null;
    }

    public static void generateXMLColumnSelect(MdFactory factory, String strLibraryName, String strSchemaName, String strTableName, String strColumnName, StringBuffer sbSelect) throws MdException, RemoteException {
        sbSelect.append("Column");
        sbSelect.append("[@SASColumnName='");
        sbSelect.append(factory.getOMIUtil().cleanStringForXML(strColumnName));
        sbSelect.append("']");
        sbSelect.append("[Table/");
        MacroPluginUtilities.generateXMLTableSelect(factory, strLibraryName, strSchemaName, strTableName, sbSelect);
        sbSelect.append("]");
    }

    public static void generateXMLLibrarySelect(MdFactory factory, String strLibraryName, StringBuffer sbSelect) throws MdException, RemoteException {
        sbSelect.append("SASLibrary");
        sbSelect.append("[@LibRef='");
        sbSelect.append(factory.getOMIUtil().cleanStringForXML(strLibraryName));
        sbSelect.append("']");
    }

    public static void generateXMLSchemaSelect(MdFactory factory, String strLibraryName, String strSchemaName, StringBuffer sbSelect) throws MdException, RemoteException {
        sbSelect.append("DatabaseSchema");
        sbSelect.append("[@SchemaName='");
        sbSelect.append(factory.getOMIUtil().cleanStringForXML(strSchemaName));
        sbSelect.append("']");
        sbSelect.append("/UsedByPackages/");
        MacroPluginUtilities.generateXMLLibrarySelect(factory, strLibraryName, sbSelect);
    }

    public static void generateXMLTableSelect(MdFactory factory, String strLibraryName, String strSchemaName, String tableName, StringBuffer sbSelect, boolean justTable) throws MdException, RemoteException {
        sbSelect.append("PhysicalTable");
        sbSelect.append("[@SASTableName='");
        sbSelect.append(factory.getOMIUtil().cleanStringForXML(tableName));
        sbSelect.append("']");
        if (justTable) {
            sbSelect.append("[");
        } else {
            sbSelect.append("/");
        }
        sbSelect.append("TablePackage/");
        if (strSchemaName != null) {
            MacroPluginUtilities.generateXMLSchemaSelect(factory, strLibraryName, strSchemaName, sbSelect);
        } else {
            MacroPluginUtilities.generateXMLLibrarySelect(factory, strLibraryName, sbSelect);
        }
        if (justTable) {
            sbSelect.append("]");
        }
    }

    public static void generateXMLTableSelect(MdFactory factory, String strLibraryName, String strSchemaName, String tableName, StringBuffer sbSelect) throws MdException, RemoteException {
        MacroPluginUtilities.generateXMLTableSelect(factory, strLibraryName, strSchemaName, tableName, sbSelect, false);
    }
}

