/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.CodeEditor;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDMetadataParsing;
import com.sas.wadmin.prompts.visuals.PromptDesignTimePropertyTab;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.MacroGeneralPanel;
import com.sas.wadmin.visuals.MacroOptionsTemplatesPanel;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MacroPluginPropertiesView
extends WorkspaceOMAView {
    private static final WAdminResource bundle = WAdminResource.getBundle(MacroPluginPropertiesView.class);

    public WAPropertyTabGroup createView() {
        super.createView();
        WAPropertyTabGroup tabs = new WAPropertyTabGroup();
        tabs.addTab(bundle.getString("Common.General.txt"), (WAPropertyTab)new cGeneralPropertyTab((CMetadata)this.m_metadata, true));
        tabs.addTab(bundle.getString("MacroPluginPropertiesView.SourceCode.title"), (WAPropertyTab)new cSourceCodePropertyTab((CMetadata)this.m_metadata));
        tabs.addTab(bundle.getString("MacroPluginPropertiesView.CodeOptions.title"), (WAPropertyTab)new cCodeOptionsPropertyTab(this.m_metadata));
        tabs.addTab(bundle.getString("MacroPluginPropertiesView.InputsOutputs.title"), (WAPropertyTab)new cInputsOutputsPropertyTab((CMetadata)this.m_metadata));
        tabs.addTab(bundle.getString("WANotesPropertyTab.Title.txt"), (WAPropertyTab)new JOMANotesTab(this.m_metadata));
        if (this.getShouldShowAdvancedTabs()) {
            tabs.addTab(bundle.getString("Common.Advanced.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)this.m_metadata));
            this.addAuthorizationTab(tabs, (CMetadata)this.m_metadata);
        }
        return tabs;
    }

    protected class cInputsOutputsPropertyTab
    extends WAPropertyTab {
        protected Prototype m_oMetadata;
        protected MacroOptionsTemplatesPanel m_pnlTemplates;

        public cInputsOutputsPropertyTab(CMetadata oMetadata) {
            this.m_oMetadata = (Prototype)oMetadata;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen_transform_props");
            this.initialize();
        }

        protected void initialize() {
            this.m_pnlTemplates = new MacroOptionsTemplatesPanel(this.m_oMetadata);
            this.listenForDataChangesTo(this.m_pnlTemplates);
            this.setLayout(new GridBagLayout());
            this.add((Component)((Object)this.m_pnlTemplates), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void populateStore() throws MdException, RemoteException {
            this.m_pnlTemplates.populateStore();
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.m_pnlTemplates.moveDataToView();
        }

        public void moveDataToStore() throws MdException, RemoteException {
            if (!this.hasDataChanged()) {
                return;
            }
            this.m_pnlTemplates.moveDataToStore();
            MacroPluginUtilities.updatePrototypeVersion((Prototype)MacroPluginPropertiesView.this.m_metadata);
            TextStore store = (TextStore)((Property)this.m_oMetadata.getProperties().get(0)).getStoredConfiguration();
            String transformText = store.getStoredText();
            String newAssocProps = MacroPluginUtilities.populateAssociationProperties(this.m_oMetadata, this.m_pnlTemplates).toString();
            int startIndex = 0;
            int endIndex = 0;
            if (transformText.indexOf("PFDTEMPLATE") > -1) {
                startIndex = transformText.indexOf("<UsingPrototype>");
                endIndex = transformText.indexOf("</UsingPrototype>");
                endIndex += 17;
            } else {
                startIndex = transformText.indexOf(">");
                ++startIndex;
                endIndex = transformText.indexOf("<P");
            }
            StringBuffer transformTextBuffer = new StringBuffer();
            transformTextBuffer.append(transformText.substring(0, startIndex));
            transformTextBuffer.append(newAssocProps);
            transformTextBuffer.append(transformText.substring(endIndex));
            store.setStoredText(transformTextBuffer.toString());
            transformText = transformTextBuffer.toString();
            String newWTString = MacroPluginUtilities.populateWorkTableNames(this.m_oMetadata, this.m_pnlTemplates).toString();
            startIndex = 0;
            endIndex = 0;
            startIndex = transformText.indexOf("<ClassifierTargets>");
            endIndex = transformText.indexOf("</ClassifierTargets>");
            transformTextBuffer = new StringBuffer();
            transformTextBuffer.append(transformText.substring(0, startIndex += 19));
            transformTextBuffer.append(newWTString);
            transformTextBuffer.append(transformText.substring(endIndex));
            store.setStoredText(transformTextBuffer.toString());
            this.setDataChanged(false);
        }

        public boolean validateData() {
            if (this.hasDataChanged() && 0 != MessageUtil.displayMessage((String)bundle.getString("MacroPluginPropertiesView.InputsOutputsPropertyTab.ConfirmChanges.Warning.txt"), (String)bundle.getString("MacroPluginPropertiesView.InputsOutputsPropertyTab.ConfirmChanges.Warning.title"), (int)2, (int)0)) {
                return false;
            }
            return this.m_pnlTemplates.validateData();
        }

        public void setEditable(boolean bEditable) {
            this.m_pnlTemplates.setEditable(bEditable);
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            this.m_pnlTemplates.updateWorkspaceUIComponents(bActive);
        }
    }

    protected class cSourceCodePropertyTab
    extends WAPropertyTab {
        Prototype m_oMetadata;
        private CodeEditor m_editor;
        TextStore m_storedText;

        public cSourceCodePropertyTab(CMetadata oMetadata) {
            this(oMetadata, null);
        }

        public cSourceCodePropertyTab(CMetadata oMetadata, String sFeatureMessage) {
            this.m_oMetadata = (Prototype)oMetadata;
            this.setHelpProduct("wdb");
            this.setHelpTopic("trans_gen_sascode");
            this.initialize();
        }

        public void populateStore() throws MdException, RemoteException {
            Vector vAssocs = new Vector();
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oMetadata, null, vAssocs, "<TEMPLATES>   <Property Id=\"\" Name=\"\">      <ExternalIdentities/>      <UsingPrototype/>      <Customizers/>      <PrimaryPropertyGroup/>      <OwningType/>      <Properties/>      <LocalizedAttributes/>      <StoredConfiguration/>      <Editors/>      <Resources/>      <Properties/>      <Validators/>   </Property>   <PropertyGroup>      <SubPropertyGroups/>      <Customizers/>      <Notes/>      <Properties/>      <PropertySets/>   </PropertyGroup>   <PropertySet>      <SetProperties/>   </PropertySet>   <PropertyType>      <Validators/>      <StoredConfiguration/>      <Properties/>      <Customizers/>   </PropertyType></TEMPLATES>", 268);
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.setListeningForChanges(false);
            AssociationList properties = this.m_oMetadata.getProperties();
            Property property = null;
            for (int i = 0; i < properties.size() && !(property = (Property)properties.get(i)).getPropertyRole().equalsIgnoreCase("GetXML"); ++i) {
            }
            this.m_storedText = (TextStore)property.getStoredConfiguration();
            String strGetXML = this.m_storedText.getStoredText();
            Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(strGetXML);
            Node firstNode = doc.getFirstChild();
            MdObjectStore newStore = Workspace.getMdFactory().createObjectStore();
            String reposFQID = this.m_oMetadata.getRepositoryID();
            TransformationStep cmStep = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, "Name", "TransformationStep", this.m_oMetadata.getRepositoryID());
            ArrayList inputs = new ArrayList();
            ArrayList outputs = new ArrayList();
            cmStep = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)cmStep, firstNode.getAttributes(), firstNode.getChildNodes(), reposFQID, inputs, outputs);
            ClassifierMap iMeta = (ClassifierMap)cmStep.getTransformations().elementAt(0);
            Prototype proto = (Prototype)iMeta.getUsingPrototype();
            Property prop = (Property)proto.getProperties().get(0);
            TextStore sourceCodeStore = (TextStore)prop.getStoredConfiguration();
            String sourceCodeBuffer = sourceCodeStore.getStoredText();
            newStore.dispose();
            Workspace.getWorkspace().setCursor(null);
            this.m_editor.setText(sourceCodeBuffer);
            this.setListeningForChanges(true);
        }

        public boolean validateData() {
            return !this.hasDataChanged() || 0 == MessageUtil.displayMessage((String)bundle.getString("MacroPluginPropertiesView.ConfirmChanges.Warning.txt"), (String)bundle.getString("MacroPluginPropertiesView.ConfirmChanges.Warning.title"), (int)2, (int)0);
        }

        public void moveDataToStore() throws MdException, RemoteException {
            if (!this.hasDataChanged()) {
                return;
            }
            MacroPluginUtilities.updatePrototypeVersion((Prototype)MacroPluginPropertiesView.this.m_metadata);
            String strText = this.m_editor.getText();
            String strNormalized = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strText);
            String strGetXML = this.m_storedText.getStoredText();
            int index = strGetXML.indexOf("SASCODE");
            int index2 = strGetXML.indexOf("StoredText", index);
            int index3 = strGetXML.indexOf("/StoredConfiguration", index2);
            String substr1 = strGetXML.substring(0, index2 += 12);
            String substr2 = strGetXML.substring(index3 -= 4);
            String strNewText = substr1 + strNormalized + substr2;
            this.m_storedText.setStoredText(strNewText);
            this.setDataChanged(false);
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        protected void initialize() {
            this.m_editor = new CodeEditor(Workspace.getWorkspace().getCodeEditorDefaults());
            this.m_editor.setPreferredSize(new Dimension(200, 100));
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_editor);
            super.listenForDataChangesTo((JTextComponent)this.m_editor.getEditorPane());
        }

        public void saveSettingsAndCleanUp() {
            this.m_editor.cleanup();
            super.saveSettingsAndCleanUp();
        }
    }

    protected class cCodeOptionsPropertyTab
    extends PromptDesignTimePropertyTab {
        public cCodeOptionsPropertyTab(Root metaObject) {
            super(metaObject, false, "trans_gen_sascode_options", true, true);
        }

        @Override
        public void moveDataToStore() throws MdException, RemoteException {
            if (!this.hasDataChanged()) {
                return;
            }
            super.moveDataToStore();
            MacroPluginUtilities.updatePrototypeVersion((Prototype)this.m_metadata);
            this.setDataChanged(false);
        }

        @Override
        public boolean validateData() {
            return !this.hasDataChanged() || 0 == MessageUtil.displayMessage((String)bundle.getString("MacroPluginPropertiesView.ConfirmChanges.Warning.txt"), (String)bundle.getString("MacroPluginPropertiesView.ConfirmChanges.Warning.title"), (int)2, (int)0);
        }
    }

    protected class cGeneralPropertyTab
    extends WAPropertyTab {
        protected MacroGeneralPanel m_pnlGeneral;
        protected CMetadata m_oMetadata;
        protected boolean m_fIsEntity;

        public cGeneralPropertyTab(CMetadata oMetadata) {
            this(oMetadata, false);
        }

        public cGeneralPropertyTab(CMetadata oMetadata, boolean fEntity) {
            this.m_oMetadata = oMetadata;
            this.m_fIsEntity = fEntity;
            this.setHelpProduct("wdb");
            this.setHelpTopic("general_tab_generated");
            this.initialize();
        }

        protected void initialize() {
            this.m_pnlGeneral = new MacroGeneralPanel((Prototype)this.m_oMetadata);
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.m_pnlGeneral));
            super.listenForDataChangesTo((WAPanel)this.m_pnlGeneral);
        }

        public void populateStore() throws MdException, RemoteException {
            this.m_pnlGeneral.populateStore();
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.m_pnlGeneral.moveDataToView();
        }

        public void moveDataToStore() throws MdException, RemoteException {
            if (!this.m_pnlGeneral.getGeneralPanel().hasDataChanged() && !this.hasDataChanged()) {
                return;
            }
            if (this.m_fIsEntity) {
                Property timeStamp = null;
                for (int i = 0; i < ((Prototype)this.m_oMetadata).getProperties().size(); ++i) {
                    timeStamp = (Property)((Prototype)this.m_oMetadata).getProperties().get(i);
                    if (!timeStamp.getPropertyRole().equalsIgnoreCase("VERSION")) continue;
                    String defaultValue = timeStamp.getDefaultValue();
                    int version = Integer.valueOf(defaultValue);
                    timeStamp.setDefaultValue(Integer.toString(++version));
                    break;
                }
            }
            this.m_pnlGeneral.moveDataToStore();
            MacroPluginUtilities.updatePrototypeVersion((Prototype)MacroPluginPropertiesView.this.m_metadata);
            if (this.m_fIsEntity) {
                TransformManager.updateTransformNameAndDescription((Prototype)this.m_oMetadata);
            }
            this.setDataChanged(false);
        }

        public boolean validateData() {
            return this.m_pnlGeneral.validateData();
        }

        public void setEditable(boolean bEditable) {
            this.m_pnlGeneral.setEditable(bEditable);
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            this.m_pnlGeneral.updateWorkspaceUIComponents(bActive);
        }
    }
}

