/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.DBMSLibraryConnectWizardTab;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LasrHdatImporter
extends SASImporter
implements MultipleNodeInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(LasrHdatImporter.class);
    private ArrayList m_HadoopNameList;
    private ArrayList m_ToolTipList;
    private ArrayList m_DescriptionsList;
    private ArrayList m_ImageIconList;

    @Override
    public void initPlugin() {
        this.m_LIBRARY_TAB = "HdatImportertab1";
        this.m_TABLES_TAB = "HdatImportertab2";
        String[][] standardTransitionList = new String[][]{{this.m_LIBRARY_TAB, "NEXT", this.m_TABLES_TAB}, {this.m_TABLES_TAB, "NEXT", "SASImportertab4"}};
        this.m_transitionList = standardTransitionList;
        this.m_name = bundle.getString("LasrHdatImporter.Name.LasrHdat.txt");
        this.m_icon = bundle.getImageIcon("LasrHdatImporter.image");
        this.m_tooltip = bundle.getString("LasrHdatImporter.ToolTip.txt");
        this.buildNameList();
        this.buildTooltipList();
        this.buildIconList();
        this.buildDescriptionList();
    }

    public void buildDescriptionList() {
        this.m_DescriptionsList = new ArrayList();
        this.m_DescriptionsList.add(bundle.getString("LasrHdatImporter.description.LasrHdat.notrans"));
    }

    public void buildIconList() {
        this.m_ImageIconList = new ArrayList();
        for (int j = 0; j < 4; ++j) {
            this.m_ImageIconList.add(bundle.getImageIcon("LasrHdatImporter.image"));
        }
    }

    public void buildNameList() {
        this.m_HadoopNameList = new ArrayList();
        String folderName = bundle.getString("Hadoop.Category.txt") + ".";
        this.m_HadoopNameList.add(folderName + bundle.getString("LasrHdatImporter.Name.LasrHdat.txt"));
    }

    public void buildTooltipList() {
        this.m_ToolTipList = new ArrayList();
        this.m_ToolTipList.add(bundle.getString("LasrHdatImporter.ToolTip.LasrHdat.txt"));
    }

    @Override
    protected void createLibraryTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.ConnectInfo.image");
        this.m_libraryTab = new DBMSLibraryConnectWizardTab("SASHDAT", bundle.getString("LasrHdatConnectWizardTab.Description.txt"));
        this.m_libraryTab.setHelpTopic("hdfs_win");
        this.m_libraryTab.setEngineType("SASHDAT");
        this.updateEngineName(this.m_wizardDialog);
        this.m_wizardDialog.addTab(bundle.getString("LasrHdatConnectWizardTab.Title.txt"), this.m_LIBRARY_TAB, (WAPropertyTab)this.m_libraryTab, "wa_source_connectInfo.gif", (Icon)image, false);
    }

    @Override
    public String getDescription() {
        return bundle.getString("LasrHdatImporter.description.txt");
    }

    @Override
    public String getCategory() {
        return bundle.getString("Hadoop.Category.txt");
    }

    public ArrayList getDescriptions() {
        return this.m_DescriptionsList;
    }

    public ArrayList getIcons() {
        return this.m_ImageIconList;
    }

    public ArrayList getNames() {
        return this.m_HadoopNameList;
    }

    public ArrayList getToolTips() {
        return this.m_ToolTipList;
    }

    @Override
    public boolean isEngineSupported(String engineName) {
        return engineName.equalsIgnoreCase("SASHDAT");
    }

    public void updateEngineName(WAWizardDialog wizardDialog) {
        String nodeName = (String)wizardDialog.getWizardData("SELECTEDNODE");
        if (nodeName == null) {
            return;
        }
        if (nodeName.trim().equalsIgnoreCase(bundle.getString("LasrHdatImporter.Name.LasrHdat.txt"))) {
            this.m_strEngine = bundle.getString("LasrHdatImporter.description.LasrHdat.notrans");
        }
        wizardDialog.addWizardData("ENGINETYPE", (Object)this.m_strEngine);
    }
}

