/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JobStatusTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(JobStatusTableModel.class);
    public static final int JOB_COL = 0;
    public static final int STATUS_COL = 1;
    public static final int STARTTIME_COL = 2;
    public static final int ENDTIME_COL = 3;
    public static final int APPSERVER_COL = 4;
    public static final int METADATAFQID_COL = 5;
    protected static final int W_ALL_COL = 220;
    protected static final int TOTAL_COLS = 5;
    protected static final int TOTAL_HIDDEN_COLS = 1;
    protected MdFactory m_factory = Workspace.getWorkspace().getMdObjectFactory();

    public JobStatusTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        Date dateMissing = new Date(Long.MAX_VALUE);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        WsStringTableColumn job_Col = new WsStringTableColumn(0, bundle.getString("JobStatusTableModel.Job.txt"), 220);
        job_Col.setEditable(false);
        this.m_aColumns[0] = job_Col;
        WsStringTableColumn status_Col = new WsStringTableColumn(1, bundle.getString("JobStatusTableModel.Status.txt"), 220);
        status_Col.setEditable(false);
        this.m_aColumns[1] = status_Col;
        WsDateTableColumn starttime_Col = new WsDateTableColumn(2, bundle.getString("JobStatusTableModel.Starttime.txt"), 220);
        starttime_Col.setEditable(false);
        starttime_Col.setShowAsBlankDate(dateMissing);
        this.m_aColumns[2] = starttime_Col;
        WsDateTableColumn endtime_Col = new WsDateTableColumn(3, bundle.getString("JobStatusTableModel.Endtime.txt"), 220);
        endtime_Col.setEditable(false);
        endtime_Col.setShowAsBlankDate(dateMissing);
        this.m_aColumns[3] = endtime_Col;
        WsStringTableColumn wsAppServer_Col = new WsStringTableColumn(4, bundle.getString("JobStatusTableModel.Wsappserver.txt"), 220);
        wsAppServer_Col.setEditable(false);
        this.m_aColumns[4] = wsAppServer_Col;
        this.m_aColumns[5] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        Map mAllJobs = WsJobSubmissionManager.getInstance().getAllWsServerRequests();
        List lAllKeys = WsJobSubmissionManager.getInstance().getOrderedKeyList();
        nRows = 0;
        for (int iKey = 0; iKey < lAllKeys.size(); ++iKey) {
            String sKey = (String)lAllKeys.get(iKey);
            WsServerRequest serverRequest = (WsServerRequest)mAllJobs.get(sKey);
            if (serverRequest.getWsAppServer() == null) continue;
            ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(serverRequest.getMetadataName());
            alRow.add(serverRequest.getPropertyString("jobstatus"));
            alRow.add(serverRequest.getPropertyDate("starttime"));
            alRow.add(serverRequest.getPropertyDate("endtime"));
            alRow.add(serverRequest.getWsAppServerName());
            alRow.add(serverRequest.getPropertyString("metadatafqid"));
            this.m_lData.add(alRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void deleteAllRows() throws MdException, RemoteException {
        WsJobSubmissionManager.getInstance().clearAllServerRequests();
        this.moveDataToModel();
    }

    public void deleteRow(int iRow) {
        String sJobNotComplete = WsServerRequest.JOBRUNNING;
        if (!sJobNotComplete.equals(this.getValueAt(iRow, 1))) {
            WsJobSubmissionManager.getInstance().clearServerRequest((String)this.getValueAt(iRow, 5));
            super.deleteRow(iRow);
        }
    }

    public void updateWsServerRequestRow(WsServerRequest iServerRequest) {
        if (!iServerRequest.getPropertyString("jobstatus").equalsIgnoreCase(WsServerRequest.DISPOSED)) {
            iServerRequest.getMetadataFQID();
            int nRows = this.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                String metadatafqid = (String)this.getValueAt(iRow, 5);
                if (!metadatafqid.equals(iServerRequest.getMetadataFQID())) continue;
                this.setValueAt(iServerRequest.getPropertyString("jobname"), iRow, 0);
                this.setValueAt(iServerRequest.getPropertyString("jobstatus"), iRow, 1);
                this.setValueAt(iServerRequest.getPropertyDate("starttime"), iRow, 2);
                this.setValueAt(iServerRequest.getPropertyDate("endtime"), iRow, 3);
                this.setValueAt(iServerRequest.getPropertyString("wsappserver"), iRow, 4);
                return;
            }
            ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(iServerRequest.getPropertyString("jobname"));
            alRow.add(iServerRequest.getPropertyString("jobstatus"));
            alRow.add(iServerRequest.getPropertyDate("starttime"));
            alRow.add(iServerRequest.getPropertyDate("endtime"));
            alRow.add(iServerRequest.getPropertyString("wsappserver"));
            alRow.add(iServerRequest.getPropertyString("metadatafqid"));
            this.m_lData.add(alRow);
            if (++nRows > 0) {
                this.fireTableRowsInserted(nRows - 1, nRows - 1);
            }
            this.m_nRowInstances += nRows;
        }
    }

    public CMetadata getRowMetadataObject(int iRow) {
        return WsJobSubmissionManager.getInstance().getWsServerRequestMetadata((String)this.getValueAt(iRow, 5));
    }

    public void terminateSubmittedCodeForRow(int iRow) {
        String sJobNotComplete = WsServerRequest.JOBRUNNING;
        if (sJobNotComplete.equals(this.getValueAt(iRow, 1))) {
            WsJobSubmissionManager.getInstance().termWsServerRequestCode((String)this.getValueAt(iRow, 5));
            WsStringTableColumn colStatus = (WsStringTableColumn)this.m_aColumns[1];
            WsServerRequest serverRequest = WsJobSubmissionManager.getInstance().getWsServerRequest((String)this.getValueAt(iRow, 5));
            colStatus.setDefaultValue(serverRequest.getPropertyString("jobstatus"));
        }
    }

    public void killAppServerForRow(int iRow) {
        String sJobNotComplete = WsServerRequest.JOBRUNNING;
        if (sJobNotComplete.equals(this.getValueAt(iRow, 1))) {
            WsJobSubmissionManager.getInstance().killAppServer((String)this.getValueAt(iRow, 5));
            WsStringTableColumn colStatus = (WsStringTableColumn)this.m_aColumns[1];
            WsServerRequest serverRequest = WsJobSubmissionManager.getInstance().getWsServerRequest((String)this.getValueAt(iRow, 5));
            colStatus.setDefaultValue(serverRequest.getPropertyString("jobstatus"));
        }
    }

    public void submitWsServerRequestForRow(int iRow, WsEditorOMAView editorView) {
        String sJobNotComplete = WsServerRequest.JOBRUNNING;
        if (!sJobNotComplete.equals(this.getValueAt(iRow, 1))) {
            WsStringTableColumn colStatus = (WsStringTableColumn)this.m_aColumns[1];
            WsServerRequest serverRequest = WsJobSubmissionManager.getInstance().getWsServerRequest((String)this.getValueAt(iRow, 5));
            if (serverRequest.getWsAppServer() != null) {
                editorView.getEditorTab().submitCode();
            }
            colStatus.setDefaultValue(serverRequest.getPropertyString("jobstatus"));
        }
    }
}

