/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.visuals.JobStatusBarIcon;
import com.sas.wadmin.visuals.JobStatusTableModel;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoManager;

public class JobStatusPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(JobStatusPanel.class);
    protected JobStatusTableModel m_mdlJobStatus = new JobStatusTableModel();
    protected MdObjectStore m_objectStore;
    protected WsTable m_tblJobStatus;
    protected JScrollPane m_scrJobStatus;
    protected JButton m_btnClearAll;
    protected JButton m_btnHelp;
    protected JPanel m_pnlButtons;
    protected WsAbstractAction m_actManagerMenu;
    protected WsAbstractAction m_actClearAll;
    protected WsAbstractAction m_actHelp;
    protected WsAbstractAction m_actClear;
    protected WsAbstractAction m_actViewJob;
    protected WsAbstractAction m_actTerminateJob;
    protected WsAbstractAction m_actKillJob;
    protected WsAbstractAction m_actResubmitJob;
    protected cDataChangedListener m_chgListener;
    protected boolean m_bShowButtons;
    private static JobStatusPanel g_instance;

    private JobStatusPanel(boolean bShowButtons) {
        this.m_bShowButtons = bShowButtons;
        this.initialize();
        this.layoutWidgets();
        g_instance = this;
    }

    public static JobStatusPanel getInstance() {
        if (g_instance == null) {
            g_instance = new JobStatusPanel(true);
        }
        return g_instance;
    }

    protected void initialize() {
        this.createActions();
        this.m_tblJobStatus = new WsTable((WsAbstractTableModel)this.m_mdlJobStatus);
        this.m_tblJobStatus.setToolTipText(bundle.getString("JobStatusPanel.Table.ToolTip.txt"));
        this.m_tblJobStatus.setRowsReorderable(false);
        this.m_tblJobStatus.setRowHoldingEnabled(false);
        this.m_tblJobStatus.setColumnsReorderable(false);
        this.m_tblJobStatus.setColumnHoldingEnabled(false);
        this.m_tblJobStatus.setAutoResizeMode(3);
        this.m_tblJobStatus.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblJobStatus.setUndoManager((UndoManager)this.waum);
        this.m_tblJobStatus.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_tblJobStatus.setRowHeaderPopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tblJobStatus.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tblJobStatus.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_chgListener = this.createDataChangedListener();
        WsJobSubmissionManager.getInstance().addPropertyChangeListener((PropertyChangeListener)this.m_chgListener);
        this.m_scrJobStatus = new JScrollPane((Component)this.m_tblJobStatus);
        this.createButtonsPanel();
    }

    protected void createButtonsPanel() {
        this.m_btnClearAll = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actClearAll);
        this.m_btnHelp = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actHelp);
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlRight.add(this.m_btnClearAll);
        pnlRight.add(this.m_btnHelp);
        this.m_pnlButtons = new JPanel(new BorderLayout(0, 0));
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout(0, 5));
        this.add(this.m_scrJobStatus, "Center");
        if (this.m_bShowButtons) {
            this.add(this.m_pnlButtons, "South");
        }
    }

    public boolean validateData() {
        return true;
    }

    public void saveSettingsAndCleanUp() {
        WsJobSubmissionManager.getInstance().removePropertyChangeListener((PropertyChangeListener)this.m_chgListener);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblJobStatus.setEditable(bEditable);
        this.m_actClearAll.setEnabled(bEditable && this.m_tblJobStatus.getSelectedRows().length > 0);
        this.m_actHelp.setEnabled(bEditable);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlJobStatus.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlJobStatus.moveDataToModel();
        if (this.m_mdlJobStatus.getRowCount() > 0) {
            this.m_tblJobStatus.selectCell(0, 0);
        }
        this.updateActions();
        JobStatusBarIcon.getInstance().resetJobStatusBarIcon();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlJobStatus.moveDataToStore();
        this.setDataChanged(false);
    }

    protected WsEditorOMAView showProcessView(int iRow) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        CMetadata oMetadata = this.m_mdlJobStatus.getRowMetadataObject(iRow);
        Job oJob = null;
        if (oMetadata instanceof Job) {
            oJob = (Job)oMetadata;
            return JobTreeNode.showProcessView((CMetadata)oJob);
        }
        return null;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actManagerMenu.setActive(bActive);
        this.m_actClearAll.setActive(bActive);
        this.m_actHelp.setActive(bActive);
        this.m_actClear.setActive(bActive);
        this.m_actViewJob.setActive(bActive);
        this.m_actTerminateJob.setActive(bActive);
        this.m_actKillJob.setActive(bActive);
        this.m_actResubmitJob.setActive(bActive);
        this.updateActions();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected cDataChangedListener createDataChangedListener() {
        return new cDataChangedListener();
    }

    protected void createActions() {
        this.m_actManagerMenu = this.createManagerMenuAction();
        this.m_actClearAll = this.createClearAllAction();
        this.m_actClear = this.createClearAction();
        this.m_actHelp = this.createHelpAction();
        this.m_actViewJob = this.createViewJobAction();
        this.m_actTerminateJob = this.createTerminateJobAction();
        this.m_actKillJob = this.createKillJobAction();
        this.m_actResubmitJob = this.createResubmitJobAction();
    }

    protected void updateActions() {
        int[] aSelectedRows = this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
        this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
        boolean bEditable = this.isEditable();
        boolean bSelected = aSelectedRows.length > 0;
        boolean bJobComplete = false;
        boolean bOneSelected = false;
        boolean bOneRow = false;
        if (this.m_mdlJobStatus.getRowCount() > 0) {
            bOneRow = true;
        }
        if (aSelectedRows.length == 1) {
            bOneSelected = true;
            String sStatus = (String)this.m_mdlJobStatus.getValueAt(aSelectedRows[0], 1);
            bJobComplete = !sStatus.equals(WsServerRequest.JOBRUNNING) && !sStatus.equals(WsServerRequest.JOBCANCELINPROGRESS);
        }
        this.m_actTerminateJob.setEnabled(bEditable && bOneSelected && !bJobComplete);
        this.m_actKillJob.setEnabled(bEditable && bOneSelected && !bJobComplete);
        this.m_actClear.setEnabled(bEditable && bOneSelected && bJobComplete);
        this.m_actResubmitJob.setEnabled(bEditable && bOneSelected && bJobComplete);
        this.m_actViewJob.setEnabled(bEditable && bSelected);
        this.m_actClearAll.setEnabled(bEditable && bOneRow);
        this.m_actHelp.setEnabled(bEditable);
    }

    protected WsAbstractAction createManagerMenuAction() {
        return new cManagerMenuAction();
    }

    protected WsAbstractAction createClearAllAction() {
        return new cClearAllAction();
    }

    protected WsAbstractAction createHelpAction() {
        return new cHelpAction();
    }

    protected WsAbstractAction createClearAction() {
        return new cClearAction();
    }

    protected WsAbstractAction createViewJobAction() {
        return new cViewJobAction();
    }

    protected WsAbstractAction createTerminateJobAction() {
        return new cTerminateJobAction();
    }

    protected WsAbstractAction createKillJobAction() {
        return new cKillJobAction();
    }

    protected WsAbstractAction createResubmitJobAction() {
        return new cResubmitJobAction();
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SwingUtilities.invokeLater(new cRunnable(e));
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JobStatusPanel.this.updateActions();
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actClearAll));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actClear));
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actViewJob));
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actTerminateJob));
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actKillJob));
            mnuPopup.add(new JMenuItem((Action)JobStatusPanel.this.m_actResubmitJob));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JobStatusPanel.this.updateActions();
        }
    }

    protected class cRunnable
    implements Runnable {
        PropertyChangeEvent m_evt;

        cRunnable(PropertyChangeEvent evt) {
            this.m_evt = evt;
        }

        @Override
        public void run() {
            JobStatusPanel.this.updateActions();
            Object oSource = this.m_evt.getSource();
            if (oSource instanceof WsServerRequest) {
                if (!this.m_evt.getNewValue().equals(WsServerRequest.DISPOSED)) {
                    WsServerRequest serverRequest = (WsServerRequest)oSource;
                    JobStatusPanel.this.m_mdlJobStatus.updateWsServerRequestRow(serverRequest);
                    if (JobStatusPanel.this.m_mdlJobStatus.getRowCount() > 0) {
                        JobStatusPanel.this.m_tblJobStatus.selectCell(0, 0);
                    }
                } else {
                    try {
                        JobStatusPanel.this.m_mdlJobStatus.moveDataToModel();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            }
        }
    }

    protected class cResubmitJobAction
    extends WsAbstractAction {
        public cResubmitJobAction() {
            super(bundle, "JobStatusPanel.ResubmitJob", false, false);
            this.setMenuSupportId("resubmitjob");
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = JobStatusPanel.this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
            JobStatusPanel.this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
            for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
                WsEditorOMAView editorView = JobStatusPanel.this.showProcessView(aSelectedRows[iRow]);
                JobStatusPanel.this.m_mdlJobStatus.submitWsServerRequestForRow(aSelectedRows[iRow], editorView);
            }
        }
    }

    protected class cKillJobAction
    extends WsAbstractAction {
        public cKillJobAction() {
            super(bundle, "JobStatusPanel.KillJob", false, false);
            this.setMenuSupportId("kill");
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("JobStatusPanel.ConfirmKillMessage.txt"), (String)bundle.getString("JobStatusPanel.ConfirmKillTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            int[] aSelectedRows = JobStatusPanel.this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
            JobStatusPanel.this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
            for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
                JobStatusPanel.this.m_mdlJobStatus.killAppServerForRow(aSelectedRows[iRow]);
            }
        }
    }

    protected class cTerminateJobAction
    extends WsAbstractAction {
        public cTerminateJobAction() {
            super(bundle, "JobStatusPanel.TerminateJob", false, false);
            this.setMenuSupportId("canceljob");
        }

        public void actionPerformed(ActionEvent e) {
            int eAnswer = MessageUtil.displayMessage((String)bundle.getString("JobStatusPanel.ConfirmCancelMessage.txt"), (String)bundle.getString("JobStatusPanel.ConfirmCancelTitle.txt"), (int)1, (int)0);
            if (eAnswer == 1) {
                return;
            }
            int[] aSelectedRows = JobStatusPanel.this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
            JobStatusPanel.this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
            for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
                JobStatusPanel.this.m_mdlJobStatus.terminateSubmittedCodeForRow(aSelectedRows[iRow]);
            }
        }
    }

    protected class cViewJobAction
    extends WsAbstractAction {
        public cViewJobAction() {
            super(bundle, "JobStatusPanel.ViewJob", false, false);
            this.setMenuSupportId("viewpfdjob");
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = JobStatusPanel.this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
            JobStatusPanel.this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
            for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
                JobStatusPanel.this.showProcessView(aSelectedRows[iRow]);
            }
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        public cClearAction() {
            super(bundle, "JobStatusPanel.Clear", false, false);
            this.setMenuSupportId("clear");
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = JobStatusPanel.this.m_tblJobStatus.getSelectedRowsFromSelectedCells();
            JobStatusPanel.this.m_tblJobStatus.convertRowIndexesToModel(aSelectedRows);
            for (int iRow = 0; iRow < aSelectedRows.length; ++iRow) {
                JobStatusPanel.this.m_mdlJobStatus.deleteRow(aSelectedRows[iRow]);
            }
        }
    }

    protected class cClearAllAction
    extends WsAbstractAction {
        public cClearAllAction() {
            super(bundle, "JobStatusPanel.ClearAll", false, false);
            this.setMenuSupportId("clearall");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JobStatusPanel.this.m_mdlJobStatus.deleteAllRows();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class cHelpAction
    extends WsAbstractAction {
        public cHelpAction() {
            super(bundle, "JobStatusPanel.Help", false);
        }

        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().showHelp("wdb", "job_status_manager", (Window)Workspace.getWorkspace());
        }
    }

    protected class cManagerMenuAction
    extends WsAbstractAction {
        public cManagerMenuAction() {
            this.setMenuSupportId("managermenu");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

