/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JobStatusBarIcon
extends JLabel {
    private static WAdminResource bundle = WAdminResource.getBundle(JobStatusBarIcon.class);
    protected PropertyChangeListener m_lstnrJobSubmissionManager;
    protected WsPopupMenuRequestListener m_lstnrPopupMenu;
    protected Icon m_iconBase;
    protected WsAbstractAction m_actJobs;
    protected WsAbstractAction m_actJobStatusManager;
    private static JobStatusBarIcon m_WsJobStatusBarIconInstance = new JobStatusBarIcon();

    private JobStatusBarIcon() {
        this.initialize();
    }

    public static JobStatusBarIcon getInstance() {
        return m_WsJobStatusBarIconInstance;
    }

    private void initialize() {
        this.m_lstnrJobSubmissionManager = this.createJobSubmissionDataChangedListener();
        WsJobSubmissionManager.getInstance().addPropertyChangeListener(this.m_lstnrJobSubmissionManager);
        this.m_iconBase = bundle.getImageIcon("JobStatusBarIcon.JobStatusIcon.image");
        this.setIcon(this.m_iconBase);
        this.setToolTipText(bundle.getString("JobStatusBarIcon.ToolTip.txt"));
        this.m_actJobStatusManager = this.createJobStatusManagerAction();
        cMouseListener ml = new cMouseListener();
        this.addMouseListener(ml);
    }

    public void resetJobStatusBarIcon() {
        this.setIcon(this.m_iconBase);
    }

    public void setJobStatusBarIconChanged() {
        this.setIcon(bundle.getImageIcon("JobStatusBarIcon.JobStatusChangedIcon.image"));
    }

    protected WsEditorOMAView showProcessView(String iKey) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        CMetadata oMetadata = WsJobSubmissionManager.getInstance().getWsServerRequestMetadata(iKey);
        Job oJob = null;
        if (oMetadata instanceof Job) {
            oJob = (Job)oMetadata;
            return JobTreeNode.showProcessView((CMetadata)oJob);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] oaListeners = this.listenerList.getListenerList();
        for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != ChangeListener.class) continue;
            ((ChangeListener)oaListeners[iListener + 1]).stateChanged(e);
        }
    }

    public PropertyChangeListener createJobSubmissionDataChangedListener() {
        return new cJobSubmissionDataChangedListener();
    }

    protected AbstractAction createJobAction(String sJobName, String iKey) {
        return new cJobAction(sJobName, iKey);
    }

    protected WsAbstractAction createClearAllAction() {
        return new cClearAllAction();
    }

    protected WsAbstractAction createJobStatusManagerAction() {
        return new cJobStatusManagerAction();
    }

    protected List getLast5Jobs() {
        List lKeys = WsJobSubmissionManager.getInstance().getOrderedKeyList();
        ArrayList<WsServerRequest> lJobs = new ArrayList<WsServerRequest>();
        for (int iKey = 1; iKey <= lKeys.size(); ++iKey) {
            if (iKey > 5) {
                return lJobs;
            }
            String sKey = (String)lKeys.get(lKeys.size() - iKey);
            lJobs.add(WsJobSubmissionManager.getInstance().getWsServerRequest(sKey));
        }
        return lJobs;
    }

    protected JPopupMenu createJobMenu(JPopupMenu mnuPopup) {
        List lJobs = new ArrayList();
        lJobs = this.getLast5Jobs();
        if (!lJobs.isEmpty()) {
            int nJobs = lJobs.size();
            for (int iJob = 0; iJob < nJobs; ++iJob) {
                WsServerRequest serverRequest = (WsServerRequest)lJobs.get(iJob);
                if (serverRequest.getWsAppServer() == null || serverRequest.getPropertyString("jobstatus").length() <= 0) continue;
                String sJobLine = serverRequest.getPropertyString("jobname") + ": " + serverRequest.getPropertyString("jobstatus");
                mnuPopup.add(this.createJobAction(sJobLine, serverRequest.getMetadataFQID()));
            }
        }
        return mnuPopup;
    }

    public void handlePopupEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.setIcon(bundle.getImageIcon("JobStatusBarIcon.JobStatusIcon.image"));
            this.showPopupMenu(e);
        }
    }

    public void showPopupMenu(MouseEvent e) {
    }

    protected class cMouseListener
    extends MouseAdapter {
        protected cMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JobStatusBarIcon.this.handlePopupEvent(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JobStatusBarIcon.this.m_actJobStatusManager.actionPerformed(new ActionEvent("doubleClick", -1, ""));
            }
        }
    }

    protected class cJobSubmissionDataChangedListener
    implements PropertyChangeListener {
        protected cJobSubmissionDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getNewValue().equals(WsServerRequest.JOBABORTED) || e.getNewValue().equals(WsServerRequest.JOBERRORED) || e.getNewValue().equals(WsServerRequest.JOBKILLED) || e.getNewValue().equals(WsServerRequest.JOBTERMINATED) || e.getNewValue().equals(WsServerRequest.JOBSUCCESSFUL) || e.getNewValue().equals(WsServerRequest.JOBCANCELLED) || e.getNewValue().equals(WsServerRequest.JOBRUNNING)) {
                JobStatusBarIcon.this.setIcon(bundle.getImageIcon("JobStatusBarIcon.JobStatusChangedIcon.image"));
            }
        }
    }

    protected class cJobAction
    extends AbstractAction {
        String m_iKey;

        public cJobAction(String sJobName, String iKey) {
            super(sJobName);
            this.m_iKey = iKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JobStatusBarIcon.this.showProcessView(this.m_iKey);
        }
    }

    protected class cJobStatusManagerAction
    extends WsAbstractAction {
        public cJobStatusManagerAction() {
            super(bundle, "JobStatusBarIcon.JobStatusManager", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            AppFrameworkManager.getInstance().setVisible("RuntimeManager", true);
        }
    }

    protected class cClearAllAction
    extends WsAbstractAction {
        public cClearAllAction() {
            super(bundle, "JobStatusBarIcon.ClearAll", false, false);
            this.setMenuSupportId("clearall");
            if (WsJobSubmissionManager.getInstance().getAllWsServerRequests().isEmpty()) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.setIcon(bundle.getImageIcon("JobStatusBarIcon.JobStatusIcon.image"));
            WsJobSubmissionManager.getInstance().clearAllServerRequests();
        }
    }
}

