/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.InventoryMetadataObjectsFolderNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import java.rmi.RemoteException;
import java.util.List;

public class InventoryTreeNode
extends InventoryMetadataObjectsFolderNode {
    protected String m_sReposId;
    protected String m_sType;
    protected String m_sAddXMLSelect;
    protected String m_sRemoveXMLSelect;
    protected boolean m_bAllowsGrandChildren;

    public InventoryTreeNode(String sName, String sType, String sReposId) {
        this(sName, sType, sReposId, null);
    }

    public InventoryTreeNode(String sName, String sType, String sReposId, String sXMLSelect) {
        this(sName, sType, sReposId, sXMLSelect, null);
    }

    public InventoryTreeNode(String sName, String sType, String sReposId, String sAddXMLSelect, String sRemoveXMLSelect) {
        super(sName, sType, sReposId);
        this.m_sType = sType;
        this.m_sReposId = sReposId;
        this.m_sAddXMLSelect = sAddXMLSelect;
        this.m_sRemoveXMLSelect = sRemoveXMLSelect;
    }

    @Override
    public void addChildren() {
        List lObjects = this.getListOfObjects();
        if (lObjects == null) {
            return;
        }
        int nObjects = lObjects.size();
        for (int iObject = 0; iObject < nObjects; ++iObject) {
            CMetadata oData = (CMetadata)lObjects.get(iObject);
            this.addChild(this.createChild(oData));
        }
    }

    protected List getListOfObjects() {
        List lObjects = null;
        try {
            String sOptions;
            int fFlags;
            if (this.m_sAddXMLSelect == null) {
                fFlags = 264;
                sOptions = "";
            } else {
                fFlags = 392;
                sOptions = this.generateXMLSelectOptionString(this.m_sAddXMLSelect);
            }
            lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(this.getRepositoryFQID(), this.m_sType, fFlags, sOptions);
            if (this.m_sRemoveXMLSelect != null) {
                List lRemoveObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(this.getRepositoryFQID(), this.m_sType, 128, this.generateXMLSelectOptionString(this.m_sRemoveXMLSelect));
                int nRemoveObjects = lRemoveObjects.size();
                block3: for (int iRemoveObject = 0; iRemoveObject < nRemoveObjects; ++iRemoveObject) {
                    String sRemoveFQID = ((CMetadata)lRemoveObjects.get(iRemoveObject)).getFQID();
                    int nObjects = lObjects.size();
                    for (int iObject = 0; iObject < nObjects; ++iObject) {
                        CMetadata oData = (CMetadata)lObjects.get(iObject);
                        if (!oData.getFQID().equals(sRemoveFQID)) continue;
                        lObjects.remove(iObject);
                        continue block3;
                    }
                }
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return lObjects;
    }

    protected String generateXMLSelectOptionString(String sXMLSelect) {
        StringBuffer sOptions = new StringBuffer();
        sOptions.append("<XMLSELECT Search=\"");
        sOptions.append(sXMLSelect);
        sOptions.append("\"/>");
        return sOptions.toString();
    }

    @Override
    public void setAllowsGrandChildren(boolean bAllowsGrandChildren) {
        super.setAllowsGrandChildren(bAllowsGrandChildren);
        this.m_bAllowsGrandChildren = bAllowsGrandChildren;
    }

    @Override
    public boolean isValidAncestorFor(CMetadata oMetadata) {
        try {
            return this.m_sType.equals("SASLibrary") && oMetadata.getCMetadataType().equals("PhysicalTable");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    public boolean isValidParentFor(CMetadata oMetadata) {
        try {
            if (!this.getRepositoryFQID().substring(9).equals(oMetadata.getRepositoryID())) {
                return false;
            }
            if (!this.m_sType.equals(oMetadata.getCMetadataType())) {
                return false;
            }
            if (this.m_sAddXMLSelect == null && this.m_sRemoveXMLSelect == null) {
                return true;
            }
            String sFQID = oMetadata.getFQID();
            List lObjects = this.getListOfObjects();
            int nObjects = lObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                CMetadata oData = (CMetadata)lObjects.get(iObject);
                if (!oData.getFQID().equals(sFQID)) continue;
                return true;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public WsTreeNode createChild(CMetadata oMetadata) {
        WsNodeFactory factory = this.getTreeModel().getNodeFactory();
        WsDataTreeNode nodeChild = null;
        if (factory != null) {
            try {
                nodeChild = factory.createObjectNode((Root)oMetadata, (WsTreeNode)this);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            nodeChild = WorkspaceTree.createDataTreeNode((CMetadata)oMetadata, (String)"com.sas.wadmin.visuals.", (String)"TreeNode");
        }
        nodeChild.setAllowsChildren(this.allowsGrandChildren());
        return nodeChild;
    }
}

