/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.model.IndexTreeNode;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class IndexTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTreeCellRenderer.class);
    protected static Icon g_iconOpen = WorkspaceTree.getOpenedFolderIcon();
    protected static Icon g_iconClosed = WorkspaceTree.getClosedFolderIcon();
    protected static Icon g_iconIndex = WAdminResource.getTypeIcon((String)"Index", (boolean)true);

    public IndexTreeCellRenderer() {
        this.setLeafIcon(g_iconClosed);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object object, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bFocused) {
        String sTip;
        Icon icon;
        super.getTreeCellRendererComponent(tree, object, bSelected, bExpanded, bLeaf, iRow, bFocused);
        IndexTreeNode node = (IndexTreeNode)object;
        if (node.isRoot()) {
            icon = bExpanded ? g_iconOpen : g_iconClosed;
            sTip = bundle.getString("IndexTreeCellRenderer.RootNode.ToolTip.txt");
        } else if (node.isIndex()) {
            icon = g_iconIndex;
            sTip = "";
        } else {
            icon = WsColumnMetadataUtil.getColumnViewTypeIcon((String)node.getType());
            sTip = node.getDescription();
            if (sTip == null || sTip.length() > 0) {
                sTip = bundle.getString("IndexTreeCellRenderer.ColumnNode.DefaultToolTip.txt");
            }
        }
        this.setToolTipText(sTip);
        this.setIcon(icon);
        return this;
    }
}

