/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.ImpactAnalysisUtilities;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.RawDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsTree;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ImpactAnalysisReportTab
extends WAPropertyTab
implements WsSelectionProvider {
    private static WAdminResource bundle = WAdminResource.getBundle(ImpactAnalysisReportTab.class);
    private Classifier m_oTable;
    private Column m_oColumn;
    private Prototype m_oTransformPrototype;
    private Transformation m_oTransformation;
    private cTreeModel m_mdlReport;
    private WsTree m_treeReport;
    private JScrollPane m_scrReport;
    private WsAbstractAction m_actFindFirst;
    private WsAbstractAction m_actPrint;
    private WsAbstractAction m_actPageSetup;
    private PageFormat m_pageFormat;
    private Object[] m_aSelectedObjects;
    private static HashMap m_lRepositories;
    private List m_lListeners;
    private static boolean m_bDoesBIReposExist;
    private static String m_BIReposID;

    public ImpactAnalysisReportTab(Root oObject, TransformInterface oTransform, boolean bForward) {
        try {
            if (oObject.getCMetadataType().equals("PhysicalTable") || oObject.getCMetadataType().equals("ExternalTable") || oObject.getCMetadataType().equals("WorkTable") || oObject.getCMetadataType().equals("Cube")) {
                this.m_oTable = (Classifier)oObject;
            } else if (oObject.getCMetadataType().equals("Column")) {
                this.m_oColumn = (Column)oObject;
            } else if (oObject.getCMetadataType().equals("Prototype")) {
                this.m_oTransformPrototype = (Prototype)oObject;
            } else if (oObject.getCMetadataType().equals("Transformation")) {
                this.m_oTransformation = (Transformation)oObject;
            }
            this.initialize(bForward);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public ImpactAnalysisReportTab(Prototype mdoTransform) {
        this.m_oTransformPrototype = mdoTransform;
        this.initialize(true);
    }

    public ImpactAnalysisReportTab(PhysicalTable oTable, boolean bForward) {
        this.m_oTable = oTable;
        this.initialize(bForward);
    }

    public ImpactAnalysisReportTab(Classifier oTable, boolean bForward) {
        this.m_oTable = oTable;
        this.initialize(bForward);
    }

    public ImpactAnalysisReportTab(Column oColumn, boolean bForward) {
        this.m_oColumn = oColumn;
        this.initialize(bForward);
    }

    public ImpactAnalysisReportTab(Transformation oTrans, boolean bForward) {
        this.m_oTransformation = oTrans;
        this.initialize(bForward);
    }

    protected void initialize(boolean bForward) {
        this.m_lListeners = new ArrayList();
        this.createActions();
        try {
            int i;
            List lRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
            m_lRepositories = new HashMap();
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata repos = (CMetadata)lRepositories.get(i);
                String sFQID = repos.getFQID();
                String sReposName = repos.getName();
                m_lRepositories.put(sFQID.substring(9), sReposName);
            }
            m_bDoesBIReposExist = false;
            m_BIReposID = "";
            for (i = 0; i < lRepositories.size(); ++i) {
                CMetadata tmpMetadata = (CMetadata)lRepositories.get(i);
                if (!tmpMetadata.getName().equalsIgnoreCase("BILineage")) continue;
                m_bDoesBIReposExist = true;
                m_BIReposID = tmpMetadata.getFQID();
                break;
            }
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_aSelectedObjects = new Object[0];
        if (this.m_oTable != null) {
            this.m_mdlReport = new cTableTreeModel(this.m_oTable, bForward);
        } else if (this.m_oColumn != null) {
            this.m_mdlReport = new cColumnTreeModel(this.m_oColumn, bForward);
        } else if (this.m_oTransformPrototype != null) {
            this.m_mdlReport = new cTransformTreeModel(this.m_oTransformPrototype);
        } else if (this.m_oTransformation != null) {
            this.m_mdlReport = new cTransformationTreeModel(this.m_oTransformation, bForward);
        }
        this.m_treeReport = new WsTree((DefaultTreeModel)this.m_mdlReport);
        this.m_treeReport.setEditable(false);
        this.m_treeReport.addTreeSelectionListener((TreeSelectionListener)new cTreeSelectionListener());
        this.m_treeReport.setPopupMenuRequestListener((WsPopupMenuRequestListener)new cTreePopupMenuRequestListener());
        this.m_scrReport = new JScrollPane((Component)this.m_treeReport);
        this.m_scrReport.setPreferredSize(new Dimension(300, 400));
        this.setLayout(new BorderLayout());
        this.add(this.m_scrReport, "Center");
        this.updateActions();
        this.setHelpTopic("impact_analysis_win");
        this.setHelpProduct("wdb");
    }

    protected void createActions() {
        this.m_actFindFirst = new cFindFirstAction();
        this.m_actPrint = new cPrintAction();
        this.m_actPageSetup = new cPageSetupAction();
    }

    protected void updateActions() {
        cTreeNode nodeSelected = (cTreeNode)this.m_treeReport.getSelectedNode();
        this.m_actFindFirst.setEnabled(nodeSelected != null && nodeSelected.getFirstInstance() != null);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdlReport.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlReport.moveDataToModel();
        this.m_treeReport.expand();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public boolean validateData() {
        return true;
    }

    protected static boolean getUseDependentReposFlag() {
        return true;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_treeReport.updateWorkspaceUIComponents(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        WsAbstractApplicationFrameworkManager.getInstance().setSelectionProvider((WsSelectionProvider)(bActive ? this : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showProcessView(String sName, String sType, String sFQID) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            SimpleObjectImpl simpleJob = new SimpleObjectImpl(sName, sFQID, sType, "Job");
            AppViewFactory.getInstance().showOpenView((SimpleObject)simpleJob);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setTransform(TransformInterface oTransform) {
    }

    private static Job getJobFor(TransformationStep oTS) throws MdException, RemoteException {
        TransformationActivity oTA;
        AssociationList lJobs;
        if (oTS == null) {
            return null;
        }
        AssociationList lTAs = oTS.getActivities();
        if (!lTAs.isEmpty() && !(lJobs = (oTA = (TransformationActivity)lTAs.get(0)).getJobs()).isEmpty()) {
            return (Job)lJobs.get(0);
        }
        return null;
    }

    private static TransformationStep getStepFor(FeatureMap oFM) throws MdException, RemoteException {
        ClassifierMap oCM = oFM.getAssociatedClassifierMap();
        if (oCM != null) {
            AssociationList lTSs = oCM.getSteps();
            if (!lTSs.isEmpty()) {
                return (TransformationStep)lTSs.get(0);
            }
            TransformationStep ts = ImpactAnalysisReportTab.lookForSetOperators(oCM);
            if (ts != null) {
                return ts;
            }
        }
        return null;
    }

    private static TransformationStep lookForSetOperators(ClassifierMap oCM) throws MdException, RemoteException {
        ClassifierMap cm2;
        AssociationList cm2Steps;
        AssociationList l_moreSTs;
        ClassifierMap cm;
        AssociationList lSTs = oCM.getSourceTransformations();
        if (lSTs.isEmpty()) {
            lSTs = oCM.getTargetTransformations();
        }
        if (!lSTs.isEmpty() && (cm = (ClassifierMap)lSTs.get(0)).getTransformRole().equalsIgnoreCase("SetOperator") && !(l_moreSTs = cm.getSourceTransformations()).isEmpty() && !(cm2Steps = (cm2 = (ClassifierMap)l_moreSTs.get(0)).getSteps()).isEmpty()) {
            return (TransformationStep)cm2Steps.get(0);
        }
        return null;
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.m_lListeners.add(lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.m_lListeners.remove(lsnr);
    }

    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    private void fireSelectionChangedEvent() {
        WsTreeNode[] aNodes = this.m_treeReport.getSelectedNodes();
        ArrayList<SimpleObjectImpl> lObjects = new ArrayList<SimpleObjectImpl>();
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            cTreeNode node = (cTreeNode)aNodes[iNode];
            if (node == null || node.getPublicType() == null || node.getPublicType().length() == 0) continue;
            SimpleObjectImpl obj = new SimpleObjectImpl(node.getName(), node.getFQID(), node.getType(), node.getPublicType());
            lObjects.add(obj);
        }
        if (lObjects.size() == 0) {
            return;
        }
        this.m_aSelectedObjects = lObjects.toArray();
        if (this.m_lListeners.isEmpty()) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < this.m_lListeners.size(); ++iListener) {
            ((WsSelectionChangedListener)this.m_lListeners.get(iListener)).selectionChanged(ev);
        }
    }

    static {
        m_BIReposID = "";
    }

    protected static class cFeatureTreeNode
    extends cTreeNode {
        Feature m_oFeature;

        public cFeatureTreeNode(Feature oFeature) {
            super((Root)oFeature);
            this.m_oFeature = oFeature;
            try {
                this.m_icon = ImpactAnalysisUtilities.getIconForBILineage((CMetadata)oFeature);
            }
            catch (MdException mde) {
                mde.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void doDefaultAction() {
        }

        @Override
        protected void createActions() {
            super.createActions();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
        }

        @Override
        public String toString() {
            StringBuffer sName = new StringBuffer();
            if (this.getFirstInstance() != null) {
                sName.append(bundle.formatString("ImpactAnalysisReportTab.AdditionalInstance.fmt.txt", (Object)this.m_sName));
            } else {
                sName.append(this.m_sName);
            }
            String parentName = "";
            try {
                parentName = " (" + ((CMetadata)this.m_oFeature.getGroups().get(0)).getName() + ")";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parentName.length() > 0) {
                sName.append(parentName);
            }
            if (this.getFQID().length() > 9) {
                String sReposName = (String)m_lRepositories.get(this.getFQID().substring(0, 8));
                sName.append(" (").append(sReposName).append(")");
            }
            return sName.toString();
        }
    }

    protected static class cGroupTreeNode
    extends cTreeNode {
        Group m_oGroup;

        public cGroupTreeNode(Group oGroup) {
            super((Root)oGroup);
            this.m_oGroup = oGroup;
            try {
                this.m_icon = ImpactAnalysisUtilities.getIconForBILineage((CMetadata)oGroup);
            }
            catch (MdException mde) {
                mde.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void doDefaultAction() {
        }

        @Override
        protected void createActions() {
            super.createActions();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
        }
    }

    protected static class cTransformationTreeNode
    extends cTreeNode {
        Transformation m_oTrans;

        public cTransformationTreeNode(Transformation oTrans) {
            super((Root)oTrans);
            this.m_oTrans = oTrans;
            int fFlags = 264;
            if (ImpactAnalysisReportTab.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            try {
                if (oTrans.getTransformRole().length() == 0) {
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oTrans, null, null, null, fFlags);
                }
                this.m_icon = ImpactAnalysisUtilities.getCubeTypeIcon(oTrans.getTransformRole());
            }
            catch (MdException mde) {
                mde.printStackTrace();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        protected void createActions() {
            super.createActions();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
            super.addPopupMenuItems(mnuPopup);
        }
    }

    protected static class cTransformationTreeModel
    extends cTreeModel {
        private Transformation m_oTrans;
        private boolean m_bDataMovedToModel;

        public cTransformationTreeModel(Transformation oTrans, boolean bForward) {
            super(new cTransformationTreeNode(oTrans), bForward);
            this.m_oTrans = oTrans;
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(this.m_oTrans);
        }

        private void populateStore(Transformation oTrans) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                lAssociations.add("TransformationTargets");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/><TriggeredEvents/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TransformationSources");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cTransformationTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oTrans, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            if (this.m_bDataMovedToModel) {
                return;
            }
            cTreeNode nodeRoot = (cTreeNode)((Object)this.getRoot());
            this.removeAllChildrenFromParent((MutableTreeNode)((Object)nodeRoot));
            cStepList lSteps = this.getNextSteps(this.m_oTrans);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeRoot, nodeRoot, lSteps.getStep(iStep), null);
            }
            this.m_bDataMovedToModel = true;
            int numChildren = nodeRoot.getChildCount();
            if (numChildren == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpact.txt"));
            }
        }

        private void addStepNode(cTreeNode nodeParent, cTreeNode nodeTable, cStep step, Job oJob) throws MdException, RemoteException {
            AssociationList lTrans;
            Job oStepJob = ImpactAnalysisReportTab.getJobFor(step.getStep());
            if (oStepJob == null) {
                return;
            }
            if (oStepJob != oJob) {
                if (nodeTable == null) {
                    Workspace.getDefaultLogger().error((Object)"nodeTable == null when switching jobs");
                    nodeTable = nodeParent;
                }
                nodeParent = new cJobTreeNode(oStepJob);
                this.addChild((MutableTreeNode)((Object)nodeParent), (MutableTreeNode)((Object)nodeTable));
            }
            cTreeNode nodePrevious = this.find((Root)step.getStep());
            cStepTreeNode nodeStep = new cStepTreeNode(step.getStep());
            this.addChild((MutableTreeNode)((Object)nodeStep), (MutableTreeNode)((Object)nodeParent));
            if (nodePrevious != null) {
                nodeStep.setFirstInstance(nodePrevious);
                return;
            }
            List lTables = this.getNextTables(step.getMaps());
            if (lTables.size() > 1) {
                for (int iTable = 0; iTable < lTables.size(); ++iTable) {
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(bundle.formatString("ImpactAnalysisReportTab.TableBranch.fmt.txt", (Object)new Integer(iTable + 1)));
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeStep));
                    this.addTableNode(nodeBranch, (Classifier)lTables.get(iTable), oStepJob);
                }
            } else if (lTables.size() == 1) {
                this.addTableNode(nodeParent, (Classifier)lTables.get(0), oStepJob);
            }
            if ((lTrans = this.m_bForward ? step.getStep().getSourceTransformations() : step.getStep().getTargetTransformations()).size() > 1) {
                for (int iTrans = 0; iTrans < lTrans.size(); ++iTrans) {
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(bundle.formatString("ImpactAnalysisReportTab.TableBranch.fmt.txt", (Object)new Integer(iTrans + 1)));
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeStep));
                    this.addTransformationNode(nodeBranch, (Transformation)lTrans.get(iTrans), oStepJob);
                }
            } else if (lTrans.size() == 1) {
                this.addTransformationNode(nodeParent, (Transformation)lTrans.get(0), oStepJob);
            }
        }

        private void addTransformationNode(cTreeNode nodeParent, Transformation oTrans, Job oJob) throws MdException, RemoteException {
            cTransformationTreeNode nodeTable = null;
            cTreeNode nodePrev = this.find((Root)oTrans);
            nodeTable = new cTransformationTreeNode(oTrans);
            this.addChild((MutableTreeNode)((Object)nodeTable), (MutableTreeNode)((Object)nodeParent));
            if (nodePrev != null) {
                nodeTable.setFirstInstance(nodePrev);
                return;
            }
            this.populateStore(oTrans);
            cStepList lSteps = this.getNextSteps(oTrans);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeParent, nodeTable, lSteps.getStep(iStep), null);
            }
        }

        private void addTableNode(cTreeNode nodeParent, Classifier oTable, Job oJob) throws MdException, RemoteException {
            cTableTreeNode nodeTable = null;
            if (oTable.getCMetadataType().equals("PhysicalTable") || oTable.getCMetadataType().equals("ExternalTable") || oTable.getCMetadataType().equals("Cube") || oTable.getCMetadataType().equals("WorkTable")) {
                cTreeNode nodePrev = this.find((Root)oTable);
                nodeTable = new cTableTreeNode(oTable);
                this.addChild((MutableTreeNode)((Object)nodeTable), (MutableTreeNode)((Object)nodeParent));
                if (nodePrev != null) {
                    nodeTable.setFirstInstance(nodePrev);
                    return;
                }
                this.populateStore(oTable);
            }
            if (!oTable.getCMetadataType().equals("Cube")) {
                cStepList lSteps = this.getNextSteps(oTable);
                for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                    this.addStepNode(nodeParent, nodeTable, lSteps.getStep(iStep), oJob);
                }
            }
            AssociationList lSourceTrans = oTable.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                this.addInformationMap((Transformation)lSourceTrans.get(i), nodeTable);
            }
        }

        private void populateStore(Classifier oTable) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                lAssociations.add("SourceClassifierMaps");
                lAssociations.add("SourceTransformations");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/><TriggeredEvents/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TargetClassifierMaps");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cTransformationTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oTable, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        private cStepList getNextSteps(Transformation oTrans) throws MdException, RemoteException {
            cStepList lSteps = new cStepList();
            List lTSs = this.getTransformationSteps(oTrans);
            for (int iTS = 0; iTS < lTSs.size(); ++iTS) {
                TransformationStep oTS = (TransformationStep)lTSs.get(iTS);
                AssociationList lCMs = oTS.getTransformations();
                if (lTSs.isEmpty()) continue;
                lSteps.add(oTS, (AbstractTransformation)((ClassifierMap)lCMs.get(0)));
            }
            return lSteps;
        }

        private cStepList getNextSteps(Classifier oTable) throws MdException, RemoteException {
            cStepList lSteps = new cStepList();
            List lCMs = this.getClassifierMaps(oTable);
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                AssociationList lTSs = oCM.getSteps();
                if (lTSs.isEmpty()) continue;
                lSteps.add((TransformationStep)lTSs.get(0), (AbstractTransformation)oCM);
            }
            return lSteps;
        }

        protected List getTransformationSteps(Transformation oTrans) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oTrans.getTransformationTargets();
            }
            return oTrans.getTransformationSources();
        }

        private List getNextTables(List lCMs) throws MdException, RemoteException {
            ArrayList lTables = new ArrayList();
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                lTables.addAll(this.getTables(oCM));
            }
            return lTables;
        }

        private void addInformationMap(Transformation trans, cTreeNode nodeTable) throws MdException, RemoteException {
            cTreeNode nodePrev = this.find((Root)trans);
            cInformationMapTreeNode imTreeNode = new cInformationMapTreeNode(trans);
            this.addChild((MutableTreeNode)((Object)imTreeNode), (MutableTreeNode)((Object)nodeTable));
            if (nodePrev != null) {
                imTreeNode.setFirstInstance(nodePrev);
            }
            AssociationList l_SourceTrans = trans.getSourceTransformations();
            for (int i = 0; i < l_SourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)l_SourceTrans.get(i);
                this.addInformationMap(sourceTrans, imTreeNode);
            }
        }
    }

    private static class cStep {
        private TransformationStep m_oTS;
        private List m_lMaps;

        public cStep(TransformationStep oTS, AbstractTransformation oMap) {
            this.m_oTS = oTS;
            this.m_lMaps = new ArrayList();
            this.m_lMaps.add(oMap);
        }

        public TransformationStep getStep() {
            return this.m_oTS;
        }

        public List getMaps() {
            return this.m_lMaps;
        }

        public void addMap(AbstractTransformation oMap) {
            this.m_lMaps.add(oMap);
        }
    }

    private static class cStepList {
        private List m_lSteps = new ArrayList();

        public void add(TransformationStep oTS, AbstractTransformation oMap) {
            for (int iStep = 0; iStep < this.m_lSteps.size(); ++iStep) {
                cStep step = this.getStep(iStep);
                if (step.getStep() != oTS) continue;
                step.addMap(oMap);
                return;
            }
            this.m_lSteps.add(new cStep(oTS, oMap));
        }

        public int size() {
            return this.m_lSteps.size();
        }

        public cStep getStep(int iStep) {
            return (cStep)this.m_lSteps.get(iStep);
        }
    }

    protected static class cTreeNode
    extends WsTreeNode {
        private String m_sFQID;
        protected String m_sType;
        private cTreeNode m_nodeFirstInstance;
        private String m_sPublicType;
        protected WsAbstractAction m_actProperties;

        public cTreeNode(Root oObject) {
            super("");
            try {
                this.setName(oObject.getName());
                this.m_sFQID = oObject.getFQID();
                this.m_sType = oObject.getCMetadataType();
                ArrayList<String> attrs = new ArrayList<String>();
                attrs.add("PublicType");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oObject, attrs, null, null, 8);
                if (oObject instanceof PrimaryType) {
                    this.m_sPublicType = ((PrimaryType)oObject).getPublicType();
                }
                this.m_icon = oObject.getCMetadataType().equalsIgnoreCase("WorkTable") ? WsAbstractIconFactory.getInstance().getIconForPublicType("Table") : WsAbstractIconFactory.getInstance().getIconForPublicType(this.m_sPublicType);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            this.createActions();
        }

        public void doDefaultAction() {
            this.onProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProperties() {
            MdFactory factory = null;
            MdObjectStore store = null;
            try {
                factory = Workspace.getWorkspace().getMdObjectFactory();
                store = factory.createObjectStore();
                Root oDetail = this.createPropertiesObject(store);
                if (oDetail.getCMetadataType().equals("Cube")) {
                    SimpleObjectImpl simpleObj = new SimpleObjectImpl(oDetail.getName(), oDetail.getFQID(), oDetail.getCMetadataType(), ((Cube)oDetail).getPublicType());
                    AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)simpleObj);
                } else if (oDetail.getCMetadataType().equals("Prototype")) {
                    if (MacroPluginUtilities.isGeneratedTransform((Root)((Prototype)oDetail))) {
                        boolean fIsUsed = MacroPluginUtilities.isPrototypeUsedInJobs((Prototype)oDetail);
                        if (fIsUsed) {
                            MessageUtil.displayMessage((String)bundle.getString("UsedPlugin.txt"), (int)2);
                        }
                        SimpleObjectImpl simpleObj = new SimpleObjectImpl(oDetail.getName(), oDetail.getFQID(), oDetail.getCMetadataType(), ((Prototype)oDetail).getPublicType());
                        AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)simpleObj);
                    }
                } else if (oDetail.getCMetadataType().equals("Transformation") && ((TransformationImpl)oDetail).getTransformRole().equalsIgnoreCase("SASMessageQueue")) {
                    SimpleObjectImpl simpleObj = new SimpleObjectImpl(oDetail.getName(), oDetail.getFQID(), oDetail.getCMetadataType(), ((Transformation)oDetail).getPublicType());
                    AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)simpleObj);
                } else {
                    Object iObj = null;
                    boolean fFound = false;
                    iObj = oDetail instanceof Column ? ((Column)oDetail).getTable() : (oDetail instanceof FeatureMap ? this.getStepFor((FeatureMap)oDetail) : (PrimaryType)oDetail);
                    if (iObj != null) {
                        SimpleObjectImpl iObjSimple = new SimpleObjectImpl(iObj.getName(), iObj.getFQID(), iObj.getCMetadataType(), iObj.getPublicType());
                        AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)iObjSimple);
                    } else {
                        MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.nopropertysheet.txt"), (int)0);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            finally {
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                }
            }
        }

        private TransformationStep getStepFor(FeatureMap oFM) throws MdException, RemoteException {
            AssociationList lTSs;
            ClassifierMap oCM = oFM.getAssociatedClassifierMap();
            if (oCM != null && (lTSs = oCM.getSteps()).size() > 0) {
                return (TransformationStep)lTSs.get(0);
            }
            return null;
        }

        public cTreeNode(String sName) {
            super(sName);
            this.m_sType = "";
            this.m_sFQID = "";
            this.createActions();
        }

        public boolean equals(Root oObject) {
            try {
                return oObject.getFQID().equals(this.m_sFQID);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }

        public int hashcode() {
            return super.hashCode();
        }

        public void setFirstInstance(cTreeNode nodeFirstInstance) {
            this.m_nodeFirstInstance = nodeFirstInstance;
        }

        public cTreeNode getFirstInstance() {
            return this.m_nodeFirstInstance;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public String getFQID() {
            return this.m_sFQID;
        }

        public String getType() {
            return this.m_sType;
        }

        public String getPublicType() {
            return this.m_sPublicType;
        }

        protected void createActions() {
            this.m_actProperties = new cPropertiesAction();
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            this.m_actProperties.setActive(bActive);
        }

        public void addPopupMenuItems(JPopupMenu mnuPopup) {
            mnuPopup.add((Action)this.m_actProperties);
        }

        public String toString() {
            StringBuffer sName = new StringBuffer();
            if (this.m_nodeFirstInstance != null) {
                sName.append(bundle.formatString("ImpactAnalysisReportTab.AdditionalInstance.fmt.txt", (Object)this.m_sName));
            } else {
                sName.append(this.m_sName);
            }
            if (this.m_sFQID.length() > 9) {
                String sReposName = (String)m_lRepositories.get(this.m_sFQID.substring(0, 8));
                sName.append(" (").append(sReposName).append(")");
            }
            return sName.toString();
        }

        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, this.m_sName, this.m_sType, this.m_sFQID);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }

        protected class cPropertiesAction
        extends WsAbstractAction {
            public cPropertiesAction() {
                super(bundle, "ImpactAnalysisReportTab.Properties", true);
                this.setMenuSupportId("properties");
            }

            public void actionPerformed(ActionEvent e) {
                cTreeNode.this.onProperties();
            }
        }
    }

    protected static class cBranchTreeNode
    extends cTreeNode {
        public cBranchTreeNode(String sName) {
            super(sName);
            this.m_actProperties.setEnabled(false);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
        }

        @Override
        public void doDefaultAction() {
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }
    }

    protected static class cStepTreeNode
    extends cTreeNode {
        private String m_sJobName;
        private String m_sJobType;
        private String m_sJobFQID;
        private String m_sJobPublicType;
        private boolean m_bCanOpenJob;
        private TransformationStep m_oTS;
        private WsAbstractAction m_actViewJob;

        public cStepTreeNode(TransformationStep oTS) throws MdException, RemoteException {
            super((Root)oTS);
            this.m_icon = bundle.getImageIcon("ImpactAnalysisReportTab.TransformationStep.image");
            Job oJob = ImpactAnalysisReportTab.getJobFor(oTS);
            this.m_sJobName = oJob.getName();
            this.m_sJobType = oJob.getCMetadataType();
            this.m_sJobFQID = oJob.getFQID();
            this.m_sJobPublicType = oJob.getPublicType();
            try {
                SimpleObjectImpl simpleJob = new SimpleObjectImpl(oJob.getName(), oJob.getFQID(), oJob.getCMetadataType(), oJob.getPublicType());
                this.m_bCanOpenJob = AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob);
                this.m_actViewJob.setEnabled(this.m_bCanOpenJob);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            this.m_oTS = oTS;
        }

        public cStepTreeNode(TransformationStep oTS, String name) throws MdException, RemoteException {
            this(oTS);
            this.m_sName = name;
        }

        public cStepTreeNode(FeatureMap oFM, Column oColumn) throws MdException, RemoteException {
            super((Root)oFM);
            this.m_icon = bundle.getImageIcon("ImpactAnalysisReportTab.TransformationStep.image");
            TransformationStep oTS = ImpactAnalysisReportTab.getStepFor(oFM);
            Job oJob = ImpactAnalysisReportTab.getJobFor(oTS);
            this.m_sJobName = oJob.getName();
            this.m_sJobType = oJob.getCMetadataType();
            this.m_sJobFQID = oJob.getFQID();
            this.m_oTS = oTS;
            this.m_actProperties.setEnabled(true);
            this.m_sJobPublicType = this.getPublicType();
            try {
                SimpleObjectImpl simpleJob = new SimpleObjectImpl(oJob.getName(), oJob.getFQID(), oJob.getCMetadataType(), oJob.getPublicType());
                this.m_bCanOpenJob = AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob);
                this.m_actViewJob.setEnabled(this.m_bCanOpenJob);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            String sType = TransformationTargetColumnsTableModel.getViewMappingTypeString(oFM);
            this.m_sName = bundle.formatString("ImpactAnalysisReportTab.TransformationStep.NameWithMapping.fmt.txt", (Object)oTS.getName(), (Object)oColumn.getName(), (Object)sType);
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, this.m_sJobName, this.m_sJobType, this.m_sJobFQID);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }

        @Override
        protected void createActions() {
            super.createActions();
            this.m_actViewJob = new cViewJobAction();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            this.m_actViewJob.setActive(bActive & this.m_bCanOpenJob);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
            mnuPopup.add((Action)this.m_actProperties);
            mnuPopup.add((Action)this.m_actViewJob);
        }

        @Override
        public void doDefaultAction() {
            if (this.m_bCanOpenJob) {
                cStepTreeNode.showProcessView(this.m_sJobName, this.m_sJobType, this.m_sJobFQID, this.m_oTS);
            } else {
                super.doDefaultAction();
            }
        }

        @Override
        public void onProperties() {
            if (this.m_bCanOpenJob) {
                cStepTreeNode.showProcessView(this.m_sJobName, this.m_sJobType, this.m_sJobFQID, this.m_oTS);
            } else {
                super.onProperties();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void showProcessView(String sName, String sType, String sFQID, TransformationStep oTS) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            try {
                SimpleObjectImpl simpleJob = new SimpleObjectImpl(sName, sFQID, sType, "Job");
                AppViewFactory.getInstance().showOpenView((SimpleObject)simpleJob);
            }
            finally {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        protected class cViewJobAction
        extends WsAbstractAction {
            public cViewJobAction() {
                super(bundle, "ImpactAnalysisReportTab.ViewJob");
                this.setMenuSupportId("viewjob");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent e) {
                cStepTreeNode.showProcessView(cStepTreeNode.this.m_sJobName, cStepTreeNode.this.m_sJobType, cStepTreeNode.this.m_sJobFQID, null);
            }
        }
    }

    protected static class cInformationMapTreeNode
    extends cTreeNode {
        private Transformation m_Transformation;

        public cInformationMapTreeNode(Transformation oTransformation) {
            super((Root)oTransformation);
            this.m_Transformation = oTransformation;
            try {
                this.m_icon = ImpactAnalysisUtilities.getCubeTypeIcon(oTransformation.getTransformRole());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.m_actProperties.setEnabled(true);
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, (CMetadata)this.m_Transformation);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    protected static class cInvalidValuesLookupTreeNode
    extends cColumnTreeNode {
        public cInvalidValuesLookupTreeNode(Column oColumn) {
            super(oColumn);
            try {
                this.m_icon = WsColumnMetadataUtil.getColumnTypeIcon((Column)oColumn);
                this.m_sColumn = oColumn.getSASColumnName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        public void setTable(DataTable oTable) {
            if (this.m_oTable == oTable) {
                return;
            }
            this.m_oTable = oTable;
            try {
                this.m_sName = bundle.formatString("ImpactAnalysisReportTab.InvalidValuesLookupTreeNodeName.fmt.txt", (Object)oTable.getName(), (Object)this.m_sColumn);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, (CMetadata)this.m_oTable);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    protected static class cCubeFeatureTreeNode
    extends cTreeNode {
        private Cube m_oCube;
        private String m_sFeatureName;
        private Feature m_oFeature;

        public cCubeFeatureTreeNode(Feature oFeature) {
            super((Root)oFeature);
            try {
                this.m_oFeature = oFeature;
                this.m_sFeatureName = oFeature.getName();
                this.m_sType = oFeature.getCMetadataType();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void setCube(Cube oCube) {
            if (this.m_oCube == oCube) {
                return;
            }
            try {
                this.m_oCube = oCube;
                this.m_sName = bundle.formatString("ImpactAnalysisUtilities.CubeFeatureNodeName.fmt.txt", (Object)this.m_oCube.getName(), (Object)this.m_sFeatureName, (Object)this.getType());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, (CMetadata)this.m_oCube);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    protected static class cColumnTreeNode
    extends cTreeNode {
        protected DataTable m_oTable;
        protected String m_sColumn;

        public cColumnTreeNode(Column oColumn) {
            super((Root)oColumn);
            this.m_icon = WsColumnMetadataUtil.getColumnTypeIcon((Column)oColumn);
            try {
                this.m_sColumn = oColumn.getSASColumnName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void setTable(DataTable oTable) {
            if (this.m_oTable == oTable) {
                return;
            }
            try {
                this.m_oTable = oTable;
                StringBuffer sb = new StringBuffer(60);
                sb.append(oTable.getName());
                sb.append(".");
                sb.append(this.m_sColumn);
                this.m_sName = sb.toString();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, (CMetadata)this.m_oTable);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    protected static class cTransformTreeNode
    extends cTreeNode {
        private Prototype m_oTransformPrototype;

        public cTransformTreeNode(Prototype oTransformPrototype) {
            super((Root)oTransformPrototype);
            this.m_oTransformPrototype = oTransformPrototype;
            this.setIcon(bundle.getImageIcon("SASUserExit.StepOut.image"));
        }

        @Override
        protected Root createPropertiesObject(MdObjectStore store) throws MdException {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                Root object = (Root)factory.createComplexMetadataObject(store, (CMetadata)this.m_oTransformPrototype);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)object, null, null, null, 8);
                return object;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    protected static class cTableTreeNode
    extends cTreeNode {
        protected WsAbstractAction m_actViewData;
        protected WsAbstractAction m_actViewFile;
        protected WsAbstractAction m_actColumnImpact;
        Classifier m_oTable;

        public cTableTreeNode(Classifier oTable) {
            super((Root)oTable);
            this.m_oTable = oTable;
            try {
                String sType = this.m_oTable.getCMetadataType();
                this.m_actViewData.setEnabled(sType.equals("PhysicalTable") || sType.equals("ExternalTable") || sType.equals("WorkTable"));
                this.m_actViewFile.setEnabled(sType.equals("ExternalTable"));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        protected void createActions() {
            super.createActions();
            this.m_actViewData = new cViewDataAction();
            this.m_actViewFile = new cViewFileAction();
            this.m_actColumnImpact = new cColumnImpactAction();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            this.m_actViewData.setActive(bActive);
            this.m_actViewFile.setActive(bActive);
            this.m_actColumnImpact.setActive(bActive);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
            super.addPopupMenuItems(mnuPopup);
            try {
                if (this.m_oTable.getCMetadataType().equals("PhysicalTable") || this.m_oTable.getCMetadataType().equals("ExternalTable") || this.m_oTable.getCMetadataType().equals("WorkTable")) {
                    mnuPopup.addSeparator();
                    mnuPopup.add((Action)this.m_actColumnImpact);
                    mnuPopup.addSeparator();
                    mnuPopup.add((Action)this.m_actViewData);
                }
                if (this.m_oTable.getCMetadataType().equals("ExternalTable")) {
                    mnuPopup.add((Action)this.m_actViewFile);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public class ColumnComparator
        implements Comparator {
            private boolean m_bCaseSensitive = false;

            public int compare(Object first, Object second) {
                if (!(first instanceof Column) || !(second instanceof Column)) {
                    throw new IllegalArgumentException();
                }
                Column node1 = (Column)first;
                Column node2 = (Column)second;
                try {
                    return node1.getName().compareToIgnoreCase(node2.getName());
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    return 0;
                }
            }
        }

        protected class cColumnImpactAction
        extends WsAbstractAction {
            private DualListSelector m_dlsSelectColumns;
            private CollectionToListModelAdapter m_adpAvailableColumns;
            private CollectionToListModelAdapter m_adpSelectedColumns;
            private WAPropertyTab m_panAdditionalColumns;

            public cColumnImpactAction() {
                super(bundle, "ImpactPFDPanel.Column");
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!(cTableTreeNode.this.m_oTable instanceof DataTable)) {
                        return;
                    }
                    DataTable table = (DataTable)cTableTreeNode.this.m_oTable;
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ImpactPFDPanel.ColumnImpactDialog.Title.txt"), true);
                    dlg.setHelpButtonVisible(false);
                    dlg.setResizable(true);
                    this.createImpactColumnsPanel(table);
                    dlg.setMainPanel((WAPanel)this.m_panAdditionalColumns);
                    dlg.setPreferredSize(new Dimension(400, 400));
                    dlg.show();
                    if (dlg.getReturnValue() == 1 && this.m_adpSelectedColumns.getSize() > 0) {
                        Column selectedColumn = (Column)this.m_adpSelectedColumns.getElementAt(0);
                        SimpleObjectImpl simpleObj = new SimpleObjectImpl(selectedColumn.getName(), selectedColumn.getFQID(), selectedColumn.getCMetadataType(), selectedColumn.getPublicType());
                        AppViewFactory.getInstance().showAnalysisView((SimpleObject)simpleObj);
                    }
                    dlg.dispose();
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                catch (MdException e1) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Reading");
                }
            }

            private void createImpactColumnsPanel(DataTable table) throws MdException, RemoteException {
                AssociationList columns = table.getColumns();
                ArrayList availableColumns = new ArrayList(columns);
                Collections.sort(availableColumns, new ColumnComparator());
                ArrayList selectedColumns = new ArrayList();
                this.m_dlsSelectColumns = new DualListSelector();
                this.m_adpAvailableColumns = new CollectionToListModelAdapter();
                this.m_adpSelectedColumns = new CollectionToListModelAdapter();
                this.m_adpSelectedColumns.addListDataListener((ListDataListener)new DualListener());
                this.m_dlsSelectColumns.setTargetMaximumCount(1);
                this.m_dlsSelectColumns.setSourceLabel(bundle.getString("ImpactPFDPanel.source.txt"));
                this.m_dlsSelectColumns.getSourceComponent().setToolTipText(bundle.getString("ImpactPFDPanel.AvailableColumns.ToolTip.txt"));
                ((JLabel)this.m_dlsSelectColumns.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("ImpactPFDPanel.AvailableColumns.mnem").charAt(0));
                this.m_dlsSelectColumns.setTargetLabel(bundle.getString("ImpactPFDPanel.SelectedColumns.txt"));
                this.m_dlsSelectColumns.getTargetComponent().setToolTipText(bundle.getString("ImpactPFDPanel.SelectedColumns.ToolTip.txt"));
                ((JLabel)this.m_dlsSelectColumns.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("ImpactPFDPanel.SelectedColumns.mnem").charAt(0));
                this.m_panAdditionalColumns = new WAPropertyTab();
                this.m_panAdditionalColumns.setLayout((LayoutManager)new GridBagLayout());
                this.m_dlsSelectColumns.setModel((ListModel)this.m_adpAvailableColumns);
                this.m_dlsSelectColumns.setTargetModel((ListModel)this.m_adpSelectedColumns);
                this.m_dlsSelectColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
                this.m_dlsSelectColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
                this.m_adpAvailableColumns.setModel(availableColumns);
                this.m_adpSelectedColumns.setModel(selectedColumns);
                this.m_panAdditionalColumns.add((Component)this.m_dlsSelectColumns, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            }

            private class cListCellRenderer
            extends DefaultListCellRenderer {
                private cListCellRenderer() {
                }

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    try {
                        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        WsCompoundIcon iconCompound = new WsCompoundIcon();
                        iconCompound.setIconGap(1);
                        String sType = WsColumnMetadataUtil.convertColumnTypeToView((String)((Column)value).getSASColumnType());
                        iconCompound.addIcon(WsColumnMetadataUtil.getColumnViewTypeIcon((String)sType));
                        if (iconCompound.getIconCount() == 0) {
                            this.setIcon(null);
                        } else {
                            this.setIcon((Icon)iconCompound);
                        }
                        return this;
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                        return null;
                    }
                }
            }

            private class DualListener
            implements ListDataListener {
                private DualListener() {
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            }
        }

        protected class cViewFileAction
        extends WsAbstractAction {
            public cViewFileAction() {
                super(bundle, "Tree.PopupMenu.ViewRawData");
                this.setMenuSupportId("viewfile");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent e) {
                WsViewFactory.showView((CMetadata)cTableTreeNode.this.m_oTable, RawDataView.class);
            }
        }

        protected class cViewDataAction
        extends WsAbstractAction {
            public cViewDataAction() {
                super(bundle, "Tree.PopupMenu.ViewData");
                this.setMenuSupportId("viewdata");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent e) {
                WsViewFactory.showView((CMetadata)cTableTreeNode.this.m_oTable, ViewDataView.class);
            }
        }
    }

    protected static class cJobTreeNode
    extends cTreeNode {
        protected WsAbstractAction m_actViewJob;
        private boolean m_bCanOpenJob;

        public cJobTreeNode(Job oJob) {
            super((Root)oJob);
            try {
                SimpleObjectImpl simpleJob = new SimpleObjectImpl(oJob.getName(), oJob.getFQID(), oJob.getCMetadataType(), oJob.getPublicType());
                this.m_bCanOpenJob = AppViewFactory.getInstance().isOpenViewSupported((SimpleObject)simpleJob);
                this.m_actViewJob.setEnabled(this.m_bCanOpenJob);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        @Override
        protected void createActions() {
            super.createActions();
            this.m_actViewJob = new cViewJobAction();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            this.m_actViewJob.setActive(bActive & this.m_bCanOpenJob);
        }

        @Override
        public void addPopupMenuItems(JPopupMenu mnuPopup) {
            mnuPopup.add((Action)this.m_actProperties);
            mnuPopup.add((Action)this.m_actViewJob);
        }

        protected class cViewJobAction
        extends WsAbstractAction {
            public cViewJobAction() {
                super(bundle, "ImpactAnalysisReportTab.ViewJob");
                this.setMenuSupportId("viewjob");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent e) {
                ImpactAnalysisReportTab.showProcessView(cJobTreeNode.this.getName(), cJobTreeNode.this.getType(), cJobTreeNode.this.getFQID());
            }
        }
    }

    public static abstract class cTreeModel
    extends DefaultTreeModel {
        protected boolean m_bForward;

        public cTreeModel(cTreeNode nodeRoot, boolean bForward) {
            super((TreeNode)((Object)nodeRoot));
            this.m_bForward = bForward;
        }

        public abstract void populateStore() throws MdException, RemoteException;

        public abstract void moveDataToModel() throws MdException, RemoteException;

        protected List getNextSteps(TransformationStep oTS) throws MdException, RemoteException {
            ArrayList lTSs = new ArrayList();
            List lSPs = this.getStepPrecedences(oTS);
            for (int iSP = 0; iSP < lSPs.size(); ++iSP) {
                StepPrecedence oSP = (StepPrecedence)lSPs.get(iSP);
                lTSs.addAll(this.getTransformationSteps(oSP));
            }
            return lTSs;
        }

        protected List getClassifierMaps(Classifier oTable) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oTable.getSourceClassifierMaps();
            }
            return oTable.getTargetClassifierMaps();
        }

        protected List getFeatureMaps(Column oColumn) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oColumn.getSourceFeatureMaps();
            }
            return oColumn.getTargetFeatureMaps();
        }

        protected List getStepPrecedences(TransformationStep oTS) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oTS.getPredecessorDependencies();
            }
            return oTS.getSuccessorDependencies();
        }

        protected List getTransformationSteps(StepPrecedence oSP) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oSP.getSuccessors();
            }
            return oSP.getPredecessors();
        }

        protected List getTables(ClassifierMap oCM) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oCM.getClassifierTargets();
            }
            return oCM.getClassifierSources();
        }

        protected List getColumns(FeatureMap oFM) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oFM.getFeatureTargets();
            }
            return oFM.getFeatureSources();
        }

        protected cTreeNode find(Root oObject) {
            return this.find((cTreeNode)((Object)this.getRoot()), oObject);
        }

        protected cTreeNode find(cTreeNode node, Root oObject) {
            try {
                if (oObject.getFQID().equals(node.getFQID())) {
                    return node;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                cTreeNode nodeChild = (cTreeNode)((Object)node.getChildAt(iChild));
                cTreeNode nodeFound = this.find(nodeChild, oObject);
                if (nodeFound == null) continue;
                return nodeFound;
            }
            return null;
        }

        protected void addChild(MutableTreeNode nodeChild, MutableTreeNode nodeParent) {
            this.insertNodeInto(nodeChild, nodeParent, nodeParent.getChildCount());
        }

        protected void removeAllChildrenFromParent(MutableTreeNode nodeParent) {
            while (nodeParent.getChildCount() > 0) {
                this.removeNodeFromParent((MutableTreeNode)nodeParent.getChildAt(0));
            }
        }

        protected static boolean getUseDependentReposFlag() {
            return true;
        }
    }

    public static class cTransformTreeModel
    extends cTreeModel {
        private Prototype m_oTransformPrototype;
        private boolean m_bDataMovedToModel;

        public cTransformTreeModel(Prototype oTransformPrototype, TransformInterface oTransform, boolean bForward) {
            this(oTransformPrototype);
        }

        public cTransformTreeModel(Prototype oTransformPrototype) {
            super(new cTransformTreeNode(oTransformPrototype), true);
            this.m_oTransformPrototype = oTransformPrototype;
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            if (this.m_bDataMovedToModel) {
                return;
            }
            cTreeNode nodeRoot = (cTreeNode)((Object)this.getRoot());
            this.removeAllChildrenFromParent((MutableTreeNode)((Object)nodeRoot));
            List lSteps = this.getNextSteps();
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeRoot, nodeRoot, (TransformationStep)lSteps.get(iStep), null);
            }
            this.m_bDataMovedToModel = true;
            int numChildren = nodeRoot.getChildCount();
            if (numChildren == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpactTransformation.txt"));
            }
        }

        private void addStepNode(cTreeNode nodeParent, cTreeNode nodeTable, TransformationStep step, Job oJob) throws MdException, RemoteException {
            Job oStepJob = ImpactAnalysisReportTab.getJobFor(step);
            if (oStepJob == null) {
                return;
            }
            if (oStepJob != oJob) {
                if (nodeTable == null) {
                    Workspace.getDefaultLogger().error((Object)"nodeTable == null when switching jobs");
                    nodeTable = nodeParent;
                }
                nodeParent = new cJobTreeNode(oStepJob);
                this.addChild((MutableTreeNode)((Object)nodeParent), (MutableTreeNode)((Object)nodeTable));
            }
            cTreeNode nodePrevious = this.find((Root)step);
            cStepTreeNode nodeStep = new cStepTreeNode(step);
            this.addChild((MutableTreeNode)((Object)nodeStep), (MutableTreeNode)((Object)nodeParent));
            if (nodePrevious != null) {
                nodeStep.setFirstInstance(nodePrevious);
                return;
            }
        }

        private List getNextSteps() throws MdException, RemoteException {
            String strGUID = MacroPluginUtilities.getGuid(this.m_oTransformPrototype);
            return ImpactAnalysisUtilities.getTransforms((CMetadata)this.m_oTransformPrototype, strGUID);
        }
    }

    public static class cColumnTreeModel
    extends cTreeModel {
        private Column m_oColumn;
        private boolean m_bDataMovedToModel;

        public cColumnTreeModel(Column oColumn, boolean bForward) {
            super(new cColumnTreeNode(oColumn), bForward);
            this.m_oColumn = oColumn;
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(this.m_oColumn);
        }

        private void populateStore(Column oColumn) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                lAssociations.add("SourceFeatureMaps");
                lAssociations.add("Table");
                sbTemplate.append("<Column><Table/></Column>");
                sbTemplate.append("<FeatureMap><FeatureTargets/><AssociatedClassifierMap/></FeatureMap>");
                sbTemplate.append("<Select><Steps/><SourceTransformations/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><SourceTransformations/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Properties/></TransformationStep>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TargetFeatureMaps");
                lAssociations.add("Table");
                sbTemplate.append("<Column><Table/></Column>");
                sbTemplate.append("<FeatureMap><FeatureSources/><FeatureTargets/><AssociatedClassifierMap/></FeatureMap>");
                sbTemplate.append("<Select><Steps/><SourceTransformations/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><SourceTransformations/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Properties/></TransformationStep>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cColumnTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oColumn, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        public void populateStoreForBILineage(CMetadata oMeta) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                if (oMeta instanceof Feature) {
                    lAssociations.add("SourceFeatureMaps");
                }
                if (oMeta instanceof Group) {
                    lAssociations.add("SourceTransformations");
                }
            } else {
                if (oMeta instanceof Feature) {
                    lAssociations.add("TargetFeatureMaps");
                }
                if (oMeta instanceof Group) {
                    lAssociations.add("TargetTransformations");
                }
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cColumnTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oMeta, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            int numChildren;
            if (this.m_bDataMovedToModel) {
                return;
            }
            cColumnTreeNode nodeRoot = (cColumnTreeNode)((Object)this.getRoot());
            nodeRoot.setTable(this.m_oColumn.getTable());
            this.nodeChanged((TreeNode)((Object)nodeRoot));
            this.removeAllChildrenFromParent((MutableTreeNode)((Object)nodeRoot));
            cStepList lSteps = this.getNextSteps(this.m_oColumn);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeRoot, nodeRoot, lSteps.getStep(iStep), null, this.m_oColumn);
            }
            if (!this.m_bForward) {
                int numChildren2 = nodeRoot.getChildCount();
                if (numChildren2 == 0) {
                    MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpactReverseColumn.txt"));
                }
                return;
            }
            List lookupList = ImpactAnalysisUtilities.getWhereColumnUsedAsLookup(this.m_oColumn);
            HashMap<Job, cJobTreeNode> jobNodes = new HashMap<Job, cJobTreeNode>();
            for (int iJob = 0; iJob < lookupList.size(); ++iJob) {
                List lookupLocations = (List)lookupList.get(iJob);
                Job lookupJob = (Job)lookupLocations.get(0);
                cJobTreeNode jobNode = (cJobTreeNode)((Object)jobNodes.get(lookupJob));
                if (jobNode == null) {
                    jobNode = new cJobTreeNode(lookupJob);
                    jobNodes.put(lookupJob, jobNode);
                    this.addChild((MutableTreeNode)((Object)jobNode), (MutableTreeNode)((Object)nodeRoot));
                }
                TransformationStep oTS = (TransformationStep)lookupLocations.get(1);
                String tsName = ((ClassifierMap)oTS.getTransformations().get(0)).getName();
                String columnName = ((Column)lookupLocations.get(2)).getName();
                String nodeName = bundle.formatString("ImpactAnalysisReportTab.InvalidValuesNodeName.fmt.txt", (Object)tsName, (Object)columnName);
                cStepTreeNode tsStep = new cStepTreeNode(oTS, nodeName);
                this.addChild((MutableTreeNode)((Object)tsStep), (MutableTreeNode)((Object)jobNode));
            }
            if (m_bDoesBIReposExist) {
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + this.m_oColumn.getTable().getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)this.m_oColumn.getObjectStore()), m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0) {
                    Property thisProp = (Property)objects.get(objects.size() - 1);
                    Group assocObj = (Group)thisProp.getAssociatedObject();
                    AssociationList l_members = assocObj.getMembers();
                    Feature oProxyColumn = null;
                    for (int i = 0; i < l_members.size(); ++i) {
                        Feature oPossibleColumn = (Feature)l_members.get(i);
                        if (!oPossibleColumn.getName().equals(this.m_oColumn.getName())) continue;
                        oProxyColumn = oPossibleColumn;
                        break;
                    }
                    if (oProxyColumn != null) {
                        this.processFeature(oProxyColumn, nodeRoot);
                    }
                }
            }
            if ((numChildren = nodeRoot.getChildCount()) == 0) {
                if (this.m_bForward) {
                    MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpactColumn.txt"));
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpactReverseColumn.txt"));
                }
            }
        }

        private void addStepNode(cTreeNode nodeParent, cTreeNode nodeTable, cStep step, Job oJob, Column oColumn) throws MdException, RemoteException {
            List lFMs;
            TransformationStep oTS = step.getStep();
            Job oStepJob = ImpactAnalysisReportTab.getJobFor(oTS);
            if (oStepJob == null) {
                return;
            }
            if (oStepJob != oJob) {
                if (nodeTable == null) {
                    Workspace.getDefaultLogger().error((Object)"nodeTable == null when switching jobs");
                    nodeTable = nodeParent;
                }
                nodeParent = new cJobTreeNode(oStepJob);
                this.addChild((MutableTreeNode)((Object)nodeParent), (MutableTreeNode)((Object)nodeTable));
            }
            if ((lFMs = step.getMaps()).size() > 1) {
                for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
                    String sKey = "ImpactAnalysisReportTab.ColumnBranch.fmt.txt";
                    String sBranch = bundle.formatString(sKey, (Object)new Integer(iFM + 1));
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(sBranch);
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeParent));
                    this.addFeatureNode(nodeBranch, (FeatureMap)lFMs.get(iFM), oStepJob, oColumn);
                }
            } else if (lFMs.size() == 1) {
                this.addFeatureNode(nodeParent, (FeatureMap)lFMs.get(0), oStepJob, oColumn);
            }
        }

        private void addFeatureNode(cTreeNode nodeParent, FeatureMap oFM, Job oJob, Column oColumn) throws MdException, RemoteException {
            List lColumns;
            cTreeNode nodePrevious = this.find((Root)oFM);
            cStepTreeNode nodeStep = new cStepTreeNode(oFM, oColumn);
            this.addChild((MutableTreeNode)((Object)nodeStep), (MutableTreeNode)((Object)nodeParent));
            if (nodePrevious != null) {
                nodeStep.setFirstInstance(nodePrevious);
                return;
            }
            ClassifierMap oCM = oFM.getAssociatedClassifierMap();
            if (oCM != null && oCM.getTransformRole().equalsIgnoreCase("VALIDATE")) {
                AssociationList workColumnsList = oFM.getFeatureTargets();
                for (int iColumn = 0; iColumn < workColumnsList.size(); ++iColumn) {
                    Column workColumn = (Column)workColumnsList.get(iColumn);
                    List validationsList = ImpactAnalysisUtilities.getInvalidValuesValidation(workColumn);
                    for (int iValidationColumn = 0; iValidationColumn < validationsList.size(); ++iValidationColumn) {
                        Column lookupColumn = (Column)validationsList.get(iValidationColumn);
                        cInvalidValuesLookupTreeNode invalidValuesNode = new cInvalidValuesLookupTreeNode(lookupColumn);
                        invalidValuesNode.setTable(lookupColumn.getTable());
                        this.addChild((MutableTreeNode)((Object)invalidValuesNode), (MutableTreeNode)((Object)nodeStep));
                    }
                }
            }
            if ((lColumns = this.getColumns(oFM)).size() > 1) {
                String sKey = "ImpactAnalysisReportTab.ColumnBranch.fmt.txt";
                for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                    String sBranch = bundle.formatString(sKey, (Object)new Integer(iColumn + 1));
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(sBranch);
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeParent));
                    if (((CMetadata)lColumns.get(0)).getCMetadataType().equals("Column")) {
                        this.addColumnNode(nodeBranch, (Column)lColumns.get(iColumn), oJob);
                        continue;
                    }
                    this.addCubeFeatureNode(nodeBranch, (Feature)lColumns.get(0));
                }
            } else if (lColumns.size() == 1) {
                if (((CMetadata)lColumns.get(0)).getCMetadataType().equals("Column")) {
                    this.addColumnNode(nodeParent, (Column)lColumns.get(0), oJob);
                } else {
                    this.addCubeFeatureNode(nodeParent, (Feature)lColumns.get(0));
                }
            }
        }

        private void addColumnNode(cTreeNode nodeParent, Column oColumn, Job oJob) throws MdException, RemoteException {
            cColumnTreeNode nodeColumn = null;
            if (this.isPhysicalTableColumn(oColumn) || this.isExternalTableColumn(oColumn)) {
                cTreeNode nodePrev = this.find((Root)oColumn);
                nodeColumn = new cColumnTreeNode(oColumn);
                nodeColumn.setTable(oColumn.getTable());
                this.addChild((MutableTreeNode)((Object)nodeColumn), (MutableTreeNode)((Object)nodeParent));
                if (nodePrev != null) {
                    nodeColumn.setFirstInstance(nodePrev);
                    return;
                }
            }
            this.populateStore(oColumn);
            cStepList lSteps = this.getNextSteps(oColumn);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeParent, nodeColumn, lSteps.getStep(iStep), oJob, oColumn);
            }
            if (m_bDoesBIReposExist) {
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + oColumn.getTable().getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)oColumn.getObjectStore()), m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0) {
                    Property thisProp = (Property)objects.get(objects.size() - 1);
                    Group assocObj = (Group)thisProp.getAssociatedObject();
                    AssociationList l_members = assocObj.getMembers();
                    Feature oProxyColumn = null;
                    for (int i = 0; i < l_members.size(); ++i) {
                        Feature oPossibleColumn = (Feature)l_members.get(i);
                        if (!oPossibleColumn.getName().equals(oColumn.getName())) continue;
                        oProxyColumn = oPossibleColumn;
                        break;
                    }
                    if (oProxyColumn != null) {
                        this.processFeature(oProxyColumn, nodeColumn);
                    }
                }
            }
        }

        private void addCubeFeatureNode(cTreeNode nodeParent, Feature oFeature) throws MdException, RemoteException {
            Cube oCube = null;
            List lCubes = ImpactAnalysisUtilities.getCubesForFeature(oFeature);
            for (int iCube = 0; iCube < lCubes.size(); ++iCube) {
                oCube = (Cube)lCubes.get(iCube);
                cTreeNode nodePrev = this.find((Root)oFeature);
                cCubeFeatureTreeNode nodeColumn = new cCubeFeatureTreeNode(oFeature);
                nodeColumn.setCube(oCube);
                this.addChild((MutableTreeNode)((Object)nodeColumn), (MutableTreeNode)((Object)nodeParent));
                if (nodePrev == null) continue;
                nodeColumn.setFirstInstance(nodePrev);
                return;
            }
        }

        private cStepList getNextSteps(Column oColumn) throws MdException, RemoteException {
            cStepList lSteps = new cStepList();
            List lFMs = this.getFeatureMaps(oColumn);
            for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
                FeatureMap oFM = (FeatureMap)lFMs.get(iFM);
                TransformationStep oTS = ImpactAnalysisReportTab.getStepFor(oFM);
                if (oTS == null) continue;
                lSteps.add(oTS, (AbstractTransformation)oFM);
            }
            return lSteps;
        }

        private boolean isPhysicalTableColumn(Column oColumn) throws MdException, RemoteException {
            return oColumn.getTable().getCMetadataType().equals("PhysicalTable");
        }

        private boolean isExternalTableColumn(Column oColumn) throws MdException, RemoteException {
            return oColumn.getTable().getCMetadataType().equals("ExternalTable");
        }

        protected void processFeature(Feature oFeature, cTreeNode nodePrevious) throws MdException, RemoteException {
            this.populateStoreForBILineage((CMetadata)oFeature);
            if (this.m_bForward) {
                AssociationList l_SFMs = oFeature.getSourceFeatureMaps();
                for (int i = 0; i < l_SFMs.size(); ++i) {
                    FeatureMap i_FM = (FeatureMap)l_SFMs.get(i);
                    AssociationList l_FTs = i_FM.getFeatureTargets();
                    for (int j = 0; j < l_FTs.size(); ++j) {
                        this.addBIFeatureNode(nodePrevious, (Feature)l_FTs.get(j));
                    }
                }
            } else {
                AssociationList l_SFMs = oFeature.getTargetFeatureMaps();
                for (int i = 0; i < l_SFMs.size(); ++i) {
                    FeatureMap i_FM = (FeatureMap)l_SFMs.get(i);
                    AssociationList l_FTs = i_FM.getFeatureSources();
                    for (int j = 0; j < l_FTs.size(); ++j) {
                        this.addBIFeatureNode(nodePrevious, (Feature)l_FTs.get(j));
                    }
                }
            }
        }

        protected void addBIFeatureNode(cTreeNode nodeParent, Feature oFeature) throws MdException, RemoteException {
            cFeatureTreeNode nodeGroup = null;
            cTreeNode nodePrev = this.find((Root)oFeature);
            nodeGroup = new cFeatureTreeNode(oFeature);
            this.addChild((MutableTreeNode)((Object)nodeGroup), (MutableTreeNode)((Object)nodeParent));
            if (nodePrev != null) {
                nodeGroup.setFirstInstance(nodePrev);
                return;
            }
            this.processFeature(oFeature, nodeGroup);
        }
    }

    protected static class cTableTreeModel
    extends cTreeModel {
        private Classifier m_oTable;
        private boolean m_bDataMovedToModel;

        public cTableTreeModel(Classifier oTable, boolean bForward) {
            super(new cTableTreeNode(oTable), bForward);
            this.m_oTable = oTable;
        }

        @Override
        public void populateStore() throws MdException, RemoteException {
            this.populateStore(this.m_oTable);
        }

        private void populateStore(Classifier oTable) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                lAssociations.add("SourceClassifierMaps");
                lAssociations.add("SourceTransformations");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/><TriggeredEvents/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TargetClassifierMaps");
                lAssociations.add("TargetTransformations");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cTableTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oTable, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        private void populateStore(Transformation oTrans) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                lAssociations.add("TransformationTargets");
                sbTemplate.append("<Select><Steps/><ClassifierTargets/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierTargets/><TriggeredEvents/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><PredecessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Successors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            } else {
                lAssociations.add("TransformationSources");
                sbTemplate.append("<Select><Steps/><ClassifierSources/></Select>");
                sbTemplate.append("<ClassifierMap><Steps/><ClassifierSources/></ClassifierMap>");
                sbTemplate.append("<TransformationStep><Activities/><Transformations/><SuccessorDependencies/></TransformationStep>");
                sbTemplate.append("<StepPrecedence><Predecessors/></StepPrecedence>");
                sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cTableTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oTrans, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        public void populateStoreForBILineage(CMetadata oMeta) throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>();
            StringBuffer sbTemplate = new StringBuffer(100);
            sbTemplate.append("<Templates>");
            if (this.m_bForward) {
                if (oMeta instanceof Feature) {
                    lAssociations.add("SourceFeatureMaps");
                }
                if (oMeta instanceof Group) {
                    lAssociations.add("SourceTransformations");
                }
            } else {
                if (oMeta instanceof Feature) {
                    lAssociations.add("TargetFeatureMaps");
                }
                if (oMeta instanceof Group) {
                    lAssociations.add("TargetTransformations");
                }
            }
            sbTemplate.append("</Templates>");
            int fFlags = 268;
            if (cTableTreeModel.getUseDependentReposFlag()) {
                fFlags = fFlags | 0x4000 | 0x2000;
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oMeta, null, lAssociations, sbTemplate.toString(), fFlags);
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            if (this.m_bDataMovedToModel) {
                return;
            }
            cTreeNode nodeRoot = (cTreeNode)((Object)this.getRoot());
            this.removeAllChildrenFromParent((MutableTreeNode)((Object)nodeRoot));
            cStepList lSteps = this.getNextSteps(this.m_oTable);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeRoot, nodeRoot, lSteps.getStep(iStep), null);
            }
            AssociationList lSourceTrans = this.m_oTable.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                this.addInformationMap((Transformation)lSourceTrans.get(i), nodeRoot);
            }
            if (m_bDoesBIReposExist) {
                Property thisProp;
                Group assocObj;
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + this.m_oTable.getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)this.m_oTable.getObjectStore()), m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0 && (assocObj = (Group)(thisProp = (Property)objects.get(objects.size() - 1)).getAssociatedObject()) != null) {
                    this.processGroup(assocObj, nodeRoot);
                }
            }
            this.m_bDataMovedToModel = true;
            int numChildren = nodeRoot.getChildCount();
            if (numChildren == 0) {
                if (this.m_bForward) {
                    MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpact.txt"));
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("ImpactAnalysisReportTab.NoImpactReverse.txt"));
                }
            }
        }

        private void addStepNode(cTreeNode nodeParent, cTreeNode nodeTable, cStep step, Job oJob) throws MdException, RemoteException {
            AssociationList lTrans;
            Job oStepJob = ImpactAnalysisReportTab.getJobFor(step.getStep());
            if (oStepJob == null) {
                return;
            }
            boolean isCube = oStepJob.getPublicType().equals("Job.CubeBuild");
            if (oStepJob != oJob) {
                if (nodeTable == null) {
                    Workspace.getDefaultLogger().error((Object)"nodeTable == null when switching jobs");
                    nodeTable = nodeParent;
                }
                nodeParent = new cJobTreeNode(oStepJob);
                this.addChild((MutableTreeNode)((Object)nodeParent), (MutableTreeNode)((Object)nodeTable));
            }
            cTreeNode nodePrevious = this.find((Root)step.getStep());
            cStepTreeNode nodeStep = new cStepTreeNode(step.getStep());
            this.addChild((MutableTreeNode)((Object)nodeStep), (MutableTreeNode)((Object)nodeParent));
            if (nodePrevious != null) {
                nodeStep.setFirstInstance(nodePrevious);
                return;
            }
            List lTables = this.getNextTables(step.getMaps());
            if (lTables.size() > 1) {
                for (int iTable = 0; iTable < lTables.size(); ++iTable) {
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(bundle.formatString("ImpactAnalysisReportTab.TableBranch.fmt.txt", (Object)new Integer(iTable + 1)));
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeStep));
                    this.addTableNode(nodeBranch, (Classifier)lTables.get(iTable), oStepJob);
                }
            } else if (lTables.size() == 1) {
                this.addTableNode(nodeParent, (Classifier)lTables.get(0), oStepJob);
            }
            if (isCube && !this.m_bForward) {
                AssociationList lTargetTrans = this.m_oTable.getTargetTransformations();
                int size = lTargetTrans.size();
                for (int iTT = 0; iTT < size; ++iTT) {
                    ClassifierMap cm = (ClassifierMap)lTargetTrans.get(iTT);
                    AssociationList tables = cm.getTransformationSources();
                    int numTables = tables.size();
                    for (int iTable = 0; iTable < numTables; ++iTable) {
                        this.addTableNode(nodeParent, (Classifier)tables.get(iTable), oStepJob);
                    }
                }
            }
            if ((lTrans = this.m_bForward ? step.getStep().getSourceTransformations() : step.getStep().getTargetTransformations()).size() > 1) {
                for (int iTrans = 0; iTrans < lTrans.size(); ++iTrans) {
                    cBranchTreeNode nodeBranch = new cBranchTreeNode(bundle.formatString("ImpactAnalysisReportTab.TableBranch.fmt.txt", (Object)new Integer(iTrans + 1)));
                    this.addChild((MutableTreeNode)((Object)nodeBranch), (MutableTreeNode)((Object)nodeStep));
                    this.addTransformationNode(nodeBranch, (Transformation)lTrans.get(iTrans), oStepJob);
                }
            } else if (lTrans.size() == 1) {
                this.addTransformationNode(nodeParent, (Transformation)lTrans.get(0), oStepJob);
            }
        }

        private void addTableNode(cTreeNode nodeParent, Classifier oTable, Job oJob) throws MdException, RemoteException {
            cTableTreeNode nodeTable = null;
            if (oTable.getCMetadataType().equals("PhysicalTable") || oTable.getCMetadataType().equals("ExternalTable") || oTable.getCMetadataType().equals("Cube")) {
                cTreeNode nodePrev = this.find((Root)oTable);
                nodeTable = new cTableTreeNode(oTable);
                this.addChild((MutableTreeNode)((Object)nodeTable), (MutableTreeNode)((Object)nodeParent));
                if (nodePrev != null) {
                    nodeTable.setFirstInstance(nodePrev);
                    return;
                }
                this.populateStore(oTable);
            }
            if (!oTable.getCMetadataType().equals("Cube")) {
                cStepList lSteps = this.getNextSteps(oTable);
                for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                    this.addStepNode(nodeParent, nodeTable, lSteps.getStep(iStep), oJob);
                }
            }
            AssociationList lSourceTrans = oTable.getSourceTransformations();
            for (int i = 0; i < lSourceTrans.size(); ++i) {
                Transformation trans = (Transformation)lSourceTrans.get(i);
                if (trans.getTransformRole().equals("STARDIM") || trans.getTransformRole().equals("AGGREGATE")) continue;
                this.addInformationMap((Transformation)lSourceTrans.get(i), nodeTable);
            }
            if (m_bDoesBIReposExist) {
                Property thisProp;
                Group assocObj;
                String tempString = "<XMLSelect search=\"*[@Name='ActualObject' and @Desc='" + oTable.getFQID() + "']\"/>";
                List objects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((MdObjectStore)oTable.getObjectStore()), m_BIReposID, "Property", 8587, tempString);
                if (objects.size() > 0 && (assocObj = (Group)(thisProp = (Property)objects.get(objects.size() - 1)).getAssociatedObject()) != null) {
                    this.processGroup(assocObj, nodeTable);
                }
            }
        }

        private void addTransformationNode(cTreeNode nodeParent, Transformation oTrans, Job oJob) throws MdException, RemoteException {
            cTransformationTreeNode nodeTable = null;
            cTreeNode nodePrev = this.find((Root)oTrans);
            nodeTable = new cTransformationTreeNode(oTrans);
            this.addChild((MutableTreeNode)((Object)nodeTable), (MutableTreeNode)((Object)nodeParent));
            if (nodePrev != null) {
                nodeTable.setFirstInstance(nodePrev);
                return;
            }
            this.populateStore(oTrans);
            cStepList lSteps = this.getNextSteps(oTrans);
            for (int iStep = 0; iStep < lSteps.size(); ++iStep) {
                this.addStepNode(nodeParent, nodeTable, lSteps.getStep(iStep), null);
            }
        }

        private cStepList getNextSteps(Classifier oTable) throws MdException, RemoteException {
            cStepList lSteps = new cStepList();
            List lCMs = this.getClassifierMaps(oTable);
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                AssociationList lTSs = oCM.getSteps();
                if (lTSs.isEmpty()) continue;
                lSteps.add((TransformationStep)lTSs.get(0), (AbstractTransformation)oCM);
            }
            return lSteps;
        }

        private cStepList getNextSteps(Transformation oTrans) throws MdException, RemoteException {
            cStepList lSteps = new cStepList();
            List lTSs = this.getTransformationSteps(oTrans);
            for (int iTS = 0; iTS < lTSs.size(); ++iTS) {
                TransformationStep oTS = (TransformationStep)lTSs.get(iTS);
                AssociationList lCMs = oTS.getTransformations();
                if (lTSs.isEmpty()) continue;
                lSteps.add(oTS, (AbstractTransformation)((ClassifierMap)lCMs.get(0)));
            }
            return lSteps;
        }

        private List getNextTables(List lCMs) throws MdException, RemoteException {
            ArrayList lTables = new ArrayList();
            for (int iCM = 0; iCM < lCMs.size(); ++iCM) {
                ClassifierMap oCM = (ClassifierMap)lCMs.get(iCM);
                lTables.addAll(this.getTables(oCM));
            }
            return lTables;
        }

        protected List getTransformationSteps(Transformation oTrans) throws MdException, RemoteException {
            if (this.m_bForward) {
                return oTrans.getTransformationTargets();
            }
            return oTrans.getTransformationSources();
        }

        private void addInformationMap(Transformation trans, cTreeNode nodeTable) throws MdException, RemoteException {
            cTreeNode nodePrev = this.find((Root)trans);
            cInformationMapTreeNode imTreeNode = new cInformationMapTreeNode(trans);
            this.addChild((MutableTreeNode)((Object)imTreeNode), (MutableTreeNode)((Object)nodeTable));
            if (nodePrev != null) {
                imTreeNode.setFirstInstance(nodePrev);
            }
            AssociationList l_SourceTrans = trans.getSourceTransformations();
            for (int i = 0; i < l_SourceTrans.size(); ++i) {
                Transformation sourceTrans = (Transformation)l_SourceTrans.get(i);
                this.addInformationMap(sourceTrans, imTreeNode);
            }
        }

        protected void processGroup(Group oGroup, cTreeNode nodePrevious) throws MdException, RemoteException {
            this.populateStoreForBILineage((CMetadata)oGroup);
            if (this.m_bForward) {
                AssociationList l_STs = oGroup.getSourceTransformations();
                for (int i = 0; i < l_STs.size(); ++i) {
                    ClassifierMap i_CM = (ClassifierMap)l_STs.get(i);
                    AssociationList l_TTs = i_CM.getTransformationTargets();
                    for (int j = 0; j < l_TTs.size(); ++j) {
                        this.addGroupNode(nodePrevious, (Group)l_TTs.get(j));
                    }
                }
            } else {
                AssociationList l_TTs = oGroup.getTargetTransformations();
                for (int i = 0; i < l_TTs.size(); ++i) {
                    ClassifierMap i_CM = (ClassifierMap)l_TTs.get(i);
                    AssociationList l_TSs = i_CM.getTransformationSources();
                    for (int j = 0; j < l_TSs.size(); ++j) {
                        this.addGroupNode(nodePrevious, (Group)l_TSs.get(j));
                    }
                }
            }
        }

        protected void addGroupNode(cTreeNode nodeParent, Group oGroup) throws MdException, RemoteException {
            cGroupTreeNode nodeGroup = null;
            cTreeNode nodePrev = this.find((Root)oGroup);
            nodeGroup = new cGroupTreeNode(oGroup);
            this.addChild((MutableTreeNode)((Object)nodeGroup), (MutableTreeNode)((Object)nodeParent));
            if (nodePrev != null) {
                nodeGroup.setFirstInstance(nodePrev);
                return;
            }
            this.processGroup(oGroup, nodeGroup);
        }
    }

    protected class cPageSetupAction
    extends WsAbstractAction {
        public cPageSetupAction() {
            this.setMenuSupportId("pagesetup");
        }

        public void actionPerformed(ActionEvent e) {
            String sName = ImpactAnalysisReportTab.this.m_mdlReport.getRoot().toString();
            String sTitle = ((ImpactAnalysisReportTab)ImpactAnalysisReportTab.this).m_mdlReport.m_bForward ? bundle.formatString("ImpactAnalysisReportTab.ForwardPrintTitle.fmt.txt", (Object)sName) : bundle.formatString("ImpactAnalysisReportTab.ReversePrintTitle.fmt.txt", (Object)sName);
            ImpactAnalysisReportTab.this.m_pageFormat = (PageFormat)new WsTitledPageFormat(sTitle);
            PrinterJob pjob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                return;
            }
            ImpactAnalysisReportTab.this.m_pageFormat = pjob.pageDialog(ImpactAnalysisReportTab.this.m_pageFormat);
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        public cPrintAction() {
            super(bundle, "ImpactAnalysisReportTab.Print", true);
            this.setMenuSupportId("print");
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob pjob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                return;
            }
            String sName = ImpactAnalysisReportTab.this.m_mdlReport.getRoot().toString();
            String sTitle = ((ImpactAnalysisReportTab)ImpactAnalysisReportTab.this).m_mdlReport.m_bForward ? bundle.formatString("ImpactAnalysisReportTab.ForwardPrintTitle.fmt.txt", (Object)sName) : bundle.formatString("ImpactAnalysisReportTab.ReversePrintTitle.fmt.txt", (Object)sName);
            pjob.setJobName(sTitle);
            WsTree treePrint = new WsTree((DefaultTreeModel)ImpactAnalysisReportTab.this.m_mdlReport);
            treePrint.expand();
            if (ImpactAnalysisReportTab.this.m_pageFormat == null) {
                ImpactAnalysisReportTab.this.m_pageFormat = (PageFormat)new WsTitledPageFormat(sTitle);
            }
            WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)treePrint, (PageFormat)ImpactAnalysisReportTab.this.m_pageFormat, (boolean)false);
            pjob.setPageable((Pageable)printer);
            if (pjob.printDialog()) {
                try {
                    pjob.print();
                }
                catch (PrinterException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("ImpactAnalysisReportTab.PrintErrorTitle.txt"), (int)0);
                }
            }
            printer.dispose();
        }
    }

    protected class cFindFirstAction
    extends WsAbstractAction {
        public cFindFirstAction() {
            super(bundle, "ImpactAnalysisReportTab.FindFirst");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            cTreeNode nodeActive = (cTreeNode)ImpactAnalysisReportTab.this.m_treeReport.getActiveNode();
            TreePath pathFirst = new TreePath(nodeActive.getFirstInstance().getPath());
            ImpactAnalysisReportTab.this.m_treeReport.setSelectionPath(pathFirst);
            ImpactAnalysisReportTab.this.m_treeReport.scrollPathToVisible(pathFirst);
        }
    }

    protected class cTreePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cTreePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            WsTreeNode nodeActive = ImpactAnalysisReportTab.this.m_treeReport.getActiveNode();
            if (nodeActive != null) {
                nodeActive.addPopupMenuItems(mnuPopup);
                mnuPopup.add((Action)ImpactAnalysisReportTab.this.m_actFindFirst);
                mnuPopup.addSeparator();
            }
            mnuPopup.add((Action)ImpactAnalysisReportTab.this.m_actPrint);
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTreeSelectionListener
    implements TreeSelectionListener {
        protected cTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ImpactAnalysisReportTab.this.fireSelectionChangedEvent();
            ImpactAnalysisReportTab.this.updateActions();
        }
    }
}

