/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class GroupByPropertyTab
extends WAPropertyTab {
    private WAdminResource bundle = WAdminResource.getBundle(GroupByPropertyTab.class);
    private WAPanel m_panel;
    private cDNDTable m_table;
    private cGroupByTableModel m_tableModel;
    private cDNDScrollPane m_tableScrollPane;
    private JLabel m_tableLabel;
    private Vector m_columns = new Vector();
    private cDNDList m_list;
    private DefaultListModel m_listModel;
    private JScrollPane m_listScrollPane;
    private JLabel m_listBoxLabel;
    private JPanel m_btnPnlVertical;
    private JPanel m_btnPnlHorizontal;
    private JButton m_btnMoveUp;
    private JButton m_btnMoveDown;
    private JButton m_btnLeft;
    private JButton m_btnRight;
    private CMetadata m_metadata;
    private ListSelectionListener m_lsnrTableSelection;
    private ListSelectionListener m_lsnrListSelection;
    private MouseAdapter m_lsnrListMouse;
    private WsTableRowModelListener m_lsnrTargetTableRowModel;
    private TableModelListener m_lsnrTableModel;
    private WsAbstractAction m_actLeft;
    private WsAbstractAction m_actRight;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private String m_bundlePrefix = "GroupByPropertyTab";
    private String m_leftLabel;
    private String m_leftMnem;
    private String m_leftTooltip;
    private String m_rightLabel;
    private String m_rightMnem;
    private String m_rightTooltip;
    private boolean m_bOrderChanged;
    private boolean m_bIgnoreActionUpdates;
    private final int SCROLL_PANE_WIDTH = 165;
    private final int SCROLL_PANE_HEIGHT = 315;
    public static final String GROUPBYTRANFORMROLE = "SQLGROUPBYINTEGER";

    public GroupByPropertyTab(CMetadata metadata) {
        this(metadata, "", "group_by_tab");
    }

    public GroupByPropertyTab(CMetadata metadata, String bundlePrefix, String helpTopic) {
        if (bundlePrefix.trim().compareTo("") != 0) {
            this.m_bundlePrefix = bundlePrefix;
        }
        this.m_leftLabel = this.bundle.getString(this.m_bundlePrefix + ".Left.Label.txt");
        this.m_leftMnem = this.bundle.getString(this.m_bundlePrefix + ".Left.mnem");
        this.m_leftTooltip = this.bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = this.bundle.getString(this.m_bundlePrefix + ".Right.Label.txt");
        this.m_rightMnem = this.bundle.getString(this.m_bundlePrefix + ".Right.mnem");
        this.m_rightTooltip = this.bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.construct(metadata, helpTopic);
    }

    public GroupByPropertyTab(CMetadata metadata, String rightLabel, String rightMnem, String helpTopic) {
        this.m_leftLabel = this.bundle.getString(this.m_bundlePrefix + ".Left.Label.txt");
        this.m_leftMnem = this.bundle.getString(this.m_bundlePrefix + ".Left.mnem");
        this.m_leftTooltip = this.bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = this.bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.construct(metadata, helpTopic);
    }

    public GroupByPropertyTab(CMetadata metadata, String leftLabel, String leftMnem, String rightLabel, String rightMnem, String helpTopic) {
        this.m_leftLabel = leftLabel;
        this.m_leftMnem = leftMnem;
        this.m_leftTooltip = this.bundle.getString(this.m_bundlePrefix + ".Left.Tooltip.txt");
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = this.bundle.getString(this.m_bundlePrefix + ".Right.Tooltip.txt");
        this.construct(metadata, helpTopic);
    }

    public GroupByPropertyTab(CMetadata metadata, boolean sourceTable, String leftLabel, String leftMnem, String leftTooltip, String rightLabel, String rightMnem, String rightTooltip, String helpTopic) {
        this.m_leftLabel = leftLabel;
        this.m_leftMnem = leftMnem;
        this.m_leftTooltip = leftTooltip;
        this.m_rightLabel = rightLabel;
        this.m_rightMnem = rightMnem;
        this.m_rightTooltip = rightTooltip;
        this.construct(metadata, helpTopic);
    }

    public void construct(CMetadata metadata, String helpTopic) {
        try {
            if (metadata.getCMetadataType().compareTo("TransformationStep") == 0) {
                AssociationList transList = ((TransformationStep)metadata).getTransformations();
                this.m_metadata = (Transformation)transList.get(0);
            } else {
                this.m_metadata = metadata;
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic(helpTopic);
    }

    public void initialize() {
        this.createActions();
        this.createButtonsPanel();
        this.createListeners();
        this.createSourceListBox();
        this.createTargetTable();
    }

    protected void createSourceListBox() {
        this.m_listModel = new DefaultListModel();
        this.m_list = new cDNDList(this.m_listModel);
        this.m_list.initialize();
        this.m_list.setToolTipText(this.m_leftTooltip);
        this.m_listBoxLabel = new JLabel(this.m_leftLabel);
        this.m_listBoxLabel.setLabelFor(this.m_list);
        this.m_listBoxLabel.setDisplayedMnemonic(this.m_leftMnem.charAt(0));
        this.m_list.getSelectionModel().addListSelectionListener(this.m_lsnrListSelection);
        this.m_list.addMouseListener(this.m_lsnrListMouse);
        this.m_listScrollPane = new JScrollPane();
        this.m_listScrollPane.getViewport().setView(this.m_list);
        this.m_listScrollPane.setVerticalScrollBarPolicy(20);
        this.m_listScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_listScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.m_listScrollPane.setPreferredSize(new Dimension(115, 315));
    }

    protected void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnLeft = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actLeft);
        this.m_btnRight = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actRight);
        this.m_btnPnlHorizontal = new JPanel((LayoutManager)new WsButtonsLayout(0, 0));
        this.m_btnPnlVertical = new JPanel((LayoutManager)new WsButtonsLayout(1, 0));
        this.m_btnPnlHorizontal.add(this.m_btnMoveUp);
        this.m_btnPnlHorizontal.add(this.m_btnMoveDown);
        this.m_btnPnlVertical.add(this.m_btnRight);
        this.m_btnPnlVertical.add(this.m_btnLeft);
    }

    protected void createTargetTable() {
        this.m_tableModel = this.createTableModel();
        this.m_table = new cDNDTable(this.m_tableModel);
        this.m_table.setUndoManager((UndoManager)this.getWAUndoManager());
        this.m_tableModel.addTableModelListener(this.m_lsnrTableModel);
        this.m_table.getSelectionModel().addListSelectionListener(this.m_lsnrTableSelection);
        this.m_table.setMultipleSelectionDragEnabled(true);
        this.m_table.addMouseListener(this.m_lsnrListMouse);
        ((WsDefaultTableRowModel)this.m_table.getRowModel()).addRowModelListener(this.m_lsnrTargetTableRowModel);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_table.restoreSettings("GroupByTableProperty");
        this.m_tableScrollPane = new cDNDScrollPane();
        this.m_tableScrollPane.getViewport().setView((Component)((Object)this.m_table));
        this.m_tableScrollPane.setVerticalScrollBarPolicy(20);
        this.m_tableScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_tableScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.m_tableScrollPane.setPreferredSize(new Dimension(215, 315));
        this.m_tableScrollPane.setToolTipText(this.m_rightTooltip);
        this.m_tableLabel = new JLabel(this.m_rightLabel);
        this.m_tableLabel.setLabelFor((Component)((Object)this.m_table));
        this.m_tableLabel.setDisplayedMnemonic(this.m_rightMnem.charAt(0));
    }

    protected cGroupByTableModel createTableModel() {
        return new cGroupByTableModel((Transformation)this.m_metadata);
    }

    protected void createActions() {
        this.m_actLeft = this.createMoveLeftAction();
        this.m_actRight = this.createMoveRightAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
    }

    protected WsAbstractAction createMoveLeftAction() {
        return new cMoveLeftAction();
    }

    protected WsAbstractAction createMoveRightAction() {
        return new cMoveRightAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_panel = new WAPanel();
        this.m_panel.setLayout((LayoutManager)new GridBagLayout());
        this.m_panel.add((Component)this.m_listBoxLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_panel.add((Component)this.m_listScrollPane, (Object)new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_tableLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_panel.add((Component)this.m_tableScrollPane, (Object)new GridBagConstraints(2, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_btnPnlHorizontal, (Object)new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_panel.add((Component)this.m_btnPnlVertical, (Object)new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_list.setEnabled(bEditable);
        this.m_table.setEnabled(bEditable);
        this.updateActions();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actLeft.setActive(bActive);
        this.m_actRight.setActive(bActive);
        this.m_actMoveDown.setActive(bActive);
        this.m_actMoveUp.setActive(bActive);
    }

    public void saveSettingsAndCleanUp() {
        this.m_table.saveSettings("GroupByTableProperty");
    }

    protected void createListeners() {
        this.m_lsnrTableSelection = this.createTableSelectionListener();
        this.m_lsnrTargetTableRowModel = this.createTargetTableRowModelListener();
        this.m_lsnrTableModel = this.createTableModelListener();
        this.m_lsnrListSelection = this.createListSelectionListener();
        this.m_lsnrListMouse = this.createListMouseListener();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected WsTableRowModelListener createTargetTableRowModelListener() {
        return new cTargetTableRowModelListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new cListBoxListSelectionListener();
    }

    protected MouseAdapter createListMouseListener() {
        return new cListMouseListener();
    }

    public void addItemsToWsTable() {
        if (!this.isEditable()) {
            return;
        }
        try {
            int[] index = this.m_list.getSelectedIndices();
            int count = 0;
            int lastSelection = -1;
            int iDisplayType = 0;
            int newRow = 0;
            Vector<String[]> undoVector = new Vector<String[]>();
            for (int i = 0; i < index.length; ++i) {
                lastSelection = index[i] - count;
                Column column = (Column)this.m_listModel.get(lastSelection);
                String colName = column.getSASColumnName();
                AssociationList alFM = null;
                try {
                    alFM = column.getTargetFeatureMaps();
                }
                catch (MdException mdException) {
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                if (alFM != null) {
                    boolean isDerived = false;
                    for (int j = 0; j < alFM.size(); ++j) {
                        FeatureMap fM = (FeatureMap)alFM.get(j);
                        String fmRole = fM.getTransformRole();
                        if (fmRole.compareTo("Derived") != 0 && fmRole.compareTo("DERIVED") != 0) continue;
                        isDerived = true;
                        break;
                    }
                    if (isDerived) {
                        iDisplayType = 1;
                    }
                }
                ArrayList<String> alRow = new ArrayList<String>(this.m_tableModel.getColumnCount() + this.m_tableModel.getHiddenColumnCount());
                alRow.add(column.getSASColumnName());
                alRow.add(this.m_tableModel.g_saDisplayTypes[iDisplayType]);
                alRow.add((String)column);
                alRow.add(null);
                newRow = this.m_tableModel.getRowCount() - 1;
                this.m_tableModel.insertRow(newRow, alRow);
                this.m_listModel.remove(lastSelection);
                String[] undoValues = new String[]{colName, this.m_tableModel.g_sDisplayName, String.valueOf(this.m_tableModel.getRowCount() - 1)};
                undoVector.add(i, undoValues);
                ++count;
            }
            if (undoVector.size() > 0) {
                this.getWAUndoManager().addEdit((UndoableEdit)new cUndoableChange("ADD", undoVector));
            }
            this.m_table.grabFocus();
            int rowCnt = this.m_tableModel.getRowCount();
            if (rowCnt == 1) {
                this.m_table.getSelectionModel().setSelectionInterval(0, 1);
            } else {
                int initialCell = rowCnt * 2 - 2;
                this.m_table.getSelectionModel().setSelectionInterval(initialCell, initialCell + 1);
            }
            this.updateActions();
            if (iDisplayType == 1) {
                MessageUtil.displayMessage((String)this.bundle.getString("GroupByPropertyTab.DerivedColumnMessage.txt"), (int)1);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void removeItemsFromWsTable() {
        if (!this.isEditable()) {
            return;
        }
        try {
            int lastSelection = -1;
            int count = 0;
            Vector<Column> selectColumns = new Vector<Column>();
            int[] index = this.m_table.getSelectedRowsFromSelectedCells();
            Vector<String[]> undoVector = new Vector<String[]>();
            for (int i = 0; i < index.length; ++i) {
                int viewIndex = index[i];
                lastSelection = viewIndex - count;
                int modelIndex = this.m_table.convertRowIndexToModel(lastSelection);
                Column column = (Column)this.m_tableModel.getValueAt(modelIndex, 2);
                String colName = column.getSASColumnName();
                String displayType = (String)this.m_tableModel.getValueAt(modelIndex, 1);
                selectColumns.add(column);
                this.m_tableModel.deleteRow(modelIndex);
                this.fillListBox();
                String[] undoValues = new String[]{colName, displayType, String.valueOf(lastSelection)};
                undoVector.add(i, undoValues);
                ++count;
            }
            if (undoVector.size() > 0) {
                this.getWAUndoManager().addEdit((UndoableEdit)new cUndoableChange("REMOVE", undoVector));
            }
            this.m_list.grabFocus();
            int size = selectColumns.size();
            int[] intArray = new int[size];
            for (int i = 0; i < size; ++i) {
                intArray[i] = this.m_listModel.indexOf(selectColumns.get(i));
            }
            this.m_list.setSelectedIndices(intArray);
            this.updateActions();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void updateActions() {
        if (this.m_bIgnoreActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable();
        boolean bFirst = false;
        boolean bLast = false;
        int[] aSelectedTargetRows = this.m_table.getSelectedRowsFromSelectedCells();
        int nSelectedTargetRows = aSelectedTargetRows.length;
        int nTargetRows = this.m_table.getRowCount();
        for (int iSelectedTargetRow = 0; iSelectedTargetRow < nSelectedTargetRows; ++iSelectedTargetRow) {
            int iTarget = aSelectedTargetRows[iSelectedTargetRow];
            if (iTarget == 0) {
                bFirst = true;
            }
            if (iTarget == nTargetRows - 1) {
                bLast = true;
            }
            if (bFirst && bLast) break;
        }
        this.m_actLeft.setEnabled(bEditable && nSelectedTargetRows > 0);
        this.m_actRight.setEnabled(bEditable && this.m_list.getSelectedIndex() > -1);
        this.m_actMoveUp.setEnabled(bEditable && nSelectedTargetRows > 0 && !bFirst);
        this.m_actMoveDown.setEnabled(bEditable && nSelectedTargetRows > 0 && !bLast);
    }

    public boolean validateData() {
        if (this.m_bOrderChanged && !this.m_table.isOriginalOrder()) {
            int eAnswer = MessageUtil.displayMessage((String)this.bundle.getString("GroupByPropertyTab.SaveOrderMessage.txt"), (String)this.bundle.getString("GroupByPropertyTab.SaveOrderTitle.txt"), (int)2, (int)1);
            switch (eAnswer) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_table.getRowModel();
        this.m_tableModel.setRowMappings(mdlRows.getRowMappings());
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_metadata.getFQID().indexOf(36) == -1) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(this.m_metadata, null, null, "", 8);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_tableModel.moveDataToModel();
        Select s = (Select)this.m_metadata;
        AssociationList ptList = s.getClassifierTargets();
        if (ptList.size() > 0) {
            PhysicalTable pt = (PhysicalTable)ptList.get(0);
            AssociationList columnsList = pt.getColumns();
            this.m_columns.clear();
            for (int i = 0; i < columnsList.size(); ++i) {
                Column col = (Column)columnsList.get(i);
                this.m_columns.addElement(col);
            }
            this.fillListBox();
            this.updateActions();
        }
        this.m_table.clearSelection();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_tableModel.moveDataToStore();
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    protected void fillListBox() {
        try {
            this.m_listModel.clear();
            for (int i = 0; i < this.m_columns.size(); ++i) {
                Column column = (Column)this.m_columns.get(i);
                boolean inWsTable = false;
                for (int j = 0; j < this.m_tableModel.getRowCount(); ++j) {
                    Column tblColumn = (Column)this.m_tableModel.getValueAt(j, 2);
                    if (column.getFQID().compareTo(tblColumn.getFQID()) != 0) continue;
                    inWsTable = true;
                    break;
                }
                if (inWsTable) continue;
                this.m_listModel.addElement(column);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public CMetadata getMetadata() {
        return this.m_metadata;
    }

    public void drop(DropTargetDropEvent event) {
        try {
            Vector dndObj = null;
            Transferable transfer = event.getTransferable();
            if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                Object tempObj = dndObj.get(0);
                if (tempObj instanceof cDNDList) {
                    event.acceptDrop(2);
                    this.addItemsToWsTable();
                    this.setDataChanged(true);
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            event.rejectDrop();
        }
    }

    protected class cUndoableChange
    extends AbstractUndoableEdit {
        Vector m_vector;
        String m_changeType;

        public cUndoableChange(String changeType, Vector undoVector) {
            this.m_changeType = changeType;
            this.m_vector = undoVector;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_changeType.equals("ADD")) {
                this.remove();
            } else if (this.m_changeType.equals("REMOVE")) {
                this.add();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_changeType.equals("ADD")) {
                this.add();
            } else if (this.m_changeType.equals("REMOVE")) {
                this.remove();
            }
        }

        public void add() {
            try {
                GroupByPropertyTab.this.m_table.grabFocus();
                for (int v = 0; v < this.m_vector.size(); ++v) {
                    String[] values = (String[])this.m_vector.get(v);
                    String colName = values[0];
                    String displayType = values[1];
                    Column col = null;
                    for (int i = 0; i < GroupByPropertyTab.this.m_columns.size() && (col = (Column)GroupByPropertyTab.this.m_columns.get(i)).getSASColumnName().compareTo(colName) != 0; ++i) {
                    }
                    ArrayList<String> alRow = new ArrayList<String>(GroupByPropertyTab.this.m_tableModel.getColumnCount() + GroupByPropertyTab.this.m_tableModel.getHiddenColumns());
                    alRow.add(colName);
                    alRow.add(displayType);
                    alRow.add((String)col);
                    alRow.add(null);
                    int newRow = 0;
                    if (GroupByPropertyTab.this.m_tableModel.getRowCount() == 0) {
                        newRow = GroupByPropertyTab.this.m_tableModel.getRowCount() - 1;
                        GroupByPropertyTab.this.m_tableModel.insertRow(newRow, alRow);
                    } else {
                        int position = Integer.valueOf(values[2]);
                        newRow = position - 1;
                        GroupByPropertyTab.this.m_tableModel.insertRow(newRow, alRow);
                    }
                    GroupByPropertyTab.this.m_table.addRowToSelection(newRow + 1);
                    int index = -1;
                    for (int i = 0; i < GroupByPropertyTab.this.m_listModel.size(); ++i) {
                        if (((Column)GroupByPropertyTab.this.m_listModel.get(i)).getFQID().compareTo(col.getFQID()) != 0) continue;
                        index = i;
                        break;
                    }
                    if (index <= -1) continue;
                    GroupByPropertyTab.this.m_listModel.remove(index);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void remove() {
            try {
                Vector<Column> selectColumns = new Vector<Column>();
                for (int v = 0; v < this.m_vector.size(); ++v) {
                    int i;
                    String[] values = (String[])this.m_vector.get(v);
                    String colName = values[0];
                    int row = -1;
                    for (i = 0; i < GroupByPropertyTab.this.m_tableModel.getRowCount(); ++i) {
                        if (!GroupByPropertyTab.this.m_tableModel.getValueAt(i, 0).equals(colName)) continue;
                        row = i;
                        break;
                    }
                    if (row > -1) {
                        GroupByPropertyTab.this.m_tableModel.deleteRow(row);
                    }
                    for (i = 0; i < GroupByPropertyTab.this.m_columns.size(); ++i) {
                        Column col = (Column)GroupByPropertyTab.this.m_columns.get(i);
                        if (col.getSASColumnName().compareTo(colName) != 0) continue;
                        selectColumns.add(col);
                    }
                }
                GroupByPropertyTab.this.fillListBox();
                GroupByPropertyTab.this.m_list.grabFocus();
                int size = selectColumns.size();
                int[] intArray = new int[size];
                for (int i = 0; i < size; ++i) {
                    intArray[i] = GroupByPropertyTab.this.m_listModel.indexOf(selectColumns.get(i));
                }
                GroupByPropertyTab.this.m_list.setSelectedIndices(intArray);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cGroupByTableModel
    extends WsAbstractTableModel {
        private static final int COLUMNNAME_COLUMN = 0;
        private static final int DISPLAYCOLUMN_COLUMN = 1;
        private static final int METADATA_COLUMN = 2;
        private static final int FEATUREMAP_COLUMN = 3;
        private static final int VISIBLE_COLUMNS = 2;
        private static final int HIDDEN_COLUMNS = 2;
        private static final int COLUMNNAME_WIDTH = 125;
        private static final int DISPLAYCOLUMN_WIDTH = 100;
        private static final int DISPLAY_COLUMN_NAME = 0;
        private static final int DISPLAY_INTEGER = 1;
        private String g_sDisplayName;
        private String g_sDisplayInteger;
        private String g_sFeatureMapName;
        private List m_lDataColumns;
        private String[] g_saDisplayTypes;
        private int[] m_aRowMappings;

        private cGroupByTableModel(Transformation inObject) {
            this();
            groupByPropertyTab.m_metadata = (CMetadata)inObject;
        }

        private cGroupByTableModel() {
            this.g_sDisplayName = GroupByPropertyTab.this.bundle.getString("GroupByPropertyTab.ShowName.txt");
            this.g_sDisplayInteger = GroupByPropertyTab.this.bundle.getString("GroupByPropertyTab.ShowInteger.txt");
            this.g_sFeatureMapName = GroupByPropertyTab.this.bundle.getString("GroupByPropertyTab.fmName.txt");
            this.m_lDataColumns = new Vector();
            this.g_saDisplayTypes = new String[]{this.g_sDisplayName, this.g_sDisplayInteger};
            this.createColumnDefinitions();
        }

        protected void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumns()];
            this.m_aColumns[0] = new WsStringTableColumn(0, GroupByPropertyTab.this.bundle.getString("GroupByPropertyTab.column.name.txt"), 125);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new WsEnumeratedTableColumn(1, GroupByPropertyTab.this.bundle.getString("GroupByProperty.DisplayType.txt"), 100, this.g_saDisplayTypes);
            this.m_aColumns[2] = new WsMetadataTableColumn();
            this.m_aColumns[3] = new WsMetadataTableColumn();
        }

        protected void setMetadataObject(CMetadata inObject) {
            GroupByPropertyTab.this.m_metadata = inObject;
        }

        public void populateStore() {
            if (this.isStorePopulated()) {
                return;
            }
            this.setStorePopulated(true);
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            this.m_lDataColumns.clear();
            Select objSelect = (Select)GroupByPropertyTab.this.m_metadata;
            GroupByClause gbc = objSelect.getGroupByForSelect();
            if (gbc == null) {
                return;
            }
            AssociationList byColumnsList = gbc.getColumns();
            AssociationList ptList = objSelect.getClassifierTargets();
            AssociationList columnsList = null;
            if (ptList.size() > 0) {
                PhysicalTable pt = (PhysicalTable)ptList.get(0);
                columnsList = pt.getColumns();
            }
            if (columnsList != null && columnsList.size() > 0) {
                block0: for (int i = 0; i < byColumnsList.size(); ++i) {
                    Column col = (Column)byColumnsList.get(i);
                    for (int j = 0; j < columnsList.size(); ++j) {
                        Column clCol = (Column)columnsList.get(j);
                        if (clCol.getFQID().compareTo(col.getFQID()) != 0) continue;
                        this.m_lDataColumns.add(col);
                        continue block0;
                    }
                }
            }
            if (this.m_lDataColumns.size() > 0) {
                for (int i = 0; i < this.m_lDataColumns.size(); ++i) {
                    int iDisplayType = 0;
                    Column oColumn = (Column)this.m_lDataColumns.get(i);
                    FeatureMap oFM = this.findGroupByFeatureMap(oColumn);
                    if (oFM != null) {
                        iDisplayType = 1;
                    } else {
                        boolean isDerived = false;
                        AssociationList alFM = oColumn.getTargetFeatureMaps();
                        for (int j = 0; j < alFM.size(); ++j) {
                            FeatureMap fM = (FeatureMap)alFM.get(j);
                            String fmRole = fM.getTransformRole();
                            if (!fmRole.equalsIgnoreCase("DERIVED")) continue;
                            isDerived = true;
                            break;
                        }
                        if (isDerived) {
                            MessageUtil.displayMessage((String)GroupByPropertyTab.this.bundle.getString("GroupByPropertyTab.DerivedColumnMessage.txt"), (int)2);
                        }
                    }
                    ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumns());
                    alRow.add(oColumn.getSASColumnName());
                    alRow.add(this.g_saDisplayTypes[iDisplayType]);
                    alRow.add((String)oColumn);
                    alRow.add((String)oFM);
                    this.m_lData.add(alRow);
                }
            }
            if ((nRows = this.m_lData.size()) > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }

        public void moveDataToStore() throws MdException, RemoteException {
            MdObjectStore store = (MdObjectStore)GroupByPropertyTab.this.m_metadata.getObjectStore();
            Select objSelect = (Select)GroupByPropertyTab.this.m_metadata;
            GroupByClause gbc = objSelect.getGroupByForSelect();
            if (gbc == null) {
                String reposID = objSelect.getRepositoryID();
                gbc = (GroupByClause)Workspace.getMdFactory().createComplexMetadataObject(store, "GroupBy", "GroupByClause", reposID);
                objSelect.setGroupByForSelect(gbc);
            }
            AssociationList byColumnsList = gbc.getColumns();
            for (int i = 0; i < byColumnsList.size(); ++i) {
                Column col = (Column)byColumnsList.get(i);
                AssociationList alFM = col.getTargetFeatureMaps();
                for (int j = 0; j < alFM.size(); ++j) {
                    FeatureMap fM = (FeatureMap)alFM.get(j);
                    if (!fM.getTransformRole().equalsIgnoreCase(GroupByPropertyTab.GROUPBYTRANFORMROLE)) continue;
                    store.removeObjectFromStore((CMetadata)fM, null);
                }
            }
            byColumnsList.removeAllElements();
            int nRows = this.m_lData.size();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int iColumn = this.m_aRowMappings != null ? this.m_aRowMappings[iRow] : iRow;
                String sDisplayType = (String)this.getValueAt(iColumn, 1);
                Column oColumn = (Column)this.getValueAt(iColumn, 2);
                byColumnsList.add((Object)oColumn);
                if (!sDisplayType.equalsIgnoreCase(this.g_sDisplayInteger)) continue;
                FeatureMap oFM = (FeatureMap)Workspace.getMdFactory().createComplexMetadataObject(store, this.g_sFeatureMapName, "FeatureMap", GroupByPropertyTab.this.m_metadata.getRepositoryID());
                oFM.setTransformRole(GroupByPropertyTab.GROUPBYTRANFORMROLE);
                oFM.setIsUserDefined(1);
                oFM.getFeatureTargets().add((Object)oColumn);
                ((ClassifierMap)GroupByPropertyTab.this.m_metadata).getFeatureMaps().add((Object)oFM);
                this.setValueAt(oFM, iColumn, 3);
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getHiddenColumns() {
            return 2;
        }

        public int[] getRowMappings() {
            return this.m_aRowMappings;
        }

        public void setRowMappings(int[] aRowMappings) {
            this.m_aRowMappings = aRowMappings;
        }

        public FeatureMap findGroupByFeatureMap(Column iColumn) throws MdException, RemoteException {
            if (iColumn == null) {
                return null;
            }
            AssociationList al_targetFM = iColumn.getTargetFeatureMaps();
            FeatureMap oFM = null;
            for (int i = 0; i < al_targetFM.size(); ++i) {
                FeatureMap fM = (FeatureMap)al_targetFM.get(i);
                if (fM == null || !fM.getTransformRole().equalsIgnoreCase(GroupByPropertyTab.GROUPBYTRANFORMROLE)) continue;
                oFM = fM;
                break;
            }
            return oFM;
        }
    }

    class cDNDScrollPane
    extends JScrollPane
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DropTarget m_dropTarget = new DropTarget(this, this);

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof cDNDList) {
                        event.acceptDrop(2);
                        GroupByPropertyTab.this.addItemsToWsTable();
                        GroupByPropertyTab.this.setDataChanged(true);
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class cDNDTable
    extends WsTable
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DragSource m_dragSource;
        DropTarget m_dropTarget;

        public cDNDTable(cGroupByTableModel ssbm) {
            super((WsAbstractTableModel)ssbm);
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
            this.m_dropTarget = new DropTarget((Component)((Object)this), this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (GroupByPropertyTab.this.m_table.getSelectedCellCount() > 0) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof cDNDList) {
                        event.acceptDrop(2);
                        GroupByPropertyTab.this.addItemsToWsTable();
                        GroupByPropertyTab.this.setDataChanged(true);
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class cDNDList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        DragSource m_dragSource;
        DropTarget m_dropTarget;

        public cDNDList(DefaultListModel dlm) {
            super(dlm);
        }

        public void initialize() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.m_dropTarget = new DropTarget(this, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (GroupByPropertyTab.this.m_list.getSelectedIndices().length == 1) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof cDNDTable) {
                        event.acceptDrop(2);
                        GroupByPropertyTab.this.removeItemsFromWsTable();
                        GroupByPropertyTab.this.setDataChanged(true);
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class cTableModelListener
    implements TableModelListener {
        cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (GroupByPropertyTab.this.isListeningForChanges()) {
                GroupByPropertyTab.this.setDataChanged(true);
            }
        }
    }

    protected class cTargetTableRowModelListener
    implements WsTableRowModelListener {
        protected cTargetTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            if (GroupByPropertyTab.this.m_table.isEditable()) {
                GroupByPropertyTab.this.setDataChanged(true);
                GroupByPropertyTab.this.m_bOrderChanged = true;
            }
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            if (GroupByPropertyTab.this.m_table.isEditable()) {
                GroupByPropertyTab.this.setDataChanged(true);
                GroupByPropertyTab.this.m_bOrderChanged = true;
            }
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GroupByPropertyTab.this.updateActions();
        }
    }

    class cListBoxListSelectionListener
    implements ListSelectionListener {
        cListBoxListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || !GroupByPropertyTab.this.isEditable()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                GroupByPropertyTab.this.m_table.clearSelection();
            }
            GroupByPropertyTab.this.updateActions();
        }
    }

    class cListMouseListener
    extends MouseAdapter {
        cListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (GroupByPropertyTab.this.m_list == e.getSource()) {
                    GroupByPropertyTab.this.addItemsToWsTable();
                    GroupByPropertyTab.this.setDataChanged(true);
                } else {
                    GroupByPropertyTab.this.removeItemsFromWsTable();
                }
            }
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(GroupByPropertyTab.this.bundle, "GroupByPropertyTab.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            GroupByPropertyTab.this.m_bIgnoreActionUpdates = true;
            GroupByPropertyTab.this.m_table.undoableMoveSelectedRows(1);
            GroupByPropertyTab.this.setDataChanged(true);
            GroupByPropertyTab.this.m_bOrderChanged = true;
            GroupByPropertyTab.this.m_bIgnoreActionUpdates = false;
            GroupByPropertyTab.this.updateActions();
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(GroupByPropertyTab.this.bundle, "GroupByPropertyTab.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            GroupByPropertyTab.this.m_bIgnoreActionUpdates = true;
            GroupByPropertyTab.this.m_table.undoableMoveSelectedRows(-1);
            GroupByPropertyTab.this.setDataChanged(true);
            GroupByPropertyTab.this.m_bOrderChanged = true;
            GroupByPropertyTab.this.m_bIgnoreActionUpdates = false;
            GroupByPropertyTab.this.updateActions();
        }
    }

    class cMoveLeftAction
    extends WsAbstractAction {
        public cMoveLeftAction() {
            super(GroupByPropertyTab.this.bundle, "GroupByPropertyTab.MoveLeft", true);
        }

        public void actionPerformed(ActionEvent e) {
            GroupByPropertyTab.this.removeItemsFromWsTable();
            GroupByPropertyTab.this.setDataChanged(true);
        }
    }

    class cMoveRightAction
    extends WsAbstractAction {
        public cMoveRightAction() {
            super(GroupByPropertyTab.this.bundle, "GroupByPropertyTab.MoveRight", true);
        }

        public void actionPerformed(ActionEvent e) {
            GroupByPropertyTab.this.addItemsToWsTable();
            GroupByPropertyTab.this.setDataChanged(true);
        }
    }
}

