/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.RawDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class ExternalTableTreeNode
extends TempLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalTableTreeNode.class);
    private static Icon NORMAL_ICON = WAdminResource.getTypeIcon((String)"ExternalTable", (boolean)true);
    private static Icon PARAMS_ICON = bundle.getImageIcon("ExternalTableTreeNode.ExternalTableParameter.image");
    protected WsAbstractAction m_actViewData = this.createViewDataAction();
    protected WsAbstractAction m_actViewRawData = this.createViewRawDataAction();
    protected WsAbstractAction m_actImpactAnalysis = this.createImpactAnalysisAction();
    protected WsAbstractAction m_actReverseImpactAnalysis = this.createReverseImpactAnalysisAction();

    public ExternalTableTreeNode(CMetadata oExternalTable) {
        super(oExternalTable);
        this.updateIcon();
    }

    public JPopupMenu getPopupMenu(WAdminResource bundleLocal) {
        JPopupMenu menuPopup = super.getPopupMenu(bundleLocal);
        menuPopup.add((Action)this.m_actViewData);
        menuPopup.add((Action)this.m_actViewRawData);
        menuPopup.addSeparator();
        menuPopup.add((Action)this.m_actImpactAnalysis);
        menuPopup.add((Action)this.m_actReverseImpactAnalysis);
        return menuPopup;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actViewData.setActive(bActive);
        this.m_actViewRawData.setActive(bActive);
        this.m_actImpactAnalysis.setActive(bActive);
        this.m_actReverseImpactAnalysis.setActive(bActive);
    }

    @Override
    public void updateMetadata(CMetadata oMetadata) {
        this.updateIcon();
        super.updateMetadata(oMetadata);
    }

    protected void updateIcon() {
        this.setIcon(this.getDecoratedIcon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getDecoratedIcon() {
        Icon icon = NORMAL_ICON;
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                DataTable table = (DataTable)factory.createComplexMetadataObject(store, this.m_oMetadata);
                ParametersModel parmModel = new ParametersModel((Root)table);
                if (parmModel.isParameterizedObject()) {
                    icon = PARAMS_ICON;
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return icon;
    }

    public void viewData() {
        WsViewFactory.showView((CMetadata)this.m_oMetadata, ViewDataView.class);
    }

    private void viewRawData() {
        WsViewFactory.showView((CMetadata)this.m_oMetadata, RawDataView.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showImpactAnalysis(boolean bForward) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            MdFactory factory = Workspace.getMdFactory();
            MdObjectStore store = factory.createObjectStore();
            ExternalTable oDetail = (ExternalTable)factory.createComplexMetadataObject(store, this.m_oMetadata);
            ImpactAnalysisOMAView view = this.findImpactAnalysisView(oDetail, bForward);
            if (view != null) {
                oDetail.getObjectStore().dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            view = new ImpactAnalysisOMAView((Classifier)oDetail, bForward);
            WsViewFactory.attachViewToFrame((CMetadata)oDetail, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oDetail, ""));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(ExternalTable oTable, boolean bForward) throws RemoteException {
        ArrayList lViews = oTable.getViewList();
        int nViews = lViews.size();
        for (int iView = 0; iView < nViews; ++iView) {
            ImpactAnalysisOMAView view;
            if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
            return view;
        }
        return null;
    }

    protected WsAbstractAction createViewDataAction() {
        return new cViewDataAction();
    }

    protected WsAbstractAction createViewRawDataAction() {
        return new cViewRawDataAction();
    }

    protected WsAbstractAction createImpactAnalysisAction() {
        return new cImpactAnalysisAction();
    }

    protected WsAbstractAction createReverseImpactAnalysisAction() {
        return new cReverseImpactAnalysisAction();
    }

    protected class cReverseImpactAnalysisAction
    extends WsAbstractAction {
        public cReverseImpactAnalysisAction() {
            super(bundle, "Tree.PopupMenu.ReverseImpact", true);
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ExternalTableTreeNode.this.showImpactAnalysis(false);
        }
    }

    protected class cImpactAnalysisAction
    extends WsAbstractAction {
        public cImpactAnalysisAction() {
            super(bundle, "Tree.PopupMenu.Impact", true);
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ExternalTableTreeNode.this.showImpactAnalysis(true);
        }
    }

    protected class cViewRawDataAction
    extends WsAbstractAction {
        public cViewRawDataAction() {
            super(bundle, "Tree.PopupMenu.ViewRawData");
            this.setMenuSupportId("viewfile");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ExternalTableTreeNode.this.viewRawData();
        }
    }

    protected class cViewDataAction
    extends WsAbstractAction {
        public cViewDataAction() {
            super(bundle, "Tree.PopupMenu.ViewData");
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ExternalTableTreeNode.this.viewData();
        }
    }
}

