/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.SASLibrary;
import com.sas.plugins.InvalidPluginDirectoryException;
import com.sas.plugins.PluginLoader;
import com.sas.wadmin.plugins.SourceDesignerInterface;
import com.sas.wadmin.visuals.BigQueryImporter;
import com.sas.wadmin.visuals.CASImporter;
import com.sas.wadmin.visuals.DBMSConnectWizardTab;
import com.sas.wadmin.visuals.DBMSImporter;
import com.sas.wadmin.visuals.DefineTablesWizardTab;
import com.sas.wadmin.visuals.HawqImporter;
import com.sas.wadmin.visuals.HiveImporter;
import com.sas.wadmin.visuals.ImpalaImporter;
import com.sas.wadmin.visuals.JDBCImporter;
import com.sas.wadmin.visuals.JSONImporter;
import com.sas.wadmin.visuals.LasrAnalyticImporter;
import com.sas.wadmin.visuals.LasrHdatImporter;
import com.sas.wadmin.visuals.MongoDBImporter;
import com.sas.wadmin.visuals.OTHERImporter;
import com.sas.wadmin.visuals.PiImporter;
import com.sas.wadmin.visuals.RedshiftImporter;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.wadmin.visuals.SASShareImporter;
import com.sas.wadmin.visuals.SPDEImporter;
import com.sas.wadmin.visuals.SalesforceImporter;
import com.sas.wadmin.visuals.SnowflakeImporter;
import com.sas.wadmin.visuals.SparkImporter;
import com.sas.wadmin.visuals.XMLImporter;
import com.sas.wadmin.visuals.XMLV2Importer;
import com.sas.wadmin.visuals.YellowbrickImporter;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class EngineDesigner
extends AbstractDesigner {
    private static WAdminResource bundle = WAdminResource.getBundle(EngineDesigner.class);
    protected WATransitionWizardModel m_wizardModel;
    protected SASLibrary m_library;
    protected String m_engineType;
    protected SourceDesignerInterface m_plugin;
    protected String m_errmsg;

    public EngineDesigner(Frame frame, String title, SASLibrary library) {
        this(frame, title, library, true);
    }

    public EngineDesigner(Frame frame, String title, SASLibrary library, boolean useSMCPluginLoading) {
        super(frame, title);
        try {
            this.setResizable(true);
            this.m_errmsg = null;
            this.m_library = library;
            this.m_engineType = library.getEngine();
            this.m_wizardModel = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)this.m_wizardModel);
            this.setHelpProduct(DEFAULT_HELP_PRODUCT);
            this.addWizardData("DEFAULTTREEROLE", "SourceTables");
            this.m_plugin = this.findPluginForEngine(useSMCPluginLoading);
            if (this.m_plugin != null) {
                this.m_plugin.setUseEngineType(true);
                this.addWizardData("SELECTEDLIBRARY", library);
                Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("LibraryConnectPanel.LastLibrarySelected", library.getFQID());
                this.m_plugin.initializeWizard((WAWizardDialog)this, this.m_wizardModel);
                this.m_plugin.setTabProperty(1, DBMSConnectWizardTab.LIBRARYPANEL_EDITABLE, Boolean.FALSE);
                this.m_plugin.setTabProperty(1, DBMSConnectWizardTab.HELP_PRODUCT, DEFAULT_HELP_PRODUCT);
                this.m_plugin.setTabProperty(2, DefineTablesWizardTab.HELP_PRODUCT, DEFAULT_HELP_PRODUCT);
            } else if (this.m_errmsg != null) {
                MessageUtil.displayMessage((String)this.m_errmsg);
            } else {
                MessageUtil.displayMessage((String)bundle.formatString("EngineDesigner.NoDesigner.Message.fmt.txt", (Object)this.m_engineType));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void show() {
        if (this.m_plugin != null) {
            super.show();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected SourceDesignerInterface findPluginForEngine(boolean useSMCPluginLoading) {
        if (this.m_engineType.equalsIgnoreCase("ODBC") || this.m_engineType.equalsIgnoreCase("DB2") || this.m_engineType.equalsIgnoreCase("OLEDB")) {
            try {
                if (this.m_library.getLibraryConnection() == null) ** GOTO lbl20
                this.m_engineType = this.m_library.getLibraryConnection().getSource().getProductName();
            }
            catch (MdException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
                return null;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else if (this.m_engineType.equalsIgnoreCase("BASE") || this.m_engineType.startsWith("V7") || this.m_engineType.equalsIgnoreCase("V8") || this.m_engineType.equalsIgnoreCase("V9")) {
            this.m_engineType = "SAS";
        } else if (this.m_engineType.equalsIgnoreCase("XML")) {
            this.m_engineType = LibraryUtil.getXMLProductName((SASLibrary)this.m_library);
        } else if (this.m_engineType.equalsIgnoreCase("XMLV2")) {
            this.m_engineType = LibraryUtil.getXMLV2ProductName((SASLibrary)this.m_library);
        }
lbl20:
        // 8 sources

        this.addWizardData("ENGINETYPE", this.m_engineType);
        shareFound = false;
        try {
            deployedComponentList = this.m_library.getDeployedComponents();
            for (i = 0; i < deployedComponentList.size(); ++i) {
                dc = (DeployedComponent)deployedComponentList.get(i);
                identifier = dc.getClassIdentifier();
                if (!"SHARE".equalsIgnoreCase(identifier)) continue;
                shareFound = true;
            }
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (shareFound) {
            this.m_errmsg = EngineDesigner.bundle.getString("EngineDesigner.Share.Message.txt");
            return null;
        }
        plugin = new SASImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new DBMSImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            try {
                if (!this.isGenericLibrary(this.m_library)) {
                    this.updateWizardDataForDBMS();
                    ((DBMSImporter)plugin).updateEngineName((WAWizardDialog)this);
                    return plugin;
                }
            }
            catch (MdException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
                return null;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if ((plugin = new XMLV2Importer()).isEngineSupported(this.m_engineType)) {
            this.updateWizardDataForDBMS();
            return plugin;
        }
        plugin = new XMLImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            this.updateWizardDataForDBMS();
            return plugin;
        }
        plugin = new JSONImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            this.updateWizardDataForDBMS();
            return plugin;
        }
        plugin = new SASShareImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new HiveImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new ImpalaImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new PiImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new HawqImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new RedshiftImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new JDBCImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new LasrAnalyticImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new LasrHdatImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new CASImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new MongoDBImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new SalesforceImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new SnowflakeImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new BigQueryImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new YellowbrickImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new SparkImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            return plugin;
        }
        plugin = new SPDEImporter();
        if (plugin.isEngineSupported(this.m_engineType)) {
            this.addWizardData("SELECTEDNODE", EngineDesigner.bundle.getString("SPDEImporter.Name.SPDE.notrans"));
            return plugin;
        }
        try {
            if (this.isGenericLibrary(this.m_library)) {
                plugin = new OTHERImporter();
                return plugin;
            }
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        plugins = new ArrayList<E>();
        pl = null;
        if (useSMCPluginLoading) {
            pluginDirs = new ArrayList<String>();
            userPluginsDir = Workspace.getWorkspace().getPluginsDir();
            if (userPluginsDir != null) {
                pluginDirs.add(userPluginsDir);
            } else {
                pluginDirs.add(System.getProperty("user.dir") + System.getProperty("file.separator") + "plugins");
            }
            pl = null;
            try {
                pl = new PluginLoader(pluginDirs);
            }
            catch (InvalidPluginDirectoryException exc) {
                Workspace.getDefaultLogger().error((Object)"InvalidPluginDirectoryException", (Throwable)exc);
            }
            pl.initializePlugins();
        } else {
            pl = Workspace.getWorkspace().getPluginLoader();
        }
        if (pl != null) {
            plugins.addAll(pl.getPlugins("com.sas.wadmin.plugins.SourceDesignerInterface"));
        }
        for (i = 0; i < plugins.size(); ++i) {
            currentPlugin = (SourceDesignerInterface)plugins.get(i);
            if (!currentPlugin.isEngineSupported(this.m_engineType)) continue;
            return currentPlugin;
        }
        plugin = new OTHERImporter();
        return plugin;
    }

    private boolean isGenericLibrary(SASLibrary lib) throws RemoteException, MdException {
        String name;
        Prototype proto;
        boolean generic = false;
        if (lib != null && (proto = (Prototype)lib.getUsingPrototype()) != null && ("Library.Generic.Prototype.Name.xmlKey.txt".equalsIgnoreCase(name = proto.getName()) || "Generic Library".equalsIgnoreCase(name))) {
            generic = true;
        }
        return generic;
    }

    protected void updateWizardDataForDBMS() {
        if (this.m_engineType.equalsIgnoreCase("DB2OS390")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.DB2OS390.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("DB2UNXPC")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.DB2UNXPC.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("SQLSVR")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.SQLSVR.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("SYBASE")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.SYBASE.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("TERADATA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.TERADATA.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCOTHER")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCOTHER.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCACCESS")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCACCESS.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCDB2OS390")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCDB2OS390.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCDB2UNXPC")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCDB2UNXPC.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCEXCEL")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCEXCEL.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCINFORMIX")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCINFORMIX.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCORACLE")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCORACLE.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCSYBASE")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCSYBASE.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCTERADATA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCTERADATA.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("ODBCSQLSVRPC")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.ODBCSQLSVRPC.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("SASSPDS")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.SASSPDS.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("EXCEL")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.EXCEL.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("INFORMIX")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.INFORMIX.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("MYSQL")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.MYSQL.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBOTHER")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBOTHER.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBACCESS")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBACCESS.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBDB2OS390")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBDB2OS390.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBDB2UNXPC")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBDB2UNXPC.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBEXCEL")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBEXCEL.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBINFORMIX")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBINFORMIX.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBORACLE")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBORACLE.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBSQLSVRPC")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBSQLSVRPC.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBSYBASE")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBSYBASE.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBTERADATA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBTERADATA.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLALL.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLALL.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLCDISC.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLCDISC.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLACCESS.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLACCESS.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLORACLE.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLORACLE.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLV2ALL.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLV2ALL.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("XMLImporter.Name.XMLV2XMLMAP.txt"));
        } else if (this.m_engineType.equalsIgnoreCase(bundle.getString("JSONImporter.description.JSON.notrans"))) {
            this.addWizardData("SELECTEDNODE", bundle.getString("JSONImporter.Name.JSON.txt"));
        } else if (this.m_engineType.equalsIgnoreCase("NEOVIEW")) {
            this.addWizardData("SELECTEDNODE", "NEOVIEW");
        } else if (this.m_engineType.equalsIgnoreCase("NETEZZA")) {
            this.addWizardData("SELECTEDNODE", "NETEZZA");
        } else if (this.m_engineType.equalsIgnoreCase("ASTER")) {
            this.addWizardData("SELECTEDNODE", "ASTER");
        } else if (this.m_engineType.equalsIgnoreCase("SYBASEIQ")) {
            this.addWizardData("SELECTEDNODE", "SYBASE IQ");
        } else if (this.m_engineType.equalsIgnoreCase("GREENPLM")) {
            this.addWizardData("SELECTEDNODE", "GREENPLUM");
        } else if (this.m_engineType.equalsIgnoreCase("FEDSVR")) {
            this.addWizardData("SELECTEDNODE", "SAS FEDERATION SERVER");
        } else if (this.m_engineType.equalsIgnoreCase("POSTGRES")) {
            this.addWizardData("SELECTEDNODE", "POSTGRES");
        } else if (this.m_engineType.equalsIgnoreCase("SASIOHNA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.SAPHANA.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("VERTICA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.VERTICA.notrans"));
        } else if (this.m_engineType.equalsIgnoreCase("SASIOLA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("LasrAnalyticImporter.pluginname.txt"));
        } else if (this.m_engineType.equalsIgnoreCase("CAS")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("LasrAnalyticImporter.pluginname.txt"));
        } else if (this.m_engineType.equalsIgnoreCase("SASHDAT")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("CASImporter.pluginname.txt"));
        } else if (this.m_engineType.equalsIgnoreCase("OLEDBNETEZZA")) {
            this.addWizardData("SELECTEDNODE", bundle.getString("DBMSImporter.Name.OLEDBNETEZZA.notrans"));
        }
    }
}

