/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.UniqueKey;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.services.information.metadata.PathUrl;
import com.sas.wadmin.visuals.TablePanel;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.PhysicalTableUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsMessagesPropertyTab;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefineTablesWizardTab
extends WsDescriptionWizardTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DefineTablesWizardTab.class);
    protected static String HELP_PRODUCT;
    protected static String DBMSVIEW;
    protected String m_memLabel;
    protected String m_memType;
    protected String m_DBMSMemType;
    private String m_strEngine;
    protected String m_strCompress;
    protected String m_strEncrypt;
    protected String productName;
    protected String sqlString;
    protected String strLibRef;
    protected String tableTrimName;
    protected String strID;
    protected String strConnectionOptions;
    protected String strSchema;
    protected StringBuffer sqlSBuffer;
    protected StringBuffer sqlSBuffer2;
    protected LogListHolder m_logLinesHolder;
    protected TablePanel m_appPanel;
    protected WsAppServer myAppServer;
    private WsMessagesPropertyTab msgWindow;
    protected WAWizardDialog myParent;
    protected boolean m_DB2MVS;
    protected boolean m_AppServerException;
    protected boolean m_nonSASerror;
    protected boolean hasColumns;
    protected boolean[] aHasColumns;
    protected boolean m_PrimaryKeyError;
    protected boolean m_ForeignKeyError;
    protected boolean m_ColumnsError;
    protected boolean m_IndexError;
    protected boolean fDone;
    protected boolean bUserCanceled;
    protected boolean bSafeToQuit;
    protected boolean m_bFirstTime;
    protected int iNumTablesSelected;
    protected MdObjectStore store;
    protected PhysicalTable newTable;
    protected ArrayList newColumnNames;
    protected ArrayList newTables;
    protected ArrayList newTablesNames;
    protected Object[] tableList;
    protected ArrayList newlyCreatedTableNames;
    private List<String> errorTables;
    protected WATextField m_txtLocation;
    protected Tree m_selectedTree;
    protected PathUrl m_pathUrl;

    public DefineTablesWizardTab() {
        String sDescription = bundle.getString("DefineTablesWizardTab.Description.txt");
        this.setDescription(sDescription);
        this.init();
    }

    public void init() {
        HELP_PRODUCT = "HelpProduct";
        this.m_strEngine = "BASE";
        this.productName = "";
        this.m_DB2MVS = false;
        this.m_AppServerException = false;
        this.m_nonSASerror = false;
        this.m_ColumnsError = false;
        this.bUserCanceled = false;
        this.m_bFirstTime = true;
        this.m_appPanel = new TablePanel(true);
        this.msgWindow = WsMessagesPropertyTab.getInstance();
        this.setHelpProduct(AbstractDesigner.DEFAULT_HELP_PRODUCT);
        this.setHelpTopic("select_tables_win");
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel locPanel = this.createFolderSelectionPanel();
        this.add(locPanel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    protected JPanel createFolderSelectionPanel() {
        this.m_txtLocation = new WATextField();
        this.m_txtLocation.setBehavior(0);
        this.m_txtLocation.setEditable(false);
        this.m_txtLocation.setMaxCharacters(256);
        this.m_txtLocation.setToolTipText(bundle.getString("DefineTablesWizardTab.FolderLocation.Label.ToolTip.txt"));
        JLabel lbLocation = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtLocation, (String)bundle.getString("DefineTablesWizardTab.FolderLocation.Label.txt"));
        JButton btnLocation = WsUIUtilities.createTextButton((WsAbstractAction)new cSelectLocationAction());
        JPanel locPanel = new JPanel();
        BorderLayout locLayout = new BorderLayout();
        locPanel.setLayout(locLayout);
        locPanel.add((Component)lbLocation, "West");
        locPanel.add((Component)this.m_txtLocation, "Center");
        locPanel.add((Component)btnLocation, "East");
        locLayout.setHgap(5);
        return locPanel;
    }

    public void initializeFolderLocation() {
        this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
        Tree tree = (Tree)this.myParent.getWizardData("GROUP");
        try {
            if (tree == null) {
                this.store = (MdObjectStore)this.myParent.getWizardData("OBJECTSTORE");
                if (this.store != null) {
                    tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)this.store);
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (tree != null) {
            String sPath = this.getPathFromTree(tree);
            this.m_txtLocation.setText(sPath);
            this.m_selectedTree = tree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPathFromTree(Tree tree) {
        String sPath = "";
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            ChildServerInterface transaction = server.newChild(true);
            sPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)tree.getObjectStore(), (PrimaryType)tree, false);
            String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)tree.getObjectStore(), (PrimaryType)tree, true);
            try {
                this.m_pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)transaction, (String)sPathWithType);
                sPath = this.m_pathUrl.getDisplayPath();
            }
            finally {
                transaction.destroy();
            }
            return sPath;
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        return sPath;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.handleRead();
            if (this.m_bFirstTime) {
                this.initializeFolderLocation();
                this.m_bFirstTime = false;
            }
        } else {
            this.m_appPanel.doDataExchange(bSaveToModel);
            OpRequestUI myRequest = new OpRequestUI(bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"));
            myRequest.setTitle(bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
            cRunnableMethod runMethod = new cRunnableMethod();
            myRequest.execute((Runnable)runMethod);
            if (!Workspace.useProcMetalibChanges()) {
                if (this.m_AppServerException || this.m_nonSASerror || this.m_PrimaryKeyError || this.m_ForeignKeyError || this.m_ColumnsError || this.m_IndexError) {
                    String sMessage = bundle.getString("DefineTablesWizardTab.Appserver.Error.txt");
                    this.showSASLog(sMessage);
                }
            } else {
                this.showSASLog2();
            }
            Workspace.getDefaultLogger().debug((Object)"Error Log", this.getBufferFromLogLines().toString());
            if (this.myAppServer != null) {
                try {
                    Workspace.getDefaultLogger().debug((Object)this.myAppServer.getLogBuffer());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myAppServer.dispose();
            }
        }
        return true;
    }

    private StringBuffer getBufferFromLogLines() {
        StringBuffer log = new StringBuffer();
        if (this.m_logLinesHolder != null) {
            String[] lines = this.m_logLinesHolder.getLineArray();
            for (int i = 0; i < lines.length; ++i) {
                log.append(lines[i]);
            }
        }
        return log;
    }

    public boolean validateData() {
        if (this.m_appPanel.getSelectedList().length < 1) {
            MessageUtil.displayMessage((String)bundle.getString("TablePanel.SelectTable.Error.txt"), (int)0);
            return false;
        }
        if (this.m_selectedTree == null) {
            MessageUtil.displayMessage((String)bundle.getString("DefineTablesWizardTab.Error.NoFolder.txt"), (int)0);
            return false;
        }
        this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
        this.myParent.addWizardData("GROUP", (Object)this.m_selectedTree);
        return true;
    }

    public void onNext() {
        if (!this.validateData()) {
            return;
        }
        try {
            this.m_appPanel.doDataExchange(true);
            super.onNext();
        }
        catch (Exception e) {
            this.msgWindow.addMessage(e.getMessage() + "\n");
            Workspace.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
            this.m_nonSASerror = true;
        }
    }

    public String createFinishString() {
        this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
        String temp = "";
        Tree groupTree = (Tree)this.myParent.getWizardData("GROUP");
        if (groupTree != null) {
            temp = temp + bundle.formatString("DefineTablesWizardTab.finishinfo.txt", (Object)this.getPathFromTree(groupTree));
        }
        temp = temp + bundle.getString("DefineTablesWizardTab.coloninfo.txt") + "\n\n";
        this.tableList = this.m_appPanel.getTableList();
        this.iNumTablesSelected = this.tableList.length;
        for (int i = 0; i < this.iNumTablesSelected; ++i) {
            temp = i != this.iNumTablesSelected - 1 ? temp + ((String)this.tableList[i]).trim() + ", " : temp + ((String)this.tableList[i]).trim();
        }
        return temp;
    }

    protected String stripTableName(String strInName) {
        String temp2;
        int j;
        String strOutName = null;
        for (j = strInName.length(); j > 0 && (temp2 = String.valueOf(strInName.charAt(j - 1))).equals(" "); --j) {
        }
        strOutName = strInName.substring(0, j);
        return strOutName;
    }

    protected void handleRead() {
        this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
        this.myParent.setCursor(Cursor.getPredefinedCursor(3));
        DefaultListModel model = this.m_appPanel.getListModel();
        model.clear();
        MVAResultSet mytablelist = (MVAResultSet)this.myParent.getWizardData("MVARESULT");
        String value = "";
        this.fDone = true;
        while (this.fDone) {
            try {
                value = mytablelist.getString(1);
                model.addElement(value);
                this.fDone = mytablelist.next();
            }
            catch (SQLException e) {
                this.fDone = false;
                this.msgWindow.addMessage(e.getMessage() + "\n");
                Workspace.getDefaultLogger().debug((Object)"SQLException", (Throwable)e);
                this.m_nonSASerror = true;
                return;
            }
        }
        try {
            this.m_appPanel.doDataExchange(false);
        }
        catch (MdException e) {
            this.msgWindow.addMessage(e.getMessage() + "\n");
            Workspace.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
            this.m_nonSASerror = true;
            return;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.myParent.setCursor(null);
    }

    public void setEngine(String strEngine) {
        this.m_strEngine = strEngine;
    }

    public LogListHolder getLogLinesHolder() {
        return this.m_logLinesHolder;
    }

    protected void clearLog() {
        this.m_logLinesHolder = new LogListHolder(new String[0], new Integer[0]);
    }

    protected void addLogLine(String line, int type, String label) {
        this.addLogLine(line, new Integer(type), label);
    }

    protected void addLogLine(String line, Integer type, String label) {
        ArrayList<LineType> lstLineTypes;
        String[] lines = null;
        LineType[] lineTypes = null;
        if (this.m_logLinesHolder != null) {
            lines = this.m_logLinesHolder.getLineArray();
            lineTypes = this.m_logLinesHolder.getLineTypes();
        }
        ArrayList<String> lstLines = lines != null ? new ArrayList<String>(Arrays.asList(lines)) : new ArrayList();
        ArrayList<Object> arrayList = lstLineTypes = lineTypes != null ? new ArrayList<LineType>(Arrays.asList(lineTypes)) : new ArrayList();
        if (label != null && label.length() > 0) {
            line = label + " " + line;
        }
        lstLines.add(line);
        lstLineTypes.add((LineType)type);
        String[] arrayLines = lstLines.toArray(new String[lstLines.size()]);
        Integer[] arrayTypes = new Integer[lstLineTypes.size()];
        for (int i = 0; i < lstLineTypes.size(); ++i) {
            Object value = lstLineTypes.get(i);
            arrayTypes[i] = value instanceof Integer ? (Integer)lstLineTypes.get(i) : new Integer(((LineType)lstLineTypes.get(i)).value());
        }
        this.m_logLinesHolder = new LogListHolder(arrayLines, arrayTypes);
        this.msgWindow.addMessage(line);
    }

    protected void addLogLines(LogListHolder logHolder) {
        int i;
        StringBuffer logBuffer = new StringBuffer();
        LineType[] logTypes = logHolder.getLineTypes();
        String[] logLines = logHolder.getLineArray();
        for (i = 0; i < logLines.length; ++i) {
            logBuffer.append(logLines[i]).append("\n");
        }
        for (i = 0; i < logLines.length; ++i) {
            this.addLogLine(logLines[i], new Integer(logTypes[i].value()), "");
        }
        Workspace.getDefaultLogger().error((Object)logBuffer.toString());
    }

    protected void addTableStartRegistrationLogLine() {
        this.addLogLine(bundle.formatString("DefineTablesWizardTab.StartTableRegistration.txt", (Object)(this.strLibRef + "." + this.tableTrimName)), 1, "NOTE:");
    }

    protected void addTableEndRegistrationLogLine() {
        this.addLogLine(bundle.formatString("DefineTablesWizardTab.EndTableRegistration.txt", (Object)(this.strLibRef + "." + this.tableTrimName)), 1, "NOTE:");
    }

    protected void addBlankLogLine() {
        this.addLogLine("", 4, "");
    }

    protected void getTableAttributes() throws SQLException, WsAppServerCodeException, WsAppServerFailException {
        this.m_memType = "";
        this.m_memLabel = "";
        this.m_strCompress = "NO";
        this.m_strEncrypt = "NO";
        this.sqlSBuffer = new StringBuffer();
        this.sqlSBuffer.append("PROC SQL; ").append("CREATE TABLE work._memTypes AS \n").append("Select MEMTYPE, MEMLABEL, COMPRESS, ENCRYPT, DBMS_MEMTYPE from dictionary.tables where libname=\"").append(this.strLibRef.toUpperCase()).append("\" and memname=\"").append(this.tableTrimName).append("\" and MEMTYPE in (\"DATA\", \"VIEW\");").append("; quit;");
        this.myAppServer.submitSASCode(this.sqlSBuffer.toString());
        MVAResultSet mySelectedTable = this.myAppServer.getTable("WORK", "_memTypes", null, null, null);
        if (mySelectedTable.next()) {
            this.m_memType = mySelectedTable.getString(1).trim();
            this.m_memLabel = mySelectedTable.getString(2).trim();
            this.m_strCompress = mySelectedTable.getString(3).trim();
            this.m_strEncrypt = mySelectedTable.getString(4).trim();
            this.m_DBMSMemType = mySelectedTable.getString(5).trim();
        }
        mySelectedTable.close();
    }

    public static UniqueKey getPrimaryKey(PhysicalTable physicalTable) throws MdException, RemoteException {
        AssociationList uniqueKeys = physicalTable.getUniqueKeys();
        if (uniqueKeys != null) {
            for (int u = 0; u < uniqueKeys.size(); ++u) {
                UniqueKey uniqueKey = (UniqueKey)uniqueKeys.get(u);
                int isPrimary = uniqueKey.getIsPrimary();
                if (isPrimary != 1) continue;
                return uniqueKey;
            }
        }
        return null;
    }

    public static Column getColumn(PhysicalTable physicalTable, String columnName) throws MdException, RemoteException {
        AssociationList columns = physicalTable.getColumns();
        if (columns != null) {
            for (int c = 0; c < columns.size(); ++c) {
                Column column = (Column)columns.get(c);
                if (!column.getName().equals(columnName)) continue;
                return column;
            }
        }
        return null;
    }

    public void registerTables() {
        this.clearLog();
        this.bSafeToQuit = false;
        try {
            CMetadata repos;
            this.tableList = this.m_appPanel.getTableList();
            this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
            this.strLibRef = (String)this.myParent.getWizardData("RIOLIBREF");
            this.myAppServer = (WsAppServer)this.myParent.getWizardData("AppServer");
            SASLibrary myLibrary = (SASLibrary)this.myParent.getWizardData("SELECTEDLIBRARY");
            RelationalSchema mySchema = (RelationalSchema)this.myParent.getWizardData("SCHEMA");
            if (mySchema instanceof DatabaseSchema) {
                this.strConnectionOptions = LibraryUtil.getConnectionOptions((SASLibrary)myLibrary);
                this.strSchema = ((DatabaseSchema)mySchema).getSchemaName();
            }
            int iIsDBMSLibrary = myLibrary.getIsDBMSLibname();
            this.strID = new String();
            if (this.m_selectedTree != null) {
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    repos = Workspace.getWorkspace().getDefaultRepository();
                    this.strID = repos.getFQID().substring(9, 17);
                } else {
                    this.strID = this.m_selectedTree.getRepositoryID();
                }
            } else {
                repos = (CMetadata)this.myParent.getWizardData("REPOSITORY");
                this.strID = repos.getFQID().substring(9, 17);
            }
            this.store = (MdObjectStore)this.myParent.getWizardData("OBJECTSTORE");
            this.newTables = new ArrayList();
            this.newTablesNames = new ArrayList();
            this.productName = (String)this.myParent.getWizardData("ENGINETYPE");
            if (this.productName == null) {
                this.productName = this.m_strEngine;
            }
            Vector<Transformation> infoMapsInFolder = new Vector<Transformation>(1);
            if (this.productName.equalsIgnoreCase("SASIOIME")) {
                String strMappath = null;
                try {
                    AssociationList propertyList = myLibrary.getProperties();
                    for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                        Property property = (Property)propertyList.get(propIndex);
                        if (!property.getPropertyName().trim().equalsIgnoreCase("MAPPATH")) continue;
                        strMappath = property.getDefaultValue().replace("\"", "");
                        break;
                    }
                    if (strMappath != null) {
                        Tree tree = null;
                        ServerInterface authServer = Workspace.getWorkspace().getUserContext().getAuthServer();
                        ChildServerInterface transaction = authServer.newChild(true);
                        String sPathWithType = strMappath + "(Folder)";
                        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)transaction, (String)sPathWithType);
                        MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                        if (metadataObject != null) {
                            tree = (Tree)metadataObject.getRepositoryEntity();
                        }
                        if (tree != null) {
                            AssociationList membersInFolder = tree.getMembers(true);
                            for (int index = 0; index < membersInFolder.size(); ++index) {
                                Transformation trans;
                                Object obj = membersInFolder.get(index);
                                if (!(obj instanceof Transformation) || !(trans = (Transformation)obj).getPublicType().startsWith("InformationMap")) continue;
                                infoMapsInFolder.add(trans);
                            }
                        } else {
                            Workspace.getDefaultLogger().debug((Object)"InformationMap folder (Tree) not found.");
                        }
                    } else {
                        Workspace.getDefaultLogger().debug((Object)"Required library property MAPPATH not found.");
                    }
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                }
                catch (MdException mde) {
                    Workspace.getDefaultLogger().error((Object)mde.getLocalizedMessage());
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
            }
            this.aHasColumns = new boolean[this.iNumTablesSelected];
            for (int i = 0; i < this.iNumTablesSelected; ++i) {
                try {
                    String msg;
                    this.tableTrimName = ((String)this.tableList[i]).trim();
                    this.addLogLine(bundle.formatString("DefineTablesWizardTab.StartTableRegistration.txt", (Object)(this.strLibRef + "." + this.tableTrimName)), 8, "NOTE:");
                    if (!WsMetadataNameUtil.isNameUniqueInFolder((String)this.tableTrimName, (Tree)this.m_selectedTree, (String)"Table")) {
                        this.m_nonSASerror = true;
                        msg = bundle.formatString("DefineTablesWizardTab.DuplicateTableName.txt", (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                        this.addTableEndRegistrationLogLine();
                        continue;
                    }
                    this.newTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.store, this.tableTrimName, "PhysicalTable", this.strID);
                    this.newTable.setPublicType("Table");
                    this.newTable.setUsageVersion(OMRPhysicalTable.CURRENT_VERSION.encode());
                    WsMetadataUtil.updateModifiedByFor((Root)this.newTable);
                    this.newTables.add(this.newTable);
                    this.newTablesNames.add(this.tableTrimName);
                    if (this.productName.equalsIgnoreCase("SASIOIME")) {
                        Transformation mapMatch = null;
                        for (int count = 0; count < infoMapsInFolder.size(); ++count) {
                            Transformation map = (Transformation)infoMapsInFolder.get(count);
                            if (!map.getName().equals(this.tableTrimName)) continue;
                            mapMatch = map;
                            break;
                        }
                        if (mapMatch != null) {
                            this.newTable.getTargetTransformations().add(mapMatch);
                            Workspace.getDefaultLogger().debug((Object)("Associated InformationMap <" + mapMatch.getName() + "; " + mapMatch.getFQID() + "> with new table <" + this.tableTrimName + "; " + this.newTable.getFQID() + ">"));
                        } else {
                            this.newTables.remove(this.newTable);
                            this.newTablesNames.remove(this.tableTrimName);
                            this.store.removeObjectFromStore((CMetadata)this.newTable, null);
                            this.m_nonSASerror = true;
                            String msg2 = bundle.formatString("DefineTablesWizardTab.IMLE.NoInfoMapFound.Error.fmt.txt", (Object)(this.strLibRef + "." + this.tableTrimName));
                            Workspace.getDefaultLogger().error((Object)msg2);
                            this.addLogLine(msg2, 6, "ERROR:");
                            this.addTableEndRegistrationLogLine();
                            continue;
                        }
                    }
                    this.myParent.setMasterObject((CMetadata)this.newTable);
                    if (this.m_strEngine.startsWith("DB2")) {
                        if (this.m_strEngine.startsWith("DB2OS")) {
                            this.m_DB2MVS = true;
                        }
                        this.m_strEngine = "DB2";
                    } else if (this.m_strEngine.startsWith("ODBC")) {
                        this.m_strEngine = "ODBC";
                    }
                    if (this.m_selectedTree != null) {
                        this.newTable.getTrees().add((Object)this.m_selectedTree);
                    }
                    this.newTable.setIsCompressed(0);
                    this.newTable.setIsEncrypted(0);
                    this.newTable.setSASTableName(this.tableTrimName);
                    this.newTable.setTableName(this.tableTrimName);
                    this.newTable.setName(this.tableTrimName);
                    this.newTable.setNumRows(-1.0);
                    this.newTable.getTablePackages().add((Object)mySchema);
                    DBMSNamesPropertyHandler.createDBMSNamesPropertySet((Root)this.newTable, (String)((String)this.myParent.getWizardData("Case")), (String)((String)this.myParent.getWizardData("SpecChar")));
                    this.getTableAttributes();
                    this.newTable.setDesc(this.m_memLabel);
                    this.newTable.setMemberType(this.m_memType);
                    if (iIsDBMSLibrary == 1 && DBMSVIEW.equalsIgnoreCase(this.m_DBMSMemType)) {
                        this.newTable.setMemberType(this.m_DBMSMemType);
                        this.newTable.setIsDBMSView(1);
                    }
                    PhysicalTableUtil.setAttributeOptions((PhysicalTable)this.newTable, (boolean)"YES".equals(this.m_strEncrypt), (String)this.m_strCompress);
                    this.sqlSBuffer = new StringBuffer();
                    this.createColumnMetadata();
                    this.aHasColumns[i] = this.hasColumns;
                    if (this.hasColumns) {
                        if (!this.productName.equalsIgnoreCase("SYBASE") || this.newTable.getIsDBMSView() != 1) {
                            this.createIndexMetadata();
                        }
                        if (!this.productName.equalsIgnoreCase("SYBASE") || this.newTable.getIsDBMSView() != 1) {
                            this.createPrimaryKeyMetadata();
                        }
                    } else {
                        this.m_ColumnsError = true;
                        msg = bundle.formatString("DefineTablesWizardTab.NoColumns.fmt.txt", (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                    }
                    this.addTableEndRegistrationLogLine();
                    if (i != this.iNumTablesSelected - 1) {
                        this.newTable.updateMetadataAll();
                    }
                    if (!this.bUserCanceled) continue;
                    this.bSafeToQuit = true;
                    return;
                }
                catch (WsAppServerCodeException codeExcp) {
                    this.m_AppServerException = true;
                    Workspace.getDefaultLogger().error((Object)"WsAppServerCodeException", (Throwable)codeExcp);
                    if (this.myAppServer == null) continue;
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                        this.addTableEndRegistrationLogLine();
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                    continue;
                }
                catch (WsAppServerFailException codeExcp) {
                    this.m_AppServerException = true;
                    Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)codeExcp);
                    if (this.myAppServer == null) continue;
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                        this.addTableEndRegistrationLogLine();
                        continue;
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
            }
            this.createForeignKeyMetadata();
        }
        catch (SQLException se) {
            String msg = bundle.formatString("DefineTablesWizardTab.SQLexcp.Error.txt", (Object)this.tableTrimName);
            Workspace.getDefaultLogger().debug((Object)msg);
            Workspace.getDefaultLogger().debug((Object)"SQLException", (Throwable)se);
            this.m_nonSASerror = true;
            this.addLogLine(msg, 6, "ERROR:");
            this.addLogLine(se.getLocalizedMessage(), 6, "ERROR:");
        }
        catch (MdException e) {
            String msg = bundle.formatString("DefineTablesWizardTab.Mdexcp.Error.txt", (Object)this.tableTrimName);
            Workspace.getDefaultLogger().debug((Object)msg);
            Workspace.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
            this.m_nonSASerror = true;
            this.addLogLine(msg, 6, "ERROR:");
            this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void registerTablesProcMetalib() {
        this.clearLog();
        this.bSafeToQuit = false;
        boolean b_createFormatsInformats = true;
        Boolean b_BoolCreateFormatsInformats = (Boolean)this.myParent.getWizardData("FormatsInformats");
        b_createFormatsInformats = b_BoolCreateFormatsInformats != null ? b_BoolCreateFormatsInformats : true;
        boolean isChangeManagementOn = Workspace.getWorkspace().isChangeManagementOn();
        try {
            boolean bNeedProject_Reposid;
            this.tableList = this.m_appPanel.getTableList();
            this.myParent = (WAWizardDialog)this.getTopLevelAncestor();
            this.strLibRef = (String)this.myParent.getWizardData("RIOLIBREF");
            this.myAppServer = (WsAppServer)this.myParent.getWizardData("AppServer");
            PasswordAuthentication pw = null;
            SASLibrary myLibrary = (SASLibrary)this.myParent.getWizardData("SELECTEDLIBRARY");
            String libid = myLibrary.getFQID();
            boolean isCredentialPromptRequired = false;
            try {
                isCredentialPromptRequired = LibraryUtil.requiresPromptForCrendentials((SASLibrary)myLibrary);
                if (isCredentialPromptRequired) {
                    pw = LibraryUtil.getPromptedCredentialsLibraryUserPass((SASLibrary)myLibrary);
                }
            }
            catch (MdException e2) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e2, (String)"Accessing");
            }
            catch (ServiceException e2) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e2);
            }
            this.strID = new String();
            String folderID = new String();
            String reposType = new String();
            if (this.m_selectedTree != null) {
                MdFactory factory = Workspace.getMdFactory();
                String strReposId = "A0000001." + this.m_selectedTree.getFQID().substring(0, 8);
                reposType = WsRepositoryUtil.getRepositoryType((MdFactory)factory, (String)strReposId);
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                    this.strID = repos.getFQID().substring(9, 17);
                    folderID = repos.getFQID();
                } else {
                    this.strID = this.m_selectedTree.getRepositoryID();
                    folderID = this.m_selectedTree.getFQID();
                }
            } else {
                CMetadata repos = (CMetadata)this.myParent.getWizardData("REPOSITORY");
                this.strID = repos.getFQID().substring(9, 17);
            }
            this.newTables = new ArrayList();
            this.newTablesNames = new ArrayList();
            this.newlyCreatedTableNames = new ArrayList();
            this.errorTables = new ArrayList<String>();
            StringBuffer selectCode = new StringBuffer();
            selectCode.append("   SELECT (");
            boolean success = true;
            int tableCount = 0;
            for (int i = 0; i < this.iNumTablesSelected; ++i) {
                this.tableTrimName = ((String)this.tableList[i]).trim();
                if (!WsMetadataNameUtil.isNameUniqueInFolder((String)this.tableTrimName, (Tree)this.m_selectedTree, (String)"Table")) {
                    this.m_nonSASerror = true;
                    String msg = bundle.formatString("DefineTablesWizardTab.DuplicateTableName.txt", (Object)this.tableTrimName);
                    Workspace.getDefaultLogger().debug((Object)msg);
                    this.addLogLine(msg, 6, "ERROR:");
                    this.addBlankLogLine();
                    this.errorTables.add(this.tableTrimName);
                    continue;
                }
                ++tableCount;
                selectCode.append("\"");
                selectCode.append(this.tableTrimName);
                selectCode.append("\"\n ");
            }
            if (tableCount == 0) {
                return;
            }
            selectCode.append(");\n");
            StringBuffer metalibCode = new StringBuffer();
            metalibCode.append("proc metalib");
            if (Workspace.useMetalibDebug()) {
                metalibCode.append(" tl=16383");
            }
            metalibCode.append("\n;");
            metalibCode.append("   omr (LIBURI=\"");
            metalibCode.append(libid);
            metalibCode.append("\"");
            String userName = Workspace.getWorkspace().getConnectionManager().getUser();
            String userPass = Workspace.getWorkspace().getConnectionManager().getPassword();
            if (userName != null && userPass != null && !userName.isEmpty() && !userPass.isEmpty()) {
                metalibCode.append("\n   user=\"").append(userName).append("\" password=\"").append(userPass).append("\"\n");
            }
            boolean bl = bNeedProject_Reposid = !this.m_selectedTree.getFQID().substring(0, 8).equals(libid.substring(0, 8)) || reposType.equalsIgnoreCase("CUSTOM");
            if (!b_createFormatsInformats || isChangeManagementOn || bNeedProject_Reposid) {
                metalibCode.append("      / ");
                if (!b_createFormatsInformats) {
                    metalibCode.append("FORMATS=NO");
                }
                if (isChangeManagementOn) {
                    String s_projectReposID = Workspace.getWorkspace().getProjectRepositoryId();
                    metalibCode.append(" project_reposid = \"").append(s_projectReposID).append("\"");
                } else if (bNeedProject_Reposid) {
                    metalibCode.append(" project_reposid = \"").append(folderID.substring(0, 8)).append("\"");
                }
            }
            metalibCode.append("   );\n");
            metalibCode.append("   REPORT(type = summary out = \"tab_info\");\n");
            if (pw != null && isCredentialPromptRequired) {
                metalibCode.append("   dbauth(dbuser=\"").append(pw.getUserName()).append("\"\n").append("          dbpassword=\"").append(pw.getPassword()).append("\");\n");
            }
            metalibCode.append(selectCode.toString());
            metalibCode.append("   FOLDERID = \"");
            metalibCode.append(this.m_selectedTree.getFQID());
            metalibCode.append("\";\n");
            metalibCode.append("run;");
            try {
                this.myAppServer.submitSASCode(metalibCode.toString());
            }
            catch (WsAppServerCodeException codeExcp) {
                this.m_AppServerException = true;
                Workspace.getDefaultLogger().error((Object)"WsAppServerCodeException", (Throwable)codeExcp);
                if (this.myAppServer != null) {
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            catch (WsAppServerFailException codeExcp) {
                this.m_AppServerException = true;
                Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)codeExcp);
                if (this.myAppServer != null) {
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            try {
                MVAResultSet tableInfo = this.myAppServer.getTable("WORK", "tab_info", null, null, null);
                this.fDone = true;
                while (tableInfo.next()) {
                    String tabName = tableInfo.getString(1).trim();
                    String tabFQID = tableInfo.getString(2).trim();
                    String tabSASName = tableInfo.getString(3).trim();
                    this.newlyCreatedTableNames.add(tabName);
                    PhysicalTable pt = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(this.store, tabName, "PhysicalTable", tabFQID);
                    DBMSNamesPropertyHandler.createDBMSNamesPropertySet((Root)pt, (String)((String)this.myParent.getWizardData("Case")), (String)((String)this.myParent.getWizardData("SpecChar")));
                    WsMetadataUtil.updateModifiedByFor((Root)pt);
                    pt.updateMetadataAll();
                }
                tableInfo.close();
            }
            catch (SQLException e) {
                Workspace.getDefaultLogger().debug((Object)"SQLException", (Throwable)e);
                this.m_nonSASerror = true;
                this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            catch (WsAppServerFailException e1) {
                this.m_AppServerException = true;
                Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)e1);
                if (this.myAppServer != null) {
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                    }
                    catch (Exception e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            catch (MdException e) {
                Workspace.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
                this.m_nonSASerror = true;
                this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                this.errorTables.add(this.tableTrimName);
                success = false;
            }
            this.newTablesNames.add(this.tableTrimName);
            if (null != this.myAppServer && this.myAppServer.isOpen() && success) {
                try {
                    this.addLogLines(this.myAppServer.getLog());
                }
                catch (WsAppServerFailException e) {
                    Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.addBlankLogLine();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void createColumnMetadata() throws WsAppServerCodeException, WsAppServerFailException {
        this.sqlSBuffer.append("PROC SQL; ").append("CREATE TABLE work._cols AS \n").append("Select NAME, TYPE, LENGTH, FORMAT, INFORMAT, LABEL, NOTNULL from dictionary.columns where libname=\"").append(this.strLibRef.toUpperCase()).append("\"\n and memname=\"").append(this.tableTrimName).append("\" and MEMTYPE in (\"DATA\", \"VIEW\");").append(" quit;");
        this.myAppServer.submitSASCode(this.sqlSBuffer.toString());
        MVAResultSet mycolumnlist = this.myAppServer.getTable("WORK", "_cols", null, null, null);
        this.newColumnNames = new ArrayList();
        this.fDone = true;
        this.hasColumns = false;
        boolean b_createFormatsInformats = true;
        Boolean b_BoolCreateFormatsInformats = (Boolean)this.myParent.getWizardData("FormatsInformats");
        b_createFormatsInformats = b_BoolCreateFormatsInformats != null ? b_BoolCreateFormatsInformats : true;
        try {
            while (mycolumnlist.next()) {
                if (!this.hasColumns) {
                    this.hasColumns = true;
                }
                String colName = mycolumnlist.getString(1).trim();
                Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.store, colName, "Column", this.strID);
                this.newTable.addElementToChangeList((CMetadata)newColumn);
                newColumn.setPublicType("Column");
                newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                newColumn.setSASColumnName(colName.toString());
                newColumn.setColumnName(colName.toString());
                String colType = mycolumnlist.getString(2);
                if (colType.equalsIgnoreCase("char")) {
                    newColumn.setSASColumnType("C");
                } else {
                    newColumn.setSASColumnType("N");
                }
                Double dbl = new Double(mycolumnlist.getDouble(3));
                int length = dbl.intValue();
                newColumn.setSASColumnLength(length);
                newColumn.setColumnLength(length);
                if (b_createFormatsInformats) {
                    String colFormat = mycolumnlist.getString(4);
                    newColumn.setSASFormat(colFormat);
                    String colInformat = mycolumnlist.getString(5);
                    newColumn.setSASInformat(colInformat);
                }
                String colLabel = mycolumnlist.getString(6);
                newColumn.setDesc(colLabel);
                String notNull = mycolumnlist.getString(7).trim();
                if (notNull.equalsIgnoreCase("NO")) {
                    newColumn.setIsNullable(1);
                } else {
                    newColumn.setIsNullable(0);
                }
                try {
                    this.newTable.getColumns().addElement((Object)newColumn);
                }
                catch (MdException e) {
                    String msg = bundle.formatString("DefineTablesWizardTab.ColExcp.Error.txt", (Object)this.tableTrimName);
                    Workspace.getDefaultLogger().debug((Object)msg);
                    Workspace.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
                    this.m_nonSASerror = true;
                    this.m_ColumnsError = true;
                    this.addLogLine(msg, 6, "ERROR:");
                    this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                this.newColumnNames.add(colName);
            }
            mycolumnlist.close();
        }
        catch (SQLException se) {
            String msg = bundle.formatString("DefineTablesWizardTab.SQLexcp.Error.txt", (Object)this.tableTrimName);
            Workspace.getDefaultLogger().debug((Object)msg);
            Workspace.getDefaultLogger().debug((Object)"SQLException", (Throwable)se);
            this.m_nonSASerror = true;
            this.addLogLine(msg, 6, "ERROR:");
            this.addLogLine(se.getLocalizedMessage(), 6, "ERROR:");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void createIndexMetadata() throws WsAppServerCodeException, WsAppServerFailException {
        this.m_IndexError = false;
        if (this.productName.indexOf("EXCEL") > -1 || this.productName.equalsIgnoreCase("OLEDBINFORMIX") || this.productName.equalsIgnoreCase("NETEZZA") || this.productName.equalsIgnoreCase("ASTER") || this.productName.equalsIgnoreCase("SYBASEIQ") || this.productName.equalsIgnoreCase("GREENPLM") || this.productName.equalsIgnoreCase("FEDSVR") || this.productName.equalsIgnoreCase("SASIOHNA") || this.productName.equalsIgnoreCase("VERTICA") || this.productName.equalsIgnoreCase("SASIOIMP") || this.productName.equalsIgnoreCase("SASIOPI") || this.productName.equalsIgnoreCase("SASIOHWQ") || this.productName.equalsIgnoreCase("SASIORST") || this.productName.equalsIgnoreCase("OLEDBNETEZZA")) {
            return;
        }
        try {
            String tableIndex = "";
            if (this.productName.indexOf("TERADATA") > -1) {
                tableIndex = "(index=(etls=(column_name seq_in_index)))";
            }
            this.sqlSBuffer = new StringBuffer();
            this.sqlSBuffer.append("PROC SQL; CONNECT TO ").append(this.m_strEngine).append("(").append(this.strConnectionOptions).append("); \n").append("  CREATE TABLE _Indexes").append(tableIndex).append(" AS \n").append("  SELECT COLUMN_NAME, INDEX_NAME, SEQ_IN_INDEX, UNIQUE, 0 as ISPRIMARY\n").append("      FROM CONNECTION TO ").append(this.m_strEngine).append("(DBMS::Indexes(\"");
            if (this.m_DB2MVS) {
                this.sqlSBuffer.append(this.strSchema);
            }
            this.sqlSBuffer.append("\",\"").append(this.strSchema).append("\",\"").append(this.tableTrimName).append("\"))\n").append("order by INDEX_NAME desc;\n").append("QUIT; \n");
            this.myAppServer.submitSASCode(this.sqlSBuffer.toString());
            Workspace.getDefaultLogger().debug((Object)this.sqlSBuffer);
            if (this.productName.indexOf("TERADATA") > -1 && this.productName.indexOf("OLEDB") == -1 && this.productName.indexOf("ODBC") == -1) {
                this.sqlSBuffer2 = new StringBuffer();
                this.sqlSBuffer2.append("PROC SQL; CONNECT TO ").append(this.m_strEngine).append("(").append(this.strConnectionOptions).append("); \n").append("  CREATE TABLE _PrimaryIndexes").append(tableIndex).append(" AS \n").append("  SELECT INDEX_NAME, COLUMN_NAME, KEY_SEQ as SEQ_IN_INDEX\n").append("      FROM CONNECTION TO ").append(this.m_strEngine).append("(DBMS::PrimaryIndexes(\"");
                this.sqlSBuffer2.append("\",\"").append(this.strSchema).append("\",\"").append(this.tableTrimName).append("\"))\n").append("order by INDEX_NAME desc;\n").append("QUIT; \n");
                this.myAppServer.submitSASCode(this.sqlSBuffer2.toString());
                Workspace.getDefaultLogger().debug((Object)this.sqlSBuffer2);
                StringBuffer mergeCode = new StringBuffer();
                mergeCode.append("data _Indexes;\n").append("   merge _indexes(in=ind) _primaryIndexes(in=inp);\n").append("   by column_name seq_in_index;\n").append("   if (inp) then\n ISPRIMARY = 1;\n").append("run;\n proc sort data=_Indexes; by descending INDEX_NAME ;run;");
                this.myAppServer.submitSASCode(mergeCode.toString());
                Workspace.getDefaultLogger().debug((Object)mergeCode);
            }
            int noNameIndex = 0;
            boolean isFirst = true;
            MVAResultSet myIndexList = this.myAppServer.getTable("WORK", "_Indexes", null, null, null);
            ArrayList<String> newIndexNames = new ArrayList<String>();
            this.fDone = true;
            String storedIndexName = "";
            try {
                ArrayList<String> badIndexNames = new ArrayList<String>();
                ArrayList<String> indexNames = new ArrayList<String>();
                while (myIndexList.next()) {
                    String colName = myIndexList.getString(1).trim();
                    boolean bl = isFirst = myIndexList.getInt(3) == 1;
                    if (colName.length() < 1) {
                        this.m_IndexError = true;
                        String msg = bundle.formatString("DefineTablesWizardTab.IndxBlankCol.fmt.txt", (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                        continue;
                    }
                    String indexName = myIndexList.getString(2).trim();
                    if (indexName.length() < 1) {
                        if (isFirst) {
                            ++noNameIndex;
                        }
                        indexName = this.getUniqueIndexName(indexNames, noNameIndex);
                        if (isFirst) {
                            String msg = bundle.formatString("DefineTablesWizardTab.IndxNameBlankRenamed.fmt.txt", (Object)this.tableTrimName, (Object)indexName);
                            Workspace.getDefaultLogger().debug((Object)msg);
                            this.addLogLine(msg, 7, "WARNING:");
                        }
                    }
                    indexNames.add(indexName);
                    Index newIndex = null;
                    int columnindex = this.newColumnNames.indexOf(colName);
                    if (columnindex < 0) {
                        this.m_IndexError = true;
                        String msg = bundle.formatString("DefineTablesWizardTab.IndxBadCol.fmt.txt", (Object)colName, (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                        if (badIndexNames.contains(indexName)) continue;
                        badIndexNames.add(indexName);
                        String badIndexMessage = bundle.formatString("DefineTablesWizardTab.UnableToAddIndex.fmt.txt", (Object)indexName);
                        Workspace.getDefaultLogger().debug((Object)badIndexMessage);
                        this.addLogLine(badIndexMessage, 6, "ERROR:");
                        continue;
                    }
                    if (storedIndexName == null || !indexName.trim().equals(storedIndexName)) {
                        newIndex = (Index)Workspace.getMdFactory().createComplexMetadataObject(this.store, indexName, "Index", this.strID);
                        newIndex.setOwningPhysicalTable(this.newTable);
                        newIndex.setIndexName(indexName);
                        int strIsUnique = myIndexList.getInt(4);
                        newIndex.setIsUnique(strIsUnique);
                        storedIndexName = indexName;
                        if (myIndexList.getInt(5) == 1) {
                            OptionsPropertyHandler op = new OptionsPropertyHandler((Root)newIndex);
                            op.setUseSetProperties(true);
                            op.setSpecificProperty("Primary", "Primary", "true", "OPTION", null, 1, null, 12, false);
                        }
                    } else {
                        int indexLoc = newIndexNames.indexOf(indexName);
                        if (indexLoc < 0) {
                            this.m_IndexError = true;
                            String msg = bundle.formatString("DefineTablesWizardTab.IndxNameBad.fmt.txt", (Object)indexName, (Object)this.tableTrimName);
                            Workspace.getDefaultLogger().debug((Object)msg);
                            this.addLogLine(msg, 6, "ERROR:");
                            if (badIndexNames.contains(indexName)) continue;
                            badIndexNames.add(indexName);
                            String badIndexMessage = bundle.formatString("DefineTablesWizardTab.UnableToAddIndex.fmt.txt", (Object)indexName);
                            Workspace.getDefaultLogger().debug((Object)badIndexMessage);
                            this.addLogLine(badIndexMessage, 6, "ERROR:");
                            continue;
                        }
                        newIndex = (Index)this.newTable.getIndexes().elementAt(indexLoc);
                    }
                    Column column = (Column)this.newTable.getColumns().elementAt(columnindex);
                    newIndex.getColumns().add((Object)column);
                    if (newIndexNames.contains(indexName)) continue;
                    newIndexNames.add(indexName);
                }
                for (int i = 0; i < badIndexNames.size(); ++i) {
                    Index badNewIndex;
                    int badIndexLoc = newIndexNames.indexOf(badIndexNames.get(i));
                    if (badIndexLoc <= -1 || (badNewIndex = (Index)this.newTable.getIndexes().elementAt(badIndexLoc)) == null) continue;
                    badNewIndex.delete();
                    newIndexNames.remove(badIndexLoc);
                }
                myIndexList.close();
            }
            catch (Exception e) {
                String msg = bundle.formatString("DefineTablesWizardTab.IndexExcp.fmt.txt", (Object)this.tableTrimName);
                Workspace.getDefaultLogger().debug((Object)msg);
                Workspace.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
                this.m_nonSASerror = true;
                this.fDone = false;
                this.m_IndexError = true;
                this.addLogLine(msg, 6, "ERROR:");
                this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
            }
        }
        catch (WsAppServerCodeException e) {
            this.m_AppServerException = true;
            this.m_IndexError = true;
            Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.IndexAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
            Workspace.getDefaultLogger().debug((Object)"WsAppServerCodeException", (Throwable)e);
            throw e;
        }
        catch (WsAppServerFailException e) {
            this.m_AppServerException = true;
            this.m_IndexError = true;
            Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.IndexAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
            Workspace.getDefaultLogger().debug((Object)"WsAppServerFailException", (Throwable)e);
            throw e;
        }
    }

    private String getUniqueIndexName(List names, int seed) {
        String name = "NONAME";
        if (names.contains(name) && names.contains(name = name + seed)) {
            return this.getUniqueIndexName(names, seed + 1);
        }
        return name;
    }

    protected void createPrimaryKeyMetadata() throws WsAppServerCodeException, WsAppServerFailException {
        this.m_PrimaryKeyError = false;
        if (this.productName.indexOf("EXCEL") > -1 || this.productName.equalsIgnoreCase("NETEZZA") || this.productName.equalsIgnoreCase("ASTER") || this.productName.equalsIgnoreCase("SYBASEIQ") || this.productName.equalsIgnoreCase("GREENPLM") || this.productName.equalsIgnoreCase("FEDSVR") || this.productName.equalsIgnoreCase("SASIOHNA") || this.productName.equalsIgnoreCase("SASIOIMP") || this.productName.equalsIgnoreCase("SASIOPI") || this.productName.equalsIgnoreCase("SASIOHWQ") || this.productName.equalsIgnoreCase("SASIORST") || this.productName.equalsIgnoreCase("OLEDBNETEZZA")) {
            return;
        }
        this.sqlString = this.productName.equalsIgnoreCase("VERTICA") ? "PROC SQL; \n  CONNECT TO " + this.m_strEngine + "(" + this.strConnectionOptions + "); \n  CREATE TABLE _PrimaryKeys AS \n  SELECT COLUMN_NAME FROM CONNECTION TO " + this.m_strEngine + "(VERTICA::SQLPrimaryKeys(\"\",\"" + this.strSchema + "\",\"" + this.tableTrimName + "\"))\nQUIT; \n" : "PROC SQL; \n  CONNECT TO " + this.m_strEngine + "(" + this.strConnectionOptions + "); \n  CREATE TABLE _PrimaryKeys AS \n  SELECT COLUMN_NAME FROM CONNECTION TO " + this.m_strEngine + "(DBMS::PrimaryKeys(\"\",\"" + this.strSchema + "\",\"" + this.tableTrimName + "\"))\nQUIT; \n";
        try {
            this.myAppServer.submitSASCode(this.sqlString);
            MVAResultSet myPrimaryKeysList = this.myAppServer.getTable("WORK", "_PrimaryKeys", null, null, null);
            ArrayList<String> newPrimaryKeyNames = new ArrayList<String>();
            this.fDone = true;
            String storedPrimaryKeyName = "";
            try {
                while (myPrimaryKeysList.next()) {
                    String colName = myPrimaryKeysList.getString(1).trim();
                    if (colName.length() < 1) {
                        this.m_PrimaryKeyError = true;
                        String msg = bundle.formatString("DefineTablesWizardTab.PKBlankCol.fmt.txt", (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                        continue;
                    }
                    int columnindex = this.newColumnNames.indexOf(colName);
                    if (columnindex < 0) {
                        this.m_PrimaryKeyError = true;
                        String msg = bundle.formatString("DefineTablesWizardTab.PKBadCol.fmt.txt", (Object)colName, (Object)this.tableTrimName);
                        Workspace.getDefaultLogger().debug((Object)msg);
                        this.addLogLine(msg, 6, "ERROR:");
                        continue;
                    }
                    String primaryKeyName = this.tableTrimName + "." + bundle.getString("Common.DefaultPrimaryKey.txt");
                    UniqueKey newPrimaryKey = null;
                    if (!primaryKeyName.trim().equals(storedPrimaryKeyName)) {
                        newPrimaryKey = (UniqueKey)Workspace.getMdFactory().createComplexMetadataObject(this.store, primaryKeyName, "UniqueKey", this.strID);
                        newPrimaryKey.setName(primaryKeyName);
                        newPrimaryKey.setIsPrimary(1);
                        storedPrimaryKeyName = primaryKeyName;
                        this.newTable.getUniqueKeys().addElement((Object)newPrimaryKey);
                    } else {
                        newPrimaryKey = (UniqueKey)this.newTable.getUniqueKeys().elementAt(0);
                    }
                    Column column = (Column)this.newTable.getColumns().elementAt(columnindex);
                    newPrimaryKey.getKeyedColumns().add((Object)column);
                    newPrimaryKeyNames.add(primaryKeyName);
                }
                myPrimaryKeysList.close();
            }
            catch (Exception e) {
                String msg = bundle.formatString("DefineTablesWizardTab.PKExcp.fmt.txt", (Object)this.tableTrimName);
                Workspace.getDefaultLogger().debug((Object)msg);
                Workspace.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
                this.m_nonSASerror = true;
                this.m_PrimaryKeyError = true;
                this.fDone = false;
                this.addLogLine(msg, 6, "ERROR:");
                this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
            }
        }
        catch (WsAppServerFailException e) {
            this.m_AppServerException = true;
            this.m_PrimaryKeyError = true;
            Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.IndexAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
            Workspace.getDefaultLogger().debug((Object)"WsAppServerFailException", (Throwable)e);
            throw e;
        }
        catch (WsAppServerCodeException e) {
            this.m_AppServerException = true;
            this.m_PrimaryKeyError = true;
            Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.PKAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
            Workspace.getDefaultLogger().debug((Object)"WsAppServerCodeException", (Throwable)e);
            throw e;
        }
    }

    protected void createForeignKeyMetadata() {
        try {
            this.m_ForeignKeyError = false;
            if (this.productName.indexOf("EXCEL") > -1 || this.productName.equalsIgnoreCase("NETEZZA") || this.productName.equalsIgnoreCase("ASTER") || this.productName.equalsIgnoreCase("SYBASEIQ") || this.productName.equalsIgnoreCase("GREENPLM") || this.productName.equalsIgnoreCase("FEDSVR") || this.productName.equalsIgnoreCase("SASIOHNA") || this.productName.equalsIgnoreCase("SASIOIMP") || this.productName.equalsIgnoreCase("SASIOPI") || this.productName.equalsIgnoreCase("SASIOHWQ") || this.productName.equalsIgnoreCase("SASIORST") || this.productName.equalsIgnoreCase("OLEDBNETEZZA")) {
                return;
            }
            for (int i = 0; i < this.newTables.size(); ++i) {
                MVAResultSet myForeignKeysList;
                if (!this.aHasColumns[i] || this.productName.equalsIgnoreCase("SYBASE") && ((PhysicalTable)this.newTables.get(i)).getIsDBMSView() == 1) continue;
                String primaryTableName = ((PhysicalTable)this.newTables.get(i)).getName();
                this.sqlString = this.productName.equalsIgnoreCase("VERTICA") ? "PROC SQL; \n  CONNECT TO " + this.m_strEngine + "(" + this.strConnectionOptions + "); \n  CREATE TABLE _ForeignKeys AS \n  SELECT PKCOLUMN_NAME, FKTABLE_NAME, FKCOLUMN_NAME \n  FROM CONNECTION TO " + this.m_strEngine + "(VERTICA::SQLForeignKeys(\"\",\"" + this.strSchema + "\",\"" + primaryTableName + "\", \"\", \"\", \"\"))\nQUIT; \n" : "PROC SQL; \n  CONNECT TO " + this.m_strEngine + "(" + this.strConnectionOptions + "); \n  CREATE TABLE _ForeignKeys AS \n  SELECT PKCOLUMN_NAME, FKTABLE_NAME, FKCOLUMN_NAME \n  FROM CONNECTION TO " + this.m_strEngine + "(DBMS::ForeignKeys(\"\",\"" + this.strSchema + "\",\"" + primaryTableName + "\", \"\", \"\", \"\"))\nQUIT; \n";
                try {
                    this.myAppServer.submitSASCode(this.sqlString);
                    myForeignKeysList = this.myAppServer.getTable("WORK", "_ForeignKeys", null, null, null);
                }
                catch (WsAppServerFailException e) {
                    this.m_AppServerException = true;
                    this.m_ForeignKeyError = true;
                    Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.FKAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
                    Workspace.getDefaultLogger().debug((Object)"WsAppServerFailException", (Throwable)e);
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                    }
                    catch (WsAppServerFailException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                catch (WsAppServerCodeException e) {
                    this.m_AppServerException = true;
                    this.m_ForeignKeyError = true;
                    Workspace.getDefaultLogger().debug((Object)bundle.formatString("DefineTablesWizardTab.FKAppsrvExcp.fmt.txt", (Object)this.tableTrimName));
                    Workspace.getDefaultLogger().debug((Object)"WsAppServerCodeException", (Throwable)e);
                    try {
                        this.addLogLines(this.myAppServer.getLog());
                    }
                    catch (WsAppServerFailException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                this.fDone = true;
                String storedForeignKeyName = "";
                try {
                    while (myForeignKeysList.next()) {
                        String primaryColumnName = myForeignKeysList.getString(1).trim();
                        String foreignTableName = myForeignKeysList.getString(2).trim();
                        String foreignColumnName = myForeignKeysList.getString(3).trim();
                        if (primaryColumnName.length() < 1) {
                            this.m_ForeignKeyError = true;
                            String msg = bundle.formatString("DefineTablesWizardTab.FKBlankPKCol.fmt.txt", (Object)this.tableTrimName);
                            Workspace.getDefaultLogger().debug((Object)msg);
                            this.addLogLine(msg, 6, "ERROR:");
                            continue;
                        }
                        if (foreignColumnName.length() < 1) {
                            this.m_ForeignKeyError = true;
                            String msg = bundle.formatString("DefineTablesWizardTab.FKBlankFKCol.fmt.txt", (Object)this.tableTrimName);
                            Workspace.getDefaultLogger().debug((Object)msg);
                            this.addLogLine(msg, 6, "ERROR:");
                            continue;
                        }
                        if (foreignTableName.length() < 1) {
                            this.m_ForeignKeyError = true;
                            String msg = bundle.formatString("DefineTablesWizardTab.FKBlankFtable.fmt.txt", (Object)this.tableTrimName);
                            Workspace.getDefaultLogger().debug((Object)msg);
                            this.addLogLine(msg, 6, "ERROR:");
                            continue;
                        }
                        int primaryTablePosition = this.newTablesNames.indexOf(primaryTableName);
                        int foreignTablePosition = this.newTablesNames.indexOf(foreignTableName);
                        if (foreignTablePosition <= -1 || primaryTablePosition <= -1) continue;
                        ForeignKey newForeignKey = null;
                        PhysicalTable foreignTable = null;
                        PhysicalTable primaryTable = null;
                        primaryTable = (PhysicalTable)this.newTables.get(primaryTablePosition);
                        foreignTable = (PhysicalTable)this.newTables.get(foreignTablePosition);
                        Column foreignKeyColumn = DefineTablesWizardTab.getColumn(foreignTable, foreignColumnName);
                        Column primaryKeyColumn = DefineTablesWizardTab.getColumn(primaryTable, primaryColumnName);
                        if (foreignKeyColumn == null || primaryKeyColumn == null) continue;
                        String foreignKeyName = primaryTableName + "." + foreignTableName;
                        if (!foreignKeyName.trim().equals(storedForeignKeyName)) {
                            newForeignKey = (ForeignKey)Workspace.getMdFactory().createComplexMetadataObject(this.store, foreignKeyName, "ForeignKey", this.strID);
                            newForeignKey.setTable((DataTable)foreignTable);
                            UniqueKey primaryKey = DefineTablesWizardTab.getPrimaryKey(primaryTable);
                            newForeignKey.setPartnerUniqueKey(primaryKey);
                            storedForeignKeyName = foreignKeyName;
                        } else {
                            for (int iJohn = 0; iJohn < foreignTable.getForeignKeys().size(); ++iJohn) {
                                if (!((ForeignKey)foreignTable.getForeignKeys().elementAt(iJohn)).getName().equalsIgnoreCase(storedForeignKeyName)) continue;
                                newForeignKey = (ForeignKey)foreignTable.getForeignKeys().elementAt(iJohn);
                                break;
                            }
                        }
                        newForeignKey.getKeyedColumns().add((Object)foreignKeyColumn);
                        String keyAssociationName = primaryColumnName + "." + foreignColumnName;
                        KeyAssociation newKeyAssociation = null;
                        newKeyAssociation = (KeyAssociation)Workspace.getMdFactory().createComplexMetadataObject(this.store, keyAssociationName, "KeyAssociation", this.strID);
                        newKeyAssociation.setForeignKeyColumn(foreignKeyColumn);
                        newKeyAssociation.setUniqueKeyColumn(primaryKeyColumn);
                        newKeyAssociation.setOwningForeignKey(newForeignKey);
                    }
                    myForeignKeysList.close();
                }
                catch (Exception e) {
                    this.fDone = false;
                    this.m_ForeignKeyError = true;
                    Workspace.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
                    this.m_nonSASerror = true;
                    this.addLogLine(e.getLocalizedMessage(), 6, "ERROR:");
                    continue;
                }
                if (!this.bUserCanceled) continue;
                System.out.println("Cancel detected: createForeignKeyMetadata bottomloop), table: " + this.tableTrimName);
                Workspace.getDefaultLogger().debug((Object)("Cancel detected: createForeignKeyMetadata bottomloop), table: " + this.tableTrimName));
                this.bSafeToQuit = true;
                return;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void showSASLog(String sMessage) {
        int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (eAnswer == 0) {
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("DefineTablesWizardTab.LogTitle.txt"), true, this.m_logLinesHolder);
            dlg.show();
        }
    }

    public void showSASLog2() {
        int messageType = 1;
        if (!this.errorTables.isEmpty() && !this.newlyCreatedTableNames.isEmpty()) {
            messageType = 2;
        } else if (!this.errorTables.isEmpty() && this.newlyCreatedTableNames.isEmpty()) {
            messageType = 0;
        }
        int originalNumberSelected = this.tableList.length;
        int eAnswer = MessageUtil.displayListMessage((String)bundle.formatString("DefineTablesWizardSASTab.CompleteMessage.fmt.txt", (Object)this.newlyCreatedTableNames.size(), (Object)(originalNumberSelected - this.newlyCreatedTableNames.size())), (List)this.newlyCreatedTableNames, (String)bundle.getString("DefineTablesWizardTab.Information.title.txt"), (int)messageType, (int)0);
        if (eAnswer == 0) {
            this.myAppServer = (WsAppServer)this.myParent.getWizardData("AppServer");
            try {
                this.addLogLines(this.myAppServer.getOutput());
            }
            catch (WsAppServerFailException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("DefineTablesWizardTab.LogTitle.txt"), true, this.m_logLinesHolder);
            dlg.show();
        }
    }

    public void setTabProperty(String propertyName, Object propertyValue) {
        super.setTabProperty(propertyName, propertyValue);
        if (propertyName.equalsIgnoreCase(HELP_PRODUCT)) {
            String helpProduct = (String)propertyValue;
            this.setHelpProduct(helpProduct);
        }
    }

    static {
        DBMSVIEW = "VIEW";
    }

    protected class cRunnableMethod
    implements Runnable {
        protected cRunnableMethod() {
        }

        @Override
        public void run() {
            if (Workspace.useProcMetalibChanges()) {
                DefineTablesWizardTab.this.registerTablesProcMetalib();
            } else {
                DefineTablesWizardTab.this.registerTables();
            }
        }
    }

    protected class cSelectLocationAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSelectLocationAction() {
            super(bundle, "DefineTablesWizardTab.SelectFolder", 0);
        }

        public void actionPerformed(ActionEvent e) {
            String sInitialPath = DefineTablesWizardTab.this.m_pathUrl.toString();
            Root tree = WsMetadataUtil.promptForFolder((String)sInitialPath, (boolean)false);
            if (tree == null) {
                return;
            }
            DefineTablesWizardTab.this.m_selectedTree = (Tree)tree;
            String sPath = DefineTablesWizardTab.this.getPathFromTree(DefineTablesWizardTab.this.m_selectedTree);
            DefineTablesWizardTab.this.m_txtLocation.setText(sPath);
        }
    }
}

