/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.visuals.DataValidationCustomAssignEditPanel;
import com.sas.wadmin.visuals.DataValidationCustomEditPanel;
import com.sas.wadmin.visuals.DataValidationDuplicatesEditPanel;
import com.sas.wadmin.visuals.DataValidationEditPanel;
import com.sas.wadmin.visuals.DataValidationInvalidEditPanel;
import com.sas.wadmin.visuals.DataValidationMissingEditPanel;
import com.sas.wadmin.visuals.DataValidationTableModel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.undo.UndoManager;

public class DataValidationTableViewer
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationTableViewer.class);
    protected WsTable m_table;
    protected DataValidationTableModel m_tableModel;
    protected JScrollPane m_tableScrollPane;
    protected JButton m_buttonNew;
    protected JButton m_buttonEdit;
    protected JButton m_buttonDelete;
    protected JPanel m_buttonPanel;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actEdit;
    protected WsAbstractAction m_actDelete;
    protected cTableModelListener m_tableModelListener = new cTableModelListener();
    protected cTablePopupMenuRequestListener m_tablePopupListener = new cTablePopupMenuRequestListener();
    protected cTablePopupMenuRequestListener m_viewportPopupListener = new cTablePopupMenuRequestListener();
    protected cTableSelectionListener m_tableSelectionListener = new cTableSelectionListener();
    protected cTableRowModelListener m_tableRowModelListener = new cTableRowModelListener();
    protected ClassifierMap m_classifierMap;
    protected String m_validationType;
    protected DataValidationMetadataHandler m_handler;

    public void setupViewer(String validationType, DataValidationTableModel tableModel, WAUndoManager undoManager) {
        this.m_validationType = validationType;
        this.m_tableModel = tableModel;
        this.m_handler = this.m_tableModel.getHandler();
        this.setWAUndoManager(undoManager);
        this.initialize();
    }

    public void initialize() {
        this.m_table = new WsTable((WsAbstractTableModel)this.m_tableModel);
        this.m_table.setToolTipText(bundle.getString("DataValidationTableViewer.Table." + this.m_validationType + ".Tooltip.txt"));
        this.m_table.setAutoResizeMode(4);
        this.m_table.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)this.m_tablePopupListener);
        this.m_table.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)this.m_viewportPopupListener);
        this.m_tableModel.addTableModelListener(this.m_tableModelListener);
        ((WsDefaultTableRowModel)this.m_table.getRowModel()).addRowModelListener((WsTableRowModelListener)this.m_tableRowModelListener);
        this.m_table.setUndoManager((UndoManager)this.waum);
        this.m_tableScrollPane = new JScrollPane((Component)this.m_table);
        ListSelectionModel lsm = this.m_table.getSelectionModel();
        lsm.addListSelectionListener(this.m_tableSelectionListener);
        this.m_buttonPanel = new JPanel((LayoutManager)new WsButtonsLayout());
        this.m_actNew = new cNewAction();
        this.m_buttonNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_actEdit = new cEditAction();
        this.m_buttonEdit = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEdit);
        this.m_actDelete = new cDeleteAction();
        this.m_buttonDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_table.setDeleteKeyAction((Action)this.m_actDelete);
        this.setLayout(new GridBagLayout());
        this.m_buttonPanel.add(this.m_buttonNew);
        this.m_buttonPanel.add(this.m_buttonEdit);
        this.m_buttonPanel.add(this.m_buttonDelete);
        this.add(this.m_tableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.enableButtons();
    }

    public boolean validateData() {
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_tableModel.moveDataToModel();
        this.enableButtons();
        this.m_table.clearSelection();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_table.getRowModel();
        this.m_tableModel.setRowMappings(mdlRows.getRowMappings());
        this.m_tableModel.moveDataToStore();
        this.setDataChanged(false);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_actNew == null) {
            return;
        }
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
    }

    public void insertRow(List rowValues) {
        this.m_table.undoableInsertRow(this.m_tableModel.getRowCount() - 1, rowValues);
    }

    public void setRowValues(List rowValues, int row) {
        for (int i = 0; i < this.m_tableModel.getColumnCount() + this.m_tableModel.getHiddenColumnCount(); ++i) {
            this.m_tableModel.setValueAt(rowValues.get(i), row, i);
        }
    }

    public DataValidationTableModel getModel() {
        return this.m_tableModel;
    }

    public WsDefaultTableRowModel getRowModel() {
        return (WsDefaultTableRowModel)this.m_table.getRowModel();
    }

    public void enableButtons() {
        if (this.m_actNew == null) {
            return;
        }
        this.m_actNew.setEnabled(this.isEditable());
        this.m_actDelete.setEnabled(this.m_table.getSelectedRowsFromSelectedCells().length > 0 && this.isEditable());
        this.m_actEdit.setEnabled(this.m_table.getSelectedRowsFromSelectedCells().length == 1 && this.isEditable());
    }

    public void setNewButtonMnemonic(char mnem) {
        this.m_buttonNew.setMnemonic(mnem);
    }

    public void setEditButtonMnemonic(char mnem) {
        this.m_buttonEdit.setMnemonic(mnem);
    }

    public void setDeleteButtonMnemonic(char mnem) {
        this.m_buttonDelete.setMnemonic(mnem);
    }

    public DataValidationEditPanel getEditPanel(List rowValues) {
        DataValidationEditPanel editPanel = null;
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            editPanel = new DataValidationMissingEditPanel(this.m_handler, rowValues);
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            editPanel = new DataValidationDuplicatesEditPanel(this.m_handler, rowValues);
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            editPanel = new DataValidationInvalidEditPanel(this.m_handler, rowValues);
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            editPanel = new DataValidationCustomEditPanel(this.m_handler.getClassifierMap(), this.m_tableModel, rowValues);
        } else if (this.m_validationType.equalsIgnoreCase("TRUE") || this.m_validationType.equalsIgnoreCase("FALSE")) {
            editPanel = new DataValidationCustomAssignEditPanel(this.m_handler, rowValues);
        }
        return editPanel;
    }

    public void doNewAction() {
        if (!this.m_buttonNew.isEnabled()) {
            return;
        }
        List rowValues = this.m_tableModel.newRow();
        DataValidationEditPanel editPanel = this.getEditPanel(rowValues);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DataValidation." + this.m_validationType + "Tab.title.txt"), true, (WAPanel)editPanel);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            rowValues = editPanel.getRow();
            this.insertRow(rowValues);
        }
        dialog.dispose();
        this.m_table.selectRow(this.m_tableModel.getRowCount() - 1);
    }

    public void doEditAction() {
        if (!this.m_buttonEdit.isEnabled()) {
            return;
        }
        WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)this.m_table.getRowModel();
        this.m_tableModel.setRowMappings(mdlRows.getRowMappings());
        int[] selRows = this.m_table.getSelectedRowsFromSelectedCells();
        if (selRows.length != 1) {
            return;
        }
        int selectedRow = selRows[0];
        int orderedRow = this.m_tableModel.getOrderedRow(selectedRow);
        List rowValues = this.m_tableModel.getRowValues(selectedRow);
        DataValidationEditPanel editPanel = this.getEditPanel(rowValues);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DataValidation." + this.m_validationType + "Tab.title.txt"), true, (WAPanel)editPanel);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            rowValues = editPanel.getRow();
            this.setRowValues(rowValues, orderedRow);
        }
        dialog.dispose();
        this.m_table.selectRow(selectedRow);
    }

    public void doDeleteAction() {
        if (!this.m_buttonDelete.isEnabled()) {
            return;
        }
        this.m_table.undoableDeleteSelectedRows();
    }

    protected class cTableRowModelListener
    implements WsTableRowModelListener {
        protected cTableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            DataValidationTableViewer.this.setDataChanged(true);
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            DataValidationTableViewer.this.setDataChanged(true);
        }
    }

    protected class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu menuPopup = new JPopupMenu();
            menuPopup.add((Action)DataValidationTableViewer.this.m_actNew);
            menuPopup.add((Action)DataValidationTableViewer.this.m_actEdit);
            menuPopup.add((Action)DataValidationTableViewer.this.m_actDelete);
            menuPopup.show((Component)DataValidationTableViewer.this.m_table, e.getX(), e.getY());
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DataValidationTableViewer.this.enableButtons();
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (DataValidationTableViewer.this.isListeningForChanges()) {
                DataValidationTableViewer.this.setDataChanged(true);
            }
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "DataValidationTableViewer.DeleteButton", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            DataValidationTableViewer.this.doDeleteAction();
        }
    }

    protected class cEditAction
    extends WsAbstractAction {
        public cEditAction() {
            super(bundle, "DataValidationTableViewer.EditButton", false);
        }

        public void actionPerformed(ActionEvent e) {
            DataValidationTableViewer.this.doEditAction();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "DataValidationTableViewer.NewButton", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            DataValidationTableViewer.this.doNewAction();
        }
    }
}

