/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class DataValidationTableModel
extends WsAbstractTableModel {
    protected ClassifierMap m_classifierMap;
    protected PhysicalTable m_targetTable;
    protected String m_validationType;
    protected DataValidationMetadataHandler m_handler;
    protected int[] m_rowMappings;

    public DataValidationTableModel(String validationType) {
        this.m_validationType = validationType;
        this.m_handler = new DataValidationMetadataHandler(this.m_validationType);
        this.initialize();
    }

    public void initialize() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.createColumns();
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            this.m_aColumns[i].setEditable(false);
        }
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.m_handler.makeTargetTable();
        this.clear();
        List rows = this.getMetadataRows();
        for (int i = 0; i < rows.size(); ++i) {
            List rowValues = (List)rows.get(i);
            this.m_lData.add(rowValues);
        }
        this.fireTableModelPopulated();
    }

    public abstract void createColumns();

    public List newRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            rowValues.add(null);
        }
        return rowValues;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        List rows = this.getTableRows();
        this.m_handler.setMetadataValues(rows);
    }

    public List getTableRows() {
        ArrayList<List> rows = new ArrayList<List>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            List rowValues = this.getRowValues(i);
            rows.add(rowValues);
        }
        return rows;
    }

    public int getOrderedRow(int selectedRow) {
        int orderedRow = selectedRow;
        if (this.m_rowMappings != null) {
            orderedRow = this.m_rowMappings[selectedRow];
        }
        return orderedRow;
    }

    public List getRowValues(int selectedRow) {
        return super.getRowValues(this.getOrderedRow(selectedRow));
    }

    public List getMetadataRows() throws MdException, RemoteException {
        return this.m_handler.getMetadataValues();
    }

    public String getValidationType() {
        return this.m_validationType;
    }

    public void setValidationType(String validationType) {
        this.m_validationType = validationType;
    }

    public DataValidationMetadataHandler getHandler() {
        return this.m_handler;
    }

    public void setHandler(DataValidationMetadataHandler handler) {
        this.m_handler = handler;
    }

    public void setClassifierMap(ClassifierMap classifierMap) {
        this.m_classifierMap = classifierMap;
        this.m_handler.setClassifierMap(classifierMap);
    }

    public int getColumnCount() {
        return 0;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void setRowMappings(int[] rowMappings) {
        this.m_rowMappings = rowMappings;
    }

    public int[] getRowMappings() {
        return this.m_rowMappings;
    }
}

