/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.visuals.DataValidationEditPanel;
import com.sas.wadmin.visuals.SelectedColumnPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsExpressionTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class DataValidationCustomAssignEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationCustomAssignEditPanel.class);
    protected JLabel m_lblColumn;
    protected WAComboBox m_cmbColumn;
    protected JPanel m_pnlAssignTo;
    protected JRadioButton[] m_rdoType;
    protected ButtonGroup m_bgpType;
    protected WsExpressionTextField m_expExpression;
    protected SelectedColumnPanel m_selTranslation;
    protected JPanel m_pnlNoValue;
    protected JCheckBox m_chkSetValueTo;
    protected WATextField m_txtSetValueTo;
    protected JCheckBox m_chkException;
    protected cSetValueToListener m_setValueToListener = new cSetValueToListener();
    protected cTypeListener m_typeListener0 = new cTypeListener();
    protected cTypeListener m_typeListener1 = new cTypeListener();
    protected List m_tableList;
    protected List m_columnList;
    protected List m_rowValues;
    protected DataValidationMetadataHandler m_handler;
    static final String HELP_ID = "custom_assign_win";

    public DataValidationCustomAssignEditPanel(DataValidationMetadataHandler handler, List rowValues) {
        this.m_handler = handler;
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_cmbColumn = new WAComboBox();
        this.m_lblColumn = new JLabel(bundle.getString("DataValidationEditPanel.CustomAssign.Column.label.txt"));
        this.m_lblColumn.setLabelFor((Component)this.m_cmbColumn);
        this.m_lblColumn.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.CustomAssign.Column.mnem").charAt(0));
        this.m_cmbColumn.setToolTipText(bundle.getString("DataValidationEditPanel.CustomAssign.Column.tooltip.txt"));
        this.m_pnlAssignTo = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.To.label.txt"));
        this.m_pnlAssignTo.setBorder(border);
        this.m_rdoType = new JRadioButton[2];
        this.m_bgpType = new ButtonGroup();
        this.m_rdoType[0] = new JRadioButton(bundle.getString("DataValidationEditPanel.ExpressionRadio.label.txt"));
        this.m_rdoType[0].setToolTipText(bundle.getString("DataValidationEditPanel.ExpressionRadio.tooltip.txt"));
        this.m_rdoType[0].setMnemonic(bundle.getString("DataValidationEditPanel.ExpressionRadio.mnem").charAt(0));
        this.m_rdoType[0].addActionListener(this.m_typeListener0);
        this.m_bgpType.add(this.m_rdoType[0]);
        this.m_rdoType[1] = new JRadioButton(bundle.getString("DataValidationEditPanel.TranslationRadio.label.txt"));
        this.m_rdoType[1].setToolTipText(bundle.getString("DataValidationEditPanel.TranslationRadio.tooltip.txt"));
        this.m_rdoType[1].setMnemonic(bundle.getString("DataValidationEditPanel.TranslationRadio.mnem").charAt(0));
        this.m_rdoType[1].addActionListener(this.m_typeListener0);
        this.m_bgpType.add(this.m_rdoType[1]);
        this.m_expExpression = new WsExpressionTextField(this.m_handler.getTargetTable(), "");
        this.m_expExpression.setToolTipText(bundle.getString("DataValidationEditPanel.CustomAssign.Expression.tooltip.txt"));
        this.m_selTranslation = new SelectedColumnPanel();
        this.m_selTranslation.setColumnSelectorDialogHelpTopic("select_column_trans_win");
        this.m_selTranslation.setNumberOfColumnFields(2);
        this.m_selTranslation.setTableLabel(bundle.getString("DataValidationEditPanel.TransTable.label.txt"), bundle.getString("DataValidationEditPanel.TransTable.mnem").charAt(0));
        this.m_selTranslation.setColumnLabel(0, bundle.getString("DataValidationEditPanel.TransFrom.label.txt"), bundle.getString("DataValidationEditPanel.TransFrom.mnem").charAt(0));
        this.m_selTranslation.setColumnLabel(1, bundle.getString("DataValidationEditPanel.TransTo.label.txt"), bundle.getString("DataValidationEditPanel.TransTo.mnem").charAt(0));
        this.m_selTranslation.setColumnSelectorDialogDescription(bundle.getString("DataValidationEditPanel.TransDescription.txt"));
        this.m_pnlNoValue = new JPanel();
        border = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.NoValuePanel.label.txt"));
        this.m_pnlNoValue.setBorder(border);
        this.m_chkSetValueTo = new JCheckBox(bundle.getString("DataValidationEditPanel.SetValueTo.label.txt"));
        this.m_chkSetValueTo.setToolTipText(bundle.getString("DataValidationEditPanel.SetValueTo.tooltip.txt"));
        this.m_chkSetValueTo.setMnemonic(bundle.getString("DataValidationEditPanel.SetValueTo.mnem").charAt(0));
        this.m_chkSetValueTo.addActionListener(this.m_setValueToListener);
        this.m_txtSetValueTo = new WATextField();
        this.m_chkException = new JCheckBox(bundle.getString("DataValidationEditPanel.TransException.label.txt"));
        this.m_chkException.setToolTipText(bundle.getString("DataValidationEditPanel.TransException.tooltip.txt"));
        this.m_chkException.setMnemonic(bundle.getString("DataValidationEditPanel.TransException.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbColumn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlAssignTo.setLayout(new GridBagLayout());
        this.m_pnlAssignTo.add((Component)this.m_rdoType[0], new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlAssignTo.add((Component)this.m_expExpression, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.m_pnlAssignTo.add((Component)this.m_rdoType[1], new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlAssignTo.add((Component)this.m_selTranslation, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 25, 0, 5), 0, 0));
        this.m_pnlNoValue.setLayout(new GridBagLayout());
        this.m_pnlNoValue.add((Component)this.m_chkSetValueTo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNoValue.add((Component)this.m_txtSetValueTo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNoValue.add((Component)this.m_chkException, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlAssignTo.add((Component)this.m_pnlNoValue, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 25, 0, 5), 0, 0));
        this.add(this.m_pnlAssignTo, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        boolean setValueToFlag;
        this.setListeningForChanges(false);
        this.m_columnList = this.m_handler.makeColumnList(this.m_handler.getTargetTable());
        this.m_cmbColumn.addItems(this.m_columnList);
        Column column = (Column)this.m_rowValues.get(this.m_handler.getColumnIndex());
        if (column == null && this.m_columnList.size() > 0) {
            this.m_cmbColumn.setSelectedIndex(0);
        } else if (column != null) {
            this.m_cmbColumn.setSelectedItem((Object)column);
        }
        String type = (String)this.m_rowValues.get(this.m_handler.getMetaTypeIndex());
        if (type == null || type.equals("Expression")) {
            this.m_rdoType[0].setSelected(true);
        } else {
            this.m_rdoType[1].setSelected(true);
        }
        String expression = (String)this.m_rowValues.get(this.m_handler.getExpressionIndex());
        this.m_expExpression.setText(expression);
        MdObjectStore store = this.m_handler.getStore();
        this.m_selTranslation.setStore(store);
        Column fromColumn = (Column)this.m_rowValues.get(this.m_handler.getTransFromIndex());
        Column toColumn = (Column)this.m_rowValues.get(this.m_handler.getTransToIndex());
        this.m_selTranslation.setColumn(0, fromColumn);
        this.m_selTranslation.setColumn(1, toColumn);
        if (this.m_rowValues.get(this.m_handler.getTransSetValueToFlagIndex()) != null && (setValueToFlag = ((Boolean)this.m_rowValues.get(this.m_handler.getTransSetValueToFlagIndex())).booleanValue())) {
            this.m_chkSetValueTo.setSelected(true);
            String setValueTo = (String)this.m_rowValues.get(this.m_handler.getTransSetValueToIndex());
            this.m_txtSetValueTo.setText(setValueTo);
        }
        if (this.m_rowValues.get(this.m_handler.getTransExceptionIndex()) != null) {
            Boolean bExcpFlag = (Boolean)this.m_rowValues.get(this.m_handler.getTransExceptionIndex());
            if (bExcpFlag == null) {
                bExcpFlag = Boolean.FALSE;
            }
            this.m_chkException.setSelected(bExcpFlag);
        }
        this.typeChange();
        this.setValueToChange();
        this.setListeningForChanges(true);
    }

    @Override
    public boolean validateData() {
        if (this.m_cmbColumn.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.CustomAssign.MissingColumn.Error.txt"), (String)bundle.getString("DataValidationEditPanel.CustomAssign.MissingColumn.Title.txt"), (int)0);
            this.m_cmbColumn.requestFocus();
            return false;
        }
        if (this.m_rdoType[0].isSelected()) {
            if (this.m_expExpression.getText().equals("")) {
                MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingExpression.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingExpression.Title.txt"), (int)0);
                this.m_expExpression.requestFocus();
                return false;
            }
        } else {
            if (this.m_selTranslation.getColumn(0) == null || this.m_selTranslation.getColumn(1) == null) {
                MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.CustomAssign.MissingTranslation.Error.txt"), (String)bundle.getString("DataValidationEditPanel.CustomAssign.MissingTranslation.Title.txt"), (int)0);
                this.m_selTranslation.requestFocus();
                return false;
            }
            if (this.m_chkSetValueTo.isSelected() && this.m_txtSetValueTo.getText().trim().equals("")) {
                MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingSetValueTo.Error.txt "), (String)bundle.getString("DataValidationEditPanel.MissingSetValueTo.Title.txt"), (int)0);
                this.m_txtSetValueTo.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    public List getRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>(this.m_handler.getNumValues2());
        for (int i = 0; i < this.m_handler.getNumValues2(); ++i) {
            rowValues.add(null);
        }
        Column column = (Column)this.m_cmbColumn.getSelectedItem();
        String columnName = "";
        if (column != null) {
            try {
                columnName = column.getSASColumnName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        rowValues.set(this.m_handler.getColumnIndex(), column);
        rowValues.set(this.m_handler.getColumnNameIndex(), columnName);
        if (this.m_rdoType[0].isSelected()) {
            rowValues.set(this.m_handler.getTypeIndex(), bundle.getString("DataValidationEditPanel.Expression.txt"));
            rowValues.set(this.m_handler.getMetaTypeIndex(), "Expression");
            rowValues.set(this.m_handler.getExpressionIndex(), this.m_expExpression.getText());
            rowValues.set(this.m_handler.getAssignStringIndex(), this.m_expExpression.getText());
        } else {
            rowValues.set(this.m_handler.getTypeIndex(), bundle.getString("DataValidationEditPanel.Translation.txt"));
            rowValues.set(this.m_handler.getMetaTypeIndex(), "Translation");
            Column fromColumn = this.m_selTranslation.getColumn(0);
            Column toColumn = this.m_selTranslation.getColumn(1);
            PhysicalTable table = null;
            if (fromColumn != null) {
                try {
                    table = (PhysicalTable)fromColumn.getTable();
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    return null;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            rowValues.set(this.m_handler.getTransTableIndex(), table);
            rowValues.set(this.m_handler.getTransFromIndex(), fromColumn);
            rowValues.set(this.m_handler.getTransToIndex(), toColumn);
            String assign = this.m_handler.makeAssignString(table, fromColumn, toColumn);
            rowValues.set(this.m_handler.getAssignStringIndex(), assign);
            boolean setValueToFlag = this.m_chkSetValueTo.isSelected();
            rowValues.set(this.m_handler.getTransSetValueToFlagIndex(), setValueToFlag);
            if (setValueToFlag) {
                String setValueTo = this.m_txtSetValueTo.getText();
                rowValues.set(this.m_handler.getTransSetValueToIndex(), setValueTo);
            }
            boolean excpFlag = this.m_chkException.isSelected();
            rowValues.set(this.m_handler.getTransExceptionIndex(), excpFlag);
        }
        return rowValues;
    }

    public void typeChange() {
        boolean expressionFlag = this.m_rdoType[0].isSelected();
        this.m_selTranslation.setEditable(!expressionFlag);
        this.m_chkSetValueTo.setEnabled(!expressionFlag);
        this.m_txtSetValueTo.setEditable(!expressionFlag && this.m_chkSetValueTo.isSelected());
        this.m_chkException.setEnabled(!expressionFlag);
        this.m_expExpression.setEditable(expressionFlag);
    }

    public void setValueToChange() {
        this.m_txtSetValueTo.setEditable(this.m_chkSetValueTo.isSelected());
    }

    public void saveSettingsAndCleanUp() {
        this.m_chkSetValueTo.removeActionListener(this.m_setValueToListener);
        this.m_rdoType[0].removeActionListener(this.m_typeListener0);
        this.m_rdoType[1].removeActionListener(this.m_typeListener1);
        super.saveSettingsAndCleanUp();
    }

    class cSetValueToListener
    implements ActionListener {
        cSetValueToListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataValidationCustomAssignEditPanel.this.setValueToChange();
        }
    }

    class cTypeListener
    implements ActionListener {
        cTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataValidationCustomAssignEditPanel.this.typeChange();
        }
    }
}

