/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.LogListViewer;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdCallbackCancelledException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASLibrary;
import com.sas.rio.MVAResultSet;
import com.sas.rio.MVAResultSetMetaData;
import com.sas.wadmin.visuals.LibraryConnectPanel;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsStatusBarUtilities;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class DBMSConnectWizardTab
extends WsDescriptionWizardTab {
    private static WAdminResource bundle = WAdminResource.getBundle(DBMSConnectWizardTab.class);
    protected LibraryConnectPanel m_appPanel;
    protected String m_engineType;
    protected String m_SpecChar;
    protected static String DEFAULTENGINE;
    protected static String LIBRARYPANEL_EDITABLE;
    protected static String HELP_PRODUCT;
    private WsAppServer m_wizardAppServer;

    public DBMSConnectWizardTab() {
        this("", "");
    }

    public DBMSConnectWizardTab(String sDescription) {
        this(sDescription, "");
    }

    public DBMSConnectWizardTab(String sDescription, String strEngineType) {
        super(sDescription);
        LIBRARYPANEL_EDITABLE = "LibraryPanelEditable";
        HELP_PRODUCT = "HelpProduct";
        DEFAULTENGINE = "BASE";
        this.setHelpProduct(AbstractDesigner.DEFAULT_HELP_PRODUCT);
        this.m_engineType = strEngineType.length() > 0 ? strEngineType : DEFAULTENGINE;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        this.m_appPanel.doDataExchange(bSaveToModel);
        return true;
    }

    public void _initialize() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 2, new Insets(6, 6, 6, 5), 0, 0));
    }

    public void setHelpProduct(String sProduct) {
        super.setHelpProduct(sProduct);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateData() {
        WsAppServer wizardAppServer;
        if (this.m_appPanel.getLibrary() == null) {
            MessageUtil.displayMessage((String)bundle.getString("DBMSConnectWizardTab.NoSelectedLibraryError.txt"), (int)0);
            return false;
        }
        if (!this.m_appPanel.validateData()) {
            return false;
        }
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_wizardAppServer = wizardAppServer = (WsAppServer)myParent.getWizardData("AppServer");
        WsAppServer myAppServer = null;
        String strLibRef = null;
        SASLibrary tempLibrary = null;
        try {
            tempLibrary = LibraryUtil.getClientLibrary((SASLibrary)this.m_appPanel.getLibrary(), (WsAppServer)this.m_wizardAppServer);
            if (tempLibrary == null) {
                MessageUtil.displayMessage((String)bundle.getString("DBMSConnectWizardTab.SASLibraryError.txt"), (int)0);
                return false;
            }
            myParent.addWizardData("SELECTEDLIBRARY", (Object)tempLibrary);
            myAppServer = LibraryUtil.getLibraryServer((WsAppServer)this.m_wizardAppServer, (SASLibrary)tempLibrary);
            if (this.m_wizardAppServer != null && myAppServer != this.m_wizardAppServer) {
                this.m_wizardAppServer.dispose();
                this.m_wizardAppServer = null;
            }
            this.m_wizardAppServer = myAppServer;
            strLibRef = LibraryUtil.assignLibname((SASLibrary)tempLibrary, (WsAppServer)this.m_wizardAppServer, (String)"", (boolean)true, (boolean)false);
            if (myAppServer == null) {
                throw new WsAppServerFailException(bundle.getString("DBMSConnectWizardTab.AppServerNotSelected.txt"));
            }
            String defaultAppServerID = WsAppServer.getDefaultAppServerFQID();
            if (this.m_wizardAppServer != null && defaultAppServerID.length() == 0) {
                WsAppServer.setDefaultAppServerFQID((String)this.m_wizardAppServer.getServerFQID());
                if (WsStatusBarUtilities.isAppserverPanelShown()) {
                    WsStatusBarUtilities.updateAppserverPanel();
                }
            }
            if (!myAppServer.isLibrefAssigned(tempLibrary.getLibref())) {
                throw new WsAppServerLibraryException(bundle.getString("DBMSConnectWizardTab.LibraryNotAssigned.txt"));
            }
            if (this.m_wizardAppServer == null) {
                this.m_wizardAppServer = myAppServer;
            }
            if (myAppServer != this.m_wizardAppServer) {
                this.m_wizardAppServer.dispose();
                this.m_wizardAppServer = myAppServer;
            }
            myParent.addWizardData("AppServer", (Object)this.m_wizardAppServer);
        }
        catch (WsAppServerLibraryException ex) {
            String sMessage = ex.getLocalizedMessage() + " " + bundle.getString("DBMSConnectWizardTab.ViewLogQuestion.txt");
            this.showSASLogWithMessage(sMessage, myAppServer);
            return false;
        }
        catch (WsAppServerCodeException ex) {
            String sMessage = ex.getLocalizedMessage() + " " + bundle.getString("DBMSConnectWizardTab.ViewLogQuestion.txt");
            this.showSASLogWithMessage(sMessage, myAppServer);
            return false;
        }
        catch (WsAppServerFailException ex2) {
            if (ex2.hasDetailMessage()) {
                MessageUtil.displayDetailsMessage((String)ex2.getLocalizedMessage(), (int)0, (String)ex2.getDetailMessage());
                return false;
            }
            MessageUtil.displayMessage((String)ex2.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (MdCallbackCancelledException e) {
            MessageUtil.displayMessage((String)bundle.getString("DBMSConnectWizardTab.LogonCanceled.txt"), (int)0);
            return false;
        }
        catch (MdException mde) {
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)mde);
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            return false;
        }
        catch (RemoteException ase) {
            Workspace.getDefaultLogger().error((Object)"RemoteException", (Throwable)ase);
            MessageUtil.displayMessage((String)ase.getMessage(), (int)0);
            return false;
        }
        MVAResultSet mytablelist = null;
        String schemaName = null;
        String engine = (String)myParent.getWizardData("ENGINETYPE");
        try {
            myParent.addWizardData("RIOLIBREF", (Object)strLibRef);
            if (tempLibrary.getIsDBMSLibname() == 0) {
                myParent.addWizardData("SCHEMA", (Object)tempLibrary);
            } else if (engine.equals("ODBCEXCEL") || engine.equals("ODBCACCESS")) {
                schemaName = ((DatabaseSchema)this.m_appPanel.getSchema2()).getSchemaName();
                if (schemaName.length() != 0) {
                    MessageUtil.displayMessage((String)bundle.getString("DBMSConnectWizardTab.InvalidLibraryError.txt"), (int)0);
                    return false;
                }
                myParent.addWizardData("SCHEMA", (Object)this.m_appPanel.getSchema2());
            } else {
                this.m_appPanel.setEngine(engine);
                myParent.addWizardData("SCHEMA", (Object)this.m_appPanel.getSchema2());
            }
            this.m_SpecChar = (String)myParent.getWizardData("SpecChar");
            if (this.m_SpecChar != null && this.m_SpecChar.equals("Y")) {
                myAppServer.submitSASCode("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;");
            }
            mytablelist = myAppServer.submitSQLStatement("Select MEMNAME from dictionary.tables where libname=\"" + strLibRef.toUpperCase() + "\" and MEMTYPE in (\"DATA\", \"VIEW\")");
            MVAResultSetMetaData metadata = (MVAResultSetMetaData)mytablelist.getMetaData();
            int count = metadata.getColumnCount();
            mytablelist.next();
            if (mytablelist.getRow() <= 0 || count <= 0) {
                myParent.setCursor(null);
                this.showSASLogDialog(myAppServer);
                return false;
            }
            myParent.addWizardData("MVARESULT", (Object)mytablelist);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.showSASLogDialog(myAppServer);
            myParent.addWizardData("MVARESULT", mytablelist);
        }
        try {
            this.m_appPanel.saveSelectedLibraryToAppDefaultFile();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        myParent.setCursor(null);
        return true;
    }

    private boolean showSASLogWithMessage(String sMessage, WsAppServer myAppServer) {
        int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (eAnswer == 0) {
            try {
                SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("DBMSConnectWizardTab.ShowLog.title.txt"), true, myAppServer.getLog());
                dlg.show();
            }
            catch (WsAppServerFailException ex2) {
                MessageUtil.displayMessage((String)ex2.getLocalizedMessage(), (int)0);
                return false;
            }
        }
        return true;
    }

    protected void setEngineType(String engineType) {
        this.m_engineType = engineType;
    }

    public void setTabProperty(String propertyName, Object propertyValue) {
        super.setTabProperty(propertyName, propertyValue);
        if (propertyName.equalsIgnoreCase(LIBRARYPANEL_EDITABLE)) {
            boolean editable = (Boolean)propertyValue;
            this.m_appPanel.setEditable(editable);
        }
        if (propertyName.equalsIgnoreCase(HELP_PRODUCT)) {
            String helpset = (String)propertyValue;
            this.setHelpProduct(helpset);
        }
    }

    protected void showSASLogDialog(WsAppServer appServer) {
        String sMessage = bundle.getString("DBMSConnectWizardTab.ErrorNoTables.txt");
        int choice = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (choice == 0) {
            String sTitle = bundle.getString("DBMSConnectWizardTab.ShowLog.title.txt");
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), sTitle, true, appServer);
            dlg.show();
        }
    }

    protected void showErrorDialog(WAWizardDialog parent, WsAppServer appServer) {
        Object[] longMessage = new Object[]{bundle.getString("DBMSConnectWizardTab.ErrorNoTables1.txt"), bundle.getString("DBMSConnectWizardTab.ErrorNoTables2.txt")};
        Object[] warningOptions = new Object[]{bundle.getString("Common.Yes.txt"), bundle.getString("Common.No.txt")};
        int choice = JOptionPane.showOptionDialog((Component)Workspace.getWorkspace(), longMessage, bundle.getString("DBMSConnectErrorDialog.Title.txt"), 0, 2, null, warningOptions, warningOptions[0]);
        if (choice == 0) {
            if (appServer != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                cSASLogDialog dlg = new cSASLogDialog((Dialog)parent, bundle.getString("DBMSConnectWizardTab.ShowLog.title.txt"), true, appServer);
                dlg.show();
                dlg.dispose();
                this.setCursor(null);
            } else {
                MessageUtil.displayMessage((String)bundle.getString("DBMSConnectWizardTab.cannotdisplaylog.txt"), (int)2);
            }
        }
    }

    class cSASLogDialog
    extends WAStandardDialog {
        WAPanel m_centerPanel;
        WsAppServer m_appServer;
        protected LogListViewer m_logView;

        public cSASLogDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
            super(dlgOwner, sTitle, bModal);
            this.m_appServer = null;
            this.m_logView = null;
            this._initialize();
            this._layoutWidgets();
        }

        public cSASLogDialog(Frame dlgOwner, String sTitle, boolean bModal) {
            super(dlgOwner, sTitle, bModal);
            this.m_appServer = null;
            this.m_logView = null;
            this._initialize();
            this._layoutWidgets();
        }

        public cSASLogDialog(Dialog dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
            super(dlgOwner, sTitle, bModal);
            this.m_appServer = null;
            this.m_logView = null;
            this.m_appServer = server;
            this._initialize();
            this._layoutWidgets();
        }

        public cSASLogDialog(Frame dlgOwner, String sTitle, boolean bModal, WsAppServer server) {
            super(dlgOwner, sTitle, bModal);
            this.m_appServer = null;
            this.m_logView = null;
            this.m_appServer = server;
            this._initialize();
            this._layoutWidgets();
        }

        protected void _initialize() {
            this.setHelpProduct("texteditor");
            this.setHelpTopic("logspace");
            super.initialize();
        }

        protected void _layoutWidgets() {
            super.layoutWidgets();
            this.m_centerPanel = new WAPanel();
            this.m_centerPanel.setLayout((LayoutManager)new BorderLayout());
            this.m_centerPanel.add((Component)this.m_logView);
            this.setMainPanel(this.m_centerPanel);
        }

        public boolean doDataExchange(boolean saveToModel) {
            return true;
        }

        public boolean validateData() {
            return true;
        }
    }
}

