/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.visuals.CustomTreeUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.plugins.TreeNodeInterface;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class CustomTreeModel
extends WorkspaceTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(CustomTreeModel.class);
    private List m_lRepositories;
    private MdObjectStore m_store;
    private boolean m_bUserStore;
    private boolean m_bAddUngrouped;
    private UngroupedFilter m_filterUngrouped;

    public CustomTreeModel() {
        super(new WsTreeNode("root"));
        this.setListenForChanges(false);
        this.setRoot(this.createDefaultRootNode());
        this.setRepositories(Workspace.getWorkspace().getSelectedRepositories());
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore(null, "CustomTreeModel");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.setAddingUngrouped(true);
        this.setUngroupedFilter(this.createDefaultUngroupedFilter());
    }

    public void dispose() {
        try {
            if (!this.m_bUserStore) {
                this.getStore().dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        super.dispose();
    }

    public void setRoot(WsTreeNode node) {
        super.setRoot((TreeNode)node);
        node.setModel((WorkspaceTreeModel)this);
    }

    public void setRepositories(List lRepositories) {
        this.m_lRepositories = lRepositories;
    }

    public List getRepositories() {
        return this.m_lRepositories;
    }

    public void setStore(MdObjectStore store) {
        try {
            if (!this.m_bUserStore && this.m_store != null) {
                this.m_store.dispose();
            }
            this.m_store = store;
            this.m_bUserStore = true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    public void setAddingUngrouped(boolean bAddUngrouped) {
        this.m_bAddUngrouped = bAddUngrouped;
    }

    public boolean isAddingUngrouped() {
        return this.m_bAddUngrouped;
    }

    public void setUngroupedFilter(UngroupedFilter filterUngrouped) {
        this.m_filterUngrouped = filterUngrouped;
    }

    public UngroupedFilter getUngroupedFilter() {
        return this.m_filterUngrouped;
    }

    protected WsTreeNode createDefaultRootNode() {
        return new RootTreeNode();
    }

    protected NodeFilter createDefaultNodeFilter() {
        return new DefaultNodeFilter();
    }

    protected UngroupedFilter createDefaultUngroupedFilter() {
        return new DefaultUngroupedFilter();
    }

    protected NodeFactory createDefaultNodeFactory() {
        return new DefaultNodeFactory();
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (!this.m_nodeRoot.hasExpanded()) {
            this.m_nodeRoot.addChildren();
        }
    }

    public WsDataTreeNode find(Root mdoData) throws MdException, RemoteException {
        String sRepositoryFQID = "A0000001." + mdoData.getRepositoryID();
        RepositoryTreeNode nodeRepository = (RepositoryTreeNode)this.find((WsTreeNode)this.getRoot(), sRepositoryFQID);
        if (nodeRepository == null) {
            return null;
        }
        List lPathTrees = CustomTreeUtilities.getPath(mdoData, nodeRepository.getMetadataTree(), this.m_store);
        if (lPathTrees.size() != 0) {
            TreeTreeNode nodeTree = nodeRepository;
            for (int iTree = 1; iTree < lPathTrees.size(); ++iTree) {
                Tree mdoTree = (Tree)lPathTrees.get(iTree);
                if ((nodeTree = (TreeTreeNode)this.find((WsTreeNode)nodeTree, mdoTree.getFQID())) != null) continue;
                return null;
            }
            return (WsDataTreeNode)this.find((WsTreeNode)nodeTree, mdoData.getFQID());
        }
        WsTreeNode nodeUngrouped = nodeRepository.getUngroupedNode();
        if (nodeUngrouped == null) {
            return null;
        }
        return null;
    }

    protected WsTreeNode find(WsTreeNode node, String sFQID) {
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)node.getChildAt(iChild);
            if (!sFQID.equals(nodeChild.getFQID())) continue;
            return nodeChild;
        }
        return null;
    }

    public static class UngroupedTreeNode
    extends WsTreeNode {
        private Root m_mdoRepository;
        private Tree m_mdoRoot;

        public UngroupedTreeNode(Root mdoRepository, Tree mdoRoot) {
            super(bundle.getString("ObjectsSelectorTreeModel.Ungrouped.txt"));
            this.m_mdoRepository = mdoRepository;
            this.m_mdoRoot = mdoRoot;
        }

        public int getChildCount() {
            if (!this.hasExpanded()) {
                this.setHasExpanded(true);
                this.createChildren();
            }
            return super.getChildCount();
        }

        protected void createChildren() {
            CustomTreeModel model = (CustomTreeModel)this.m_Model;
            UngroupedFilter filter = model.getUngroupedFilter();
            if (filter == null) {
                return;
            }
            try {
                filter.setRootTree(this.m_mdoRoot);
                String sRepositoryFQID = this.m_mdoRepository.getFQID();
                String[] saTypes = filter.getTypes();
                for (int iType = 0; iType < saTypes.length; ++iType) {
                    StringBuffer sbOptions = new StringBuffer(100);
                    sbOptions.append("<Templates><");
                    sbOptions.append(saTypes[iType]);
                    sbOptions.append("><Trees/></");
                    sbOptions.append(saTypes[iType]);
                    sbOptions.append("><Tree><Groups/></Tree></Templates>");
                    int fFlags = 268;
                    String sSelect = filter.getXMLSelect(saTypes[iType]);
                    if (sSelect != null) {
                        fFlags |= 0x80;
                        sbOptions.append("<XMLSELECT Search=\"");
                        sbOptions.append(sSelect);
                        sbOptions.append("\"/>");
                    }
                    List lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)model.getStore(), sRepositoryFQID, saTypes[iType], fFlags, sbOptions.toString());
                    for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                        Root mdoObject = (Root)lObjects.get(iObject);
                        if (!filter.accept(mdoObject)) continue;
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }

    public static class TreeTreeNode
    extends WsDataTreeNode {
        private Tree m_mdoTree;
        private Icon m_iconNormal;
        private Icon m_iconExpanded;

        public TreeTreeNode(Root mdo) {
            super((CMetadata)mdo);
            try {
                if (mdo.getCMetadataType().equals("Tree")) {
                    Tree mdoTree = (Tree)mdo;
                    this.setMetadataTree(mdoTree);
                    String sTreeType = mdoTree.getTreeType();
                    this.m_iconNormal = bundle.getTreeTypeIcon(sTreeType, false, false);
                    this.m_iconExpanded = bundle.getTreeTypeIcon(sTreeType, true, false);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public int getChildCount() {
            if (!this.hasExpanded()) {
                this.setHasExpanded(true);
                this.createChildren();
            }
            return super.getChildCount();
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? this.m_iconExpanded : this.m_iconNormal;
        }

        public void setMetadataTree(Tree mdoTree) {
            this.m_mdoTree = mdoTree;
        }

        public Tree getMetadataTree() {
            return this.m_mdoTree;
        }

        protected void createChildren() {
            try {
                CustomTreeModel model = (CustomTreeModel)this.m_Model;
                AssociationList lMembers = this.getMetadataTree().getMembers();
                for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                    Root mdoMember = (Root)lMembers.get(iMember);
                    if (!model.getNodeFilter().accept(mdoMember, (WsTreeNode)this)) continue;
                }
                AssociationList lSubTrees = this.getMetadataTree().getSubTrees();
                for (int iSubTree = 0; iSubTree < lSubTrees.size(); ++iSubTree) {
                    Tree mdoSubTree = (Tree)lSubTrees.get(iSubTree);
                    if (!model.getNodeFilter().accept((Root)mdoSubTree, (WsTreeNode)this)) continue;
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public static class RepositoryTreeNode
    extends TreeTreeNode {
        private WsTreeNode m_nodeUngrouped;

        public RepositoryTreeNode(Root mdoRepository) {
            super(mdoRepository);
        }

        public Root getRepository() {
            return (Root)this.getMetadata();
        }

        @Override
        public Icon getIcon(boolean bExpanded) {
            return this.getIcon();
        }

        @Override
        protected void createChildren() {
            CustomTreeModel model = (CustomTreeModel)this.m_Model;
            try {
                Tree mdoRoot = CustomTreeUtilities.getRoot(this.m_oMetadata.getFQID(), model.getStore());
                if (mdoRoot != null) {
                    this.setMetadataTree(mdoRoot);
                    super.createChildren();
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (model.isAddingUngrouped()) {
                WsTreeNode nodeUngrouped = this.getUngroupedNode();
                if (nodeUngrouped == null) {
                    nodeUngrouped = this.createUngroupedNode();
                    this.setUngroupedNode(nodeUngrouped);
                }
                this.addChild(nodeUngrouped);
            }
        }

        public WsTreeNode getUngroupedNode() {
            return this.m_nodeUngrouped;
        }

        public void setUngroupedNode(WsTreeNode nodeUngrouped) {
            this.m_nodeUngrouped = nodeUngrouped;
        }

        protected WsTreeNode createUngroupedNode() {
            return new UngroupedTreeNode(this.getRepository(), this.getMetadataTree());
        }
    }

    public static class RootTreeNode
    extends WsTreeNode {
        public RootTreeNode() {
            super("Repositories");
        }

        public void addChildren() {
            this.createChildren();
        }

        public void createChildren() {
            this.setHasExpanded(true);
            CustomTreeModel model = (CustomTreeModel)this.m_Model;
            List lRepositories = model.getRepositories();
            for (int iRepository = 0; iRepository < lRepositories.size(); ++iRepository) {
                Root mdoRepository = (Root)lRepositories.get(iRepository);
                if (!model.getNodeFilter().accept(mdoRepository, (WsTreeNode)this)) continue;
            }
        }
    }

    public static class PackageNodeFactory
    extends DefaultNodeFactory {
        private Package m_pkg;
        private String m_sPostfix;
        private boolean m_bPluginsEnabled;

        public PackageNodeFactory(Package pkg) {
            this.m_pkg = pkg;
            this.m_sPostfix = "TreeNode";
        }

        public void setPackage(Package pkg) {
            this.m_pkg = pkg;
        }

        public Package getPackage() {
            return this.m_pkg;
        }

        public void setPostfix(String sPostfix) {
            this.m_sPostfix = sPostfix;
        }

        public String getPostfix() {
            return this.m_sPostfix;
        }

        public void setPluginsEnabled(boolean bEnabled) {
            this.m_bPluginsEnabled = bEnabled;
        }

        public boolean isPluginsEnabled() {
            return this.m_bPluginsEnabled;
        }

        @Override
        public WsTreeNode createNode(Root mdo, WsTreeNode nodeParent) {
            try {
                WsTreeNode node;
                if (mdo.getCMetadataType().equals("Environment") || mdo.getCMetadataType().equals("Tree")) {
                    return super.createNode(mdo, nodeParent);
                }
                String sType = mdo.getCMetadataType();
                if (this.isPluginsEnabled()) {
                    ArrayList lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.workspace.plugins.TreeNodeInterface");
                    for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
                        TreeNodeInterface plugin = (TreeNodeInterface)lPlugins.get(iPlugin);
                        if (!sType.equals(plugin.getCMetadataType())) continue;
                        return plugin.getDataTreeNode((CMetadata)mdo);
                    }
                }
                if ((node = this.createTypeNode(mdo, sType)) == null && (node = this.createTypeNode(mdo, "Root")) == null) {
                    node = super.createNode(mdo, nodeParent);
                }
                return node;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }

        private WsTreeNode createTypeNode(Root mdo, String sType) {
            Class[] aClasses = new Class[]{mdo.getClass()};
            Object[] aObjects = new Object[]{mdo};
            try {
                Class<?> clsNode = Class.forName(this.getPackage().getName() + "." + sType + this.getPostfix());
                return (WsTreeNode)Workspace.getMdFactory().getUtil().findValidConstructor(clsNode, aClasses).newInstance(aObjects);
            }
            catch (ClassNotFoundException clsNode) {
            }
            catch (InvocationTargetException clsNode) {
            }
            catch (IllegalAccessException clsNode) {
            }
            catch (NoSuchMethodException clsNode) {
            }
            catch (InstantiationException clsNode) {
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return null;
        }
    }

    public static class DefaultNodeFactory
    implements NodeFactory {
        @Override
        public WsTreeNode createNode(Root mdo, WsTreeNode nodeParent) {
            try {
                if (mdo.getCMetadataType().equals("Environment")) {
                    return new RepositoryTreeNode(mdo);
                }
                if (mdo.getCMetadataType().equals("Tree")) {
                    return new TreeTreeNode(mdo);
                }
                return new WsDataTreeNode((CMetadata)mdo);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }
    }

    public static class DefaultUngroupedFilter
    implements UngroupedFilter {
        private Group m_mdoRootGroup;
        private String[] m_saTypes = new String[]{"Cube", "PhysicalTable", "SASLibrary", "Job", "ExternalTable", "Document", "TextStore"};

        @Override
        public String[] getTypes() {
            return this.m_saTypes;
        }

        public void setTypes(String[] saTypes) {
            this.m_saTypes = saTypes;
        }

        @Override
        public String getXMLSelect(String sType) {
            if (sType.equals("TextStore")) {
                return "TextStore[@TextRole='Note']";
            }
            return null;
        }

        @Override
        public void setRootTree(Tree mdoRoot) throws MdException, RemoteException {
            AssociationList lGroups;
            this.m_mdoRootGroup = null;
            if (mdoRoot != null && !(lGroups = mdoRoot.getGroups()).isEmpty()) {
                this.m_mdoRootGroup = (Group)lGroups.get(0);
            }
        }

        @Override
        public boolean accept(Root mdoObject) throws MdException, RemoteException {
            if (this.m_mdoRootGroup == null) {
                return true;
            }
            AssociationList lTrees = mdoObject.getTrees();
            for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
                Group mdoTreeGroup;
                Tree mdoTree = (Tree)lTrees.get(iTree);
                AssociationList lGroups = mdoTree.getGroups();
                if (lGroups.isEmpty() || !(mdoTreeGroup = (Group)lGroups.get(0)).getFQID().equals(this.m_mdoRootGroup.getFQID())) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DefaultNodeFilter
    implements NodeFilter {
        protected DefaultNodeFilter() {
        }

        @Override
        public boolean accept(Root mdo, WsTreeNode nodeParent) {
            return true;
        }
    }

    public static interface NodeFactory {
        public WsTreeNode createNode(Root var1, WsTreeNode var2);
    }

    public static interface UngroupedFilter {
        public String[] getTypes();

        public String getXMLSelect(String var1);

        public void setRootTree(Tree var1) throws MdException, RemoteException;

        public boolean accept(Root var1) throws MdException, RemoteException;
    }

    public static interface NodeFilter {
        public boolean accept(Root var1, WsTreeNode var2);
    }
}

