/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;

public class ComboButton
extends JPanel {
    public static final String SHORT_NAME = "ComboButton.SHORT_NAME";
    public static final String SHORT_NAME_MNEMONIC = "ComboButton.SHORT_NAME_MNEMONIC";
    protected static final int NORMAL = 1;
    protected static final int MOUSE_OVER = 2;
    protected static final int COMBO_DISPLAYED = 3;
    protected JButton m_btnDefault;
    protected JButton m_btnOptions;
    protected int m_eVisualState;
    protected Action m_actDefault;
    protected ArrayList m_alOptionActions;
    protected Object m_callbackObject;
    private static WAdminResource bundle = WAdminResource.getBundle(ComboButton.class);

    public ComboButton() {
        this(null, null);
    }

    public ComboButton(Action actDefault, ArrayList alOptionActions) {
        this.initialize();
        this.layoutWidgets();
        this.setDefaultAction(actDefault);
        this.setOptionActions(alOptionActions);
    }

    public void setDefaultAction(Action actDefault) {
        Integer mnem;
        this.m_actDefault = actDefault;
        this.m_btnDefault.setAction(actDefault);
        if (actDefault != null && (mnem = (Integer)actDefault.getValue("MnemonicKey")) != null) {
            this.m_btnDefault.setMnemonic(mnem);
        }
    }

    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    public void setOptionActions(ArrayList alOptionActions) {
        this.m_alOptionActions = alOptionActions;
    }

    public ArrayList getOptionActions() {
        return this.m_alOptionActions;
    }

    public void addOptionAction(Action actOption) {
        this.m_alOptionActions.add(actOption);
    }

    public void removeOptionAction(Action actOption) {
        this.m_alOptionActions.remove(actOption);
    }

    protected void setVisualState(int eVisualState) {
        if (eVisualState != this.m_eVisualState) {
            this.m_eVisualState = eVisualState;
            this.repaint();
        }
    }

    protected int getVisualState() {
        return this.m_eVisualState;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.m_btnDefault.setEnabled(bEnabled);
        this.m_btnOptions.setEnabled(bEnabled);
    }

    protected void displayMenu() {
        JPopupMenu menu = new JPopupMenu();
        int nOptionActions = this.m_alOptionActions.size();
        for (int iOptionAction = 0; iOptionAction < nOptionActions; ++iOptionAction) {
            Object oDefault;
            Integer mnem;
            Action actOption = (Action)this.m_alOptionActions.get(iOptionAction);
            JMenuItem miOption = new JMenuItem(actOption);
            menu.add(miOption);
            String sShortName = (String)actOption.getValue(SHORT_NAME);
            if (sShortName != null) {
                miOption.setText(sShortName);
            }
            if ((mnem = (Integer)actOption.getValue(SHORT_NAME_MNEMONIC)) != null) {
                miOption.setMnemonic(mnem);
            }
            if ((oDefault = actOption.getValue("Default")) == null || !(oDefault instanceof Boolean) || !((Boolean)oDefault).booleanValue()) continue;
            Font fntBold = miOption.getFont().deriveFont(1);
            miOption.setFont(fntBold);
        }
        menu.show(this, 0, this.getHeight());
    }

    protected void initialize() {
        this.m_eVisualState = 1;
        MouseListener lsnrMouse = this.createMouseListener();
        this.m_btnDefault = this.createDefaultButton(lsnrMouse);
        this.m_btnOptions = this.createOptionsButton(lsnrMouse);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_btnDefault, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_btnOptions, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JButton createDefaultButton(MouseListener lsnrMouse) {
        JButton btnDefault = new JButton();
        btnDefault.setBorder(new CompoundBorder(new cButtonBorder(true), new BasicBorders.MarginBorder()));
        btnDefault.setDefaultCapable(false);
        btnDefault.addMouseListener(lsnrMouse);
        return btnDefault;
    }

    protected JButton createOptionsButton(MouseListener lsnrMouse) {
        JButton btnOptions = new JButton(bundle.getImageIcon("ComboButton.Icon.Arrow.image"));
        btnOptions.setToolTipText(bundle.getString("ComboButton.PulldownToolTip.txt"));
        btnOptions.setMargin(new Insets(1, 1, 1, 1));
        btnOptions.setBorder(new CompoundBorder(new cButtonBorder(false), new BasicBorders.MarginBorder()));
        btnOptions.addMouseListener(lsnrMouse);
        btnOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ComboButton.this.displayMenu();
            }
        });
        return btnOptions;
    }

    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    protected class cButtonBorder
    extends AbstractBorder {
        protected boolean m_bLeftButton;
        protected Color m_clrControl;
        protected Color m_clrShadow;
        protected Color m_clrDarkShadow;
        protected Color m_clrHighlight;
        protected Color m_clrLightHighlight;

        public cButtonBorder(boolean bLeftButton) {
            this.m_bLeftButton = bLeftButton;
            this.m_clrControl = UIManager.getColor("control");
            this.m_clrHighlight = UIManager.getColor("controlHighlight");
            this.m_clrLightHighlight = UIManager.getColor("controlLtHighlight");
            this.m_clrDarkShadow = UIManager.getColor("controlDkShadow");
            this.m_clrShadow = UIManager.getColor("controlShadow");
        }

        @Override
        public void paintBorder(Component cmp, Graphics g, int x, int y, int w, int h) {
            boolean bPressed;
            Color clrOld = g.getColor();
            g.translate(x, y);
            AbstractButton btn = (AbstractButton)cmp;
            ButtonModel mdl = btn.getModel();
            boolean bl = bPressed = mdl.isPressed() && mdl.isArmed();
            if (bPressed) {
                g.setColor(this.m_clrDarkShadow);
                g.drawRect(0, 0, w - 1, h - 1);
                g.setColor(this.m_clrShadow);
                g.drawRect(1, 1, w - 3, h - 3);
            } else {
                g.setColor(this.m_clrLightHighlight);
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(this.m_clrHighlight);
                g.drawLine(0, 1, w - 1, 1);
                g.setColor(this.m_clrShadow);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(this.m_clrDarkShadow);
                g.drawLine(0, h - 1, w - 1, h - 1);
                if (this.m_bLeftButton || ComboButton.this.getVisualState() == 2) {
                    g.setColor(this.m_clrLightHighlight);
                    g.drawLine(0, 1, 0, h - 2);
                    g.setColor(this.m_clrHighlight);
                    g.drawLine(1, 2, 1, h - 3);
                } else {
                    g.setColor(this.m_clrControl);
                    g.drawLine(0, 2, 0, h - 3);
                    g.drawLine(1, 2, 1, h - 3);
                }
                if (!this.m_bLeftButton || ComboButton.this.getVisualState() == 2) {
                    g.setColor(this.m_clrShadow);
                    g.drawLine(w - 2, 1, w - 2, h - 3);
                    g.setColor(this.m_clrDarkShadow);
                    g.drawLine(w - 1, 0, w - 1, h - 2);
                } else {
                    g.setColor(this.m_clrControl);
                    g.drawLine(w - 2, 2, w - 2, h - 3);
                    g.drawLine(w - 1, 2, w - 1, h - 3);
                }
            }
            g.translate(-x, -y);
            g.setColor(clrOld);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }
    }

    protected class cMouseListener
    extends MouseAdapter {
        protected cMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComboButton.this.setVisualState(2);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ComboButton.this.getVisualState() == 2) {
                ComboButton.this.setVisualState(1);
            }
        }
    }
}

