/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.visuals.ActionOptionsPanel;
import com.sas.wadmin.visuals.CodeConditionTableModel;
import com.sas.wadmin.visuals.EventOptionsPanel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.ExpressionBuilderTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;

public class CodeConditionPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(CodeConditionPropertyTab.class);
    protected CodeConditionTableModel m_mdlCodeConditions;
    protected MdObjectStore m_parentStore;
    protected PropertyType m_propertyType = null;
    protected MdObjectStore m_objectStore;
    protected CMetadata m_Metadata;
    protected MdFactory m_factory;
    protected WsTable m_tblCodeConditions;
    protected JScrollPane m_scrCodeConditions;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JButton m_btnActionOptions;
    protected JPanel m_pnlButtons;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actActionOptions;
    protected boolean m_bShowButtons;

    public CodeConditionPropertyTab(CMetadata iMeta, List iCodeActionCombos) {
        this(iMeta, iCodeActionCombos, true);
    }

    public CodeConditionPropertyTab(CMetadata iMeta, List iCodeActionCombos, boolean bShowButtons) {
        this.m_Metadata = iMeta;
        this.m_mdlCodeConditions = new CodeConditionTableModel(iMeta, iCodeActionCombos);
        this.m_bShowButtons = bShowButtons;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.createActions();
        this.m_tblCodeConditions = new cPopUpOnColumnTable(this.m_mdlCodeConditions);
        this.m_tblCodeConditions.setToolTipText(bundle.getString("CodeConditionPropertyTab.Table.ToolTip.txt"));
        this.m_tblCodeConditions.setRowsReorderable(false);
        this.m_tblCodeConditions.setRowHoldingEnabled(false);
        this.m_tblCodeConditions.setColumnsReorderable(false);
        this.m_tblCodeConditions.setColumnHoldingEnabled(false);
        this.m_tblCodeConditions.setAutoResizeMode(4);
        this.m_tblCodeConditions.setUndoManager((UndoManager)this.waum);
        this.m_tblCodeConditions.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        this.m_mdlCodeConditions.addTableModelListener(this.createTableModelListener());
        this.m_tblCodeConditions.setRowHeaderPopupMenuRequestListener(this.createRowHeaderPopupMenuRequestListener());
        this.m_tblCodeConditions.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
        this.m_tblCodeConditions.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
        this.m_tblCodeConditions.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblCodeConditions.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_scrCodeConditions = new JScrollPane((Component)this.m_tblCodeConditions);
        this.setHelpProduct("wdb");
        this.setHelpTopic("status_handling_tab");
        this.createButtonsPanel();
    }

    protected void createButtonsPanel() {
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnActionOptions = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actActionOptions);
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        pnlRight.add(this.m_btnActionOptions);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout(0, 5));
        this.add(this.m_scrCodeConditions, "Center");
        if (this.m_bShowButtons) {
            this.add(this.m_pnlButtons, "South");
        }
    }

    public boolean validateData() {
        if (!this.m_tblCodeConditions.stopCellEditing()) {
            return false;
        }
        int nRows = this.m_tblCodeConditions.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            try {
                Property oProperty = (Property)this.m_mdlCodeConditions.getValueAt(iRow, 3);
                AssociationList lActionOptions = oProperty.getProperties();
                if (oProperty.getDefaultValue().equals("Event") && lActionOptions.size() == 0) {
                    MessageUtil.displayMessage((String)bundle.getString("CodeConditionPropertyTab.MissingOptionsMessage.txt"), (String)bundle.getString("CodeConditionPropertyTab.MissingOptionsTitle.txt"), (int)0, (int)-1);
                    return false;
                }
                for (int iActionOption = 0; iActionOption < lActionOptions.size(); ++iActionOption) {
                    Property lActionOption = (Property)lActionOptions.get(iActionOption);
                    if (!lActionOption.getDefaultValue().equals("")) continue;
                    MessageUtil.displayMessage((String)bundle.getString("CodeConditionPropertyTab.MissingOptionsMessage.txt"), (String)bundle.getString("CodeConditionPropertyTab.MissingOptionsTitle.txt"), (int)0, (int)-1);
                    return false;
                }
                String sActionName = (String)this.m_mdlCodeConditions.getValueAt(iRow, 1);
                if (sActionName != null && !sActionName.equals("")) continue;
                MessageUtil.displayMessage((String)bundle.getString("CodeConditionPropertyTab.NoActionsFoundForCodeCondition.msg.txt"), (String)bundle.getString("CodeConditionPropertyTab.NoActionsFoundTitle.txt"), (int)0, (int)-1);
                return false;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblCodeConditions.setEditable(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && this.m_tblCodeConditions.getSelectedRows().length > 0);
        int[] aSelectedRows = this.m_tblCodeConditions.getSelectedRowsFromSelectedCells();
        boolean bSelectedIsNone = false;
        boolean bAnyOptions = false;
        if (aSelectedRows.length > 0) {
            String sName = (String)this.m_mdlCodeConditions.getValueAt(aSelectedRows[0], 1);
            if (sName.equals("None") || sName.equals("")) {
                bSelectedIsNone = true;
            }
            try {
                Property oProperty = (Property)this.m_mdlCodeConditions.getValueAt(aSelectedRows[0], 3);
                if (oProperty != null && !oProperty.getProperties().isEmpty()) {
                    bAnyOptions = true;
                }
            }
            catch (MdException oProperty) {
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            bSelectedIsNone = true;
        }
        this.m_actActionOptions.setEnabled(bEditable && this.m_tblCodeConditions.getSelectedRows().length == 1 && !bSelectedIsNone && bAnyOptions);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlCodeConditions.populateStore();
        this.m_factory = Workspace.getWorkspace().getMdObjectFactory();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlCodeConditions.moveDataToModel();
        if (this.m_mdlCodeConditions.getRowCount() > 0) {
            this.m_tblCodeConditions.selectCell(0, 0);
        }
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_mdlCodeConditions.moveDataToStore();
        this.setDataChanged(false);
    }

    public void setOwningStore(MdObjectStore store) {
        this.m_objectStore = store;
    }

    public List getCodeConditionsList() {
        return this.m_mdlCodeConditions.getCodeConditionsList();
    }

    public CodeConditionTableModel getModel() {
        return this.m_mdlCodeConditions;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actActionOptions.setActive(bActive);
    }

    protected void createNewRow() {
        if (this.m_mdlCodeConditions.m_DefaultCodeConditions.isEmpty()) {
            MessageUtil.displayMessage((String)bundle.getString("CodeConditionPropertyTab.Error.txt"), (int)0);
            return;
        }
        this.m_tblCodeConditions.undoableInsertNewRowAfterLastSelectedRow();
        List vCodeConditions = this.m_mdlCodeConditions.m_vCodeConditions;
        boolean bEventFound = false;
        Event oEvent = null;
        int[] aSelectedRows = this.m_tblCodeConditions.getSelectedRowsFromSelectedCells();
        int iNewRow = aSelectedRows[0];
        Property oDefaultEvent = (Property)this.m_mdlCodeConditions.m_CodeConditionProperties.get(0);
        String sName = (String)this.m_mdlCodeConditions.m_DefaultCodeConditions.get(0);
        Property oProperty = null;
        try {
            Property oActionProperty = this.m_mdlCodeConditions.m_NoneAction;
            oProperty = this.m_mdlCodeConditions.createActionProperty(oActionProperty);
            for (int iCodeCondition = 0; iCodeCondition < vCodeConditions.size(); ++iCodeCondition) {
                if (!sName.equals(((Event)vCodeConditions.get(iCodeCondition)).getName())) continue;
                bEventFound = true;
                oEvent = (Event)vCodeConditions.get(iCodeCondition);
                break;
            }
            if (!bEventFound) {
                oEvent = (Event)this.m_factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), sName, "Event", this.m_Metadata.getRepositoryID());
                oEvent.setDesc("CodeCondition");
                oEvent.setEventRole(oDefaultEvent.getDefaultValue());
                oEvent.setCondition(this.m_mdlCodeConditions.getEventCondition(oEvent));
                PropertySet oPropSet = (PropertySet)this.m_factory.createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), bundle.getString("CodeConditionPropertyTab.PropertySetName.notrans"), "PropertySet", oEvent.getRepositoryID());
                oPropSet.setSetRole(bundle.getString("CodeConditionPropertyTab.PropertySetRole.notrans"));
                oPropSet.setOwningObject((Root)oEvent);
                oPropSet.getSetProperties().add((Object)oProperty);
                this.m_mdlCodeConditions.m_alTriggeredEvents.add((Object)oEvent);
                this.m_mdlCodeConditions.m_vCodeConditions.add(oEvent);
            } else {
                AssociationList alOldPropertySets = oEvent.getPropertySets();
                for (int iPropertySet = 0; iPropertySet < alOldPropertySets.size(); ++iPropertySet) {
                    PropertySet lPropertySet = (PropertySet)alOldPropertySets.get(iPropertySet);
                    if (!lPropertySet.getName().equals("True Actions")) continue;
                    lPropertySet.getSetProperties().add((Object)oProperty);
                }
            }
            this.m_mdlCodeConditions.setValueAt(oProperty, iNewRow, 3);
            this.m_mdlCodeConditions.setValueAt(oEvent, iNewRow, 2);
            this.m_mdlCodeConditions.setValueAt(oProperty.getName(), iNewRow, 1);
            this.m_mdlCodeConditions.setValueAt(sName, iNewRow, 0);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createRowHeaderPopupMenuRequestListener() {
        return new cRowHeaderPopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void addSpaceIconToPopupMenu(JPopupMenu mnuPopup) {
        ImageIcon iconSpace = bundle.getImageIcon("Common.EmptyIcon.image");
        int nItems = mnuPopup.getComponentCount();
        for (int iItem = 0; iItem < nItems; ++iItem) {
            JMenuItem mi;
            Component cmp = mnuPopup.getComponent(iItem);
            if (!(cmp instanceof JMenuItem) || (mi = (JMenuItem)cmp).getIcon() != null) continue;
            mi.setIcon(iconSpace);
        }
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actActionOptions = this.createActionOptionsAction();
    }

    protected void updateActions() {
        int[] aSelectedRows = this.m_tblCodeConditions.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bSelected = aSelectedRows.length > 0;
        boolean bOneSelected = aSelectedRows.length == 1;
        boolean bSelectedIsNone = false;
        boolean bAnyOptions = false;
        if (aSelectedRows.length > 0) {
            try {
                Property oProperty;
                String sName = (String)this.m_mdlCodeConditions.getValueAt(aSelectedRows[0], 1);
                if (sName != null && (sName.equals(this.m_mdlCodeConditions.m_NoneAction.getName()) || sName.equals(""))) {
                    bSelectedIsNone = true;
                }
                if ((oProperty = (Property)this.m_mdlCodeConditions.getValueAt(aSelectedRows[0], 3)) != null && !oProperty.getProperties().isEmpty()) {
                    bAnyOptions = true;
                }
            }
            catch (MdException sName) {
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        } else {
            bSelectedIsNone = true;
        }
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actActionOptions.setEnabled(bEditable && bOneSelected && !bSelectedIsNone && bAnyOptions);
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createActionOptionsAction() {
        return new cActionOptionsAction();
    }

    protected class cPopUpOnColumnTable
    extends WsTable {
        public cPopUpOnColumnTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                int iRow = this.editingRow;
                int iCol = this.editingColumn;
                Object oldValue = this.getValueAt(iRow, iCol);
                super.editingStopped(e);
                Object newValue = this.getValueAt(iRow, iCol);
                if (newValue != null && !oldValue.equals(newValue)) {
                    if (iCol == 1) {
                        CodeConditionPropertyTab.this.m_actActionOptions.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    } else {
                        this.removeEditor();
                    }
                }
            }
        }
    }

    protected class cActionOptionsAction
    extends WsAbstractAction {
        public cActionOptionsAction() {
            super(bundle, "CodeConditionPropertyTab.ActionOptions", true);
            this.setMenuSupportId("actionoptions");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (!CodeConditionPropertyTab.this.m_tblCodeConditions.stopCellEditing()) {
                return;
            }
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                int iSelectedRow = CodeConditionPropertyTab.this.m_tblCodeConditions.convertRowIndexToModel(CodeConditionPropertyTab.this.m_tblCodeConditions.getCurrentRow());
                String oEventName = (String)CodeConditionPropertyTab.this.m_mdlCodeConditions.getValueAt(iSelectedRow, 0);
                Property oProperty = (Property)CodeConditionPropertyTab.this.m_mdlCodeConditions.getValueAt(iSelectedRow, 3);
                String sName = (String)CodeConditionPropertyTab.this.m_mdlCodeConditions.getValueAt(iSelectedRow, 1);
                Property oDefinedProperty = CodeConditionPropertyTab.this.m_mdlCodeConditions.getDefinedAction(sName);
                if (oDefinedProperty != null && !oProperty.getPropertyName().equals(oDefinedProperty.getPropertyName())) {
                    for (int iNewAction = 0; iNewAction < CodeConditionPropertyTab.this.m_mdlCodeConditions.m_Actions.size(); ++iNewAction) {
                        Property oActionProperty = (Property)CodeConditionPropertyTab.this.m_mdlCodeConditions.m_Actions.get(iNewAction);
                        if (!oActionProperty.getName().equals(sName)) continue;
                        try {
                            oProperty.setPropertyName(oActionProperty.getPropertyName());
                            oProperty.setDesc(oActionProperty.getDesc());
                            oProperty.setDefaultValue(oActionProperty.getDefaultValue());
                            String propertyRole = oActionProperty.getPropertyRole();
                            if (propertyRole != null && propertyRole.compareTo("") != 0 && propertyRole.toUpperCase().compareTo("INPUT") != 0) {
                                oProperty.setPropertyRole(oActionProperty.getPropertyRole());
                            }
                            oProperty.setUseValueOnly(oActionProperty.getUseValueOnly());
                            PropertyType oPropType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), null, "String", "PropertyType", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID(), null);
                            oPropType.setSQLType(12);
                            oProperty.setOwningType(oPropType);
                            AssociationList alActionProperties = oActionProperty.getProperties();
                            oProperty.getProperties().removeAllElements();
                            for (int iOption = 0; iOption < alActionProperties.size(); ++iOption) {
                                Property oActionOptionProperty = (Property)oActionProperty.getProperties().get(iOption);
                                Property oOptionProperty = (Property)factory.createComplexMetadataObject((MdObjectStore)CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), oActionOptionProperty.getPropertyName(), "Property", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID());
                                oOptionProperty.setPropertyRole(oActionOptionProperty.getPropertyRole());
                                oOptionProperty.setUseValueOnly(oActionOptionProperty.getUseValueOnly());
                                PropertyType propType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), null, "String", "PropertyType", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID(), null);
                                propType.setSQLType(12);
                                oOptionProperty.setOwningType(propType);
                                oOptionProperty.setDesc(oActionOptionProperty.getDesc());
                                oOptionProperty.setPropertyName(oActionOptionProperty.getPropertyName());
                                oProperty.getProperties().add((Object)oOptionProperty);
                            }
                            break;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            break;
                        }
                    }
                }
                MdObjectStore store = (MdObjectStore)oProperty.getObjectStore();
                MdObjectStore storeDialog = Workspace.getMdFactory().createObjectStore((MdStore)store);
                storeDialog.setIsGotToServerForMetadata(true);
                if (!oProperty.getDefaultValue().equals("None")) {
                    if (oProperty.getDefaultValue().equals("Event")) {
                        EventOptionsPanel pnl = new EventOptionsPanel(oProperty);
                        pnl.setStore(storeDialog);
                        String sEventOptionsDialogTitle = bundle.getString("CodeConditionsPropertyTab.EventOptionsDialogTitle.txt");
                        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sEventOptionsDialogTitle, true, (WAPanel)pnl);
                        dlg.setResizable(true);
                        dlg.show();
                    } else if (oProperty.getDefaultValue().equals("SetTargetToExpression")) {
                        try {
                            FeatureMap mdExpressionFM;
                            ArrayList<PhysicalTable> lTables = new ArrayList<PhysicalTable>(1);
                            if (CodeConditionPropertyTab.this.m_Metadata instanceof FeatureMap && CodeConditionPropertyTab.this.m_Metadata.getName().equals("LOOKUP")) {
                                AssociationProperty mdAssocProp = (AssociationProperty)((FeatureMap)CodeConditionPropertyTab.this.m_Metadata).getSourceSpecifications().get(0);
                                Prototype mdPrototype = mdAssocProp.getOwningPrototype();
                                PhysicalTable mdTargetTable = (PhysicalTable)(mdAssocProp = (AssociationProperty)mdPrototype.getPrototypeProperties().get(100)).getUsingPrototype();
                                if (mdTargetTable != null) {
                                    lTables.add(mdTargetTable);
                                }
                            }
                            ExpressionBuilderTab pnlExprBldr = new ExpressionBuilderTab(new ArrayList(0), lTables, false);
                            Property mdValueProperty = (Property)oProperty.getProperties().get(0);
                            String sExpression = mdValueProperty.getDefaultValue();
                            boolean bNeedsQuotes = false;
                            for (int i = 0; i < lTables.size(); ++i) {
                                bNeedsQuotes |= DBMSNamesPropertyHandler.needQuotes((DataTable)((PhysicalTable)lTables.get(i)));
                            }
                            AssociationList lSpecTargetTrans = mdValueProperty.getSpecTargetTransformations();
                            if (lSpecTargetTrans.isEmpty()) {
                                mdExpressionFM = (FeatureMap)factory.createComplexMetadataObject((MdObjectStore)CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), "Lookup Expression", "FeatureMap", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID());
                                lSpecTargetTrans.add(mdExpressionFM);
                            } else {
                                mdExpressionFM = (FeatureMap)lSpecTargetTrans.get(0);
                            }
                            sExpression = ExpressionParser.detokenizeString((String)sExpression, (AbstractTransformation)mdExpressionFM, (boolean)bNeedsQuotes);
                            pnlExprBldr.setExpression(sExpression);
                            String sExprOptionsDialogTitle = bundle.getString("CodeConditionsPropertyTab.ExprOptionsDialogTitle.txt");
                            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sExprOptionsDialogTitle, true, (WAPanel)pnlExprBldr);
                            dlg.setResizable(true);
                            dlg.show();
                            if (dlg.getReturnValue() == 1) {
                                sExpression = pnlExprBldr.getExpression();
                                if (sExpression.length() > 0 && !sExpression.endsWith(";")) {
                                    sExpression = sExpression + ";";
                                }
                                ArrayList lColumns = new ArrayList();
                                for (int i = 0; i < lTables.size(); ++i) {
                                    lColumns.addAll(((PhysicalTable)lTables.get(i)).getColumns());
                                }
                                sExpression = ExpressionParser.tokenizeString((String)sExpression, lColumns, (AbstractTransformation)mdExpressionFM, (boolean)bNeedsQuotes, (boolean)false);
                                mdValueProperty.setDefaultValue(sExpression);
                            }
                        }
                        catch (MdException mde) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                    } else {
                        boolean anyProperties = true;
                        try {
                            if (oProperty.getProperties().isEmpty()) {
                                anyProperties = false;
                            }
                        }
                        catch (MdException pnlExprBldr) {
                            // empty catch block
                        }
                        if (anyProperties) {
                            ActionOptionsPanel pnl = new ActionOptionsPanel(oProperty, oEventName);
                            pnl.setStore(storeDialog);
                            String sActionOptionsDialogTitle = bundle.getString("CodeConditionsPropertyTab.ActionOptionsDialogTitle.txt");
                            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sActionOptionsDialogTitle, true, (WAPanel)pnl);
                            dlg.setResizable(true);
                            dlg.setHelpProduct("wdb");
                            dlg.setHelpTopic("action_options_win");
                            dlg.show();
                        }
                    }
                }
                storeDialog.dispose();
                CodeConditionPropertyTab.this.updateActions();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "CodeConditionPropertyTab.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            int[] aSelectedRows = CodeConditionPropertyTab.this.m_tblCodeConditions.getSelectedRowsFromSelectedCells();
            for (int i = 0; i < aSelectedRows.length; ++i) {
                try {
                    CodeConditionPropertyTab.this.m_mdlCodeConditions.deleteRowMetadata(aSelectedRows[i]);
                    continue;
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Deleting");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            CodeConditionPropertyTab.this.m_tblCodeConditions.undoableDeleteSelectedRows();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "CodeConditionPropertyTab.New", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionPropertyTab.this.createNewRow();
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actDelete));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actActionOptions));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public class cRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = CodeConditionPropertyTab.this.m_tblCodeConditions.createRowHeaderPopupMenu();
            CodeConditionPropertyTab.this.addSpaceIconToPopupMenu(mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actDelete));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)CodeConditionPropertyTab.this.m_actActionOptions));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cTableModelListener
    implements TableModelListener {
        protected cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            try {
                if (CodeConditionPropertyTab.this.isListeningForChanges()) {
                    CodeConditionPropertyTab.this.setDataChanged(true);
                }
                if (e.getType() == 0) {
                    int iRow = e.getFirstRow();
                    int iCol = e.getColumn();
                    switch (iCol) {
                        case 0: {
                            String sCodeCondition = (String)CodeConditionPropertyTab.this.m_mdlCodeConditions.getValueAt(iRow, iCol);
                            String sAction = (String)CodeConditionPropertyTab.this.m_mdlCodeConditions.getValueAt(iRow, iCol + 1);
                            String[] saActions = CodeConditionPropertyTab.this.m_mdlCodeConditions.getActions(sCodeCondition);
                            for (int iValidAction = 0; iValidAction < saActions.length; ++iValidAction) {
                                String Action2 = saActions[iValidAction];
                                if (!sAction.equals(Action2)) continue;
                                return;
                            }
                            Property oActionProperty = CodeConditionPropertyTab.this.m_mdlCodeConditions.m_NoneAction;
                            Property oProperty = (Property)CodeConditionPropertyTab.this.m_factory.createComplexMetadataObject((MdObjectStore)CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), oActionProperty.getName(), "Property", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID());
                            oProperty.setPropertyName(oActionProperty.getPropertyName());
                            oProperty.setName(oActionProperty.getName());
                            oProperty.setDesc(oActionProperty.getDesc());
                            oProperty.setDefaultValue(oActionProperty.getDefaultValue());
                            String propertyRole = oActionProperty.getPropertyRole();
                            if (propertyRole != null && propertyRole.compareTo("") != 0 && propertyRole.toUpperCase().compareTo("INPUT") != 0) {
                                oProperty.setPropertyRole(oActionProperty.getPropertyRole());
                            }
                            oProperty.setUseValueOnly(oActionProperty.getUseValueOnly());
                            PropertyType oPropType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(CodeConditionPropertyTab.this.m_Metadata.getObjectStore(), null, "String", "PropertyType", CodeConditionPropertyTab.this.m_Metadata.getRepositoryID(), null);
                            oPropType.setSQLType(12);
                            oProperty.setOwningType(oPropType);
                            CodeConditionPropertyTab.this.m_mdlCodeConditions.setValueAt(oProperty, iRow, 3);
                            CodeConditionPropertyTab.this.m_mdlCodeConditions.setValueAt(oProperty.getName(), iRow, 1);
                        }
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CodeConditionPropertyTab.this.updateActions();
        }
    }
}

