/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

class CodeConditionConfigTableModel
extends WsAbstractTableModel {
    protected MdObjectStore m_oStore;
    protected String m_strGroupName;
    protected String m_strPropertyRole;
    protected Group m_mdPropertyGroup;
    protected List m_lInitialProperties;
    protected Property m_mdDefaultProperty;
    protected WsUniqueNameTableColumn m_colPropertyName;
    protected static final int NAME_COLUMN = 0;
    protected static final int METADATA_COLUMN = 1;
    protected static final int COLUMN_COUNT = 1;
    protected static final int HIDDEN_COLUMN_COUNT = 1;

    public CodeConditionConfigTableModel(String strColumnName, String strGroupName, String strPropertyRole) {
        this.m_strGroupName = strGroupName;
        this.m_strPropertyRole = strPropertyRole;
        this.m_colPropertyName = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, strColumnName, 200);
        this.m_colPropertyName.setMaximumCharacters(50);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = this.m_colPropertyName;
        this.m_aColumns[1] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 1;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    protected void setColumnFormatString(String strFormat) {
        this.m_colPropertyName.setFormatString(strFormat);
    }

    public void setStore(MdObjectStore oStore) {
        this.m_oStore = oStore;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        String sOptions = "<XMLSELECT Search=\"Group[@Name='" + this.m_strGroupName + "']\"/><TEMPLATES><Group Id=\"\" Name=\"\" Desc=\"\"><Members/><Properties/></Group></TEMPLATES>";
        List lPropertyGroups = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_oStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "Group", 24972, sOptions);
        if (lPropertyGroups.size() > 0) {
            this.m_mdPropertyGroup = (Group)lPropertyGroups.get(0);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        if (this.m_mdPropertyGroup == null) {
            return;
        }
        AssociationList alProperties = this.m_mdPropertyGroup.getProperties();
        this.m_lInitialProperties = alProperties;
        this.m_mdDefaultProperty = (Property)alProperties.get(0);
        for (int i = 0; i < alProperties.size(); ++i) {
            Property mdProperty = (Property)alProperties.get(i);
            ArrayList<String> alRow = new ArrayList<String>();
            alRow.add(mdProperty.getName());
            alRow.add((String)mdProperty);
            this.m_lData.add(alRow);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        Property mdProperty;
        if (this.m_mdPropertyGroup == null) {
            return;
        }
        ArrayList<Property> alCurrentProperties = new ArrayList<Property>();
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            String strName;
            mdProperty = (Property)this.getValueAt(iRow, 1);
            if (mdProperty != null) {
                strName = (String)this.getValueAt(iRow, 0);
                if (!mdProperty.getName().equals(strName)) {
                    mdProperty.setName(strName);
                    mdProperty.setDesc(strName);
                    mdProperty.setPropertyName(strName);
                }
            } else {
                strName = (String)this.getValueAt(iRow, 0);
                mdProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, strName, "Property", Workspace.getWorkspace().getDefaultRepositoryId());
                mdProperty.setDesc(strName);
                mdProperty.setIsExpert(1);
                mdProperty.setIsUpdateable(1);
                mdProperty.setIsVisible(1);
                mdProperty.setPropertyName(strName);
                mdProperty.setPropertyRole(this.m_strPropertyRole);
                PropertyType oPropType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, null, "String", "PropertyType", Workspace.getWorkspace().getDefaultRepositoryId(), null);
                oPropType.setSQLType(12);
                mdProperty.setOwningType(oPropType);
                this.m_mdPropertyGroup.getProperties().add((Object)mdProperty);
                this.setValueAt(mdProperty, iRow, 1);
            }
            alCurrentProperties.add(mdProperty);
        }
        for (int i = 0; i < this.m_lInitialProperties.size(); ++i) {
            mdProperty = (Property)this.m_lInitialProperties.get(i);
            if (alCurrentProperties.contains(mdProperty)) continue;
            AssociationList lAttachedProperties = mdProperty.getProperties();
            for (int j = 0; j < lAttachedProperties.size(); ++j) {
                this.m_oStore.removeObjectFromStore((CMetadata)((Property)lAttachedProperties.get(j)), "");
                --j;
            }
            this.m_oStore.removeObjectFromStore((CMetadata)mdProperty, "");
            --i;
        }
    }

    public boolean isCellEditable(int iRow, int iCol) {
        try {
            Property mdProperty = (Property)this.getValueAt(iRow, 1);
            return mdProperty == null || mdProperty.getIsUpdateable() == 1;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected String[] getNameValues() {
        String[] aNameValues = new String[this.getRowCount()];
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            aNameValues[iRow] = (String)this.getValueAt(iRow, 0);
        }
        return aNameValues;
    }

    protected Property getPropertyObject(String strPropertyName) {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            if (!this.getValueAt(iRow, 0).equals(strPropertyName)) continue;
            return (Property)this.getValueAt(iRow, 1);
        }
        return null;
    }
}

