/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.wadmin.visuals.ActionOptionsConfigPanel;
import com.sas.wadmin.visuals.CodeConditionConfigTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;

public class CodeConditionConfigPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(CodeConditionConfigPanel.class);
    protected cConditionTable m_tblCondition;
    protected cActionTable m_tblAction;
    protected WsTable m_tblCombo;
    protected JButton m_btnNewCondition;
    protected JButton m_btnNewAction;
    protected JButton m_btnNewCombo;
    protected JButton m_btnDeleteCondition;
    protected JButton m_btnDeleteAction;
    protected JButton m_btnDeleteCombo;
    protected JButton m_btnActionOptions;
    protected CodeConditionConfigTableModel m_mdlCondition;
    protected cActionTableModel m_mdlAction;
    protected cComboTableModel m_mdlCombo;
    protected cActNewCondition m_actNewCondition;
    protected cActDeleteCondition m_actDeleteCondition;
    protected cActNewAction m_actNewAction;
    protected cActDeleteAction m_actDeleteAction;
    protected cActActionOptions m_actActionOptions;
    protected cActNewCombo m_actNewCombo;
    protected cActDeleteCombo m_actDeleteCombo;
    protected MdObjectStore m_oObjectStore;
    protected static final String CONDITION_GROUP = "Code Conditions";
    protected static final String CONDITION_ROLE = "codecondition";
    protected static final String ACTION_GROUP = "Actions";
    protected static final String ACTION_ROLE = "action";
    protected static final String COMBO_GROUP = "CodeActionCombos";

    public CodeConditionConfigPanel(Group mdGroup) {
        try {
            this.m_oObjectStore = (MdObjectStore)mdGroup.getObjectStore();
            this.initialize();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static Group getMetadataObject() {
        Group mdGroup = null;
        try {
            MdObjectStore oStore = Workspace.getMdFactory().createObjectStore();
            String sOptions = "<XMLSELECT Search=\"Group[@Name='CodeActionCombos']\"/>";
            try {
                List lGroups = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)oStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "Group", 8588, sOptions);
                if (lGroups.size() > 0) {
                    mdGroup = (Group)lGroups.get(0);
                }
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return mdGroup;
    }

    protected void initialize() {
        this.m_actNewCondition = new cActNewCondition();
        this.m_actDeleteCondition = new cActDeleteCondition();
        this.m_actNewAction = new cActNewAction();
        this.m_actDeleteAction = new cActDeleteAction();
        this.m_actActionOptions = new cActActionOptions();
        this.m_actNewCombo = new cActNewCombo();
        this.m_actDeleteCombo = new cActDeleteCombo();
        this.m_actDeleteCondition.setEnabled(false);
        this.m_actDeleteAction.setEnabled(false);
        this.m_actActionOptions.setEnabled(false);
        this.m_actDeleteCombo.setEnabled(false);
        this.m_mdlCondition = new CodeConditionConfigTableModel(bundle.getString("CodeConditionConfigPanel.ConditionColumn.txt"), CONDITION_GROUP, CONDITION_ROLE);
        this.m_mdlCondition.setColumnFormatString(bundle.getString("CodeConditionConfigPanel.NewConditionName.fmt.txt"));
        this.m_mdlCondition.addTableModelListener(new cConditionTableModelListener());
        this.m_mdlAction = new cActionTableModel(bundle.getString("CodeConditionConfigPanel.ActionColumn.txt"), ACTION_GROUP, ACTION_ROLE);
        this.m_mdlAction.setColumnFormatString(bundle.getString("CodeConditionConfigPanel.NewActionName.fmt.txt"));
        this.m_mdlAction.addTableModelListener(new cActionTableModelListener());
        this.m_mdlCombo = new cComboTableModel(COMBO_GROUP);
        this.m_mdlCombo.addTableModelListener(new cComboTableModelListener());
        this.m_tblCondition = new cConditionTable(this.m_mdlCondition);
        this.m_tblCondition.setRowsReorderable(false);
        this.m_tblCondition.setColumnsReorderable(false);
        this.m_tblCondition.setRowHoldingEnabled(false);
        this.m_tblCondition.setColumnHoldingEnabled(false);
        this.m_tblCondition.setColumnHidingEnabled(false);
        this.m_tblCondition.setAutoResizeMode(4);
        this.m_tblCondition.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblCondition.setUndoManager((UndoManager)this.waum);
        this.m_tblCondition.getSelectionModel().setSelectionMode(0);
        this.m_tblCondition.getSelectionModel().addListSelectionListener(new cConditionTableSelectionListener());
        this.m_tblCondition.getActionMap().put((Object)this.m_actDeleteCondition, (Action)((Object)this.m_actDeleteCondition));
        this.m_tblCondition.getInputMap().put(KeyStroke.getKeyStroke(127, 0), (Object)this.m_actDeleteCondition);
        this.m_tblCondition.setTablePopupMenuRequestListener(new cConditionTablePopupMenuRequestListener());
        this.m_tblCondition.setViewportPopupMenuRequestListener(new cConditionTablePopupMenuRequestListener());
        this.m_tblCondition.setOriginPopupMenuRequestListener(new cConditionTablePopupMenuRequestListener());
        this.m_tblCondition.setRowHeaderPopupMenuRequestListener(new cConditionTablePopupMenuRequestListener());
        this.m_tblCondition.setColumnHeaderPopupMenuRequestListener(new cConditionTableColumnHeaderPopupMenuRequestListener());
        this.m_tblAction = new cActionTable(this.m_mdlAction);
        this.m_tblAction.setRowsReorderable(false);
        this.m_tblAction.setColumnsReorderable(false);
        this.m_tblAction.setRowHoldingEnabled(false);
        this.m_tblAction.setColumnHoldingEnabled(false);
        this.m_tblAction.setColumnHidingEnabled(false);
        this.m_tblAction.setAutoResizeMode(4);
        this.m_tblAction.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblAction.setUndoManager((UndoManager)this.waum);
        this.m_tblAction.getSelectionModel().setSelectionMode(0);
        this.m_tblAction.getSelectionModel().addListSelectionListener(new cActionTableSelectionListener());
        this.m_tblAction.getActionMap().put((Object)this.m_actDeleteAction, (Action)((Object)this.m_actDeleteAction));
        this.m_tblAction.getInputMap().put(KeyStroke.getKeyStroke(127, 0), (Object)this.m_actDeleteAction);
        this.m_tblAction.setTablePopupMenuRequestListener(new cActionTablePopupMenuRequestListener());
        this.m_tblAction.setViewportPopupMenuRequestListener(new cActionTablePopupMenuRequestListener());
        this.m_tblAction.setOriginPopupMenuRequestListener(new cActionTablePopupMenuRequestListener());
        this.m_tblAction.setRowHeaderPopupMenuRequestListener(new cActionTablePopupMenuRequestListener());
        this.m_tblAction.setColumnHeaderPopupMenuRequestListener(new cActionTableColumnHeaderPopupMenuRequestListener());
        this.m_tblCombo = new WsTable((WsAbstractTableModel)this.m_mdlCombo);
        this.m_tblCombo.setRowsReorderable(false);
        this.m_tblCombo.setColumnsReorderable(false);
        this.m_tblCombo.setRowHoldingEnabled(false);
        this.m_tblCombo.setColumnHoldingEnabled(false);
        this.m_tblCombo.setColumnHidingEnabled(false);
        this.m_tblCombo.setAutoResizeMode(4);
        this.m_tblCombo.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tblCombo.setUndoManager((UndoManager)this.waum);
        this.m_tblCombo.getSelectionModel().addListSelectionListener(new cComboTableSelectionListener());
        this.m_tblCombo.getActionMap().put((Object)this.m_actDeleteCombo, (Action)((Object)this.m_actDeleteCombo));
        this.m_tblCombo.getInputMap().put(KeyStroke.getKeyStroke(127, 0), (Object)this.m_actDeleteCombo);
        this.m_tblCombo.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cComboTablePopupMenuRequestListener());
        this.m_tblCombo.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new cComboTablePopupMenuRequestListener());
        this.m_tblCombo.setOriginPopupMenuRequestListener((WsPopupMenuRequestListener)new cComboTablePopupMenuRequestListener());
        this.m_tblCombo.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cComboTablePopupMenuRequestListener());
        this.m_tblCombo.setColumnHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cComboTableColumnHeaderPopupMenuRequestListener());
        this.m_btnNewCondition = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewCondition);
        this.m_btnDeleteCondition = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteCondition);
        this.m_btnNewAction = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewAction);
        this.m_btnDeleteAction = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteAction);
        this.m_btnActionOptions = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actActionOptions);
        this.m_btnNewCombo = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewCombo);
        this.m_btnDeleteCombo = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDeleteCombo);
        this.setHelpProduct("wdb");
        this.setHelpTopic("config_status_win");
        JScrollPane scrCondition = new JScrollPane((Component)((Object)this.m_tblCondition));
        scrCondition.setMinimumSize(new Dimension(200, 150));
        scrCondition.setPreferredSize(new Dimension(250, 150));
        JScrollPane scrAction = new JScrollPane((Component)((Object)this.m_tblAction));
        scrAction.setMinimumSize(new Dimension(200, 150));
        scrAction.setPreferredSize(new Dimension(250, 150));
        JScrollPane scrCombo = new JScrollPane((Component)this.m_tblCombo);
        scrCombo.setMinimumSize(new Dimension(400, 150));
        scrCombo.setPreferredSize(new Dimension(500, 150));
        JPanel pnlConditionBtns = new JPanel((LayoutManager)new WsButtonsLayout());
        JPanel pnlActionBtns = new JPanel((LayoutManager)new WsButtonsLayout());
        JPanel pnlComboBtns = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlConditionBtns.add(this.m_btnNewCondition);
        pnlConditionBtns.add(this.m_btnDeleteCondition);
        pnlActionBtns.add(this.m_btnNewAction);
        pnlActionBtns.add(this.m_btnDeleteAction);
        pnlActionBtns.add(this.m_btnActionOptions);
        pnlComboBtns.add(this.m_btnNewCombo);
        pnlComboBtns.add(this.m_btnDeleteCombo);
        JPanel pnlConditions = new JPanel(new BorderLayout(0, 5));
        JPanel pnlActions = new JPanel(new BorderLayout(0, 5));
        JPanel pnlCombos = new JPanel(new BorderLayout(0, 5));
        pnlConditions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CodeConditionConfigPanel.ConditionTable.Border.txt")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        pnlActions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CodeConditionConfigPanel.ActionTable.Border.txt")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        pnlCombos.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CodeConditionConfigPanel.ComboTable.Border.txt")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        pnlConditions.add((Component)scrCondition, "Center");
        pnlConditions.add((Component)pnlConditionBtns, "South");
        pnlActions.add((Component)scrAction, "Center");
        pnlActions.add((Component)pnlActionBtns, "South");
        pnlCombos.add((Component)scrCombo, "Center");
        pnlCombos.add((Component)pnlComboBtns, "South");
        this.setLayout(new BorderLayout(5, 10));
        this.add(pnlConditions, "West");
        this.add(pnlActions, "East");
        this.add(pnlCombos, "South");
    }

    public boolean validateData() {
        if (!this.m_tblCondition.stopCellEditing()) {
            return false;
        }
        if (!this.m_tblAction.stopCellEditing()) {
            return false;
        }
        return this.m_tblCombo.stopCellEditing();
    }

    public void populateStore() throws MdException, RemoteException {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_mdlCondition.setStore(this.m_oObjectStore);
            this.m_mdlAction.setStore(this.m_oObjectStore);
            this.m_mdlCondition.populateStore();
            this.m_mdlAction.populateStore();
            this.m_mdlCombo.populateStore();
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_mdlCondition.moveDataToModel();
            this.m_mdlAction.moveDataToModel();
            this.m_mdlCombo.moveDataToModel();
            this.m_mdlCombo.setConditions(this.getConditions());
            this.m_mdlCombo.setActions(this.getActions());
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() {
        try {
            this.m_mdlCondition.moveDataToStore();
            this.m_mdlAction.moveDataToStore();
            this.m_mdlCombo.moveDataToStore();
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Writing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblCondition.setEditable(bEditable);
        this.m_tblAction.setEditable(bEditable);
        this.m_tblCombo.setEditable(bEditable);
        this.m_actNewCondition.setEnabled(bEditable);
        this.m_actNewAction.setEnabled(bEditable);
        this.m_actNewCombo.setEnabled(bEditable);
    }

    protected String[] getConditions() {
        return this.m_mdlCondition.getNameValues();
    }

    protected String[] getActions() {
        return this.m_mdlAction.getNameValues();
    }

    protected Property getConditionObject(String strConditionName) {
        return this.m_mdlCondition.getPropertyObject(strConditionName);
    }

    protected Property getActionObject(String strActionName) {
        return this.m_mdlAction.getPropertyObject(strActionName);
    }

    protected void newCondition() {
        this.m_tblCondition.undoableInsertNewRow(this.m_tblCondition.getRowCount() - 1);
    }

    protected void deleteCondition() {
        int[] aSelectedRows = this.m_tblCondition.getSelectedRowsFromSelectedCells();
        int[] aFoundRows = this.m_mdlCombo.findRows(0, this.m_mdlCondition.getValueAt(aSelectedRows[0], 0));
        if (aFoundRows.length > 0) {
            int iRC = MessageUtil.displayMessage((String)bundle.getString("CodeConditionConfigPanel.ConditionTable.DeleteMsg.txt"), (int)2, (int)0);
            if (iRC == 1) {
                return;
            }
            for (int i = aFoundRows.length - 1; i >= 0; --i) {
                this.m_mdlCombo.deleteRow(aFoundRows[i]);
            }
        }
        this.m_tblCondition.undoableDeleteSelectedRows();
    }

    protected void newAction() {
        this.m_tblAction.undoableInsertNewRow(this.m_tblAction.getRowCount() - 1);
    }

    protected void deleteAction() {
        int[] aSelectedRows = this.m_tblAction.getSelectedRowsFromSelectedCells();
        int[] aFoundRows = this.m_mdlCombo.findRows(1, this.m_mdlAction.getValueAt(aSelectedRows[0], 0));
        if (aFoundRows.length > 0) {
            int iRC = MessageUtil.displayMessage((String)bundle.getString("CodeConditionConfigPanel.ActionTable.DeleteMsg.txt"), (int)2, (int)0);
            if (iRC == 1) {
                return;
            }
            for (int i = aFoundRows.length - 1; i >= 0; --i) {
                this.m_mdlCombo.deleteRow(aFoundRows[i]);
            }
        }
        this.m_tblAction.undoableDeleteSelectedRows();
    }

    protected void modifyActionOptions() {
        ActionOptionsConfigPanel pnlOptions = new ActionOptionsConfigPanel();
        int[] aSelectedRows = this.m_tblAction.getSelectedRowsFromSelectedCells();
        int iRow = aSelectedRows[0];
        pnlOptions.setOptionsValues(this.m_mdlAction.getOptionValues(iRow));
        pnlOptions.moveDataToModel();
        WAStandardDialog dlgOptions = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("CodeConditionConfigPanel.ActionOptionsDialogTitle.txt"), true, (WAPanel)pnlOptions);
        dlgOptions.show();
        if (dlgOptions.getReturnValue() == 1) {
            pnlOptions.moveDataToStore();
            this.m_mdlAction.setOptionValues(iRow, pnlOptions.getOptionsValues());
        }
    }

    protected void newCombo() {
        this.m_tblCombo.undoableInsertNewRow(this.m_tblCombo.getRowCount() - 1);
    }

    protected void deleteCombo() {
        this.m_tblCombo.undoableDeleteSelectedRows();
    }

    protected void updateConditionActions() {
        try {
            if (this.isEditable()) {
                boolean bUpdateable = false;
                int[] aSelectedRows = this.m_tblCondition.getSelectedRowsFromSelectedCells();
                if (aSelectedRows.length > 0) {
                    Property mdCondition = (Property)this.m_mdlCondition.getValueAt(aSelectedRows[0], 1);
                    if (mdCondition == null || mdCondition.getIsUpdateable() == 1) {
                        bUpdateable = true;
                    }
                }
                this.m_actDeleteCondition.setEnabled(bUpdateable);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void updateActionActions() {
        try {
            if (this.isEditable()) {
                boolean bUpdateable = false;
                int[] aSelectedRows = this.m_tblAction.getSelectedRowsFromSelectedCells();
                if (aSelectedRows.length > 0) {
                    Property mdAction = (Property)this.m_mdlAction.getValueAt(aSelectedRows[0], 1);
                    if (mdAction == null || mdAction.getIsUpdateable() == 1) {
                        bUpdateable = true;
                    }
                }
                this.m_actDeleteAction.setEnabled(bUpdateable);
                this.m_actActionOptions.setEnabled(bUpdateable);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void updateComboActions() {
        if (this.isEditable()) {
            int[] aSelectedRows = this.m_tblCombo.getSelectedRowsFromSelectedCells();
            this.m_actDeleteCombo.setEnabled(aSelectedRows.length > 0);
        }
    }

    protected class cComboTableSelectionListener
    implements ListSelectionListener {
        protected cComboTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CodeConditionConfigPanel.this.updateComboActions();
        }
    }

    protected class cActionTableSelectionListener
    implements ListSelectionListener {
        protected cActionTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CodeConditionConfigPanel.this.updateActionActions();
        }
    }

    protected class cConditionTableSelectionListener
    implements ListSelectionListener {
        protected cConditionTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CodeConditionConfigPanel.this.updateConditionActions();
        }
    }

    protected class cComboTableModelListener
    implements TableModelListener {
        protected cComboTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (CodeConditionConfigPanel.this.isListeningForChanges()) {
                CodeConditionConfigPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cActionTableModelListener
    implements TableModelListener {
        protected cActionTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (CodeConditionConfigPanel.this.isListeningForChanges()) {
                CodeConditionConfigPanel.this.m_tblCombo.stopCellEditing();
                CodeConditionConfigPanel.this.m_mdlCombo.setActions(CodeConditionConfigPanel.this.getActions());
                CodeConditionConfigPanel.this.setDataChanged(true);
            }
        }
    }

    protected class cConditionTableModelListener
    implements TableModelListener {
        protected cConditionTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (CodeConditionConfigPanel.this.isListeningForChanges()) {
                CodeConditionConfigPanel.this.m_tblCombo.stopCellEditing();
                CodeConditionConfigPanel.this.m_mdlCombo.setConditions(CodeConditionConfigPanel.this.getConditions());
                CodeConditionConfigPanel.this.setDataChanged(true);
            }
        }
    }

    class cComboTableModel
    extends WsAbstractTableModel {
        protected String m_strGroupName;
        protected Group m_mdMainComboGroup;
        protected HashMap m_hmComboGroups;
        protected static final int CONDITION_COLUMN = 0;
        protected static final int ACTION_COLUMN = 1;
        protected static final int COLUMN_COUNT = 2;
        protected static final String COMBO_GROUP_NAME = "CodeActionCombo";
        protected static final String COMBO_GROUP_DESC = "Code Condition Action Combination ";

        public cComboTableModel(String strGroupName) {
            this.m_strGroupName = strGroupName;
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount()];
            this.m_aColumns[0] = new WsEnumeratedTableColumn(0, bundle.getString("CodeConditionConfigPanel.ConditionColumn.txt"), 250);
            this.m_aColumns[1] = new WsEnumeratedTableColumn(1, bundle.getString("CodeConditionConfigPanel.ActionColumn.txt"), 250);
        }

        public int getColumnCount() {
            return 2;
        }

        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            String sOptions = "<XMLSELECT Search=\"Group[@Name='" + this.m_strGroupName + "']\"/><TEMPLATES><Group Id=\"\" Name=\"\" Desc=\"\"><Members/><Properties/></Group></TEMPLATES>";
            List lComboGroups = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)CodeConditionConfigPanel.this.m_oObjectStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "Group", 24972, sOptions);
            if (lComboGroups.size() > 0) {
                this.m_mdMainComboGroup = (Group)lComboGroups.get(0);
            }
            this.setStorePopulated(true);
        }

        public void moveDataToModel() throws MdException, RemoteException {
            this.clear();
            if (this.m_mdMainComboGroup == null) {
                return;
            }
            AssociationList lMemberGroups = this.m_mdMainComboGroup.getMembers();
            this.m_hmComboGroups = new HashMap();
            for (int i = 0; i < lMemberGroups.size(); ++i) {
                Group mdComboGroup = (Group)lMemberGroups.get(i);
                AssociationList alMembers = mdComboGroup.getMembers();
                Property mdCondition = (Property)alMembers.get(0);
                this.m_hmComboGroups.put(mdCondition.getName(), mdComboGroup);
                for (int j = 1; j < alMembers.size(); ++j) {
                    Property mdAction = (Property)alMembers.get(j);
                    ArrayList<String> alRow = new ArrayList<String>();
                    alRow.add(mdCondition.getName());
                    alRow.add(mdAction.getName());
                    this.m_lData.add(alRow);
                }
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() throws MdException, RemoteException {
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                String strConditionName = (String)this.getValueAt(iRow, 0);
                String strActionName = (String)this.getValueAt(iRow, 1);
                Group mdComboGroup = (Group)this.m_hmComboGroups.get(strConditionName);
                if (mdComboGroup != null) {
                    boolean bFound = false;
                    AssociationList lActions = mdComboGroup.getMembers();
                    for (int i = 1; i < lActions.size(); ++i) {
                        Property mdAction = (Property)lActions.get(i);
                        if (!mdAction.getName().equals(this.getValueAt(iRow, 1))) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    lActions.add(CodeConditionConfigPanel.this.getActionObject(strActionName));
                    continue;
                }
                int iNextGroupNumber = this.getNextNumber();
                String strComboName = COMBO_GROUP_NAME + iNextGroupNumber;
                mdComboGroup = (Group)Workspace.getMdFactory().createComplexMetadataObject(CodeConditionConfigPanel.this.m_oObjectStore, strComboName, "Group", Workspace.getWorkspace().getDefaultRepositoryId());
                mdComboGroup.setDesc(COMBO_GROUP_DESC + iNextGroupNumber);
                this.m_mdMainComboGroup.getMembers().add((Object)mdComboGroup);
                this.m_hmComboGroups.put(strConditionName, mdComboGroup);
                AssociationList lGroupMembers = mdComboGroup.getMembers();
                lGroupMembers.add(CodeConditionConfigPanel.this.getConditionObject(strConditionName));
                lGroupMembers.add(CodeConditionConfigPanel.this.getActionObject(strActionName));
            }
            AssociationList lComboGroups = this.m_mdMainComboGroup.getMembers();
            for (int i = 0; i < lComboGroups.size(); ++i) {
                Group mdComboGroup = (Group)lComboGroups.get(i);
                AssociationList lGroupMembers = mdComboGroup.getMembers();
                if (lGroupMembers.size() > 0 && ((Property)lGroupMembers.get(0)).getPropertyRole().equals(CodeConditionConfigPanel.CONDITION_ROLE)) {
                    String strConditionName = ((Property)lGroupMembers.get(0)).getName();
                    for (int j = 1; j < lGroupMembers.size(); ++j) {
                        Property mdAction = (Property)lGroupMembers.get(j);
                        if (this.rowExists(strConditionName, mdAction.getName())) continue;
                        lGroupMembers.remove(mdAction);
                        --j;
                    }
                    continue;
                }
                CodeConditionConfigPanel.this.m_oObjectStore.removeObjectFromStore((CMetadata)mdComboGroup, "");
                --i;
            }
        }

        protected boolean rowExists(String strConditionName, String strActionName) {
            ArrayList<String> lRowValues = new ArrayList<String>();
            lRowValues.add(strConditionName);
            lRowValues.add(strActionName);
            int[] aRows = this.findRows(lRowValues);
            return aRows.length > 0;
        }

        protected int getNextNumber() throws MdException, RemoteException {
            AssociationList lComboGroups = this.m_mdMainComboGroup.getMembers();
            if (lComboGroups.isEmpty()) {
                return 1;
            }
            Group mdComboGroup = (Group)lComboGroups.get(lComboGroups.size() - 1);
            String strName = mdComboGroup.getName();
            String strNumber = strName.substring(COMBO_GROUP_NAME.length());
            return Integer.parseInt(strNumber) + 1;
        }

        public void setConditions(String[] aConditions) {
            WsEnumeratedTableColumn oColumn = (WsEnumeratedTableColumn)this.m_aColumns[0];
            oColumn.setPossibleValues(aConditions);
            oColumn.setDefaultValue(aConditions[0]);
        }

        public void setActions(String[] aActions) {
            WsEnumeratedTableColumn oColumn = (WsEnumeratedTableColumn)this.m_aColumns[1];
            oColumn.setPossibleValues(aActions);
            oColumn.setDefaultValue(aActions[0]);
        }

        public void updateConditionName(String strOldName, String strNewName) {
            int[] aRows = this.findRows(0, strOldName);
            for (int i = 0; i < aRows.length; ++i) {
                this.setValueAt(strNewName, aRows[i], 0);
                this.fireTableCellUpdated(aRows[i], 0);
            }
        }

        public void updateActionName(String strOldName, String strNewName) {
            int[] aRows = this.findRows(1, strOldName);
            for (int i = 0; i < aRows.length; ++i) {
                this.setValueAt(strNewName, aRows[i], 1);
                this.fireTableCellUpdated(aRows[i], 1);
            }
        }
    }

    class cActionTableModel
    extends CodeConditionConfigTableModel {
        HashMap m_hmActionOptions;
        protected static final String OPTION_PROPERTY_ROLE = "parameter";

        public cActionTableModel(String strColumnName, String strGroupName, String strPropertyRole) {
            super(strColumnName, strGroupName, strPropertyRole);
        }

        @Override
        public void moveDataToModel() throws MdException, RemoteException {
            super.moveDataToModel();
            if (this.m_mdPropertyGroup == null) {
                return;
            }
            this.m_hmActionOptions = new HashMap();
            AssociationList alProperties = this.m_mdPropertyGroup.getProperties();
            for (int i = 0; i < alProperties.size(); ++i) {
                Property mdProperty = (Property)alProperties.get(i);
                if (mdProperty.getIsUpdateable() != 1) continue;
                AssociationList lActionOptions = mdProperty.getProperties();
                ArrayList<String> lOptionStrings = new ArrayList<String>();
                for (int j = 0; j < lActionOptions.size(); ++j) {
                    lOptionStrings.add(((Property)lActionOptions.get(j)).getName());
                }
                this.m_hmActionOptions.put(mdProperty.getName(), lOptionStrings);
            }
        }

        @Override
        public void moveDataToStore() throws MdException, RemoteException {
            super.moveDataToStore();
            if (this.m_mdPropertyGroup == null) {
                return;
            }
            AssociationList lActions = this.m_mdPropertyGroup.getProperties();
            for (int i = 0; i < lActions.size(); ++i) {
                int j;
                ArrayList lOptionStrings;
                Property mdAction = (Property)lActions.get(i);
                if (mdAction.getIsUpdateable() != 1 || (lOptionStrings = (ArrayList)this.m_hmActionOptions.get(mdAction.getName())) == null) continue;
                AssociationList lActionOptions = mdAction.getProperties();
                int iActionOptionsCount = lActionOptions.size();
                for (j = 0; j < lOptionStrings.size(); ++j) {
                    String strOption = (String)lOptionStrings.get(j);
                    boolean bFound = false;
                    for (int k = 0; k < iActionOptionsCount; ++k) {
                        Property mdOption = (Property)lActionOptions.get(k);
                        if (!mdOption.getName().equals(strOption)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    Property mdOption = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, strOption, "Property", Workspace.getWorkspace().getDefaultRepositoryId());
                    mdOption.setDesc(strOption);
                    mdOption.setIsExpert(1);
                    mdOption.setIsUpdateable(1);
                    mdOption.setIsVisible(1);
                    mdOption.setPropertyName(strOption);
                    mdOption.setPropertyRole(OPTION_PROPERTY_ROLE);
                    PropertyType oPropType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_oStore, null, "String", "PropertyType", Workspace.getWorkspace().getDefaultRepositoryId(), null);
                    oPropType.setSQLType(12);
                    mdOption.setOwningType(oPropType);
                    lActionOptions.add(mdOption);
                }
                for (j = 0; j < lActionOptions.size(); ++j) {
                    Property mdOption = (Property)lActionOptions.get(j);
                    if (lOptionStrings.contains(mdOption.getName())) continue;
                    this.m_oStore.removeObjectFromStore((CMetadata)mdOption, "");
                    --j;
                }
            }
        }

        public void updateKeyInMap(Object oOldKey, Object oNewKey) {
            Object oObject = this.m_hmActionOptions.get(oOldKey);
            this.m_hmActionOptions.remove(oOldKey);
            this.m_hmActionOptions.put(oNewKey, oObject);
        }

        public List getOptionValues(int iRow) {
            String strName = (String)this.getValueAt(iRow, 0);
            return (List)this.m_hmActionOptions.get(strName);
        }

        public void setOptionValues(int iRow, List lOptionValues) {
            String strName = (String)this.getValueAt(iRow, 0);
            this.m_hmActionOptions.put(strName, lOptionValues);
        }
    }

    protected class cActionTable
    extends WsTable {
        public cActionTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                Object oOldValue = this.getValueAt(this.editingRow, this.editingColumn);
                int iOldRow = this.editingRow;
                int iOldColumn = this.editingColumn;
                super.editingStopped(e);
                Object oNewValue = this.getValueAt(iOldRow, iOldColumn);
                if (!oOldValue.equals(oNewValue)) {
                    CodeConditionConfigPanel.this.m_mdlAction.updateKeyInMap(oOldValue, oNewValue);
                    CodeConditionConfigPanel.this.m_mdlCombo.updateActionName((String)oOldValue, (String)oNewValue);
                }
            }
        }
    }

    protected class cConditionTable
    extends WsTable {
        public cConditionTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                Object oOldValue = this.getValueAt(this.editingRow, this.editingColumn);
                int iOldRow = this.editingRow;
                int iOldColumn = this.editingColumn;
                super.editingStopped(e);
                Object oNewValue = this.getValueAt(iOldRow, iOldColumn);
                if (!oOldValue.equals(oNewValue)) {
                    CodeConditionConfigPanel.this.m_mdlCombo.updateConditionName((String)oOldValue, (String)oNewValue);
                }
            }
        }
    }

    protected class cComboTableColumnHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cComboTableColumnHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = CodeConditionConfigPanel.this.m_tblCombo.createColumnHeaderPopupMenu();
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewCombo)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteCombo)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cActionTableColumnHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cActionTableColumnHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = CodeConditionConfigPanel.this.m_tblAction.createColumnHeaderPopupMenu();
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewAction)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteAction)));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actActionOptions)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cConditionTableColumnHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cConditionTableColumnHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = CodeConditionConfigPanel.this.m_tblCondition.createColumnHeaderPopupMenu();
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewCondition)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteCondition)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cComboTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cComboTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewCombo)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteCombo)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cActionTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cActionTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewAction)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteAction)));
            mnuPopup.addSeparator();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actActionOptions)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cConditionTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cConditionTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actNewCondition)));
            mnuPopup.add(new JMenuItem((Action)((Object)CodeConditionConfigPanel.this.m_actDeleteCondition)));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cActDeleteCombo
    extends WsAbstractAction {
        public cActDeleteCombo() {
            super(bundle, "CodeConditionConfigPanel.DeleteCombo");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.deleteCombo();
        }
    }

    protected class cActNewCombo
    extends WsAbstractAction {
        public cActNewCombo() {
            super(bundle, "CodeConditionConfigPanel.NewCombo");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.newCombo();
        }
    }

    protected class cActActionOptions
    extends WsAbstractAction {
        public cActActionOptions() {
            super(bundle, "CodeConditionConfigPanel.ModifyActionOptions");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.modifyActionOptions();
        }
    }

    protected class cActDeleteAction
    extends WsAbstractAction {
        public cActDeleteAction() {
            super(bundle, "CodeConditionConfigPanel.DeleteAction");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.deleteAction();
        }
    }

    protected class cActNewAction
    extends WsAbstractAction {
        public cActNewAction() {
            super(bundle, "CodeConditionConfigPanel.NewAction");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.newAction();
        }
    }

    protected class cActDeleteCondition
    extends WsAbstractAction {
        public cActDeleteCondition() {
            super(bundle, "CodeConditionConfigPanel.DeleteCondition");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.deleteCondition();
        }
    }

    protected class cActNewCondition
    extends WsAbstractAction {
        public cActNewCondition() {
            super(bundle, "CodeConditionConfigPanel.NewCondition");
        }

        public void actionPerformed(ActionEvent e) {
            CodeConditionConfigPanel.this.newCondition();
        }
    }
}

