/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ClearProjectDialog
extends WAStandardDialog {
    private static WAdminResource m_bundle = WAdminResource.getBundle(ClearProjectDialog.class);
    private String m_sProjectRepos = null;
    private String m_sProjectName = null;
    private boolean m_bIsDeletedRepos = false;
    private int m_numberOfDeletedReposRows = 0;
    private ArrayList m_alSelectedRows = new ArrayList();

    public ClearProjectDialog() {
        super((Frame)Workspace.getWorkspace(), m_bundle.getString("ClearProjectDialog.Title.txt"), true);
        cClearProjectPanel pnlClearProject = new cClearProjectPanel();
        pnlClearProject.setPreferredSize(new Dimension(500, 200));
        this.setMainPanel(pnlClearProject);
        this.setResizable(true);
        this.setHelpProduct("wdb");
        this.setHelpTopic("clear_project_repos");
    }

    public String getSelectedProjectRepos() {
        return this.m_sProjectRepos;
    }

    public String getSelectedProjectName() {
        return this.m_sProjectName;
    }

    public boolean isDeletedRepos() {
        return this.m_bIsDeletedRepos;
    }

    public List getSelectedProjects() {
        return this.m_alSelectedRows;
    }

    public class cClearProjectPanel
    extends WAPanel {
        private static final int SCROLL_PANE_WIDTH = 700;
        private static final int SCROLL_PANE_HEIGHT = 315;
        private cClearProjectModel m_mdlClearProject;
        private WsTable m_tblClearProject;
        private JScrollPane m_scrClearProject;
        private JCheckBox m_ckbDeletedProject;
        private JLabel m_lblDescription;

        public cClearProjectPanel() {
            this.initialize();
            this.setEditable(false);
        }

        protected void initialize() {
            this.m_mdlClearProject = new cClearProjectModel();
            this.m_tblClearProject = new WsTable((WsAbstractTableModel)this.m_mdlClearProject);
            this.m_tblClearProject.setEditable(false);
            this.m_tblClearProject.setAutoResizeMode(4);
            this.m_tblClearProject.setRowHeaderVisible(false);
            this.m_tblClearProject.setColumnHeaderPopupMenuEnabled(false);
            this.m_tblClearProject.setRowHeaderPopupMenuEnabled(false);
            this.m_tblClearProject.setSelectionMode(2);
            this.m_tblClearProject.setSortingEnabled(false);
            this.m_tblClearProject.setRowSelectionAllowed(true);
            this.m_tblClearProject.setCellSelectionEnabled(false);
            this.m_scrClearProject = new JScrollPane((Component)this.m_tblClearProject);
            this.m_scrClearProject.setPreferredSize(new Dimension(700, 315));
            this.m_lblDescription = new JLabel(m_bundle.getString("ClearProjectDialog.Desc.txt"));
            this.m_lblDescription.setLabelFor((Component)this.m_tblClearProject);
            this.m_ckbDeletedProject = WsUIUtilities.createCheckBox((WAdminResource)m_bundle, (String)"ClearProjectDialog.ShowDeletedRepositories");
            this.m_ckbDeletedProject.addActionListener(new cCheckBoxListener());
            JSeparator sep = new JSeparator(0);
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(sep, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 1));
            this.add(this.m_scrClearProject, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_ckbDeletedProject, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        }

        public void populateStore() {
            this.m_mdlClearProject.populateStore();
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.m_mdlClearProject.moveDataToModel();
        }

        public boolean validateData() {
            int[] aSelectedRows = this.m_tblClearProject.getSelectedRowsFromSelectedCells();
            if (aSelectedRows.length == 0) {
                MessageUtil.displayMessage((String)m_bundle.getString("ClearProjectDialog.NoProjectSelected.txt"), (int)1, (int)-1);
                return false;
            }
            this.m_tblClearProject.convertRowIndexesToModel(aSelectedRows);
            ClearProjectDialog.this.m_sProjectRepos = (String)this.m_mdlClearProject.getValueAt(aSelectedRows[0], 1);
            ClearProjectDialog.this.m_bIsDeletedRepos = (Boolean)this.m_mdlClearProject.getValueAt(aSelectedRows[0], 3);
            ClearProjectDialog.this.m_sProjectName = (String)this.m_mdlClearProject.getValueAt(aSelectedRows[0], 0);
            ClearProjectDialog.this.m_alSelectedRows.clear();
            for (int i = 0; i < aSelectedRows.length; ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>();
                String sProjectName = (String)this.m_mdlClearProject.getValueAt(aSelectedRows[i], 0);
                String sProjectID = (String)this.m_mdlClearProject.getValueAt(aSelectedRows[i], 1);
                Boolean bDeletedRepos = (Boolean)this.m_mdlClearProject.getValueAt(aSelectedRows[i], 3);
                alRow.add(sProjectName);
                alRow.add(sProjectID);
                alRow.add(bDeletedRepos);
                ClearProjectDialog.this.m_alSelectedRows.add(alRow);
            }
            return true;
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
        }

        public class cClearProjectModel
        extends WsAbstractTableModel {
            public static final int NAME_COLUMN = 0;
            public static final int ID_COLUMN = 1;
            public static final int USER_COLUMN = 2;
            public static final int DELETED_REPOS = 3;
            protected static final int TOTAL_COLUMNS = 4;
            protected static final int TOTAL_COLS = 3;
            protected static final int TOTAL_HIDDEN_COLS = 1;

            public cClearProjectModel() {
                this.m_aColumns = new WsAbstractTableColumn[4];
                this.m_aColumns[0] = new WsStringTableColumn(0, m_bundle.getString("ClearProjectDialog.NameColum.txt"), 150);
                this.m_aColumns[1] = new WsStringTableColumn(1, m_bundle.getString("ClearProjectDialog.IDColumn.txt"), 150);
                this.m_aColumns[2] = new WsStringTableColumn(2, m_bundle.getString("ClearProjectDialog.UserColumn.txt"), 150);
                this.m_aColumns[3] = new WsBooleanTableColumn();
            }

            public void populateStore() {
            }

            public void moveDataToModel() throws MdException, RemoteException {
                try {
                    Repository[] reposArray = null;
                    IOMI omiConnection = Workspace.getWorkspace().getCMRHandle();
                    reposArray = Repository.getRepositories((IOMI)omiConnection);
                    for (int iRepository = 0; iRepository < reposArray.length; ++iRepository) {
                        String sReposName;
                        Repository oRepository = reposArray[iRepository];
                        if (!oRepository.getType().equalsIgnoreCase("PROJECT")) continue;
                        String sId = oRepository.getFQID();
                        Identity thisReposOwner = WsRepositoryUtil.getRepositoryOwner((MdFactory)Workspace.getMdFactory(), (String)sId);
                        if (thisReposOwner != null) {
                            sReposName = oRepository.getName();
                            String sReposOwner = thisReposOwner.getName();
                            String sReposOwnerID = thisReposOwner.getFQID();
                            if (IdentityUtil.checkSpecialAuthorization((int)1, (boolean)true)) {
                                this.insertRow(sReposName, sId, sReposOwner, Boolean.FALSE);
                                continue;
                            }
                            if (!sReposOwnerID.equals(Workspace.getWorkspace().getMyIdentityID())) continue;
                            this.insertRow(sReposName, sId, sReposOwner, Boolean.FALSE);
                            continue;
                        }
                        if (!IdentityUtil.checkSpecialAuthorization((int)1, (boolean)true)) continue;
                        sReposName = oRepository.getName();
                        this.insertRow(sReposName, sId, "UnknownUserName", Boolean.FALSE);
                    }
                }
                catch (Exception e) {
                    MessageUtil.displayMessage((String)e.getMessage(), (int)0);
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addDeletedRepositories() {
                try {
                    ClearProjectDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ClearProjectDialog.this.m_numberOfDeletedReposRows = 0;
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ChangeManagementUtil: setChangeStateForNewObjects");
                    try {
                        String sOptions = "<XMLSELECT Search=\"*[@ChangeState ? 'Checked-out to']\"/>";
                        List lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "Root", 408, sOptions);
                        if (!lObjects.isEmpty()) {
                            HashSet<String> hsAllRepos = new HashSet<String>();
                            List lRepositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
                            for (int r = 0; r < lRepositories.size(); ++r) {
                                CMetadata oRepos = (CMetadata)lRepositories.get(r);
                                hsAllRepos.add(oRepos.getFQID());
                            }
                            HashSet<String> hsDeletedRepos = new HashSet<String>();
                            for (int z = 0; z < lObjects.size(); ++z) {
                                String sUserID;
                                String sLockUserName;
                                String sIDOfProjectRepos;
                                block23: {
                                    Root thisObject = (Root)lObjects.get(z);
                                    String sChangeState = thisObject.getChangeState();
                                    int index = sChangeState.indexOf(58);
                                    int stopIndex = sChangeState.indexOf(".");
                                    String sIDOfProjectObject = sChangeState.substring(index += 2, stopIndex);
                                    sIDOfProjectRepos = "A0000001." + sIDOfProjectObject;
                                    if (hsAllRepos.contains(sIDOfProjectRepos) || hsDeletedRepos.contains(sIDOfProjectRepos)) continue;
                                    hsDeletedRepos.add(sIDOfProjectRepos);
                                    String sLockedBy = thisObject.getLockedBy();
                                    CMetadata person = Workspace.getMdFactory().createComplexMetadataObject(store, "none", "Person", sLockedBy);
                                    CMetadata identity = Workspace.getMdFactory().createComplexMetadataObject(store, "none", "Identity", sLockedBy);
                                    StringBuffer sbXML = new StringBuffer();
                                    sbXML.append("<");
                                    sbXML.append(person.getCMetadataType());
                                    sbXML.append(" Id=\"");
                                    sbXML.append(person.getFQID());
                                    sbXML.append("\" Name=\"\" />");
                                    try {
                                        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), "", 256);
                                        sLockUserName = person.getName();
                                        sUserID = person.getFQID();
                                    }
                                    catch (Exception eMeta) {
                                        Workspace.getDefaultLogger().error((Object)"", (Throwable)eMeta);
                                        sbXML = new StringBuffer();
                                        sbXML.append("<");
                                        sbXML.append(identity.getCMetadataType());
                                        sbXML.append(" Id=\"");
                                        sbXML.append(identity.getFQID());
                                        sbXML.append("\" Name=\"\" />");
                                        try {
                                            Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), "", 256);
                                            sLockUserName = identity.getName();
                                            sUserID = identity.getFQID();
                                        }
                                        catch (MdException eMeta2) {
                                            sLockUserName = m_bundle.getString("ClearProjectDialog.UnknownUserName.txt");
                                            sUserID = null;
                                            ClearProjectDialog.this.setCursor(Cursor.getDefaultCursor());
                                            break block23;
                                        }
                                        ClearProjectDialog.this.setCursor(Cursor.getDefaultCursor());
                                    }
                                    finally {
                                        ClearProjectDialog.this.setCursor(Cursor.getDefaultCursor());
                                    }
                                }
                                if (IdentityUtil.checkSpecialAuthorization((int)1, (boolean)true)) {
                                    this.insertRow(m_bundle.getString("ClearProjectDialog.UnknownRepositoryName.txt"), sIDOfProjectRepos, sLockUserName, Boolean.TRUE);
                                    ClearProjectDialog.this.m_numberOfDeletedReposRows++;
                                    continue;
                                }
                                if (sUserID == null || !sUserID.equals(Workspace.getWorkspace().getMyIdentityID())) continue;
                                this.insertRow(m_bundle.getString("ClearProjectDialog.UnknownRepositoryName.txt"), sIDOfProjectRepos, sLockUserName, Boolean.TRUE);
                                ClearProjectDialog.this.m_numberOfDeletedReposRows++;
                            }
                        }
                        if (lObjects.isEmpty() || ClearProjectDialog.this.m_numberOfDeletedReposRows == 0) {
                            MessageUtil.displayMessage((String)m_bundle.getString("ClearProjectDialog.NoDeletedReposFound.txt"), (int)1, (int)-1);
                        }
                    }
                    catch (MdException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    finally {
                        store.dispose();
                        ClearProjectDialog.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }

            public void moveDataToStore() {
            }

            public int getColumnCount() {
                return 3;
            }

            public int getHiddenColumnCount() {
                return 1;
            }

            public void insertRow(String projectName, String projectID, String projectUser, Boolean bDeletedRepos) {
                ArrayList<Object> m = new ArrayList<Object>();
                m.add(projectName);
                m.add(projectID);
                m.add(projectUser);
                m.add(bDeletedRepos);
                this.m_lData.add(m);
                this.fireTableRowsInserted(this.m_lData.size() - 1, this.m_lData.size() - 1);
            }
        }

        class cCheckBoxListener
        implements ActionListener {
            cCheckBoxListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cClearProjectPanel.this.m_ckbDeletedProject.isSelected()) {
                    cClearProjectPanel.this.m_mdlClearProject.addDeletedRepositories();
                } else {
                    int totalRows = cClearProjectPanel.this.m_mdlClearProject.getRowCount();
                    for (int i = 1; i <= ClearProjectDialog.this.m_numberOfDeletedReposRows; ++i) {
                        cClearProjectPanel.this.m_mdlClearProject.deleteRow(totalRows - i);
                    }
                }
            }
        }
    }
}

