/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Change;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.visuals.ChangeTextDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTitledPageFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChangeHistoryPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ChangeHistoryPanel.class);
    private static final int SCROLL_PANE_WIDTH = 700;
    private static final int SCROLL_PANE_HEIGHT = 315;
    private cChangeHistoryModel m_mdlHistory;
    private WsTable m_tblHistory;
    private Root m_oObject;
    private JScrollPane m_scrHistory;
    private JLabel m_lblDescription;
    private WsAbstractAction m_actPrint;
    private WsAbstractAction m_actViewFullText;
    private boolean m_bisProjectObject = false;
    protected JPanel m_pnlButtons;

    public ChangeHistoryPanel(CMetadata oObject) {
        this.m_oObject = (Root)oObject;
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("cm_history_win");
        this.setEditable(false);
    }

    protected void initialize() {
        this.createActions();
        this.m_mdlHistory = new cChangeHistoryModel(this.m_oObject);
        this.m_tblHistory = new WsTable((WsAbstractTableModel)this.m_mdlHistory);
        this.m_tblHistory.setEditable(false);
        this.m_tblHistory.setAutoResizeMode(0);
        this.m_tblHistory.setRowHeaderVisible(false);
        this.m_tblHistory.setColumnHeaderPopupMenuEnabled(false);
        this.m_tblHistory.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cPopupMenuRequestListener());
        this.m_tblHistory.getSelectionModel().addListSelectionListener(new cTableSelectionListener());
        this.m_scrHistory = new JScrollPane((Component)this.m_tblHistory);
        this.m_scrHistory.setPreferredSize(new Dimension(700, 315));
        this.m_lblDescription = new JLabel();
        this.m_lblDescription.setLabelFor((Component)this.m_tblHistory);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrHistory, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        try {
            this.m_bisProjectObject = Workspace.getWorkspace().getProjectRepositoryId() == null ? false : Workspace.getWorkspace().getProjectRepositoryId().equals(this.m_oObject.getRepositoryID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void populateStore() {
        this.m_mdlHistory.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_mdlHistory.moveDataToModel();
        this.m_tblHistory.sort(0, -1);
        this.m_tblHistory.setSortingEnabled(false);
        this.m_tblHistory.setSelectionMode(0);
        for (int i = 1; i <= this.m_tblHistory.getRowCount(); ++i) {
            Integer ii = new Integer(i);
            this.m_tblHistory.setValueAt((Object)ii, this.m_tblHistory.getRowCount() - i, 0);
        }
        this.m_lblDescription.setText(bundle.formatString("ChangeHistoryPanel.Label.Table.fmt.txt", (Object)String.valueOf(this.m_tblHistory.getRowCount())));
    }

    public boolean validateData() {
        return true;
    }

    protected void createActions() {
        this.m_actPrint = new cPrintAction();
        this.m_actViewFullText = new cViewFullTextAction();
    }

    public void updateActions() {
        int[] aSelectedRows = this.m_tblHistory.getSelectedRowsFromSelectedCells();
        if (aSelectedRows.length == 0) {
            this.m_actViewFullText.setEnabled(false);
            return;
        }
        this.m_tblHistory.convertRowIndexesToModel(aSelectedRows);
        Object selectedObject = this.m_mdlHistory.getValueAt(aSelectedRows[0], 6);
        if (selectedObject != null) {
            this.m_actViewFullText.setEnabled(true);
        } else {
            this.m_actViewFullText.setEnabled(false);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actViewFullText.setActive(bActive);
        this.updateActions();
    }

    protected class cTableSelectionListener
    implements ListSelectionListener {
        protected cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ChangeHistoryPanel.this.updateActions();
        }
    }

    public class cChangeHistoryModel
    extends WsAbstractTableModel {
        public static final int VERSION_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        public static final int DESCR_COLUMN = 2;
        public static final int USER_COLUMN = 3;
        public static final int DATE_COLUMN = 4;
        public static final int ACTION_COLUMN = 5;
        public static final int OBJECT_COLUMN = 6;
        protected static final int TOTAL_COLUMNS = 7;
        protected static final int TOTAL_COLS = 6;
        protected static final int TOTAL_HIDDEN_COLS = 1;
        protected Root m_metadata;

        public cChangeHistoryModel(Root oObject) {
            this.m_metadata = oObject;
            this.m_aColumns = new WsAbstractTableColumn[7];
            this.m_aColumns[0] = new WsIntegerTableColumn(0, bundle.getString("ChangeHistoryModel.Version.txt"), 50);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ChangeHistoryModel.Name.txt"), 100);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ChangeHistoryModel.Description.txt"), 200);
            this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("ChangeHistoryModel.User.txt"), 100);
            this.m_aColumns[4] = new WsDateTableColumn(4, bundle.getString("ChangeHistoryModel.DateTime.txt"), 170);
            this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("ChangeHistoryModel.Action.txt"), 76);
            this.m_aColumns[6] = new WsMetadataTableColumn();
        }

        public void populateStore() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void moveDataToModel() throws MdException, RemoteException {
            Date realDateCreated;
            Root oPrimaryObject = null;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, null, null, 0x4000008);
            String template = "<Templates><Change><ChangeIdentity/></Change></Templates>";
            ArrayList<String> lAssocs = new ArrayList<String>();
            lAssocs.add("Changes");
            String sObjectChangeState = this.m_metadata.getChangeState();
            if (sObjectChangeState.startsWith("Checkout") || sObjectChangeState.startsWith("Fetch")) {
                String sPrimaryFQID = sObjectChangeState.substring(17);
                String sPrimaryXML = "<" + this.m_metadata.getCMetadataType() + " Id=\"" + sPrimaryFQID + "\" Name=\"\" ></" + this.m_metadata.getCMetadataType() + ">";
                List lPrimaryObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sPrimaryXML, "", 67109128);
                if (lPrimaryObjects.isEmpty()) throw new MdException("Primary object missing");
                oPrimaryObject = (Root)lPrimaryObjects.get(0);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oPrimaryObject, null, lAssocs, template, 0x400000C);
            } else {
                oPrimaryObject = this.m_metadata;
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, lAssocs, template, 0x400000C);
            }
            String sName = this.m_metadata.getName();
            String sDesc = this.m_metadata.getDesc();
            if (this.m_metadata.getChangeState().equals("") || this.m_metadata.getChangeState().startsWith("Checked")) {
                realDateCreated = this.parseDate(oPrimaryObject.getMetadataCreated());
            } else {
                String sPrimaryFQID = sObjectChangeState.substring(17);
                String sPrimaryXML = "<" + this.m_metadata.getCMetadataType() + " Id=\"" + sPrimaryFQID + "\" Name=\"\" ></" + this.m_metadata.getCMetadataType() + ">";
                List lPrimaryObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sPrimaryXML, "", 67109128);
                if (lPrimaryObjects.isEmpty()) throw new MdException("Primary object missing");
                oPrimaryObject = (Root)lPrimaryObjects.get(0);
                realDateCreated = this.parseDate(oPrimaryObject.getMetadataCreated());
            }
            this.insertRow(new Integer(1), sName, sDesc, "", realDateCreated, bundle.getString("ChangeHistoryPanel.TableFirstRow.txt"), null);
            AssociationList lChanges = oPrimaryObject.getChanges(false);
            for (int i = 0; i < lChanges.size(); ++i) {
                Change mdoChange = (Change)lChanges.elementAt(i);
                String sChangeName = mdoChange.getName();
                String sChangeDesc = mdoChange.getDesc();
                int endOfFirstLine = sChangeDesc.indexOf("\n");
                String sChangeDescFirstLine = endOfFirstLine > 0 ? sChangeDesc.substring(0, endOfFirstLine) : sChangeDesc;
                String sChangeUser = "Unknown User";
                Identity oChangeUserIdentity = mdoChange.getChangeIdentity();
                if (oChangeUserIdentity != null) {
                    sChangeUser = oChangeUserIdentity.getName();
                } else if (mdoChange.getChangeState().length() > 0) {
                    sChangeUser = mdoChange.getChangeState();
                }
                Date dateCreated = this.parseDate(mdoChange.getMetadataCreated());
                this.insertRow(new Integer(i + 2), sChangeName, sChangeDescFirstLine, sChangeUser, dateCreated, bundle.getString("ChangeHistoryPanel.TableOtherRows.txt"), mdoChange);
            }
            if (this.m_metadata.isLocked()) {
                String options = "<XMLSELECT search=\"@Id='" + this.m_metadata.getLockedBy() + "'\"/>";
                int objCount = Workspace.getMdFactory().getOMIUtil().doesObjectExist("A0000001." + this.m_metadata.getLockedBy().substring(0, 8), "Person", options);
                String slockUser = "Unknown User";
                if (objCount > 0) {
                    String sXML = "<Person Id=\"" + this.m_metadata.getLockedBy() + "\" Name=\"\" ></" + "Person" + ">";
                    List newObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sXML, "", 256);
                    if (newObjects.size() > 0) {
                        Person olockUser = (Person)newObjects.get(0);
                        slockUser = olockUser.getName();
                    }
                }
                Date lockedDate = null;
                lockedDate = ChangeHistoryPanel.this.m_bisProjectObject ? this.parseDate(this.m_metadata.getMetadataCreated()) : this.parseDate(this.m_metadata.getMetadataUpdated());
                this.insertRow(new Integer(lChanges.size() + 2), "", "", slockUser, lockedDate, bundle.getString("ChangeHistoryPanel.LockedRow.txt"), null);
            }
            if (!ChangeHistoryPanel.this.m_bisProjectObject || !this.m_metadata.getChangeState().startsWith("Fetch")) return;
            this.insertRow(new Integer(lChanges.size() + 2), "", "", "", this.parseDate(this.m_metadata.getMetadataCreated()), bundle.getString("ChangeHistoryPanel.FetchedRow.txt"), null);
        }

        public void moveDataToStore() {
        }

        public int getColumnCount() {
            return 6;
        }

        public int getHiddenColumnCount() {
            return 1;
        }

        public void insertRow(Integer verInteger, String changeName, String changeDesc, String changeUser, Date changeCreated, String action, Object oChangeObject) {
            ArrayList<Object> m = new ArrayList<Object>();
            m.add(verInteger);
            m.add(changeName);
            m.add(changeDesc);
            m.add(changeUser);
            m.add(changeCreated);
            m.add(action);
            m.add(oChangeObject);
            this.m_lData.add(m);
            this.fireTableRowsInserted(this.m_lData.size() - 1, this.m_lData.size() - 1);
        }

        private Date parseDate(String sDate) {
            double secondsSince1Jan1960 = Double.parseDouble(sDate);
            double secondsSince1Jan1970 = secondsSince1Jan1960 - 3.156192E8;
            long millisecondsSince1Jan1970 = (long)(secondsSince1Jan1970 * 1000.0);
            return new Date(millisecondsSince1Jan1970);
        }
    }

    protected class cViewObjectsAction
    extends WsAbstractAction {
        public cViewObjectsAction() {
            super(bundle, "ChangeHistoryPanel.Action.ViewObjects");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cViewFullTextAction
    extends WsAbstractAction {
        public cViewFullTextAction() {
            super(bundle, "ChangeHistoryPanel.Action.ViewFullText");
            this.setMenuSupportId("viewfulltext");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int[] aSelectedRows = ChangeHistoryPanel.this.m_tblHistory.getSelectedRowsFromSelectedCells();
                ChangeHistoryPanel.this.m_tblHistory.convertRowIndexesToModel(aSelectedRows);
                cChangeHistoryModel cChangeHistoryModel2 = ChangeHistoryPanel.this.m_mdlHistory;
                int n = aSelectedRows[0];
                ChangeHistoryPanel.this.m_mdlHistory;
                Change oChange = (Change)cChangeHistoryModel2.getValueAt(n, 6);
                ChangeTextDialog v = new ChangeTextDialog((Frame)Workspace.getWorkspace(), oChange.getName(), oChange);
                v.show();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        public cPrintAction() {
            super(bundle, "ChangeHistoryPanel.Action.Print");
            this.setMenuSupportId("print");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)ChangeHistoryPanel.this.m_tblHistory, (PageFormat)new WsTitledPageFormat(bundle.getString("ChangeHistoryPanel.PrintJobName.txt")), (boolean)false);
            try {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
                    return;
                }
                pjob.setJobName(bundle.getString("ChangeHistoryPanel.PrintJobName.txt"));
                pjob.setPageable((Pageable)printer);
                if (pjob.printDialog()) {
                    pjob.print();
                }
            }
            catch (PrinterException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("ChangeHistoryPanel.PrintError.txt"), (int)0);
            }
            finally {
                printer.dispose();
            }
        }
    }

    protected class cPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            int[] aSelectedRows = ChangeHistoryPanel.this.m_tblHistory.getSelectedRowsFromSelectedCells();
            ChangeHistoryPanel.this.m_tblHistory.convertRowIndexesToModel(aSelectedRows);
            cChangeHistoryModel cChangeHistoryModel2 = ChangeHistoryPanel.this.m_mdlHistory;
            int n = aSelectedRows[0];
            ChangeHistoryPanel.this.m_mdlHistory;
            Object what = cChangeHistoryModel2.getValueAt(n, 6);
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add((Action)ChangeHistoryPanel.this.m_actPrint);
            if (what != null) {
                mnuPopup.add((Action)ChangeHistoryPanel.this.m_actViewFullText);
            }
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

