/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ActionOptionsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ActionOptionsTableModel.class);
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    public static final int PROPERTY_COL = 2;
    protected static final int W_NAME_COL = 220;
    protected static final int W_VALUE_COL = 250;
    protected static final int TOTAL_COLS = 2;
    protected static final int TOTAL_HIDDEN_COLS = 1;
    protected Property m_Metadata;
    protected String m_Event;
    protected Property m_Property;
    protected AssociationList m_alProperties;

    public ActionOptionsTableModel(Property iMetadata, String iEvent) {
        this.m_Metadata = iMetadata;
        this.m_Event = iEvent;
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("ActionOptionsTableModel.Name.txt"), 220, 200);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ActionOptionsTableModel.Value.txt"), 250, 200);
        this.m_aColumns[2] = new WsMetadataTableColumn();
        WsStringTableColumn tcName_Col = (WsStringTableColumn)this.m_aColumns[0];
        tcName_Col.setEditable(false);
    }

    public void setProperty(Property aProperty) {
        this.m_Property = aProperty;
    }

    public Property getProperty() {
        return this.m_Property;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_Metadata.isNewObject()) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_Metadata, null, null, "", 8);
        }
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = 0;
        this.m_alProperties = this.m_Metadata.getProperties();
        for (int iProperty = 0; iProperty < this.m_alProperties.size(); ++iProperty) {
            Property lActionOption = (Property)this.m_alProperties.get(iProperty);
            if (!lActionOption.getPropertyRole().equals("parameter")) continue;
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(lActionOption.getName());
            if (lActionOption.getDefaultValue().equals("") && lActionOption.getName().equals("Message")) {
                alRow.add(this.m_Event);
            } else {
                alRow.add(lActionOption.getDefaultValue());
            }
            alRow.add((String)lActionOption);
            this.m_lData.add(alRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int nProperties = this.m_alProperties.size();
        ArrayList<Object> alOldProperties = new ArrayList<Object>(nProperties);
        for (int iProperties = 0; iProperties < nProperties; ++iProperties) {
            alOldProperties.add(this.m_alProperties.get(iProperties));
        }
        this.m_alProperties.removeAllElements();
        int nRows = this.m_lData.size();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            Property oProperty = (Property)this.getValueAt(iRow, 2);
            String oActionOptionName = (String)this.getValueAt(iRow, 0);
            String oActionOptionValue = (String)this.getValueAt(iRow, 1);
            if (!oProperty.getName().equals(oActionOptionName)) {
                oProperty.setName(oActionOptionName);
                oProperty.setPropertyName(oActionOptionName);
                oProperty.setDesc(oActionOptionName);
            }
            if (!oProperty.getDefaultValue().equals(oActionOptionValue)) {
                oProperty.setDefaultValue(oActionOptionValue);
            }
            this.m_alProperties.add((Object)oProperty);
            if (!alOldProperties.contains(oProperty)) continue;
            alOldProperties.remove(oProperty);
        }
    }

    public int findActionRow(Property oProperty) {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!oProperty.equals(this.getValueAt(iRow, 2))) continue;
            return iRow;
        }
        return -1;
    }

    public void deleteRowMetadata(int iRow) throws MdException, RemoteException {
        Property prop = (Property)this.getValueAt(iRow, 2);
        MdObjectStore store = (MdObjectStore)prop.getObjectStore();
        store.removeObjectFromStore((CMetadata)prop, "");
    }
}

