/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.viewdata2.RowCount;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.wadmin.viewdata2.impl.WorkTableBrowseFactory;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JComponent;

public class WorkTablePanel
extends ViewDataPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WorkTablePanel.class);
    private WorkTable m_workTable;
    private RowCount m_counter;
    private int m_rowCount = -1;

    public WorkTablePanel(WorkTable workTable) {
        this(workTable, null);
    }

    public WorkTablePanel(WorkTable workTable, WsAppServer appServer) {
        this.m_workTable = workTable;
        this.m_appServer = appServer;
    }

    @Override
    protected void initializeImpl() {
        String assignedID = null;
        try {
            assignedID = this.m_appServer.openAssignedSQLConnection();
            this.m_rowCount = RowCount.getRowCountFromDictionary("WORK", this.m_workTable.getTableName(), (Connection)this.m_appServer.getAssignedSQLConnection(assignedID));
        }
        catch (WsAppServerFailException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            if (assignedID != null) {
                this.m_appServer.closeAssignedSQLConnection(assignedID);
            }
        }
        super.initializeImpl();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        if (this.m_counter != null) {
            this.m_counter.dispose();
        }
        super.saveSettingsAndCleanUp();
    }

    @Override
    protected ViewDataAbstractFactory createFactory() throws ViewDataException {
        return new WorkTableBrowseFactory(this.getWorkTable(), this.m_appServer);
    }

    protected WsAppServer getAppServer() {
        return this.m_appServer;
    }

    protected WorkTable getWorkTable() {
        return this.m_workTable;
    }

    @Override
    protected void onFetchSuccessful() {
        super.onFetchSuccessful();
        if (!this.getFactory().getDefaultModel().isRowCountKnown() && this.m_rowCount != -1 && this.m_rowCount >= 0 && !this.getFactory().getDefaultModel().hasFilter()) {
            this.getFactory().getDefaultModel().setRowCount(this.m_rowCount);
        }
    }

    @Override
    protected void onFetchError(String msg, ViewDataException e) {
        super.onFetchError(msg, e);
        if (e.hasCause() && e.causeInstanceOf(WsAppServerCodeException.class)) {
            this.showWsAppServerCodeException((WsAppServerCodeException)e.getCause());
        } else {
            MessageUtil.displayDetailsMessage((String)bundle.getString("WorkTablePanel.ErrorFetchingData.txt"), (int)0, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showWsAppServerCodeException(WsAppServerCodeException e) {
        WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
        try {
            logPropertyTab.appendText(((MetadataConnectionManager)this.getFactory().getDefaultConnectionManager()).getAppServer().getLog());
            logPropertyTab.scrollToTop();
            MessageUtil.displayDetailsMessage((String)e.getLocalizedMessage(), (String)bundle.getString("WorkTablePanel.WsAppServerCodeExceptionTitle.txt"), (int)0, (JComponent)logPropertyTab);
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)bundle.formatString("WorkTablePanel.CodeSubmitLogNotAvailable.fmt.txt", (Object)ex.getLocalizedMessage()), (int)0);
        }
        finally {
            logPropertyTab.saveSettingsAndCleanUp();
        }
    }
}

