/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataJDBCModel;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.event.JDBCSQLQueryModelListener;
import com.sas.wadmin.viewdata2.impl.JDBCSQLQueryModel;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;

public class PhysicalTableSQLQueryModelFactory
extends ViewDataAbstractFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(PhysicalTableSQLQueryModelFactory.class);
    private PhysicalTable m_tableMetadata;
    private WsAppServer m_appServer;
    private JDBCSQLQueryModelListener jdbcListener;
    private String m_query;

    public PhysicalTableSQLQueryModelFactory(PhysicalTable tableMetadata) {
        this(tableMetadata, null, null);
    }

    public PhysicalTableSQLQueryModelFactory(PhysicalTable tableMetadata, WsAppServer appServer, String query) {
        this.m_tableMetadata = tableMetadata;
        this.m_appServer = appServer;
        this.m_query = query;
    }

    @Override
    public ConnectionManager createConnectionManager() throws ViewDataException {
        MetadataConnectionManager connManager = new MetadataConnectionManager((DataTable)this.m_tableMetadata, false, this.m_appServer);
        connManager.init();
        return connManager;
    }

    @Override
    public ViewDataModel createModel() throws ViewDataException {
        try {
            if (this.m_query == null) {
                this.m_query = "SELECT * FROM " + this.getTableSQLName();
            }
            JDBCSQLQueryModel model = new JDBCSQLQueryModel(this.m_query, this.createDefaultConnectionManager());
            model.setTableSQLName(this.m_tableMetadata.getSASTableName());
            if (this.jdbcListener != null) {
                model.addJDBCDataModelListener(this.jdbcListener);
            }
            return model;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    @Override
    public ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = super.createToolBar();
        toolbar.addComponent(CommonActionsFactory.getGoToRowWidget(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(this.getAction("Common:Print"));
        toolbar.addFlatToolButton(this.getAction("Common:Refresh"));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSearchScreenAction(this.createDefaultSearchToolArea()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowJDBCColumnNameAction((ViewDataJDBCModel)this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowJDBCColumnLabelAction((ViewDataJDBCModel)this.createDefaultModel()));
        return toolbar;
    }

    @Override
    protected ViewDataTable createTable() throws ViewDataException {
        ViewDataTable table = super.createTable();
        table.setEditable(false);
        return table;
    }

    @Override
    protected PhysicalTable getPhysicalTable() {
        return this.m_tableMetadata;
    }

    protected String getTableSQLName() throws MdException, RemoteException, ViewDataException {
        String libref = this.getLibRef();
        if (libref == null) {
            throw new ViewDataException(bundle.getString("PhysicalTableSQLQueryModelFactory.LibraryFetchFail.txt"));
        }
        return libref + "." + DBMSNamesUtil.getQuotedString((String)this.m_tableMetadata.getSASTableName(), (DataTable)this.m_tableMetadata);
    }

    protected String getLibRef() throws MdException, RemoteException, ViewDataException {
        SASLibrary library = this.getLibrary();
        if (library != null) {
            return library.getLibref();
        }
        if (this.m_tableMetadata instanceof WorkTable) {
            return "work";
        }
        return null;
    }

    protected SASLibrary getLibrary() throws MdException, RemoteException, ViewDataException {
        WsAppServer appServer = ((MetadataConnectionManager)this.createDefaultConnectionManager()).getAppServer();
        ServerContext iDefault = appServer.getServerContext();
        SASLibrary iLib = LibraryUtil.getLibrary((DataTable)this.m_tableMetadata, (ServerContext)iDefault);
        if (iLib == null) {
            return null;
        }
        return LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
    }

    @Override
    protected boolean isDatasetEditable() throws ViewDataException {
        return false;
    }

    public void setJDBCSQLQueryModelListener(JDBCSQLQueryModelListener listner) {
        this.jdbcListener = listner;
    }
}

