/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Role;
import com.sas.wadmin.viewdata2.RowCount;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.event.JDBCSQLQueryModelListener;
import com.sas.wadmin.viewdata2.impl.JobTableFactory;
import com.sas.wadmin.viewdata2.impl.PhysicalTableBrowseFactory;
import com.sas.wadmin.viewdata2.impl.PhysicalTableEditFactory;
import com.sas.wadmin.viewdata2.impl.PhysicalTableSQLQueryModelFactory;
import com.sas.wadmin.viewdata2.impl.TableConnectionManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class PhysicalTablePanel
extends ViewDataPanel
implements JDBCSQLQueryModelListener {
    private static WAdminResource bundle = WAdminResource.getBundle(PhysicalTablePanel.class);
    private boolean RUN_DEAD_CODE = false;
    private ITable m_modelTable;
    private PhysicalTable m_physicalTable;
    private RowCount m_counter;
    private BaseModel m_mdl;
    private OMRAdapter m_omr;
    private boolean m_editable;
    private Mode m_mode;

    public PhysicalTablePanel(PhysicalTable physicalTable) {
        this(physicalTable, Mode.BROWSE);
    }

    public PhysicalTablePanel(PhysicalTable physicalTable, Mode mode) {
        this(physicalTable, mode, false, null);
    }

    public PhysicalTablePanel(PhysicalTable physicalTable, boolean editable) {
        this(physicalTable, Mode.BROWSE, editable, null);
    }

    public PhysicalTablePanel(PhysicalTable physicalTable, Mode mode, boolean editable, WsAppServer appServer) {
        if (this.RUN_DEAD_CODE) {
            new Mode();
        }
        this.m_mode = Mode.BROWSE;
        this.m_physicalTable = physicalTable;
        this.m_modelTable = null;
        this.m_mode = mode;
        this.m_editable = this.m_mode == Mode.EDIT ? true : editable;
        this.m_appServer = appServer;
    }

    public PhysicalTablePanel(ITable table, Mode mode, boolean editable, WsAppServer appServer) {
        if (this.RUN_DEAD_CODE) {
            new Mode();
        }
        this.m_mode = Mode.BROWSE;
        this.m_physicalTable = null;
        this.m_modelTable = table;
        this.m_mode = mode;
        this.m_editable = this.m_mode == Mode.EDIT ? true : editable;
        this.m_appServer = appServer;
        this.m_mdl = new BaseModel();
        this.m_mdl.setDebugName(this.m_modelTable.getName() + " view data edit mode");
        this.m_mdl.setModelEventsEnabled(false);
        try {
            this.m_omr = new OMRAdapter((IModel)this.m_mdl, Workspace.getMdFactory(), this.m_modelTable.getName() + " view data edit mode");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_modelTable != null) {
            return;
        }
        String sOptions = "<TEMPLATES><PhysicalTable><Columns/><TablePackage/></PhysicalTable><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></TEMPLATES>";
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.getPhysicalTable(), null, null, sOptions, 24972);
        super.populateStore();
    }

    @Override
    public boolean canClose() {
        if (!super.canClose()) {
            return false;
        }
        if (this.getFactory() == null) {
            return true;
        }
        if (this.m_mode == Mode.EDIT && this.getFactory().hasDefaultTable() && this.getFactory().getDefaultTable().isEditingInProgress()) {
            int ret = MessageUtil.displayMessage((String)bundle.getString("PhysicalTablePanel.CloseWhenEditingPrompt.txt"), (String)bundle.getString("PhysicalTablePanel.CloseWhenEditingPromptTitle.txt"), (int)2, (int)1);
            if (ret == -1 || ret == 2) {
                return false;
            }
            if (ret == 1) {
                this.getFactory().getDefaultTable().cancelRowEditing();
                return true;
            }
            this.getFactory().getDefaultTable().commitEditRow();
            return !this.getFactory().getDefaultTable().isEditingInProgress();
        }
        return true;
    }

    @Override
    public void saveSettingsAndCleanUp() {
        if (this.m_mdl != null) {
            this.m_mdl.dispose();
        }
        if (this.m_omr != null) {
            this.m_omr.dispose();
        }
        this.disposeRowCounter();
        super.saveSettingsAndCleanUp();
    }

    protected void disposeRowCounter() {
        if (this.m_counter != null) {
            this.m_counter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMode(Mode mode) {
        block31: {
            if (mode == this.m_mode) {
                return;
            }
            Mode oldMode = this.m_mode;
            ResultSet rs = null;
            if (mode != Mode.BROWSE && mode != Mode.EDIT && mode != Mode.METADATA_OUT_OF_SYNC) {
                throw new IllegalArgumentException("Illegal mode");
            }
            if (mode == Mode.EDIT && !this.m_editable) {
                throw new IllegalArgumentException("Not editable");
            }
            try {
                this.m_mode = mode;
                this.moveDataToView();
                if (mode != Mode.EDIT) break block31;
                ViewDataAbstractFactory factory = this.createFactory();
                try {
                    ViewDataModel vdModel = factory.createModel();
                    rs = vdModel.createStatement().executeQuery(vdModel.getQuery());
                    if (rs.getConcurrency() != 1008) {
                        MessageUtil.displayMessage((String)bundle.getString("PhysicalTablePanel.EditModeFailed.txt"), (String)bundle.getString("PhysicalTablePanel.EditModeFailed.title.txt"), (int)0);
                        this.m_mode = oldMode;
                        this.moveDataToView();
                    }
                }
                finally {
                    factory.dispose();
                }
            }
            catch (MdException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (SQLException se) {
                MessageUtil.displayMessage((String)se.getLocalizedMessage(), (int)0);
            }
            catch (ViewDataException ve) {
                MessageUtil.displayMessage((String)ve.getLocalizedMessage(), (int)0);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException se) {
                    MessageUtil.displayMessage((String)se.getLocalizedMessage(), (int)0);
                }
            }
        }
    }

    @Override
    protected ViewDataAbstractFactory createFactory() throws ViewDataException {
        if (this.m_modelTable != null && this.m_mode == Mode.BROWSE) {
            if (this.m_modelTable instanceof IExternalTable) {
                IServer server = ((IExternalTable)this.m_modelTable).getServer();
                WsAppServer appServer = null;
                if (server != null) {
                    appServer = WsAppServer.createAppServer((String)server.getID());
                }
                return new JobTableFactory(this.m_modelTable, appServer, null);
            }
            return new JobTableFactory(this.m_modelTable, this.m_appServer, new EditModeAction());
        }
        if (this.m_mode == Mode.EDIT) {
            return new PhysicalTableEditFactory(this.getPhysicalTable(), new BrowseModeAction());
        }
        if (this.m_mode == Mode.BROWSE) {
            if (this.m_editable) {
                PhysicalTableBrowseFactory factory = new PhysicalTableBrowseFactory(this.getPhysicalTable(), this.m_appServer, new EditModeAction());
                this.m_editable = factory.isDatasetEditable();
                return factory;
            }
            return new PhysicalTableBrowseFactory(this.getPhysicalTable(), this.m_appServer, null);
        }
        PhysicalTableSQLQueryModelFactory factory = new PhysicalTableSQLQueryModelFactory(this.getPhysicalTable(), this.m_appServer, null);
        factory.setJDBCSQLQueryModelListener(this);
        return factory;
    }

    @Override
    public void refresh() {
        this.changeMode(Mode.BROWSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PhysicalTable getPhysicalTable() {
        if (this.m_physicalTable == null && this.m_modelTable != null && this.m_modelTable instanceof IPhysicalTable && this.m_mdl != null && this.m_omr != null) {
            try {
                if (this.m_modelTable instanceof IWorkTable) {
                    this.m_mdl.setUndoSupported(false);
                    IWorkTable wTable = (IWorkTable)this.m_modelTable;
                    IWorkTable newTable = this.m_mdl.getObjectFactory().createNewWorkTable(this.m_mdl.createIDForNewObject(wTable.getID()));
                    boolean undoSpt = wTable.getModel().isUndoSupported();
                    wTable.getModel().setUndoSupported(false);
                    try {
                        wTable.deepCopy((IPhysicalTable)newTable);
                    }
                    finally {
                        wTable.getModel().setUndoSupported(undoSpt);
                    }
                    newTable.saveToOMR(this.m_omr);
                    this.m_modelTable = newTable;
                }
                this.m_omr.populateFor((IOMRPersistable)this.m_modelTable);
                return (PhysicalTable)this.m_omr.acquireOMRObject((IOMRPersistable)this.m_modelTable);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            return null;
        }
        return this.m_physicalTable;
    }

    @Override
    public String getDisplayTitle() {
        if (!this.m_editable) {
            return bundle.formatString("PhysicalTablePanel.BrowseOnlyTitle.fmt.txt", (Object)super.getDisplayTitle());
        }
        return super.getDisplayTitle();
    }

    @Override
    protected void onFetchStarted() {
        super.onFetchStarted();
        this.disposeRowCounter();
        this.setEnabled(false);
        if (this.m_mode == Mode.BROWSE && this.getFactory() != null && !this.getFactory().getDefaultModel().isRowCountKnown() && !this.getFactory().getDefaultModel().hasFilter()) {
            this.m_counter = new RowCount(this.getFactory());
            this.m_counter.getRowCount(this.getFactory().getDefaultModel().getLibRef(), this.getFactory().getDefaultModel().getTableSQLName());
        }
    }

    @Override
    protected void onFetchSuccessful() {
        super.onFetchSuccessful();
        if (this.m_mode == Mode.BROWSE && this.getFactory() != null && !this.getFactory().getDefaultModel().isRowCountKnown() && !this.getFactory().getDefaultModel().hasFilter()) {
            this.setEnabled(false);
            new Thread(){

                @Override
                public void run() {
                    PhysicalTablePanel.this.m_counter.updateRowCountToModel();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onFetchError(String msg, ViewDataException e) {
        int option;
        block22: {
            this.disposeRowCounter();
            if (this.isFromClosingFrame()) {
                return;
            }
            if (!e.hasCause() || !e.causeInstanceOf(WsAppServerFailException.class) && !e.causeInstanceOf(SQLException.class) || this.m_mode == Mode.METADATA_OUT_OF_SYNC || this.m_modelTable instanceof IExternalTable) {
                super.onFetchError(msg, e);
                if (e.hasCause() && e.causeInstanceOf(WsAppServerCodeException.class)) {
                    this.showWsAppServerCodeException((WsAppServerCodeException)e.getCause());
                    return;
                }
                MessageUtil.displayDetailsMessage((String)bundle.getString("PhysicalTablePanel.ErrorFetchingData.txt"), (int)0, (String)msg);
                return;
            }
            if (this.m_mode != Mode.BROWSE || !this.m_editable) break block22;
            try {
                if (((TableConnectionManager)this.getFactory().createDefaultConnectionManager()).doesTableExist()) break block22;
                int option2 = MessageUtil.displayMessage((String)bundle.formatString("PhysicalTablePanel.TableCreatePrompt.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName()), (int)2, (int)0);
                if (option2 == 1 || option2 == -1) {
                    super.onFetchError(msg, e);
                    return;
                }
                {
                    catch (WsAppServerFailException e18) {
                        Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)e18);
                        MessageUtil.displayMessage((String)e18.getLocalizedMessage(), (int)0);
                    }
                    catch (MdException e19) {
                        Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e19);
                        MessageUtil.displayMetadataExceptionMessage((MdException)e19, (String)"Accessing");
                        break block22;
                    }
                    try {
                        ((TableConnectionManager)this.getFactory().createDefaultConnectionManager()).createTable();
                        this.changeMode(Mode.EDIT);
                        return;
                    }
                    catch (CodegenException e1) {}
                    {
                        block23: {
                            Workspace.getDefaultLogger().error((Object)"CodegenException", (Throwable)e1);
                            break block23;
                            catch (BadLibraryDefinitionException e12) {
                                Workspace.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e12);
                                break block23;
                            }
                            catch (BadServerDefinitionException e13) {
                                Workspace.getDefaultLogger().error((Object)"BadServerDefinitionException", (Throwable)e13);
                                break block23;
                            }
                            catch (ServerException e14) {
                                Workspace.getDefaultLogger().error((Object)"ServerException", (Throwable)e14);
                                break block23;
                            }
                            catch (MdException e15) {
                                Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e15);
                                MessageUtil.displayMetadataExceptionMessage((MdException)e15, (String)"Accessing");
                                break block23;
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                                break block23;
                            }
                            catch (WsAppServerFailException e16) {
                                Workspace.getDefaultLogger().error((Object)"WsAppServerFailException", (Throwable)e16);
                                break block23;
                            }
                            catch (WsAppServerCodeException e17) {
                                this.showWsAppServerCodeException(e17);
                                Workspace.getDefaultLogger().error((Object)"WsAppServerCodeException", (Throwable)e);
                            }
                        }
                        super.onFetchError(msg, e);
                        return;
                    }
                }
            }
            catch (ViewDataException e1) {
                Workspace.getDefaultLogger().error((Object)"ViewDataException", (Throwable)e1);
            }
            catch (SQLException e1) {
                Workspace.getDefaultLogger().error((Object)"SQLException", (Throwable)e1);
            }
        }
        if ((option = MessageUtil.displayDetailsMessage((String)bundle.formatString("PhysicalTablePanel.MetadataOutOfSyncPrompt.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName()), (int)2, (int)0, (String)e.getCause().getMessage())) == 1) {
            super.onFetchError(msg, e);
            return;
        }
        if (e.causeInstanceOf(SQLException.class)) {
            super.onFetchError(msg, e);
            MessageUtil.displayDetailsMessage((String)bundle.getString("PhysicalTablePanel.ErrorFetchingData.txt"), (int)0, (String)msg);
            return;
        }
        this.getFactory().getDefaultModel().waitOnDataFetch();
        this.changeMode(Mode.METADATA_OUT_OF_SYNC);
    }

    protected void showWsAppServerCodeException(WsAppServerCodeException e) {
        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        int showMessage = MessageUtil.displayMessage((String)bundle.getString("PhysicalTablePanel.WsAppServerCodeException.txt"), (int)0, (int)0);
        if (showMessage == 0) {
            SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("PhysicalTablePanel.WsAppServerCodeExceptionTitle.txt"), true, ((TableConnectionManager)this.getFactory().getDefaultConnectionManager()).getAppServer());
            logDlg.setResizable(true);
            logDlg.show();
        }
    }

    class SCD2TypeEditCheckBoxOptionPane
    extends JOptionPane {
        private JCheckBox m_rememberDecision;

        public SCD2TypeEditCheckBoxOptionPane() {
            this.setMessageType(2);
            this.setOptionType(0);
            this.initialize();
        }

        protected void initialize() {
            this.m_rememberDecision = new JCheckBox(bundle.getString("PhysicalTablePanel.EditSCD2TablePromptRememberDecision.txt"));
            this.setMessage(new Object[]{bundle.getString("PhysicalTablePanel.EditSCD2TablePrompt.txt"), this.m_rememberDecision});
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        protected boolean getRememberDecision() {
            return this.m_rememberDecision.isSelected();
        }
    }

    class EditModeAction
    extends WsAbstractAction {
        public EditModeAction() {
            super(bundle, "PhysicalTablePanel.EditModeAction", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Edit"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AssociationList roles;
                if (PhysicalTablePanel.this.getPhysicalTable() != null && (roles = PhysicalTablePanel.this.getPhysicalTable().getRoles()) != null && !roles.isEmpty()) {
                    boolean isSCD2 = false;
                    for (int i = 0; i < roles.size(); ++i) {
                        if (!"SCD2_TABLE".equals(((Role)roles.get(i)).getObjectRole())) continue;
                        isSCD2 = true;
                        break;
                    }
                    if (isSCD2 && !this.shouldEditSCD2Table()) {
                        return;
                    }
                }
                PhysicalTablePanel.this.changeMode(Mode.EDIT);
            }
            catch (MdException e1) {
                Workspace.getDefaultLogger().warn((Object)"", (Throwable)e1);
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        protected boolean shouldEditSCD2Table() {
            WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
            boolean alwaysEditSCD2 = false;
            if (file.getPropertyString("ViewData.EditSCD2Tables") != null) {
                alwaysEditSCD2 = file.getPropertyBoolean("ViewData.EditSCD2Tables", false);
            }
            if (alwaysEditSCD2) {
                return true;
            }
            SCD2TypeEditCheckBoxOptionPane pane = new SCD2TypeEditCheckBoxOptionPane();
            JDialog dialog = pane.createDialog((Component)Workspace.getWorkspace(), bundle.getString("PhysicalTablePanel.AlwaysEditSCD2TableTitle.txt"));
            dialog.show();
            file.setPropertyBoolean("ViewData.EditSCD2Tables", pane.getRememberDecision());
            Object value = pane.getValue();
            return value != null && (Integer)value == 0;
        }
    }

    class BrowseModeAction
    extends WsAbstractAction {
        public BrowseModeAction() {
            super(bundle, "PhysicalTablePanel.BrowseModeAction", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Browse"));
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTablePanel.this.changeMode(Mode.BROWSE);
        }
    }

    public static final class Mode {
        public static final Mode BROWSE = new Mode();
        public static final Mode EDIT = new Mode();
        protected static final Mode METADATA_OUT_OF_SYNC = new Mode();

        private Mode() {
        }
    }
}

