/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.QueryOptionsDialog;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataJDBCModel;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.impl.EditModel;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class PhysicalTableEditFactory
extends ViewDataAbstractFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(PhysicalTableEditFactory.class);
    private PhysicalTable m_tableMetadata;
    private WsAbstractAction m_browseAction;

    public PhysicalTableEditFactory(PhysicalTable tableMetadata) {
        this.m_tableMetadata = tableMetadata;
    }

    public PhysicalTableEditFactory(PhysicalTable tableMetadata, WsAbstractAction browseAction) {
        this(tableMetadata);
        this.m_browseAction = browseAction;
    }

    @Override
    public ConnectionManager createConnectionManager() throws ViewDataException {
        MetadataConnectionManager connManager = new MetadataConnectionManager((DataTable)this.getPhysicalTable(), true, this.m_appServer);
        connManager.init();
        return connManager;
    }

    @Override
    public ViewDataModel createModel() throws ViewDataException {
        try {
            String libref = this.getLibRef();
            if (libref == null) {
                throw new ViewDataException(bundle.getString("PhysicalTableEditFactory.LibraryFetchFail.txt"));
            }
            EditModel model = new EditModel(libref, this.getTableSQLName(), this.createDefaultConnectionManager());
            model.setTableDisplayName(this.getPhysicalTable().getName());
            return model;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    @Override
    public ViewDataTable createTable() throws ViewDataException {
        ViewDataTable table = super.createTable();
        table.setEditable(true);
        table.setColumnHidingEnabled(false);
        return table;
    }

    @Override
    public QueryOptionsDialog createQueryOptionsDialog() throws ViewDataException {
        return null;
    }

    @Override
    public ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = super.createToolBar();
        CommonActionsFactory.UndoRedoActionGroup undoRedoActions = CommonActionsFactory.getUndoRedoActionGroup(this.createDefaultUndoManager());
        toolbar.addComponent(CommonActionsFactory.getGoToRowWidget(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(this.m_browseAction);
        toolbar.addFlatToggleButton(CommonActionsFactory.getNullEditModeAction());
        toolbar.addSeparator();
        toolbar.addFlatToolButton(this.getAction("Common:Print"));
        toolbar.addFlatToolButton(this.getAction("Common:Refresh"));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getPasteAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(undoRedoActions.getAction("undo"));
        toolbar.addFlatToolButton(undoRedoActions.getAction("redo"));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSearchScreenAction(this.createDefaultSearchToolArea()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowJDBCColumnNameAction((ViewDataJDBCModel)this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowJDBCColumnLabelAction((ViewDataJDBCModel)this.createDefaultModel()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCommitAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getDeleteAction(this.createDefaultTable()));
        return toolbar;
    }

    @Override
    protected void addAccelerators(ViewDataPanel pnl) throws ViewDataException {
        super.addAccelerators(pnl);
        InputMap mapInput = pnl.getInputMap(1);
        mapInput.put(KeyStroke.getKeyStroke(90, 2), "undo");
        mapInput.put(KeyStroke.getKeyStroke(89, 2), "redo");
        CommonActionsFactory.UndoRedoActionGroup undoRedoActions = CommonActionsFactory.getUndoRedoActionGroup(this.createDefaultUndoManager());
        ActionMap mapActions = pnl.getActionMap();
        mapActions.put("undo", (Action)undoRedoActions.getAction("undo"));
        mapActions.put("redo", (Action)undoRedoActions.getAction("redo"));
    }

    @Override
    public JPopupMenu createTablePopupMenu() throws ViewDataException {
        if (this.createDefaultTable() == null) {
            this.createTable();
        }
        if (this.createDefaultSearchToolArea() == null) {
            this.createSearchToolArea();
        }
        JPopupMenu tablePopup = new JPopupMenu();
        tablePopup.add((Action)CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        tablePopup.add((Action)CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        tablePopup.addSeparator();
        tablePopup.add((Action)CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        tablePopup.add((Action)CommonActionsFactory.getPasteAction(this.createDefaultTable()));
        tablePopup.add((Action)CommonActionsFactory.getPasteSpecialAction(this.createDefaultTable()));
        tablePopup.addSeparator();
        tablePopup.add((Action)CommonActionsFactory.getDeleteAction(this.createDefaultTable()));
        return tablePopup;
    }

    @Override
    protected JPopupMenu createTableRowHeaderPopupMenu() throws ViewDataException {
        JPopupMenu mnuPopup = this.createDefaultTable().createRowHeaderPopupMenu();
        WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
        if (mnuPopup.getComponentCount() != 0) {
            mnuPopup.addSeparator();
        }
        mnuPopup.add(new JMenuItem((Action)CommonActionsFactory.getDeleteAction(this.createDefaultTable())));
        return mnuPopup;
    }

    @Override
    protected PhysicalTable getPhysicalTable() {
        return this.m_tableMetadata;
    }

    protected String getTableSQLName() {
        try {
            return this.getPhysicalTable().getSASTableName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    protected String getLibRef() throws MdException, RemoteException, ViewDataException {
        SASLibrary library = this.getLibrary();
        if (library != null) {
            return library.getLibref();
        }
        return null;
    }

    protected SASLibrary getLibrary() throws MdException, RemoteException, ViewDataException {
        WsAppServer appServer = ((MetadataConnectionManager)this.createDefaultConnectionManager()).getAppServer();
        ServerContext iDefault = appServer.getServerContext();
        SASLibrary iLib = LibraryUtil.getLibrary((DataTable)this.getPhysicalTable(), (ServerContext)iDefault);
        if (iLib == null) {
            return null;
        }
        return LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
    }

    @Override
    protected boolean isDatasetEditable() throws ViewDataException {
        return true;
    }
}

