/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.wadmin.viewdata2.impl.PhysicalTableModel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;

public class PhysicalTableBrowseFactory
extends ViewDataAbstractFactory {
    private PhysicalTable m_tableMetadata;
    private WsAbstractAction m_editAction;

    public PhysicalTableBrowseFactory(PhysicalTable tableMetadata) {
        this(tableMetadata, null, null);
    }

    public PhysicalTableBrowseFactory(PhysicalTable tableMetadata, WsAppServer appServer, WsAbstractAction editAction) {
        this.m_tableMetadata = tableMetadata;
        this.m_appServer = appServer;
        this.m_editAction = editAction;
    }

    @Override
    public ConnectionManager createConnectionManager() throws ViewDataException {
        this.setFactoryDisposable(false);
        try {
            MetadataConnectionManager connManager = new MetadataConnectionManager((DataTable)this.getPhysicalTable(), this.m_appServer);
            connManager.init();
            MetadataConnectionManager metadataConnectionManager = connManager;
            return metadataConnectionManager;
        }
        finally {
            this.setFactoryDisposable(true);
        }
    }

    @Override
    public ViewDataModel createModel() throws ViewDataException {
        this.setFactoryDisposable(false);
        try {
            PhysicalTableModel physicalTableModel = new PhysicalTableModel(this.getPhysicalTable(), this.createDefaultConnectionManager());
            return physicalTableModel;
        }
        finally {
            this.setFactoryDisposable(true);
        }
    }

    @Override
    public ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = super.createToolBar();
        toolbar.addComponent(CommonActionsFactory.getGoToRowWidget(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        toolbar.addSeparator();
        if (this.isDatasetEditable() && this.m_editAction != null) {
            toolbar.addFlatToggleButton(CommonActionsFactory.getNullBrowseModeAction());
            toolbar.addFlatToolButton(this.m_editAction);
            toolbar.addSeparator();
        }
        toolbar.addFlatToolButton(this.getAction("Common:Print"));
        toolbar.addFlatToolButton(this.getAction("Common:Refresh"));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSearchScreenAction(this.createDefaultSearchToolArea()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSortScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowFilterScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSubsetScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnNameAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnLabelAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnMetadataNameAction(this.createDefaultModel()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getApplyMetadataFormatsAction(this.createDefaultModel()));
        return toolbar;
    }

    @Override
    protected ViewDataTable createTable() throws ViewDataException {
        ViewDataTable table = super.createTable();
        table.setEditable(false);
        return table;
    }

    @Override
    protected PhysicalTable getPhysicalTable() {
        return this.m_tableMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isDatasetEditable() throws ViewDataException {
        if (this.m_editAction == null || !Workspace.getWorkspace().isObjectEditable((CMetadata)this.getPhysicalTable())) {
            return false;
        }
        this.setFactoryDisposable(false);
        try {
            if (!"DATA".equals(this.getPhysicalTable().getMemberType())) {
                boolean bl = false;
                return bl;
            }
            SASLibrary lib = ((MetadataConnectionManager)this.createDefaultConnectionManager()).getSASLibrary();
            if (lib == null) {
                boolean bl = false;
                return bl;
            }
            if (!"BASE".equals(lib.getEngine()) || this.getPhysicalTable().getSASTableName().indexOf("&") != -1) {
                boolean bl = false;
                return bl;
            }
            AssociationList lServers = lib.getDeployedComponents();
            if (lServers.isEmpty()) {
                boolean bl = this.isDefaultAppServerWorkspace();
                return bl;
            }
            for (int i = 0; i < lServers.size(); ++i) {
                ServerContext iSCx = (ServerContext)lServers.get(i);
                AssociationList lLogicals = iSCx.getUsingComponents();
                for (int j = 0; j < lLogicals.size(); ++j) {
                    LogicalServer iLs = (LogicalServer)lLogicals.get(j);
                    if ("440196D4-90F0-11D0-9F41-00A024BB830C".compareTo(iLs.getClassIdentifier()) != 0) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.setFactoryDisposable(true);
        }
    }
}

