/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.JobTableModel;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.SubmitType;
import java.rmi.RemoteException;

public class JobPhysicalTableModel
extends JobTableModel {
    IPhysicalTable m_physicalTable;

    public JobPhysicalTableModel(IPhysicalTable table, ConnectionManager manager) {
        super((ITable)table);
        this.m_physicalTable = table;
        this.setConnectionManager(manager);
    }

    @Override
    protected String getTableOptions() {
        try {
            return this.m_physicalTable.getReadTableOptions(true);
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            Workspace.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            Workspace.getDefaultLogger().error((Object)"BadServerDefinitionException", (Throwable)e);
        }
        catch (CodegenException e) {
            Workspace.getDefaultLogger().error((Object)"CodegenException", (Throwable)e);
        }
        catch (ServerException e) {
            Workspace.getDefaultLogger().error((Object)"ServerException", (Throwable)e);
        }
        return "";
    }

    @Override
    public String getLibRef() {
        WsAppServer appServer = this.getConnectionManager().getAppServer();
        try {
            IServer server = ModelUIUtilities.getServerForAppServer(this.m_physicalTable.getModel(), appServer);
            ILibrary lib = this.m_physicalTable.getClientLibrary(server);
            if (lib != null) {
                return lib.getLibref();
            }
            return SubmitType.getInstance().getSubmittedWorkLibrary();
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return SubmitType.getInstance().getSubmittedWorkLibrary();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return SubmitType.getInstance().getSubmittedWorkLibrary();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return SubmitType.getInstance().getSubmittedWorkLibrary();
        }
    }

    @Override
    protected void postFetchDataProcessing() throws ViewDataException {
        if (this.isDisplayColumnsChanged()) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableRowsInserted(0, this.getRowCount() - 1);
        }
        this.setDisplayColumnsChanged(false);
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public boolean isSubsetable() {
        return true;
    }

    @Override
    protected void fetchDataPreemptive() throws ViewDataException {
        try {
            WsAppServer appServer = this.getConnectionManager().getAppServer();
            if (appServer != null) {
                appServer.submitSASCode("options obs = max;");
            }
            super.fetchDataPreemptive();
        }
        catch (WsAppServerCodeException e) {
            throw new ViewDataException(e);
        }
        catch (WsAppServerFailException e) {
            throw new ViewDataException(e);
        }
    }
}

