/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.impl.ExternalTableModel;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;

public class ExternalTableBrowseFactory
extends ViewDataAbstractFactory {
    private ExternalTable m_tableMetadata;
    private EFIDataModel m_efiModel;

    public ExternalTableBrowseFactory(ExternalTable tableMetadata) {
        this.m_tableMetadata = tableMetadata;
    }

    public ExternalTableBrowseFactory(ExternalTable tableMetadata, EFIDataModel model) {
        this.m_tableMetadata = tableMetadata;
        this.m_efiModel = model;
    }

    @Override
    public ConnectionManager createConnectionManager() throws ViewDataException {
        try {
            this.m_efiModel = this.getEFIDataModel();
            if (this.m_efiModel == null) {
                this.m_efiModel = new EFIDataModel();
            }
            this.m_efiModel.setExternalTable(this.getExternalTable());
            this.m_efiModel.populateStore();
            MetadataConnectionManager connManager = new MetadataConnectionManager((DataTable)this.getExternalTable(), this.getEFIDataModel().getAppServer());
            connManager.setEditable(false);
            connManager.init();
            return connManager;
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    @Override
    public ViewDataModel createModel() throws ViewDataException {
        ConnectionManager connManager = this.createDefaultConnectionManager();
        return new ExternalTableModel(this.getEFIDataModel(), connManager);
    }

    @Override
    public ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = super.createToolBar();
        toolbar.addComponent(CommonActionsFactory.getGoToRowWidget(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        toolbar.addFlatToolButton(CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(this.getAction("Common:Print"));
        toolbar.addFlatToolButton(this.getAction("Common:Refresh"));
        toolbar.addSeparator();
        toolbar.addFlatToolButton(CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSearchScreenAction(this.createDefaultSearchToolArea()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSortScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowFilterScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowSubsetScreenAction(this.createDefaultQueryOptionsDialog()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnNameAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnLabelAction(this.createDefaultModel()));
        toolbar.addFlatToggleButton(CommonActionsFactory.getShowMetadataColumnMetadataNameAction(this.createDefaultModel()));
        toolbar.addSeparator();
        toolbar.addFlatToggleButton(CommonActionsFactory.getApplyMetadataFormatsAction(this.createDefaultModel()));
        return toolbar;
    }

    @Override
    protected ViewDataTable createTable() throws ViewDataException {
        ViewDataTable table = super.createTable();
        table.setEditable(false);
        return table;
    }

    @Override
    protected PhysicalTable getPhysicalTable() {
        return null;
    }

    protected ExternalTable getExternalTable() {
        return this.m_tableMetadata;
    }

    protected EFIDataModel getEFIDataModel() {
        return this.m_efiModel;
    }

    @Override
    protected boolean isDatasetEditable() throws ViewDataException {
        return false;
    }
}

