/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.swing.adapters.TableViewClipboardAdapter;
import com.sas.swing.visuals.tableview.DefaultRowHeaderRenderer;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTableRowModel;
import com.sas.wadmin.viewdata2.event.ViewDataModelAdapter;
import com.sas.wadmin.viewdata2.event.ViewDataTableListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsDefaultTableColumnHeader;
import com.sas.workspace.WsDefaultTableColumnHeaderRenderer;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoableEdit;

public class ViewDataTable
extends WsTable {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataTable.class);
    protected static final int EDIT_ROW_NONE = -100;
    protected static final int APPEND_ROW = -101;
    private JPopupMenu m_tablePopup;
    private int m_editRowNumber = -100;
    private Object[] m_editRow;
    private boolean m_isCommitting = false;
    private ArrayList m_viewDataListeners = new ArrayList();

    public ViewDataTable(ViewDataModel model) {
        super((WsAbstractTableModel)model);
        this.setClipboardAdapter(new ViewDataTableClipBoardAdapter((TableView)this));
        this.setColumnAutoResizeMode(4);
        this.setRowsReorderable(false);
        this.setRowHoldingEnabled(false);
        this.setSelectionMode(2);
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
        this.getColumnHeader().setCellsToSizeCount(0);
        if (this.getViewDataModel().isEditable()) {
            this.addKeyListener(new ViewDataTableKeyListener());
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancelRowEdit");
            this.getActionMap().put("cancelRowEdit", new ViewDataTableEscapeKeyHandler());
            this.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
            this.getRowHeader().setDefaultRenderer(this.createRowHeaderRenderer());
            if (this.getViewDataModel().isRowCountKnown()) {
                this.onRowCountKnown();
            }
        }
        this.getViewDataModel().addViewDataModelListener(this.createTableModelListener());
        ViewDataTablePopupListener popupListener = new ViewDataTablePopupListener();
        this.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)popupListener);
        this.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)popupListener);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new ViewDataTableColumnHeader(this.getColumnModel());
    }

    protected TableRowModel createDefaultRowModel() {
        return new ViewDataTableRowModel(this);
    }

    protected ViewDataTableModelListener createTableModelListener() {
        return new ViewDataTableModelListener();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new ViewDataTableSelectionListener();
    }

    protected TableCellRenderer createRowHeaderRenderer() {
        return new ViewDataTableRowHeaderRenderer();
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.m_tablePopup = popupMenu;
    }

    public void showColumn(int columnModelIndex, int position) {
        super.showColumn(columnModelIndex, position);
        this.getColumnHeader().sizeColumnToFit(position);
    }

    protected void updateColumnHeaderLabels() {
        int count = this.getColumnModel().getColumnCount();
        for (int i = 0; i < count; ++i) {
            String title = this.getViewDataModel().getColumnDisplayName(this.convertColumnIndexToModel(i));
            this.getColumnModel().getColumn(i).setHeaderValue(title);
        }
        this.sizeColumnsToFit();
        List list = this.getHiddenColumns();
        for (TableColumn tableColumn : list) {
            String title = this.getViewDataModel().getColumnDisplayName(tableColumn.getModelIndex());
            tableColumn.setHeaderValue(title);
        }
    }

    protected void updateSortColumns() {
        if (this.getViewDataModel().getSortedColumns() == null) {
            this.m_aSortColumns = null;
            this.m_aSortDirections = null;
            return;
        }
        int[] aSortColumns = (int[])this.getViewDataModel().getSortedColumns().clone();
        int[] aSortDirections = this.convertModelDirectionsToSortDirections(this.getViewDataModel().getSortedColumnOrder());
        int niceCols = 0;
        for (int i = 0; i < aSortColumns.length; ++i) {
            aSortColumns[i] = this.getViewDataModel().convertTrueIndexToColumn(aSortColumns[i]);
            if (aSortColumns[i] == -1) continue;
            ++niceCols;
        }
        this.m_aSortColumns = new int[niceCols];
        this.m_aSortDirections = new int[niceCols];
        int soFar = 0;
        for (int i = 0; i < aSortColumns.length; ++i) {
            if (aSortColumns[i] == -1) continue;
            this.m_aSortColumns[soFar] = aSortColumns[i];
            this.m_aSortDirections[soFar] = aSortDirections[i];
            ++soFar;
        }
        this.getColumnHeader().repaint();
    }

    public int getRowCount() {
        return this.getAdjustedRowCount();
    }

    protected int getAdjustedRowCount() {
        ViewDataModel model = this.getViewDataModel();
        if (!model.isEditable() || !model.isRowCountKnown()) {
            return model.getRowCount();
        }
        return model.getRowCount() + 1 + (this.isAppendRowEditing() ? 1 : 0);
    }

    public Object getValueAt(int row, int column) {
        if (this.getViewDataModel().isFetchDataRunning()) {
            return "";
        }
        if (!this.getViewDataModel().isEditable()) {
            return this.validateValue(column, super.getValueAt(row, column));
        }
        if (this.isEditingInProgress() && this.isEditRow(row)) {
            if (this.isAppendRowEditing()) {
                return ViewDataModel.UNCHANGED_VALUE.equals(this.m_editRow[this.convertColumnIndexToModel(column)]) ? this.validateValue(column, "") : this.m_editRow[this.convertColumnIndexToModel(column)];
            }
            return ViewDataModel.UNCHANGED_VALUE.equals(this.m_editRow[this.convertColumnIndexToModel(column)]) ? this.validateValue(column, super.getValueAt(row, column)) : this.m_editRow[this.convertColumnIndexToModel(column)];
        }
        if (this.isNewRow(row)) {
            return this.validateValue(column, "");
        }
        return this.validateValue(column, super.getValueAt(row, column));
    }

    protected Object validateValue(int column, Object value) {
        if (value == null || "".equals(value)) {
            if (this.getViewDataModel().getColumnClass(this.convertColumnIndexToModel(column)) == Double.class) {
                return ViewDataModel.UNKNOWN_DOUBLE;
            }
            if (this.getViewDataModel().getColumnSASType(this.convertColumnIndexToModel(column)).equals("D")) {
                return ViewDataModel.UNKNOWN_DATE;
            }
            return "";
        }
        String type = this.getViewDataModel().getColumnSASType(this.convertColumnIndexToModel(column));
        if (value instanceof String && !type.equals("C")) {
            return ((String)value).trim();
        }
        return value;
    }

    public void gotoRow(int row) throws SQLException, ViewDataException {
        this.getViewDataModel().gotoRow(row);
        this.selectRow(this.convertRowIndexToView(row));
    }

    public void gotoLastRow() throws SQLException, ViewDataException {
        this.getViewDataModel().gotoLastRow();
        int row = this.getViewDataModel().getRowCount();
        this.selectRow(this.convertRowIndexToView(row - 1));
    }

    public void gotoCurrentLastRow() {
        int row = this.getViewDataModel().getRowCount();
        this.selectRow(this.convertRowIndexToView(row - 1));
    }

    public void gotoCell(int row, int column) throws SQLException, ViewDataException {
        this.gotoRow(row);
        this.selectCell(row, column);
    }

    protected SizeSequence getRowHeightModel() {
        return this.rowHeightModel;
    }

    public void sort(int[] aColumns, int[] aDirections) {
        if (this.getViewDataModel().isFetchDataRunning()) {
            return;
        }
        if (this.getRowModel() instanceof WsDefaultTableRowModel) {
            int[] aModelColumns;
            if (!this.stopCellEditing()) {
                return;
            }
            if (aColumns == null) {
                aModelColumns = null;
            } else {
                int nColumns = aColumns.length;
                aModelColumns = new int[nColumns];
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    aModelColumns[iColumn] = this.convertColumnIndexToModel(aColumns[iColumn]);
                }
            }
            this.sortImpl(aModelColumns, aDirections);
        }
    }

    public void sortImpl(int[] aColumns, int[] aDirections) {
        try {
            this.m_aSortColumns = aColumns;
            this.m_aSortDirections = aDirections;
            ViewDataModel model = this.getViewDataModel();
            if (aColumns == null || aColumns.length == 0) {
                if (model.getSortedColumns() == null || model.getSortedColumns().length == 0) {
                    return;
                }
                model.clearSortColumns();
            } else {
                if (model.getSortedColumns() != null && model.getSortedColumns().length == aColumns.length) {
                    boolean changed = false;
                    for (int i = 0; i < aColumns.length; ++i) {
                        if (aColumns[i] == this.getViewDataModel().convertTrueIndexToColumn(model.getSortedColumns()[i]) && aDirections[i] == 1 == (model.getSortedColumnOrder()[i] == ViewDataModel.SortDirection.DIRECTION_ASCENDING)) continue;
                        changed = true;
                        break;
                    }
                    if (!changed) {
                        return;
                    }
                }
                model.setSortedColumns(this.convertColumnIndicesToTrue(aColumns), this.convertSortDirectionsToModelDirections(this.m_aSortDirections));
            }
            model.fetchData();
        }
        catch (ViewDataException e) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.TableLoadError.txt"), (int)0);
        }
    }

    protected int[] convertColumnIndicesToTrue(int[] indices) {
        if (indices == null) {
            return null;
        }
        int[] trueIndices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            trueIndices[i] = this.getViewDataModel().convertColumnIndexToTrue(indices[i]);
        }
        return trueIndices;
    }

    protected ViewDataModel.SortDirection[] convertSortDirectionsToModelDirections(int[] aDirections) {
        ViewDataModel.SortDirection[] directions = new ViewDataModel.SortDirection[aDirections.length];
        for (int i = 0; i < aDirections.length; ++i) {
            directions[i] = aDirections[i] == 1 ? ViewDataModel.SortDirection.DIRECTION_ASCENDING : ViewDataModel.SortDirection.DIRECTION_DESCENDING;
        }
        return directions;
    }

    protected int[] convertModelDirectionsToSortDirections(ViewDataModel.SortDirection[] aDirections) {
        int[] directions = new int[aDirections.length];
        for (int i = 0; i < aDirections.length; ++i) {
            directions[i] = aDirections[i] == ViewDataModel.SortDirection.DIRECTION_ASCENDING ? 1 : -1;
        }
        return directions;
    }

    protected void selectRange(int[] startCell, int[] endCell) {
        this.setCellSelectionInterval(startCell[0], startCell[1], endCell[0], endCell[1]);
    }

    public boolean isColumnHidden(int modelColumnIndex) {
        List hCols = this.getHiddenColumns();
        for (int i = 0; i < hCols.size(); ++i) {
            if (((TableColumn)hCols.get(i)).getModelIndex() != modelColumnIndex) continue;
            return true;
        }
        return false;
    }

    protected ViewDataModel getViewDataModel() {
        return (ViewDataModel)((Object)this.getModel());
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (!this.getViewDataModel().isEditable()) {
            throw new UnsupportedOperationException("Model not editable.");
        }
        if (this.m_editRowNumber == -100) {
            throw new UnsupportedOperationException("Table not editing.");
        }
        if (!this.isEditRow(row)) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.setValueAtWarning.txt"), (int)2);
            this.removeEditor();
            this.getSelectionModel().setValueIsAdjusting(false);
        } else {
            this.m_editRow[this.convertColumnIndexToModel((int)column)] = aValue;
        }
    }

    public void setEditingRow(int aRow) {
        super.setEditingRow(aRow);
        if (aRow < 0 || this.isEditingInProgress()) {
            return;
        }
        this.onRowEditingStarted(aRow);
        this.putSelectedCellInEditing();
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.isEditing() || extend && this.isAppendRow(rowIndex)) {
            return;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    public void setCellSelectionInterval(int row0, int column0, int row1, int column1) {
        if (this.isAppendRow(row1)) {
            --row1;
        }
        if (this.isAppendRow(row0)) {
            --row0;
        }
        super.setCellSelectionInterval(row0, column0, row1, column1);
    }

    public boolean isEditingInProgress() {
        if (!this.getViewDataModel().isEditable()) {
            return false;
        }
        return this.m_editRowNumber != -100;
    }

    protected void initEditRow(int editRowNumber) {
        this.m_editRowNumber = this.isAppendRow(editRowNumber) ? -101 : editRowNumber;
        this.m_editRow = this.getEmptyRowArray();
    }

    protected Object[] getEmptyRowArray() {
        Object[] emptyRow = new Object[this.getModel().getColumnCount()];
        for (int i = 0; i < emptyRow.length; ++i) {
            emptyRow[i] = ViewDataModel.UNCHANGED_VALUE;
        }
        return emptyRow;
    }

    protected boolean isEditRow(int row) {
        if (!this.isEditingInProgress()) {
            return false;
        }
        if (this.isAppendRowEditing()) {
            return this.isAppendRow(row);
        }
        return this.m_editRowNumber == row;
    }

    public void commitEditRow() {
        if (!this.isEditingInProgress()) {
            return;
        }
        if (this.isEditing() && !this.stopCellEditing()) {
            return;
        }
        try {
            this.m_isCommitting = true;
            List<Object> editRow = Arrays.asList((Object[])this.m_editRow.clone());
            this.replaceMissingWithNull(editRow);
            if (this.m_editRowNumber == -101) {
                this.undoableAppendRow(editRow);
            } else if (this.hasEditRowChanged()) {
                this.m_mgrUndo.addEdit(this.undoableSetRowValuesImpl1(this.convertRowIndexToModel(this.m_editRowNumber), editRow));
            }
            this.clearEditRow();
            this.onRowEditingEnded();
        }
        catch (SQLException e) {
            String message = this.m_editRowNumber == -101 ? bundle.getString("ViewDataTable.RowAppendJDBCError.txt") : bundle.getString("ViewDataTable.RowUpdateJDBCError.txt");
            MessageUtil.displayDetailsMessage((String)message, (int)0, (String)e.getMessage());
            this.selectCell(this.m_editRowNumber == -101 ? this.getAppendRowNumber() : this.m_editRowNumber, 0);
        }
        catch (ViewDataException e) {
            String message = this.m_editRowNumber == -101 ? bundle.getString("ViewDataTable.RowAppendError.txt") : bundle.getString("ViewDataTable.RowUpdateError.txt");
            MessageUtil.displayMessage((String)message, (int)0);
            this.selectCell(this.m_editRowNumber == -101 ? this.getAppendRowNumber() : this.m_editRowNumber, 0);
        }
        finally {
            this.m_isCommitting = false;
        }
    }

    protected void replaceMissingWithNull(List list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.getNullIfMissingValue(list.get(i)));
        }
    }

    protected Object getNullIfMissingValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.equals(ViewDataModel.UNKNOWN_DOUBLE) || value.equals(ViewDataModel.UNKNOWN_DATE)) {
            return null;
        }
        return value;
    }

    public void cancelRowEditing() {
        this.cancelCellEditing();
        if (!this.isEditingInProgress()) {
            return;
        }
        this.clearEditRow();
        this.onRowEditingCancelled();
    }

    protected boolean hasEditRowChanged() {
        boolean changed = false;
        for (int i = 0; i < this.m_editRow.length; ++i) {
            if (ViewDataModel.UNCHANGED_VALUE.equals(this.m_editRow[i])) continue;
            changed = true;
        }
        return changed;
    }

    protected void putSelectedCellInEditing() {
        int[][] cells = this.getSelectedCells();
        if (cells == null || cells.length == 0) {
            return;
        }
        this.editCellAt(cells[0][0], cells[0][1]);
    }

    protected void clearEditRow() {
        this.m_editRowNumber = -100;
        this.m_editRow = null;
    }

    protected boolean isAppendRowEditing() {
        return this.m_editRowNumber == -101;
    }

    protected boolean isAppendRow(int row) {
        if (!this.getViewDataModel().isRowCountKnown()) {
            return false;
        }
        return this.getAppendRowNumber() == row;
    }

    protected int getAppendRowNumber() {
        return this.getViewDataModel().getRowCount();
    }

    protected void putAppendRowInEditing() {
        if (this.isEditingInProgress()) {
            return;
        }
        this.initEditRow(this.getAppendRowNumber());
    }

    protected boolean isNewRow(int row) {
        if (!this.getViewDataModel().isRowCountKnown()) {
            return false;
        }
        return this.getNewRowNumber() == row;
    }

    protected int getNewRowNumber() {
        return this.getAppendRowNumber() + (this.isAppendRowEditing() ? 1 : 0);
    }

    protected void onRowCountKnown() {
    }

    protected void onRowEditingStarted(int row) {
        this.setSelectionMode(0);
        this.selectCell(this.getCurrentRow(), this.getCurrentColumn());
        this.initEditRow(row);
        this.fireRowUpdateStarted(row, this.isAppendRow(row));
    }

    protected void onRowEditingEnded() {
        int[][] selectedCells = this.getSelectedCells();
        this.setSelectionMode(2);
        if (selectedCells != null && selectedCells.length != 0) {
            this.selectCell(selectedCells[0][0], selectedCells[0][1]);
        }
        this.getRowHeader().repaint();
        this.fireRowUpdateEnded();
    }

    protected void onRowEditingCancelled() {
        this.getRowHeader().revalidate();
        this.getRowHeader().repaint();
        this.setSelectionMode(2);
        this.fireRowUpdateCancelled();
    }

    protected void onEditAppendRowGesture(int column) {
        if (this.isEditingInProgress()) {
            return;
        }
        this.putAppendRowInEditing();
        this.getViewDataModel().fireTableRowsInserted(this.getViewDataModel().getRowCount(), this.getViewDataModel().getRowCount() + 1);
        this.clearSelection();
        column = column >= 0 ? column : 0;
        this.selectCell(this.getAppendRowNumber(), column);
        this.fireRowUpdateStarted(this.getAppendRowNumber(), true);
    }

    protected void onCommitEditRowGesture() {
        this.commitEditRow();
    }

    protected void onPasteData(List pastedData) {
        this.undoablePasteData(pastedData);
    }

    public void onPasteSpecialData() {
        ((ViewDataTableClipBoardAdapter)this.getClipboardAdapter()).pasteSpecialSelectedCells();
    }

    protected void onPasteSpecialData(List pastedData) {
        this.undoablePasteAndAppendData(pastedData);
    }

    protected void onDeleteKeyPressed() {
        this.undoableDeleteSelectedRows();
    }

    protected void onFetchSuccessful() {
        this.updateSortColumns();
    }

    protected int handleSingleRowDeleteError(SQLException e, int row) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.DeleteRowError.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)e.getMessage()));
    }

    protected int handleMultiRowDeleteError(SQLException e, int row) {
        return this.handleMultiRowError(bundle.formatString("ViewDataTable.DeleteRowError.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)e.getMessage()));
    }

    protected int handleSingleRowSetValuesSQLError(SQLException e, int row) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.SetRowValuesErrorSQL.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)e.getMessage()));
    }

    protected int handleMultiRowSetValuesSQLError(SQLException e, int row) {
        return this.handleMultiRowError(bundle.formatString("ViewDataTable.SetRowValuesErrorSQL.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)e.getMessage()));
    }

    protected int handleSingleRowSetValuesFormatError(int row, int col) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.SetRowValuesErrorFormat.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)this.getColumnName(col)));
    }

    protected int handleEditRowSetValuesFormatError(int col) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.SetEditRowValuesErrorFormat.fmt.txt", (Object)this.getColumnName(col)));
    }

    protected int handleMultiRowSetValuesFormatError(int row, int col) {
        return this.handleMultiRowError(bundle.formatString("ViewDataTable.SetRowValuesErrorFormat.fmt.txt", (Object)new Integer(this.convertRowIndexToModel(row) + 1), (Object)this.getColumnName(col)));
    }

    protected int handleSingleRowPasteSpecialError(int row, ViewDataException e) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.PasteSpecialError.fmt.txt", (Object)new Integer(row), (Object)e.getMessage()));
    }

    protected int handleMultiRowPasteSpecialError(int row, ViewDataException e) {
        return this.handleMultiRowError(bundle.formatString("ViewDataTable.PasteSpecialError.fmt.txt", (Object)new Integer(row), (Object)e.getMessage()));
    }

    protected int handleSingleRowAppendError(SQLException e) {
        return this.handleSingleRowError(bundle.formatString("ViewDataTable.AppendRowError.fmt.txt", (Object)e.getMessage()));
    }

    protected int handleMultiRowAppendError(SQLException e) {
        return this.handleMultiRowError(bundle.formatString("ViewDataTable.AppendRowError.fmt.txt", (Object)e.getMessage()));
    }

    protected int handleSingleRowError(String message) {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        int action = file.getPropertyInt("ViewData.MultiRowOperationErrors", 0);
        switch (action) {
            case 1: {
                return 3;
            }
        }
        MessageUtil.displayMessage((String)message, (int)0);
        return 2;
    }

    protected int handleMultiRowError(String message) {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        int action = file.getPropertyInt("ViewData.MultiRowOperationErrors", 0);
        switch (action) {
            case 2: {
                MessageUtil.displayMessage((String)message, (int)0);
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        int value = this.showMultiRowOperationPrompt(message);
        switch (value) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 2;
    }

    protected int showMultiRowOperationPrompt(String message) {
        MultiRowErrorPromptOptionPane pane = new MultiRowErrorPromptOptionPane(message);
        JDialog dialog = pane.createDialog(null, bundle.getString("ViewDataTable.MultiRowErrorRowErrorTitle.txt"));
        dialog.show();
        return pane.getSelectedValue();
    }

    public void undoableSetValueAt(Object oValue, int iRow, int iCol) {
        this.setValueAt(oValue, iRow, iCol);
    }

    public void undoableInsertNewRowAfterLastSelectedRow() {
        throw new UnsupportedOperationException("New row not supported. Use append row.");
    }

    public void undoableInsertNewRow(int iRow) {
        throw new UnsupportedOperationException("New row not supported. Use append row.");
    }

    public UndoableEdit undoableInsertNewRowImpl(int iRow) {
        throw new UnsupportedOperationException("New row not supported. Use append row.");
    }

    public void undoableAppendRows(List lRowValueLists) throws SQLException, ViewDataException {
        if (!this.getViewDataModel().isEditable()) {
            throw new UnsupportedOperationException("Model not editable.");
        }
        for (int i = 0; i < lRowValueLists.size(); ++i) {
            this.undoableAppendRow((List)lRowValueLists.get(i));
        }
    }

    public void undoableAppendRow(List lRowValues) throws SQLException, ViewDataException {
        if (!this.getViewDataModel().isEditable()) {
            throw new UnsupportedOperationException("Model not editable.");
        }
        this.m_mgrUndo.addEdit(this.undoableAppendRowImpl(lRowValues));
    }

    protected UndoableEdit undoableAppendRowImpl(List lRowValues) throws SQLException, ViewDataException {
        this.appendRowImpl(lRowValues);
        if (!this.getViewDataModel().isRowCountKnown()) {
            this.getViewDataModel().gotoLastRow();
        }
        return this.createAppendRowUndoable(this.getViewDataModel().getRowCount() - 1, lRowValues);
    }

    protected void appendRowImpl(List lRowValues) throws SQLException {
        this.clearSelection();
        this.getViewDataModel().appendRow(lRowValues);
    }

    public void undoableDeleteSelectedRows() {
        int[] aSelectedRows = this.getCellSelectionEnabled() ? this.getSelectedRowsFromSelectedCells() : this.getSelectedRows();
        boolean suppress = false;
        if (!this.confirmDelete(aSelectedRows.length)) {
            return;
        }
        block7: for (int iSelectedRow = aSelectedRows.length - 1; iSelectedRow >= 0; --iSelectedRow) {
            try {
                this.m_mgrUndo.addEdit(this.undoableDeleteRowImpl1(aSelectedRows[iSelectedRow]));
                continue;
            }
            catch (SQLException e) {
                if (suppress) continue;
                int action = aSelectedRows.length == 1 ? this.handleSingleRowDeleteError(e, aSelectedRows[iSelectedRow]) : this.handleMultiRowDeleteError(e, aSelectedRows[iSelectedRow]);
                switch (action) {
                    case 2: {
                        this.selectRow(aSelectedRows[iSelectedRow]);
                        return;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 3: {
                        suppress = true;
                    }
                }
            }
        }
        int iRow = aSelectedRows[aSelectedRows.length - 1] - (aSelectedRows.length - 1);
        if (iRow < this.getModel().getRowCount()) {
            this.selectRow(iRow);
        } else if (this.getModel().getRowCount() > 0) {
            this.selectRow(iRow - 1);
        }
    }

    public void undoableDeleteRow(int iRow) {
        if (!this.confirmDelete(1)) {
            return;
        }
        try {
            this.m_mgrUndo.addEdit(this.undoableDeleteRowImpl1(iRow));
        }
        catch (SQLException e) {
            this.handleSingleRowDeleteError(e, iRow);
        }
    }

    protected UndoableEdit undoableDeleteRowImpl1(int iRow) throws SQLException {
        this.cancelRowEditing();
        iRow = this.convertRowIndexToModel(iRow);
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        List lRowValues = mdl.getRowValues(iRow);
        this.getViewDataModel().deleteRow1(iRow);
        return this.createDeleteRowUndoable(iRow, lRowValues);
    }

    protected boolean confirmDelete(int deleteRowCount) {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        boolean alwaysDeleteWithoutPrompt = false;
        if (file.getPropertyString("ViewData.DeleteRowsWithoutPrompt") != null) {
            alwaysDeleteWithoutPrompt = file.getPropertyBoolean("ViewData.DeleteRowsWithoutPrompt", false);
        }
        if (alwaysDeleteWithoutPrompt) {
            return true;
        }
        DeleteRowsCheckBoxOptionPane pane = new DeleteRowsCheckBoxOptionPane(deleteRowCount);
        JDialog dialog = pane.createDialog((Component)Workspace.getWorkspace(), bundle.getString("ViewDataTable.DeleteRowConfirmTitle.txt"));
        dialog.show();
        file.setPropertyBoolean("ViewData.DeleteRowsWithoutPrompt", pane.getRememberDecision());
        Object value = pane.getValue();
        return value != null && (Integer)value == 0;
    }

    public void undoablePasteData(List pastedData) {
        int pastedRowCount = pastedData.size();
        int pastedColCount = ((List)pastedData.get(0)).size();
        int startRow = -1;
        int startCol = -1;
        if (!this.isEditingInProgress()) {
            if (this.getSelectedCellCount() < 1) {
                return;
            }
            int[] cell = this.getCurrentCell();
            if (cell == null || cell.length == 0) {
                cell = this.getSelectedCells()[0];
            }
            startRow = cell[0];
            startCol = cell[1];
            if (startCol < 0) {
                startCol = 0;
            }
            if (this.undoablePasteData(startRow, startCol, pastedData)) {
                this.selectRange(new int[]{startRow, startCol}, new int[]{startRow + pastedRowCount - 1, startCol + pastedColCount - 1});
            }
        } else {
            if (this.isEditing()) {
                startRow = this.getEditingRow();
                startCol = this.getEditingColumn();
                this.cancelCellEditing();
            } else {
                int[] cell = this.getCurrentCell();
                if (cell != null && cell.length == 0) {
                    startRow = cell[0];
                    startCol = cell[1];
                }
            }
            if (startRow == -1 || startCol == -1) {
                startRow = this.isAppendRowEditing() ? this.getAppendRowNumber() : this.m_editRowNumber;
                startCol = 0;
            }
            if (pastedData.size() > 1) {
                MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.PasteEditRowMultipleRowsWarning.txt"), (int)2);
            }
            this.pasteDataIntoEditRow(startCol, pastedData);
            this.repaint();
        }
    }

    protected void pasteDataIntoEditRow(int col, List pastedData) {
        if (pastedData.isEmpty() || !this.isEditingInProgress()) {
            return;
        }
        int pastedColCount = ((List)pastedData.get(0)).size();
        if (col + pastedColCount > this.getColumnCount()) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.PasteEditRowFailed.txt"), (int)0);
            return;
        }
        List row = (List)pastedData.get(0);
        int setCol = col;
        try {
            for (int cIdx = 0; cIdx < pastedColCount; ++cIdx) {
                setCol = col + cIdx;
                Object value = row.get(cIdx);
                this.m_editRow[this.convertColumnIndexToModel((int)setCol)] = "".equals(value) ? null : (BaseTransforms.defaultInstance.isTransformable(String.class, this.getColumnClass(setCol)) ? BaseTransforms.defaultInstance.transform(value, this.getColumnClass(setCol)) : (this.getColumnClass(setCol) == Date.class ? this.getDateFormat(setCol).parse((String)value) : value));
            }
        }
        catch (TransformException e) {
            this.handleEditRowSetValuesFormatError(setCol);
        }
        catch (ParseException e) {
            this.handleEditRowSetValuesFormatError(setCol);
        }
        catch (NumberFormatException e) {
            this.handleEditRowSetValuesFormatError(setCol);
        }
    }

    protected boolean undoablePasteData(int row, int col, List pastedData) {
        if (!this.validatePasteData(pastedData, row, col)) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.PasteRangeInvalid.txt"), (int)0);
            return false;
        }
        int pastedRowCount = pastedData.size();
        int pastedColCount = ((List)pastedData.get(0)).size();
        boolean suppress = false;
        int action = 1;
        for (int rIdx = 0; rIdx < pastedRowCount; ++rIdx) {
            int setRow = row + rIdx;
            Object[] aRowValue = this.getEmptyRowArray();
            List colList = (List)pastedData.get(rIdx);
            int setCol = col;
            try {
                for (int cIdx = 0; cIdx < pastedColCount; ++cIdx) {
                    setCol = col + cIdx;
                    Object value = colList.get(cIdx);
                    aRowValue[this.convertColumnIndexToModel((int)setCol)] = "".equals(value) ? null : (BaseTransforms.defaultInstance.isTransformable(String.class, this.getColumnClass(setCol)) ? BaseTransforms.defaultInstance.transform(value, this.getColumnClass(setCol)) : (this.getColumnClass(setCol) == Date.class ? this.getDateFormat(setCol).parse((String)value) : value));
                }
                this.m_mgrUndo.addEdit(this.undoableSetRowValuesImpl1(setRow, Arrays.asList(aRowValue)));
            }
            catch (SQLException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesSQLError(e, setRow) : this.handleMultiRowSetValuesSQLError(e, setRow);
            }
            catch (TransformException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            catch (ParseException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            catch (NumberFormatException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            switch (action) {
                case 2: {
                    this.selectRow(setRow);
                    return false;
                }
                case 3: {
                    suppress = true;
                }
            }
        }
        return true;
    }

    protected boolean validatePasteData(List data, int startRow, int startCol) {
        if (data.isEmpty()) {
            return true;
        }
        int cols = -1;
        int rows = data.size();
        for (int i = 0; i < rows; ++i) {
            if (cols != -1 && ((List)data.get(i)).size() != cols) {
                return false;
            }
            if (cols != -1) continue;
            cols = ((List)data.get(i)).size();
        }
        try {
            if (startCol + cols > this.getColumnCount() || !this.getViewDataModel().peek(this.convertRowIndexToModel(startRow + rows - 1))) {
                return false;
            }
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
        return true;
    }

    public void undoablePasteAndAppendData(List pastedData) {
        int[] cell;
        int pastedRowCount = pastedData.size();
        int pastedColCount = ((List)pastedData.get(0)).size();
        int startRow = -1;
        int startCol = -1;
        if (!this.isEditingInProgress()) {
            if (this.getSelectedCellCount() < 1) {
                return;
            }
            cell = this.getCurrentCell();
            if (cell == null || cell.length == 0) {
                cell = this.getSelectedCells()[0];
            }
            startRow = cell[0];
            startCol = cell[1];
        } else {
            if (this.isEditing()) {
                startRow = this.getEditingRow();
                startCol = this.getEditingColumn();
                this.cancelCellEditing();
            } else {
                cell = this.getCurrentCell();
                if (cell != null && cell.length == 0) {
                    startRow = cell[0];
                    startCol = cell[1];
                }
            }
            if (startRow == -1 || startCol == -1) {
                startRow = this.isAppendRowEditing() ? this.getAppendRowNumber() : this.m_editRowNumber;
                startCol = 0;
            }
            this.cancelRowEditing();
        }
        this.undoablePasteAndAppendData(startRow, startCol, pastedData);
        if (!this.isAppendRow(startRow)) {
            int endRow = startRow + pastedRowCount <= this.getViewDataModel().getRowCount() ? startRow + pastedRowCount - 1 : this.getViewDataModel().getRowCount() - 1;
            int endCol = startCol + pastedColCount - 1;
            this.selectRange(new int[]{startRow, startCol}, new int[]{endRow, endCol});
        }
    }

    protected void undoablePasteAndAppendData(int row, int col, List pastedData) {
        if (!this.validatePasteAndAppendData(pastedData, col)) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataTable.PasteRangeInvalid.txt"), (int)0);
            return;
        }
        int pastedRowCount = pastedData.size();
        int pastedColCount = ((List)pastedData.get(0)).size();
        boolean suppress = false;
        int action = 1;
        for (int rIdx = 0; rIdx < pastedRowCount; ++rIdx) {
            int setRow = row + rIdx;
            Object[] aRowValue = this.getEmptyRowArray();
            List colList = (List)pastedData.get(rIdx);
            int setCol = col;
            try {
                this.getViewDataModel().peek(this.convertRowIndexToModel(setRow));
                for (int cIdx = 0; cIdx < pastedColCount; ++cIdx) {
                    setCol = col + cIdx;
                    Object value = colList.get(cIdx);
                    aRowValue[this.convertColumnIndexToModel((int)setCol)] = "".equals(value) ? null : (BaseTransforms.defaultInstance.isTransformable(String.class, this.getColumnClass(setCol)) ? BaseTransforms.defaultInstance.transform(value, this.getColumnClass(setCol)) : (this.getColumnClass(setCol) == Date.class ? this.getDateFormat(setCol).parse((String)value) : value));
                }
                if (this.getViewDataModel().getRowCount() > setRow && this.getViewDataModel().getRowCount() > this.convertRowIndexToModel(setRow)) {
                    this.m_mgrUndo.addEdit(this.undoableSetRowValuesImpl1(setRow, Arrays.asList(aRowValue)));
                } else {
                    this.m_mgrUndo.addEdit(this.undoableAppendRowImpl(Arrays.asList(aRowValue)));
                }
            }
            catch (SQLException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesSQLError(e, setRow) : this.handleMultiRowSetValuesSQLError(e, setRow);
            }
            catch (TransformException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            catch (ParseException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            catch (NumberFormatException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowSetValuesFormatError(setRow, setCol) : this.handleMultiRowSetValuesFormatError(setRow, setCol);
            }
            catch (ViewDataException e) {
                if (suppress) continue;
                action = pastedRowCount == 1 ? this.handleSingleRowPasteSpecialError(setRow, e) : this.handleMultiRowPasteSpecialError(setRow, e);
            }
            switch (action) {
                case 2: {
                    this.selectRow(setRow);
                    return;
                }
                case 3: {
                    suppress = true;
                }
            }
        }
    }

    protected boolean validatePasteAndAppendData(List data, int startCol) {
        if (data.isEmpty()) {
            return true;
        }
        int cols = -1;
        int rows = data.size();
        for (int i = 0; i < rows; ++i) {
            if (cols != -1 && ((List)data.get(i)).size() != cols) {
                return false;
            }
            if (cols != -1) continue;
            cols = ((List)data.get(i)).size();
        }
        try {
            if (startCol + cols > this.getColumnCount()) {
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
        return true;
    }

    protected DateFormat getDateFormat(int col) {
        return ((WsDateTableColumn)this.getViewDataModel().getColumn(this.convertColumnIndexToModel(col))).getDateFormat();
    }

    public void undoableSetRowsValues(int[] iaRows, List[] laRowValues) {
        this.cancelRowEditing();
        boolean suppress = false;
        block7: for (int i = 0; i < iaRows.length; ++i) {
            try {
                this.m_mgrUndo.addEdit(this.undoableSetRowValuesImpl1(iaRows[i], laRowValues[i]));
                continue;
            }
            catch (SQLException e) {
                if (suppress) continue;
                int action = iaRows.length == 1 ? this.handleSingleRowSetValuesSQLError(e, iaRows[i]) : this.handleMultiRowSetValuesSQLError(e, iaRows[i]);
                switch (action) {
                    case 2: {
                        this.selectRow(i);
                        return;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 3: {
                        suppress = true;
                    }
                }
            }
        }
    }

    public void undoableSetRowValues(int iRow, List lRowValues) {
        try {
            this.m_mgrUndo.addEdit(this.undoableSetRowValuesImpl1(iRow, lRowValues));
        }
        catch (SQLException e) {
            this.handleSingleRowSetValuesSQLError(e, iRow);
        }
    }

    protected UndoableEdit undoableSetRowValuesImpl1(int iRow, List lRowValues) throws SQLException {
        this.cancelCellEditing();
        iRow = this.convertRowIndexToModel(iRow);
        WsAbstractTableModel mdl = (WsAbstractTableModel)this.getModel();
        List lOldRowValues = mdl.getRowValues(iRow);
        this.getViewDataModel().setRowValues1(iRow, lRowValues);
        return this.createSetRowValuesUndoable(iRow, lRowValues, lOldRowValues);
    }

    protected UndoableEdit createSetRowValuesUndoable(int iRow, List lNewValues, List lOldValues) {
        return new SetRowValuesUndoable(iRow, lNewValues, lOldValues);
    }

    public UndoableEdit createAppendRowUndoable(int row, List lRowValues) {
        return new AppendRowUndoable(row, lRowValues);
    }

    protected UndoableEdit createDeleteRowUndoable(int iRow, List lRowValues) {
        return new DeleteRowUndoable(iRow, lRowValues);
    }

    public void addViewDataTableListener(ViewDataTableListener listener) {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            this.m_viewDataListeners = new ArrayList();
        }
        this.m_viewDataListeners.add(listener);
    }

    public void removeViewDataTableListener(ViewDataTableListener listener) {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            return;
        }
        this.m_viewDataListeners.remove(listener);
    }

    public void removeAllViewDataTableListeners() {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            return;
        }
        this.m_viewDataListeners.clear();
    }

    protected void fireRowUpdateStarted(int row, boolean isAppendRow) {
        for (ViewDataTableListener listener : this.m_viewDataListeners) {
            listener.rowUpdateStarted(row, isAppendRow);
        }
    }

    protected void fireRowUpdateEnded() {
        for (ViewDataTableListener listener : this.m_viewDataListeners) {
            listener.rowUpdateEnded();
        }
    }

    protected void fireRowUpdateCancelled() {
        for (ViewDataTableListener listener : this.m_viewDataListeners) {
            listener.rowUpdateCancelled();
        }
    }

    protected class DeleteRowUndoable
    extends WAUndoable {
        private List m_lRowValues;
        private int m_iRow;

        public DeleteRowUndoable(int iRow, List lRowValues) {
            this.m_iRow = iRow;
            this.m_lRowValues = lRowValues;
        }

        public void undo() {
            super.undo();
            ViewDataTable.this.cancelRowEditing();
            try {
                ViewDataTable.this.appendRowImpl(this.m_lRowValues);
                this.m_iRow = ViewDataTable.this.convertRowIndexToView(ViewDataTable.this.getViewDataModel().getRowCount() - 1);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowAppendError(e);
            }
        }

        public void redo() {
            super.redo();
            try {
                ViewDataTable.this.cancelRowEditing();
                ViewDataTable.this.getViewDataModel().deleteRow1(ViewDataTable.this.convertRowIndexToModel(this.m_iRow));
                if (this.m_iRow < ViewDataTable.this.getModel().getRowCount()) {
                    ViewDataTable.this.selectRow(this.m_iRow);
                } else if (ViewDataTable.this.getModel().getRowCount() > 0) {
                    ViewDataTable.this.selectRow(this.m_iRow - 1);
                }
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowDeleteError(e, this.m_iRow);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
        }
    }

    protected class AppendRowUndoable
    extends WAUndoable {
        private List m_lRowValues;
        private int m_iRow;

        public AppendRowUndoable(int iRow, List lRowValues) {
            this.m_iRow = iRow;
            this.m_lRowValues = lRowValues;
        }

        public void undo() {
            super.undo();
            ViewDataTable.this.cancelRowEditing();
            try {
                ViewDataTable.this.getViewDataModel().deleteRow1(ViewDataTable.this.convertRowIndexToModel(this.m_iRow));
                if (this.m_iRow < ViewDataTable.this.getModel().getRowCount()) {
                    ViewDataTable.this.selectRow(this.m_iRow);
                } else if (ViewDataTable.this.getModel().getRowCount() > 0) {
                    ViewDataTable.this.selectRow(this.m_iRow - 1);
                }
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowDeleteError(e, this.m_iRow);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
        }

        public void redo() {
            super.redo();
            ViewDataTable.this.cancelRowEditing();
            try {
                ViewDataTable.this.appendRowImpl(this.m_lRowValues);
                this.m_iRow = ViewDataTable.this.convertRowIndexToView(ViewDataTable.this.getViewDataModel().getRowCount() - 1);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowAppendError(e);
            }
        }
    }

    protected class SetRowValuesUndoable
    extends WAUndoable {
        private int m_iRow;
        private List m_lNewValues;
        private List m_lOldValues;

        public SetRowValuesUndoable(int iRow, List lNewValues, List lOldValues) {
            this.m_iRow = iRow;
            this.m_lNewValues = lNewValues;
            this.m_lOldValues = lOldValues;
        }

        public void undo() {
            super.undo();
            ViewDataTable.this.cancelRowEditing();
            try {
                ViewDataTable.this.getViewDataModel().setRowValues1(ViewDataTable.this.convertRowIndexToModel(this.m_iRow), this.m_lOldValues);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowSetValuesSQLError(e, this.m_iRow);
            }
        }

        public void redo() {
            super.redo();
            ViewDataTable.this.cancelRowEditing();
            try {
                ViewDataTable.this.getViewDataModel().setRowValues1(ViewDataTable.this.convertRowIndexToModel(this.m_iRow), this.m_lNewValues);
                ViewDataTable.this.selectRow(this.m_iRow);
            }
            catch (SQLException e) {
                ViewDataTable.this.handleSingleRowSetValuesSQLError(e, this.m_iRow);
            }
        }
    }

    class ViewDataTableClipBoardAdapter
    extends TableViewClipboardAdapter {
        public ViewDataTableClipBoardAdapter(TableView oTable) {
            super(oTable);
        }

        public void copySelectedCells() {
            TransformInterface transform = BaseTransforms.defaultInstance.lookupTransform(String.class, Date.class);
            if (transform != null) {
                BaseTransforms.defaultInstance.unregisterTransform(String.class, Date.class, transform);
            }
            try {
                super.copySelectedCells();
            }
            finally {
                if (transform != null) {
                    BaseTransforms.defaultInstance.registerTransform(String.class, Date.class, transform);
                }
            }
        }

        public void cutSelectedCells() {
            Workspace.getDefaultLogger().error((Object)"Cut not supported");
        }

        public void pasteSelectedCells() {
            if (!(ViewDataTable.this.isEditingInProgress() || ViewDataTableClipBoardAdapter.canPaste((TableView)this.table) && ViewDataTable.this.getSelectedCellCount() >= 1)) {
                return;
            }
            List pastedData = this.getPastedData();
            if (pastedData == null || pastedData.isEmpty()) {
                return;
            }
            TransformInterface transform = BaseTransforms.defaultInstance.lookupTransform(String.class, Date.class);
            if (transform != null) {
                BaseTransforms.defaultInstance.unregisterTransform(String.class, Date.class, transform);
            }
            try {
                ViewDataTable.this.onPasteData(pastedData);
            }
            finally {
                if (transform != null) {
                    BaseTransforms.defaultInstance.registerTransform(String.class, Date.class, transform);
                }
            }
        }

        protected void copyCellsToClipboard(boolean replace, String replaceString) {
            if (replace) {
                Workspace.getDefaultLogger().error((Object)"Cut not supported");
                return;
            }
            StringBuffer sbf = new StringBuffer();
            int rowCount = this.table.getRowCount();
            int colCount = this.table.getColumnCount();
            int numCells = this.table.getSelectedCellCount();
            int[][] cellsSelected = this.table.getSelectedCells();
            Class[] colClasses = new Class[colCount];
            for (int i = 0; i < colCount; ++i) {
                colClasses[i] = this.table.getModel().getColumnClass(i);
            }
            int x1 = cellsSelected[0][0];
            int y1 = cellsSelected[0][1];
            int x2 = cellsSelected[cellsSelected.length - 1][0];
            int y2 = cellsSelected[cellsSelected.length - 1][1];
            ListSelectionModel lsm = this.table.getSelectionModel();
            int min = lsm.getMinSelectionIndex();
            int max = lsm.getMaxSelectionIndex();
            if ((Math.abs(x2 - x1) + 1) * (Math.abs(y2 - y1) + 1) == numCells && lsm.isSelectedIndex(min) && lsm.isSelectedIndex(max)) {
                for (int i = 0; i < numCells; ++i) {
                    int x = cellsSelected[i][0];
                    int y = cellsSelected[i][1];
                    if (x >= rowCount || y >= colCount) continue;
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(x, y), y));
                    sbf.append(value);
                    if (replace) {
                        this.table.setValueAt((Object)replaceString, x, y);
                    }
                    if (i >= numCells - 1) continue;
                    if (x == cellsSelected[i + 1][0]) {
                        sbf.append("\t");
                        continue;
                    }
                    sbf.append("\n");
                }
            }
            this.stringSelection = new StringSelection(sbf.toString());
            ViewDataTableClipBoardAdapter.getClipboard().setContents(this.stringSelection, this.stringSelection);
        }

        protected String transform(Object value, int columnViewIndex) {
            if (!ViewDataTable.this.getViewDataModel().isEditable() && value instanceof String) {
                return value.toString();
            }
            int columnModelIndex = ViewDataTable.this.convertColumnIndexToModel(columnViewIndex);
            if ((value = ViewDataTable.this.getNullIfMissingValue(value)) == null) {
                return "";
            }
            String val = "";
            try {
                if (value instanceof Double) {
                    DecimalFormat decf = (DecimalFormat)DecimalFormat.getNumberInstance();
                    decf.setGroupingUsed(false);
                    decf.setMaximumFractionDigits(Integer.MAX_VALUE);
                    val = decf.format((Double)value);
                } else {
                    val = BaseTransforms.defaultInstance.isTransformable(String.class, ViewDataTable.this.getModel().getColumnClass(columnModelIndex)) ? BaseTransforms.defaultInstance.transform(value, ViewDataTable.this.getModel().getColumnClass(columnModelIndex)).toString() : (ViewDataTable.this.getModel().getColumnClass(columnModelIndex) == Date.class ? ViewDataTable.this.getDateFormat(columnModelIndex).format(value) : value.toString());
                }
            }
            catch (TransformException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            return val;
        }

        protected Object replaceNull(Object value) {
            if ((value = ViewDataTable.this.getNullIfMissingValue(value)) == null) {
                return super.replaceNull(value);
            }
            return value;
        }

        public void pasteSpecialSelectedCells() {
            if (!(ViewDataTable.this.isEditingInProgress() || ViewDataTableClipBoardAdapter.canPaste((TableView)this.table) && ViewDataTable.this.getSelectedCellCount() >= 1)) {
                return;
            }
            List pastedData = this.getPastedData();
            if (pastedData == null || pastedData.isEmpty()) {
                return;
            }
            TransformInterface transform = BaseTransforms.defaultInstance.lookupTransform(String.class, Date.class);
            if (transform != null) {
                BaseTransforms.defaultInstance.unregisterTransform(String.class, Date.class, transform);
            }
            try {
                ViewDataTable.this.onPasteSpecialData(pastedData);
            }
            finally {
                if (transform != null) {
                    BaseTransforms.defaultInstance.registerTransform(String.class, Date.class, transform);
                }
            }
        }

        protected List getPastedData() {
            try {
                Transferable transfer = ViewDataTableClipBoardAdapter.getClipboard().getContents((Object)this);
                if (transfer != null && transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                    return ViewDataTableClipBoardAdapter.parseContents((String)data);
                }
            }
            catch (UnsupportedFlavorException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (IOException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            return null;
        }
    }

    class ViewDataTableModelListener
    extends ViewDataModelAdapter {
        ViewDataTableModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("RowCount".equals(e.getPropertyName())) {
                if ((Integer)e.getNewValue() != -1) {
                    ViewDataTable.this.onRowCountKnown();
                }
            } else if ("ColumnDisplayLabel".equals(e.getPropertyName())) {
                ViewDataTable.this.updateColumnHeaderLabels();
            }
        }

        @Override
        public void fetchSuccessful() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataTable.this.onFetchSuccessful();
                }
            });
        }
    }

    class ViewDataTableRowHeaderRenderer
    extends DefaultRowHeaderRenderer {
        private final JButton m_newRowLabel = new JButton(ViewDataTable.access$000().getImageIcon("ViewDataTable.NewRow.image"));
        private final JButton m_editRowLabel = new JButton(ViewDataTable.access$000().getImageIcon("ViewDataTable.EditRow.image"));

        public ViewDataTableRowHeaderRenderer() {
            this.m_newRowLabel.setToolTipText(bundle.getString("ViewDataTable.NewRow.tip"));
            this.m_editRowLabel.setToolTipText(bundle.getString("ViewDataTable.EditRow.tip"));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean bIsSelected, boolean hasFocus, int row, int column) {
            if (!ViewDataTable.this.getViewDataModel().isEditable()) {
                return super.getTableCellRendererComponent(table, value, this.isSelected, hasFocus, row, column);
            }
            if (ViewDataTable.this.isNewRow(row)) {
                return this.m_newRowLabel;
            }
            if (ViewDataTable.this.isEditRow(row)) {
                return this.m_editRowLabel;
            }
            return super.getTableCellRendererComponent(table, value, this.isSelected, hasFocus, row, column);
        }
    }

    class ExtendedColumnHeaderRenderer
    extends WsDefaultTableColumnHeaderRenderer {
        private Icon m_iconType;

        ExtendedColumnHeaderRenderer() {
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (this.m_iconType != null) {
                dim.width += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            return dim;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            if (tbl.getModel().getColumnCount() < 1) {
                this.m_iconType = null;
            } else {
                String type = ((ViewDataModel)((Object)tbl.getModel())).getColumnSASType(tbl.convertColumnIndexToModel(iCol));
                this.m_iconType = WsColumnMetadataUtil.getColumnTypeIcon((String)type);
            }
            return super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
        }

        protected void paintComponent(Graphics g) {
            int y;
            String sText;
            FontMetrics fm;
            int cxText;
            int cxMaxText;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            Insets insets = this.getInsets();
            int cxComp = this.getWidth() - insets.left - insets.right;
            Icon iconRight = this.getIcon();
            int cxIconsAndGaps = 0;
            if (this.m_iconType != null) {
                cxIconsAndGaps += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            if (iconRight != null) {
                cxIconsAndGaps += iconRight.getIconWidth() + this.getIconTextGap();
            }
            if ((cxMaxText = cxComp - cxIconsAndGaps) < (cxText = SwingUtilities.computeStringWidth(fm = g.getFontMetrics(), sText = this.getText()))) {
                int iEnd = sText.length();
                while (cxMaxText < (cxText = fm.stringWidth(sText = sText.substring(0, --iEnd) + "...")) && iEnd > 2) {
                }
            }
            int cxSpace = cxComp - cxIconsAndGaps - cxText;
            int x = insets.left + cxSpace / 2;
            if (this.m_iconType != null) {
                y = (this.getHeight() - this.m_iconType.getIconHeight()) / 2;
                this.m_iconType.paintIcon((Component)((Object)this), g, x, y);
                x += this.m_iconType.getIconWidth() + this.getIconTextGap();
            }
            y = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            g.drawString(sText, x, y);
            if (iconRight != null) {
                y = (this.getHeight() - iconRight.getIconHeight()) / 2;
                iconRight.paintIcon((Component)((Object)this), g, x += cxText + this.getIconTextGap(), y);
            }
        }
    }

    class ViewDataTableColumnHeader
    extends WsDefaultTableColumnHeader {
        public ViewDataTableColumnHeader(TableColumnModel colModel) {
            super(colModel);
        }

        protected TableCellRenderer createDefaultRenderer() {
            return new ExtendedColumnHeaderRenderer();
        }
    }

    class ViewDataTablePopupListener
    extends WsTable.cDefaultTablePopupMenuRequestListener {
        ViewDataTablePopupListener() {
            super((WsTable)ViewDataTable.this);
        }

        public void popupMenuRequested(MouseEvent e) {
            if (ViewDataTable.this.m_tablePopup == null) {
                return;
            }
            ViewDataTable.this.m_tablePopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    class ViewDataTableSelectionListener
    implements ListSelectionListener {
        private boolean m_isAdjusting;

        ViewDataTableSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || this.isAdjusting() || ViewDataTable.this.getSelectedCellCount() != 1) {
                return;
            }
            try {
                this.setIsAdjusting(true);
                int selRow = ViewDataTable.this.getSelectedCells()[0][0];
                int selCol = ViewDataTable.this.getSelectedCells()[0][1];
                if (!ViewDataTable.this.isEditingInProgress()) {
                    if (!ViewDataTable.this.isNewRow(selRow)) {
                        return;
                    }
                    ViewDataTable.this.onEditAppendRowGesture(selCol);
                    return;
                }
                if (!ViewDataTable.this.isEditRow(selRow) && !ViewDataTable.this.m_isCommitting) {
                    int[][] selectedCells = ViewDataTable.this.getSelectedCells();
                    ViewDataTable.this.onCommitEditRowGesture();
                    if (!ViewDataTable.this.isNewRow(selRow)) {
                        if (selectedCells != null && selectedCells.length != 0) {
                            ViewDataTable.this.selectCell(selectedCells[0][0], selectedCells[0][1]);
                        }
                        return;
                    }
                    ViewDataTable.this.onEditAppendRowGesture(selCol);
                    return;
                }
                if (ViewDataTable.this.getSelectedCellCount() != 1) {
                    ViewDataTable.this.cancelCellEditing();
                }
            }
            finally {
                this.setIsAdjusting(false);
            }
        }

        protected void setIsAdjusting(boolean isAdjusting) {
            this.m_isAdjusting = isAdjusting;
        }

        protected boolean isAdjusting() {
            return this.m_isAdjusting;
        }
    }

    class ViewDataTableEscapeKeyHandler
    extends AbstractAction {
        ViewDataTableEscapeKeyHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewDataTable.this.isEditingInProgress()) {
                if (ViewDataTable.this.isEditing()) {
                    ViewDataTable.this.cancelCellEditing();
                } else {
                    ViewDataTable.this.cancelRowEditing();
                }
            }
        }
    }

    class ViewDataTableKeyListener
    extends KeyAdapter {
        ViewDataTableKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127 && ViewDataTable.this.getSelectedCellCount() > 0 && !ViewDataTable.this.isEditingInProgress()) {
                ViewDataTable.this.onDeleteKeyPressed();
            }
        }
    }

    class DeleteRowsCheckBoxOptionPane
    extends JOptionPane {
        private JCheckBox m_rememberDecision;
        private int m_rowsForDelete;

        public DeleteRowsCheckBoxOptionPane(int rowsForDelete) {
            this.m_rowsForDelete = rowsForDelete;
            this.setMessageType(2);
            this.setOptionType(0);
            this.initialize();
        }

        protected void initialize() {
            this.m_rememberDecision = new JCheckBox(bundle.getString("ViewDataTable.DeleteRowPromptRememberDecision.txt"));
            this.setMessage(new Object[]{bundle.formatString("ViewDataTable.DeleteRowConfirm.fmt.txt", (Object)new Integer(this.m_rowsForDelete)), this.m_rememberDecision});
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        protected boolean getRememberDecision() {
            return this.m_rememberDecision.isSelected();
        }
    }

    class MultiRowErrorPromptOptionPane
    extends JOptionPane {
        public static final int OPTION_CONTINUE = 1;
        public static final int OPTION_ABORT = 2;
        public static final int OPTION_SUPPRESS = 3;
        private String m_message;

        public MultiRowErrorPromptOptionPane(String sMessage) {
            Object[] aOptions = new String[]{bundle.getString("ViewDataTable.MultiRowErrorPromptContinue.txt"), bundle.getString("ViewDataTable.MultiRowErrorPromptAbort.txt"), bundle.getString("ViewDataTable.MultiRowErrorPromptSuppress.txt")};
            this.m_message = sMessage;
            this.setMessage(new String[]{this.m_message, bundle.getString("ViewDataTable.MultiRowErrorRowError.txt")});
            this.setMessageType(0);
            this.setOptions(aOptions);
            this.setInitialValue(bundle.getString("ViewDataTable.MultiRowErrorPromptAbort.txt"));
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 100;
        }

        public int getSelectedValue() {
            String sValue = (String)this.getValue();
            if (sValue == null) {
                return 2;
            }
            if (sValue.equals(bundle.getString("ViewDataTable.MultiRowErrorPromptContinue.txt"))) {
                return 1;
            }
            if (sValue.equals(bundle.getString("ViewDataTable.MultiRowErrorPromptAbort.txt"))) {
                return 2;
            }
            if (sValue.equals(bundle.getString("ViewDataTable.MultiRowErrorPromptSuppress.txt"))) {
                return 3;
            }
            return 2;
        }
    }
}

