/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.RSCursorMover;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.workspace.WAdminResource;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ViewDataScrollPane
extends JScrollPane {
    public ViewDataScrollPane(Component view) {
        super(view);
        this.init();
    }

    public ViewDataScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public ViewDataScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    protected void init() {
        LookAndFeel lnf = UIManager.getLookAndFeel();
        String lnfName = lnf.getName();
        if (lnfName.equals("Windows")) {
            WindowsScrollBarUIWithPromptInfo newUI = new WindowsScrollBarUIWithPromptInfo();
            this.getVerticalScrollBar().setUI(newUI);
        }
        ViewDataScrollPaneAdjustmentListener listener = new ViewDataScrollPaneAdjustmentListener();
        this.getVerticalScrollBar().addAdjustmentListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setWheelScrollingEnabled(enabled);
        this.getVerticalScrollBar().setEnabled(enabled);
        this.getHorizontalScrollBar().setEnabled(enabled);
    }

    @Override
    public JViewport createViewport() {
        return new ViewDataScrollPaneViewPort();
    }

    protected class WindowsScrollBarUIWithPromptInfo
    extends BasicScrollBarUI {
        protected WAdminResource bundle = WAdminResource.getBundle(WindowsScrollBarUIWithPromptInfo.class);
        private int m_iPreviousThumbY = 0;

        protected WindowsScrollBarUIWithPromptInfo() {
        }

        @Override
        protected BasicScrollBarUI.TrackListener createTrackListener() {
            TrackListenerWithOffset m_TrackListenerWithOffset = new TrackListenerWithOffset();
            return m_TrackListenerWithOffset;
        }

        protected class TrackListenerWithOffset
        extends BasicScrollBarUI.TrackListener {
            private MouseEvent m_LastDraggedEvent;
            private MouseEvent m_LastReleasedEvent;
            private MouseEvent m_CurDraggedEvent;

            protected TrackListenerWithOffset() {
                super(WindowsScrollBarUIWithPromptInfo.this);
                this.m_LastDraggedEvent = null;
                this.m_LastReleasedEvent = null;
                this.m_CurDraggedEvent = null;
            }

            private void setLastDraggedEvent(MouseEvent e) {
                this.m_LastDraggedEvent = e;
            }

            private MouseEvent getLastDraggedEvent() {
                MouseEvent e = this.m_LastDraggedEvent;
                this.m_LastDraggedEvent = null;
                return e;
            }

            private void setLastReleasedEvent(MouseEvent e) {
                this.m_LastReleasedEvent = e;
            }

            private MouseEvent getLastReleasedEvent() {
                MouseEvent e = this.m_LastReleasedEvent;
                this.m_LastReleasedEvent = null;
                return e;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ViewDataModel model = (ViewDataModel)((Object)((ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView())).getModel());
                if (model.isFetchDataRunning()) {
                    this.setLastReleasedEvent(e);
                } else {
                    super.mouseReleased(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ViewDataModel model = (ViewDataModel)((Object)((ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView())).getModel());
                if (model.isFetchDataRunning()) {
                    this.setLastReleasedEvent(null);
                    return;
                }
                if (!WindowsScrollBarUIWithPromptInfo.this.getThumbBounds().isEmpty()) {
                    WindowsScrollBarUIWithPromptInfo.this.m_iPreviousThumbY = ((WindowsScrollBarUIWithPromptInfo)WindowsScrollBarUIWithPromptInfo.this).getThumbBounds().y;
                }
                super.mousePressed(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) || !WindowsScrollBarUIWithPromptInfo.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                    return;
                }
                if (!WindowsScrollBarUIWithPromptInfo.this.scrollbar.isEnabled() || WindowsScrollBarUIWithPromptInfo.this.getThumbBounds().isEmpty()) {
                    return;
                }
                ViewDataTable table = (ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView());
                ViewDataModel model = (ViewDataModel)((Object)((ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView())).getModel());
                if (model.isFetchDataRunning()) {
                    this.setLastDraggedEvent(e);
                    this.setLastReleasedEvent(null);
                    return;
                }
                if (WindowsScrollBarUIWithPromptInfo.this.isDragging) {
                    this.m_CurDraggedEvent = e;
                    int max = WindowsScrollBarUIWithPromptInfo.this.scrollbar.getMaximum();
                    int rowCount = ((JTable)ViewDataScrollPane.this.getViewport().getView()).getRowCount();
                    int curValue = WindowsScrollBarUIWithPromptInfo.this.scrollbar.getValue();
                    int m_CurRow = (int)((double)curValue * (double)rowCount / (double)max);
                    int destValue = this.getDestValue(e);
                    int m_DestRow = (int)((double)destValue * (double)rowCount / (double)max);
                    boolean bContinue = true;
                    boolean bNeedDialog = model.getRSAbsoluteEstimator().needLongRunningDialog(m_CurRow, m_DestRow);
                    if (bNeedDialog) {
                        this.setLastReleasedEvent(e);
                        if (!CommonActionsFactory.GoToRowDelayCheckBoxOptionPane.doLongRunningOperation()) {
                            bContinue = false;
                        }
                    }
                    if (bContinue) {
                        boolean bNeedNewThread = model.getRSAbsoluteEstimator().needNewThread(m_CurRow, m_DestRow);
                        if (bNeedNewThread) {
                            ViewDataPanel vdp = (ViewDataPanel)((Object)ViewDataScrollPane.this.getParent());
                            vdp.getFactory().getDefaultToolBar().setEnabled(false);
                            table.setEnabled(false);
                            model.setFetchDataRunning(true);
                            vdp.updateTitle();
                            RSCursorMover cursorMover = new RSCursorMover(m_CurRow, m_DestRow, model){

                                @Override
                                protected void runInEventDispatchThread() {
                                    TrackListenerWithOffset.this.mouseDraggedAfterMovingCursor();
                                }
                            };
                            Thread thread = new Thread(cursorMover);
                            thread.start();
                        } else {
                            model.getRSAbsoluteEstimator().UpdateAbsolutingRSTime(m_CurRow, m_DestRow);
                            super.mouseDragged(e);
                            MouseEvent rme = this.getLastReleasedEvent();
                            if (rme != null) {
                                this.mouseReleased(rme);
                            }
                            WindowsScrollBarUIWithPromptInfo.this.m_iPreviousThumbY = ((WindowsScrollBarUIWithPromptInfo)WindowsScrollBarUIWithPromptInfo.this).getThumbBounds().y;
                        }
                    } else {
                        Rectangle rect = WindowsScrollBarUIWithPromptInfo.this.getThumbBounds();
                        WindowsScrollBarUIWithPromptInfo.this.setThumbBounds(rect.x, WindowsScrollBarUIWithPromptInfo.this.m_iPreviousThumbY, rect.width, rect.height);
                        MouseEvent rme = this.getLastReleasedEvent();
                        if (rme != null) {
                            this.mouseReleased(rme);
                        }
                    }
                }
            }

            public void mouseDraggedAfterMovingCursor() {
                ViewDataTable table = (ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView());
                ViewDataModel model = (ViewDataModel)((Object)((ViewDataTable)((Object)ViewDataScrollPane.this.getViewport().getView())).getModel());
                model.setFetchDataRunning(false);
                ViewDataPanel vdp = (ViewDataPanel)((Object)ViewDataScrollPane.this.getParent());
                vdp.getFactory().getDefaultToolBar().setEnabled(true);
                table.setEnabled(true);
                vdp.updateTitle();
                MouseEvent follwongEvent = this.getLastDraggedEvent();
                if (follwongEvent != null) {
                    this.mouseDragged(follwongEvent);
                } else {
                    super.mouseDragged(this.m_CurDraggedEvent);
                    WindowsScrollBarUIWithPromptInfo.this.m_iPreviousThumbY = ((WindowsScrollBarUIWithPromptInfo)WindowsScrollBarUIWithPromptInfo.this).getThumbBounds().y;
                    MouseEvent rme = this.getLastReleasedEvent();
                    if (rme != null) {
                        this.mouseReleased(rme);
                    }
                }
            }

            protected int getDestValue(MouseEvent e) {
                int destValue = -1;
                if (WindowsScrollBarUIWithPromptInfo.this.scrollbar.getOrientation() == 1) {
                    BoundedRangeModel model = WindowsScrollBarUIWithPromptInfo.this.scrollbar.getModel();
                    Rectangle thumbR = WindowsScrollBarUIWithPromptInfo.this.getThumbBounds();
                    int thumbMin = WindowsScrollBarUIWithPromptInfo.this.decrButton.getY() + WindowsScrollBarUIWithPromptInfo.this.decrButton.getHeight();
                    int thumbMax = WindowsScrollBarUIWithPromptInfo.this.incrButton.getY() - thumbR.height;
                    int thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                    if (thumbPos == thumbMax) {
                        if (WindowsScrollBarUIWithPromptInfo.this.scrollbar.getOrientation() == 1 || WindowsScrollBarUIWithPromptInfo.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                            destValue = model.getMaximum() - model.getExtent();
                        }
                    } else {
                        float valueMax = model.getMaximum() - model.getExtent();
                        float valueRange = valueMax - (float)model.getMinimum();
                        float thumbValue = thumbPos - thumbMin;
                        float thumbRange = thumbMax - thumbMin;
                        int value = WindowsScrollBarUIWithPromptInfo.this.scrollbar.getOrientation() == 1 || WindowsScrollBarUIWithPromptInfo.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                        destValue = value + model.getMinimum();
                    }
                }
                return destValue;
            }

            protected int adjustValue(int value) {
                JScrollPane scrollpane;
                JViewport viewport;
                Component view;
                int destValue = value;
                if (WindowsScrollBarUIWithPromptInfo.this.scrollbar.getParent() instanceof JScrollPane && (view = (viewport = (scrollpane = (JScrollPane)WindowsScrollBarUIWithPromptInfo.this.scrollbar.getParent()).getViewport()).getView()) instanceof JList) {
                    JList list = (JList)view;
                    Boolean val = UIManager.getBoolean(list, list.getLocale());
                    if (val == null || !(val instanceof Boolean)) {
                        val = false;
                    }
                    if (val.booleanValue()) {
                        int index;
                        Rectangle rect;
                        int adjustedValue = destValue;
                        int mode = list.getLayoutOrientation();
                        int orientation = WindowsScrollBarUIWithPromptInfo.this.scrollbar.getOrientation();
                        if (orientation == 1 && mode == 0 && (rect = list.getCellBounds(index = list.locationToIndex(new Point(0, destValue)), index)) != null) {
                            adjustedValue = rect.y;
                        }
                        destValue = adjustedValue;
                    }
                }
                return destValue;
            }
        }
    }

    protected class ViewDataScrollPaneAdjustmentListener
    implements AdjustmentListener {
        private final int MAX_ADJUSTMENT_ROWS = 10000;
        private final int MAX_ADJUSTMENT_TIME = 1000;
        private int m_lastRow = 0;
        private long m_lastTime = System.currentTimeMillis();
        private boolean adjusting = false;

        protected ViewDataScrollPaneAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (evt.getAdjustmentType() != 5 || evt.getValueIsAdjusting() || this.adjusting) {
                return;
            }
            long time = System.currentTimeMillis();
            Adjustable source = evt.getAdjustable();
            double scrollRatio = (double)source.getValue() / (double)source.getMaximum();
            int rowCount = ((JTable)ViewDataScrollPane.this.getViewport().getView()).getRowCount();
            int row = (int)((double)rowCount * scrollRatio);
            if (row > this.m_lastRow && row - this.m_lastRow > 10000 && time - this.m_lastTime <= 1000L) {
                this.adjusting = true;
                row = this.m_lastRow + 10000;
                source.setValue((int)((double)row / (double)rowCount));
                this.makeRowVisible((JTable)ViewDataScrollPane.this.getViewport().getView(), row);
                this.adjusting = false;
            }
            this.m_lastRow = row;
            this.m_lastTime = time;
        }

        protected void makeRowVisible(JTable table, int row) {
            Rectangle r = table.getCellRect(row, -1, true);
            Insets i = table.getInsets();
            r.x = i.left;
            r.width = table.getWidth() - i.left - i.right;
            int from = r.y;
            int to = r.y + r.height;
            Rectangle visible = table.getVisibleRect();
            if (visible.y <= from && visible.y + visible.height >= to) {
                return;
            }
            visible.y = from;
            visible.height = to - from;
            table.scrollRectToVisible(visible);
        }
    }

    protected class ViewDataScrollPaneViewPort
    extends JViewport {
        protected ViewDataScrollPaneViewPort() {
        }

        @Override
        public void scrollRectToVisible(Rectangle contentRect) {
            if (contentRect.y > this.getVisibleRect().y) {
                contentRect.y = (int)((double)contentRect.y + ((double)this.getHeight() - contentRect.getHeight()));
            }
            super.scrollRectToVisible(contentRect);
        }
    }
}

