/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.QueryOptionsDialog;
import com.sas.wadmin.viewdata2.SearchToolArea;
import com.sas.wadmin.viewdata2.ViewDataAbstractFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataScrollPane;
import com.sas.wadmin.viewdata2.event.QueryOptionsEventAdapter;
import com.sas.wadmin.viewdata2.event.SearchEventAdapter;
import com.sas.wadmin.viewdata2.event.SearchEventListener;
import com.sas.wadmin.viewdata2.event.ViewDataModelAdapter;
import com.sas.wadmin.viewdata2.event.ViewDataModelListener;
import com.sas.wadmin.viewdata2.event.ViewDataTableAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsPopupMenuRequestListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public abstract class ViewDataPanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataPanel.class);
    public static final String PROPERTY_DISPLAY_TITLE = "DisplayTitle";
    private ViewDataAbstractFactory m_factory;
    private boolean m_initializationRunning = false;
    private boolean m_isActive = false;
    private boolean m_showToolBar = true;
    private boolean m_hasErrors = false;
    protected WsAppServer m_appServer;
    private WAPropertyFrame m_parentFrame;

    protected ViewDataModelListener getModelListener() {
        return new ViewDataPanelModelListener();
    }

    protected SearchEventListener getSearchListener() {
        return new ViewDataPanelSearchListener();
    }

    protected QueryOptionsListener getQueryOptionsListener() {
        return new QueryOptionsListener();
    }

    protected TableRowHeaderPopupMenuRequestListener getTableRowHeaderPopupListener() {
        return new TableRowHeaderPopupMenuRequestListener();
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            this.cleanUp();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayDetailsMessage((String)bundle.getString("PhysicalTablePanel.ErrorLoadingData.txt"), (int)0, (String)e.getMessage());
            return;
        }
        this.loadPanel();
    }

    public void loadPanel() {
        this.m_initializationRunning = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setHasErrors(false);
        this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data");
        new Thread(){

            @Override
            public void run() {
                ViewDataPanel.this.initializeImpl();
            }
        }.start();
    }

    protected void initializeImpl() {
        try {
            if (!this.isFromClosingFrame()) {
                if (this.getFactory() == null) {
                    this.setFactory(this.createFactory());
                }
                this.getFactory().createDefaultModel();
            }
            if (!this.isFromClosingFrame()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ViewDataPanel.this.initModel();
                            ViewDataPanel.this.getFactory().getDefaultModel().setViewDataPanel(ViewDataPanel.this);
                            ViewDataPanel.this.getFactory().createDefaultTable();
                            ViewDataPanel.this.initTable();
                            ViewDataPanel.this.getFactory().createDefaultSearchToolArea();
                            ViewDataPanel.this.initSearchToolArea();
                            if (ViewDataPanel.this.getFactory().getDefaultModel().isSortable() && ViewDataPanel.this.getFactory().getDefaultModel().isFilterable() && ViewDataPanel.this.getFactory().getDefaultModel().isSubsetable()) {
                                ViewDataPanel.this.getFactory().createDefaultQueryOptionsDialog();
                                ViewDataPanel.this.initQueryOptionsDialog();
                            }
                            if (ViewDataPanel.this.m_showToolBar) {
                                ViewDataPanel.this.getFactory().createDefaultToolBar();
                            }
                            ViewDataPanel.this.getFactory().addAccelerators(ViewDataPanel.this);
                            ViewDataPanel.this.layoutWidgets();
                            ViewDataPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            if (!ViewDataPanel.this.isFromClosingFrame()) {
                                ViewDataPanel.this.getFactory().getDefaultModel().fetchData();
                            }
                        }
                        catch (ViewDataException e) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                            if (!ViewDataPanel.this.isFromClosingFrame()) {
                                MessageUtil.displayDetailsMessage((String)bundle.getString("ViewDataPanel.ErrorInitializing.txt"), (int)0, (String)e.getMessage());
                                ViewDataPanel.this.setHasErrors(true);
                            }
                        }
                        catch (MdException e) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                            ViewDataPanel.this.setHasErrors(true);
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                    }
                });
            }
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            if (!this.isFromClosingFrame()) {
                this.setHasErrors(true);
                MessageUtil.displayDetailsMessage((String)bundle.getString("ViewDataPanel.ErrorInitializing.txt"), (int)0, (String)e.getMessage());
            }
        }
        catch (InterruptedException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        finally {
            if (this.hasErrors()) {
                try {
                    this.cleanUp();
                }
                catch (ViewDataException e) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                }
                this.setCursor(Cursor.getDefaultCursor());
                this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
            }
            this.m_initializationRunning = false;
            if (this.isFromClosingFrame()) {
                this.closeParentFrame();
            }
        }
    }

    protected void initModel() throws MdException, RemoteException {
        this.getFactory().getDefaultModel().addViewDataModelListener(this.getModelListener());
        this.getFactory().getDefaultModel().populateStore();
        this.getFactory().getDefaultModel().moveDataToModel();
    }

    protected void initTable() throws ViewDataException {
        this.getFactory().getDefaultTable().setPopupMenu(this.getFactory().createDefaultTablePopupMenu());
        this.getFactory().getDefaultTable().setRowHeaderPopupMenuRequestListener(this.getTableRowHeaderPopupListener());
        this.getFactory().getDefaultTable().addViewDataTableListener(new ViewDataPanelTableListener());
        this.getFactory().getDefaultTable().setSortingEnabled(this.getFactory().createDefaultModel().isSortable());
    }

    protected void initSearchToolArea() throws ViewDataException {
        this.getFactory().getDefaultSearchToolArea().addSearchEventListener(this.getSearchListener());
        this.getFactory().getDefaultSearchToolArea().setVisible(false);
    }

    protected void initQueryOptionsDialog() throws ViewDataException {
        this.getFactory().getDefaultQueryOptionsDialog().addQueryOptionsEventListener(this.getQueryOptionsListener());
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        if (this.getFactory().hasDefaultToolBar()) {
            this.add(this.getFactory().getDefaultToolBar(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        }
        this.add(this.getFactory().getDefaultSearchToolArea(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new ViewDataScrollPane((Component)((Object)this.getFactory().getDefaultTable()), 22, 30), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_isActive = bActive;
        if (this.getFactory() != null && this.getFactory().hasDefaultToolBar()) {
            this.getFactory().getDefaultToolBar().setActive(bActive);
        }
    }

    public WAPropertyFrame getParentFrame() {
        if (this.m_parentFrame == null) {
            JInternalFrame[] frames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
            block0: for (int i = 0; i < frames.length; ++i) {
                JInternalFrame frame = frames[i];
                if (!(frame instanceof WAPropertyFrame)) continue;
                Component[] cps = frame.getContentPane().getComponents();
                for (int k = 0; k < cps.length; ++k) {
                    if (cps[k] != this) continue;
                    this.m_parentFrame = (WAPropertyFrame)frame;
                    continue block0;
                }
            }
        }
        return this.m_parentFrame;
    }

    public void closeParentFrame() {
        WAPropertyFrame frame = this.getParentFrame();
        if (frame != null) {
            class FrameClosingDelayer
            implements Runnable {
                WAPropertyFrame m_Frame = null;

                public FrameClosingDelayer(WAPropertyFrame frame) {
                    this.m_Frame = frame;
                }

                @Override
                public void run() {
                    ViewDataModel model;
                    ViewDataAbstractFactory factory = ViewDataPanel.this.getFactory();
                    ViewDataModel viewDataModel = model = factory != null ? factory.getDefaultModel() : null;
                    if (!(ViewDataPanel.this.m_initializationRunning || factory != null && !factory.isFactoryDisposable() || model != null && (model == null || model.isFetchDataRunning()))) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (m_Frame != null) {
                                    m_Frame.doDefaultCloseAction();
                                }
                            }
                        });
                    }
                }
            }
            Thread thread = new Thread(new FrameClosingDelayer(frame));
            thread.start();
        }
    }

    protected void setClosingFrameStatus() {
        WAPropertyFrame frame = this.getParentFrame();
        if (frame != null) {
            this.updateTitle();
            this.setEnabled(false);
        }
    }

    public boolean isFromClosingFrame() {
        boolean result = false;
        WAPropertyFrame frame = this.getParentFrame();
        if (frame != null) {
            if (frame.isFromClosingApplication()) {
                frame.setIsFromClosingApplication(false);
                result = false;
            } else if (frame.isFromClosingFrame()) {
                result = true;
            }
        }
        return result;
    }

    public boolean canClose() {
        SearchToolArea searchToolArea;
        ViewDataModel model;
        if (this.m_initializationRunning) {
            if (this.isFromClosingFrame()) {
                this.setClosingFrameStatus();
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.WarningLoadingInProgress.txt"));
            }
            return false;
        }
        if (this.getFactory() == null) {
            return true;
        }
        ViewDataModel viewDataModel = model = this.getFactory().hasDefaultModel() ? this.getFactory().getDefaultModel() : null;
        if (this.m_initializationRunning || !this.getFactory().isFactoryDisposable() || model != null && model.isFetchDataRunning()) {
            if (this.isFromClosingFrame()) {
                this.setClosingFrameStatus();
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.WarningLoadingInProgress.txt"));
            }
            return false;
        }
        SearchToolArea searchToolArea2 = searchToolArea = this.getFactory().hasDefaultSearchToolArea() ? this.getFactory().getDefaultSearchToolArea() : null;
        if (searchToolArea != null && searchToolArea.isSearchInProgress()) {
            MessageUtil.displayMessage((String)bundle.getString("ViewDataPanel.WarningSearchInProgress.txt"));
            return false;
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        try {
            this.cleanUp();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayDetailsMessage((String)bundle.getString("ViewDataPanel.ErrorCleaningUp.txt"), (int)0, (String)e.getMessage());
        }
        super.saveSettingsAndCleanUp();
    }

    protected void cleanUp() throws ViewDataException {
        if (this.getFactory() != null) {
            this.getFactory().dispose();
        }
        this.removeAll();
        this.setFactory(null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getFactory() == null) {
            return;
        }
        if (this.getFactory().hasDefaultTable()) {
            this.getFactory().getDefaultTable().setEnabled(enabled);
            this.getFactory().getDefaultTable().getScrollPane().setEnabled(enabled);
        }
        if (this.getFactory().hasDefaultToolBar()) {
            this.getFactory().getDefaultToolBar().setEnabled(enabled);
            this.getFactory().getDefaultToolBar().setActive(this.m_isActive);
        }
        if (this.getFactory().hasDefaultSearchToolArea()) {
            this.getFactory().getDefaultSearchToolArea().setEnabled(enabled);
        }
        if (this.getFactory().hasDefaultQueryOptionsDialog()) {
            this.getFactory().getDefaultQueryOptionsDialog().setEnabled(enabled);
        }
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.getFactory() == null) {
            return;
        }
        if (this.getFactory().hasDefaultTable()) {
            this.getFactory().getDefaultTable().setCursor(cursor);
            if (this.getFactory().getDefaultTable().getScrollPane() != null) {
                this.getFactory().getDefaultTable().getScrollPane().setCursor(cursor);
            }
        }
        if (this.getFactory().hasDefaultToolBar()) {
            this.getFactory().getDefaultToolBar().setCursor(cursor);
        }
        if (this.getFactory().hasDefaultSearchToolArea()) {
            this.getFactory().getDefaultSearchToolArea().setCursor(cursor);
        }
    }

    protected void onFetchStarted() {
        this.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
    }

    protected void updateTitle() {
        this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
    }

    protected void onFetchSuccessful() {
        if (!this.isFromClosingFrame()) {
            this.setHasErrors(false);
            this.setEnabled(true);
        }
    }

    protected void onFetchError(String msg, ViewDataException e) {
        Workspace.getDefaultLogger().warn((Object)msg);
        if (!this.isFromClosingFrame()) {
            this.setHasErrors(true);
            this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
            this.setEnabled(false);
        }
    }

    protected void onFetchComplete() {
        if (!this.isFromClosingFrame()) {
            this.setCursor(Cursor.getDefaultCursor());
            this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
            if (this.getFactory().hasDefaultSearchToolArea()) {
                this.getFactory().getDefaultSearchToolArea().reset();
            }
        }
    }

    protected void onSearchStarted() {
        this.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
    }

    protected void onSearchEnded() {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.firePropertyChange(PROPERTY_DISPLAY_TITLE, null, null);
    }

    protected void onMatchFound(int row, int col) {
        try {
            this.getFactory().getDefaultModel().peek(row);
            this.getFactory().getDefaultTable().gotoCell(this.getFactory().getDefaultTable().convertRowIndexToView(row), this.getFactory().getDefaultTable().convertColumnIndexToView(col));
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMessage((String)bundle.formatString("ViewDataPanel.SearchError.fmt.txt", (Object)e.getMessage()), (int)0);
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMessage((String)bundle.formatString("ViewDataPanel.SearchError.fmt.txt", (Object)e.getMessage()), (int)0);
        }
    }

    protected void onNoMatchFound(String s) {
        MessageUtil.displayMessage((String)bundle.formatString("SearchToolArea.Warning.NoMatch.fmt.txt", (Object)s), (int)1);
    }

    protected void onSearchError(ViewDataException e) {
        MessageUtil.displayMessage((String)bundle.formatString("ViewDataPanel.SearchError.fmt.txt", (Object)e.getMessage()), (int)0);
    }

    protected void onQueryOptionsChanged() {
        try {
            QueryOptionsDialog queryOptions = this.getFactory().createDefaultQueryOptionsDialog();
            if (queryOptions == null) {
                return;
            }
            ViewDataModel model = this.getFactory().createDefaultModel();
            ArrayList sortColumns = queryOptions.getSortByColumns();
            int[] sortIndices = new int[sortColumns.size()];
            ViewDataModel.SortDirection[] sortDirections = new ViewDataModel.SortDirection[sortColumns.size()];
            for (int i = 0; i < sortColumns.size(); ++i) {
                Object[] row = (Object[])sortColumns.get(i);
                sortIndices[i] = (Integer)row[0];
                sortDirections[i] = (ViewDataModel.SortDirection)row[1];
            }
            model.setFilter(queryOptions.getFilter());
            model.setSortedColumns(sortIndices, sortDirections);
            model.setDisplayColumns(queryOptions.getDisplayColumns());
            model.fetchData();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayDetailsMessage((String)bundle.getString("ViewDataPanel.ErrorApplyingQueryOptions.txt"), (int)0, (String)e.getMessage());
        }
    }

    public String getDisplayTitle() {
        if (this.getFactory() == null && this.hasErrors()) {
            return bundle.getString("ViewDataPanel.TitleError.txt");
        }
        if (this.getFactory() != null && this.hasErrors()) {
            return bundle.formatString("ViewDataPanel.TitleError.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName());
        }
        if (this.isFromClosingFrame()) {
            String tableName = null;
            if (this.getFactory() != null && this.getFactory().getDefaultModel() != null) {
                tableName = this.getFactory().getDefaultModel().getTableDisplayName();
            }
            if (tableName == null) {
                tableName = "";
            }
            return bundle.formatString("ViewDataPanel.TitleWaitForClosing.txt", (Object)tableName);
        }
        if (this.getFactory() == null || !this.getFactory().hasDefaultModel() || this.getFactory().hasDefaultModel() && this.getFactory().getDefaultModel().isFetchDataRunning()) {
            return bundle.getString("ViewDataPanel.TitleLoading.txt");
        }
        if (this.getFactory().hasDefaultSearchToolArea() && this.getFactory().getDefaultSearchToolArea().isSearchInProgress()) {
            return bundle.formatString("ViewDataPanel.TitleSearching.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName());
        }
        boolean bShowRowLimitInfo = false;
        if (this.getFactory().getDefaultModel().isRowCountKnown()) {
            int curRowCount = this.getFactory().getDefaultModel().getRowCount();
            int rowLimit = this.getFactory().getDefaultModel().getRowLimit();
            bShowRowLimitInfo = rowLimit > 0 && rowLimit == curRowCount;
        }
        if (this.getFactory().getDefaultModel().isRowCountKnown()) {
            String str = null;
            str = !bShowRowLimitInfo ? bundle.formatString("ViewDataPanel.TitleRowCountKnown.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName(), (Object)new Integer(this.getFactory().getDefaultModel().getRowCount())) : bundle.formatString("ViewDataPanel.TitleRowCountKnownWithRowLimitInfo.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName(), (Object)new Integer(this.getFactory().getDefaultModel().getRowCount()));
            return str;
        }
        if (this.getFactory().getDefaultModel().hasFilter()) {
            return bundle.formatString("ViewDataPanel.TitleFilter.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName(), (Object)new Integer(this.getFactory().getDefaultModel().getRowCount()));
        }
        return bundle.formatString("ViewDataPanel.TitleRowCountUnknown.fmt.txt", (Object)this.getFactory().getDefaultModel().getTableDisplayName());
    }

    public void setToolBarShowing(boolean show) {
        this.m_showToolBar = show;
        if (this.getFactory() != null && this.getFactory().hasDefaultToolBar() && this.getFactory().getDefaultToolBar().isVisible() != show) {
            this.getFactory().getDefaultToolBar().setVisible(show);
        }
    }

    public boolean isToolBarShowing() {
        return this.m_showToolBar;
    }

    protected boolean hasErrors() {
        return this.m_hasErrors;
    }

    protected void setHasErrors(boolean hasErrors) {
        this.m_hasErrors = hasErrors;
    }

    protected ViewDataAbstractFactory getFactory() {
        return this.m_factory;
    }

    protected void setFactory(ViewDataAbstractFactory factory) {
        this.m_factory = factory;
    }

    protected abstract ViewDataAbstractFactory createFactory() throws ViewDataException;

    class QueryOptionsListener
    extends QueryOptionsEventAdapter {
        QueryOptionsListener() {
        }

        @Override
        public void queryOptionsChanged() {
            ViewDataPanel.this.onQueryOptionsChanged();
        }
    }

    class ViewDataPanelSearchListener
    extends SearchEventAdapter {
        ViewDataPanelSearchListener() {
        }

        @Override
        public void searchStarting() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onSearchStarted();
                }
            });
        }

        @Override
        public void searchEnded() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onSearchEnded();
                }
            });
        }

        @Override
        public void matchFound(final int row, final int col) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onMatchFound(row, col);
                }
            });
        }

        @Override
        public void noMatchFound(final String s) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onNoMatchFound(s);
                }
            });
        }

        @Override
        public void searchError(final ViewDataException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onSearchError(e);
                }
            });
        }
    }

    class ViewDataPanelTableListener
    extends ViewDataTableAdapter {
        ViewDataPanelTableListener() {
        }

        @Override
        public void rowUpdateStarted(int row, boolean isAppendRow) {
            this.enableControls(false);
        }

        @Override
        public void rowUpdateEnded() {
            this.enableControls(true);
        }

        @Override
        public void rowUpdateCancelled() {
            this.enableControls(true);
        }

        protected void enableControls(boolean enable) {
            if (ViewDataPanel.this.getFactory().hasDefaultToolBar()) {
                ViewDataPanel.this.getFactory().getDefaultToolBar().setEnabled(enable);
            }
            if (ViewDataPanel.this.getFactory().hasDefaultSearchToolArea()) {
                ViewDataPanel.this.getFactory().getDefaultSearchToolArea().setEnabled(enable);
            }
            if (ViewDataPanel.this.getFactory().hasDefaultQueryOptionsDialog()) {
                ViewDataPanel.this.getFactory().getDefaultQueryOptionsDialog().setEnabled(enable);
            }
        }
    }

    class ViewDataPanelModelListener
    extends ViewDataModelAdapter {
        ViewDataPanelModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!"RowCount".equals(e.getPropertyName())) {
                return;
            }
            if ((Integer)e.getNewValue() != -1) {
                ViewDataPanel.this.firePropertyChange(ViewDataPanel.PROPERTY_DISPLAY_TITLE, null, null);
            }
        }

        @Override
        public void fetchStarted() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onFetchStarted();
                }
            });
        }

        @Override
        public void fetchSuccessful() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onFetchSuccessful();
                }
            });
        }

        @Override
        public void fetchError(final String msg, final ViewDataException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onFetchError(msg, e);
                }
            });
        }

        @Override
        public void fetchComplete() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewDataPanel.this.onFetchComplete();
                }
            });
        }
    }

    class TableRowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        TableRowHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            try {
                JPopupMenu mnuPopup = ViewDataPanel.this.getFactory().createDefaultTableRowHeaderPopup();
                if (mnuPopup != null) {
                    mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
            catch (ViewDataException e1) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e1);
            }
        }
    }
}

