/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.wadmin.viewdata2.SearchComparable;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataUtil;
import com.sas.wadmin.viewdata2.event.SearchEventAdapter;
import com.sas.wadmin.viewdata2.event.SearchEventListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsCheckBoxScrollPane;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchToolArea
extends JToolBar {
    private static WAdminResource bundle = WAdminResource.getBundle(SearchToolArea.class);
    protected static final String SEARCH_STRINGS_KEY = "ViewData.SearchString.";
    protected static final int SEARCH_DIRECTION_UP = 1;
    protected static final int SEARCH_DIRECTION_DOWN = 2;
    public static final String PROPERTY_SEARCH_COLUMN_LIST = "SearchColumnList";
    public static final String PROPERTY_MATCH_TYPE = "MatchType";
    public static final String PROPERTY_MATCH_CASE = "MatchCase";
    public static final String PROPERTY_TRIM_LEADING_SPACES = "TrimLeadingSpaces";
    public static final String PROPERTY_TRIM_TRAILING_SPACES = "TrimTrailingSpaces";
    private WAComboBox m_cmbSearchText;
    private PopupMenuButton m_inColumnsMenu;
    private WAComboBox m_cmbColumns;
    private JToolBar m_searchButtonPanel;
    private JButton m_btnOptions;
    private JButton m_btnClose;
    private ViewDataTable m_table;
    private int[] m_searchColumns;
    private SearchComparable.MatchType m_matchType = SearchComparable.MatchType.MATCH_CONTAINS;
    private boolean m_matchCase = false;
    private boolean m_trimLeadingSpaces = false;
    private boolean m_trimTrailingSpaces = true;
    private int m_currentSearchDirection = -1;
    private ArrayList m_searchEventListeners;
    private boolean m_columnListAdjusting;
    private boolean m_searchInProgress = false;
    private boolean m_stopSearch = false;
    private byte[] mutex = new byte[0];

    public SearchToolArea(ViewDataTable table) {
        this.m_table = table;
        this.setFloatable(false);
        this.setRollover(true);
        this.initialize();
        this.layoutWidgets();
        this.moveDataToView();
    }

    private void initialize() {
        this.m_cmbSearchText = new WAComboBox();
        this.m_cmbSearchText.setEditable(true);
        this.m_cmbSearchText.setMinimumSize(new Dimension(175, 20));
        this.m_cmbSearchText.setPreferredSize(new Dimension(175, 20));
        this.m_cmbSearchText.setBorder((Border)new LineBorder(SystemColor.controlDkShadow, 1));
        this.m_cmbSearchText.getEditor().addActionListener((ActionListener)((Object)new SearchComboEditorAction()));
        this.m_inColumnsMenu = new PopupMenuButton(bundle.getString("SearchToolArea.InColumns.txt"), new InColumnsPopupMenu(), 1);
        this.m_inColumnsMenu.addFocusListener(WsUIUtilities.BUTTON_FOCUS_LISTENER);
        this.m_cmbColumns = new WAComboBox();
        this.m_cmbColumns.setEditable(true);
        this.m_cmbColumns.setMinimumSize(new Dimension(175, 20));
        this.m_cmbColumns.setPreferredSize(new Dimension(175, 20));
        this.m_cmbColumns.setBorder((Border)new LineBorder(SystemColor.controlDkShadow, 1));
        this.m_cmbColumns.addItemListener((ItemListener)new InColumnsComboItemListener());
        this.m_cmbColumns.getEditor().addActionListener((ActionListener)((Object)new SearchComboEditorAction()));
        this.m_searchButtonPanel = new SearchButtonPanel();
        WsDropMenuAction actOptions = new WsDropMenuAction(bundle, "SearchToolArea.Options", 16);
        actOptions.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("OptionsDropMenu"));
        actOptions.setDropMenu((JPopupMenu)new OptionsPopupMenu());
        this.m_btnOptions = WsUIUtilities.createDropMenuButton((WsDropMenuAction)actOptions);
        this.m_btnClose = WsUIUtilities.createFlatToolButton((WsAbstractAction)new CloseAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "SearchAgain");
        this.getActionMap().put("SearchAgain", (Action)((Object)new SearchAgainAction()));
        this.setLayout(new GridBagLayout());
        SearchAreaKeyListener keyListener = new SearchAreaKeyListener();
        this.addKeyListener(keyListener);
        this.m_cmbSearchText.addKeyListener((KeyListener)keyListener);
        this.addPropertyChangeListener(new ColumnListChangedListener());
    }

    private void layoutWidgets() {
        JLabel lblSearchText = new JLabel(bundle.getString("SearchToolArea.SearchTextLabel.txt"));
        lblSearchText.setLabelFor((Component)this.m_cmbSearchText);
        lblSearchText.setDisplayedMnemonic(bundle.getString("SearchToolArea.SearchTextLabel.mnem").charAt(0));
        this.add((Component)lblSearchText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 3, 5), 0, 0));
        this.add((Component)this.m_cmbSearchText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)this.m_inColumnsMenu, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)this.m_cmbColumns, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)this.m_searchButtonPanel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)this.m_btnOptions, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
        this.add((Component)this.m_btnClose, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 5), 0, 0));
    }

    public void moveDataToView() {
        this.loadSearchStringsFromAppDefaultsFile();
    }

    public void moveDataToStore() {
        this.saveSearchStringToAppDefaultsFile();
    }

    public void saveSettingsAndCleanUp() {
        this.close();
        this.getInputMap(2).remove(KeyStroke.getKeyStroke(114, 0));
        this.getActionMap().remove("SearchAgain");
        this.getInputMap(2).remove(KeyStroke.getKeyStroke(27, 0));
        this.getActionMap().remove("Close");
    }

    public void reset() {
        this.clearSearchColumnList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_cmbSearchText.setEnabled(enabled);
        this.m_inColumnsMenu.setEnabled(enabled);
        this.m_cmbColumns.setEnabled(enabled);
        this.m_searchButtonPanel.setEnabled(enabled);
        this.m_btnOptions.setEnabled(enabled);
        this.m_btnClose.setEnabled(enabled);
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.getActionMap().put("Close", this.m_btnClose.getAction());
        super.setVisible(aFlag);
    }

    public void stopSearch() {
        this.onStopSearch();
    }

    protected int[] find(Comparable c, int[] columns) throws SQLException {
        return this.find(c, columns, 2);
    }

    protected int[] find(Comparable c, int[] columns, int direction) throws SQLException {
        int startRow = this.m_table.getCurrentRow();
        if (startRow >= 0) {
            return this.find(c, columns, direction, startRow, columns[0]);
        }
        return new int[]{-1, -1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] find(Comparable c, int[] columns, int direction, int row, int column) throws SQLException {
        TransformInterface transform = BaseTransforms.defaultInstance.lookupTransform(String.class, Date.class);
        if (transform != null) {
            BaseTransforms.defaultInstance.unregisterTransform(String.class, Date.class, transform);
        }
        try {
            int[] temp = this.getClosestSearchableCell(row, column, direction);
            row = temp[0];
            column = temp[1];
            if (row < 0) {
                int[] nArray = new int[]{-1, -1};
                return nArray;
            }
            int startColIndex = -1;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != column) continue;
                startColIndex = i;
                break;
            }
            if (startColIndex == -1) {
                int[] i = new int[]{-1, -1};
                return i;
            }
            ResultSet resultSet = this.getModel().getDataManager().getResultSet();
            while (!this.m_stopSearch && resultSet.absolute(row + 1)) {
                Object o;
                int i;
                if (direction == 2) {
                    for (i = startColIndex; i < columns.length; ++i) {
                        if (this.m_stopSearch) {
                            int[] nArray = new int[]{-1, -1};
                            return nArray;
                        }
                        o = SearchToolArea.getResultSetObject(resultSet, columns[i], this.m_table);
                        if (c.compareTo(this.transform(o, i)) != 0) continue;
                        int[] nArray = new int[]{row, columns[i]};
                        return nArray;
                    }
                    ++row;
                    startColIndex = 0;
                    continue;
                }
                for (i = startColIndex; i >= 0; --i) {
                    if (this.m_stopSearch) {
                        o = new int[]{-1, -1};
                        return o;
                    }
                    o = SearchToolArea.getResultSetObject(resultSet, columns[i], this.m_table);
                    if (c.compareTo(this.transform(o, i)) != 0) continue;
                    int[] nArray = new int[]{row, columns[i]};
                    return nArray;
                }
                if (--row < 0) break;
                startColIndex = columns.length - 1;
            }
            int[] nArray = new int[]{-1, -1};
            return nArray;
        }
        finally {
            if (transform != null) {
                BaseTransforms.defaultInstance.registerTransform(String.class, Date.class, transform);
            }
        }
    }

    private static Object getResultSetObject(ResultSet tResultSet, int tColumn, ViewDataTable tTable) throws SQLException {
        Object o = tResultSet.getObject(tColumn + 1);
        if (o != null && o instanceof String) {
            int tempColumn = tTable.convertColumnIndexToModel(tColumn);
            String type = tTable.getViewDataModel().getColumnSASType(tempColumn);
            if (!type.equals("C")) {
                o = ((String)o).trim();
            }
        }
        return o;
    }

    protected int[] getClosestSearchableCell(int row, int col, int direction) {
        int colViewIndex = this.m_table.convertColumnIndexToView(col);
        int[] cols = this.getSearchableColumnsInViewOrder();
        if (cols == null || cols.length == 0) {
            return new int[]{-1, -1};
        }
        for (int i = 0; i < cols.length; ++i) {
            if (direction == 2) {
                if (this.m_table.convertColumnIndexToView(cols[i]) <= colViewIndex) continue;
                return new int[]{row, cols[i]};
            }
            if (this.m_table.convertColumnIndexToView(cols[cols.length - i - 1]) >= colViewIndex) continue;
            return new int[]{row, cols[cols.length - i - 1]};
        }
        if (direction == 2) {
            return new int[]{++row, cols[0]};
        }
        return new int[]{--row, cols[cols.length - 1]};
    }

    protected String transform(Object value, int col) {
        if (value == null) {
            return "";
        }
        String val = "";
        try {
            if (value instanceof Double) {
                DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
                df.setGroupingUsed(false);
                df.setMaximumFractionDigits(Integer.MAX_VALUE);
                val = df.format((Double)value);
            } else {
                val = BaseTransforms.defaultInstance.isTransformable(String.class, this.getModel().getColumnClass(col)) ? BaseTransforms.defaultInstance.transform(value, this.getModel().getColumnClass(col)).toString() : (this.getModel().getColumnClass(col) == Date.class ? this.getDateFormat(col).format(value) : value.toString());
            }
        }
        catch (TransformException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return val;
    }

    protected DateFormat getDateFormat(int col) {
        return ((WsDateTableColumn)this.getModel().getColumn(col)).getDateFormat();
    }

    protected void onNext() {
        this.m_currentSearchDirection = 2;
        this.handleSearch(this.m_currentSearchDirection);
    }

    protected void onPrevious() {
        this.m_currentSearchDirection = 1;
        this.handleSearch(this.m_currentSearchDirection);
    }

    protected void handleSearch(final int direction) {
        this.saveSearchStringToAppDefaultsFile();
        this.addColumnsListToColumnsCombo();
        int[] cell = new int[]{0, 0};
        if (this.m_table.getSelectedCellCount() > 0) {
            cell = this.m_table.getSelectedCells()[0];
        }
        final int currentRow = this.m_table.convertRowIndexToModel(cell[0]);
        final int currentCol = this.m_table.convertColumnIndexToModel(cell[1]);
        this.m_stopSearch = false;
        this.m_searchInProgress = true;
        this.fireSearchStarting();
        new Thread(){

            @Override
            public void run() {
                try {
                    int[] match = SearchToolArea.this.find(SearchToolArea.this.getSearchComparable(), SearchToolArea.this.getSearchableColumnsInViewOrder(), direction, currentRow, currentCol);
                    if (match[0] == -1) {
                        if (SearchToolArea.this.m_stopSearch) {
                            SearchToolArea.this.fireSearchCancelled();
                        } else {
                            SearchToolArea.this.fireNoMatchFound();
                        }
                        return;
                    }
                    SearchToolArea.this.fireMatchFound(match[0], match[1]);
                }
                catch (SQLException e) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    SearchToolArea.this.fireSearchError(e);
                }
                finally {
                    SearchToolArea.this.fireSearchEnded();
                    SearchToolArea.this.m_searchInProgress = false;
                    SearchToolArea.this.notifySearchComplete();
                }
            }
        }.start();
    }

    protected void onStopSearch() {
        this.m_stopSearch = true;
        this.waitOnSearch();
    }

    protected void close() {
        this.moveDataToStore();
        this.setVisible(false);
    }

    protected void onSearchAllCharColumnsSelection() {
        ArrayList<WsAbstractTableColumn> colList = new ArrayList<WsAbstractTableColumn>();
        ViewDataModel model = this.getModel();
        int colCount = model.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if (!"C".equals(model.getColumnSASType(i))) continue;
            colList.add(model.getColumn(i));
        }
        int[] searchColumns = this.convertColumnListToIndices(colList);
        if (searchColumns.length == 0) {
            int option = MessageUtil.displayMessage((String)bundle.getString("SearchToolArea.NoCharColumns.txt"), (int)2, (int)0);
            if (option == 1) {
                return;
            }
            this.onSelectColumnsSelection();
            return;
        }
        this.setSearchColumns(searchColumns);
    }

    protected void onSearchAllNumericColumnsSelection() {
        ArrayList<WsAbstractTableColumn> colList = new ArrayList<WsAbstractTableColumn>();
        ViewDataModel model = this.getModel();
        int colCount = model.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            if ("C".equals(model.getColumnSASType(i))) continue;
            colList.add(model.getColumn(i));
        }
        int[] searchColumns = this.convertColumnListToIndices(colList);
        if (searchColumns.length == 0) {
            int option = MessageUtil.displayMessage((String)bundle.getString("SearchToolArea.NoNumericColumns.txt"), (int)2, (int)0);
            if (option == 1) {
                return;
            }
            this.onSelectColumnsSelection();
            return;
        }
        this.setSearchColumns(searchColumns);
    }

    protected void onSearchAllColumnsSelection() {
        int[] colList = new int[this.getModel().getColumnCount()];
        for (int i = 0; i < colList.length; ++i) {
            colList[i] = i;
        }
        if (colList.length != 0) {
            this.setSearchColumns(colList);
        }
    }

    protected void onSelectColumnsSelection() {
        ColumnSelectionPanel mainPanel = new ColumnSelectionPanel();
        mainPanel.initialize();
        mainPanel.layoutWidgets();
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("SearchToolArea.ColumnSelectionDialogTitle.fmt.txt", (Object)this.getModel().getTableDisplayName()), true, (WAPanel)mainPanel){

            protected void initialize() {
                super.initialize();
            }
        };
        dialog.setResizable(true);
        dialog.setHelpButtonVisible(false);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            this.setSearchColumns(mainPanel.getSelectedColumns());
        }
    }

    protected void clearSearchColumnList() {
        this.onSearchAllColumnsSelection();
    }

    protected void onColumnListComboValueChanged() {
        boolean doCorrect;
        List columnList = this.parseColumnList(this.m_cmbColumns.getText());
        ArrayList<String> columns = new ArrayList<String>();
        ViewDataModel model = this.getModel();
        int colCount = model.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            columns.add(model.getColumnName(i).toUpperCase());
        }
        ArrayList<WsAbstractTableColumn> validColumns = new ArrayList<WsAbstractTableColumn>();
        ArrayList invalidColumns = new ArrayList();
        for (int i = 0; i < columnList.size(); ++i) {
            int index = columns.indexOf(((String)columnList.get(i)).toUpperCase());
            if (index != -1) {
                validColumns.add(model.getColumn(index));
                continue;
            }
            invalidColumns.add(columnList.get(i));
        }
        int[] searchColumns = this.convertColumnListToIndices(validColumns);
        this.setSearchColumns(searchColumns);
        if (invalidColumns.size() != 0 && (doCorrect = this.doCorrectInvalidColumns(invalidColumns))) {
            this.onSelectColumnsSelection();
        }
    }

    protected boolean doCorrectInvalidColumns(List invalidColumnNames) {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        boolean ignore = file.getPropertyBoolean("ViewData.IgnoreInvalidColumnNames", false);
        if (!ignore) {
            IgnoreInvalidColumnNamesCheckBoxOptionPane pane = new IgnoreInvalidColumnNamesCheckBoxOptionPane(invalidColumnNames);
            JDialog dialog = pane.createDialog((Component)Workspace.getWorkspace(), bundle.getString("SearchToolArea.InvalidColumnNameTitle.txt"));
            dialog.setVisible(true);
            file.setPropertyBoolean("ViewData.IgnoreInvalidColumnNames", pane.getRememberDecision());
            Object value = pane.getValue();
            if (value != null && (Integer)value == 0) {
                return true;
            }
        }
        return false;
    }

    protected void updateColumnListCombo() {
        this.m_columnListAdjusting = true;
        try {
            String columnList = "";
            for (int i = 0; i < this.m_searchColumns.length; ++i) {
                columnList = columnList + this.getModel().getColumnName(this.m_searchColumns[i]);
                if (i == this.m_searchColumns.length - 1) continue;
                columnList = columnList + "; ";
            }
            this.m_cmbColumns.setSelectedItem((Object)columnList);
        }
        finally {
            this.m_columnListAdjusting = false;
        }
    }

    protected void onExactMatchSelection() {
        this.setMatchType(SearchComparable.MatchType.MATCH_EXACT);
    }

    protected void onContainsMatchSelection() {
        this.setMatchType(SearchComparable.MatchType.MATCH_CONTAINS);
    }

    protected void onBeginsWithMatchSelection() {
        this.setMatchType(SearchComparable.MatchType.MATCH_BEGINS);
    }

    protected void onMatchCaseMatchSelection() {
        this.setMatchCase(!this.m_matchCase);
    }

    protected void onTrimLeadingSpacesSelection() {
        this.setTrimLeadingSpaces(!this.m_trimLeadingSpaces);
    }

    protected void onTrimTrailingSpacesSelection() {
        this.setTrimTrailingSpaces(!this.m_trimTrailingSpaces);
    }

    protected ViewDataModel getModel() {
        return this.m_table.getViewDataModel();
    }

    protected void setSearchColumns(int[] searchColumns) {
        if (searchColumns == null || searchColumns.length == 0) {
            this.onSearchAllColumnsSelection();
            return;
        }
        int[] old = this.m_searchColumns;
        this.m_searchColumns = searchColumns;
        this.firePropertyChange(PROPERTY_SEARCH_COLUMN_LIST, old, this.m_searchColumns);
    }

    protected void setMatchType(SearchComparable.MatchType matchType) {
        SearchComparable.MatchType old = this.m_matchType;
        this.m_matchType = matchType;
        this.firePropertyChange(PROPERTY_MATCH_TYPE, old, this.m_matchType);
    }

    protected SearchComparable.MatchType getMatchType() {
        return this.m_matchType;
    }

    protected void setMatchCase(boolean matchCase) {
        boolean old = this.m_matchCase;
        this.m_matchCase = matchCase;
        this.firePropertyChange(PROPERTY_MATCH_CASE, old, this.m_matchCase);
    }

    protected boolean getMatchCase() {
        return this.m_matchCase;
    }

    protected void setTrimLeadingSpaces(boolean trimLeadingSpaces) {
        boolean old = this.m_trimLeadingSpaces;
        this.m_trimLeadingSpaces = trimLeadingSpaces;
        this.firePropertyChange(PROPERTY_TRIM_LEADING_SPACES, old, this.m_trimLeadingSpaces);
    }

    protected boolean getTrimLeadingSpaces() {
        return this.m_trimLeadingSpaces;
    }

    protected void setTrimTrailingSpaces(boolean trimTrailingSpaces) {
        boolean old = this.m_trimTrailingSpaces;
        this.m_trimTrailingSpaces = trimTrailingSpaces;
        this.firePropertyChange(PROPERTY_TRIM_TRAILING_SPACES, old, this.m_trimTrailingSpaces);
    }

    protected boolean getTrimTrailingSpaces() {
        return this.m_trimTrailingSpaces;
    }

    protected SearchComparable getSearchComparable() {
        return new SearchComparable(this.m_cmbSearchText.getText(), this.getMatchType(), this.getMatchCase(), this.getTrimLeadingSpaces(), this.getTrimTrailingSpaces());
    }

    protected int[] getSearchableColumnsInViewOrder() {
        int i;
        this.verifyColumnsSelectedForSearch();
        int[] searchColumns = new int[this.m_searchColumns.length];
        System.arraycopy(this.m_searchColumns, 0, searchColumns, 0, this.m_searchColumns.length);
        for (int i2 = 0; i2 < searchColumns.length; ++i2) {
            for (int j = i2 + 1; j < searchColumns.length; ++j) {
                int jIndex;
                int iIndex = this.m_table.convertColumnIndexToView(searchColumns[i2]);
                if (iIndex <= (jIndex = this.m_table.convertColumnIndexToView(searchColumns[j]))) continue;
                int temp = searchColumns[i2];
                searchColumns[i2] = searchColumns[j];
                searchColumns[j] = temp;
            }
        }
        ArrayList<Integer> visibleColumns = new ArrayList<Integer>();
        for (i = 0; i < searchColumns.length; ++i) {
            if (this.m_table.isColumnHidden(searchColumns[i])) continue;
            visibleColumns.add(new Integer(searchColumns[i]));
        }
        searchColumns = new int[visibleColumns.size()];
        for (i = 0; i < searchColumns.length; ++i) {
            searchColumns[i] = (Integer)visibleColumns.get(i);
        }
        return searchColumns;
    }

    protected void verifyColumnsSelectedForSearch() {
        if (this.m_searchColumns == null || this.m_searchColumns.length == 0) {
            this.onSearchAllColumnsSelection();
        }
    }

    public boolean isSearchInProgress() {
        return this.m_searchInProgress;
    }

    private int[] convertColumnListToIndices(List list) {
        int[] columnIndices = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            columnIndices[i] = ((WsAbstractTableColumn)list.get(i)).getModelIndex();
        }
        return columnIndices;
    }

    protected List parseColumnList(String columnList) {
        String DELIMITERS = " ;,\"";
        String DOUBLE_QUOTE = "\"";
        String delim = " ;,\"";
        ArrayList<String> result = new ArrayList<String>();
        boolean returnTokens = true;
        StringTokenizer parser = new StringTokenizer(columnList, delim, returnTokens);
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken(delim);
            if (!token.equals("\"")) {
                if (!(delim.indexOf(token) == -1 & token != null) || token.trim().equals("")) continue;
                result.add(token.trim());
                continue;
            }
            delim = delim.equals(" ;,\"") ? "\"" : " ;,\"";
        }
        return result;
    }

    protected void loadSearchStringsFromAppDefaultsFile() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        int maxSearchStrings = file.getPropertyInt("ViewData.RecentSearches", 10);
        this.m_cmbSearchText.loadItems(SEARCH_STRINGS_KEY, maxSearchStrings);
        this.m_cmbSearchText.setSelectedIndex(this.m_cmbSearchText.hasItems() ? 0 : -1);
        SearchComparable.MatchType type = SearchComparable.MatchType.MATCH_CONTAINS;
        int matchType = file.getPropertyInt("ViewData.SearchMatchType", 2);
        if (matchType == 1) {
            type = SearchComparable.MatchType.MATCH_EXACT;
        } else if (matchType == 3) {
            type = SearchComparable.MatchType.MATCH_BEGINS;
        }
        this.setMatchType(type);
        this.setMatchCase(file.getPropertyBoolean("ViewData.SearchMatchCase", false));
        this.setTrimLeadingSpaces(file.getPropertyBoolean("ViewData.TrimLeadingSpaces", false));
        this.setTrimTrailingSpaces(file.getPropertyBoolean("ViewData.TrimTrailingSpaces", true));
    }

    protected void saveSearchStringToAppDefaultsFile() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        int maxSearchStrings = file.getPropertyInt("ViewData.RecentSearches", 10);
        String text = this.m_cmbSearchText.getText();
        this.m_cmbSearchText.saveItems(SEARCH_STRINGS_KEY, maxSearchStrings);
        this.m_cmbSearchText.removeAllItems();
        this.m_cmbSearchText.loadItems(SEARCH_STRINGS_KEY, maxSearchStrings);
        this.m_cmbSearchText.setSelectedItem((Object)text);
        SearchComparable.MatchType type = this.getMatchType();
        int matchType = 2;
        if (type == SearchComparable.MatchType.MATCH_EXACT) {
            matchType = 1;
        } else if (type == SearchComparable.MatchType.MATCH_BEGINS) {
            matchType = 3;
        }
        file.setPropertyInt("ViewData.SearchMatchType", matchType);
        file.setPropertyBoolean("ViewData.SearchMatchCase", this.getMatchCase());
        file.setPropertyBoolean("ViewData.TrimLeadingSpaces", this.getTrimLeadingSpaces());
        file.setPropertyBoolean("ViewData.TrimTrailingSpaces", this.getTrimTrailingSpaces());
        this.m_cmbSearchText.requestFocus();
    }

    protected void addColumnsListToColumnsCombo() {
        if (this.m_cmbColumns.getSelectedItem() == null || this.m_cmbColumns.getSelectedItem().toString().trim().length() == 0) {
            return;
        }
        if (this.m_cmbColumns.getSelectedIndex() == -1) {
            this.m_cmbColumns.addItem(this.m_cmbColumns.getSelectedItem());
        }
    }

    public void addSearchEventListener(SearchEventListener listener) {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            this.m_searchEventListeners = new ArrayList();
        }
        this.m_searchEventListeners.add(listener);
    }

    public void removeSearchEventListener(SearchEventListener listener) {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        this.m_searchEventListeners.remove(listener);
    }

    public void fireSearchStarting() {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.searchStarting();
        }
    }

    public void fireSearchEnded() {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.searchEnded();
        }
    }

    public void fireMatchFound(int row, int col) {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.matchFound(row, col);
        }
    }

    public void fireNoMatchFound() {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        String searchStr = this.m_cmbSearchText.getText();
        if (this.getTrimLeadingSpaces()) {
            searchStr = ViewDataUtil.trimLeft(searchStr);
        }
        if (this.getTrimTrailingSpaces()) {
            searchStr = ViewDataUtil.trimRight(searchStr);
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.noMatchFound(searchStr);
        }
    }

    public void fireSearchError(Exception e) {
        this.fireSearchError(new ViewDataException(e));
    }

    public void fireSearchError(ViewDataException e) {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.searchError(e);
        }
    }

    public void fireSearchCancelled() {
        if (this.m_searchEventListeners == null || this.m_searchEventListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_searchEventListeners.size(); ++i) {
            SearchEventListener listener = (SearchEventListener)this.m_searchEventListeners.get(i);
            listener.searchCancelled(this.m_cmbSearchText.getText());
        }
    }

    public void waitOnSearch() {
        this.waitOnSearch(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnSearch(long timeout) {
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            if (!this.isSearchInProgress()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            try {
                this.mutex.wait(timeout);
            }
            catch (InterruptedException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySearchComplete() {
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            this.mutex.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    class SearchThread
    extends Thread {
        SearchThread() {
        }

        @Override
        public void run() {
            SearchToolArea.this.fireSearchStarting();
            SearchToolArea.this.handleSearch(SearchToolArea.this.m_currentSearchDirection);
            SearchToolArea.this.fireSearchEnded();
        }
    }

    class SearchFlatButton
    extends JButton {
        private Insets NO_MARGIN;
        private Insets XP_MARGIN;

        public SearchFlatButton() {
            this.NO_MARGIN = new Insets(0, 0, 0, 0);
            this.XP_MARGIN = new Insets(2, 2, 2, 2);
            this.initialize();
        }

        public SearchFlatButton(Action act) {
            super(act);
            this.NO_MARGIN = new Insets(0, 0, 0, 0);
            this.XP_MARGIN = new Insets(2, 2, 2, 2);
            this.initialize();
        }

        public SearchFlatButton(String sText) {
            super(sText);
            this.NO_MARGIN = new Insets(0, 0, 0, 0);
            this.XP_MARGIN = new Insets(2, 2, 2, 2);
            this.initialize();
        }

        public SearchFlatButton(Icon icon) {
            super(icon);
            this.NO_MARGIN = new Insets(0, 0, 0, 0);
            this.XP_MARGIN = new Insets(2, 2, 2, 2);
            this.initialize();
        }

        public SearchFlatButton(String sText, Icon icon) {
            super(sText, icon);
            this.NO_MARGIN = new Insets(0, 0, 0, 0);
            this.XP_MARGIN = new Insets(2, 2, 2, 2);
            this.initialize();
        }

        protected void initialize() {
            if (WsUIUtilities.isXPThemeActive()) {
                this.setMargin(this.XP_MARGIN);
                return;
            }
            this.setMargin(this.NO_MARGIN);
            this.setFocusPainted(false);
            this.setBorder(new cBevelBorder(2));
            this.setRolloverEnabled(true);
            this.addChangeListener(new cChangeListener());
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.getModel().setRollover(false);
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        protected class cChangeListener
        implements ChangeListener {
            protected cChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                cBevelBorder border;
                Color clrBackground = SystemColor.control;
                ButtonModel mdl = SearchFlatButton.this.getModel();
                if (mdl.isSelected()) {
                    border = new cBevelBorder(1);
                    if (!mdl.isPressed() && !mdl.isRollover()) {
                        float[] rgbDark = new float[3];
                        float[] rgbLight = new float[3];
                        SystemColor.control.getColorComponents(rgbDark);
                        SystemColor.controlLtHighlight.getColorComponents(rgbLight);
                        clrBackground = new Color((rgbDark[0] + rgbLight[0]) / 2.0f, (rgbDark[1] + rgbLight[1]) / 2.0f, (rgbDark[2] + rgbLight[2]) / 2.0f);
                    }
                } else {
                    border = mdl.isPressed() && mdl.isRollover() ? new cBevelBorder(1) : (mdl.isPressed() || mdl.isRollover() ? new cBevelBorder(0) : new cBevelBorder(2));
                }
                SearchFlatButton.this.setBorder(border);
                SearchFlatButton.this.setBackground(clrBackground);
            }
        }

        protected class cBevelBorder
        extends AbstractBorder {
            public static final int RAISED = 0;
            public static final int LOWERED = 1;
            public static final int FLAT = 2;
            private int m_eBevelType;
            private Color m_clrHighlight;
            private Color m_clrShadow;

            public cBevelBorder(int eBevelType) {
                this.m_eBevelType = eBevelType;
                switch (this.m_eBevelType) {
                    case 0: {
                        this.m_clrHighlight = SystemColor.controlLtHighlight;
                        this.m_clrShadow = SystemColor.controlShadow;
                        break;
                    }
                    case 1: {
                        this.m_clrHighlight = SystemColor.controlShadow;
                        this.m_clrShadow = SystemColor.controlLtHighlight;
                    }
                }
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color clrOld = g.getColor();
                Color clrBack = c.getBackground();
                if (this.m_eBevelType == 2) {
                    this.m_clrHighlight = clrBack;
                    this.m_clrShadow = clrBack;
                }
                int h = height;
                int w = width;
                g.translate(x, y);
                g.setColor(this.m_clrHighlight);
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(1, 0, w - 1, 0);
                g.setColor(this.m_clrShadow);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(w - 1, 1, w - 1, h - 2);
                g.setColor(clrBack);
                g.drawRect(1, 1, w - 3, h - 3);
                g.translate(-x, -y);
                g.setColor(clrOld);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(2, 3, 3, 3);
            }

            public int getBevelType() {
                return this.m_eBevelType;
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        }
    }

    class PopupMenuButton
    extends SearchFlatButton {
        static final int ALIGN_LEFT = 1;
        static final int ALIGN_RIGHT = 2;
        private JPopupMenu m_popup;
        private int m_alignment;

        PopupMenuButton(String label) {
            PopupAction action = new PopupAction();
            action.putValue("Name", label);
            this.setAction((Action)((Object)action));
            this.setHorizontalTextPosition(2);
            this.setName(label);
            this.initialize();
        }

        PopupMenuButton(String label, JPopupMenu popup) {
            this(label);
            this.setPopupMenu(popup);
        }

        PopupMenuButton(String label, JPopupMenu popup, int alignment) {
            this(label);
            this.setPopupMenu(popup);
            this.setAlignment(alignment);
        }

        public void setPopupMenu(JPopupMenu popup) {
            this.m_popup = popup;
        }

        public void setAlignment(int alignment) {
            this.m_alignment = alignment;
        }

        protected void showPopupMenu() {
            if (this.m_popup == null) {
                return;
            }
            double left = 0.0;
            double top = this.getY() + this.getHeight();
            if (this.m_alignment == 2) {
                left = (double)this.getWidth() - this.m_popup.getPreferredSize().getWidth();
            }
            this.m_popup.show(this, (int)left, (int)top);
        }

        class PopupAction
        extends WsAbstractAction {
            PopupAction() {
                super(bundle, "SearchToolArea.PopupMenuSouthButton", 274);
            }

            public void actionPerformed(ActionEvent e) {
                PopupMenuButton.this.showPopupMenu();
            }
        }
    }

    class SearchButtonPanel
    extends JToolBar {
        private JButton m_btnSearchNext;
        private JButton m_btnSearchPrevious;
        private JButton m_btnStop;

        SearchButtonPanel() {
            this.setFloatable(false);
            this.setRollover(true);
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.m_btnSearchNext = WsUIUtilities.createFlatToolButton((WsAbstractAction)new NextAction());
            this.m_btnSearchPrevious = WsUIUtilities.createFlatToolButton((WsAbstractAction)new PreviousAction());
            this.m_btnStop = WsUIUtilities.createFlatToolButton((WsAbstractAction)new StopSearchAction());
            this.m_btnSearchNext.setVisible(true);
            this.m_btnSearchPrevious.setVisible(true);
            this.m_btnStop.setVisible(false);
            SearchToolArea.this.addSearchEventListener(new SearchButtonPanelSearchListener());
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_btnSearchNext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_btnStop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_btnSearchPrevious, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.m_btnSearchNext.setEnabled(enabled);
            this.m_btnSearchPrevious.setEnabled(enabled);
            this.m_btnStop.setEnabled(SearchToolArea.this.m_searchInProgress);
        }

        class SearchButtonPanelSearchListener
        extends SearchEventAdapter {
            SearchButtonPanelSearchListener() {
            }

            @Override
            public void searchStarting() {
                SearchButtonPanel.this.m_btnSearchNext.setVisible(false);
                SearchButtonPanel.this.m_btnSearchPrevious.setVisible(false);
                SearchButtonPanel.this.m_btnStop.setVisible(true);
                SearchButtonPanel.this.m_btnStop.setEnabled(true);
            }

            @Override
            public void searchEnded() {
                SearchButtonPanel.this.m_btnSearchNext.setVisible(true);
                SearchButtonPanel.this.m_btnSearchPrevious.setVisible(true);
                SearchButtonPanel.this.m_btnStop.setVisible(false);
            }
        }
    }

    class IgnoreInvalidColumnNamesCheckBoxOptionPane
    extends JOptionPane {
        private List m_invalidColumnNames;
        private JCheckBox m_rememberDecision;

        public IgnoreInvalidColumnNamesCheckBoxOptionPane(List invalidColumnNames) {
            this.setMessageType(2);
            this.setOptionType(0);
            this.m_invalidColumnNames = invalidColumnNames;
            this.initialize();
        }

        protected void initialize() {
            JScrollPane scroll = new JScrollPane(new JList<Object>(this.m_invalidColumnNames.toArray()));
            this.m_rememberDecision = new JCheckBox(bundle.getString("SearchToolArea.AlwaysIgnoreInvalidColumnNames.txt"));
            this.setMessage(new Object[]{bundle.getString("SearchToolArea.InvalidColumnName1.txt"), scroll, this.m_rememberDecision, bundle.getString("SearchToolArea.InvalidColumnName2.txt")});
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        protected boolean getRememberDecision() {
            return this.m_rememberDecision.isSelected();
        }
    }

    class ColumnSelectionPanel
    extends WAPropertyTab {
        private WsCheckBoxScrollPane m_scrollColumns;
        private TriStateCheckBox m_masterCheckBox;
        private ColumnCheckBoxListener m_checkBoxListener;
        private boolean m_adjustingColumnCheckBoxesState;

        ColumnSelectionPanel() {
        }

        protected void initialize() {
            ViewDataModel model = SearchToolArea.this.getModel();
            this.m_masterCheckBox = new TriStateCheckBox();
            this.m_masterCheckBox.setCycleEnabled(false);
            this.m_masterCheckBox.setAction((Action)((Object)new SelectAllAction()));
            this.m_checkBoxListener = new ColumnCheckBoxListener();
            this.m_scrollColumns = new WsCheckBoxScrollPane();
            this.m_scrollColumns.setPreferredSize(new Dimension(400, this.m_scrollColumns.getPreferredSize().height));
            for (int i = 0; i < model.getColumnCount(); ++i) {
                boolean selected = false;
                if (SearchToolArea.this.m_searchColumns != null) {
                    for (int j = 0; j < SearchToolArea.this.m_searchColumns.length; ++j) {
                        if (SearchToolArea.this.m_searchColumns[j] != i) continue;
                        selected = true;
                        break;
                    }
                }
                ColumnCheckBox checkBox = new ColumnCheckBox(i);
                checkBox.setSelected(selected);
                checkBox.addItemListener(this.m_checkBoxListener);
                this.m_scrollColumns.addElement((JCheckBox)checkBox);
            }
            this.m_scrollColumns.redisplay();
            this.updateMasterStateFromCheckBox();
        }

        protected void layoutWidgets() {
            JLabel lblColumns = new JLabel(bundle.getString("SearchToolArea.ColumnsLabel.txt"));
            lblColumns.setLabelFor((Component)this.m_scrollColumns);
            lblColumns.setDisplayedMnemonic(bundle.getString("SearchToolArea.ColumnsLabel.mnem").charAt(0));
            this.m_masterCheckBox.setFont(this.m_masterCheckBox.getFont().deriveFont(1));
            JPanel allColumnsPanel = new JPanel();
            allColumnsPanel.setBorder(new BevelBorder(1));
            allColumnsPanel.setLayout(new GridBagLayout());
            allColumnsPanel.add((Component)this.m_masterCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(allColumnsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.m_scrollColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        protected int[] getSelectedColumns() {
            ArrayList<JCheckBox> selectedList = new ArrayList<JCheckBox>();
            int size = this.m_scrollColumns.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!this.m_scrollColumns.getCheckBox(i).isSelected()) continue;
                selectedList.add(this.m_scrollColumns.getCheckBox(i));
            }
            int[] selected = new int[selectedList.size()];
            for (int i = 0; i < selected.length; ++i) {
                selected[i] = ((ColumnCheckBox)selectedList.get(i)).getColumnIndex();
            }
            return selected;
        }

        protected void updateMasterStateFromCheckBox() {
            int size = this.m_scrollColumns.getModel().getSize();
            boolean hasSelected = false;
            boolean hasUnselected = false;
            for (int i = 0; i < size; ++i) {
                if (this.m_scrollColumns.getCheckBox(i).isSelected()) {
                    hasSelected = true;
                } else {
                    hasUnselected = true;
                }
                if (!hasSelected || !hasUnselected) continue;
                this.m_masterCheckBox.setSelectedValue(1);
                this.m_masterCheckBox.repaint();
                return;
            }
            if (hasSelected) {
                this.m_masterCheckBox.setSelectedValue(2);
            } else {
                this.m_masterCheckBox.setSelectedValue(0);
            }
            this.m_masterCheckBox.repaint();
        }

        protected void updateCheckBoxStateFromMaster() {
            this.m_adjustingColumnCheckBoxesState = true;
            try {
                this.m_scrollColumns.setStatusAll(this.m_masterCheckBox.isSelected());
            }
            finally {
                this.m_adjustingColumnCheckBoxesState = false;
            }
        }

        private class SelectAllAction
        extends WsAbstractAction {
            SelectAllAction() {
                super(bundle, "SearchToolArea.SelectAllColumns", 0);
            }

            public void actionPerformed(ActionEvent e) {
                ColumnSelectionPanel.this.updateCheckBoxStateFromMaster();
            }
        }

        private class ColumnCheckBoxListener
        implements ItemListener {
            private ColumnCheckBoxListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ColumnSelectionPanel.this.m_adjustingColumnCheckBoxesState) {
                    return;
                }
                ColumnSelectionPanel.this.updateMasterStateFromCheckBox();
            }
        }

        private class ColumnCheckBox
        extends JCheckBox {
            private int m_columnIndex;

            ColumnCheckBox(int columnIndex) {
                this.m_columnIndex = columnIndex;
                this.setSelected(true);
                this.setText(SearchToolArea.this.getModel().getColumnName(this.m_columnIndex));
            }

            int getColumnIndex() {
                return this.m_columnIndex;
            }
        }
    }

    class ColumnListChangedListener
    implements PropertyChangeListener {
        ColumnListChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!SearchToolArea.PROPERTY_SEARCH_COLUMN_LIST.equals(evt.getPropertyName())) {
                return;
            }
            SearchToolArea.this.updateColumnListCombo();
        }
    }

    class InColumnsComboItemListener
    implements ItemListener {
        InColumnsComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (SearchToolArea.this.m_columnListAdjusting || e.getStateChange() != 1) {
                return;
            }
            SearchToolArea.this.onColumnListComboValueChanged();
        }
    }

    class TrimTrailingSpacesAction
    extends WsAbstractToggleAction {
        public TrimTrailingSpacesAction() {
            super(bundle, "SearchToolArea.TrimTrailingSpaces", 256);
            this.setSelected(SearchToolArea.this.getTrimTrailingSpaces());
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_TRIM_TRAILING_SPACES.equals(evt.getPropertyName())) {
                        TrimTrailingSpacesAction.this.setSelected((Boolean)evt.getNewValue());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onTrimTrailingSpacesSelection();
        }
    }

    class TrimLeadingSpacesAction
    extends WsAbstractToggleAction {
        public TrimLeadingSpacesAction() {
            super(bundle, "SearchToolArea.TrimLeadingSpaces", 256);
            this.setSelected(SearchToolArea.this.getTrimLeadingSpaces());
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_TRIM_LEADING_SPACES.equals(evt.getPropertyName())) {
                        TrimLeadingSpacesAction.this.setSelected((Boolean)evt.getNewValue());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onTrimLeadingSpacesSelection();
        }
    }

    class MatchCaseMatchAction
    extends WsAbstractToggleAction {
        public MatchCaseMatchAction() {
            super(bundle, "SearchToolArea.MatchCase", 256);
            this.setSelected(SearchToolArea.this.getMatchCase());
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_MATCH_CASE.equals(evt.getPropertyName())) {
                        MatchCaseMatchAction.this.setSelected((Boolean)evt.getNewValue());
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onMatchCaseMatchSelection();
        }
    }

    class BeginsWithMatchAction
    extends WsAbstractToggleAction {
        public BeginsWithMatchAction() {
            super(bundle, "SearchToolArea.BeginsWithMatch", 256);
            this.setSelected(SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_BEGINS);
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_MATCH_TYPE.equals(evt.getPropertyName())) {
                        BeginsWithMatchAction.this.setSelected(evt.getNewValue() == SearchComparable.MatchType.MATCH_BEGINS);
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onBeginsWithMatchSelection();
        }
    }

    class ContainsMatchAction
    extends WsAbstractToggleAction {
        public ContainsMatchAction() {
            super(bundle, "SearchToolArea.ContainsMatch", 256);
            this.setSelected(SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_CONTAINS);
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_MATCH_TYPE.equals(evt.getPropertyName())) {
                        ContainsMatchAction.this.setSelected(evt.getNewValue() == SearchComparable.MatchType.MATCH_CONTAINS);
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onContainsMatchSelection();
        }
    }

    class ExactMatchAction
    extends WsAbstractToggleAction {
        public ExactMatchAction() {
            super(bundle, "SearchToolArea.ExactMatch", 256);
            this.setSelected(SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_EXACT);
            SearchToolArea.this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (SearchToolArea.PROPERTY_MATCH_TYPE.equals(evt.getPropertyName())) {
                        ExactMatchAction.this.setSelected(evt.getNewValue() == SearchComparable.MatchType.MATCH_EXACT);
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onExactMatchSelection();
        }
    }

    class SelectColumnsAction
    extends WsAbstractAction {
        public SelectColumnsAction() {
            super(bundle, "SearchToolArea.SelectCols", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onSelectColumnsSelection();
        }
    }

    class SearchAllColumnsAction
    extends WsAbstractAction {
        public SearchAllColumnsAction() {
            super(bundle, "SearchToolArea.AllCols", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onSearchAllColumnsSelection();
        }
    }

    class SearchAllNumericColumnsAction
    extends WsAbstractAction {
        public SearchAllNumericColumnsAction() {
            super(bundle, "SearchToolArea.AllNumericCols", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onSearchAllNumericColumnsSelection();
        }
    }

    class SearchAllCharColumnsAction
    extends WsAbstractAction {
        public SearchAllCharColumnsAction() {
            super(bundle, "SearchToolArea.AllCharColumns", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onSearchAllCharColumnsSelection();
        }
    }

    class CloseAction
    extends WsAbstractAction {
        CloseAction() {
            super(bundle, "SearchToolArea.CloseAction", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Close"));
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.close();
        }
    }

    class SearchComboEditorAction
    extends WsAbstractAction {
        SearchComboEditorAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SearchToolArea.this.m_currentSearchDirection == 1) {
                SearchToolArea.this.onPrevious();
            } else {
                SearchToolArea.this.onNext();
            }
        }
    }

    class SearchAgainAction
    extends WsAbstractAction {
        SearchAgainAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SearchToolArea.this.m_currentSearchDirection == 2) {
                SearchToolArea.this.onNext();
            } else if (SearchToolArea.this.m_currentSearchDirection == 1) {
                SearchToolArea.this.onPrevious();
            }
        }
    }

    class StopSearchAction
    extends WsAbstractAction {
        StopSearchAction() {
            super(bundle, "SearchToolArea.StopSearchAction", 2);
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            SearchToolArea.this.onStopSearch();
        }
    }

    class PreviousAction
    extends WsAbstractAction {
        PreviousAction() {
            super(bundle, "SearchToolArea.PreviousAction", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:FindPrevious"));
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onPrevious();
        }
    }

    class NextAction
    extends WsAbstractAction {
        NextAction() {
            super(bundle, "SearchToolArea.NextAction", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:FindNext"));
        }

        public void actionPerformed(ActionEvent e) {
            SearchToolArea.this.onNext();
        }
    }

    class OptionsPopupMenu
    extends JPopupMenu {
        OptionsPopupMenu() {
            this.initialize();
        }

        void initialize() {
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem exactMatch = WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)new ExactMatchAction());
            JRadioButtonMenuItem containsMatch = WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)new ContainsMatchAction());
            JRadioButtonMenuItem beginsWithMatch = WsUIUtilities.createRadioButtonMenuItem((WsAbstractToggleAction)new BeginsWithMatchAction());
            JCheckBoxMenuItem matchCase = WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)new MatchCaseMatchAction());
            JCheckBoxMenuItem trimLeadingSpaces = WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)new TrimLeadingSpacesAction());
            JCheckBoxMenuItem trimTrailingSpaces = WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)new TrimTrailingSpacesAction());
            group.add(exactMatch);
            group.add(containsMatch);
            group.add(beginsWithMatch);
            if (SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_EXACT) {
                exactMatch.setSelected(true);
            } else if (SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_CONTAINS) {
                containsMatch.setSelected(true);
            } else if (SearchToolArea.this.getMatchType() == SearchComparable.MatchType.MATCH_BEGINS) {
                beginsWithMatch.setSelected(true);
            }
            this.add(exactMatch);
            this.add(containsMatch);
            this.add(beginsWithMatch);
            this.addSeparator();
            this.add(matchCase);
            this.add(trimLeadingSpaces);
            this.add(trimTrailingSpaces);
        }
    }

    class InColumnsPopupMenu
    extends JPopupMenu {
        InColumnsPopupMenu() {
            this.initialize();
        }

        void initialize() {
            JMenuItem allCharCols = new JMenuItem();
            JMenuItem allNumCols = new JMenuItem();
            JMenuItem allCols = new JMenuItem();
            JMenuItem selectCols = new JMenuItem();
            allCharCols.setAction((Action)((Object)new SearchAllCharColumnsAction()));
            allNumCols.setAction((Action)((Object)new SearchAllNumericColumnsAction()));
            allCols.setAction((Action)((Object)new SearchAllColumnsAction()));
            selectCols.setAction((Action)((Object)new SelectColumnsAction()));
            this.add(allCharCols);
            this.add(allNumCols);
            this.add(allCols);
            this.addSeparator();
            this.add(selectCols);
        }
    }

    class SearchAreaKeyListener
    extends KeyAdapter {
        SearchAreaKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 27) {
                return;
            }
            SearchToolArea.this.close();
        }
    }
}

